/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.taskmanage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.taskmanage.enums.TaskRecordStartModeEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskReocrdStatusEnum;
import kd.fi.bcm.business.taskmanage.helper.TaskPermHelper;
import kd.fi.bcm.business.taskmanage.helper.TaskRecordServiceHelper;
import kd.fi.bcm.business.taskmanage.model.TaskRecordModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.taskmanage.TaskRecordListProvider;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskScheduleHelper;
import org.apache.commons.collections4.CollectionUtils;

public class TaskRecordListPlugin
extends AbstractBaseListPlugin {
    private static final String BTN_NEW = "btn_new";
    private static final String BTN_START = "btn_start";
    private static final String BTN_STOP = "btn_stop";
    private static final String BTN_RESET = "btn_reset";
    private static final String BTN_DELETE = "btn_delete";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BILLLISTAP = "billlistap";
    private static final String MODEL = "model";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.createListDataProviderListener();
        ((BillList)this.getControl(BILLLISTAP)).addHyperClickListener(this::hyperLinkClick);
    }

    private void createListDataProviderListener() {
        ((BillList)this.getControl(BILLLISTAP)).addCreateListDataProviderListener(args -> args.setListDataProvider((IListDataProvider)new TaskRecordListProvider(this.getModelId(), false)));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.createListDataProviderListener();
        this.refreshBillByUserSelect(new ArrayList<String>(), true);
        this.refreshBillList();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_new": {
                this.createNewTaskRecord(itemKey);
                break;
            }
            case "btn_start": {
                this.startTaskRecord();
                break;
            }
            case "btn_stop": {
                this.stopTaskRecord();
                break;
            }
            case "btn_reset": {
                this.resetTaskRecord();
                break;
            }
            case "btn_refresh": {
                this.refreshBillList();
                break;
            }
            case "btn_delete": {
                if (!this.checkSelectRows() || !this.validatePerm(this.getSelectRows())) {
                    return;
                }
                if (!this.validateStatusReverse(Arrays.asList(this.getSelectTaskRecords()), TaskReocrdStatusEnum.SUSPEND)) {
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5220\u9664\u9009\u4e2d\u7684\u5b9e\u4f8b\u5417\uff1f", (String)"TaskRecordListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_DELETE, (IFormPlugin)this));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        this.createListDataProviderListener();
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "btn_delete": {
                if (!MessageBoxResult.Yes.name().equals(messageBoxClosedEvent.getResultValue())) break;
                this.deleteTaskRecord();
                this.refreshBillList();
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        this.createListDataProviderListener();
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "btn_new": {
                this.refreshBillList();
                break;
            }
            case "btn_start": {
                DynamicObject[] records = this.getSelectTaskRecords();
                if (null != closedCallBackEvent.getReturnData()) {
                    this.modifyTaskRecordEndTime(records, (Map)closedCallBackEvent.getReturnData());
                }
                this.modifyTaskRecordStatus(TaskReocrdStatusEnum.RUNNING, records);
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String keyName;
        super.propertyChanged(e);
        switch (keyName = e.getProperty().getName()) {
            case "model": {
                this.refreshBillList();
                break;
            }
        }
    }

    private void refreshBillList() {
        Long modelId = 0L;
        if (null != this.getValue(MODEL)) {
            modelId = this.getModelId();
        }
        this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.clearSelection();
        FilterParameter fp = new FilterParameter();
        fp.getQFilters().add(new QFilter(MODEL, "=", (Object)modelId));
        if (LongUtil.isvalidLong((Object)modelId)) {
            fp.getQFilters().add(new QFilter("id", "not in", (Object)TaskPermHelper.getPerm((Long)modelId, (String)"bcm_taskrecord", (DataTypeEnum[])new DataTypeEnum[]{DataTypeEnum.NO})));
        }
        billList.setQueryFilterParameter(fp);
        billList.refresh();
    }

    private void createNewTaskRecord(String actionId) {
        if (!this.validateModel()) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.setFormId("bcm_createtaskrecord_new");
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u521b\u5efa\u4efb\u52a1\u5411\u5bfc", (String)"TaskRecordListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShowParameter);
    }

    private boolean checkSelectRows() {
        return this.checkSelectRows(false);
    }

    private boolean checkSelectRows(boolean single) {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"TaskRecordListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (single && selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"TaskRecordListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Set<Long> getSelectRows() {
        HashSet<Long> selectIds = new HashSet<Long>();
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        for (ListSelectedRow row : selectedRows) {
            selectIds.add((Long)row.getPrimaryKeyValue());
        }
        return selectIds;
    }

    private void startTaskRecord() {
        if (!this.checkSelectRows() || !this.validatePerm(this.getSelectRows())) {
            return;
        }
        DynamicObject[] records = this.getSelectTaskRecords();
        DynamicObject dyn = Arrays.asList(records).stream().filter(e -> Objects.equals(TaskReocrdStatusEnum.RUNNING.getValue(), e.getString("status")) || Objects.equals(TaskReocrdStatusEnum.COMPLETE.getValue(), e.getString("status"))).findFirst().orElseGet(() -> null);
        if (null != dyn) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5b9e\u4f8b\u4e2d\u5b58\u5728\u5df2\u5f00\u59cb\u7684\u5b9e\u4f8b\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaskRecordListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List<DynamicObject> needModifyEndTimes = this.needModifyEndTime(Arrays.asList(records));
        if (CollectionUtils.isNotEmpty(needModifyEndTimes)) {
            this.openEndTimePage(needModifyEndTimes);
        } else {
            this.modifyTaskRecordStatus(TaskReocrdStatusEnum.RUNNING, records);
        }
    }

    private void getTaskRecordDetail(Long taskRecordId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setFormId("bcm_viewtaskrecord");
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        formShowParameter.setCustomParam("taskRecordId", (Object)taskRecordId);
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u8be6\u60c5", (String)"TaskRecordListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShowParameter);
    }

    private void stopTaskRecord() {
        if (!this.checkSelectRows() || !this.validatePerm(this.getSelectRows())) {
            return;
        }
        DynamicObject[] records = this.getSelectTaskRecords();
        if (!this.validateStatus(Arrays.asList(records), TaskReocrdStatusEnum.SUSPEND)) {
            return;
        }
        this.modifyTaskRecordStatus(TaskReocrdStatusEnum.SUSPEND, records);
    }

    private void resetTaskRecord() {
        if (!this.checkSelectRows() || !this.validatePerm(this.getSelectRows())) {
            return;
        }
        DynamicObject[] records = this.getSelectTaskRecords();
        if (!this.validateStatusReverse(Arrays.asList(records), TaskReocrdStatusEnum.SUSPEND)) {
            return;
        }
        TaskRecordServiceHelper.resetTaskRecord(this.getSelectRows());
        this.refreshBillList();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"TaskRecordListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void deleteTaskRecord() {
        Set scheduleIds = TaskRecordServiceHelper.deleteTaskRecord(this.getSelectRows());
        TaskScheduleHelper.deleteSchedule(scheduleIds);
        this.refreshBillList();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"TaskRecordListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void modifyTaskRecordStatus(TaskReocrdStatusEnum statusEnum, DynamicObject[] records) {
        TaskRecordServiceHelper.modifyTaskRecordStatus((TaskReocrdStatusEnum)statusEnum, (DynamicObject[])records);
        this.refreshBillList();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"TaskRecordListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void modifyTaskRecordEndTime(DynamicObject[] records, Map<String, Object> returnData) {
        Date endTime = (Date)returnData.get("endtime");
        List<DynamicObject> needModifyEndTimes = this.needModifyEndTime(Arrays.asList(records));
        ArrayList<String> updateScheduleIds = new ArrayList<String>(needModifyEndTimes.size());
        for (DynamicObject e : needModifyEndTimes) {
            e.set("endtime", (Object)endTime);
            String scheduleId = e.getString("scheduleid");
            if (StringUtils.isNotEmpty((String)scheduleId)) {
                updateScheduleIds.add(scheduleId);
                continue;
            }
            if (null == endTime) continue;
            scheduleId = TaskScheduleHelper.createSchedule(e.getLong("id"), null, endTime);
            e.set("scheduleid", (Object)scheduleId);
            TaskScheduleHelper.addSchedule(scheduleId);
        }
        TaskScheduleHelper.updateTaskRecordEndTime(updateScheduleIds, endTime);
    }

    private DynamicObject[] getSelectTaskRecords() {
        return TaskRecordServiceHelper.loadTaskRecords(this.getSelectRows());
    }

    private boolean validateModel() {
        if (Objects.isNull(this.getValue(MODEL))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4f53\u7cfb\u201d\u3002", (String)"TaskTemplateListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private List<DynamicObject> needModifyEndTime(List<DynamicObject> records) {
        return records.stream().filter(e -> e.getBoolean("isforceclose")).collect(Collectors.toList());
    }

    private boolean validateStatus(List<DynamicObject> records, TaskReocrdStatusEnum statusEnum) {
        DynamicObject dyn = records.stream().filter(e -> Objects.equals(statusEnum.getValue(), e.getString("status"))).findFirst().orElseGet(() -> null);
        if (null != dyn) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5b9e\u4f8b\u4e2d\u5b58\u5728\u201c\u6682\u6302\u201d\u72b6\u6001\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaskRecordListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateStatusReverse(List<DynamicObject> records, TaskReocrdStatusEnum statusEnum) {
        DynamicObject dyn = records.stream().filter(e -> !Objects.equals(statusEnum.getValue(), e.getString("status"))).findFirst().orElseGet(() -> null);
        if (null != dyn) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u7684\u72b6\u6001\u5fc5\u987b\u662f\u201c\u6682\u6302\u201d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaskRecordListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new Object[0]));
            return false;
        }
        return true;
    }

    private void openEndTimePage(List<DynamicObject> needModifyEndTimes) {
        Date endTime = this.getSelectRows().size() == 1 ? needModifyEndTimes.get(0).getDate("endtime") : null;
        endTime = null != endTime && endTime.getTime() > System.currentTimeMillis() ? endTime : null;
        List beginTimeList = needModifyEndTimes.stream().filter(e -> Objects.equals(TaskRecordStartModeEnum.SCHEDULE_PLAN.getValue(), e.getString("startmode")) && null != e.getDate("begintime")).map(e -> Pair.onePair((Object)e.getLong("id"), (Object)e.getDate("begintime"))).collect(Collectors.toList());
        beginTimeList.sort((o1, o2) -> Long.compare(((Date)o2.p2).getTime(), ((Date)o1.p2).getTime()));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_taskrecord_endtime");
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (null != endTime) {
            formShowParameter.setCustomParam("endtime", (Object)endTime);
        }
        if (CollectionUtils.isNotEmpty(beginTimeList)) {
            formShowParameter.setCustomParam("maxBeginTime", ((Pair)beginTimeList.get((int)0)).p2);
            formShowParameter.setCustomParam("taskRecordName", (Object)TaskRecordModel.dynObjToTaskRecordModel((Long)((Long)((Pair)beginTimeList.get((int)0)).p1)).getTaskTemplateModel().getName());
        }
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_START));
        this.getView().showForm(formShowParameter);
    }

    private boolean validatePerm(Set<Long> ids) {
        Set onlyRead = TaskPermHelper.getPerm((Long)this.getModelId(), (String)"bcm_taskrecord", (DataTypeEnum[])new DataTypeEnum[]{DataTypeEnum.READ});
        Long exist = ids.stream().filter(e -> onlyRead.contains(e)).findFirst().orElseGet(() -> null);
        if (null != exist) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5b9e\u4f8b\u4e2d\u5b58\u5728\u7ed1\u5b9a\u4e86\u201c\u53ea\u8bfb\u201d\u6743\u9650\u7c7b\u7684\u5b9e\u4f8b\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaskRecordListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        BillList billList = (BillList)e.getSource();
        Object taskRecordId = billList.getFocusRowPkId();
        this.getTaskRecordDetail((Long)taskRecordId);
    }
}

