/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.taskmanage;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.mvc.list.ListDataProvider;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.taskmanage.enums.TaskReocrdStatusEnum;
import kd.fi.bcm.business.taskmanage.helper.UserTaskHelper;
import kd.fi.bcm.business.taskmanage.model.TaskRecordModel;
import kd.fi.bcm.business.taskmanage.model.TaskRecordModelFilterMemEntry;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskCommonHelper;

public class TaskRecordListProvider
extends ListDataProvider {
    private static final String FILTERMEMBER = "filtermember";
    private static final String PERMCLASS = "permclass";
    private static final String PROGRESS = "progress";
    private static final String PROGRESSBAR = "progressbar";
    private Long modelId;
    private boolean showProgress;
    private List<DynamicSimpleProperty> showProps = Lists.newArrayList((Object[])new DynamicSimpleProperty[]{new DynamicSimpleProperty("filtermember", String.class, (Object)""), new DynamicSimpleProperty("permclass", String.class, (Object)""), new DynamicSimpleProperty("progress", String.class, (Object)""), new DynamicSimpleProperty("progressbar", String.class, (Object)"")});

    public TaskRecordListProvider(Long modelId, boolean showProgress) {
        this.modelId = modelId;
        this.showProgress = showProgress;
    }

    public DynamicObjectCollection getData(int arg0, int arg1) {
        DynamicObjectCollection rows = super.getData(arg0, arg1);
        if (rows.isEmpty()) {
            return rows;
        }
        Set recordIdSet = rows.stream().map(e -> (Long)e.getPkValue()).collect(Collectors.toSet());
        List recordList = TaskRecordModel.dynObjToTaskRecordModel((DynamicObject[])UserTaskHelper.loadTaskRecordList(recordIdSet));
        Map<Long, TaskRecordModel> recordMap = recordList.stream().collect(Collectors.toMap(e -> e.getId(), e -> e));
        Map permClassMap = PermClassEntityHelper.batchGetPermissionClassByEntityAndId((long)this.modelId, (String)"bcm_taskrecord", recordIdSet);
        this.showProps.forEach(e -> rows.getDynamicObjectType().getProperties().add(e));
        for (DynamicObject row : rows) {
            TaskRecordModel recordModel;
            Long recordId = (Long)row.getPkValue();
            if (this.showProgress) {
                Pair process = Pair.onePair((Object)row.getInt("finishnum"), (Object)row.getInt("totalnum"));
                if (!Objects.equals(TaskReocrdStatusEnum.COMPLETE.getValue(), row.getString("status")) && (Integer)process.p2 != 0) {
                    row.set(PROGRESS, (Object)String.format("%s %s/%s", (Integer)process.p1 * 100 / (Integer)process.p2 + "%", process.p1, process.p2));
                    row.set(PROGRESSBAR, (Object)TaskCommonHelper.convertProgress((Pair<Integer, Integer>)process));
                }
            }
            if (null == (recordModel = recordMap.get(recordId))) continue;
            ArrayList<String> members = new ArrayList<String>();
            for (TaskRecordModelFilterMemEntry member : recordModel.getTaskRecordModelFilterMemEntry()) {
                IDNumberTreeNode memberNode = MemberReader.findMemberById((long)this.modelId, (String)member.getDimensionMembermodel(), (Long)member.getMemberId());
                if (null == memberNode) continue;
                members.add(memberNode.getName());
            }
            row.set(FILTERMEMBER, (Object)String.join((CharSequence)"\uff0c", members));
            DynamicObject permDyn = (DynamicObject)permClassMap.get(recordId);
            row.set(PERMCLASS, null != permDyn ? permDyn.getString("permclass.number") : null);
        }
        this.getQueryResult().setDataCount(this.getRealCount());
        return rows;
    }
}

