/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.taskmanage;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.taskmanage.enums.TaskActivityTypeEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskRelaOperEnum;
import kd.fi.bcm.business.taskmanage.helper.TaskRecordServiceHelper;
import kd.fi.bcm.business.taskmanage.model.TaskRecordModel;
import kd.fi.bcm.business.taskmanage.model.TaskRecordModelActTplEntry;
import kd.fi.bcm.business.taskmanage.model.TaskRecordModelFilterMemEntry;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateActModel;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateActTplEntry;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateDisdimEntry;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateModel;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateScene;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.taskmanage.TaskActivityTabInfo;
import kd.fi.bcm.formplugin.taskmanage.TaskActivityTabManager;
import kd.fi.bcm.formplugin.taskmanage.TaskRecordCreateBase;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskCardHelper;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskCommonHelper;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskOpenMenuHelper;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskReportHelper;
import org.apache.commons.collections4.CollectionUtils;

public class TaskRecordViewPlugin
extends AbstractBaseListPlugin
implements CellClickListener,
TabSelectListener,
TaskRecordCreateBase {
    private static final String TAB_VIEW = "tabap";
    private TaskTemplateModel taskTemplateModel;
    private TaskRecordModel taskRecordModel;
    private static final String CHECK_ALLOCATION = "checkallocation";
    private static final String START_UP_POLICY = "startuppolicy";
    private static final String ENTRYENTITY_ACT = "entryentity_act";
    private static final String ENTRYENTITY_ACTID = "entryentity_actid";
    private static final String ENTRYENTITY_ACTNAME = "entryentity_actname";
    private static final String KEY_ACTIVITY_ID = "KEY_ACTIVITY_ID";
    private static final String BTN_REPORTTEMPLATE_PLAN = "tpldisflex";
    private static final String TEMPLATENUMBER = "templatenumber";
    private static final String TEMPLATENAME = "templatename";
    private static final String TYPE = "type";
    private static final String SCENE = "scene";
    private static final String REMARK = "remark";
    private static final String DISDIMENSIONITEM = "disdimensionitem";
    private static final String SETTINGPANEL = "settingpanel";
    private static final String ACTNAME = "actname";
    private static final String DESCRIPTION = "description";
    private static final String ACTTYPE = "acttype";
    private static final String ISAPPLYDETAIL = "isapplydetail";
    private static final String ISAPPLYMERGE = "isapplymerge";
    private static final String ISDEPENDLAST = "isdependlast";
    private static final String RELEVANTOP = "relevantop";
    private static final String RELEVANTOP_FLEX = "relevantopflex";
    private static final String PARAMLOCK = "paramlock";
    private static final String ISNOTICE = "isnotice";
    private static final String NOTICEDISMODE = "noticedismode";
    private static final String MESSAGECHANNEL = "messagechannel";
    private static final String NOTICECONTENT = "noticecontent";
    private static final String MSGUSER = "msguser";
    private static final String MSGUSERGROUP = "msgusergroup";
    private static final String BTN_REPORTTEMPLATE = "btn_reporttemplate";
    private static final String YEAR = "year";
    private static final String PERIOD = "period";
    private static final String SCENARIO = "scenario";
    private static final String TAB_CHECKTPL = "checktpltab";
    private static final String COMBO_ACTIVITY = "activitylist";
    private static final String BILL_LIST_AP_ENTITY = "billlistapentity";
    private static final String INIT_ACTIVITY_FLAG = "INIT_ACTIVITY_FLAG";
    private TaskActivityTabManager taskActivityTabManager;
    private static final String BTN_ADD_TPL = "addtpl";
    private static final String BTN_DELETE_TPL = "deletetpl";
    private static final String CACHE_TASK_TPL_FILTER_DIM_MAP = "filterDimMap";
    private static final String CACHE_TASK_RECORD_MODEL_KEY = "taskRecordModel";
    private static final String BEGINTIME = "begintime";
    private static final String ENDTIME = "endtime";
    private static final String CHANNEL = "channel";
    private static final String NOTICESWITCH = "noticeswitch";
    private static final String TASKNOTICECONTENT = "tasknoticecontent";
    private static final String PERMCLASS = "permclass";
    private static final String STARTMODE = "startmode";
    private static final String FORCECLOSE = "forceclose";
    private static final String[] TEMPLATE_BASIC_DATA = new String[]{"templatenumber", "templatename", "type", "disdimensionitem", "scene", "remark"};
    private static final String[] TEMPLATE_ACTIVITY_DETAIL = new String[]{"actname", "description", "acttype", "isapplydetail", "isapplymerge", "isdependlast", "relevantop", "paramlock", "isnotice", "noticedismode", "messagechannel", "msguser", "msgusergroup", "noticecontent"};
    private static final String[] TASK_CONDITION_CONTENT = new String[]{"year", "period", "scenario"};
    private static final String[] START_UP_POLICY_CONTENT = new String[]{"startmode", "begintime", "forceclose", "endtime", "noticeswitch", "channel", "tasknoticecontent", "permclass"};

    @Override
    public void initialize() {
        super.initialize();
        this.getView().setEnable(Boolean.FALSE, TEMPLATE_BASIC_DATA);
        this.getView().setEnable(Boolean.FALSE, TEMPLATE_ACTIVITY_DETAIL);
        this.getView().setEnable(Boolean.FALSE, TASK_CONDITION_CONTENT);
        this.getView().setEnable(Boolean.FALSE, START_UP_POLICY_CONTENT);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab topTab = (Tab)this.getControl(TAB_VIEW);
        topTab.addTabSelectListener((TabSelectListener)this);
        ((EntryGrid)this.getControl(ENTRYENTITY_ACT)).addCellClickListener((CellClickListener)this);
        Tab checkTplTab = (Tab)this.getControl(TAB_CHECKTPL);
        checkTplTab.addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(BTN_REPORTTEMPLATE);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadTaskRecordModel();
        Long modelId = (Long)this.getFormCustomParam("KEY_MODEL_ID");
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
        this.getPageCache().put("PAGE_FORMM_ID", "bcm_viewtaskrecord");
        this.setValue("model", modelId);
        this.loadTaskTemplateData();
        this.loadTaskConditionData();
    }

    private void loadCheckAllocationData() {
        this.refreshDisList(this.gainGroupId());
        this.buildActivityPanel();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String keyName = e.getProperty().getName();
        if (this.getFilterDimMapFromCache().containsKey(keyName)) {
            this.updateTaskRecordModelFilterDimMember(keyName);
            return;
        }
        switch (keyName) {
            case "activitylist": {
                this.setCurrentActivityId(this.getPageCache(), (String)e.getChangeSet()[0].getNewValue());
                this.refreshTemplateDistributionPage(true);
                this.refreshDisList(this.gainGroupId());
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getModel().getEntryRowCount(ENTRYENTITY_ACT) > 0) {
            ((EntryGrid)this.getControl(ENTRYENTITY_ACT)).selectRows(0);
        }
    }

    private void updateTaskRecordModelFilterDimMember(String key) {
        LinkedHashMap<String, Pair<Long, String>> filterDimMap = this.getFilterDimMapFromCache();
        Pair<Long, String> dimPair = filterDimMap.get(key);
        List taskRecordModelFilterMemEntry = this.getTaskRecordModel().getTaskRecordModelFilterMemEntry();
        for (TaskRecordModelFilterMemEntry entry : taskRecordModelFilterMemEntry) {
            if (!Objects.equals(entry.getDimensionId(), dimPair.p1)) continue;
            DynamicObject value = (DynamicObject)this.getValue(key);
            entry.setMemberId(Long.valueOf(value == null ? 0L : value.getLong("id")));
        }
        this.cacheTaskRecordModel(this.getTaskRecordModel());
        this.getPageCache().remove(INIT_ACTIVITY_FLAG);
    }

    private TaskRecordModel getTaskRecordModel() {
        if (null != this.taskRecordModel) {
            return this.taskRecordModel;
        }
        String serial = this.getPageCache().get(CACHE_TASK_RECORD_MODEL_KEY);
        this.taskRecordModel = StringUtils.isNotEmpty((String)serial) ? (TaskRecordModel)this.deSerializedBytes(serial) : new TaskRecordModel();
        return this.taskRecordModel;
    }

    private void cacheTaskRecordModel(TaskRecordModel taskRecordModel) {
        this.getPageCache().put(CACHE_TASK_RECORD_MODEL_KEY, this.toByteSerialized(taskRecordModel));
    }

    private LinkedHashMap<String, Pair<Long, String>> getFilterDimMapFromCache() {
        String serialStr = this.getPageCache().get(CACHE_TASK_TPL_FILTER_DIM_MAP);
        if (StringUtils.isNotEmpty((String)serialStr)) {
            return (LinkedHashMap)ObjectSerialUtil.deSerializedBytes((String)serialStr);
        }
        return new LinkedHashMap<String, Pair<Long, String>>();
    }

    private void refreshDisList(String groupId) {
        BillList billList = (BillList)this.getControl(BILL_LIST_AP_ENTITY);
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.getQFilters().clear();
        QFilter qFilter = StringUtils.isNotEmpty((String)groupId) ? new QFilter("groupid", "=", (Object)groupId) : new QFilter("1", "=", (Object)0);
        filterParameter.getQFilters().add(qFilter);
        billList.setQueryFilterParameter(filterParameter);
        billList.clearSelection();
        this.setColumnDimName();
        billList.refresh();
        this.getView().setVisible(Boolean.valueOf(true), new String[]{BILL_LIST_AP_ENTITY});
    }

    private void loadTaskTemplateData() {
        this.initTemplateName(this.getTaskTemplateModel());
        this.initActivityList(this.getTaskTemplateModel());
        this.initBasicData(this.getTaskTemplateModel());
        this.initComboItem();
    }

    private void loadTaskConditionData() {
        List taskRecordModelFilterMemEntryList = this.taskRecordModel.getTaskRecordModelFilterMemEntry();
        for (TaskRecordModelFilterMemEntry taskRecordModelFilterMemEntry : taskRecordModelFilterMemEntryList) {
            String dimensionNumber = taskRecordModelFilterMemEntry.getDimensionNumber();
            long modelId = this.getModelId();
            Long memberId = taskRecordModelFilterMemEntry.getMemberId();
            switch (dimensionNumber) {
                case "Scenario": {
                    this.setValue(SCENARIO, MemberReader.findScenaMemberById((Long)modelId, (Long)memberId).getId());
                    break;
                }
                case "Year": {
                    this.setValue(YEAR, MemberReader.findFyMemberById((Long)modelId, (Long)memberId).getId());
                    break;
                }
                case "Period": {
                    this.setValue(PERIOD, MemberReader.findPeriodMemberById((Long)modelId, (Long)memberId).getId());
                }
            }
        }
    }

    private void loadStartUpPolicyData() {
        Long taskRecordId = (Long)this.getFormCustomParam("taskRecordId");
        String findTemplateIdSql = "select fisnotice,fnoticecontent,fbegintime,fendtime,fmessagechannel,fstartmode,fisforceclose from t_bcm_taskrecord where fid = ?";
        Object[] params4Product = new SqlParameter[]{new SqlParameter(":fid", -5, (Object)taskRecordId)};
        DB.query((DBRoute)BCMConstant.DBROUTE, (String)findTemplateIdSql, (Object[])params4Product, rs -> {
            if (rs.next()) {
                this.setValue(NOTICESWITCH, rs.getInt("fisnotice"));
                this.setValue(TASKNOTICECONTENT, rs.getString("fnoticecontent"));
                this.setValue(BEGINTIME, rs.getString("fbegintime"));
                this.setValue(ENDTIME, rs.getString("fendtime"));
                this.setValue(CHANNEL, rs.getString("fmessagechannel"));
                this.setValue(STARTMODE, rs.getInt("fstartmode"));
                this.setValue(FORCECLOSE, rs.getInt("fisforceclose"));
            }
            return null;
        });
        DynamicObject taskRecordDyna = this.getTaskRecordModel().genDynamicObject();
        this.setValue(PERMCLASS, taskRecordDyna.getLong(PERMCLASS));
    }

    private void initComboItem() {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(TaskActivityTypeEnum.values().length);
        List<TaskActivityTypeEnum> enumList = this.isRPT() ? TaskActivityTypeEnum.getRptEnum() : Arrays.asList(TaskActivityTypeEnum.values());
        for (TaskActivityTypeEnum type : enumList) {
            list.add(new ComboItem(new LocaleString(type.getName()), type.getType()));
        }
        ((ComboEdit)this.getControl(ACTTYPE)).setComboItems(list);
    }

    private void initBasicData(TaskTemplateModel taskTemplateModel) {
        this.setValue(REMARK, taskTemplateModel.getRemark());
        this.setValue(TEMPLATENUMBER, taskTemplateModel.getNumber());
        this.setValue(TEMPLATENAME, taskTemplateModel.getName());
        this.setValue(TYPE, taskTemplateModel.getType().getCode());
        this.loadScene();
        this.loadDisDimension();
    }

    private void loadDisDimension() {
        List taskTemplateDisdimList = this.getTaskTemplateModel().getTaskTemplateDisdim();
        StringBuilder sb = new StringBuilder();
        for (TaskTemplateDisdimEntry taskTemplateDisdimEntry : taskTemplateDisdimList) {
            int range = taskTemplateDisdimEntry.getRange();
            IDNumberTreeNode disDimensionTreeNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)taskTemplateDisdimEntry.getMemberid());
            if (IDNumberTreeNode.NotFoundTreeNode == disDimensionTreeNode) continue;
            RangeEnum.buildScopeShowName((StringBuilder)sb, (String)disDimensionTreeNode.getName(), (int)range);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        this.setValue(DISDIMENSIONITEM, sb.toString());
    }

    private void loadScene() {
        List taskTemplateSceneList = this.getTaskTemplateModel().getTaskTemplateScene();
        StringBuilder sb = new StringBuilder();
        for (TaskTemplateScene taskTemplateScene : taskTemplateSceneList) {
            IDNumberTreeNode scenaMemberById = MemberReader.findScenaMemberById((Long)this.getModelId(), (Long)taskTemplateScene.getBasedataid());
            if (IDNumberTreeNode.NotFoundTreeNode == scenaMemberById) continue;
            sb.append(scenaMemberById.getName()).append(";");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        this.setValue(SCENE, sb.toString());
    }

    private void initTemplateName(TaskTemplateModel taskTemplateModel) {
        String templateView = taskTemplateModel.getNumber() + "_" + taskTemplateModel.getName();
        ((Label)this.getControl("templateview")).setText(templateView);
    }

    private TaskTemplateModel getTaskTemplateModel() {
        if (this.taskTemplateModel != null) {
            return this.taskTemplateModel;
        }
        this.taskTemplateModel = TaskTemplateModel.dynToModel((Long)this.getTaskRecordModel().getTaskTemplateModel().getId());
        this.getPageCache().put("CACHE_TASK_TPL_MODEL", this.toByteSerialized(this.taskTemplateModel));
        return this.taskTemplateModel;
    }

    private void initActivityList(TaskTemplateModel taskTemplate) {
        int currRow = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY_ACT);
        this.getModel().deleteEntryData(ENTRYENTITY_ACT);
        List list = taskTemplate.getTaskTemplateAct();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY_ACT, list.size());
        for (int i = 0; i < list.size(); ++i) {
            TaskTemplateActModel act = (TaskTemplateActModel)list.get(i);
            this.setActEntry(i, act.getId(), act.getActName());
        }
        currRow = currRow < list.size() ? currRow : 0;
        this.refreshActBaseInfo((TaskTemplateActModel)list.get(currRow), currRow);
    }

    private void refreshActBaseInfo(TaskTemplateActModel act, int row) {
        if (null == act) {
            return;
        }
        if (row >= 0) {
            ((EntryGrid)this.getControl(ENTRYENTITY_ACT)).clickCell("1", row);
        }
        this.getPageCache().put(KEY_ACTIVITY_ID, String.valueOf(act.getId()));
        this.getModel().beginInit();
        this.setValue(ACTNAME, act.getActName());
        this.setValue(DESCRIPTION, act.getDescription());
        this.setValue(ACTTYPE, act.getActType().getType());
        this.setValue(ISAPPLYDETAIL, act.isApplydetail());
        this.setValue(ISAPPLYMERGE, act.isApplymerge());
        this.setValue(ISDEPENDLAST, act.getIsdependlast());
        this.setValue(RELEVANTOP, act.getRelevantop().getCode());
        this.setValue(PARAMLOCK, act.getParamlock());
        this.setValue(ISNOTICE, act.isNotice());
        this.setValue(NOTICEDISMODE, act.getNoticedismode().getCode());
        this.setValue(MESSAGECHANNEL, act.getMessagechannel());
        this.setValue(NOTICECONTENT, act.getNoticecontent());
        this.setValue(MSGUSER, act.getMsguserId(TaskTemplateModel.UserTypeEnum.USER).toArray());
        this.setValue(MSGUSERGROUP, act.getMsguserId(TaskTemplateModel.UserTypeEnum.GROUP).toArray());
        this.setMsguserEnable(act);
        this.getModel().endInit();
        this.getView().updateView(SETTINGPANEL);
        this.getView().setVisible(Boolean.valueOf(act.isReport()), new String[]{BTN_REPORTTEMPLATE_PLAN});
        if (!this.isEnable()) {
            this.getView().setEnable(Boolean.valueOf(act.isNotice()), new String[]{NOTICEDISMODE, MESSAGECHANNEL});
        }
        this.initComboItemRelevantop(act);
        this.initComboItemParamlock(act);
    }

    private void setActEntry(int row, Long actId, Object actName) {
        if (LongUtil.isvalidLong((Object)actId)) {
            this.getModel().setValue(ENTRYENTITY_ACTID, (Object)actId, row);
        }
        if (Objects.nonNull(actName)) {
            this.getModel().setValue(ENTRYENTITY_ACTNAME, (Object)((OrmLocaleValue)actName).getLocaleValue(), row);
        }
    }

    private void setMsguserEnable(TaskTemplateActModel act) {
        boolean enable;
        boolean bl = enable = act.isNotice() && act.getNoticedismode() == TaskTemplateModel.DismodeEnum.ASSIGN;
        if (!this.isEnable()) {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{MSGUSER, MSGUSERGROUP});
        }
    }

    private boolean isEnable() {
        return this.getTaskTemplateModel().isEnable();
    }

    private void initComboItemRelevantop(TaskTemplateActModel act) {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(TaskRelaOperEnum.values().length);
        List operEnumList = TaskActivityTypeEnum.getRelaOper((TaskActivityTypeEnum)act.getActType());
        boolean isReportTaskAndNotReportAct = this.isReportTask() && act.getActType() != TaskActivityTypeEnum.Report;
        operEnumList.removeIf(e -> isReportTaskAndNotReportAct && e != TaskRelaOperEnum.NULL);
        for (TaskRelaOperEnum type : operEnumList) {
            list.add(new ComboItem(new LocaleString(type.getName()), type.getCode()));
        }
        ((ComboEdit)this.getControl(RELEVANTOP)).setComboItems(list);
        this.getView().setVisible(Boolean.valueOf(operEnumList.size() > 1), new String[]{RELEVANTOP_FLEX});
    }

    private void initComboItemParamlock(TaskTemplateActModel act) {
        List list;
        Pair<List<String>, String> pair = TaskOpenMenuHelper.pageF7Map.get(act.getActType());
        if (null == pair) {
            list = Collections.emptyList();
        } else {
            list = new ArrayList(((List)pair.p1).size());
            Long modelId = this.getModelId();
            for (String param : (List)pair.p1) {
                list.add(new ComboItem(new LocaleString(TaskCardHelper.getDimTitle(modelId, param)), param));
            }
        }
        ((MulComboEdit)this.getControl(PARAMLOCK)).setComboItems(list);
    }

    private boolean isReportTask() {
        return this.getTaskTemplateModel().isReportTask();
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        if (cellClickEvent.getSource() instanceof EntryGrid) {
            String eKey;
            switch (eKey = ((EntryGrid)cellClickEvent.getSource()).getKey()) {
                case "entryentity_act": {
                    this.cellClickByAct();
                    break;
                }
            }
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    private void cellClickByAct() {
        int row = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY_ACT);
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY_ACT, row);
        Long activityId = rowEntity.getLong(ENTRYENTITY_ACTID);
        this.refreshActBaseInfo(this.getActivityModel(activityId), -1);
    }

    private TaskTemplateActModel getActivityModel(Long activityId) {
        if (!LongUtil.isvalidLong((Object)activityId)) {
            return null;
        }
        List list = this.getTaskTemplateModel().getTaskTemplateAct();
        return list.stream().filter(e -> Objects.equals(activityId, e.getId())).findFirst().orElseGet(() -> null);
    }

    private TaskTemplateActModel getActivityModel() {
        return this.getActivityModel(this.getActivityId());
    }

    private Long getActivityId() {
        String serial = this.getPageCache().get(KEY_ACTIVITY_ID);
        return StringUtils.isNotEmpty((String)serial) ? Long.parseLong(serial) : 0L;
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String currentTab;
        switch (currentTab = tabSelectEvent.getTabKey()) {
            case "checkallocation": {
                this.loadCheckAllocationData();
                break;
            }
            case "startuppolicy": {
                this.loadStartUpPolicyData();
            }
        }
    }

    private void buildActivityPanel() {
        if (null != this.getPageCache().get(INIT_ACTIVITY_FLAG)) {
            return;
        }
        TaskRecordModel taskRecordModel = this.getTaskRecordModel();
        if (this.isNew()) {
            taskRecordModel.getTaskRecordModelActTplEntry().clear();
        }
        TaskTemplateModel taskTemplateModel = this.getTaskTemplateModel();
        List taskTemplateAct = taskTemplateModel.getTaskTemplateAct();
        List<TaskTemplateActModel> reportActivity = taskTemplateAct.stream().filter(r -> r.isReport()).collect(Collectors.toList());
        Map<Long, Long> allSource2Right = this.filterTemplateByVersioned(reportActivity);
        Set<Long> allCycleIdsByScenario = this.filterCycleByScenario(reportActivity);
        this.taskActivityTabManager = new TaskActivityTabManager();
        for (TaskTemplateActModel actModel : reportActivity) {
            boolean isCycleTable;
            long actId = actModel.getId();
            String tabKey = actId + "";
            String actName = ((OrmLocaleValue)actModel.getActName()).getLocaleValue();
            List taskTemplateActTpl = actModel.getTaskTemplateActTpl();
            boolean bl = isCycleTable = CollectionUtils.isNotEmpty((Collection)taskTemplateActTpl) ? ((TaskTemplateActTplEntry)taskTemplateActTpl.get(0)).isCycletable() : false;
            if (!isCycleTable) {
                taskTemplateActTpl.removeIf(e -> !allSource2Right.containsKey(e.getTemplateid()));
                taskTemplateActTpl.forEach(e -> e.setTemplateid((Long)allSource2Right.get(e.getTemplateid())));
            } else {
                taskTemplateActTpl.removeIf(e -> !allCycleIdsByScenario.contains(e.getTemplateid()));
            }
            List<Long> reportTplIdList = taskTemplateActTpl.stream().map(r -> r.getTemplateid()).collect(Collectors.toList());
            List<String> reportTplNumberList = taskTemplateActTpl.stream().map(r -> r.getTemplatenumber()).collect(Collectors.toList());
            TaskActivityTabInfo info = this.taskActivityTabManager.addActivityTabInfo(tabKey, actName, actId, reportTplIdList, reportTplNumberList);
            info.setCycleTable(isCycleTable);
            if (!this.isNew()) continue;
            reportTplIdList.stream().forEach(e -> this.getTaskRecordModel().getTaskRecordModelActTplEntry().add(this.createRecordModelActTplEntry(actId, (Long)e, isCycleTable)));
        }
        this.cacheTaskActivityTabManager(this.taskActivityTabManager);
        this.cacheTaskRecordModel(this.getTaskRecordModel());
        this.getPageCache().put(INIT_ACTIVITY_FLAG, "true");
        if (CollectionUtils.isEmpty(reportActivity)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_ADD_TPL, BTN_DELETE_TPL});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_ADD_TPL, BTN_DELETE_TPL});
        }
        TaskRecordServiceHelper.deleteDisList((String)this.gainGroupId());
        if (CollectionUtils.isNotEmpty(reportActivity)) {
            TaskRecordServiceHelper.createDisList((TaskTemplateModel)this.getTaskTemplateModel(), (String)this.gainGroupId());
        }
        this.buildComboActivity(reportActivity);
    }

    private void buildComboActivity(List<TaskTemplateActModel> reportActivity) {
        ComboEdit edit = (ComboEdit)this.getControl(COMBO_ACTIVITY);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(reportActivity.size());
        if (CollectionUtils.isEmpty(reportActivity)) {
            edit.setComboItems(items);
            this.setValue(COMBO_ACTIVITY, null);
            return;
        }
        for (TaskTemplateActModel act : reportActivity) {
            items.add(new ComboItem(new LocaleString(act.getActNameString()), String.valueOf(act.getId())));
        }
        edit.setComboItems(items);
        this.setValue(COMBO_ACTIVITY, null);
        this.setValue(COMBO_ACTIVITY, reportActivity.get(0).getId());
        this.setCurrentActivityId(this.getPageCache(), String.valueOf(reportActivity.get(0).getId()));
    }

    private Map<Long, Long> filterTemplateByVersioned(List<TaskTemplateActModel> reportActivity) {
        ArrayList pagememberSceneids = Lists.newArrayList((Object[])new Long[]{((DynamicObject)this.getValue(SCENARIO)).getLong("id")});
        Long yearId = ((DynamicObject)this.getValue(YEAR)).getLong("id");
        Long periodId = ((DynamicObject)this.getValue(PERIOD)).getLong("id");
        HashSet allTemplateIds = new HashSet(16);
        for (TaskTemplateActModel actModel : reportActivity) {
            List taskTemplateActTpl = actModel.getTaskTemplateActTpl();
            boolean isCycleTable = CollectionUtils.isNotEmpty((Collection)taskTemplateActTpl) ? ((TaskTemplateActTplEntry)taskTemplateActTpl.get(0)).isCycletable() : false;
            if (isCycleTable) continue;
            allTemplateIds.addAll(taskTemplateActTpl.stream().map(e -> e.getTemplateid()).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isEmpty(allTemplateIds)) {
            return Collections.emptyMap();
        }
        Map allSource2Right = TemplateUtil.getRightTplIdByVersioned((Long)this.getModelId(), (Long)yearId, (Long)periodId, allTemplateIds);
        Set templateIdsByScene = TaskRecordServiceHelper.filterTemplateByScenario((Long)this.getModelId(), (List)pagememberSceneids, allSource2Right.values());
        allSource2Right.entrySet().removeIf(e -> !templateIdsByScene.contains(e.getValue()));
        return allSource2Right;
    }

    private Set<Long> filterCycleByScenario(List<TaskTemplateActModel> reportActivity) {
        ArrayList pagememberSceneids = Lists.newArrayList((Object[])new Long[]{((DynamicObject)this.getValue(SCENARIO)).getLong("id")});
        HashSet allCycleIds = new HashSet(16);
        for (TaskTemplateActModel actModel : reportActivity) {
            List taskTemplateActTpl = actModel.getTaskTemplateActTpl();
            boolean isCycleTable = CollectionUtils.isNotEmpty((Collection)taskTemplateActTpl) ? ((TaskTemplateActTplEntry)taskTemplateActTpl.get(0)).isCycletable() : false;
            if (!isCycleTable) continue;
            allCycleIds.addAll(taskTemplateActTpl.stream().map(e -> e.getTemplateid()).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isEmpty(allCycleIds)) {
            return Collections.emptySet();
        }
        DynamicObjectCollection dyns = TaskReportHelper.getCycleTableList(this.getModelId(), allCycleIds.stream().collect(Collectors.toList()), false, pagememberSceneids);
        return dyns.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
    }

    private void cacheTaskActivityTabManager(TaskActivityTabManager taskActivityTabManager) {
        this.cacheTaskActivityTabManager(this.getPageCache(), taskActivityTabManager);
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        TaskRecordServiceHelper.deleteDisList((String)this.gainGroupId());
        super.beforeClosed(e);
    }

    private boolean isNew() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        return status == OperationStatus.ADDNEW;
    }

    private TaskRecordModelActTplEntry createRecordModelActTplEntry(Long activityId, Long templateId, boolean isCycleTable) {
        TaskRecordModelActTplEntry subEntry = new TaskRecordModelActTplEntry(null);
        subEntry.setActivityId(activityId);
        subEntry.setTemplateId(templateId);
        subEntry.setCycleTable(isCycleTable);
        return subEntry;
    }

    private void loadTaskRecordModel() {
        long taskRecordModelId = (Long)this.getFormCustomParam("taskRecordId");
        this.taskRecordModel = TaskRecordModel.dynObjToTaskRecordModel((Long)taskRecordModelId);
        this.taskRecordModel.setModelId(this.getModelId());
        this.cacheTaskRecordModel(this.taskRecordModel);
    }

    private void refreshTemplateDistributionPage(boolean refresh) {
        this.getPageCache().put("SUB_PAGEID_TPLDIS_REFRESH_FLAG", String.valueOf(refresh));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String propName = beforeF7SelectEvent.getProperty().getName();
        if (Objects.equals(SCENARIO, propName)) {
            Set scenarioIds = this.getTaskTemplateModel().getTaskTemplateScene().stream().map(e -> e.getBasedataid()).collect(Collectors.toSet());
            QFilter filter = new QFilter("id", "in", scenarioIds);
            ((BasedataEditSingleMemberF7)((Object)beforeF7SelectEvent.getSource())).setCustomFilter(filter);
            beforeF7SelectEvent.getCustomQFilters().add(filter);
        }
    }

    private void setColumnDimName() {
        TaskCommonHelper.setColumnDimName(this.getView(), this.getModelId(), SCENE, SCENARIO);
        TaskCommonHelper.setColumnDimNumAndName(this.getView(), this.getModelId(), new String[]{"disnumber", "disname"}, "entity");
    }

    @Override
    public void click(EventObject evt) {
        String eKey;
        super.click(evt);
        switch (eKey = ((Control)evt.getSource()).getKey()) {
            case "btn_reporttemplate": {
                this.openReportTemplate(eKey);
            }
        }
    }

    private void openReportTemplate(String eKey) {
        List<Long> sceneIds = this.getTaskTemplateModel().getTaskTemplateScene().stream().map(e -> e.getBasedataid()).collect(Collectors.toList());
        TaskTemplateActModel act = this.getActivityModel();
        if (this.currentActNull(act)) {
            return;
        }
        List tplList = act.getTaskTemplateActTpl();
        List<String> templateNumbers = !act.isCycletable() ? this.getTemplateNumbers() : TaskReportHelper.getTemplateNumbersByCycletable(this.getModelId(), tplList.stream().map(e -> e.getTemplateid()).collect(Collectors.toList()));
        TaskRecordViewPlugin.openReportTemplate((AbstractFormPlugin)this, eKey, this.getModelId(), templateNumbers, sceneIds, act.isCycletable(), this.isEnable(), null);
    }

    public static void openReportTemplate(AbstractFormPlugin plugin, String actionId, Long modelId, List<String> templateNumbers, List<Long> sceneIds, boolean iscycletable, boolean readonly, Map<String, Long> f7IdMap) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_tasktpl_acttplf7");
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)modelId);
        formShowParameter.setCustomParam("rows", templateNumbers);
        formShowParameter.setCustomParam("pagememberids", sceneIds);
        formShowParameter.setCustomParam("iscycletable", (Object)iscycletable);
        formShowParameter.setCustomParam("readonly", (Object)readonly);
        formShowParameter.setCustomParam("ishideSearch", (Object)true);
        if (null != f7IdMap) {
            formShowParameter.setCustomParam("f7IdMap", f7IdMap);
        }
        formShowParameter.setParentPageId(plugin.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u62a5\u8868\u6a21\u677f", (String)"TaskCommonHelper_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        plugin.getView().showForm(formShowParameter);
    }

    private boolean currentActNull(TaskTemplateActModel act) {
        if (null == act) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u521b\u5efa\u6d3b\u52a8\u3002", (String)"TaskTemplateConfigPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private List<String> getTemplateNumbers() {
        TaskTemplateActModel act = this.getActivityModel();
        if (null == act) {
            return Collections.emptyList();
        }
        return act.getTaskTemplateActTpl().stream().map(e -> e.getTemplatenumber()).collect(Collectors.toList());
    }
}

