/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.taskmanage;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.serviceHelper.CycleTablesServiceHelper;
import kd.fi.bcm.business.taskmanage.enums.TaskActivityTypeEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskRelaOperEnum;
import kd.fi.bcm.business.taskmanage.helper.TaskTemplateHelper;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateActModel;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateActMsgEntry;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateActTplEntry;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateModel;
import kd.fi.bcm.business.taskmanage.notice.TaskNoticeContentHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskCardHelper;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskCommonHelper;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskOpenMenuHelper;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskReportHelper;
import org.apache.commons.collections4.CollectionUtils;

public class TaskTemplateConfigPlugin
extends AbstractBaseFormPlugin
implements CellClickListener {
    private static final String PARAM_TASKTEMPLATEID = "taskTemplateId";
    private static final String ENTRYENTITY_ACT = "entryentity_act";
    private static final String KEY_ACTIVITY_ID = "KEY_ACTIVITY_ID";
    private static final String KEY_TASKTEMPLATE_MODEL = "KEY_TASKTEMPLATE_MODEL";
    private static final String IS_MODIFY = "is_modify";
    private static final String ENTRYENTITY_ACTID = "entryentity_actid";
    private static final String ENTRYENTITY_ACTNAME = "entryentity_actname";
    private static final String TOOLBAR_AP = "toolbarap";
    private static final String BTN_SAVE = "btn_save";
    private static final String BTN_BASEINFO = "btn_baseinfo";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_EXIT = "exit";
    private static final String BTN_ADDNEW = "btn_addnew";
    private static final String BTN_DELETE = "btn_delete";
    private static final String BTN_UP = "btn_up";
    private static final String BTN_DOWN = "btn_down";
    private static final String BTN_TEMPLATELIST = "btn_templatelist";
    private static final String BTN_REPORTTEMPLATE = "btn_reporttemplate";
    private static final String BTN_REPORTTEMPLATE_PLAN = "tpldisflex";
    private static final String BTN_USETOALLACT = "btn_usetoallact";
    private static final String BTN_BACKTOLIST = "btn_backtolist";
    private static final String SETTINGPANEL = "settingpanel";
    private static final String ACTNAME = "actname";
    private static final String DESCRIPTION = "description";
    private static final String ACTTYPE = "acttype";
    private static final String ISAPPLYDETAIL = "isapplydetail";
    private static final String ISAPPLYMERGE = "isapplymerge";
    private static final String ISDEPENDLAST = "isdependlast";
    private static final String RELEVANTOP = "relevantop";
    private static final String RELEVANTOP_FLEX = "relevantopflex";
    private static final String PARAMLOCK = "paramlock";
    private static final String ISNOTICE = "isnotice";
    private static final String NOTICEDISMODE = "noticedismode";
    private static final String MESSAGECHANNEL = "messagechannel";
    private static final String NOTICECONTENT = "noticecontent";
    private static final String PARSEDIM = "parsedim";
    private static final String MSGUSER = "msguser";
    private static final String MSGUSERGROUP = "msgusergroup";
    private static final List<String> PROPERTY_KEYSET = Arrays.asList("actname", "description", "acttype", "isapplydetail", "isapplymerge", "isdependlast", "relevantop", "paramlock", "isnotice", "noticedismode", "messagechannel", "noticecontent", "msguser", "msgusergroup", "parsedim");
    private TaskTemplateModel taskTemplateModel;

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(TOOLBAR_AP);
        this.addClickListeners(BTN_ADDNEW, BTN_DELETE, BTN_UP, BTN_DOWN, BTN_TEMPLATELIST, BTN_REPORTTEMPLATE, BTN_USETOALLACT);
        ((EntryGrid)this.getControl(ENTRYENTITY_ACT)).addCellClickListener((CellClickListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getFormCustomParam("KEY_MODEL_ID");
        this.setValue("model", modelId);
        this.loadTaskTemplateModel();
        this.initNoticeDim(modelId);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_BACKTOLIST});
        this.addTempAct();
    }

    private void initNoticeDim(Long modelId) {
        Pair noticeDim = TaskNoticeContentHelper.getNoticeDim((Long)modelId, (boolean)true);
        ComboEdit comboEdit = (ComboEdit)this.getControl(PARSEDIM);
        comboEdit.setComboItems((List)noticeDim.p1);
        comboEdit.addTips(new Tips("text", null, new LocaleString((String)noticeDim.p2), false, null));
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getModel().getEntryRowCount(ENTRYENTITY_ACT) > 0) {
            ((EntryGrid)this.getControl(ENTRYENTITY_ACT)).selectRows(0);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_save": {
                this.saveTaskTemplate();
                break;
            }
            case "btn_baseinfo": {
                TaskCommonHelper.openEdit(this, itemKey, this.getFormCustomParam(PARAM_TASKTEMPLATEID), this.getModelId());
                break;
            }
            case "btn_refresh": {
                this.loadTaskTemplateModel();
                this.addTempAct();
                break;
            }
            case "btn_backtolist": {
                TaskCommonHelper.openList(this.getView(), this.getModelId());
                break;
            }
            case "btn_enable": 
            case "btn_disable": {
                this.enable(itemKey);
                this.loadTaskTemplateModel();
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        super.beforeItemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_refresh": 
            case "exit": 
            case "btn_enable": {
                if (!this.checkIsModified(itemKey)) break;
                evt.setCancel(true);
                break;
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        String eKey;
        super.click(evt);
        switch (eKey = ((Control)evt.getSource()).getKey()) {
            case "btn_reporttemplate": {
                this.openReportTemplate(eKey);
                break;
            }
            case "btn_usetoallact": {
                this.useToAllAct();
                break;
            }
            case "btn_addnew": {
                this.addActivity();
                break;
            }
            case "btn_delete": {
                this.deleteActivity();
                break;
            }
            case "btn_up": 
            case "btn_down": {
                this.moveUpAndDown(eKey);
                break;
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String eKey;
        super.beforeClick(evt);
        switch (eKey = ((Control)evt.getSource()).getKey()) {
            case "btn_reporttemplate": 
            case "btn_usetoallact": {
                if (!this.currentActNull(this.getActivityModel())) break;
                evt.setCancel(true);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            return;
        }
        switch (callBackId) {
            case "btn_refresh": {
                this.loadTaskTemplateModel();
                break;
            }
            case "exit": {
                this.getView().close();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "btn_baseinfo": {
                if (!LongUtil.isvalidLong((Object)e.getReturnData())) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TaskTemplateConfigPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.reloadTaskTemplateModelExcludeAct();
                break;
            }
            case "btn_reporttemplate": {
                this.setReportTemplate(e.getReturnData());
                break;
            }
        }
    }

    public void cellClick(CellClickEvent event) {
        if (event.getSource() instanceof EntryGrid) {
            String eKey;
            switch (eKey = ((EntryGrid)event.getSource()).getKey()) {
                case "entryentity_act": {
                    this.cellClickByAct();
                    break;
                }
            }
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String keyName = e.getProperty().getName();
        if (PROPERTY_KEYSET.contains(keyName)) {
            this.setActProperty(e);
        }
    }

    private void initTemplateName(TaskTemplateModel taskTemplate) {
        String templateView = taskTemplate.getNumber() + "_" + taskTemplate.getName();
        ((Label)this.getControl("templateview")).setText(templateView);
    }

    private void loadTaskTemplateModel() {
        this.taskTemplateDynToModel();
        this.setViewEnable();
        this.initData();
        this.setModify(false);
    }

    private void setViewEnable() {
        boolean disable = !this.isEnable();
        this.getView().setEnable(Boolean.valueOf(disable), new String[]{BTN_ADDNEW, BTN_DELETE, BTN_UP, BTN_DOWN, BTN_USETOALLACT});
        this.getView().setEnable(Boolean.valueOf(disable), PROPERTY_KEYSET.toArray(new String[0]));
        this.getView().setVisible(Boolean.valueOf(disable), new String[]{BTN_SAVE, "btn_enable"});
        this.getView().setVisible(Boolean.valueOf(!disable), new String[]{"btn_disable"});
    }

    private void reloadTaskTemplateModelExcludeAct() {
        List actCache = this.getTaskTemplateModel().getTaskTemplateAct();
        this.taskTemplateDynToModel();
        this.getTaskTemplateModel().setTaskTemplateAct(actCache);
        this.initData();
    }

    private void taskTemplateDynToModel() {
        this.taskTemplateModel = TaskTemplateModel.dynToModel((Long)((Long)this.getFormCustomParam(PARAM_TASKTEMPLATEID)));
    }

    private void initData() {
        this.cacheTaskTemplateModel(this.getTaskTemplateModel());
        this.initTemplateName(this.getTaskTemplateModel());
        this.initActivityList(this.getTaskTemplateModel());
        this.initComboItem();
    }

    public void cacheTaskTemplateModel(TaskTemplateModel model) {
        this.getPageCache().put(KEY_TASKTEMPLATE_MODEL, this.toByteSerialized(model));
    }

    private TaskTemplateModel getTaskTemplateModel() {
        if (this.taskTemplateModel != null) {
            return this.taskTemplateModel;
        }
        String serial = this.getPageCache().get(KEY_TASKTEMPLATE_MODEL);
        if (StringUtils.isNotEmpty((String)serial)) {
            this.taskTemplateModel = (TaskTemplateModel)this.deSerializedBytes(serial);
        } else {
            this.taskTemplateDynToModel();
            this.cacheTaskTemplateModel(this.taskTemplateModel);
        }
        return this.taskTemplateModel;
    }

    private boolean isEnable() {
        return this.getTaskTemplateModel().isEnable();
    }

    private boolean isReportTask() {
        return this.getTaskTemplateModel().isReportTask();
    }

    private Long getActivityId() {
        String serial = this.getPageCache().get(KEY_ACTIVITY_ID);
        return StringUtils.isNotEmpty((String)serial) ? Long.parseLong(serial) : 0L;
    }

    private TaskTemplateActModel getActivityModel() {
        return this.getActivityModel(this.getActivityId());
    }

    private TaskTemplateActModel getActivityModel(Long activityId) {
        if (!LongUtil.isvalidLong((Object)activityId)) {
            return null;
        }
        List list = this.getTaskTemplateModel().getTaskTemplateAct();
        return list.stream().filter(e -> Objects.equals(activityId, e.getId())).findFirst().orElseGet(() -> null);
    }

    private void initActivityList(TaskTemplateModel taskTemplate) {
        int currRow = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY_ACT);
        this.getModel().deleteEntryData(ENTRYENTITY_ACT);
        List list = taskTemplate.getTaskTemplateAct();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY_ACT, list.size());
        for (int i = 0; i < list.size(); ++i) {
            TaskTemplateActModel act = (TaskTemplateActModel)list.get(i);
            this.setActEntry(i, act.getId(), act.getActName());
        }
        currRow = currRow < list.size() ? currRow : 0;
        this.refreshActBaseInfo((TaskTemplateActModel)list.get(currRow), currRow);
    }

    private void setActEntry(int row, Long actId, Object actName) {
        if (LongUtil.isvalidLong((Object)actId)) {
            this.getModel().setValue(ENTRYENTITY_ACTID, (Object)actId, row);
        }
        if (Objects.nonNull(actName)) {
            this.getModel().setValue(ENTRYENTITY_ACTNAME, (Object)((OrmLocaleValue)actName).getLocaleValue(), row);
        }
    }

    private void initComboItem() {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(TaskActivityTypeEnum.values().length);
        List<TaskActivityTypeEnum> enumList = this.isRPT() ? TaskActivityTypeEnum.getRptEnum() : Arrays.asList(TaskActivityTypeEnum.values());
        for (TaskActivityTypeEnum type : enumList) {
            list.add(new ComboItem(new LocaleString(type.getName()), type.getType()));
        }
        ((ComboEdit)this.getControl(ACTTYPE)).setComboItems(list);
    }

    private void initComboItemRelevantop(TaskTemplateActModel act) {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(TaskRelaOperEnum.values().length);
        List operEnumList = TaskActivityTypeEnum.getRelaOper((TaskActivityTypeEnum)act.getActType());
        boolean isReportTaskAndNotReportAct = this.isReportTask() && act.getActType() != TaskActivityTypeEnum.Report;
        operEnumList.removeIf(e -> isReportTaskAndNotReportAct && e != TaskRelaOperEnum.NULL);
        for (TaskRelaOperEnum type : operEnumList) {
            list.add(new ComboItem(new LocaleString(type.getName()), type.getCode()));
        }
        ((ComboEdit)this.getControl(RELEVANTOP)).setComboItems(list);
        this.getView().setVisible(Boolean.valueOf(operEnumList.size() > 1), new String[]{RELEVANTOP_FLEX});
    }

    private void initComboItemParamlock(TaskTemplateActModel act) {
        List list;
        Pair<List<String>, String> pair = TaskOpenMenuHelper.pageF7Map.get(act.getActType());
        if (null == pair) {
            list = Collections.emptyList();
        } else {
            list = new ArrayList(((List)pair.p1).size());
            Long modelId = this.getModelId();
            for (String param : (List)pair.p1) {
                list.add(new ComboItem(new LocaleString(TaskCardHelper.getDimTitle(modelId, param)), param));
            }
        }
        ((MulComboEdit)this.getControl(PARAMLOCK)).setComboItems(list);
    }

    private void refreshActBaseInfo(TaskTemplateActModel act, int row) {
        if (null == act) {
            return;
        }
        if (row >= 0) {
            ((EntryGrid)this.getControl(ENTRYENTITY_ACT)).selectRows(row);
        }
        this.getPageCache().put(KEY_ACTIVITY_ID, String.valueOf(act.getId()));
        this.getModel().beginInit();
        this.setValue(ACTNAME, act.getActName());
        this.setValue(DESCRIPTION, act.getDescription());
        this.setValue(ACTTYPE, act.getActType().getType());
        this.setValue(ISAPPLYDETAIL, act.isApplydetail());
        this.setValue(ISAPPLYMERGE, act.isApplymerge());
        this.setValue(ISDEPENDLAST, act.getIsdependlast());
        this.setValue(RELEVANTOP, act.getRelevantop().getCode());
        this.setValue(PARAMLOCK, act.getParamlock());
        this.setValue(ISNOTICE, act.isNotice());
        this.setValue(NOTICEDISMODE, act.getNoticedismode().getCode());
        this.setValue(MESSAGECHANNEL, act.getMessagechannel());
        this.setValue(NOTICECONTENT, act.getNoticecontent());
        this.setValue(MSGUSER, act.getMsguserId(TaskTemplateModel.UserTypeEnum.USER).toArray());
        this.setValue(MSGUSERGROUP, act.getMsguserId(TaskTemplateModel.UserTypeEnum.GROUP).toArray());
        this.setMsguserEnable(act);
        this.getModel().endInit();
        this.getView().updateView(SETTINGPANEL);
        this.getView().setVisible(Boolean.valueOf(act.isReport()), new String[]{BTN_REPORTTEMPLATE_PLAN});
        if (!this.isEnable()) {
            this.getView().setEnable(Boolean.valueOf(act.isNotice()), new String[]{NOTICEDISMODE, MESSAGECHANNEL});
        }
        this.initComboItemRelevantop(act);
        this.initComboItemParamlock(act);
    }

    private void refreshActBaseinfoNull() {
        this.getModel().beginInit();
        for (String e : PROPERTY_KEYSET) {
            this.setValue(e, null);
        }
        this.getModel().endInit();
        this.getView().updateView(SETTINGPANEL);
        this.getPageCache().put(KEY_ACTIVITY_ID, "0");
    }

    private void showSettingPanel(boolean isShow) {
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{SETTINGPANEL});
    }

    private void cellClickByAct() {
        int row = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY_ACT);
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY_ACT, row);
        Long activityId = rowEntity.getLong(ENTRYENTITY_ACTID);
        this.refreshActBaseInfo(this.getActivityModel(activityId), -1);
    }

    private void setModify(boolean isModify) {
        this.getPageCache().put(IS_MODIFY, String.valueOf(isModify));
    }

    private boolean isModified() {
        String serial = this.getPageCache().get(IS_MODIFY);
        if (StringUtils.isNotEmpty((String)serial)) {
            return Boolean.parseBoolean(serial);
        }
        return false;
    }

    private boolean checkIsModified(String operateKey) {
        if (this.isModified()) {
            switch (operateKey) {
                case "btn_refresh": {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4fee\u6539\uff0c\u5237\u65b0\u4f1a\u4e22\u5931\u4fee\u6539\u7684\u5185\u5bb9\uff0c\u662f\u5426\u786e\u8ba4\u5237\u65b0\uff1f", (String)"TaskTemplateConfigPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(operateKey, (IFormPlugin)this));
                    break;
                }
                case "exit": {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4fee\u6539\uff0c\u9000\u51fa\u4f1a\u4e22\u5931\u4fee\u6539\u7684\u5185\u5bb9\uff0c\u662f\u5426\u786e\u8ba4\u9000\u51fa\uff1f", (String)"TaskTemplateConfigPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(operateKey, (IFormPlugin)this));
                    break;
                }
                case "btn_enable": {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4fee\u6539\uff0c\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"TaskTemplateConfigPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    break;
                }
            }
            return true;
        }
        return false;
    }

    private boolean currentActNull(TaskTemplateActModel act) {
        if (null == act) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u521b\u5efa\u6d3b\u52a8\u3002", (String)"TaskTemplateConfigPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void setActProperty(PropertyChangedArgs e) {
        String keyName = e.getProperty().getName();
        TaskTemplateActModel act = this.getActivityModel();
        if (this.currentActNull(act)) {
            return;
        }
        switch (keyName) {
            case "actname": {
                int row = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY_ACT);
                act.setActName(this.getValue(ACTNAME));
                this.setActEntry(row, null, act.getActName());
                break;
            }
            case "description": {
                act.setDescription(this.getValue(DESCRIPTION));
                break;
            }
            case "acttype": {
                String actType = (String)this.getValue(ACTTYPE);
                act.setActType(actType);
                this.getView().setVisible(Boolean.valueOf(act.isReport()), new String[]{BTN_REPORTTEMPLATE_PLAN});
                if (!act.isReport()) {
                    act.getTaskTemplateActTpl().clear();
                }
                this.initComboItemRelevantop(act);
                this.setValue(RELEVANTOP, TaskRelaOperEnum.NULL.getCode());
                this.initComboItemParamlock(act);
                this.setValue(PARAMLOCK, null);
                break;
            }
            case "isapplydetail": {
                act.setIsApplydetail(((Boolean)this.getValue(ISAPPLYDETAIL)).booleanValue());
                break;
            }
            case "isapplymerge": {
                act.setIsApplymerge(((Boolean)this.getValue(ISAPPLYMERGE)).booleanValue());
                break;
            }
            case "isdependlast": {
                act.setIsdependlast((String)this.getValue(ISDEPENDLAST));
                break;
            }
            case "relevantop": {
                if (StringUtils.isEmpty((String)((String)this.getValue(RELEVANTOP)))) {
                    this.setValue(RELEVANTOP, TaskRelaOperEnum.NULL.getCode());
                }
                act.setRelevantop((String)this.getValue(RELEVANTOP));
                break;
            }
            case "paramlock": {
                act.setParamlock((String)this.getValue(PARAMLOCK));
                break;
            }
            case "isnotice": {
                act.setIsNotice(((Boolean)this.getValue(ISNOTICE)).booleanValue());
                this.getView().setEnable(Boolean.valueOf(act.isNotice()), new String[]{NOTICEDISMODE, MESSAGECHANNEL});
                this.getModel().beginInit();
                this.setMsguserEnable(act);
                this.getModel().endInit();
                this.getView().updateView(SETTINGPANEL);
                break;
            }
            case "noticedismode": {
                act.setNoticedismode((String)this.getValue(NOTICEDISMODE));
                this.getModel().beginInit();
                this.setMsguserEnable(act);
                this.getModel().endInit();
                this.getView().updateView(SETTINGPANEL);
                break;
            }
            case "messagechannel": {
                act.setMessagechannel((String)this.getValue(MESSAGECHANNEL));
                break;
            }
            case "noticecontent": {
                act.setNoticecontent(this.getValue(NOTICECONTENT));
                break;
            }
            case "msguser": 
            case "msgusergroup": {
                this.setMsguser(act, keyName);
                break;
            }
            case "parsedim": {
                Object content = this.getValue(NOTICECONTENT);
                if (!(content instanceof Map)) break;
                LocaleString tem = LocaleString.fromMap((Map)((Map)content));
                tem.setLocaleValue(tem.getLocaleValue() + e.getChangeSet()[0].getNewValue());
                this.getModel().setValue(NOTICECONTENT, (Object)tem.getLocaleValue());
                break;
            }
        }
        this.setModify(true);
        this.cacheTaskTemplateModel(this.getTaskTemplateModel());
    }

    private void setMsguserEnable(TaskTemplateActModel act) {
        boolean enable;
        boolean bl = enable = act.isNotice() && act.getNoticedismode() == TaskTemplateModel.DismodeEnum.ASSIGN;
        if (!this.isEnable()) {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{MSGUSER, MSGUSERGROUP});
        }
    }

    private void setReportTemplate(Object returnData) {
        if (null == returnData) {
            return;
        }
        TaskTemplateActModel act = this.getActivityModel();
        if (null == act) {
            return;
        }
        ArrayList<TaskTemplateActTplEntry> newTplEntry = new ArrayList<TaskTemplateActTplEntry>(((List)returnData).size());
        int seq = 1;
        for (Map e : (List)returnData) {
            TaskTemplateActTplEntry subEntry = new TaskTemplateActTplEntry(null);
            subEntry.setSeq(seq++);
            subEntry.setTemplateid((Long)e.get("id"));
            subEntry.setTemplatenumber((String)e.get("number"));
            subEntry.setIsCycletable(((Boolean)e.get("iscycletable")).booleanValue());
            newTplEntry.add(subEntry);
        }
        if (!this.isRepeatTemplate(act, newTplEntry)) {
            act.getTaskTemplateActTpl().clear();
            act.getTaskTemplateActTpl().addAll(newTplEntry);
            this.setModify(true);
            this.cacheTaskTemplateModel(this.getTaskTemplateModel());
        }
    }

    private void setMsguser(TaskTemplateActModel act, String keyName) {
        TaskTemplateModel.UserTypeEnum userType = Objects.equals(MSGUSER, keyName) ? TaskTemplateModel.UserTypeEnum.USER : TaskTemplateModel.UserTypeEnum.GROUP;
        DynamicObjectCollection list = (DynamicObjectCollection)this.getValue(keyName);
        act.getTaskTemplateActMsg().removeIf(e -> e.getUsertype() == userType);
        for (DynamicObject dyn : list) {
            TaskTemplateActMsgEntry subEntry = new TaskTemplateActMsgEntry(null);
            subEntry.setUsertype(userType.getCode());
            subEntry.setUser(Long.valueOf(dyn.getLong("fbasedataid_id")));
            act.getTaskTemplateActMsg().add(subEntry);
        }
    }

    private List<String> getTemplateNumbers() {
        TaskTemplateActModel act = this.getActivityModel();
        if (null == act) {
            return Collections.emptyList();
        }
        return act.getTaskTemplateActTpl().stream().map(e -> e.getTemplatenumber()).collect(Collectors.toList());
    }

    private void saveTaskTemplate() {
        int row = 1;
        if (!this.validateActType()) {
            return;
        }
        for (TaskTemplateActModel act : this.getTaskTemplateModel().getTaskTemplateAct()) {
            if (this.validateAct(act, row++)) continue;
            return;
        }
        TaskTemplateModel model = this.getTaskTemplateModel();
        model.setModifierId(this.getUserId());
        model.setModifyTime(TimeServiceHelper.now());
        DynamicObject t = model.genDynamicObject();
        List actList = model.genActDynamicObject();
        try (TXHandle tx = TX.requiresNew();){
            try {
                BusinessDataWriter.delete((String)"bcm_tasktplactivity", (QFilter[])new QFilter("tasktemplate", "=", t.getPkValue()).toArray());
                if (CollectionUtils.isNotEmpty((Collection)actList)) {
                    BusinessDataWriter.save((IDataEntityType)((DynamicObject)actList.get(0)).getDataEntityType(), (Object[])actList.toArray());
                }
                BusinessDataWriter.delete((IDataEntityType)t.getDataEntityType(), (Object[])new Object[]{t.getPkValue()});
                BusinessDataWriter.save((IDataEntityType)t.getDataEntityType(), (Object[])new Object[]{t});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
        this.writeOperationLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.SAVE.getMultiLangEnumBridge(), (String)"Save"), model.getNumber(), model.getName(), ResultStatusEnum.SUCCESS.getName());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TaskTemplateConfigPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.loadTaskTemplateModel();
    }

    private void addActivity() {
        int row = this.getModel().appendEntryRow(ENTRYENTITY_ACT, this.getModel().getEntryCurrentRowIndex(ENTRYENTITY_ACT), 1)[0];
        TaskTemplateActModel act = new TaskTemplateActModel(this.getTaskTemplateModel());
        this.getTaskTemplateModel().getTaskTemplateAct().add(row, act);
        this.setActEntry(row, act.getId(), act.getActName());
        this.cacheTaskTemplateModel(this.getTaskTemplateModel());
        this.refreshActBaseInfo(act, row);
        this.setModify(true);
        this.showSettingPanel(true);
    }

    private void addTempAct() {
        TaskTemplateModel taskTemplateModel = this.getTaskTemplateModel();
        if (taskTemplateModel.getTaskTemplateAct().isEmpty()) {
            this.addActivity();
            this.setValue(ACTNAME, new LocaleString(ResManager.loadKDString((String)"\u6d3b\u52a81", (String)"TaskTemplateConfigPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            int row = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY_ACT);
            if (this.getModel().getEntryRowCount(ENTRYENTITY_ACT) == 0) {
                this.showSettingPanel(true);
            }
            this.setActEntry(row, null, this.getValue(ACTNAME));
            TaskTemplateActModel act = this.getActivityModel();
            if (act == null) {
                return;
            }
            act.setActName(this.getValue(ACTNAME));
            this.cacheTaskTemplateModel(this.getTaskTemplateModel());
            this.setModify(false);
        }
    }

    private void deleteActivity() {
        if (this.currentActNull(this.getActivityModel())) {
            return;
        }
        int row = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY_ACT);
        Long actId = (Long)this.getModel().getValue(ENTRYENTITY_ACTID, row);
        this.getTaskTemplateModel().getTaskTemplateAct().removeIf(e -> Objects.equals(actId, e.getId()));
        this.cacheTaskTemplateModel(this.getTaskTemplateModel());
        this.getModel().deleteEntryRow(ENTRYENTITY_ACT, row);
        this.setModify(true);
        int newRow = row - 1;
        if (newRow < 0) {
            if (this.getModel().getEntryRowCount(ENTRYENTITY_ACT) > 0) {
                newRow = 0;
            } else {
                this.refreshActBaseinfoNull();
                this.showSettingPanel(false);
                return;
            }
        }
        Long newActId = (Long)this.getModel().getValue(ENTRYENTITY_ACTID, newRow);
        TaskTemplateActModel newAct = this.getTaskTemplateModel().getTaskTemplateAct().stream().filter(e -> Objects.equals(newActId, e.getId())).findFirst().orElseGet(() -> null);
        if (null != newAct) {
            this.refreshActBaseInfo(newAct, newRow);
        }
    }

    private void moveUpAndDown(String eKey) {
        int row;
        if (this.currentActNull(this.getActivityModel())) {
            return;
        }
        int newRow = row = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY_ACT);
        int rowCount = this.getModel().getEntryRowCount(ENTRYENTITY_ACT);
        if (Objects.equals(BTN_UP, eKey)) {
            if (row == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u884c\u5df2\u7ecf\u662f\u7b2c\u4e00\u884c\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"TaskTemplateConfigPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().moveEntryRowUp(ENTRYENTITY_ACT, row);
            newRow = row - 1;
        } else {
            if (row == rowCount - 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u884c\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u884c\uff0c\u4e0d\u80fd\u4e0b\u79fb\u3002", (String)"TaskTemplateConfigPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().moveEntryRowDown(ENTRYENTITY_ACT, row);
            newRow = row + 1;
        }
        Collections.swap(this.getTaskTemplateModel().getTaskTemplateAct(), row, newRow);
        this.cacheTaskTemplateModel(this.getTaskTemplateModel());
        this.getView().updateView(ENTRYENTITY_ACT);
        ((EntryGrid)this.getControl(ENTRYENTITY_ACT)).selectRows(newRow);
        this.setModify(true);
    }

    private boolean validateAct(TaskTemplateActModel act, int row) {
        if (null == act.getActName() || StringUtils.isEmpty((String)((OrmLocaleValue)act.getActName()).getLocaleValue())) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c %s \u4e2a\u6d3b\u52a8\u8bf7\u5f55\u5165\u201c\u540d\u79f0\u201d\u3002", (String)"TaskTemplateConfigPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), row));
            return false;
        }
        if (act.isNotice() && StringUtils.isEmpty((String)act.getMessagechannel())) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c %s \u4e2a\u6d3b\u52a8\u8bf7\u5f55\u5165\u201c\u6d88\u606f\u6e20\u9053\u201d\u3002", (String)"TaskTemplateConfigPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), row));
            return false;
        }
        if (act.isNotice() && act.getNoticedismode() == TaskTemplateModel.DismodeEnum.ASSIGN && CollectionUtils.isEmpty((Collection)act.getTaskTemplateActMsg())) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u4e2a\u6d3b\u52a8\u8bf7\u8f93\u5165\u201c\u7528\u6237/\u7528\u6237\u7ec4\u201d\u3002", (String)"TaskTemplateConfigPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), row));
            return false;
        }
        if (act.isNotice() && (null == act.getNoticecontent() || StringUtils.isEmpty((String)((OrmLocaleValue)act.getNoticecontent()).getLocaleValue()))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8bf7\u5f55\u5165\u201c\u901a\u77e5\u5185\u5bb9\u201d\u3002", (String)"TaskTemplateConfigPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), row));
            return false;
        }
        return !this.isRepeatTemplate(act, act.getTaskTemplateActTpl());
    }

    private boolean validateActType() {
        if (this.isReportTask()) {
            return true;
        }
        boolean flag = true;
        List list = this.getTaskTemplateModel().getTaskTemplateAct();
        HashMap<String, Integer> map = new HashMap<String, Integer>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            TaskTemplateActModel act = (TaskTemplateActModel)list.get(i);
            if (act.getRelevantop() == TaskRelaOperEnum.NULL || act.getRelevantop() == TaskRelaOperEnum.ReportSubmit) continue;
            String key = act.getActType().getType() + "_" + act.getRelevantop().getCode();
            if (map.containsKey(key)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c %s \u4e2a\u6d3b\u52a8\u5b58\u5728\u76f8\u540c\u6d3b\u52a8\u7c7b\u578b\u3001\u5173\u8054\u64cd\u4f5c\u7684\u6d3b\u52a8\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"TaskTemplateConfigPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), map.get(key) + "," + (i + 1)));
                flag = false;
                break;
            }
            map.put(key, i + 1);
        }
        return flag;
    }

    private void useToAllAct() {
        TaskTemplateActModel act = this.getActivityModel();
        if (this.currentActNull(act)) {
            return;
        }
        for (TaskTemplateActModel other : this.getTaskTemplateModel().getTaskTemplateAct()) {
            if (other.getId() == act.getId()) continue;
            other.setIsNotice(act.isNotice());
            other.setNoticedismode(act.getNoticedismode().getCode());
            other.setMessagechannel(act.getMessagechannel());
            other.setNoticecontent(act.getNoticecontent());
            other.getTaskTemplateActMsg().clear();
            for (TaskTemplateActMsgEntry msg : act.getTaskTemplateActMsg()) {
                TaskTemplateActMsgEntry subEntry = new TaskTemplateActMsgEntry(null);
                subEntry.setUsertype(msg.getUsertype().getCode());
                subEntry.setUser(msg.getUser());
                other.getTaskTemplateActMsg().add(subEntry);
            }
        }
        this.cacheTaskTemplateModel(this.getTaskTemplateModel());
        this.setModify(true);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5e94\u7528\u81f3\u6240\u6709\u6d3b\u52a8\u3002", (String)"TaskTemplateConfigPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void openReportTemplate(String eKey) {
        List<Long> sceneIds = this.getTaskTemplateModel().getTaskTemplateScene().stream().map(e -> e.getBasedataid()).collect(Collectors.toList());
        TaskTemplateActModel act = this.getActivityModel();
        if (this.currentActNull(act)) {
            return;
        }
        List tplList = act.getTaskTemplateActTpl();
        List<String> templateNumbers = !act.isCycletable() ? this.getTemplateNumbers() : TaskReportHelper.getTemplateNumbersByCycletable(this.getModelId(), tplList.stream().map(e -> e.getTemplateid()).collect(Collectors.toList()));
        TaskCommonHelper.openReportTemplate(this, eKey, this.getModelId(), templateNumbers, sceneIds, act.isCycletable(), this.isEnable(), null);
    }

    private boolean isRepeatTemplate(TaskTemplateActModel act, List<TaskTemplateActTplEntry> currentActTpls) {
        if (act.getRelevantop() != TaskRelaOperEnum.ReportSubmit || CollectionUtils.isEmpty(currentActTpls)) {
            return false;
        }
        boolean isRepeat = false;
        Map<Long, Set<Long>> allTemplates = this.getAllTemplateByReportSubmit();
        boolean isCycletable = currentActTpls.get(0).isCycletable();
        Map cycleMap = isCycletable ? CycleTablesServiceHelper.getTmplDisCycleTablesDetail((Object)this.getModelId(), currentActTpls.stream().map(e -> e.getTemplateid()).collect(Collectors.toSet())) : null;
        Set allTemplatesNoCurrent = allTemplates.entrySet().stream().filter(e -> !Objects.equals(act.getId(), e.getKey())).collect(Collectors.toSet());
        for (TaskTemplateActTplEntry tpl : currentActTpls) {
            Set tplByCycle;
            Map.Entry exist = null;
            Long tplId = tpl.getTemplateid();
            Set set = tplByCycle = null != cycleMap && cycleMap.containsKey(tplId) ? (Set)cycleMap.get(tplId) : Collections.emptySet();
            if (!isCycletable) {
                exist = allTemplatesNoCurrent.stream().filter(e -> ((Set)e.getValue()).contains(tplId)).findFirst().orElseGet(() -> null);
            } else {
                for (Map.Entry e2 : allTemplatesNoCurrent) {
                    HashSet temp = new HashSet(tplByCycle);
                    temp.retainAll((Collection)e2.getValue());
                    if (!CollectionUtils.isNotEmpty(temp)) continue;
                    exist = e2;
                    break;
                }
            }
            if (null == exist) continue;
            isRepeat = true;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0e\u5df2\u5b58\u5728\u7684\u6d3b\u52a8\u62a5\u8868\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaskTemplateConfigPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            break;
        }
        return isRepeat;
    }

    private Map<Long, Set<Long>> getAllTemplateByReportSubmit() {
        return (Map)ThreadCache.get((Object)"getAllTemplateByReportSubmit", () -> {
            List reportSubmitAct = this.getTaskTemplateModel().getTaskTemplateAct().stream().filter(e -> e.getActType() == TaskActivityTypeEnum.Report && e.getRelevantop() == TaskRelaOperEnum.ReportSubmit).collect(Collectors.toList());
            HashMap allTemplatesMap = new HashMap(reportSubmitAct.size());
            for (TaskTemplateActModel act : reportSubmitAct) {
                HashSet allTemplates = new HashSet(act.getTaskTemplateActTpl().size());
                Set tplByAct = act.getTaskTemplateActTpl().stream().map(e -> e.getTemplateid()).collect(Collectors.toSet());
                if (!act.isCycletable()) {
                    allTemplates.addAll(tplByAct);
                } else {
                    Map cycleMap = CycleTablesServiceHelper.getTmplDisCycleTablesDetail((Object)this.getModelId(), tplByAct);
                    if (null != cycleMap) {
                        allTemplates.addAll(cycleMap.entrySet().stream().flatMap(e -> ((Set)e.getValue()).stream()).collect(Collectors.toSet()));
                    }
                }
                allTemplatesMap.put(act.getId(), allTemplates);
            }
            return allTemplatesMap;
        });
    }

    private void enable(String itemKey) {
        boolean isEnable = Objects.equals("btn_enable", itemKey);
        String updateEnable = isEnable ? "1" : "0";
        OpItemEnum opItemEnum = isEnable ? OpItemEnum.ENABLE : OpItemEnum.DISABLE;
        ArrayList ids = Lists.newArrayList((Object[])new Object[]{this.getTaskTemplateModel().getId()});
        TaskTemplateHelper.updateStatus((List)ids, (boolean)isEnable, (String)updateEnable);
        String objNumber = this.getTaskTemplateModel().getNumber();
        OpNameMultiLangEnumBridge opName = OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)opItemEnum.getMultiLangEnumBridge(), (String)opItemEnum.getCode());
        this.writeSuccessLog(opName, objNumber);
        this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"TaskTemplateConfigPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opName));
    }
}

