/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.taskmanage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillPlugin;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.basedata.MultiF7Results;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.taskmanage.enums.TaskActivityEnum;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateActModel;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateModel;
import kd.fi.bcm.business.template.model.CustomProperty;
import kd.fi.bcm.business.template.model.FilterDimMember;
import kd.fi.bcm.business.template.model.MembProperty;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskCardHelper;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskCommonHelper;
import org.apache.commons.collections4.CollectionUtils;

public class TaskTemplateEditPlugin
extends AbstractBaseFormPlugin
implements IBillPlugin {
    private static final String MODEL = "model";
    private static final String FILTERDIM = "filterdim";
    private static final String SCENE = "scene";
    private static final String DISDIMENSIONENTITY = "disdimensionentity";
    private static final String DISDIMENSIONITEM = "disdimensionitem";
    private static final String ENTRYENTITY_DISDIM = "entryentity_disdim";
    private static final String ENTRYENTITY_ACT = "entryentity_act";
    private static final String PARAM_DEFAULT = "default";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String TYPE = "type";
    private static final String ID = "id";
    private static final String COMEFROM = "comefrom";
    public static final List<String> DEFAULT_FILTERDIM = Arrays.asList(SysDimensionEnum.Scenario.getNumber(), SysDimensionEnum.Year.getNumber(), SysDimensionEnum.Period.getNumber());
    public static final List<SysDimensionEnum> COMBO_DISDIMENSION = Collections.singletonList(SysDimensionEnum.Entity);
    private static final String DEFAULT_DISDIMENSION = SysDimensionEnum.Entity.getMemberTreemodel();
    private static final List<TaskActivityEnum> DEFAULT_ACTIVITY = Arrays.asList(TaskActivityEnum.PeriodManage, TaskActivityEnum.YearCarry, TaskActivityEnum.ExchangeRate, TaskActivityEnum.Invest, TaskActivityEnum.InvestRelation, TaskActivityEnum.Formula, TaskActivityEnum.Integration, TaskActivityEnum.Report, TaskActivityEnum.Check, TaskActivityEnum.Adjust, TaskActivityEnum.Merge, TaskActivityEnum.MergeEcSubmit, TaskActivityEnum.MergeArchive);

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(DISDIMENSIONITEM);
        ((BasedataEdit)this.getControl(FILTERDIM)).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl(SCENE)).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setValue(MODEL, this.getModelId());
        this.initDisDimensionComboItem();
        this.initTaskTypeCommoItem();
        this.initDefault();
        this.getView().setVisible(Boolean.FALSE, new String[]{FILTERDIM, DISDIMENSIONENTITY});
        this.setF7DimName();
    }

    private void initTaskTypeCommoItem() {
        ComboEdit comboItem = (ComboEdit)this.getControl(TYPE);
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(2);
        list.add(new ComboItem(ResManager.getLocaleString((String)"\u7f16\u5236\u4efb\u52a1", (String)"TaskTemplateEditPlugin_3", (String)"fi-bcm-formplugin"), TaskTemplateModel.TypeEnum.REPORT.getCode()));
        if (!this.isRPT()) {
            list.add(new ComboItem(ResManager.getLocaleString((String)"\u5408\u5e76\u4efb\u52a1", (String)"TaskTemplateEditPlugin_4", (String)"fi-bcm-formplugin"), TaskTemplateModel.TypeEnum.MERGE.getCode()));
        }
        comboItem.setComboItems(list);
    }

    public void afterLoadData(EventObject e) {
        this.initDisDimensionComboItem();
        this.initDisDimensionItem();
        this.getView().setVisible(Boolean.FALSE, new String[]{FILTERDIM, DISDIMENSIONENTITY});
        boolean disable = Objects.equals(TaskTemplateModel.EnableEnum.DISABLE.getStatusValue(), this.getValue("enable"));
        this.getView().setEnable(Boolean.valueOf(disable), new String[]{NAME, SCENE, DISDIMENSIONITEM});
        this.getView().setVisible(Boolean.valueOf(disable), new String[]{"confirm"});
        this.setF7DimName();
        this.getView().getModel().setDataChanged(false);
    }

    @Override
    public void click(EventObject evt) {
        String eKey;
        super.click(evt);
        switch (eKey = ((Control)evt.getSource()).getKey()) {
            case "disdimensionitem": {
                this.mulMemberF7Click(eKey);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean isSuccess = e.getOperationResult().getValidateResult().isSuccess();
        if (!isSuccess) {
            log.error("unit test return value:" + e.getOperationResult());
        }
        if (e.getSource() instanceof Save && isSuccess) {
            this.writeOperationLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.SAVE.getMultiLangEnumBridge(), (String)"Save"), this.getModel().getValue(NUMBER).toString(), this.getModel().getValue(NAME).toString(), ResultStatusEnum.SUCCESS.getName());
            this.getView().returnDataToParent(this.getModel().getDataEntity().getPkValue());
            this.getView().close();
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        QFilter modelQf = new QFilter(MODEL, "=", (Object)this.getModelId());
        if (Objects.equals(SCENE, beforeF7SelectEvent.getProperty().getName())) {
            modelQf.and("parent", "!=", (Object)0L);
        }
        beforeF7SelectEvent.getCustomQFilters().add(modelQf);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        this.setF7DimName();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (args.getSource() instanceof Save) {
            this.checkPerm(parameter.getStatus().name().toLowerCase(Locale.ENGLISH));
            if (!this.validateNumber() || !this.validateScene()) {
                args.setCancel(true);
                return;
            }
            if (!OperationStatus.EDIT.equals((Object)parameter.getStatus())) {
                this.setDefaultAct();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "disdimensionitem": {
                if (null == e.getReturnData()) {
                    return;
                }
                this.mulMemberF7CallBack(actionId, e.getReturnData());
                this.setDisdimensionItem();
                break;
            }
        }
    }

    @Override
    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String keyName;
        super.propertyChanged(e);
        switch (keyName = e.getProperty().getName()) {
            case "disdimensionitem": {
                if (!StringUtils.isEmpty((String)((String)e.getChangeSet()[0].getNewValue()))) break;
                this.getPageCache().put(DISDIMENSIONITEM, "[]");
                this.getModel().deleteEntryData(ENTRYENTITY_DISDIM);
                break;
            }
        }
    }

    private void initDisDimensionComboItem() {
        ComboEdit comboItem = (ComboEdit)this.getControl(DISDIMENSIONENTITY);
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(COMBO_DISDIMENSION.size());
        for (SysDimensionEnum dim : COMBO_DISDIMENSION) {
            String dimName = MemberReader.getDimensionNameById((long)MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)dim.getNumber()));
            list.add(new ComboItem(new LocaleString(dimName), dim.getMemberTreemodel()));
        }
        comboItem.setComboItems(list);
    }

    private void initDefault() {
        ArrayList<Long> dimIds = new ArrayList<Long>(DEFAULT_FILTERDIM.size());
        for (String dimNumber : DEFAULT_FILTERDIM) {
            dimIds.add(MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)dimNumber));
        }
        this.setValue(FILTERDIM, dimIds.toArray());
        this.setValue(DISDIMENSIONENTITY, DEFAULT_DISDIMENSION);
        if (((Boolean)this.getFormCustomParam(PARAM_DEFAULT)).booleanValue()) {
            this.setValue(TYPE, TaskTemplateModel.TypeEnum.MERGE.getCode());
        }
    }

    private boolean validateNumber() {
        String number = (String)this.getValue(NUMBER);
        if (StringUtils.isNotEmpty((String)number)) {
            String regEx = "^(?!_)[-a-zA-Z0-9_.]+$";
            Pattern pattern = Pattern.compile(regEx);
            Matcher matcher = pattern.matcher(number);
            String showMsg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d:\u201c\u7f16\u7801\u201d\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"TaskTemplateEditPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), number);
            if (!matcher.matches()) {
                this.getView().showTipNotification(showMsg);
                return false;
            }
            if (number.contains("..") || number.startsWith(".") || number.startsWith("-")) {
                this.getView().showTipNotification(showMsg);
                return false;
            }
        }
        Long pkId = null;
        if (this.getView().getFormShowParameter() instanceof BillShowParameter) {
            pkId = (Long)((BillShowParameter)this.getView().getFormShowParameter()).getPkId();
        }
        QFilter filter = new QFilter(MODEL, "=", (Object)this.getModelId());
        filter.and(NUMBER, "=", (Object)number);
        filter.and(COMEFROM, "=", (Object)0L);
        if (Objects.nonNull(pkId)) {
            filter.and(ID, "!=", (Object)pkId);
        }
        if (QueryServiceHelper.exists((String)"bcm_tasktemplate", (QFilter[])filter.toArray())) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u201c\u7f16\u7801\u201d\u5df2\u5b58\u5728\u3002", (String)"TaskTemplateEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), number));
            return false;
        }
        return true;
    }

    private void mulMemberF7Click(String eKey) {
        Long modelId = this.getModelId();
        String entityNumber = (String)this.getValue(DISDIMENSIONENTITY);
        Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)SysDimensionEnum.getEnumByMemberTreemodel((String)entityNumber).getNumber());
        String dimName = MemberReader.getDimensionNameById((long)dimensionId);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        FormShowParameter para = new FormShowParameter();
        para.setFormId("bcm_mulmemberf7base_tem");
        para.getOpenStyle().setShowType(ShowType.Modal);
        params.put("dimensionid", dimensionId);
        params.put("sign", eKey);
        params.put("KEY_MODEL_ID", modelId.toString());
        if ("bcm_entitymembertree".equals(entityNumber)) {
            params.put("disableRateCls", "true");
        }
        para.setCustomParams(params);
        para.setCaption(String.format(ResManager.loadKDString((String)"%s - \u6210\u5458\u9009\u62e9", (String)"TemplateDimSettingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimName));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, eKey);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    private void initDisDimensionItem() {
        String entityNumber = (String)this.getValue(DISDIMENSIONENTITY);
        DynamicObjectCollection list = (DynamicObjectCollection)this.getValue(ENTRYENTITY_DISDIM);
        ArrayList<FilterDimMember> members = new ArrayList<FilterDimMember>(list.size());
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            boolean isCustom = !LongUtil.isvalidLong((Object)((DynamicObject)list.get(0)).getLong("memberid"));
            Map<Long, DynamicObject> propertyValueMap = null;
            if (isCustom) {
                List propertyValueIds = list.stream().map(e -> e.getLong("propertyvalue")).collect(Collectors.toList());
                propertyValueMap = QueryMemberDetailsHelper.getDefinedPropertyByIds(propertyValueIds).stream().collect(Collectors.toMap(e -> e.getLong(ID), e -> e));
            }
            for (DynamicObject e2 : list) {
                FilterDimMember m = new FilterDimMember();
                m.setId(!isCustom ? e2.getLong("memberid") : e2.getLong("propertyvalue"));
                m.setScope(e2.getInt("range"));
                IDNumberTreeNode memberNode = MemberReader.findMemberById((long)this.getModelId(), (String)(!isCustom ? entityNumber : "bcm_definedpropertyvalue"), (Long)m.getId());
                m.setNumber(memberNode.getNumber());
                m.setName(memberNode.getName());
                if (propertyValueMap != null && isCustom && propertyValueMap.containsKey(m.getId())) {
                    m.setCustom(isCustom);
                    DynamicObject pDyn = propertyValueMap.get(m.getId());
                    MembProperty membProperty = new MembProperty();
                    membProperty.setCustomProperty(new CustomProperty(Long.valueOf(pDyn.getLong("propertyid.id"))));
                    membProperty.setNumber(m.getNumber());
                    membProperty.setName(m.getName());
                    membProperty.getCustomProperty().setNumber(pDyn.getString("propertyid.number"));
                    membProperty.getCustomProperty().setName(pDyn.getString("propertyid.name"));
                    m.setMembProperty(membProperty);
                }
                members.add(m);
            }
        }
        MultiF7Results results = MultiF7Results.buildParamForFd(members, (long)this.getModelId());
        this.setValue(DISDIMENSIONITEM, results.getShowText());
        this.getPageCache().put(DISDIMENSIONITEM, SerializationUtils.toJsonString((Object)results.toList()));
    }

    private void mulMemberF7CallBack(String actionId, Object returnData) {
        DynamicObjectCollection doc = (DynamicObjectCollection)returnData;
        MultiF7Results results = MultiF7Results.buildParam((DynamicObjectCollection)doc, (long)this.getModelId());
        this.setValue(actionId, results.getShowText());
        this.getPageCache().put(actionId, SerializationUtils.toJsonString((Object)results.toList()));
    }

    private void setDisdimensionItem() {
        String json = this.getPageCache().get(DISDIMENSIONITEM);
        if (StringUtils.isEmpty((String)json)) {
            return;
        }
        Long dimensionId = MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)SysDimensionEnum.getEnumByMemberTreemodel((String)((String)this.getValue(DISDIMENSIONENTITY))).getNumber());
        List list = (List)SerializationUtils.fromJsonString((String)json, List.class);
        this.getModel().deleteEntryData(ENTRYENTITY_DISDIM);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY_DISDIM, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Map e = (Map)list.get(i);
            String id = (String)e.get(ID);
            this.getModel().setValue("disdimensionid", (Object)dimensionId, i);
            this.getModel().setValue("range", e.get("scope"), i);
            if (StringUtils.isEmpty((String)((String)e.get("pid")))) {
                this.getModel().setValue("memberid", (Object)id, i);
                continue;
            }
            this.getModel().setValue("propertyvalue", (Object)id, i);
        }
    }

    private void setDefaultAct() {
        if (!((Boolean)this.getFormCustomParam(PARAM_DEFAULT)).booleanValue() || Objects.equals(this.getValue(TYPE), TaskTemplateModel.TypeEnum.REPORT.getCode())) {
            return;
        }
        List<TaskActivityEnum> list = DEFAULT_ACTIVITY;
        long taskTemplateId = GlobalIdUtil.genGlobalLongId();
        this.setValue(ID, taskTemplateId);
        this.getModel().deleteEntryData(ENTRYENTITY_ACT);
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY_ACT, list.size());
        long[] activityIds = GlobalIdUtil.genGlobalLongIds((int)list.size());
        ArrayList<DynamicObject> saveDyns = new ArrayList<DynamicObject>(list.size());
        AtomicInteger incrementer = new AtomicInteger(1);
        for (TaskActivityEnum e : list) {
            int index = incrementer.get() - 1;
            long activityId = activityIds[index];
            TaskTemplateActModel activity = TaskTemplateActModel.getDefaultModel((TaskActivityEnum)e);
            activity.setId(activityId);
            activity.setTaskTemplateId(taskTemplateId);
            saveDyns.add(activity.genDynamicObject(incrementer));
            this.getModel().setValue("activity_id", (Object)activityId, index);
        }
        if (CollectionUtils.isNotEmpty(saveDyns)) {
            SaveServiceHelper.save((DynamicObject[])saveDyns.toArray(new DynamicObject[0]));
        }
    }

    private boolean validateScene() {
        if (!Objects.equals(TaskTemplateModel.TypeEnum.MERGE.getCode(), this.getValue(TYPE))) {
            return true;
        }
        Long pkId = null;
        if (this.getView().getFormShowParameter() instanceof BillShowParameter) {
            pkId = (Long)((BillShowParameter)this.getView().getFormShowParameter()).getPkId();
        }
        QFilter filter = new QFilter(MODEL, "=", (Object)this.getModelId());
        filter.and(TYPE, "=", (Object)TaskTemplateModel.TypeEnum.MERGE.getCode());
        filter.and(COMEFROM, "=", (Object)0L);
        if (Objects.nonNull(pkId)) {
            filter.and(ID, "!=", (Object)pkId);
        }
        HashSet existSceneIds = new HashSet(8);
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"bcm_tasktemplate", (String)"id,scene", (QFilter[])new QFilter[]{filter});
        for (int i = 0; i < dyns.length; ++i) {
            dyns[i].getDynamicObjectCollection(SCENE).stream().forEach(e -> existSceneIds.add(e.getLong("fbasedataid.id")));
        }
        DynamicObject sceneItem = ((DynamicObjectCollection)this.getValue(SCENE)).stream().filter(e -> existSceneIds.contains(e.getLong("fbasedataid.id"))).findFirst().orElseGet(() -> null);
        if (Objects.nonNull(sceneItem)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u201c%s\u201d\u60c5\u666f\u4e0b\u7684\u5408\u5e76\u4efb\u52a1\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaskTemplateEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sceneItem.getString("fbasedataid.name")));
            return false;
        }
        return true;
    }

    private void setF7DimName() {
        Long modelId = this.getModelId();
        LocaleString sceneCaption = new LocaleString(TaskCommonHelper.getSceneTitle(this.getModelId()));
        ((MulBasedataEdit)this.getControl(SCENE)).setCaption(sceneCaption);
        ((MulBasedataProp)this.getModel().getDataEntityType().getAllFields().get(SCENE)).setDisplayName(sceneCaption);
        LocaleString disdimitemCaption = new LocaleString(TaskCardHelper.getDimTitle(modelId, SysDimensionEnum.getEnumByMemberTreemodel((String)((String)this.getValue(DISDIMENSIONENTITY))).getSign()));
        ((TextEdit)this.getControl(DISDIMENSIONITEM)).setCaption(disdimitemCaption);
        ((TextProp)this.getModel().getDataEntityType().getAllFields().get(DISDIMENSIONITEM)).setDisplayName(disdimitemCaption);
    }
}

