/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.taskmanage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.taskmanage.helper.TaskTemplateHelper;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskCommonHelper;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TaskTemplateListPlugin
extends AbstractBaseListPlugin
implements BeforeF7SelectListener {
    private static final String MODEL = "model";
    private static final String BILLLISTAP = "billlistap";
    private static final String COMEFROM = "comefrom";
    private static final String BTN_NEW = "btn_new";
    private static final String BTN_NEW_STANDARD = "btn_new_standard";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_DELETE = "btn_delete";
    public static final String BTN_ENABLE = "btn_enable";
    public static final String BTN_DISABLE = "btn_disable";
    private static final String BTN_BASEINFO = "btn_baseinfo";
    public static final String ENABLE = "1";
    public static final String DISABLE = "0";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((BasedataEdit)this.getControl(MODEL)).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BillList)this.getControl(BILLLISTAP)).addHyperClickListener(this::hyperLinkClick);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(!this.isRPT()), new String[]{BTN_NEW_STANDARD});
        Set limitedModelIds = MemberPermHelper.getLimitedModelListByUser();
        ((BasedataEdit)this.getControl(MODEL)).setQFilter(new QFilter("id", "in", (Object)limitedModelIds));
        this.loadByUserSelect(limitedModelIds);
        this.refreshBillList();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String keyName;
        super.propertyChanged(e);
        switch (keyName = e.getProperty().getName()) {
            case "model": {
                this.refreshBillList();
                break;
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String name = beforeF7SelectEvent.getProperty().getName();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_new": 
            case "btn_new_standard": {
                this.openNew(itemKey);
                break;
            }
            case "btn_baseinfo": {
                this.openEdit(itemKey);
                break;
            }
            case "btn_enable": 
            case "btn_disable": {
                this.enable(itemKey);
                this.refreshBillList();
                break;
            }
            case "btn_refresh": {
                this.refreshBillList();
                break;
            }
            case "btn_delete": {
                if (!this.isSelect()) {
                    return;
                }
                DynamicObjectCollection list = this.getDynBySelectIds();
                DynamicObject dyn = list.stream().filter(e -> Objects.equals(ENABLE, e.getString("enable"))).findFirst().orElseGet(() -> null);
                if (Objects.nonNull(dyn)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6a21\u677f\u5305\u542b\u5904\u4e8e\u542f\u7528\u72b6\u6001\u4e0b\u7684\u6a21\u677f\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"TaskTemplateListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                String msg = ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5220\u9664\u9009\u4e2d\u7684\u6a21\u677f\u5417\uff1f", (String)"TaskTemplateListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_DELETE, (IFormPlugin)this));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            return;
        }
        switch (callBackId) {
            case "btn_delete": {
                this.delete();
                this.refreshBillList();
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "btn_new": 
            case "btn_new_standard": 
            case "btn_baseinfo": {
                if (!LongUtil.isvalidLong((Object)e.getReturnData())) break;
                this.refreshBillList();
                if (Objects.equals(BTN_BASEINFO, actionId)) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TaskTemplateListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    break;
                }
                Long taskTemplateId = (Long)e.getReturnData();
                TaskCommonHelper.openSettingPage(this.getView(), this.getModelId(), taskTemplateId, this.getTaskTemplateName(taskTemplateId));
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        Long taskTemplateId = (Long)((BillListHyperLinkClickEvent)e).getCurrentRow().getPrimaryKeyValue();
        TaskCommonHelper.openSettingPage(this.getView(), this.getModelId(), taskTemplateId, this.getTaskTemplateName(taskTemplateId));
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
    }

    protected void loadByUserSelect(Set<Long> limitedModelIds) {
        Long modelIdFromConfigPage = (Long)this.getFormCustomParam("KEY_MODEL_ID");
        String modelId = null != modelIdFromConfigPage ? String.valueOf(modelIdFromConfigPage) : UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), MODEL);
        if (kd.bos.util.StringUtils.isNotEmpty((String)modelId) && limitedModelIds.contains(Long.valueOf(modelId))) {
            this.setValue(MODEL, modelId);
            this.getPageCache().put("KEY_MODEL_ID", modelId);
        }
    }

    private void refreshBillList() {
        Long modelId = 0L;
        if (null != this.getValue(MODEL)) {
            modelId = this.getModelId();
        }
        this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
        FilterParameter fp = new FilterParameter();
        fp.getQFilters().add(new QFilter(MODEL, "=", (Object)modelId));
        fp.getQFilters().add(new QFilter(COMEFROM, "=", (Object)0L));
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.clearSelection();
        billList.setQueryFilterParameter(fp);
        this.setColumnDimName();
        billList.refresh();
    }

    private boolean validateModel() {
        if (Objects.isNull(this.getValue(MODEL))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4f53\u7cfb\u201d\u3002", (String)"TaskTemplateListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isSelect() {
        boolean isSelect;
        boolean bl = isSelect = ((BillList)this.getControl(BILLLISTAP)).getSelectedRows().size() > 0;
        if (!isSelect) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8bb0\u5f55\u3002", (String)"TaskTemplateListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return isSelect;
    }

    private boolean isSelectMulti() {
        boolean isSelect;
        boolean bl = isSelect = ((BillList)this.getControl(BILLLISTAP)).getSelectedRows().size() > 1;
        if (isSelect) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"TaskTemplateListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return isSelect;
    }

    private void openNew(String actionId) {
        if (!this.validateModel()) {
            return;
        }
        TaskCommonHelper.openNew((AbstractFormPlugin)this, actionId, this.getModelId(), Objects.equals(BTN_NEW_STANDARD, actionId));
    }

    private void openEdit(String actionId) {
        if (!this.isSelect() || this.isSelectMulti()) {
            return;
        }
        Object pkId = ((BillList)this.getControl(BILLLISTAP)).getSelectedRows().get(0).getPrimaryKeyValue();
        TaskCommonHelper.openEdit((AbstractFormPlugin)this, actionId, pkId, this.getModelId());
    }

    private void delete() {
        List<Object> ids = this.getSelectIds();
        DynamicObjectCollection list = TaskTemplateHelper.getDynByIds(ids);
        TaskTemplateHelper.delete(ids);
        String objNumber = StringUtils.join((Iterable)list.stream().map(e -> e.getString("number")).collect(Collectors.toList()), (String)"|");
        OpNameMultiLangEnumBridge opName = OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.DELETE.getMultiLangEnumBridge(), (String)OpItemEnum.DELETE.getCode());
        this.writeSuccessLog(opName, objNumber);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"TaskTemplateListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private List<Object> getSelectIds() {
        List<Object> ids = ((BillList)this.getControl(BILLLISTAP)).getSelectedRows().stream().map(e -> e.getPrimaryKeyValue()).collect(Collectors.toList());
        return ids;
    }

    private DynamicObjectCollection getDynBySelectIds() {
        return TaskTemplateHelper.getDynByIds(this.getSelectIds());
    }

    private String getTaskTemplateName(Long templateId) {
        ArrayList<Long> ids = new ArrayList<Long>(1);
        ids.add(templateId);
        DynamicObjectCollection list = TaskTemplateHelper.getDynByIds(ids);
        return CollectionUtils.isNotEmpty((Collection)list) ? ((DynamicObject)list.get(0)).getString("name") : "";
    }

    private void enable(String itemKey) {
        if (!this.isSelect()) {
            return;
        }
        boolean isEnable = Objects.equals(BTN_ENABLE, itemKey);
        String updateEnable = isEnable ? ENABLE : DISABLE;
        OpNameMultiLangEnumBridge opName = isEnable ? OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.ENABLE.getMultiLangEnumBridge(), (String)OpItemEnum.ENABLE.getCode()) : OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.DISABLE.getMultiLangEnumBridge(), (String)OpItemEnum.DISABLE.getCode());
        List<Object> ids = this.getSelectIds();
        DynamicObjectCollection list = TaskTemplateHelper.getDynByIds(ids);
        List hasDyn = list.stream().filter(e -> Objects.equals(updateEnable, e.getString("enable"))).collect(Collectors.toList());
        List hasIds = hasDyn.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        ids.removeAll(hasIds);
        TaskTemplateHelper.updateStatus(ids, (boolean)isEnable, (String)updateEnable);
        String objNumber = StringUtils.join((Iterable)list.stream().map(e -> e.getString("number")).collect(Collectors.toList()), (String)"|");
        this.writeSuccessLog(opName, objNumber);
        this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"TaskTemplateListPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opName.getDescription()));
    }

    private void setColumnDimName() {
        TaskCommonHelper.setColumnDimName(this.getView(), this.getModelId(), "scene.name", "scenario");
    }
}

