/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.taskmanage;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.taskmanage.helper.TaskRecordServiceHelper;
import kd.fi.bcm.business.template.TemplatePermCrossUtil;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.datatypeutil.DataTypeConvertUtil;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.SearchResult;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskReportHelper;
import kd.fi.bcm.spread.common.TemplateConstant;

public class TaskTplDistributionPlugin
extends AbstractBaseFormPlugin {
    public static final String temCatalog_treeID = "temcatalogtree";
    private static final String ROOT_NODE = "rootNode";
    private static final String CACHE_SEARCH = "cache_search";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String MODEL = "model";
    private static final String TEMPLATE = "template";
    private static final String ENTITY = "entity";
    protected static final String VIEW_COMBO = "viewcombo";
    private static final String ORG_IDS = "orgids";
    private static final String GROUP = "group";
    private static final String TEMPLATE_IDS = "templeteids";
    private static final String TEMPLATELIST_TEMPLATE_IDS = "templatelist_template_ids";
    protected static final String ISCYCLETABLE = "iscycletable";
    private final TreeNodeCheckListener treeNodeCheckListener = new TreeNodeCheckListener(){

        public void treeNodeCheck(TreeNodeCheckEvent evt) {
            TaskTplDistributionPlugin.this.getPageCache().remove(TaskTplDistributionPlugin.TEMPLATELIST_TEMPLATE_IDS);
            TaskTplDistributionPlugin.this.refreshBillList();
        }
    };

    protected boolean isCycletable() {
        return (Boolean)this.getValue(ISCYCLETABLE);
    }

    protected void setCycletable(Object iscycletable) {
        this.setValue(ISCYCLETABLE, iscycletable);
    }

    protected String getTreeKey() {
        return temCatalog_treeID;
    }

    protected boolean showCycleTree() {
        return false;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addListeners();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long modelid = this.getModelId();
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelid));
        if (modelid != 0L) {
            this.setCycletable(this.getFormCustomParam(ISCYCLETABLE));
            this.setTempalteDate2View(modelid, true);
        }
    }

    @Override
    public void click(EventObject evt) {
        String eKey;
        super.click(evt);
        switch (eKey = ((Control)evt.getSource()).getKey()) {
            case "imageup": {
                this.searchNext(-1);
                break;
            }
            case "imagedown": {
                this.searchNext(1);
                break;
            }
        }
    }

    private void searchNext(int i) {
        IPageCache pageCache = this.getPageCache();
        String searchResultCache = pageCache.get(CACHE_SEARCH);
        if (searchResultCache != null) {
            SearchResult result = (SearchResult)ObjectSerialUtil.deSerializedBytes((String)searchResultCache);
            TreeNode next = result.next(i);
            TreeView tree = (TreeView)this.getControl(this.getTreeKey());
            if (next == null) {
                if (i > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"DistributionPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"DistributionPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                }
            } else {
                tree.checkNode(next);
                tree.treeNodeClick(next.getParentid(), next.getId());
                pageCache.put(CACHE_SEARCH, ObjectSerialUtil.toByteSerialized((Object)result));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"DistributionPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    protected List<Long> getTemSelectedAndResultList(String entityid) {
        TreeView tree = (TreeView)this.getControl(entityid);
        List tids = tree.getTreeState().getSelectedNodeId();
        if (tids.isEmpty()) {
            String cache = this.getPageCache().get(TEMPLATE_IDS);
            tids = StringUtils.isNotEmpty((CharSequence)cache) ? (List)SerializationUtils.fromJsonString((String)cache, List.class) : new ArrayList();
            this.getPageCache().remove(TEMPLATE_IDS);
            if (tids.isEmpty()) {
                cache = this.getPageCache().get(TEMPLATELIST_TEMPLATE_IDS);
                List list = tids = StringUtils.isNotEmpty((CharSequence)cache) ? (List)SerializationUtils.fromJsonString((String)cache, List.class) : new ArrayList();
            }
        }
        if (this.isCycletable()) {
            return DataTypeConvertUtil.convert((List)tids);
        }
        DynamicObjectCollection doc = TaskReportHelper.getTemplatecatalogList(this.getModelId());
        LinkedList<String> clist = new LinkedList<String>();
        for (DynamicObject dd : doc) {
            clist.add(dd.getString("id"));
        }
        tids.removeAll(clist);
        return DataTypeConvertUtil.convert(tids);
    }

    private void addListeners() {
        this.addClickListeners("selectorg", "deleteorg", "deletedistribution", "details", "imageup", "imagedown", "btnok");
        this.addItemClickListeners("toolbarap");
        TreeView tree = (TreeView)this.getControl(this.getTreeKey());
        tree.addTreeNodeCheckListener(this.treeNodeCheckListener);
        Search se = (Search)this.getControl("searchap");
        se.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent var1) {
                String text = var1.getText();
                if (text != null && !"".equals(text)) {
                    TaskTplDistributionPlugin.this.searchTemplate(text.trim());
                } else {
                    TaskTplDistributionPlugin.this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                }
            }
        });
    }

    private void searchTemplate(String search) {
        TreeView tree = (TreeView)this.getControl(this.getTreeKey());
        String rootNodeCache = this.getPageCache().get(ROOT_NODE);
        if (rootNodeCache != null) {
            TreeNode root = (TreeNode)ObjectSerialUtil.deSerializedBytes((String)rootNodeCache);
            ArrayList hitNode = new ArrayList();
            root.getTreeNodeListByText(hitNode, search, 999);
            SearchResult result = null;
            if (hitNode.size() > 0) {
                result = new SearchResult(hitNode);
                TreeNode next = result.next(1);
                tree.checkNode(next);
                this.refreshBillList();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5173\u8282\u70b9\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u540d\u79f0\u540e\u641c\u7d22\u3002", (String)"DistributionPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            this.getPageCache().put(CACHE_SEARCH, result == null ? null : ObjectSerialUtil.toByteSerialized((Object)result));
        }
    }

    protected void setTempalteDate2View(long modelid, boolean isSelected) {
        if (this.showCycleTree()) {
            this.setCycleDate2View(modelid);
            return;
        }
        TreeNode rootview = null;
        DynamicObjectCollection temlist = this.getTemplateColls(modelid);
        rootview = TaskReportHelper.getTemplateTree(this.mergeTemplatecatalogList(modelid), temlist, new ArrayList<TreeNode>(), "0", new TreeNode(), this.isCycletable());
        this.getPageCache().put(ROOT_NODE, ObjectSerialUtil.toByteSerialized((Object)rootview));
        TreeView tree = (TreeView)this.getControl(this.getTreeKey());
        tree.deleteAllNodes();
        BCMTreeUtils.spreadAllNode((TreeNode)rootview);
        List rows = (List)this.getView().getFormShowParameter().getCustomParam("rows");
        ArrayList orgIds = new ArrayList();
        ArrayList<TreeNode> selNodes = new ArrayList<TreeNode>();
        for (DynamicObject dd : temlist) {
            if (!isSelected || rows == null || !rows.contains(dd.getString("number"))) continue;
            TreeNode node = rootview.getTreeNode(dd.getString("id"), 10);
            selNodes.add(node);
        }
        tree.addNode(rootview);
        if (selNodes.size() > 0) {
            tree.checkNodes(selNodes);
            this.getPageCache().put(TEMPLATELIST_TEMPLATE_IDS, SerializationUtils.toJsonString(selNodes.stream().map(selNode -> selNode.getId()).collect(Collectors.toList())));
            this.getPageCache().put(TEMPLATE_IDS, SerializationUtils.toJsonString(selNodes.stream().map(selNode -> selNode.getId()).collect(Collectors.toList())));
        }
        this.getPageCache().put(ORG_IDS, SerializationUtils.toJsonString(orgIds));
        this.getView().updateView(this.getTreeKey());
    }

    private DynamicObjectCollection getTemplateColls(long modelid) {
        QFilter filter = TemplatePermCrossUtil.getCommonTemplateQfilter((boolean)false, (Long)modelid, (boolean)false);
        Object pks = this.getView().getFormShowParameter().getCustomParam("tpks");
        if (pks != null) {
            QFilter filter1 = new QFilter("id", "in", pks);
            filter.and(filter1);
        }
        List pagememberSceneids = (List)this.getFormCustomParam("pagememberids");
        TaskRecordServiceHelper.filterTemplateByScenario((QFilter)filter, (Long)modelid, (List)pagememberSceneids);
        DynamicObjectCollection queryResult = this.queryTemplate(filter);
        DynamicObjectCollection result = new DynamicObjectCollection();
        HashSet groupIds = Sets.newHashSet();
        queryResult.forEach(c -> {
            Long groupId = c.getLong(GROUP);
            if (groupIds.add(groupId)) {
                result.add(c);
            }
        });
        if (this.isCycletable()) {
            TaskReportHelper.replaceByCycletable(modelid, result);
        }
        return result;
    }

    protected DynamicObjectCollection queryTemplate(QFilter filter) {
        return TaskReportHelper.queryTemplate(filter);
    }

    private List<Map<String, String>> mergeTemplatecatalogList(long modelid) {
        DynamicObjectCollection doc;
        if (!this.isCycletable()) {
            doc = TaskReportHelper.getTemplatecatalogList(modelid);
        } else {
            List pagememberSceneids = (List)this.getFormCustomParam("pagememberids");
            doc = TaskReportHelper.getCycleTableList(modelid, null, true, pagememberSceneids);
        }
        ArrayList<Map<String, String>> clist = new ArrayList<Map<String, String>>();
        for (DynamicObject dd : doc) {
            if ("0".equals(dd.getString("parent")) && (dd.getString("longnumber") == null || dd.getString("longnumber") == "")) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", dd.getString("id"));
            map.put("name", dd.getString("name"));
            map.put("parentid", dd.getString("parent"));
            clist.add(map);
        }
        return clist;
    }

    protected void refreshBillList() {
    }

    private void setCycleDate2View(long modelid) {
        TreeNode rootview = this.getCycleTableTree();
        this.getPageCache().put(ROOT_NODE, ObjectSerialUtil.toByteSerialized((Object)rootview));
        TreeView tree = (TreeView)this.getControl(this.getTreeKey());
        tree.deleteAllNodes();
        BCMTreeUtils.spreadAllNode((TreeNode)rootview);
        List rows = (List)this.getView().getFormShowParameter().getCustomParam("rows");
        ArrayList<TreeNode> selNodes = new ArrayList<TreeNode>();
        if (rows != null) {
            for (String e : rows) {
                TreeNode node = rootview.getTreeNode(e, 10);
                if (null == node) continue;
                selNodes.add(node);
            }
        }
        tree.addNode(rootview);
        if (selNodes.size() > 0) {
            tree.checkNodes(selNodes);
            this.getPageCache().put(TEMPLATELIST_TEMPLATE_IDS, SerializationUtils.toJsonString(selNodes.stream().map(selNode -> selNode.getId()).collect(Collectors.toList())));
            this.getPageCache().put(TEMPLATE_IDS, SerializationUtils.toJsonString(selNodes.stream().map(selNode -> selNode.getId()).collect(Collectors.toList())));
        }
        this.getView().updateView(this.getTreeKey());
    }

    private TreeNode getCycleTableTree() {
        DynamicObjectCollection dyns;
        DynamicObject rootDyn;
        List pks = (List)this.getView().getFormShowParameter().getCustomParam("tpks");
        if (pks != null && null != (rootDyn = (dyns = TaskReportHelper.getCycleTableList(this.getModelId(), null, true)).stream().filter(e -> Objects.equals(0L, e.getLong("parent"))).findFirst().orElseGet(() -> null))) {
            pks.add(rootDyn.getLong("id"));
        }
        dyns = TaskReportHelper.getCycleTableList(this.getModelId(), pks, true);
        TreeNode cycleTableTree = new TreeNode();
        ArrayList<Map> treeList = new ArrayList<Map>(dyns.size());
        for (DynamicObject e2 : dyns) {
            treeList.add(TemplatePermCrossUtil.getSingeleCataLogMap((DynamicObject)e2));
            if (!TemplateConstant.ROOT_ID.equals(e2.getString(TemplateConstant.PARENT))) continue;
            cycleTableTree.setId(e2.getString(TemplateConstant.ID));
            cycleTableTree.setText(e2.getString(TemplateConstant.NAME));
        }
        BCMTreeUtils.setEntryNode((TreeNode)cycleTableTree, treeList, (String)cycleTableTree.getId());
        return cycleTableTree;
    }
}

