/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.taskmanage;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.container.Tab;
import kd.bos.form.container.Wizard;
import kd.bos.form.control.Control;
import kd.bos.form.control.StepsOption;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.list.BillList;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.taskmanage.enums.TaskActivityTypeEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskStatusEnum;
import kd.fi.bcm.business.taskmanage.helper.UserTaskHelper;
import kd.fi.bcm.business.taskmanage.model.UserTaskInfoModel;
import kd.fi.bcm.business.taskmanage.notice.TaskTplNoticeService;
import kd.fi.bcm.business.taskmanage.status.TaskOperateResult;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.common.model.MessageInfo;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.MainPage;
import kd.fi.bcm.formplugin.pageinteraction.SubPage;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskCommonHelper;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskOpenMenuHelper;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskOperateHelper;
import org.apache.commons.collections4.CollectionUtils;

public class UserTaskInfoListPlugin
extends AbstractBaseListPlugin
implements SubPage {
    private static final String MODEL = "model";
    private static final String BILLLISTAP = "billlistap";
    private static final String WIZARDAP = "usertaskinfowizardap";
    private static final String TABAP = "tabap";
    private static final String OPERATE = "operate";
    private static final String ACTIVITY_NAME = "activity.name";
    private static final String BTN_USERTASK_REFRESH = "btn_usertask_refresh";
    public static final String KEY_CANCEL_USERTASKINFOID = "KEY_CANCEL_USERTASKINFOID";
    private static final String KEY_USERTASKID = "usertaskId";
    private static final String KEY_ACTIVITYID = "activityId";
    private static final String KEY_ORGID = "orgId";
    private static final String KEY_PAGEPARAMS = "KEY_PAGEPARAMS";
    private Map<String, Long> pageParams;

    @Override
    public void registerListener(EventObject e) {
        this.resetAppId();
        super.registerListener(e);
        this.addClickListeners(BTN_USERTASK_REFRESH);
        ((BillList)this.getControl(BILLLISTAP)).addHyperClickListener(this::hyperLinkClick);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initPageParams();
        this.refreshAll();
        this.getView().setVisible(Boolean.valueOf(!this.isShowSlide()), new String[]{"btn_usertask_close"});
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    @Override
    public void click(EventObject evt) {
        String eKey;
        super.click(evt);
        switch (eKey = ((Control)evt.getSource()).getKey()) {
            case "btn_usertask_refresh": {
                this.refreshAll();
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String fieldName;
        switch (fieldName = e.getFieldName()) {
            case "operate": {
                this.finish();
                break;
            }
            case "activity.name": {
                this.openActivityPage();
                break;
            }
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
    }

    private void initPageParams() {
        Long activityId;
        Long usertaskId;
        Long orgId = 0L;
        if (this.isShowSlide()) {
            Tuple<Long, Long, Long> ids = TaskCommonHelper.getUsertaskListParam(this.getPageCache());
            usertaskId = (Long)ids.p1;
            activityId = (Long)ids.p2;
            orgId = (Long)ids.p3;
        } else {
            usertaskId = (Long)this.getFormCustomParam(KEY_USERTASKID);
            Object tempId = this.getFormCustomParam(KEY_ACTIVITYID);
            activityId = Long.valueOf(String.valueOf(tempId));
        }
        this.updatePageParam(KEY_USERTASKID, usertaskId);
        this.updatePageParam(KEY_ACTIVITYID, activityId);
        this.updatePageParam(KEY_ORGID, orgId);
    }

    private Map<String, Long> getPageParams() {
        if (null == this.pageParams) {
            String seria = this.getPageCache().get(KEY_PAGEPARAMS);
            this.pageParams = StringUtils.isNotEmpty((String)seria) ? (Map<Object, Object>)JacksonUtils.fromJson((String)seria, Map.class) : new HashMap<String, Long>(4);
        }
        return this.pageParams;
    }

    private void updatePageParam(String key, Long id) {
        Map<String, Long> map = this.getPageParams();
        map.put(key, id);
        this.getPageCache().put(KEY_PAGEPARAMS, JacksonUtils.toJson(map));
    }

    private Long getCurActivityId() {
        Long activityId = this.getPageParams().get(KEY_ACTIVITYID);
        return null != activityId ? Long.parseLong(String.valueOf(activityId)) : 0L;
    }

    private Long getUsertaskId() {
        Long usertaskId = this.getPageParams().get(KEY_USERTASKID);
        return null != usertaskId ? Long.parseLong(String.valueOf(usertaskId)) : 0L;
    }

    private Long getOrgId() {
        Long orgId = this.getPageParams().get(KEY_ORGID);
        return null != orgId ? Long.parseLong(String.valueOf(orgId)) : 0L;
    }

    private Long getCancelUsertaskinfoId() {
        String seria = this.getPageCache().get(KEY_CANCEL_USERTASKINFOID);
        return StringUtils.isNotEmpty((String)seria) ? Long.parseLong(seria) : 0L;
    }

    private void refreshAll() {
        this.refreshBillList();
        this.initWizard();
    }

    private void refreshBillList() {
        final IPageCache pageCache = this.getPageCache();
        Long usertaskId = this.getUsertaskId();
        if (null == usertaskId) {
            usertaskId = 0L;
        }
        FilterParameter fp = new FilterParameter();
        QFilter filter = UserTaskHelper.getUsertaskinfoFilter((Long)usertaskId);
        fp.getQFilters().add(filter);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.clearSelection();
        billList.getListModel().setProvider((IListDataProvider)new ListDataProvider(){
            private DynamicSimpleProperty operateProperty = new DynamicSimpleProperty();
            {
                this.operateProperty.setName(UserTaskInfoListPlugin.OPERATE);
            }

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection rows = super.getData(arg0, arg1);
                if (rows.isEmpty()) {
                    return rows;
                }
                rows.getDynamicObjectType().getProperties().add((Object)this.operateProperty);
                int index = 0;
                pageCache.put(UserTaskInfoListPlugin.KEY_CANCEL_USERTASKINFOID, "0");
                for (DynamicObject row : rows) {
                    if (!Objects.equals(TaskStatusEnum.FINISH.getCode(), row.getString("status"))) {
                        row.set(UserTaskInfoListPlugin.OPERATE, (Object)OpItemEnum.FINISH.getName());
                    } else if (index == rows.size() - 1 || index + 1 < rows.size() && !Objects.equals(TaskStatusEnum.FINISH.getCode(), ((DynamicObject)rows.get(index + 1)).getString("status"))) {
                        row.set(UserTaskInfoListPlugin.OPERATE, (Object)OpItemEnum.CANCEL.getName());
                        pageCache.put(UserTaskInfoListPlugin.KEY_CANCEL_USERTASKINFOID, row.getString("id"));
                    } else {
                        row.set(UserTaskInfoListPlugin.OPERATE, (Object)"");
                    }
                    ++index;
                }
                return rows;
            }
        });
        billList.setOrderBy("executeseq");
        int totalSize = QueryServiceHelper.queryOne((String)"bcm_usertaskinfo", (String)"count(1)", (QFilter[])filter.toArray()).getInt(0);
        if (totalSize > 20) {
            billList.setPageRow(totalSize);
            billList.setPageRows(totalSize);
        }
        billList.setQueryFilterParameter(fp);
        billList.refresh();
    }

    private void initWizard() {
        int i;
        Long activityId = this.getCurActivityId();
        Wizard ap = (Wizard)this.getControl(WIZARDAP);
        List stepsOptions = ap.getStepsOptions();
        stepsOptions.clear();
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        DynamicObjectCollection list = billList.getListModel().getQueryResult().getCollection();
        int curStepIndex = 0;
        String curStatus = "process";
        for (i = 0; i < list.size(); ++i) {
            DynamicObject e = (DynamicObject)list.get(i);
            TaskStatusEnum statusEnum = TaskStatusEnum.getEnumByCode((String)e.getString("status"));
            StepsOption step = new StepsOption(new LocaleString(statusEnum.getName()), new LocaleString(""));
            if (statusEnum == TaskStatusEnum.PROCESSING) {
                step.setStatus("process");
            } else if (statusEnum == TaskStatusEnum.FINISH) {
                step.setStatus("finish");
            }
            stepsOptions.add(step);
            if (!Objects.equals(e.getLong("activity.id"), activityId)) continue;
            curStepIndex = i;
            curStatus = step.getStatus();
        }
        for (i = 0; i < stepsOptions.size(); ++i) {
            if (i <= curStepIndex) continue;
            ((StepsOption)stepsOptions.get(i)).setTitle(new LocaleString(TaskStatusEnum.READY.getName()));
        }
        ap.setStepsOptions(stepsOptions);
        ap.setWizardStepsOptions(stepsOptions);
        HashMap<String, Object> currentStepMap = new HashMap<String, Object>();
        currentStepMap.put("currentStep", curStepIndex);
        currentStepMap.put("currentStatus", curStatus);
        ap.setWizardCurrentStep(currentStepMap);
        String curTabPage = "";
        TabAp tabAp = new TabAp();
        tabAp.setKey(TABAP);
        for (int i2 = 0; i2 < stepsOptions.size(); ++i2) {
            TabPageAp page = new TabPageAp();
            page.setKey("tabpageap" + i2);
            page.setName(((StepsOption)stepsOptions.get(i2)).getTitle());
            tabAp.getItems().add(page);
            if (i2 != curStepIndex) continue;
            curTabPage = page.getKey();
        }
        this.getView().updateControlMetadata(TABAP, tabAp.createControl());
        Tab tab = (Tab)this.getControl(TABAP);
        tab.activeTab(curTabPage);
        this.customControl(String.valueOf(curStepIndex), curStatus, stepsOptions.size());
    }

    private void finish() {
        if (((BillList)this.getControl(BILLLISTAP)).getSelectedRows().size() == 0) {
            return;
        }
        Long usertaskinfoId = (Long)((BillList)this.getControl(BILLLISTAP)).getSelectedRows().get(0).getPrimaryKeyValue();
        boolean isFinishOper = !Objects.equals(this.getCancelUsertaskinfoId(), usertaskinfoId);
        long orgId = this.getOrgId();
        TaskOperateResult result = TaskOperateHelper.finish(orgId, usertaskinfoId, isFinishOper);
        this.showResultBoxInfo(result);
        List usertaskinfoList = result.getSuccessList();
        if (CollectionUtils.isEmpty((Collection)usertaskinfoList)) {
            return;
        }
        if (null != result.getCurActivityId()) {
            this.updatePageParam(KEY_ACTIVITYID, result.getCurActivityId());
        }
        String opName = isFinishOper ? OpItemEnum.FINISH.getName() : OpItemEnum.CANCEL.getName();
        OpNameMultiLangEnumBridge opNameBridge = isFinishOper ? OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.FINISH.getMultiLangEnumBridge(), (String)"finish") : OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.CANCEL.getMultiLangEnumBridge(), (String)"cancel");
        this.writeLogWithEntityNumber("bcm_usertasklist", opNameBridge, OPDescMultiLangEnumBridge.genUnTransBridge((String)String.format(result.getOperDescriotion(), opName)));
        this.refreshAll();
        this.refreshParentList(StringUtils.isNotEmpty((String)result.getNewRecordStatus()));
        if (isFinishOper == Boolean.TRUE) {
            TaskTplNoticeService.sendMsgByUserTaskInfo((List)usertaskinfoList);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"UserTaskInfoListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void openActivityPage() {
        if (((BillList)this.getControl(BILLLISTAP)).getSelectedRows().size() == 0) {
            return;
        }
        Long usertaskinfoId = (Long)((BillList)this.getControl(BILLLISTAP)).getSelectedRows().get(0).getPrimaryKeyValue();
        UserTaskInfoModel usertaskinfo = UserTaskInfoModel.dynToModel((Long)usertaskinfoId);
        TaskActivityTypeEnum actType = usertaskinfo.getActivityModel().getActType();
        if (StringUtils.isNotEmpty((String)actType.getMenuFormId())) {
            UserSelectModel userSelectModel = TaskOperateHelper.builtUserSelectModel(this.getView(), this.getModelId(), usertaskinfo, this.getOrgId());
            TaskOpenMenuHelper.openActMenuPage(this.getView(), usertaskinfo.getActivityModel(), userSelectModel, t -> TaskCommonHelper.closeUsertaskinfolistBySlide(t));
        }
    }

    private void refreshParentList(boolean refreshRecord) {
        CommandParam backCom = new CommandParam("bcm_usertaskinfolist", "bcm_usertasklist", "refreshlist", this.getUsertaskId(), refreshRecord);
        if (this.isShowSlide()) {
            IFormView parentFormView = this.getView().getView(TaskCommonHelper.getParentPageId(this.getPageCache()));
            this.sendMsg(this.getView(), backCom, parentFormView);
        } else {
            this.sendMsg(this.getView(), backCom);
        }
    }

    private void customControl(String currentStep, String curStatus, int stepSize) {
        CustomControl custom = (CustomControl)this.getView().getControl("customcontrolap");
        JSONObject data = new JSONObject();
        data.put("wizardId", (Object)WIZARDAP);
        data.put("currentStep", (Object)currentStep);
        data.put("currentStatus", (Object)curStatus);
        data.put("stepSize", (Object)stepSize);
        data.put("time", (Object)TimeServiceHelper.now());
        custom.setData((Object)data);
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        if (Objects.equals("afterShowSlideBill", key)) {
            this.initPageParams();
            this.refreshAll();
        }
    }

    private boolean isShowSlide() {
        return null == this.getFormCustomParam(KEY_USERTASKID);
    }

    public void showResultBoxInfo(ResultBox result, String operName) {
        String title = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5b58\u5728\u672a\u5904\u7406\u7684\u8bb0\u5f55\u3002", (String)"MergeControlListPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]), operName);
        List messageList = result.getMessageList();
        List msgs = messageList.stream().map(MessageInfo::getMessage).collect(Collectors.toList());
        this.getView().showMessage(title, Joiner.on((String)"\n").join(msgs), MessageTypes.Default);
    }

    public void showResultBoxInfo(TaskOperateResult result) {
        if (!result.getResult().isSuccess()) {
            if (result.getResult().isError()) {
                this.getView().showErrorNotification(((MessageInfo)result.getResult().getErrorList().get(0)).getMessage());
            } else {
                this.getView().showTipNotification(((MessageInfo)result.getResult().getTipList().get(0)).getMessage());
            }
            return;
        }
        if (null == result.getLastStatusResult().getData() || !((Boolean)result.getLastStatusResult().getData()).booleanValue()) {
            this.showResultBoxInfo(result.getLastStatusResult(), result.getOperName());
        }
    }

    private void sendMsg(IFormView curview, CommandParam com, IFormView pv) {
        FormViewPluginProxy proxy;
        if (pv != null && (proxy = (FormViewPluginProxy)pv.getService(FormViewPluginProxy.class)) != null) {
            proxy.getPlugIns().forEach(e -> {
                if (MainPage.class.isAssignableFrom(e.getClass())) {
                    ((MainPage)MainPage.class.cast(e)).disPatchMsg(pv, com);
                }
            });
            curview.sendFormAction(pv);
        }
    }

    private void resetAppId() {
        String appId = this.getBizAppId();
        if (StringUtils.isEmpty((String)appId) && StringUtils.isEmpty((String)(appId = this.getPageCache().get("appId")))) {
            appId = "cm";
        }
        this.getView().getFormShowParameter().setAppId(appId);
        ThreadCache.put((Object)"appId", (Object)appId);
    }
}

