/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.taskmanage;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.BillList;
import kd.bos.list.ViewCommonUtil;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.userconfig.GridConfigDAO;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.util.ModelUtil;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.mergecontrol.MergeControlService;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.taskmanage.enums.TaskReocrdStatusEnum;
import kd.fi.bcm.business.taskmanage.helper.TaskPermHelper;
import kd.fi.bcm.business.taskmanage.helper.UserTaskHelper;
import kd.fi.bcm.business.taskmanage.model.TaskRecordModel;
import kd.fi.bcm.business.taskmanage.model.UserTaskModel;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CslSchemeEnum;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.batch.BatchInsertService;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.MainPage;
import kd.fi.bcm.formplugin.taskmanage.TaskRecordListProvider;
import kd.fi.bcm.formplugin.taskmanage.UserTaskListProvider;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskCardHelper;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskCommonHelper;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskOpenMenuHelper;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskReportHelper;
import kd.fi.bcm.formplugin.util.EntryGridUtils;
import kd.fi.bcm.formplugin.util.TreeEntryEntityUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;

public class UserTaskListPlugin
extends AbstractBaseListPlugin
implements MainPage,
TreeNodeQueryListener {
    private static final String MODEL = "model";
    private static final String BILLLISTAP = "billlistap";
    private static final String BILLLISTAP_RECORD = "billlistap_record";
    private static final String STATUS = "status";
    private static final String ENDTIME = "endtime";
    private static final String TASKRECORD = "taskrecord";
    private static final String BILLLISTAP_RECORD_CARD = "billlistap_record_card";
    private static final String TREE_ENTITY = "treeentryentity";
    private static final String TREE_FIELD_PRE = "tree_";
    private static final String TREE_FIELD_MEMBERNAME = "tree_membername";
    private static final String BILL_FIELD_MEMBERNAME = "member.name";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_USERTASK_REFRESH = "btn_usertask_refresh";
    private static final String BTN_USERTASK_CLOSE = "btn_usertask_close";
    private static final String BTN_EXPORT = "btn_export";
    private static final String BTN_SHOW_TREE = "show_tree";
    private static final String BTN_SHOW_TABLE = "show_table";
    private static final String PAGE_ITEM = "pageItem";
    public static final String SUB_PAGEID_USERTASKINFOLIST = "SUB_PAGEID_USERTASKINFOLIST";
    private static final Set<String> hideFields = Sets.newHashSet((Object[])new String[]{"tree_taskname", "tree_reportcomplete", "tree_reportchkup", "tree_pcreportcomplete", "tree_pcreportcommit", "tree_pcreportchkup"});
    private Long selectTaskRecordId = 0L;
    private Long selectUserTaskId = 0L;
    private int selectPageIndex = 0;
    private boolean hasAddListener = false;
    private boolean isClearCacheByTreeEntry = true;
    private static final String CURRENT_CACHE_TASK_RECORD_ID = "CacheCurrentTaskRecordId";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BILLLISTAP_RECORD_CARD, BTN_USERTASK_REFRESH, BTN_USERTASK_CLOSE);
        ((BillList)this.getControl(BILLLISTAP)).addHyperClickListener(this::hyperLinkClick);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTITY);
        if (null != treeEntry) {
            treeEntry.addHyperClickListener(this::hyperLinkClick);
            treeEntry.addCellClickListener((TreeNodeQueryListener)this);
        }
        this.createListDataProviderListener();
        if (null != this.getControl("cslscheme")) {
            ((BasedataEdit)this.getControl("cslscheme")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private void createListDataProviderListener() {
        ((BillList)this.getControl(BILLLISTAP)).addCreateListDataProviderListener(args -> args.setListDataProvider((IListDataProvider)new UserTaskListProvider()));
        ((BillList)this.getControl(BILLLISTAP_RECORD)).addCreateListDataProviderListener(args -> args.setListDataProvider((IListDataProvider)new TaskRecordListProvider(this.getModelId(), true)));
        ((BillList)this.getControl(BILLLISTAP_RECORD)).addAfterBindDataListener(this::afterBindDataRecord);
        this.hasAddListener = true;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (null != this.getControl("cslscheme")) {
            ((BasedataEdit)this.getControl("cslscheme")).setQFilter(new QFilter("number", "!=", (Object)CslSchemeEnum.DefaultRate.getNumber()));
        }
        this.createListDataProviderListener();
        if (!this.loadByCustomParam()) {
            this.loadByUserSelect(null);
        }
        this.loadCslschemeByUserSelect();
        this.setPageItem(BTN_SHOW_TABLE);
        this.refreshBillListRecord(true);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.hideEntryFields();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(Objects.equals(BTN_SHOW_TREE, this.getPageItem())), new String[]{"cslscheme"});
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String keyName;
        super.propertyChanged(e);
        switch (keyName = e.getProperty().getName()) {
            case "model": {
                if (null == e.getChangeSet()[0].getNewValue()) {
                    this.getPageCache().put("KEY_MODEL_ID", "0");
                }
                this.loadCslschemeByUserSelect();
            }
            case "refreshtime": {
                this.refreshBillListRecord();
                break;
            }
            case "cslscheme": {
                this.refreshBillList();
                this.saveUserSelect();
                break;
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String name = beforeF7SelectEvent.getProperty().getName();
        if (Objects.equals("cslscheme", name) && null == this.getValue(MODEL)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4f53\u7cfb\u201d\u3002", (String)"TaskTemplateListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_refresh": {
                this.refreshBillListRecord();
                break;
            }
            case "btn_export": {
                this.export();
                break;
            }
            case "show_tree": 
            case "show_table": {
                if (Objects.equals(BTN_SHOW_TREE, itemKey) && null != this.getValue(MODEL) && null == this.getValue("cslscheme")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u7ec4\u7ec7\u89c6\u56fe\u201d\u3002", (String)"UserTaskListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                this.setPageItem(itemKey);
                this.refreshBillList();
                break;
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        String eKey;
        super.click(evt);
        switch (eKey = ((Control)evt.getSource()).getKey()) {
            case "billlistap_record_card": {
                this.refreshBillList();
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        Long usertaskId;
        Long orgId = null;
        if (e instanceof BillListHyperLinkClickEvent) {
            usertaskId = (Long)((BillListHyperLinkClickEvent)e).getCurrentRow().getPrimaryKeyValue();
        } else {
            usertaskId = this.getModel().getEntryRowEntity(TREE_ENTITY, e.getRowIndex()).getLong("usertaskid");
            orgId = this.getModel().getEntryRowEntity(TREE_ENTITY, e.getRowIndex()).getLong("memberid");
        }
        Long activityId = UserTaskModel.dynToModel((Long)usertaskId).getActivity();
        TaskCommonHelper.openUsertaskinfolistBySlide(this.getView(), this.getModelId(), usertaskId, activityId, orgId);
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
    }

    public void afterBindDataRecord(EventObject e) {
        BillList billList = (BillList)this.getControl(BILLLISTAP_RECORD);
        if (this.setPageIndexByTaskRecordId(billList)) {
            return;
        }
        if (billList.getListModel().getQueryResult().getCollection().size() > 0) {
            this.selectTaskRecordId = this.getSelectedRecordIdFromCache();
            this.billListSelectRow(billList, this.selectTaskRecordId);
            if (this.selectTaskRecordId == 0L) {
                this.selectTaskRecordId = (Long)((DynamicObject)billList.getListModel().getQueryResult().getCollection().get(0)).getPkValue();
            }
        }
        this.refreshBillList(this.selectTaskRecordId, this.selectUserTaskId);
    }

    @Override
    public void dealMsg(CommandParam com) {
        this.createListDataProviderListener();
        if (Objects.equals("refreshlist", com.getOperation())) {
            Boolean refreshRecord = CollectionUtils.isNotEmpty(com.getParam()) ? (Boolean)com.getParam().get(1) : Boolean.FALSE;
            this.selectUserTaskId = CollectionUtils.isNotEmpty(com.getParam()) ? (Long)com.getParam().get(0) : 0L;
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl(BILLLISTAP_RECORD)).getSelectedRows();
            if (CollectionUtils.isNotEmpty((Collection)selectedRows)) {
                this.selectTaskRecordId = (Long)selectedRows.get(0).getPrimaryKeyValue();
            }
            this.isClearCacheByTreeEntry = false;
            if (refreshRecord.booleanValue()) {
                this.refreshBillListRecord();
            } else {
                this.refreshBillList(this.selectTaskRecordId, this.selectUserTaskId);
            }
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        String pageItem = this.getPageItem();
        if (Objects.equals(BTN_SHOW_TREE, pageItem)) {
            // empty if block
        }
    }

    private void billListSelectRow(BillList billList, Long id) {
        DynamicObjectCollection list = billList.getListModel().getQueryResult().getCollection();
        int rowIndex = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (!Objects.equals(id, ((DynamicObject)list.get(i)).getPkValue())) continue;
            rowIndex = i;
            break;
        }
        billList.selectRows(this.getStartLine(billList) + rowIndex);
    }

    private int getStartLine(BillList billList) {
        AbstractGrid.GridState entryState = billList.getEntryState();
        int startLine = entryState.getCurrentPageIndex() <= 1 ? 0 : (entryState.getCurrentPageIndex() - 1) * entryState.getPageRows();
        return startLine;
    }

    protected void loadByUserSelect(Set<Long> limitedModelIds) {
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), MODEL);
        if (StringUtils.isNotEmpty((String)modelId)) {
            this.setValue(MODEL, modelId);
            this.getPageCache().put("KEY_MODEL_ID", modelId);
        }
    }

    private void loadCslschemeByUserSelect() {
        DynamicObject dyn;
        if (null == this.getControl("cslscheme")) {
            return;
        }
        Long cslschemeId = null;
        if (LongUtil.isvalidLong((Object)this.getModelId()) && null != (dyn = UserSelectUtil.getUserSelectById(String.valueOf(this.getModelId()), "cslscheme", ModelUtil.queryApp((IFormView)this.getView()))) && LongUtil.isvalidLong((Object)dyn.getLong("cslscheme"))) {
            cslschemeId = dyn.getLong("cslscheme");
        }
        this.setValue("cslscheme", cslschemeId);
        DynamicObject cslschemeDyn = (DynamicObject)this.getValue("cslscheme");
        if (null != cslschemeDyn && Objects.equals(cslschemeDyn.getString("number"), CslSchemeEnum.DefaultRate.getNumber())) {
            this.setValue("cslscheme", null);
        }
    }

    protected boolean loadByCustomParam() {
        Long modelId = (Long)this.getFormCustomParam("KEY_MODEL_ID");
        if (LongUtil.isvalidLong((Object)modelId)) {
            this.setValue(MODEL, modelId);
            this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
            return true;
        }
        return false;
    }

    private void refreshBillListRecord() {
        this.refreshBillListRecord(false);
    }

    private void refreshBillListRecord(boolean init) {
        Long modelId = 0L;
        if (null != this.getValue(MODEL)) {
            modelId = this.getModelId();
        }
        this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
        FilterParameter fp = new FilterParameter();
        fp.getQFilters().add(new QFilter(MODEL, "=", (Object)modelId));
        fp.getQFilters().add(new QFilter(STATUS, "!=", (Object)TaskReocrdStatusEnum.SUSPEND.getValue()));
        if (LongUtil.isvalidLong((Object)modelId)) {
            fp.getQFilters().add(new QFilter("id", "not in", this.getNotExistMemberRecordIds(modelId, fp.getQFilters())));
        }
        BillList billList = (BillList)this.getControl(BILLLISTAP_RECORD);
        billList.clearSelection();
        billList.setQueryFilterParameter(fp);
        billList.setOrderBy("id");
        this.getPageIndexByTaskRecordId(billList, fp.getQFilters());
        if (!init) {
            billList.refresh();
        }
    }

    private void refreshBillList() {
        Long taskRecordId = this.getSelectedRecordId();
        if (LongUtil.isvalidLong((Object)taskRecordId)) {
            this.refreshBillList(taskRecordId);
        }
    }

    private void refreshBillList(Long taskRecordId) {
        TaskRecordModel recordModel;
        if (null == taskRecordId) {
            taskRecordId = 0L;
        }
        this.selectTaskRecordId = taskRecordId;
        TaskRecordModel taskRecordModel = recordModel = LongUtil.isvalidLong((Object)taskRecordId) ? TaskRecordModel.dynObjToTaskRecordModel((Long)taskRecordId) : null;
        if (Objects.equals(BTN_SHOW_TABLE, this.getPageItem())) {
            this.refreshBillList(this.getUsertaskFilter(taskRecordId, recordModel));
            this.getModel().deleteEntryData(TREE_ENTITY);
        } else {
            this.refreshBillList(this.getUsertaskFilter(0L, null));
            this.refreshTreeEntry(taskRecordId, this.isClearCacheByTreeEntry);
        }
        this.setColumnDimName(recordModel);
    }

    private void refreshBillList(QFilter filter) {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.clearSelection();
        billList.setQueryFilterParameter(new FilterParameter(filter, null));
        billList.refresh();
    }

    private QFilter getUsertaskFilter(Long taskRecordId, TaskRecordModel recordModel) {
        QFilter filter = new QFilter(TASKRECORD, "=", (Object)taskRecordId);
        if (null != recordModel) {
            filter.and(TaskPermHelper.getDisMemberPerm((Long)recordModel.getTaskTemplateId()));
        }
        return filter;
    }

    private void refreshBillList(Long taskRecordId, Long userTaskId) {
        this.refreshBillList(taskRecordId);
        if (userTaskId != 0L) {
            this.billListSelectRow((BillList)this.getControl(BILLLISTAP), userTaskId);
        }
    }

    private void getPageIndexByTaskRecordId(BillList billList, List<QFilter> qFilters) {
        String taskRecordIdStr;
        if (!this.hasAddListener) {
            this.createListDataProviderListener();
        }
        if (!LongUtil.isvalidLong((Object)(taskRecordIdStr = TaskOpenMenuHelper.getAppCacheTaskRecordId()))) {
            return;
        }
        this.getPageCache().put(CURRENT_CACHE_TASK_RECORD_ID, taskRecordIdStr);
        Long taskRecordId = Long.valueOf(taskRecordIdStr);
        DynamicObjectCollection list = QueryServiceHelper.query((String)"bcm_taskrecord", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]), (String)billList.getOrderBy());
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        int pageRow = billList.getEntryState().getPageRows();
        int curIndex = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (!Objects.equals(((DynamicObject)list.get(i)).getLong("id"), taskRecordId)) continue;
            curIndex = i;
            break;
        }
        this.selectPageIndex = curIndex / pageRow + 1;
        this.selectTaskRecordId = taskRecordId;
    }

    private boolean setPageIndexByTaskRecordId(BillList billList) {
        if (this.selectPageIndex > 0 && this.selectPageIndex != billList.getEntryState().getCurrentPageIndex()) {
            int tempIndex = this.selectPageIndex;
            this.selectPageIndex = 0;
            billList.setPageIndex(tempIndex);
            return true;
        }
        return false;
    }

    private Set<Long> getNotExistMemberRecordIds(Long modelId, List<QFilter> qFilters) {
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bcm_taskrecord", (String)"id,tasktemplate,tasktemplate.disdimensionentity", (QFilter[])qFilters.toArray(new QFilter[0]));
        Set<Long> taskRecordIds = dyns.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        QFilter filter = new QFilter(TASKRECORD, "in", taskRecordIds);
        filter.and(TaskPermHelper.getDisMemberPerm((Long)modelId, (String)SysDimensionEnum.Entity.getMemberTreemodel()));
        DynamicObjectCollection usertaskDyns = QueryServiceHelper.query((String)"bcm_usertask", (String)"id,taskrecord,member", (QFilter[])filter.toArray());
        Set hasMemberRecordIds = usertaskDyns.stream().map(e -> e.getLong(TASKRECORD)).collect(Collectors.toSet());
        taskRecordIds.removeIf(e -> hasMemberRecordIds.contains(e));
        return taskRecordIds;
    }

    private void setColumnDimName(TaskRecordModel recordModel) {
        String disDimension = null != recordModel ? recordModel.getTaskTemplateModel().getDisdimensionentity() : SysDimensionEnum.Entity.getMemberTreemodel();
        SysDimensionEnum dimEnum = SysDimensionEnum.getEnumByMemberTreemodel((String)disDimension);
        TaskCommonHelper.setColumnDimName(this.getView(), this.getModelId(), BILL_FIELD_MEMBERNAME, (null != dimEnum ? dimEnum : SysDimensionEnum.Entity).getSign());
        TaskCommonHelper.setColumnDimName(this.getView(), this.getModelId(), TREE_FIELD_MEMBERNAME, (null != dimEnum ? dimEnum : SysDimensionEnum.Entity).getSign());
    }

    private Long getSelectedRecordId() {
        BillList recordBillList = (BillList)this.getControl(BILLLISTAP_RECORD);
        if (recordBillList.getSelectedRows().size() > 0) {
            ListSelectedRow taskRecordListSelectedRow = recordBillList.getSelectedRows().get(0);
            Long taskRecordId = (Long)taskRecordListSelectedRow.getPrimaryKeyValue();
            this.getPageCache().put(CURRENT_CACHE_TASK_RECORD_ID, String.valueOf(taskRecordId));
            return (Long)taskRecordListSelectedRow.getPrimaryKeyValue();
        }
        this.getPageCache().remove(CURRENT_CACHE_TASK_RECORD_ID);
        return 0L;
    }

    private long getSelectedRecordIdFromCache() {
        String cacheTaskRecordId = this.getPageCache().get(CURRENT_CACHE_TASK_RECORD_ID);
        return StringUtil.isEmptyString((String)cacheTaskRecordId) ? 0L : LongUtil.toLong((Object)cacheTaskRecordId);
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        if (this.getModel().getEntryEntity(TREE_ENTITY).size() < evt.getRowKey() + 1) {
            return;
        }
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTITY);
        int[] re = this.addChildRows(evt.getRowKey(), this.getSelectedRecordId());
        if (re == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8d22\u5e74\u671f\u95f4\u4e0b\uff0c\u6ca1\u6709\u6709\u6548\u7684\u4e0b\u7ea7\u7ec4\u7ec7\u8282\u70b9\u3002", (String)"MergeControlListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            treeEntry.collapse(evt.getRowKey());
            return;
        }
        IClientViewProxy po = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        po.invokeControlMethod(TREE_ENTITY, "collapseAllNode", new Object[]{re});
        treeEntry.selectRows(evt.getRowKey());
    }

    private int[] addChildRows(int rowKey, Long taskRecordId) {
        DynamicObject obj = this.getModel().getEntryRowEntity(TREE_ENTITY, rowKey);
        if (obj == null) {
            return new int[0];
        }
        long pid = (Long)obj.get("id");
        try {
            DynamicObject next = this.getModel().getEntryRowEntity(TREE_ENTITY, rowKey + 1);
            if (next != null && next.getLong("pid") == pid && StringUtils.isNotEmpty((String)next.getString("number"))) {
                return new int[0];
            }
        }
        catch (Exception t) {
            log.error(String.format("UserTaskListPlugin - addChildRows:%n%s", ThrowableHelper.toString((Exception)t)));
        }
        DynamicObjectCollection orgChildren = this.queryUsertaskTreeEntry(taskRecordId, pid, null, false, BTN_SHOW_TREE);
        return TreeEntryEntityUtil.insertTreeEntry(this.getView(), orgChildren, this.getTreeEntryProperties(), rowKey, pid, false);
    }

    private List<String> getTreeEntryProperties() {
        EntryType entityType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(TREE_ENTITY);
        List<String> properties = entityType.getProperties().stream().map(e -> e.getName()).collect(Collectors.toList());
        properties.removeAll(Lists.newArrayList((Object[])new String[]{"seq", "isGroupNode", "pid"}));
        return properties;
    }

    private void refreshTreeEntry(Long taskRecordId, boolean isClearCache) {
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTITY);
        if (null == treeEntry) {
            return;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(TREE_ENTITY);
        DynamicObject rowDyn = this.getModel().getEntryRowEntity(TREE_ENTITY, rowIndex);
        long rowId = null != rowDyn ? (Long)rowDyn.getPkValue() : 0L;
        this.getModel().deleteEntryData(TREE_ENTITY);
        String pageItem = this.getPageItem();
        DynamicObjectCollection orgTree = this.queryUsertaskTreeEntry(taskRecordId, null, pageItem, true, BTN_SHOW_TREE);
        if (CollectionUtils.isNotEmpty((Collection)orgTree)) {
            List<String> properties = this.getTreeEntryProperties();
            if (Objects.equals(BTN_SHOW_TREE, pageItem)) {
                int parentLevel = ((DynamicObject)orgTree.get(0)).getInt("level");
                int[] re = TreeEntryEntityUtil.createTreeEntryFp(this.getView(), orgTree, properties, String.valueOf(parentLevel), false);
                if (isClearCache) {
                    treeEntry.setCollapse(false);
                    treeEntry.collapse(re);
                    treeEntry.selectRows(0);
                }
            } else {
                BatchInsertService<DynamicObject> bs = new BatchInsertService<DynamicObject>(TREE_ENTITY, properties.toArray(new String[0]));
                bs.batchCreateNewEntryRow(this.getView(), (Collection<DynamicObject>)orgTree, data -> {
                    ArrayList mcRowData = new ArrayList(properties.size());
                    properties.forEach(p -> mcRowData.add(data.get(p)));
                    return mcRowData.toArray();
                });
            }
        }
        this.getView().updateView(TREE_ENTITY);
        if (!isClearCache) {
            if (Objects.equals(BTN_SHOW_TREE, pageItem)) {
                this.expandNodes(treeEntry, taskRecordId);
                DynamicObjectCollection list = this.getModel().getEntryEntity(TREE_ENTITY);
                for (int i = 0; i < list.size(); ++i) {
                    if (!Objects.equals(rowId, ((DynamicObject)list.get(i)).getPkValue())) continue;
                    treeEntry.selectRows(i);
                    break;
                }
            } else {
                treeEntry.selectRows(rowIndex);
            }
        }
    }

    private void expandNodes(TreeEntryGrid treeEntry, Long taskRecordId) {
        ArrayList<Integer> rows = new ArrayList<Integer>(10);
        ArrayList exids = new ArrayList(10);
        Object expandNodes = treeEntry.getExpandNodes();
        if (Objects.nonNull(expandNodes)) {
            exids.addAll((List)expandNodes);
        }
        while (CollectionUtils.isNotEmpty(exids)) {
            DynamicObjectCollection objs = this.getModel().getEntryEntity(treeEntry.getKey());
            for (int i = 1; i < objs.size(); ++i) {
                if (!exids.contains(((DynamicObject)objs.get(i)).getString("id"))) continue;
                rows.add(i);
                exids.remove(((DynamicObject)objs.get(i)).getString("id"));
                break;
            }
            if (CollectionUtils.isEmpty(rows)) break;
            for (Integer rid : rows) {
                this.addChildRows(rid, taskRecordId);
            }
            rows.clear();
        }
    }

    private DynamicObjectCollection queryUsertaskTreeEntry(Long taskRecordId, Long pid, String pageItem, boolean isContainSelf, String propType) {
        if (!LongUtil.isvalidLong((Object)taskRecordId)) {
            return new DynamicObjectCollection();
        }
        TaskRecordModel recordModel = TaskRecordModel.dynObjToTaskRecordModel((Long)taskRecordId);
        FixedItem fixedItem = this.getFixedItem(recordModel);
        if (null == fixedItem) {
            return new DynamicObjectCollection();
        }
        if (null == pid) {
            pid = fixedItem.getEntityId();
        }
        long modelId = this.getModelId();
        DynamicObjectCollection orgTree = MergeControlService.getInstance().getOrgTree(fixedItem, pid, pageItem, isContainSelf, false);
        List allOrgId = orgTree.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        Set noPermMembers = PermissionServiceImpl.getInstance((Long)modelId).matchNoPermMembers(MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity"), "bcm_entitymembertree", allOrgId);
        HashMap<Long, Long> toBaseMemberMap = new HashMap<Long, Long>(orgTree.size());
        HashMap<Long, Set<Long>> baseRealIdMap = new HashMap<Long, Set<Long>>(orgTree.size());
        for (DynamicObject dyn : orgTree) {
            long realId = dyn.getLong("id");
            Long baseId = TaskReportHelper.change2BaseOrg(modelId, realId);
            toBaseMemberMap.put(realId, baseId);
            baseRealIdMap.computeIfAbsent(baseId, k -> new HashSet(16)).add(realId);
        }
        DynamicObjectCollection usertaskList = this.queryUsertask(recordModel, toBaseMemberMap.values().stream().collect(Collectors.toSet()));
        Map<Long, DynamicObject> usertaskMap = usertaskList.stream().collect(Collectors.toMap(e -> e.getLong("member"), e -> e));
        DynamicObject schemeDyn = (DynamicObject)this.getValue("cslscheme");
        String cslschemeName = schemeDyn.getString("name");
        Map<String, Object> infoMap = UserTaskListProvider.getUsertaskListShowInfo(usertaskList, recordModel, schemeDyn.getLong("id"), baseRealIdMap);
        boolean isTreeEntry = true;
        String fieldPre = TREE_FIELD_PRE;
        DynamicObjectType entityType = (DynamicObjectType)this.getModel().getDataEntityType().getAllEntities().get(TREE_ENTITY);
        DynamicObjectCollection result = new DynamicObjectCollection();
        for (DynamicObject org : orgTree) {
            DynamicObject usertaskDyn;
            DynamicObject rowObj = new DynamicObject(entityType);
            Long orgId = org.getLong("id");
            rowObj.set("id", (Object)orgId);
            if (isTreeEntry) {
                rowObj.set("memberid", org.get("memberid"));
                rowObj.set("membernumber", (Object)org.getString("number"));
                rowObj.set("level", org.get("level"));
                rowObj.set("isleaf", org.get("isleaf"));
                rowObj.set(TREE_FIELD_MEMBERNAME, (Object)org.getString("name"));
            }
            rowObj.set(fieldPre + "taskname", (Object)cslschemeName);
            if (!noPermMembers.contains(orgId) && null != (usertaskDyn = usertaskMap.get(toBaseMemberMap.get(orgId)))) {
                if (isTreeEntry) {
                    rowObj.set("usertaskid", (Object)usertaskDyn.getLong("id"));
                }
                UserTaskListProvider.buildUsertaskData(rowObj, usertaskDyn, infoMap, fieldPre, orgId);
            }
            result.add((Object)rowObj);
        }
        return result;
    }

    private DynamicObjectCollection queryUsertask(TaskRecordModel recordModel, Set<Long> memberIds) {
        QFilter filter = this.getUsertaskFilter(recordModel.getId(), recordModel);
        if (CollectionUtils.isNotEmpty(memberIds)) {
            filter.and("member", "in", memberIds);
        }
        return UserTaskHelper.queryUserTaskList((QFilter)filter, (String)"id,member,activity,status,finishnum,totalnum,dimensiontype,member as member_id", (String)"id");
    }

    private FixedItem getFixedItem(TaskRecordModel recordModel) {
        DynamicObject modelDy = (DynamicObject)this.getValue(MODEL);
        DynamicObject cslschemeDy = (DynamicObject)this.getValue("cslscheme");
        if (null == cslschemeDy) {
            return null;
        }
        Map filterMember = recordModel.getFilterMemberInfo(true);
        Tuple scenarioDy = (Tuple)filterMember.get(SysDimensionEnum.Scenario.getNumber());
        Tuple yearDy = (Tuple)filterMember.get(SysDimensionEnum.Year.getNumber());
        Tuple periodDy = (Tuple)filterMember.get(SysDimensionEnum.Period.getNumber());
        IDNumberTreeNode entityRoot = MemberReader.findEntityMemberByNum((String)modelDy.getString("number"), (String)"Entity").getChildren().stream().filter(e -> Objects.equals(cslschemeDy.get("number"), e.getProperty("cslscheme"))).findFirst().orElseGet(() -> null);
        if (null == entityRoot) {
            return null;
        }
        FixedItem ctx = FixedItem.newOne((SimpleItem)SimpleItem.newOne((Object)modelDy.getLong("id"), (String)modelDy.getString("number")), (SimpleItem)SimpleItem.newOne((Object)scenarioDy.p1, (String)((String)scenarioDy.p2)), (SimpleItem)SimpleItem.newOne((Object)yearDy.p1, (String)((String)yearDy.p2)), (SimpleItem)SimpleItem.newOne((Object)periodDy.p1, (String)((String)periodDy.p2)), (SimpleItem)SimpleItem.newOne((Object)entityRoot.getId(), (String)entityRoot.getNumber()));
        return ctx;
    }

    private void hideEntryFields() {
        try {
            EntryGridUtils.createDefaultSetting(this.getView(), TREE_ENTITY, fieldApInfos -> {
                for (GridConfigurationRow field : fieldApInfos) {
                    if (!hideFields.contains(field.getFieldKey())) continue;
                    field.setHide(true);
                }
            });
        }
        catch (Exception ex) {
            log.error("hide field error", (Throwable)ex);
        }
    }

    private String getPageItem() {
        String seria = this.getPageCache().get(PAGE_ITEM);
        return StringUtils.isNotEmpty((String)seria) ? seria : BTN_SHOW_TABLE;
    }

    private void setPageItem(String pageItem) {
        boolean showTree = Objects.equals(BTN_SHOW_TREE, pageItem);
        this.getView().setVisible(Boolean.valueOf(!showTree), new String[]{BTN_SHOW_TREE});
        this.getView().setVisible(Boolean.valueOf(showTree), new String[]{BTN_SHOW_TABLE});
        this.getPageCache().put(PAGE_ITEM, pageItem);
        this.getView().setVisible(Boolean.valueOf(showTree), new String[]{TREE_ENTITY, "cslscheme"});
        this.getView().setVisible(Boolean.valueOf(!showTree), new String[]{BILLLISTAP, BTN_EXPORT});
    }

    private void saveUserSelect() {
        String modelId = UserSelectUtil.getF7SelectId(this.getView(), MODEL);
        String cslschemeId = UserSelectUtil.getF7SelectId(this.getView(), "cslscheme");
        if (!LongUtil.isvalidLong((Object)modelId) || !LongUtil.isvalidLong((Object)cslschemeId)) {
            return;
        }
        UserSelectModel userModel = new UserSelectModel();
        userModel.setApplication(ModelUtil.queryApp((IFormView)this.getView()));
        userModel.setModel(modelId);
        userModel.setCslScheme(cslschemeId);
        userModel.setModifier(RequestContext.getOrCreate().getUserId());
        UserSelectUtil.savetUserSelect(userModel);
    }

    private void syncUserConfig(String pageItem) {
        if (Objects.equals(BTN_SHOW_TREE, pageItem)) {
            List<Map> billListSettingList2 = EntryGridUtils.getSettingByBillList(this.getView(), BILLLISTAP);
            EntryGridUtils.updateSetting(this.getView(), GridConfigDAO.buildUserConfigKey((String)this.getView().getEntityId(), (String)TREE_ENTITY), GridConfigurationRow.class, fieldApInfos -> {
                for (GridConfigurationRow row : fieldApInfos) {
                    Map billListRow = this.getBillListRow(billListSettingList2, row.getFieldKey());
                    if (null == billListRow) continue;
                    row.setHide(!ViewCommonUtil.getListColumnVisible((boolean)false, (boolean)false, (int)((Integer)billListRow.get("visible"))));
                    row.setFreeze(((Boolean)billListRow.get("fixed")).booleanValue());
                    row.setTextAlign((String)billListRow.get("textAlign"));
                }
            });
        }
        if (Objects.equals(BTN_SHOW_TABLE, pageItem)) {
            List<GridConfigurationRow> fieldApInfos2 = EntryGridUtils.getSetting(this.getView(), TREE_ENTITY);
            EntryGridUtils.updateSetting(this.getView(), EntryGridUtils.buildUserConfigKeyByBillList((BillList)this.getControl(BILLLISTAP)), Map.class, billListSettingList -> {
                for (GridConfigurationRow row : fieldApInfos2) {
                    Map billListRow = this.getBillListRow((List<Map>)billListSettingList, row.getFieldKey());
                    if (null == billListRow) continue;
                    billListRow.put("visible", row.isHide() ? 0 : 63);
                    billListRow.put("fixed", row.isFreeze());
                    billListRow.put("textAlign", row.getTextAlign());
                }
            });
        }
    }

    private Map getBillListRow(List<Map> billListSettingList, String fieldKey) {
        boolean isMemberName = Objects.equals(TREE_FIELD_MEMBERNAME, fieldKey);
        String fkey = isMemberName ? BILL_FIELD_MEMBERNAME : fieldKey;
        String pre = isMemberName ? "" : TREE_FIELD_PRE;
        Map billListRow = billListSettingList.stream().filter(e -> Objects.equals(fkey, pre + e.get("listFieldKey"))).findFirst().orElseGet(() -> null);
        return billListRow;
    }

    private void export() {
        Long taskRecordId = this.getSelectedRecordId();
        String emptyMsg = ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5f15\u51fa\u3002", (String)"UserTaskListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        if (!LongUtil.isvalidLong((Object)taskRecordId)) {
            this.getView().showTipNotification(emptyMsg);
            return;
        }
        TaskRecordModel recordModel = TaskRecordModel.dynObjToTaskRecordModel((Long)taskRecordId);
        DynamicObjectCollection dyns = this.getExportData(recordModel);
        if (CollectionUtils.isEmpty((Collection)dyns)) {
            this.getView().showTipNotification(emptyMsg);
            return;
        }
        String filename = Joiner.on((String)"-").join((Object)ResManager.loadKDString((String)"\u6211\u7684\u4efb\u52a1", (String)"UserTaskListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Object)recordModel.getTaskTemplateModel().getName(), new Object[]{this.getPageItem()});
        String taskTemplateNumber = recordModel.getTaskTemplateModel().getNumber();
        try {
            this.exportData("bcm_usertask", (DynamicObject[])dyns.toArray((Object[])new DynamicObject[0]), filename);
            this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.EXPORT.getMultiLangEnumBridge(), (String)"export"), new OPDescMultiLangEnumBridge("%1$s \u5bfc\u51fa\u6210\u529f\u3002", "UserTaskListPlugin_3", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{taskTemplateNumber})));
        }
        catch (Exception e) {
            this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.EXPORT.getMultiLangEnumBridge(), (String)"export"), new OPDescMultiLangEnumBridge("%1$s \u5bfc\u51fa\u5931\u8d25\u3002", "UserTaskListPlugin_4", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{taskTemplateNumber})));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    private DynamicObjectCollection getExportData(TaskRecordModel recordModel) {
        String memberIdKey;
        DynamicObjectCollection rows;
        if (Objects.equals(BTN_SHOW_TABLE, this.getPageItem())) {
            rows = this.queryUsertask(recordModel, null);
            UserTaskListProvider.buildUsertaskListData(rows);
            memberIdKey = "member_id";
        } else {
            rows = this.queryUsertaskTreeEntry(recordModel.getId(), null, BTN_SHOW_TABLE, true, BTN_SHOW_TABLE);
            memberIdKey = "id";
        }
        if (CollectionUtils.isNotEmpty((Collection)rows)) {
            rows.getDynamicObjectType().getProperties().add((Object)new DynamicSimpleProperty("member", Map.class, Collections.emptyMap()));
            for (DynamicObject row : rows) {
                IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)recordModel.getModelId(), (Long)row.getLong(memberIdKey));
                HashMap member = Maps.newHashMap();
                member.put("name", node.getName());
                member.put("number", node.getNumber());
                row.set("member", (Object)member);
            }
        }
        return rows;
    }

    private void exportData(String entityName, DynamicObject[] dys, String filename) throws Exception {
        String memberName = TaskCardHelper.getDimTitle(this.getModelId(), SysDimensionEnum.Entity.getSign());
        String memberNumber = String.format(ResManager.loadKDString((String)"%s\u7f16\u7801", (String)"TaskCommonHelper_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), memberName);
        Object importTemplateId = ExportUtil.getImportTemplateId((String)entityName);
        FormView formView = (FormView)this.getView();
        String routeAppId = formView.getFormShowParameter().getServiceAppId();
        List<String> showFields = this.getUserConfigFields();
        String url = ExportUtil.export((DynamicObject[])dys, (Object)importTemplateId, (String)routeAppId, (String)entityName, (String)(filename + ".xlsx"), format -> {
            int i;
            format.fields.removeIf(e -> !showFields.contains(e));
            format.properties.keySet().removeIf(e -> !showFields.contains(e));
            List member = (List)format.flexColumnDisplay.get("member");
            if (null != member) {
                member.clear();
                List flex = (List)format.flexColumn.get("member");
                for (i = 0; i < flex.size(); ++i) {
                    if (Objects.equals("member.number", flex.get(i))) {
                        member.add(memberNumber);
                    }
                    if (!Objects.equals(BILL_FIELD_MEMBERNAME, flex.get(i))) continue;
                    member.add(memberName);
                }
            }
            ArrayList<String> showFields2 = new ArrayList<String>(showFields);
            showFields2.removeIf(e -> !format.fields.contains(e));
            for (i = 0; i < showFields2.size(); ++i) {
                String field = (String)showFields2.get(i);
                Collections.swap(format.fields, format.fields.indexOf(field), i);
            }
        });
        if (StringUtils.isNotEmpty((String)url)) {
            this.downloadFile(url, "bcm_usertasklist", "1G2FW/G3YIL8");
        }
    }

    private List<String> getUserConfigFields() {
        String memberKey;
        List<String> fields;
        if (Objects.equals(BTN_SHOW_TABLE, this.getPageItem())) {
            List billListSettingList = EntryGridUtils.getSettingByBillList(this.getView(), BILLLISTAP);
            billListSettingList = billListSettingList.stream().filter(e -> ViewCommonUtil.getListColumnVisible((boolean)false, (boolean)false, (int)((Integer)e.get("visible")))).collect(Collectors.toList());
            billListSettingList.sort(Comparator.comparingInt(e -> (Integer)e.get("seq")));
            fields = billListSettingList.stream().map(e -> (String)e.get("listFieldKey")).collect(Collectors.toList());
            memberKey = BILL_FIELD_MEMBERNAME;
        } else {
            List<GridConfigurationRow> fieldApInfos = EntryGridUtils.getSetting(this.getView(), TREE_ENTITY);
            fields = fieldApInfos.stream().filter(e -> !e.isHide()).map(e -> e.getFieldKey()).collect(Collectors.toList());
            fields = fields.stream().map(e -> e.replace(TREE_FIELD_PRE, "")).collect(Collectors.toList());
            memberKey = "membername";
        }
        for (int i = 0; i < fields.size(); ++i) {
            if (!Objects.equals(memberKey, fields.get(i))) continue;
            fields.remove(i);
            fields.add(i, "member");
        }
        return fields;
    }
}

