/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.taskmanage;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.taskmanage.enums.TaskActivityTypeEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskStatusEnum;
import kd.fi.bcm.business.taskmanage.helper.TaskRecordServiceHelper;
import kd.fi.bcm.business.taskmanage.helper.UserTaskHelper;
import kd.fi.bcm.business.taskmanage.model.TaskRecordModel;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateActModel;
import kd.fi.bcm.business.taskmanage.model.TaskTmplStatus;
import kd.fi.bcm.business.taskmanage.status.AbstractStatus;
import kd.fi.bcm.business.taskmanage.status.OperateStatus;
import kd.fi.bcm.business.taskmanage.status.StatusContext;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskCommonHelper;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskOperateHelper;
import org.apache.commons.collections4.CollectionUtils;

public class UserTaskListProvider
extends ListDataProvider {
    public static final String REPORTPROGRESS_MAP = "reportProgressMap";
    public static final String ACT_MAP = "actMap";
    public static final String SHOWSTATUS_MAP = "showStatusMap";
    public static final String ListSelectFields = "id,member,activity,status,finishnum,totalnum,dimensiontype,member as member_id";
    public static final String TASKNAME = "taskname";
    public static final String SHOWSTATUS = "showstatus";
    public static final String ACTIVITYNAME = "activityname";
    public static final String PROGRESSBAR = "progressbar";
    public static final String REPORTCOMPLETE = "reportcomplete";
    public static final String REPORTCOMMIT = "reportcommit";
    public static final String REPORTCHKUP = "reportchkup";
    public static final String PC = "pc";
    private static List<DynamicSimpleProperty> showProps = Lists.newArrayList((Object[])new DynamicSimpleProperty[]{new DynamicSimpleProperty("taskname", String.class, (Object)""), new DynamicSimpleProperty("showstatus", String.class, (Object)""), new DynamicSimpleProperty("activityname", String.class, (Object)""), new DynamicSimpleProperty("progressbar", String.class, (Object)"0"), new DynamicSimpleProperty("reportcomplete", String.class, (Object)"-"), new DynamicSimpleProperty("reportcommit", String.class, (Object)"-")});

    public DynamicObjectCollection getData(int arg0, int arg1) {
        DynamicObjectCollection rows = super.getData(arg0, arg1);
        IDataEntityProperty p = rows.getDynamicObjectType().getProperties().stream().filter(e -> Objects.equals("member", e.getName())).findFirst().orElseGet(() -> null);
        if (null == p) {
            return rows;
        }
        UserTaskListProvider.buildUsertaskListData(rows);
        return rows;
    }

    public static void buildUsertaskListData(DynamicObjectCollection rows) {
        if (CollectionUtils.isEmpty((Collection)rows)) {
            return;
        }
        if (!rows.getDynamicObjectType().getProperties().containsKey((Object)"activity")) {
            rows.getDynamicObjectType().getProperties().add((Object)new DynamicSimpleProperty("activity", Long.class, (Object)0L));
            Map<Long, Long> activityIdMap = QueryServiceHelper.query((String)"bcm_usertask", (String)"id,activity", (QFilter[])new QFilter("id", "in", rows.stream().map(e -> e.getLong("id")).collect(Collectors.toList())).toArray()).stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getLong("activity")));
            rows.forEach(e -> e.set("activity", activityIdMap.get(e.getLong("id"))));
        }
        showProps.forEach(e -> rows.getDynamicObjectType().getProperties().add(e));
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)rows.get(0)).getLong("id"), (String)"bcm_usertask");
        TaskRecordModel taskRecord = UserTaskHelper.loadTaskRecord((Long)dyn.getLong("taskrecord.id"));
        Map<String, Object> infoMap = UserTaskListProvider.getUsertaskListShowInfo(rows, taskRecord, null, null);
        Map<Long, String> cslSchemeNames = UserTaskListProvider.getCslschemeNames(taskRecord.getModelId());
        for (DynamicObject row : rows) {
            String cslSchemeNamesName = cslSchemeNames.get(MemberReader.findEntityMemberById((Long)taskRecord.getModelId(), (Long)row.getLong("member_id")).getProperty("cslscheme.id"));
            row.set(TASKNAME, (Object)cslSchemeNamesName);
            UserTaskListProvider.buildUsertaskData(row, row, infoMap, "", null);
        }
    }

    public static void buildUsertaskData(DynamicObject row, DynamicObject usertaskDyn, Map<String, Object> infoMap, String fieldPre, Long realOrgId) {
        Map reportProgressMap = (Map)infoMap.get(REPORTPROGRESS_MAP);
        Map actMap = (Map)infoMap.get(ACT_MAP);
        Map showStatusMap = (Map)infoMap.get(SHOWSTATUS_MAP);
        Long usertaskId = usertaskDyn.getLong("id");
        row.set(fieldPre + PROGRESSBAR, (Object)TaskCommonHelper.convertProgress((Pair<Integer, Integer>)Pair.onePair((Object)usertaskDyn.getInt("finishnum"), (Object)usertaskDyn.getInt("totalnum"))));
        TaskTemplateActModel act = (TaskTemplateActModel)actMap.get(usertaskDyn.getLong("activity"));
        if (null == act) {
            row.set(fieldPre + SHOWSTATUS, (Object)TaskStatusEnum.READY.getName());
            return;
        }
        row.set(fieldPre + SHOWSTATUS, showStatusMap.get(usertaskId));
        row.set(fieldPre + ACTIVITYNAME, (Object)act.getActNameString());
        TaskTmplStatus reportPregress = (TaskTmplStatus)reportProgressMap.get(usertaskId);
        if (null != reportPregress && reportPregress.getTotal() > 0) {
            row.set(fieldPre + REPORTCOMPLETE, (Object)TaskCommonHelper.convertProgress((Pair<Integer, Integer>)Pair.onePair((Object)reportPregress.getEcCount().getComplete(), (Object)reportPregress.getTotal())));
            row.set(fieldPre + REPORTCOMMIT, (Object)TaskCommonHelper.convertProgress((Pair<Integer, Integer>)Pair.onePair((Object)reportPregress.getEcCount().getCommit(), (Object)reportPregress.getTotal())));
            if (!StringUtils.isBlank((CharSequence)fieldPre)) {
                row.set(fieldPre + REPORTCHKUP, (Object)TaskCommonHelper.convertProgress((Pair<Integer, Integer>)Pair.onePair((Object)reportPregress.getEcCount().getChkup(), (Object)reportPregress.getTotal())));
                TaskTmplStatus.TmplCount pcCount = (TaskTmplStatus.TmplCount)reportPregress.getPcStatusMap().get(realOrgId);
                if (pcCount != null) {
                    row.set(fieldPre + PC + REPORTCOMPLETE, (Object)TaskCommonHelper.convertProgress((Pair<Integer, Integer>)Pair.onePair((Object)pcCount.getComplete(), (Object)reportPregress.getTotal())));
                    row.set(fieldPre + PC + REPORTCOMMIT, (Object)TaskCommonHelper.convertProgress((Pair<Integer, Integer>)Pair.onePair((Object)pcCount.getCommit(), (Object)reportPregress.getTotal())));
                    row.set(fieldPre + PC + REPORTCHKUP, (Object)TaskCommonHelper.convertProgress((Pair<Integer, Integer>)Pair.onePair((Object)pcCount.getChkup(), (Object)reportPregress.getTotal())));
                }
            }
        }
    }

    private static Map<TaskActivityTypeEnum, Set<Long>> getOrgIdsGroupByType(DynamicObjectCollection rows, Map<Long, TaskTemplateActModel> actMap) {
        HashMap<TaskActivityTypeEnum, Set<Long>> map = new HashMap<TaskActivityTypeEnum, Set<Long>>(8);
        for (DynamicObject row : rows) {
            TaskTemplateActModel act = actMap.get(row.getLong("activity"));
            if (null == act) continue;
            map.computeIfAbsent(act.getActType(), k -> new HashSet(rows.size())).add(TaskOperateHelper.getEntityMemberId(row));
        }
        return map;
    }

    public static Map<String, Object> getUsertaskListShowInfo(DynamicObjectCollection rows, TaskRecordModel taskRecord, Long schemeId, Map<Long, Set<Long>> baseShareIdMap) {
        HashMap<String, Object> infoMap = new HashMap<String, Object>(8);
        long modelId = taskRecord.getModelId();
        Map<Long, Long> usertaskAndOrgIds = rows.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> TaskOperateHelper.getEntityMemberId(e)));
        Map reportProgressMap = TaskRecordServiceHelper.getUserTaskReportProgress((TaskRecordModel)taskRecord, usertaskAndOrgIds, (Long)schemeId, baseShareIdMap);
        Map actMap = UserTaskHelper.queryActivityMap(rows.stream().map(e -> e.getLong("activity")).collect(Collectors.toSet()));
        Map actStatusMap = UserTaskHelper.queryUserTaskInfoStatus((DynamicObjectCollection)rows);
        HashMap<Long, String> showStatusMap = new HashMap<Long, String>(rows.size());
        StatusContext ctx = new StatusContext();
        ctx.setFilterMembers(Long.valueOf(modelId), taskRecord.getFilterMemberInfo(false), null, null);
        ctx.setOrgIds(UserTaskListProvider.getOrgIdsGroupByType(rows, actMap));
        ctx.setCache(true);
        for (DynamicObject row : rows) {
            Long usertaskId = row.getLong("id");
            TaskTemplateActModel act = (TaskTemplateActModel)actMap.get(row.getLong("activity"));
            if (null == act) continue;
            if (Objects.equals(TaskStatusEnum.FINISH.getCode(), row.getString("status"))) {
                showStatusMap.put(usertaskId, TaskStatusEnum.FINISH.getName());
                continue;
            }
            String actStatus = (String)actStatusMap.get(usertaskId);
            ctx.setEntityMemberId(Long.valueOf(TaskOperateHelper.getEntityMemberId(row)));
            ctx.init(act, actStatus);
            OperateStatus status = AbstractStatus.getInstance((StatusContext)ctx);
            showStatusMap.put(usertaskId, status.show());
        }
        infoMap.put(REPORTPROGRESS_MAP, reportProgressMap);
        infoMap.put(ACT_MAP, actMap);
        infoMap.put(SHOWSTATUS_MAP, showStatusMap);
        return infoMap;
    }

    private static Map<Long, String> getCslschemeNames(Long modelId) {
        DynamicObjectCollection list = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id,name", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
        return list.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getString("name")));
    }
}

