/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.taskmanage;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.taskmanage.enums.TaskRelaOperEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskStatusEnum;
import kd.fi.bcm.business.taskmanage.helper.TaskRecordServiceHelper;
import kd.fi.bcm.business.taskmanage.helper.UserTaskHelper;
import kd.fi.bcm.business.taskmanage.model.TaskRecordModel;
import kd.fi.bcm.business.taskmanage.model.TaskRecordModelFilterMemEntry;
import kd.fi.bcm.business.taskmanage.model.UserTaskInfoModel;
import kd.fi.bcm.business.taskmanage.model.UserTaskModel;
import kd.fi.bcm.business.template.model.DynaEntityObject;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.SubPage;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.MultiKeyMap;

public class UserTaskTreePlugin
extends AbstractBaseFormPlugin
implements SubPage,
TreeNodeClickListener {
    private static final String TREEVIEW = "treeview";
    private static final String SHOWTYPE = "showtype";
    private static final String CF_CTSTATUS = "combofield_ct";
    private static final String ORGID = "ORGID";
    private static final String ORG_SCOPE = "orgScope";
    private static final String IS_CYCLETABLE = "isCycletable";
    private static final String IS_CTSTATUS = "isCTStatus";
    private static final String DIMF7ID = "DIMF7ID";
    private static final List<String> dimF7KeyMap = Lists.newArrayList((Object[])new String[]{SysDimensionEnum.Scenario.getNumber(), SysDimensionEnum.Year.getNumber(), SysDimensionEnum.Period.getNumber()});
    private static final String KEY_FOCUS_USERTASKINFO_ID = "KEY_FOCUS_USERTASKINFO_ID";
    private static final String ID_SEP = "_";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshPage(this.getView().getFormShowParameter().getCustomParams());
    }

    @Override
    public void dealMsg(CommandParam com) {
        if (Objects.equals(com.getOperation(), "refresh")) {
            this.refreshPage((Map)com.getParam().get(0));
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        TreeView tree = (TreeView)this.getControl(TREEVIEW);
        TreeView.TreeState treeState = tree.getTreeState();
        Map selectNode = treeState.getFocusNode();
        boolean isParent = (Boolean)selectNode.get("isParent");
        if (!isParent) {
            this.sendMsgByClickTreeNode(selectNode);
        } else {
            this.sendMsgByClean();
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String keyName;
        super.propertyChanged(e);
        switch (keyName = e.getProperty().getName()) {
            case "showtype": {
                TreeView tree = (TreeView)this.getControl(TREEVIEW);
                Map focusNode = tree.getTreeState().getFocusNode();
                this.initTree(this.getModelId(), this.getUserTaskOrgId());
                this.focusTreeNode(tree, focusNode);
                break;
            }
            case "combofield_ct": {
                this.sendMsgByCTStatus();
                break;
            }
        }
    }

    private Long getUserTaskOrgId() {
        String orgId = this.getPageCache().get(ORGID);
        return StringUtils.isNotEmpty((String)orgId) ? Long.parseLong(orgId) : 0L;
    }

    private void refreshPage(Map<String, Object> params) {
        Long modelId = (Long)params.get("KEY_MODEL_ID");
        Object orgIdObj = params.get("orgId");
        String orgScope = (String)params.get(ORG_SCOPE);
        if (null == orgIdObj) {
            return;
        }
        Long orgId = Long.valueOf(String.valueOf(orgIdObj));
        String orgName = (String)params.get("orgName");
        Boolean isCycletable = (Boolean)params.get(IS_CYCLETABLE);
        isCycletable = null != isCycletable ? isCycletable : Boolean.FALSE;
        Boolean isCTStatus = (Boolean)params.get(IS_CTSTATUS);
        isCTStatus = null != isCTStatus ? isCTStatus : Boolean.TRUE;
        HashMap dimF7IdMap = new HashMap(4);
        if (null != modelId) {
            this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
            this.getPageCache().put(ORGID, String.valueOf(orgId));
            this.getPageCache().put(ORG_SCOPE, orgScope);
            this.getPageCache().put(IS_CYCLETABLE, String.valueOf(isCycletable));
            this.getPageCache().put(IS_CTSTATUS, String.valueOf(isCTStatus));
            dimF7KeyMap.stream().forEach(e -> dimF7IdMap.put(e, null != params.get(e) ? Long.parseLong(String.valueOf(params.get(e))) : 0L));
            this.getPageCache().put(DIMF7ID, this.toByteSerialized(dimF7IdMap));
        }
        this.setOrglabel(orgName);
        this.initTree(modelId, orgId);
        this.setValue(CF_CTSTATUS, String.valueOf(isCTStatus));
        this.getView().setVisible(isCycletable, new String[]{CF_CTSTATUS});
    }

    private void setOrglabel(String orgName) {
        ((Label)this.getControl("orglabel")).setText(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%s", (String)"ReportListPlugin_113", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgName));
    }

    private void initTree(Long modelId, Long orgId) {
        TreeView tree = (TreeView)this.getControl(TREEVIEW);
        tree.deleteAllNodes();
        Map<String, Long> dimF7IdMap = this.getDimF7IdMap();
        String nullDim = dimF7KeyMap.stream().filter(e -> !LongUtil.isvalidLong(dimF7IdMap.get(e))).findFirst().orElseGet(() -> null);
        if (StringUtils.isNotEmpty((String)nullDim)) {
            this.sendMsgByClean();
            return;
        }
        Set taskrecordIds = UserTaskHelper.getTaskRecordIdByDataSet((Long)modelId, dimF7IdMap);
        String orgScope = this.getPageCache().get(ORG_SCOPE) == null ? "me" : this.getPageCache().get(ORG_SCOPE);
        Set<Long> orgIds = this.getAllOrgIds(modelId, orgId, orgScope);
        List usertaskList = UserTaskHelper.loadUserTask((Long)modelId, orgIds, (Set)taskrecordIds);
        if (CollectionUtils.isEmpty((Collection)usertaskList)) {
            this.sendMsgByClean();
            return;
        }
        Set userTaskIds = usertaskList.stream().map(DynaEntityObject::getId).collect(Collectors.toSet());
        Map<Long, UserTaskModel> userTaskModelMap = usertaskList.stream().collect(Collectors.toMap(DynaEntityObject::getId, t -> t));
        taskrecordIds = usertaskList.stream().map(UserTaskModel::getTaskrecord).collect(Collectors.toSet());
        Map taskRecordMap = UserTaskHelper.loadTaskRecordMap(taskrecordIds);
        List usertaskinfoList = UserTaskHelper.loadUserTaskInfo(userTaskIds, null, (boolean)true);
        if (CollectionUtils.isEmpty((Collection)usertaskinfoList)) {
            this.sendMsgByClean();
            return;
        }
        String oldSelectNodeId = this.getPageCache().get(KEY_FOCUS_USERTASKINFO_ID);
        TreeNode selectNode = null;
        boolean isCycletable = this.isCycletable();
        MultiKeyMap isCycletableMap = TaskRecordServiceHelper.getActCyclableByRecord(taskrecordIds);
        String showType = (String)this.getValue(SHOWTYPE);
        HashMap<Long, List> orgToTaskInfoMap = new HashMap<Long, List>();
        for (UserTaskInfoModel userTaskInfoModel : usertaskinfoList) {
            long userTaskId = userTaskInfoModel.getUsertask();
            long memberId = userTaskModelMap.get(userTaskId).getMember();
            List taskInfoList = orgToTaskInfoMap.computeIfAbsent(memberId, k -> new ArrayList(10));
            taskInfoList.add(userTaskInfoModel);
        }
        Set orgIdNotSort = orgToTaskInfoMap.keySet();
        List orgIdSort = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,level,dseq", (QFilter[])new QFilter("id", "in", orgIdNotSort).toArray(), (String)"level, dseq").stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        ArrayList treeList = new ArrayList(10);
        for (Long memberId : orgIdSort) {
            List userTaskInfos = (List)orgToTaskInfoMap.get(memberId);
            HashMap<String, String> orgInfoMap = new HashMap<String, String>(8);
            orgInfoMap.put("id", String.valueOf(memberId));
            orgInfoMap.put("name", this.showOrgNodeName(modelId, memberId, showType));
            orgInfoMap.put("parentid", "0");
            orgInfoMap.put("type", "orginfo");
            treeList.add(orgInfoMap);
            for (UserTaskInfoModel userTaskInfo : userTaskInfos) {
                HashMap<String, String> userTaskInfoNode = new HashMap<String, String>(8);
                Long taskRecordId = userTaskInfo.getUserTaskModel().getTaskrecord();
                if (isCycletableMap.get((Object)taskRecordId, (Object)userTaskInfo.getActivity()) != null && !Objects.equals(isCycletable, isCycletableMap.get((Object)taskRecordId, (Object)userTaskInfo.getActivity()))) continue;
                String userTaskInfoId = String.valueOf(userTaskInfo.getId());
                userTaskInfoNode.put("id", userTaskInfoId);
                userTaskInfoNode.put("name", this.getUsertaskinfoNodeName(userTaskInfo, (TaskRecordModel)taskRecordMap.get(taskRecordId), showType));
                userTaskInfoNode.put("parentid", String.valueOf(memberId));
                userTaskInfoNode.put("type", "usertaskinfo");
                treeList.add(userTaskInfoNode);
                if (!Objects.equals(userTaskInfoId, oldSelectNodeId)) continue;
                selectNode = new TreeNode(String.valueOf(memberId), userTaskInfoId, "");
            }
        }
        TreeNode treeRoot = new TreeNode();
        treeRoot.setId("0");
        treeRoot.setText("root");
        treeRoot.setParentid("");
        BCMTreeUtils.setEntryNode((TreeNode)treeRoot, treeList, (String)treeRoot.getId());
        tree.addNode(treeRoot);
        if (null == selectNode && CollectionUtils.isNotEmpty((Collection)treeRoot.getChildren())) {
            String parentId = ((TreeNode)treeRoot.getChildren().get(0)).getId();
            List children = ((TreeNode)treeRoot.getChildren().get(0)).getChildren();
            if (children != null && !children.isEmpty()) {
                selectNode = new TreeNode(parentId, ((TreeNode)children.get(0)).getId(), "");
            }
        }
        if (null != selectNode) {
            tree.focusNode(selectNode);
            this.sendMsgByClickTreeNode(tree.getTreeState().getFocusNode());
        } else {
            this.sendMsgByClean();
        }
    }

    public Pair<String, String> getUsertaskNodeKey(TaskRecordModel taskRecordModel) {
        List list = taskRecordModel.getTaskRecordModelFilterMemEntry();
        CharSequence[] members = new String[list.size()];
        CharSequence[] ids = new String[list.size()];
        for (TaskRecordModelFilterMemEntry member : list) {
            String dimNumber = member.getDimensionNumber();
            String membermodel = member.getDimensionMembermodel();
            Long memberId = member.getMemberId();
            IDNumberTreeNode memberNode = MemberReader.findMemberById((long)this.getModelId(), (String)membermodel, (Long)memberId);
            if (null == memberNode) continue;
            int index = this.getFilterdimIndex(dimNumber);
            members[index] = memberNode.getName();
            ids[index] = String.valueOf(memberId);
        }
        return Pair.onePair((Object)String.join((CharSequence)ID_SEP, ids), (Object)String.join((CharSequence)" ", members));
    }

    private String getUsertaskinfoNodeName(UserTaskInfoModel usertaskinfo, TaskRecordModel recordModel, String showType) {
        String status = usertaskinfo.getStatus();
        String statusName = StringUtils.isNotEmpty((String)status) ? TaskStatusEnum.getEnumByCode((String)status).getName() : "";
        String taskNumber = recordModel.getTaskTemplateModel().getNumber();
        String taskName = recordModel.getTaskTemplateModel().getName();
        StringBuilder taskInfo = new StringBuilder();
        switch (showType) {
            case "1": {
                taskInfo.append(taskName).append(" ");
                break;
            }
            case "2": {
                taskInfo.append(taskNumber).append(" ");
                break;
            }
            case "3": {
                taskInfo.append(taskNumber).append(" ").append(taskName).append(" ");
                break;
            }
        }
        return String.format("[%s] %s%s", statusName, taskInfo, usertaskinfo.getActivityModel().getActNameString());
    }

    private String showOrgNodeName(long modelId, long orgId, String showType) {
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        StringBuilder orgInfo = new StringBuilder();
        switch (showType) {
            case "1": {
                orgInfo.append(orgNode.getName()).append(" ");
                break;
            }
            case "2": {
                orgInfo.append(orgNode.getNumber()).append(" ");
                break;
            }
            case "3": 
            case "4": {
                orgInfo.append(orgNode.getNumber()).append(" ").append(orgNode.getName()).append(" ");
            }
        }
        return orgInfo.toString();
    }

    private Set<Long> getAllOrgIds(Long modelId, Long orgId, String orgScope) {
        HashSet<Long> orgIds = new HashSet<Long>();
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        orgIds.add(orgId);
        if (!orgNode.isLeaf() && !"me".equals(orgScope)) {
            if ("alllevel".equals(orgScope)) {
                orgIds.addAll(orgNode.getAllChildrenIds());
            } else if ("directlevel".equals(orgScope)) {
                orgIds.addAll(orgNode.getChildrenIds());
            } else if ("allleaf".equals(orgScope)) {
                HashSet<Long> leafIds = new HashSet(16);
                List allLeafChildren = orgNode.getAllChildren(2);
                for (IDNumberTreeNode node : allLeafChildren) {
                    if (node.getId() <= 0L) continue;
                    leafIds.add(node.getId());
                }
                leafIds = QueryMemberDetailsHelper.change2BaseMember(leafIds);
                return leafIds;
            }
        }
        orgIds = QueryMemberDetailsHelper.change2BaseMember(orgIds);
        return orgIds;
    }

    private int getFilterdimIndex(String dimnumber) {
        if (Objects.equals(SysDimensionEnum.Scenario.getNumber(), dimnumber)) {
            return 0;
        }
        if (Objects.equals(SysDimensionEnum.Year.getNumber(), dimnumber)) {
            return 1;
        }
        return 2;
    }

    private void sendMsgByClean() {
        HashMap<String, Object> selectNode = new HashMap<String, Object>(1);
        selectNode.put("id", "0");
        this.sendMsgByClickTreeNode(selectNode);
    }

    private void sendMsgByClickTreeNode(Map<String, Object> selectNode) {
        List templateIds;
        String usertaskinfoId = (String)selectNode.get("id");
        this.getPageCache().put(KEY_FOCUS_USERTASKINFO_ID, usertaskinfoId);
        Long orgId = this.getUserTaskOrgId();
        String relevantop = TaskRelaOperEnum.NULL.getCode();
        if (LongUtil.isvalidLong((Object)usertaskinfoId)) {
            UserTaskInfoModel userTaskInfoModel = UserTaskInfoModel.dynToModel((Long)Long.valueOf(usertaskinfoId));
            relevantop = userTaskInfoModel.getActivityModel().getRelevantop().getCode();
            Map org2Template = TaskRecordServiceHelper.getTaskRecordTemplateIds((Long)this.getModelId(), (Set)Sets.newHashSet((Object[])new Long[]{orgId}), (Long)userTaskInfoModel.getUserTaskModel().getTaskrecord(), (Long)userTaskInfoModel.getActivity(), (boolean)false);
            templateIds = org2Template.containsKey(orgId) ? (List)org2Template.get(orgId) : Collections.emptyList();
        } else {
            templateIds = Collections.emptyList();
        }
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("usertaskinfoId", Long.valueOf(usertaskinfoId));
        params.put("usertask_templateids", templateIds);
        params.put("SUB_PAGEID_USERTASK_REFRESH_FLAG", Boolean.FALSE.toString());
        params.put("usertask_relevantop", relevantop);
        this.sendMsg("bcm_usertasktree_clicktask", params);
    }

    private void sendMsgByCTStatus() {
        String isCTStatus = (String)this.getValue(CF_CTSTATUS);
        this.sendMsg("bcm_usertasktree_ctstatus", isCTStatus);
    }

    private void sendMsg(String operation, Object param) {
        CommandParam backCom = new CommandParam("bcm_usertasktree", "bcm_report_list", operation, param);
        this.sendMsg(this.getView(), backCom);
    }

    private void focusTreeNode(TreeView tree, Map<String, Object> selectNode) {
        if (null == selectNode) {
            return;
        }
        TreeNode node = new TreeNode();
        node.setId((String)selectNode.get("id"));
        node.setText((String)selectNode.get("text"));
        node.setParentid((String)selectNode.get("parentid"));
        tree.focusNode(node);
    }

    private boolean isCycletable() {
        String seria = this.getPageCache().get(IS_CYCLETABLE);
        return StringUtils.isNotEmpty((String)seria) ? Boolean.parseBoolean(seria) : false;
    }

    private boolean isCTStatus() {
        String seria = this.getPageCache().get(IS_CTSTATUS);
        return StringUtils.isNotEmpty((String)seria) ? Boolean.parseBoolean(seria) : true;
    }

    private Map<String, Long> getDimF7IdMap() {
        String seria = this.getPageCache().get(DIMF7ID);
        return StringUtils.isNotEmpty((String)seria) ? (Map)this.deSerializedBytes(seria) : Collections.emptyMap();
    }
}

