/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.taskmanage.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.allinone.model.MergeData;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.mergecontrol.MergeControlService;
import kd.fi.bcm.business.mergecontrol.MergeStatusService;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.taskmanage.enums.MergeStatusEnum;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AdjustTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.StageOpTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;

public class TaskCardHelper {
    public static final String FORM_CARD_MERGEMONITOR = "bcm_card_mergemonitor";
    public static final String FORM_CARD_MERGESTATUSCOUNT = "bcm_card_mergestatuscount";
    public static final String FORM_CARD_MERGEBACKRANK = "bcm_card_mergebackrank";
    public static final String FORM_CARD_TASKCONTEXTF7 = "bcm_card_taskcontextf7";
    public static final String FORM_CARD_TASKPROGRESS = "bcm_card_taskprogress";
    public static final String FORM_CARD_TASKPROGRESSLIST = "bcm_card_taskprogresslist";
    public static final String REFRESHTIME = "refreshtime";
    private static final List<MergeStatusEnum> BatchMcStatus = Lists.newArrayList((Object[])new MergeStatusEnum[]{MergeStatusEnum.COL_FLOWSTATUS, MergeStatusEnum.COL_PCFLOWSTATUS, MergeStatusEnum.COL_CALCULATESTATUS, MergeStatusEnum.COL_PCCALCULATESTATUS, MergeStatusEnum.COL_ARCHIVESTATUS});
    private static final String MERGEDATAID_EC = "mergedataid_ec";
    private static final String BACK_NUM = "back_num";

    public static List<Pair<String, String>> getCardPageId(IPageCache parentPageCache, String formId) {
        return TaskCardHelper.getCardPageId(parentPageCache, Collections.singletonList(formId));
    }

    public static List<Pair<String, String>> getCardPageId(IPageCache parentPageCache, List<String> formIds) {
        Map<String, String> allCardConfig = TaskCardHelper.getAllCardConfigMap(parentPageCache);
        Map<String, String> allCardPageId = TaskCardHelper.getAllCardPageIdMap(parentPageCache);
        ArrayList<Pair<String, String>> cardPageIds = new ArrayList<Pair<String, String>>(allCardConfig.size());
        for (Map.Entry<String, String> entry : allCardConfig.entrySet()) {
            Map value = (Map)SerializationUtils.fromJsonString((String)entry.getValue(), Map.class);
            if (!formIds.contains(value.get("cardformnum")) || !allCardPageId.containsKey(entry.getKey())) continue;
            cardPageIds.add((Pair<String, String>)Pair.onePair((Object)entry.getKey(), (Object)allCardPageId.get(entry.getKey())));
        }
        cardPageIds.sort(Comparator.comparingLong(e -> Long.parseLong((String)e.p1)));
        return cardPageIds;
    }

    public static Map<String, String> getAllCardConfigMap(IPageCache parentPageCache) {
        String allCardConfigStr;
        Map<String, String> allCardConfigMap = new HashMap<String, String>(8);
        if (parentPageCache != null && StringUtils.isNotEmpty((String)(allCardConfigStr = parentPageCache.get("cache_allCardConfig")))) {
            allCardConfigMap = (Map)SerializationUtils.fromJsonString((String)allCardConfigStr, Map.class);
        }
        return allCardConfigMap;
    }

    public static Map<String, String> getAllCardPageIdMap(IPageCache parentPageCache) {
        String allCardConfigStr;
        Map<String, String> allCardConfigMap = new HashMap<String, String>(8);
        if (parentPageCache != null && StringUtils.isNotEmpty((String)(allCardConfigStr = parentPageCache.get("cache_CardId_PageId_Map")))) {
            allCardConfigMap = (Map)SerializationUtils.fromJsonString((String)allCardConfigStr, Map.class);
        }
        return allCardConfigMap;
    }

    public static void refreshRelaCard(IFormView formView, String formId, List<Pair<String, Object>> updateDim) {
        if (null == formView.getParentView()) {
            return;
        }
        IPageCache parentPageCache = formView.getParentView().getPageCache();
        IFormView mainPageView = formView.getMainView();
        for (Pair<String, String> e : TaskCardHelper.getCardPageId(parentPageCache, formId)) {
            String pageId = (String)e.p2;
            if (!StringUtils.isNotEmpty((String)pageId) || null == mainPageView.getView(pageId)) continue;
            IFormView cardFormView = mainPageView.getView(pageId);
            if (CollectionUtils.isEmpty(updateDim)) {
                cardFormView.getModel().setValue(REFRESHTIME, (Object)System.currentTimeMillis());
            } else {
                updateDim.forEach(dim -> {
                    if (null != cardFormView.getControl((String)dim.p1)) {
                        cardFormView.getModel().setValue((String)dim.p1, dim.p2);
                    }
                });
            }
            formView.sendFormAction(cardFormView);
        }
    }

    public static void refreshRelaCardByChangeDim(PropertyChangedArgs e, IFormView formView, String formId, List<String> f7DimKeys) {
        List<Object> updateDims;
        String keyName = e.getProperty().getName();
        if (!f7DimKeys.contains(keyName)) {
            return;
        }
        ChangeData data = e.getChangeSet()[0];
        if (null == data.getNewValue() && null != data.getOldValue()) {
            if (Objects.equals("model", keyName)) {
                return;
            }
            updateDims = Collections.singletonList(Pair.onePair((Object)keyName, null));
        } else {
            updateDims = f7DimKeys.stream().filter(dimKey -> null == UserSelectUtil.getF7SelectId(formView, dimKey)).map(dimKey -> Pair.onePair((Object)dimKey, null)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(updateDims)) {
                updateDims.add((Pair<String, Object>)Pair.onePair((Object)keyName, (Object)UserSelectUtil.getF7SelectId(formView, keyName)));
            }
        }
        TaskCardHelper.refreshRelaCard(formView, formId, updateDims);
    }

    public static boolean existCard(IFormView formView, String formId) {
        if (null == formView.getParentView()) {
            return false;
        }
        boolean exist = false;
        IPageCache parentPageCache = formView.getParentView().getPageCache();
        IFormView mainPageView = formView.getMainView();
        for (Pair<String, String> e : TaskCardHelper.getCardPageId(parentPageCache, formId)) {
            String pageId = (String)e.p2;
            if (!StringUtils.isNotEmpty((String)pageId) || null == mainPageView.getView(pageId)) continue;
            exist = true;
            break;
        }
        return exist;
    }

    public static void countMergeStatus(MergeStatusEnum statusEnum, FixedItem fixedItem, String process, EntryType entityType, Map<String, LinkedHashMap<String, Integer>> cacheMap) {
        if (TaskCardHelper.fixedItemNull(fixedItem)) {
            return;
        }
        String processType = statusEnum == MergeStatusEnum.COL_CHKSTATUS || statusEnum == MergeStatusEnum.COL_ADJUSTSTATUS ? process : null;
        DynamicObjectCollection orgTree = TaskCardHelper.getOrgTree(fixedItem);
        if (BatchMcStatus.contains(statusEnum) || statusEnum == MergeStatusEnum.COL_CHKSTATUS) {
            List<Map<String, Object>> list = TaskCardHelper.queryMergeControlEntity(orgTree, fixedItem, entityType, processType);
            TaskCardHelper.batchMcStatus(list, cacheMap);
            if (statusEnum == MergeStatusEnum.COL_CHKSTATUS) {
                cacheMap.put(statusEnum.getCode(), TaskCardHelper.countMergeStatus(list, statusEnum));
            }
        } else if (statusEnum == MergeStatusEnum.COL_ADJUSTSTATUS) {
            List<Map<String, Object>> list = TaskCardHelper.queryAdjustAuditStatus(orgTree, fixedItem, entityType, processType);
            cacheMap.put(statusEnum.getCode(), TaskCardHelper.countMergeStatus(list, statusEnum));
        }
    }

    private static boolean fixedItemNull(FixedItem fixedItem) {
        return null == fixedItem.getModel() || null == fixedItem.getScenario() || null == fixedItem.getFy() || null == fixedItem.getPeriod() || null == fixedItem.getEntity();
    }

    private static LinkedHashMap<String, Integer> countMergeStatus(List<Map<String, Object>> dyns, MergeStatusEnum statusEnum) {
        LinkedHashMap map = dyns.stream().collect(Collectors.groupingBy(e -> String.valueOf(e.get(statusEnum.getColkey())), LinkedHashMap::new, Collectors.summingInt(e -> 1)));
        LinkedHashMap<String, Integer> resultMap = new LinkedHashMap<String, Integer>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            String name = statusEnum.getStatusName((String)entry.getKey());
            Integer count = resultMap.computeIfAbsent(name, e -> 0);
            resultMap.put(name, count + (Integer)entry.getValue());
        }
        return resultMap;
    }

    private static void batchMcStatus(List<Map<String, Object>> list, Map<String, LinkedHashMap<String, Integer>> cacheMap) {
        for (MergeStatusEnum e : BatchMcStatus) {
            cacheMap.put(e.getCode(), TaskCardHelper.countMergeStatus(list, e));
        }
    }

    public static List<Map<String, Object>> queryMergeControlEntity(DynamicObjectCollection orgTree, FixedItem fixedItem, EntryType entityType, String processType) {
        boolean isChkCheck = StringUtils.isNotEmpty((String)processType);
        MergeControlService mergeService = MergeControlService.getInstance();
        long modelId = fixedItem.getModelId();
        long scenarioId = fixedItem.getScenarioId();
        long yearId = fixedItem.getFyId();
        long periodId = fixedItem.getPeriodId();
        boolean isContainName = CollectionUtils.isNotEmpty((Collection)orgTree) ? ((DynamicObject)orgTree.get(0)).getDynamicObjectType().getProperties().containsKey((Object)"name") : false;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(orgTree.size());
        Set memberIds = orgTree.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        Map mcDataMap = MergeStatusService.getInstance().batchGetMcData(Long.valueOf(modelId), Long.valueOf(scenarioId), Long.valueOf(yearId), Long.valueOf(periodId), memberIds);
        Map chkResult = isChkCheck ? mergeService.getChkCheckResult(Long.valueOf(modelId), Long.valueOf(scenarioId), Long.valueOf(yearId), Long.valueOf(periodId), memberIds, processType) : null;
        for (DynamicObject org : orgTree) {
            long orgId = org.getLong("id");
            Map<String, Object> rowObj = TaskCardHelper.getRowObj(org);
            MergeData mergeData = (MergeData)mcDataMap.get(orgId);
            McStatus mcStatus = mergeData.getMergeStatus();
            rowObj.put("calculatestatus", mcStatus.getCalculate().getStatus());
            rowObj.put("pccalculatestatus", mcStatus.getConvert().getStatus());
            rowObj.put("flowstatus", mcStatus.getFlow().getStatus());
            rowObj.put("pcflowstatus", mcStatus.getPcFlow().getStatus());
            rowObj.put("archivestatus", mcStatus.getArchive().getStatus());
            DynamicObject ecData = mergeData.getEcData();
            if (null != ecData) {
                rowObj.put(MERGEDATAID_EC, ecData.getLong("id"));
                if (isContainName) {
                    rowObj.put("name", org.getString("name"));
                }
            }
            if (isChkCheck) {
                Pair chkPair = null;
                if (chkResult != null) {
                    chkPair = (Pair)chkResult.get(orgId);
                }
                String checkResult = chkPair == null ? (mcStatus != null && mcStatus.getCalculate().isSuccess() ? "C" : "B") : (Objects.equals(processType, AdjustTypeEnum.ERPT.getValue()) ? (String)chkPair.p1 : (String)chkPair.p2);
                rowObj.put("chkstatus", checkResult);
            }
            result.add(rowObj);
        }
        return result;
    }

    public static List<Map<String, Object>> queryAdjustAuditStatus(DynamicObjectCollection orgTree, FixedItem fixedItem, EntryType entityType, String processType) {
        long modelId = fixedItem.getModelId();
        long scenarioId = fixedItem.getScenarioId();
        long yearId = fixedItem.getFyId();
        long periodId = fixedItem.getPeriodId();
        Set unAuditOrSet = AdjustmentServiceHelper.collectUnAuditAdjust((long)modelId, (long)scenarioId, (long)yearId, (long)periodId, (DynamicObjectCollection)orgTree);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (DynamicObject org : orgTree) {
            String orgNumber = org.getString("id");
            Map<String, Object> rowObj = TaskCardHelper.getRowObj(org);
            if (!"Entity".equalsIgnoreCase(orgNumber)) {
                int status = unAuditOrSet.contains(orgNumber) ? 1 : 0;
                rowObj.put("adjuststatus", status);
            }
            result.add(rowObj);
        }
        return result;
    }

    private static Map<String, Object> getRowObj(DynamicObject org) {
        HashMap<String, Object> rowObj = new HashMap<String, Object>(8);
        rowObj.put("id", org.getLong("id"));
        rowObj.put("number", org.get("number"));
        return rowObj;
    }

    private static DynamicObjectCollection getOrgTree(FixedItem fixedItem) {
        long modelId = fixedItem.getModelId();
        long pid = fixedItem.getEntityId();
        boolean onlyMergeOrg = !ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM030");
        return MergeControlService.getInstance().getOrgTreeSimple(fixedItem, Long.valueOf(pid), true, onlyMergeOrg, false);
    }

    public static Map<String, Integer> queryMergeBackData(FixedItem fixedItem, int topNum) {
        if (TaskCardHelper.fixedItemNull(fixedItem) || !LongUtil.isvalidLong((Object)fixedItem.getEntityId())) {
            return new LinkedHashMap<String, Integer>(0);
        }
        DynamicObjectCollection orgTree = TaskCardHelper.getOrgTree(fixedItem);
        List<Map<String, Object>> list = TaskCardHelper.queryMergeControlEntity(orgTree, fixedItem, null, null);
        Set<Long> mergeControlIds = list.stream().filter(e -> e.containsKey(MERGEDATAID_EC)).map(e -> (Long)e.get(MERGEDATAID_EC)).collect(Collectors.toSet());
        LinkedHashMap<Long, Integer> flowTaskMap = TaskCardHelper.countFlowTask(mergeControlIds, StageOpTypeEnum.BACK.getCode(), topNum);
        if (flowTaskMap.isEmpty()) {
            return new LinkedHashMap<String, Integer>(0);
        }
        HashSet<Long> uniqueMcId = new HashSet<Long>(flowTaskMap.size());
        for (Map<String, Object> e2 : list) {
            Long mergeControlId = (Long)e2.get(MERGEDATAID_EC);
            if (null == mergeControlId || !flowTaskMap.containsKey(mergeControlId) || !uniqueMcId.add(mergeControlId)) continue;
            e2.put(BACK_NUM, flowTaskMap.get(mergeControlId));
        }
        list.removeIf(e -> !e.containsKey(BACK_NUM));
        list.sort((o1, o2) -> ((Integer)o2.get(BACK_NUM)).compareTo((Integer)o1.get(BACK_NUM)));
        FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam(fixedItem.getModelId(), fixedItem.getScenarioId(), fixedItem.getFyNum(), fixedItem.getPeriodId());
        Map orgId2Names = EntityVersioningUtil.filterEffectiveOrgByMergeStruct((FilterOrgStructParam)filterOrgStructParam, (Collection)list.stream().map(e -> (Long)e.get("id")).collect(Collectors.toList()));
        LinkedHashMap<String, Integer> dataMap = new LinkedHashMap<String, Integer>(topNum);
        int index = 0;
        for (Map<String, Object> e3 : list) {
            if (index >= topNum) break;
            String name = (String)orgId2Names.get(e3.get("id"));
            dataMap.put(e3.get("number") + "_" + name, (Integer)e3.get(BACK_NUM));
            ++index;
        }
        return dataMap;
    }

    private static LinkedHashMap<Long, Integer> countFlowTask(Set<Long> bizIds, String action, int topNum) {
        if (CollectionUtils.isEmpty(bizIds)) {
            return new LinkedHashMap<Long, Integer>(0);
        }
        LinkedHashMap<Long, Integer> flowTaskMap = new LinkedHashMap<Long, Integer>(topNum);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select top ").append(topNum).append(" a.fbizid as bizid,count(1) as total ");
        sqlBuilder.append("from t_bcm_flowtask a ");
        sqlBuilder.append("where a.fbizid in (");
        sqlBuilder.append(String.join((CharSequence)",", bizIds.stream().map(e -> e.toString()).collect(Collectors.toList())));
        sqlBuilder.append(")");
        sqlBuilder.append("and a.faction = '").append(action).append("' ");
        sqlBuilder.append("group by a.fbizid ");
        sqlBuilder.append("order by count(1) desc ");
        DB.query((DBRoute)DBRoute.of((String)"bcm"), (String)sqlBuilder.toString(), rs -> {
            while (rs.next()) {
                Long bizid = rs.getLong("bizid");
                int total = rs.getInt("total");
                flowTaskMap.put(bizid, total);
            }
            return null;
        });
        return flowTaskMap;
    }

    public static String getDimTitle(Long modelId, String dimKey) {
        String name = "";
        if (Objects.equals("model", dimKey)) {
            name = ResManager.loadKDString((String)"\u4f53\u7cfb", (String)"TaskCardHelper_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        } else if (Objects.equals("cslscheme", dimKey)) {
            name = ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe", (String)"TaskCardHelper_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        } else {
            String dimName;
            DimTypesEnum dimTypesEnum = DimTypesEnum.valueOf((String)dimKey.toUpperCase(Locale.ENGLISH));
            name = LongUtil.isvalidLong((Object)modelId) ? (StringUtils.isNotEmpty((String)(dimName = MemberReader.getDimensionNameById((long)MemberReader.getDimensionIdByNum((long)modelId, (String)dimTypesEnum.getNumber())))) ? dimName : dimTypesEnum.getName()) : dimTypesEnum.getName();
        }
        return name;
    }
}

