/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.taskmanage.helper;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FloatingDirection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListColumn;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskCardHelper;

public class TaskCommonHelper {
    public static void openNew(AbstractFormPlugin plugin, String actionId, Long modelId, boolean isDefault) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_tasktemplate");
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)modelId);
        formShowParameter.setCustomParam("default", (Object)isDefault);
        formShowParameter.setParentPageId(plugin.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"TaskCommonHelper_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        plugin.getView().showForm(formShowParameter);
    }

    public static void openEdit(AbstractFormPlugin plugin, String actionId, Object pkId, Long modelId) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("bcm_tasktemplate");
        formShowParameter.setPkId(pkId);
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)modelId);
        formShowParameter.setParentPageId(plugin.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"TaskCommonHelper_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        plugin.getView().showForm((FormShowParameter)formShowParameter);
    }

    public static void openList(IFormView formView, Long modelId) {
        String pageId = (String)formView.getFormShowParameter().getCustomParam("bcm_tasktemplatelist_pageid");
        if (StringUtils.isEmpty((String)pageId)) {
            return;
        }
        if (TaskCommonHelper.activatePage(formView, pageId)) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setPageId(pageId);
        formShowParameter.setFormId("bcm_tasktemplatelist");
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)modelId);
        TaskCommonHelper.openTabPage(formView, formShowParameter, formView.getParentView());
    }

    public static void openSettingPage(IFormView formView, Long modelId, Long taskTemplateId, String taskTemplateName) {
        String pageId = formView.getPageId() + taskTemplateId;
        if (TaskCommonHelper.activatePage(formView, pageId)) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setPageId(pageId);
        formShowParameter.setFormId("bcm_tasktemplateconfig");
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)modelId);
        formShowParameter.setCustomParam("taskTemplateId", (Object)taskTemplateId);
        formShowParameter.setCustomParam("bcm_tasktemplatelist_pageid", (Object)formView.getPageId());
        formShowParameter.setCaption(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u6a21\u677f\u8bbe\u7f6e-%s", (String)"TaskCommonHelper_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), taskTemplateName));
        TaskCommonHelper.openTabPage(formView, formShowParameter, formView.getParentView());
    }

    private static boolean activatePage(IFormView formView, String pageId) {
        IFormView view;
        IFormView mainPageView = formView.getMainView();
        IFormView iFormView = view = mainPageView != null ? mainPageView : formView.getParentView();
        if (view != null && view.getView(pageId) != null) {
            IFormView page = view.getView(pageId);
            page.activate();
            formView.sendFormAction(page);
            return true;
        }
        return false;
    }

    public static void openTabPage(IFormView formView, FormShowParameter formShowParameter, IFormView parentView) {
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
        if (null == parentView) {
            formView.showForm(formShowParameter);
        } else {
            formShowParameter.setParentPageId(parentView.getPageId());
            formShowParameter.setParentFormId(parentView.getEntityId());
            parentView.showForm(formShowParameter);
            formView.sendFormAction(parentView);
        }
    }

    public static void openReportTemplate(AbstractFormPlugin plugin, String actionId, Long modelId, List<String> templateNumbers, List<Long> sceneIds, boolean iscycletable, boolean readonly, Map<String, Long> f7IdMap) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_tasktpl_acttplf7");
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)modelId);
        formShowParameter.setCustomParam("rows", templateNumbers);
        formShowParameter.setCustomParam("pagememberids", sceneIds);
        formShowParameter.setCustomParam("iscycletable", (Object)iscycletable);
        formShowParameter.setCustomParam("readonly", (Object)readonly);
        if (null != f7IdMap) {
            formShowParameter.setCustomParam("f7IdMap", f7IdMap);
        }
        formShowParameter.setParentPageId(plugin.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u62a5\u8868\u6a21\u677f", (String)"TaskCommonHelper_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        plugin.getView().showForm(formShowParameter);
    }

    public static void openUsertaskinfolist(IFormView formView, String pageId, Long modelId, Long usertaskId, Long activityId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setPageId(pageId);
        formShowParameter.setFormId("bcm_usertaskinfolist");
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)modelId);
        formShowParameter.setCustomParam("usertaskId", (Object)usertaskId);
        formShowParameter.setCustomParam("activityId", (Object)activityId);
        formShowParameter.setParentPageId(formView.getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        formShowParameter.getOpenStyle().setFloatingDirection(FloatingDirection.BottomRight);
        formView.showForm(formShowParameter);
    }

    public static void openUsertaskinfolistBySlide(IFormView formView, Long modelId, Long usertaskId, Long activityId, Long orgId) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("usertaskId", usertaskId);
        params.put("activityId", activityId);
        params.put("orgId", orgId);
        params.put("parentPageId", formView.getPageId());
        params.put("appId", formView.getFormShowParameter().getAppId());
        params.put("KEY_MODEL_ID", modelId);
        AppCacheServiceHelper.put((String)TaskCommonHelper.getUsertaskListParamKey(), (Object)JacksonUtils.toJson(params), (int)300);
        String formId = "bcm_usertaskinfolist";
        IClientViewProxy proxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("direction", "right");
        map.put("formId", formId);
        map.put("offsetInAllDC", new HashMap(4){
            {
                this.put("right", 10);
            }
        });
        proxy.addAction("setSlideBillFormId", map);
        HashMap<String, String> o = new HashMap<String, String>(1);
        o.put("formId", formId);
        proxy.addAction("showSlideBill", o);
    }

    public static void closeUsertaskinfolistBySlide(IFormView formView) {
        IClientViewProxy proxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        HashMap<String, Object> o = new HashMap<String, Object>(2);
        o.put("formId", "bcm_usertaskinfolist");
        o.put("show", Boolean.FALSE);
        proxy.addAction("showSlideBill", o);
    }

    public static String getUsertaskListParamKey() {
        return "bcm_usertaskinfolist_" + RequestContext.get().getGlobalSessionId();
    }

    public static Tuple<Long, Long, Long> getUsertaskListParam(IPageCache pageCache) {
        String seria = AppCacheServiceHelper.getString((String)TaskCommonHelper.getUsertaskListParamKey());
        if (StringUtils.isNotEmpty((String)seria)) {
            Map params = (Map)JacksonUtils.fromJson((String)seria, Map.class);
            pageCache.put("parentPageId", String.valueOf(params.get("parentPageId")));
            pageCache.put("appId", String.valueOf(params.get("appId")));
            pageCache.put("KEY_MODEL_ID", String.valueOf(params.get("KEY_MODEL_ID")));
            AppCacheServiceHelper.remove((String)TaskCommonHelper.getUsertaskListParamKey());
            return Tuple.create((Object)Long.valueOf(String.valueOf(params.get("usertaskId"))), (Object)Long.valueOf(String.valueOf(params.get("activityId"))), (Object)LongUtil.toLong(params.get("orgId")));
        }
        return Tuple.create((Object)0L, (Object)0L, (Object)0L);
    }

    public static String getParentPageId(IPageCache pageCache) {
        return pageCache.get("parentPageId");
    }

    public static String convertProgress(Pair<Integer, Integer> num) {
        int progressValue = 0;
        if ((Integer)num.p1 == 0 || (Integer)num.p2 == 0) {
            return String.valueOf(progressValue);
        }
        if (num.p1 == num.p2) {
            progressValue = 20;
        } else {
            int tmp = (Integer)num.p1 * 100 / (Integer)num.p2;
            int remainder = tmp % 5;
            progressValue = remainder < 3 ? BigDecimal.valueOf(Math.floor((double)tmp / 5.0)).intValue() : BigDecimal.valueOf(Math.ceil((double)tmp / 5.0)).intValue();
            if (progressValue == 0) {
                ++progressValue;
            }
            if (progressValue == 20) {
                --progressValue;
            }
        }
        return String.valueOf(progressValue);
    }

    public static String getSceneTitle(Long modelId) {
        return String.format(ResManager.loadKDString((String)"\u9002\u7528%s", (String)"TaskCommonHelper_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), TaskCardHelper.getDimTitle(modelId, "scenario"));
    }

    public static void setColumnDimName(IFormView formView, Long modelId, String colKey, String dimKey) {
        String columnCaption;
        Control column = formView.getControl(colKey);
        if (null == column) {
            return;
        }
        String string = columnCaption = Objects.equals(dimKey, "scenario") ? TaskCommonHelper.getSceneTitle(modelId) : TaskCardHelper.getDimTitle(modelId, dimKey);
        if (column instanceof ListColumn) {
            ((ListColumn)column).setCaption(new LocaleString(columnCaption));
        }
        if (column instanceof TextEdit) {
            ((TextEdit)column).setCaption(new LocaleString(columnCaption));
        }
    }

    public static void setColumnDimNumAndName(IFormView formView, Long modelId, String[] colKeys, String dimKey) {
        String dimName = TaskCardHelper.getDimTitle(modelId, dimKey);
        Control number = formView.getControl(colKeys[0]);
        Control name = formView.getControl(colKeys[1]);
        if (null != number) {
            LocaleString numberL = new LocaleString(String.format(ResManager.loadKDString((String)"%s\u7f16\u7801", (String)"TaskCommonHelper_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimName));
            if (number instanceof ListColumn) {
                ((ListColumn)number).setCaption(numberL);
            }
            if (number instanceof TextEdit) {
                ((TextEdit)number).setCaption(numberL);
            }
        }
        if (null != name) {
            LocaleString nameL = new LocaleString(String.format(ResManager.loadKDString((String)"%s\u540d\u79f0", (String)"TaskCommonHelper_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimName));
            if (name instanceof ListColumn) {
                ((ListColumn)name).setCaption(nameL);
            }
            if (name instanceof TextEdit) {
                ((TextEdit)name).setCaption(nameL);
            }
        }
    }
}

