/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.taskmanage.helper;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.list.ListShowParameter;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.taskmanage.enums.TaskActitvityPerm;
import kd.fi.bcm.business.taskmanage.enums.TaskActivityTypeEnum;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateActModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.BcmBasePluginUtil;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskCommonHelper;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskOperateHelper;
import org.apache.commons.collections4.CollectionUtils;

public class TaskOpenMenuHelper {
    private static final String scene = "scenario";
    private static final String year = "year";
    private static final String period = "period";
    private static final String model = "model";
    private static final String cslScheme = "cslscheme";
    private static final String entity = "entity";
    private static final String focusNodeOrgId = "focusnodeid";
    private static final String selectorgs = "selectorgs";
    public static final String KEY_TASKRECORD_ID = "bcm_usertasklist_taskrecordid";
    public static final String REFRESHTIME = "refreshtime";
    private static final List<String> pageF7_0 = Arrays.asList("model", "scenario", "year", "period", "entity");
    private static final List<String> pageF7_1 = Arrays.asList("model", "scenario", "year", "period", "cslscheme");
    private static final List<String> pageF7_2 = Arrays.asList("model", "scenario", "year", "period");
    public static final Map<TaskActivityTypeEnum, Pair<List<String>, String>> pageF7Map = new HashMap(){
        {
            this.put(TaskActivityTypeEnum.PeriodManage, Pair.onePair((Object)pageF7_0, null));
            this.put(TaskActivityTypeEnum.YearCarry, Pair.onePair((Object)pageF7_1, (Object)TaskOpenMenuHelper.focusNodeOrgId));
            this.put(TaskActivityTypeEnum.ExchangeRate, Pair.onePair((Object)pageF7_2, null));
            this.put(TaskActivityTypeEnum.Invest, Pair.onePair(Arrays.asList(TaskOpenMenuHelper.model, TaskOpenMenuHelper.cslScheme), (Object)TaskOpenMenuHelper.focusNodeOrgId));
            this.put(TaskActivityTypeEnum.InvestRelation, Pair.onePair((Object)pageF7_1, (Object)"parentOrg"));
            this.put(TaskActivityTypeEnum.Formula, Pair.onePair((Object)pageF7_2, null));
            this.put(TaskActivityTypeEnum.Integration, Pair.onePair((Object)pageF7_1, (Object)"cache_org_id"));
            this.put(TaskActivityTypeEnum.Report, Pair.onePair((Object)pageF7_1, null));
            this.put(TaskActivityTypeEnum.Check, Pair.onePair((Object)pageF7_1, null));
            this.put(TaskActivityTypeEnum.Adjust, Pair.onePair((Object)pageF7_1, (Object)TaskOpenMenuHelper.focusNodeOrgId));
            this.put(TaskActivityTypeEnum.Merge, Pair.onePair((Object)pageF7_0, null));
            this.put(TaskActivityTypeEnum.InveReport, Pair.onePair((Object)pageF7_1, (Object)"parentOrg"));
            this.put(TaskActivityTypeEnum.InvlimSheet, Pair.onePair((Object)pageF7_1, (Object)TaskOpenMenuHelper.focusNodeOrgId));
        }
    };

    private static long getUserId() {
        return Long.parseLong(RequestContext.get().getUserId());
    }

    public static String getJumpFromKey(String formId) {
        return "jumpfrom_" + RequestContext.get().getGlobalSessionId() + "_" + formId;
    }

    public static String getJumpFrom(String formId) {
        String cacheKey = TaskOpenMenuHelper.getJumpFromKey(formId);
        String seria = AppCacheServiceHelper.getString((String)cacheKey);
        if (StringUtils.isNotEmpty((String)seria)) {
            AppCacheServiceHelper.remove((String)cacheKey);
        }
        return seria;
    }

    public static void openActMenuPage(IFormView formView, TaskTemplateActModel actModel, UserSelectModel userSelectModel, Consumer<IFormView> beforeOpen) {
        IFormView appPageView;
        TaskActivityTypeEnum actType = actModel.getActType();
        Long modelId = Long.valueOf(userSelectModel.getModel());
        String menuPageId = "";
        IFormView mainPageView = formView.getMainView();
        String mainPageId = null != mainPageView ? mainPageView.getPageId() : formView.getPageId();
        String menuFormId = actType.getMenuFormId();
        String appID = formView.getFormShowParameter().getAppId();
        String appPageId = appID + mainPageId;
        IFormView iFormView = appPageView = null != mainPageView ? mainPageView.getView(appPageId) : null;
        if (null == appPageView) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5e94\u7528\u9875\u9762\u4e0d\u5b58\u5728\u3002", (String)"TaskOpenMenuHelper_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        int is = BcmBasePluginUtil.checkPermission(TaskOpenMenuHelper.getUserId(), modelId, appID, "bcm_taskactperm", (String)((Pair)TaskActitvityPerm.PermItemMap.get((Object)actType)).p1);
        if (is == 0 && !MemberPermHelper.ifUserHasRootPermByModel((long)TaskOpenMenuHelper.getUserId(), (String)String.valueOf(modelId))) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u65e0\u8be5\u6d3b\u52a8\u6743\u9650\u3002", (String)"TaskOpenMenuHelper_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        AppMenuInfo menu = TaskOpenMenuHelper.getAppMenu(formView, menuFormId);
        if (null == menu) {
            menuPageId = TaskOpenMenuHelper.getPageIdByActType(formView, actType, modelId);
            if (StringUtils.isEmpty((String)menuPageId)) {
                menuPageId = actType.getMenuFormId() + "_" + mainPageId;
            }
        } else {
            menuPageId = menu.getId() + mainPageId;
        }
        if (null != beforeOpen) {
            beforeOpen.accept(formView);
        }
        TaskOperateHelper.saveUserSelect(userSelectModel);
        AppCacheServiceHelper.put((String)TaskOpenMenuHelper.getJumpFromKey(menuFormId), (Object)"bcm_usertasklist", (int)120);
        if (null != mainPageView && mainPageView.getView(menuPageId) != null) {
            IFormView menuPageView = mainPageView.getView(menuPageId);
            menuPageView.activate();
            TaskOpenMenuHelper.refreshPage(menuPageView, actType, userSelectModel);
            TaskOpenMenuHelper.setParamlock(actModel.getParamlock(), null, menuPageView);
            formView.sendFormAction(menuPageView);
            return;
        }
        Map<String, Object> customParams = TaskOpenMenuHelper.getCustomParamsByActType(actType, userSelectModel);
        TaskOpenMenuHelper.setParamlock(actModel.getParamlock(), customParams, null);
        FormShowParameter formShowParameter = new FormShowParameter();
        if (null != menu && StringUtils.isNotEmpty((String)menu.getParams())) {
            Map menuParams = (Map)JSONArray.parseObject((String)menu.getParams(), Map.class);
            if ("list".equals(menuParams.get("type"))) {
                formShowParameter = new ListShowParameter();
                ((ListShowParameter)formShowParameter).setBillFormId((String)menuParams.get("billFormId"));
            }
            for (Map.Entry e : menuParams.entrySet()) {
                customParams.put((String)e.getKey(), e.getValue());
            }
        }
        if (customParams.get("formId") == null) {
            customParams.put("formId", menuFormId);
        }
        customParams.put("appid", appID);
        formShowParameter.setPageId(menuPageId);
        formShowParameter.setFormId(menuFormId);
        formShowParameter.setCustomParams(customParams);
        TaskCommonHelper.openTabPage(formView, formShowParameter, appPageView);
    }

    public static void refreshPage(IFormView menuPageView, TaskActivityTypeEnum actType, UserSelectModel userSelectModel) {
        Pair<List<String>, String> dims = pageF7Map.get(actType);
        if (null == dims) {
            return;
        }
        if (StringUtils.isNotEmpty((String)((String)dims.p2)) && StringUtils.isNotEmpty((String)userSelectModel.getOrg())) {
            menuPageView.getPageCache().put((String)dims.p2, userSelectModel.getOrg());
            ArrayList<String> selectnodes = new ArrayList<String>(1);
            selectnodes.add(userSelectModel.getOrg());
            menuPageView.getPageCache().put(selectorgs, ObjectSerialUtil.toByteSerialized(selectnodes));
        }
        for (String dimKey : (List)dims.p1) {
            if (null == menuPageView.getControl(dimKey)) continue;
            TaskOpenMenuHelper.setValue(menuPageView, dimKey, model, () -> userSelectModel.getModel());
            TaskOpenMenuHelper.setValue(menuPageView, dimKey, scene, () -> userSelectModel.getScene());
            TaskOpenMenuHelper.setValue(menuPageView, dimKey, year, () -> userSelectModel.getYear());
            TaskOpenMenuHelper.setValue(menuPageView, dimKey, period, () -> userSelectModel.getPeriod());
            TaskOpenMenuHelper.setValue(menuPageView, dimKey, entity, () -> userSelectModel.getOrg());
            TaskOpenMenuHelper.setValue(menuPageView, dimKey, cslScheme, () -> userSelectModel.getCslScheme());
        }
    }

    private static void setValue(IFormView menuPageView, String dimKey, String prop, Supplier<String> supplier) {
        if (Objects.equals(prop, dimKey) && StringUtils.isNotEmpty((String)supplier.get())) {
            menuPageView.getModel().setValue(dimKey, (Object)Long.valueOf(supplier.get()));
        }
    }

    public static AppMenuInfo getAppMenu(IFormView formView, String menuFormId) {
        String appID = formView.getFormShowParameter().getAppId();
        return AppMetadataCache.getAppMenusInfoByAppId((String)appID).stream().filter(e -> Objects.equals(menuFormId, e.getFormId())).findFirst().orElseGet(() -> null);
    }

    public static void openAppMenu(IFormView formView, AppMenuInfo menu, Map<String, Object> customParams) {
        String appID = formView.getFormShowParameter().getAppId();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("view", formView);
        map.put("formnumber", menu.getFormId());
        map.put("parametertype", menu.getParamType());
        map.put("parameter", JSONArray.parseObject((String)menu.getParams()));
        map.put("menuname", menu.getName());
        map.put("openType", menu.getOpenType());
        map.put("permItem", menu.getPermission());
        if (null != customParams && customParams.size() > 0) {
            map.put("customparameters", customParams);
        }
        OpenPageUtils.openApp((String)appID, (String)menu.getId(), map, (IFormView)formView);
    }

    public static String getPageIdByActType(IFormView formView, TaskActivityTypeEnum actType, Long modelId) {
        String pageId = "";
        IFormView mainPageView = formView.getMainView();
        String mainPageId = null != mainPageView ? mainPageView.getPageId() : formView.getPageId();
        switch (actType) {
            case InveReport: {
                AppMenuInfo investMenu = TaskOpenMenuHelper.getAppMenu(formView, TaskActivityTypeEnum.Invest.getMenuFormId());
                if (null == investMenu) break;
                String investPageId = investMenu.getId() + mainPageId;
                pageId = investPageId + "_" + modelId;
                break;
            }
        }
        return pageId;
    }

    public static Map<String, Object> getCustomParamsByActType(TaskActivityTypeEnum actType, UserSelectModel userSelectModel) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        switch (actType) {
            case InveReport: {
                customParams.put("KEY_MODEL_ID", userSelectModel.getModel());
                if (!StringUtils.isNotEmpty((String)userSelectModel.getOrg())) break;
                customParams.put(cslScheme, Long.valueOf(userSelectModel.getCslScheme()));
                break;
            }
            case InvlimSheet: {
                if (!StringUtils.isNotEmpty((String)userSelectModel.getOrg())) break;
                customParams.put("selectedOrgid", userSelectModel.getOrg());
            }
        }
        return customParams;
    }

    public static void setParamlock(String paramlock, Map<String, Object> customParams, IFormView menuPageView) {
        String[] paramlocks;
        if (StringUtils.isEmpty((String)paramlock)) {
            return;
        }
        ArrayList<String> paramlockList = new ArrayList<String>(5);
        for (String e : paramlocks = paramlock.split(",")) {
            if (StringUtils.isEmpty((String)e)) continue;
            paramlockList.add(e);
        }
        if (null != customParams) {
            customParams.put("f7_disable_list", paramlockList);
        }
        if (null != menuPageView && CollectionUtils.isNotEmpty(paramlockList)) {
            menuPageView.setEnable(Boolean.valueOf(false), paramlockList.toArray(new String[0]));
        }
    }

    public static void openUserTaskList(IFormView formView, Long modelId, Long taskRecordId) {
        AppMenuInfo menu = TaskOpenMenuHelper.getAppMenu(formView, "bcm_usertasklist");
        if (null == menu) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u83dc\u5355\u4fe1\u606f\u5931\u8d25", (String)"BizAppHomePlugin_9", (String)"bos-portal-plugin", (Object[])new Object[0]));
            return;
        }
        IFormView mainPageView = formView.getMainView();
        String mainPageId = null != mainPageView ? mainPageView.getPageId() : formView.getPageId();
        String menuPageId = menu.getId() + mainPageId;
        if (null != mainPageView && mainPageView.getView(menuPageId) != null) {
            IFormView menuPageView = mainPageView.getView(menuPageId);
            menuPageView.getFormShowParameter().getCustomParams().remove("KEY_MODEL_ID");
            menuPageView.activate();
            if (LongUtil.isvalidLong((Object)modelId)) {
                TaskOpenMenuHelper.setAppCacheTaskRecordId(taskRecordId);
                DynamicObject modelDyn = (DynamicObject)menuPageView.getModel().getValue(model);
                if (null != modelDyn && Objects.equals(modelId, modelDyn.getPkValue())) {
                    menuPageView.getModel().setValue(REFRESHTIME, (Object)System.currentTimeMillis());
                } else {
                    menuPageView.getModel().setValue(model, (Object)modelId);
                }
            }
            formView.sendFormAction(menuPageView);
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        customParams.put("formId", "bcm_usertasklist");
        if (LongUtil.isvalidLong((Object)modelId)) {
            customParams.put("KEY_MODEL_ID", modelId);
            TaskOpenMenuHelper.setAppCacheTaskRecordId(taskRecordId);
        }
        TaskOpenMenuHelper.openAppMenu(formView, menu, customParams);
    }

    private static void setAppCacheTaskRecordId(Long taskRecordId) {
        AppCacheServiceHelper.put((String)(KEY_TASKRECORD_ID + RequestContext.getOrCreate().getGlobalSessionId()), (Object)taskRecordId.toString(), (int)60);
    }

    public static String getAppCacheTaskRecordId() {
        String sessionId = RequestContext.getOrCreate().getGlobalSessionId();
        String taskRecordId = AppCacheServiceHelper.getString((String)(KEY_TASKRECORD_ID + sessionId));
        AppCacheServiceHelper.remove((String)(KEY_TASKRECORD_ID + sessionId));
        return taskRecordId;
    }
}

