/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.taskmanage.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.util.ModelUtil;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.UserSelectServiceHelper;
import kd.fi.bcm.business.taskmanage.enums.TaskOperateMsgEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskRelaOperEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskStatusEnum;
import kd.fi.bcm.business.taskmanage.helper.UserTaskHelper;
import kd.fi.bcm.business.taskmanage.model.TaskRecordModel;
import kd.fi.bcm.business.taskmanage.model.UserTaskInfoModel;
import kd.fi.bcm.business.taskmanage.model.UserTaskModel;
import kd.fi.bcm.business.taskmanage.status.AbstractStatus;
import kd.fi.bcm.business.taskmanage.status.StatusContext;
import kd.fi.bcm.business.taskmanage.status.TaskOperateResult;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.StageOpTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.MethodOpProxy;
import kd.fi.bcm.formplugin.mergecontrol.MergeControlListPlugin;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;

public class TaskOperateHelper {
    public static final String KEY_APPID = "appId";

    private static long getUserId() {
        return Long.parseLong(RequestContext.get().getUserId());
    }

    public static TaskOperateResult checkFinishByActivity(Long usertaskinfoId, boolean isFinishOper) {
        TaskOperateResult result = TaskOperateResult.of();
        UserTaskInfoModel usertaskinfo = UserTaskInfoModel.dynToModel((Long)usertaskinfoId);
        UserTaskModel userTaskModel = UserTaskModel.dynToModel((Long)usertaskinfo.getUsertask());
        if (isFinishOper) {
            TaskOperateHelper.checkFinishByDependlast(userTaskModel, usertaskinfo, result);
        } else {
            TaskOperateHelper.checkCancel(usertaskinfo, result);
        }
        return result;
    }

    public static TaskOperateResult finishByActivity(long orgId, Long usertaskinfoId, boolean isFinishOper) {
        if (!LongUtil.isvalidLong((Object)usertaskinfoId)) {
            return TaskOperateResult.of();
        }
        UserTaskInfoModel usertaskinfo = UserTaskInfoModel.dynToModel((Long)usertaskinfoId);
        if (TaskRelaOperEnum.NULL == usertaskinfo.getActivityModel().getRelevantop()) {
            return TaskOperateResult.of();
        }
        TaskOperateResult result = TaskOperateHelper.finish(orgId, usertaskinfo, isFinishOper, false);
        if (StringUtils.isNotEmpty((String)result.getOperDescriotion())) {
            String opName = isFinishOper ? OpItemEnum.FINISH.getName() : OpItemEnum.CANCEL.getName();
            Long modelId = TaskRecordModel.dynObjToTaskRecordModel((Long)usertaskinfo.getUserTaskModel().getTaskrecord()).getModelId();
            String entityNumber = usertaskinfo.getActivityModel().getActType().getMenuFormId();
            ((ILogService)ServiceFactory.getService(ILogService.class)).addLog(OperationLogUtil.buildLogInfo((String)opName, (String)String.format(result.getOperDescriotion(), opName), (Long)modelId, (String)entityNumber));
        }
        return result;
    }

    public static TaskOperateResult finish(long orgId, Long userTaskInfoId, boolean isFinishOper) {
        if (!LongUtil.isvalidLong((Object)userTaskInfoId)) {
            return TaskOperateResult.of();
        }
        UserTaskInfoModel userTaskInfo = UserTaskInfoModel.dynToModel((Long)userTaskInfoId);
        return TaskOperateHelper.finish(orgId, userTaskInfo, isFinishOper, true);
    }

    private static TaskOperateResult finish(long orgId, UserTaskInfoModel usertaskinfo, boolean isFinishOper, boolean doRelevantop) {
        List nextList;
        TaskOperateResult result;
        Long usertaskId = usertaskinfo.getUsertask();
        UserTaskModel userTaskModel = UserTaskModel.dynToModel((Long)usertaskId);
        TaskRecordModel taskRecord = UserTaskHelper.loadTaskRecord((Long)userTaskModel.getTaskrecord());
        Set hasPermIds = PermissionServiceImpl.getInstance((Long)taskRecord.getModelId()).matchWritePermMembers(Long.valueOf(userTaskModel.getDimension()), userTaskModel.getDimensiontype(), Collections.singletonList(userTaskModel.getMember()));
        if (!hasPermIds.contains(userTaskModel.getMember())) {
            TaskOperateResult result2 = TaskOperateResult.of();
            result2.add(TaskOperateMsgEnum.NO_PERM, new Object[]{userTaskModel.getMemberName()});
            return result2;
        }
        List usertaskinfoList = null;
        String usertaskStatus = userTaskModel.getStatus();
        String newUsertaskStatus = "";
        String newRecordStatus = "";
        if (isFinishOper) {
            result = TaskOperateHelper.doFinish(orgId, taskRecord, userTaskModel, usertaskinfo, doRelevantop);
            usertaskinfoList = result.getSuccessList();
            if (CollectionUtils.isNotEmpty((Collection)usertaskinfoList) && !Objects.equals(usertaskStatus, TaskStatusEnum.FINISH.getCode())) {
                boolean usertaskFinish = UserTaskHelper.userTaskFinish((Long)usertaskId, (List)usertaskinfoList);
                newUsertaskStatus = usertaskFinish ? TaskStatusEnum.FINISH.getCode() : "";
                boolean recordFinish = usertaskFinish ? UserTaskHelper.taskRecordFinish((Long)usertaskId, (Long)userTaskModel.getTaskrecord()) : false;
                newRecordStatus = recordFinish ? TaskStatusEnum.FINISH.getCode() : "";
            }
        } else {
            result = TaskOperateHelper.doCancel(orgId, taskRecord, userTaskModel, usertaskinfo, doRelevantop);
            usertaskinfoList = result.getSuccessList();
            if (CollectionUtils.isNotEmpty((Collection)usertaskinfoList) && Objects.equals(usertaskStatus, TaskStatusEnum.FINISH.getCode())) {
                newUsertaskStatus = TaskStatusEnum.PROCESSING.getCode();
                newRecordStatus = TaskStatusEnum.PROCESSING.getCode();
            }
        }
        if (CollectionUtils.isEmpty((Collection)usertaskinfoList)) {
            return result;
        }
        UserTaskInfoModel curUsertaskinfo = (UserTaskInfoModel)usertaskinfoList.get(usertaskinfoList.size() - 1);
        Long curActivityId = curUsertaskinfo.getActivity();
        Long nextUsertaskinfoId = null;
        if (isFinishOper && CollectionUtils.isNotEmpty((Collection)(nextList = UserTaskHelper.nextUserTaskInfo((Long)userTaskModel.getId(), (Integer)curUsertaskinfo.getExecuteseq())))) {
            curActivityId = ((UserTaskInfoModel)nextList.get(0)).getActivity();
            nextUsertaskinfoId = ((UserTaskInfoModel)nextList.get(0)).getId();
        }
        TaskOperateHelper.saveStatus(userTaskModel, usertaskinfoList, curActivityId, newUsertaskStatus, newRecordStatus, nextUsertaskinfoId);
        result.setNewRecordStatus(newUsertaskStatus);
        result.setCurActivityId(curActivityId);
        result.setOperDescriotion(TaskOperateHelper.getOpDescriotion(taskRecord, userTaskModel, usertaskinfoList));
        return result;
    }

    private static List<UserTaskInfoModel> checkFinishByDependlast(UserTaskModel usertask, UserTaskInfoModel curUsertaskinfo, TaskOperateResult result) {
        if (Objects.equals(TaskStatusEnum.FINISH.getCode(), curUsertaskinfo.getStatus())) {
            result.add(TaskOperateMsgEnum.FINISHED, new Object[0]);
            return Collections.emptyList();
        }
        List usertaskinfoList = UserTaskHelper.loadUserTaskInfo((Long)usertask.getId(), (Integer)curUsertaskinfo.getExecuteseq());
        if (CollectionUtils.isEmpty((Collection)usertaskinfoList)) {
            return usertaskinfoList;
        }
        List<UserTaskInfoModel> noFinishList = usertaskinfoList.stream().filter(e -> !Objects.equals(TaskStatusEnum.FINISH.getCode(), e.getStatus())).collect(Collectors.toList());
        if (noFinishList.size() > 1) {
            for (UserTaskInfoModel e2 : noFinishList) {
                if (Objects.equals(e2.getId(), curUsertaskinfo.getId()) || !Objects.equals("1", e2.getActivityModel().getIsdependlast())) continue;
                result.add(TaskOperateMsgEnum.NEED_FINISH_BEFORE, new Object[]{((OrmLocaleValue)e2.getActivityModel().getActName()).getLocaleValue()});
                break;
            }
        }
        return noFinishList;
    }

    private static boolean checkCancel(UserTaskInfoModel curUsertaskinfo, TaskOperateResult result) {
        if (!Objects.equals(TaskStatusEnum.FINISH.getCode(), curUsertaskinfo.getStatus())) {
            result.add(TaskOperateMsgEnum.CANCELED, new Object[0]);
            return false;
        }
        Long usertaskId = curUsertaskinfo.getUsertask();
        List list = UserTaskHelper.loadUserTaskInfo((Long)usertaskId, null);
        int index = 0;
        boolean flag = false;
        for (UserTaskInfoModel e : list) {
            if (Objects.equals(e.getId(), curUsertaskinfo.getId()) && (index == list.size() - 1 || index + 1 < list.size() && !Objects.equals(TaskStatusEnum.FINISH.getCode(), ((UserTaskInfoModel)list.get(index + 1)).getStatus()))) {
                flag = true;
                break;
            }
            ++index;
        }
        if (!flag) {
            result.add(TaskOperateMsgEnum.NO_LAST_FINISH, new Object[]{((OrmLocaleValue)curUsertaskinfo.getActivityModel().getActName()).getLocaleValue()});
        }
        return flag;
    }

    private static TaskOperateResult doFinish(long orgId, TaskRecordModel taskRecord, UserTaskModel usertask, UserTaskInfoModel curUsertaskinfo, boolean doRelevantop) {
        TaskOperateResult result = TaskOperateResult.of();
        List<UserTaskInfoModel> noFinishList = TaskOperateHelper.checkFinishByDependlast(usertask, curUsertaskinfo, result);
        if (!result.getResult().isSuccess()) {
            return result;
        }
        int index = 0;
        StatusContext ctx = new StatusContext();
        ctx.setEntityMemberId(Long.valueOf(orgId > 0L ? orgId : TaskOperateHelper.getEntityMemberId(usertask)));
        TaskOperateHelper.setFixedItem(ctx, usertask, taskRecord);
        for (UserTaskInfoModel e : noFinishList) {
            boolean relevantop;
            TaskRelaOperEnum operEnum = e.getActivityModel().getRelevantop();
            boolean bl = !Objects.equals(e.getId(), curUsertaskinfo.getId()) ? operEnum != TaskRelaOperEnum.NULL : (relevantop = operEnum != TaskRelaOperEnum.NULL && doRelevantop);
            if (relevantop) {
                ctx.init(e.getActivityModel(), null);
                ctx.setUserTaskInfoId(Long.valueOf(e.getId()));
                ResultBox statusResult = TaskOperateHelper.doRelevantop(ctx, operEnum, true, f -> AbstractStatus.getInstance((StatusContext)ctx).finish());
                result.setLastStatusResult(statusResult);
                result.setOperName(operEnum.getName());
                if (null == statusResult.getData() || !((Boolean)statusResult.getData()).booleanValue()) break;
            }
            e.setStatus(TaskStatusEnum.FINISH.getCode());
            ++index;
        }
        result.setSuccessList(noFinishList.subList(0, index));
        return result;
    }

    private static TaskOperateResult doCancel(long orgId, TaskRecordModel taskRecord, UserTaskModel usertask, UserTaskInfoModel curUsertaskinfo, boolean doRelevantop) {
        TaskOperateResult result = TaskOperateResult.of();
        TaskRelaOperEnum operEnum = curUsertaskinfo.getActivityModel().getRelevantop();
        if (operEnum != TaskRelaOperEnum.NULL && doRelevantop) {
            StatusContext ctx = new StatusContext();
            ctx.setEntityMemberId(Long.valueOf(orgId > 0L ? orgId : TaskOperateHelper.getEntityMemberId(usertask)));
            TaskOperateHelper.setFixedItem(ctx, usertask, taskRecord);
            ctx.init(curUsertaskinfo.getActivityModel(), null);
            ctx.setUserTaskInfoId(Long.valueOf(curUsertaskinfo.getId()));
            ResultBox statusResult = TaskOperateHelper.doRelevantop(ctx, operEnum, false, f -> AbstractStatus.getInstance((StatusContext)ctx).cancel());
            result.setLastStatusResult(statusResult);
            result.setOperName(operEnum.getName());
            if (null == statusResult.getData() || !((Boolean)statusResult.getData()).booleanValue()) {
                return result;
            }
        }
        curUsertaskinfo.setStatus(TaskStatusEnum.PROCESSING.getCode());
        ArrayList<UserTaskInfoModel> list = new ArrayList<UserTaskInfoModel>(1);
        list.add(curUsertaskinfo);
        result.setSuccessList(list);
        return result;
    }

    private static void saveStatus(UserTaskModel userTaskModel, List<UserTaskInfoModel> usertaskinfoModelList, Long curActivityId, String newUsertaskStatus, String newRecordStatus, Long nextUsertaskinfoId) {
        DynamicObject[] usertaskinfoList;
        Set usertaskinfoIds = usertaskinfoModelList.stream().map(e -> e.getId()).collect(Collectors.toSet());
        Map<Long, String> updateStatusMap = usertaskinfoModelList.stream().collect(Collectors.toMap(e -> e.getId(), e -> e.getStatus()));
        for (DynamicObject e2 : usertaskinfoList = BusinessDataServiceHelper.load((String)"bcm_usertaskinfo", (String)"id,status,modifier,modifytime", (QFilter[])new QFilter("id", "in", usertaskinfoIds).toArray())) {
            e2.set("modifier", (Object)TaskOperateHelper.getUserId());
            e2.set("modifytime", (Object)TimeServiceHelper.now());
            e2.set("status", (Object)updateStatusMap.get(e2.getLong("id")));
        }
        DynamicObject nextUsertaskinfo = null;
        if (null != nextUsertaskinfoId) {
            nextUsertaskinfo = BusinessDataServiceHelper.loadSingle((Object)nextUsertaskinfoId, (String)"bcm_usertaskinfo", (String)"id,status,modifier,modifytime");
            nextUsertaskinfo.set("modifier", (Object)TaskOperateHelper.getUserId());
            nextUsertaskinfo.set("modifytime", (Object)TimeServiceHelper.now());
            nextUsertaskinfo.set("status", (Object)TaskStatusEnum.PROCESSING.getCode());
        }
        int recordFinishnumUpdate = 0;
        Pair recordProgress = null;
        int usertaskFinishnumUpdate = Objects.equals(TaskStatusEnum.FINISH.getCode(), usertaskinfoModelList.get(0).getStatus()) ? usertaskinfoModelList.size() : -usertaskinfoModelList.size();
        Pair progress = UserTaskHelper.getUserTaskFinishProgress((Long)userTaskModel.getId());
        DynamicObject usertaskDyn = BusinessDataServiceHelper.loadSingle((Object)userTaskModel.getId(), (String)"bcm_usertask", (String)"id,activity,status,modifier,modifytime,finishnum");
        usertaskDyn.set("activity", (Object)curActivityId);
        usertaskDyn.set("finishnum", (Object)((Integer)progress.p1 + usertaskFinishnumUpdate));
        usertaskDyn.set("modifier", (Object)TaskOperateHelper.getUserId());
        usertaskDyn.set("modifytime", (Object)TimeServiceHelper.now());
        if (StringUtils.isNotEmpty((String)newUsertaskStatus)) {
            usertaskDyn.set("status", (Object)newUsertaskStatus);
            recordFinishnumUpdate = Objects.equals(TaskStatusEnum.FINISH.getCode(), newUsertaskStatus) ? 1 : -1;
            recordProgress = UserTaskHelper.getTaskRecordFinishProgress((Long)userTaskModel.getTaskrecord());
        }
        DynamicObject recordDyn = null;
        if (null != recordProgress) {
            recordDyn = BusinessDataServiceHelper.loadSingle((Object)userTaskModel.getTaskrecord(), (String)"bcm_taskrecord", (String)"id,status,modifier,modifytime,finishnum");
            if (StringUtils.isNotEmpty((String)newRecordStatus)) {
                recordDyn.set("status", (Object)newRecordStatus);
            }
            recordDyn.set("finishnum", (Object)((Integer)recordProgress.p1 + recordFinishnumUpdate));
            recordDyn.set("modifier", (Object)TaskOperateHelper.getUserId());
            recordDyn.set("modifytime", (Object)TimeServiceHelper.now());
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])usertaskinfoList);
                if (null != nextUsertaskinfo) {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{nextUsertaskinfo});
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{usertaskDyn});
                if (null != recordDyn) {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recordDyn});
                }
            }
            catch (Throwable e3) {
                tx.markRollback();
                throw new KDBizException(e3, new ErrorCode("", e3.getMessage()), new Object[0]);
            }
        }
    }

    public static long getEntityMemberId(Object usertaskObj) {
        long defValue = 0L;
        if (usertaskObj instanceof DynamicObject) {
            DynamicObject usertask = (DynamicObject)usertaskObj;
            return Objects.equals(usertask.getString("dimensiontype"), SysDimensionEnum.Entity.getMemberTreemodel()) ? usertask.getLong("member_id") : defValue;
        }
        if (usertaskObj instanceof UserTaskModel) {
            UserTaskModel usertask = (UserTaskModel)usertaskObj;
            return Objects.equals(usertask.getDimensiontype(), SysDimensionEnum.Entity.getMemberTreemodel()) ? usertask.getMember() : defValue;
        }
        return defValue;
    }

    private static void setFixedItem(StatusContext ctx, UserTaskModel usertask, TaskRecordModel taskRecord) {
        Long modelId = taskRecord.getModelId();
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        SimpleItem orgItem = SimpleItem.newOne((Object)ctx.getEntityMemberId(), (String)usertask.getMemberNumber());
        ctx.setFilterMembers(modelId, taskRecord.getFilterMemberInfo(true), modelNumber, orgItem);
    }

    private static ResultBox doRelevantop(StatusContext ctx, TaskRelaOperEnum operEnum, boolean isFinishOper, Function<Object, ResultBox> status) {
        ResultBox result;
        if (operEnum.isWatchable()) {
            StageOpTypeEnum stageOpEnum = isFinishOper ? StageOpTypeEnum.COMMIT : StageOpTypeEnum.BACK;
            result = (ResultBox)MethodOpProxy.createInstance(TaskOperateHelper.getBizAppId(), ctx.getFixedItem().getModelNum(), MergeControlListPlugin.class, stageOpEnum.getItem()).executeWithResult(() -> (ResultBox)status.apply(null));
        } else {
            result = status.apply(null);
        }
        return result;
    }

    public static String getBizAppId() {
        String appId = (String)ThreadCache.get((Object)KEY_APPID);
        return StringUtils.isNotEmpty((String)appId) ? appId : "cm";
    }

    private static String getOpDescriotion(TaskRecordModel taskRecord, UserTaskModel usertask, List<UserTaskInfoModel> usertaskinfoList) {
        String opDescriotion = ResManager.loadKDString((String)"\u4efb\u52a1[%1$s]\uff0c\u7ec4\u7ec7[%2$s]\uff0c\u6d3b\u52a8[%3$s]\uff0c%4$s", (String)"TaskOperateHelper_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String templateName = taskRecord.getTaskTemplateModel().getName();
        String orgName = usertask.getMemberName();
        String actNames = org.apache.commons.lang3.StringUtils.join((Iterable)usertaskinfoList.stream().map(e -> e.getActivityModel().getActNameString()).collect(Collectors.toList()), (String)"|");
        return String.format(opDescriotion, templateName, orgName, actNames, "%s" + ResultStatusEnum.SUCCESS.getName());
    }

    public static UserSelectModel builtUserSelectModel(IFormView formView, Long modelId, UserTaskInfoModel usertaskinfo, Long orgId) {
        UserTaskModel userTaskModel = UserTaskModel.dynToModel((Long)usertaskinfo.getUsertask());
        TaskRecordModel taskRecord = UserTaskHelper.loadTaskRecord((Long)userTaskModel.getTaskrecord());
        String modelIdStr = String.valueOf(modelId);
        String entityId = LongUtil.isvalidLong((Object)orgId) ? String.valueOf(orgId) : (Objects.equals(SysDimensionEnum.Entity.getMemberTreemodel(), userTaskModel.getDimensiontype()) ? String.valueOf(userTaskModel.getMember()) : null);
        String cslScheme = null;
        Map filterMemberMap = taskRecord.getFilterMemberInfo(false);
        String sceneId = TaskOperateHelper.getMemberId(filterMemberMap, SysDimensionEnum.Scenario);
        String yearId = TaskOperateHelper.getMemberId(filterMemberMap, SysDimensionEnum.Year);
        String periodId = TaskOperateHelper.getMemberId(filterMemberMap, SysDimensionEnum.Period);
        if (StringUtils.isNotEmpty((String)entityId)) {
            IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)modelId, (Long)Long.valueOf(entityId));
            cslScheme = String.valueOf((Long)node.getProperty("cslscheme.id"));
        }
        UserSelectModel userModel = new UserSelectModel();
        userModel.setApplication(ModelUtil.queryApp((IFormView)formView));
        userModel.setModel(modelIdStr);
        userModel.setScene(sceneId);
        userModel.setPeriod(periodId);
        userModel.setYear(yearId);
        userModel.setOrg(entityId);
        userModel.setCslScheme(cslScheme);
        userModel.setModifier(RequestContext.getOrCreate().getUserId());
        return userModel;
    }

    private static String getMemberId(Map<String, Tuple<Long, String, String>> filterMemberMap, SysDimensionEnum dimensionEnum) {
        Tuple<Long, String, String> t = filterMemberMap.get(dimensionEnum.getNumber());
        return null != t ? String.valueOf(t.p1) : null;
    }

    public static void saveUserSelect(UserSelectModel userModel) {
        UserSelectUtil.savetUserSelect(userModel);
        Long modelId = Long.valueOf(userModel.getModel());
        String entityId = userModel.getOrg();
        if (StringUtils.isNotEmpty((String)entityId)) {
            UserSelectServiceHelper.setEntity((Long)TaskOperateHelper.getUserId(), (Long)modelId, (Object)entityId);
        }
    }
}

