/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.taskmanage.helper;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.CycleTablesServiceHelper;
import kd.fi.bcm.business.serviceHelper.ReportServiceHelper;
import kd.fi.bcm.business.taskmanage.enums.TaskOperateMsgEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskRelaOperEnum;
import kd.fi.bcm.business.taskmanage.status.TaskOperateResult;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.common.model.MessageInfo;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.MainPage;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskOperateHelper;
import org.apache.commons.collections4.CollectionUtils;

public class TaskReportHelper {
    public static final String UsertaskinfoId = "usertaskinfoId";
    public static final String UsertaskTemplateIds = "usertask_templateids";
    public static final String RrefreshPageKey = "SUB_PAGEID_USERTASK_REFRESH_FLAG";
    public static final String ClickTaskOperate = "bcm_usertasktree_clicktask";
    public static final String CTStatusOperate = "bcm_usertasktree_ctstatus";
    public static final String UsertaskRelevantop = "usertask_relevantop";
    public static final String UserTaskCheckCommit = "usertask_checkcommit";
    public static final String ToTemplateByCycle = "toTemplateByCycle";

    private static boolean isBCM(IFormView formView) {
        return Objects.equals("cm", formView.getFormShowParameter().getAppId());
    }

    public static boolean showUsertaskTabpage(IFormView formView, boolean isCycleTablesView) {
        String formId = formView.getFormShowParameter().getFormId();
        boolean show = ConfigServiceHelper.getGlobalBoolParam((String)ConfigEnum.IS_SHOW_REPORTTASK.getNumber());
        show = show && Objects.equals("bcm_report_list", formId);
        return show;
    }

    public static void showUsertaskTabpage(IFormView formView, boolean isCycleTablesView, String tabpageKey) {
        boolean show = TaskReportHelper.showUsertaskTabpage(formView, isCycleTablesView);
        formView.setVisible(Boolean.valueOf(show), new String[]{tabpageKey});
    }

    public static TreeNode getOrgFocusNode(IFormView formView, Long modelId, TreeNode rootTreeNode, TreeNode selectnode, String selectorgKey) {
        String selectorg;
        String seria = formView.getPageCache().get(selectorgKey);
        List selects = StringUtils.isNotEmpty((String)seria) ? (List)ObjectSerialUtil.deSerializedBytes((String)seria) : Collections.emptyList();
        String string = selectorg = CollectionUtils.isNotEmpty((Collection)selects) ? (String)selects.get(selects.size() - 1) : null;
        if (!TaskReportHelper.isBCM(formView) || StringUtils.isEmpty((String)selectorg) || Objects.equals(selectorg, selectnode.getId()) || formView.getPageCache().get("isFromTaskManage") == null) {
            return selectnode;
        }
        IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)modelId, (Long)Long.valueOf(selectorg));
        ArrayList hitNode = new ArrayList(4);
        rootTreeNode.getTreeNodeListByText(hitNode, node.getNumber(), 999);
        if (CollectionUtils.isEmpty(hitNode)) {
            return selectnode;
        }
        ArrayList<String> newSelects = new ArrayList<String>(1);
        newSelects.add(((TreeNode)hitNode.get(0)).getId());
        formView.getPageCache().put(selectorgKey, ObjectSerialUtil.toByteSerialized(newSelects));
        return (TreeNode)hitNode.get(0);
    }

    public static void openUserTaskTreePage(AbstractFormPlugin plugin, String targetKey, Long modelId, String orgName, Long orgId, boolean isCycletable, Map<String, Long> f7IdMap, boolean isCTStatus, String orgScope) {
        if (!(plugin instanceof MainPage) || !TaskReportHelper.showUsertaskTabpage(plugin.getView(), isCycletable)) {
            return;
        }
        if (Objects.equals(Boolean.FALSE.toString(), ThreadCache.get((Object)RrefreshPageKey)) || Objects.equals(Boolean.FALSE.toString(), plugin.getPageCache().get(RrefreshPageKey))) {
            return;
        }
        orgId = TaskReportHelper.change2BaseOrg(modelId, orgId);
        TaskReportHelper.refreshUserTaskTree(plugin.getPageCache(), Boolean.FALSE.toString());
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("KEY_MODEL_ID", modelId);
        params.put("orgName", orgName);
        params.put("orgId", orgId);
        params.put("orgScope", orgScope);
        params.put("isCycletable", isCycletable);
        params.put("isCTStatus", isCTStatus);
        if (null != f7IdMap) {
            params.put(SysDimensionEnum.Scenario.getNumber(), f7IdMap.get("scenariof7id"));
            params.put(SysDimensionEnum.Year.getNumber(), f7IdMap.get("yearf7id"));
            params.put(SysDimensionEnum.Period.getNumber(), f7IdMap.get("periodf7id"));
        }
        String pageIdCacheKey = "SUB_PAGEID_USERTASK";
        String formId = "bcm_usertasktree";
        String oldPageId = plugin.getPageCache().get(pageIdCacheKey);
        if (StringUtils.isNotEmpty((String)oldPageId) && plugin.getView().getView(oldPageId) != null && !TaskReportHelper.isPageCacheExpire(plugin.getView().getView(oldPageId))) {
            CommandParam com = new CommandParam("bcm_report_list", formId, "refresh", params);
            ((MainPage)plugin).sendMsg(plugin.getView(), com);
            return;
        }
        String pageId = ((MainPage)plugin).getPageIdAndCache(plugin.getPageCache(), formId);
        plugin.getPageCache().put(pageIdCacheKey, pageId);
        FormShowParameter formParameter = new FormShowParameter();
        formParameter.setFormId(formId);
        formParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formParameter.getOpenStyle().setTargetKey(targetKey);
        formParameter.setPageId(pageId);
        formParameter.setCustomParams(params);
        plugin.getView().showForm(formParameter);
    }

    private static boolean isPageCacheExpire(IFormView formView) {
        boolean isExpire;
        block2: {
            isExpire = false;
            try {
                formView.getModel().getValue("combofield_ct");
            }
            catch (KDException e) {
                if (!Objects.equals("bos.pageCacheInvalid", e.getErrorCode().getCode())) break block2;
                isExpire = true;
            }
        }
        return isExpire;
    }

    public static Long change2BaseOrg(Long modelId, Long orgId) {
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        if (LongUtil.isvalidLong((Object)orgNode.getCopyfromId())) {
            orgId = orgNode.getCopyfromId();
        }
        return orgId;
    }

    public static void refreshUserTaskTree(boolean isTabUsertask, IPageCache pageCache) {
        if (!isTabUsertask) {
            TaskReportHelper.refreshUserTaskTree(pageCache, Boolean.TRUE.toString());
        }
    }

    private static void refreshUserTaskTree(IPageCache pageCache, String refresh) {
        pageCache.put(RrefreshPageKey, refresh);
    }

    public static void setTemplateIdByUserTask(IFormView formView, CommandParam com, Consumer<Object> action) {
        if (Objects.equals(com.getOperation(), ClickTaskOperate) && null != action) {
            IPageCache pageCache = formView.getPageCache();
            Map params = (Map)com.getParam().get(0);
            pageCache.put(UsertaskTemplateIds, JacksonUtils.toJson(params.get(UsertaskTemplateIds)));
            pageCache.put(UsertaskinfoId, String.valueOf((Long)params.get(UsertaskinfoId)));
            pageCache.put(UsertaskRelevantop, (String)params.get(UsertaskRelevantop));
            ThreadCache.put((Object)RrefreshPageKey, params.get(RrefreshPageKey));
            action.accept(null);
        }
    }

    public static Long getUsertaskinfoId(IPageCache pageCache) {
        String seria = pageCache.get(UsertaskinfoId);
        return StringUtils.isNotEmpty((String)seria) ? Long.parseLong(seria) : 0L;
    }

    public static boolean reportSubmitByUsertask(IPageCache pageCache) {
        return Objects.equals(TaskRelaOperEnum.ReportSubmit.getCode(), pageCache.get(UsertaskRelevantop));
    }

    public static void updateShowCTTypeByUserTask(IFormView formView, CommandParam com, Consumer<Boolean> action) {
        if (Objects.equals(com.getOperation(), CTStatusOperate) && null != action) {
            String isCTStatus = (String)com.getParam().get(0);
            isCTStatus = StringUtils.isNotEmpty((String)isCTStatus) ? isCTStatus : Boolean.TRUE.toString();
            action.accept(Objects.equals(Boolean.TRUE.toString(), isCTStatus));
        }
    }

    public static List<Long> getTemplateByUserTask(IPageCache pageCache) {
        String seria = pageCache.get(UsertaskTemplateIds);
        if (StringUtils.isNotEmpty((String)seria) && !"null".equals(seria)) {
            return (List)JacksonUtils.fromJson((String)seria, List.class);
        }
        return Collections.emptyList();
    }

    public static void filterTemplateByUserTask(IPageCache pageCache, Set<Long> selectTemplateIdSet, boolean isTabUsertask, Set<Long> templateByUserTask) {
        if (isTabUsertask) {
            List<Long> tplIdsByUsertask = null == templateByUserTask ? TaskReportHelper.getTemplateByUserTask(pageCache) : templateByUserTask.stream().collect(Collectors.toList());
            selectTemplateIdSet.removeIf(e -> !tplIdsByUsertask.contains(e));
        }
    }

    public static void refreshUserTaskByImmediate(AbstractFormPlugin plugin, String targetKey, Long modelId, String orgName, Long orgId, boolean isCycletable, Map<String, Long> f7IdMap, boolean isCTStatus, String orgScope) {
        TaskReportHelper.refreshUserTaskTree(false, plugin.getPageCache());
        TaskReportHelper.openUserTaskTreePage(plugin, targetKey, modelId, orgName, orgId, isCycletable, f7IdMap, isCTStatus, orgScope);
    }

    public static TreeNode getTemplateTree(List<Map<String, String>> templatecatalogList, DynamicObjectCollection templateColls, List<TreeNode> templateNodeList, String rootid, TreeNode root, boolean disable) {
        if (templateNodeList.size() != 0) {
            root.setChildren(templateNodeList);
        }
        if (templatecatalogList.size() == 0) {
            return new TreeNode();
        }
        Iterator<Map<String, String>> iter = templatecatalogList.iterator();
        String fieldId = "";
        String fieldName = "";
        String parentid = "";
        while (iter.hasNext()) {
            Map<String, String> map = iter.next();
            fieldId = map.get("id");
            fieldName = map.get("name");
            parentid = map.get("parentid");
            if (!parentid.equals(rootid)) continue;
            if (templateColls != null && templateColls.size() > 0) {
                templateNodeList = new ArrayList<TreeNode>();
                for (DynamicObject templateObject : templateColls) {
                    if (!templateObject.get("templatecatalog").toString().equals(fieldId)) continue;
                    TreeNode templateNode = new TreeNode();
                    templateNode.setLeaf(true);
                    templateNode.setDisabled(disable);
                    templateNode.setParentid(fieldId);
                    templateNode.setId(templateObject.get("id").toString());
                    String versionnumber = templateObject.getDynamicObjectType().getProperty("versionnumber") == null ? "" : String.format("V%.1f", Float.valueOf(templateObject.getBigDecimal("versionnumber").floatValue()));
                    templateNode.setText(templateObject.get("number").toString() + "   " + templateObject.get("name").toString() + "   " + versionnumber);
                    templateNode.setData(null);
                    templateNodeList.add(templateNode);
                }
            }
            TreeNode entry = new TreeNode();
            entry.setParentid(parentid);
            entry.setId(fieldId);
            entry.setText(fieldName);
            entry.setData((Object)map.get("number"));
            entry = TaskReportHelper.getTemplateTree(templatecatalogList, templateColls, templateNodeList, fieldId, entry, disable);
            ArrayList<TreeNode> children = root.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>();
                root.setChildren(children);
            }
            if (entry.getChildren() != null) {
                children.add(entry);
            }
            entry.setIsOpened(true);
        }
        return root;
    }

    public static DynamicObjectCollection getTempDisCycletable(Long modelId, List<Long> cycletableIds) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        if (CollectionUtils.isNotEmpty(cycletableIds)) {
            filter.and("cycletable", "in", cycletableIds);
        }
        String selectFields = "id, model, template, cycletable, template.number";
        DynamicObjectCollection disObjs = QueryServiceHelper.query((String)"bcm_tempdiscycletable", (String)selectFields, (QFilter[])new QFilter[]{filter});
        return disObjs;
    }

    public static List<String> getTemplateNumbersByCycletable(Long modelId, List<Long> cycletableIds) {
        DynamicObjectCollection list = TaskReportHelper.getTempDisCycletable(modelId, cycletableIds);
        return list.stream().map(e -> e.getString("template.number")).collect(Collectors.toList());
    }

    public static List<Long> getTemplateIdsByCycletable(Long modelId, List<Long> cycletableIds) {
        DynamicObjectCollection list = TaskReportHelper.getTempDisCycletable(modelId, cycletableIds);
        return list.stream().map(e -> e.getLong("template")).collect(Collectors.toList());
    }

    public static Map<Long, Long> getTempDisCycletable(Long modelId) {
        DynamicObjectCollection disObjs = TaskReportHelper.getTempDisCycletable(modelId, null);
        Map<Long, Long> map = disObjs.stream().collect(Collectors.toMap(e -> e.getLong("template"), e -> e.getLong("cycletable")));
        return map;
    }

    public static DynamicObjectCollection getCycleTableList(Long modelId, List<Long> ids, boolean isContainRoot) {
        return TaskReportHelper.getCycleTableList(modelId, ids, isContainRoot, null);
    }

    public static DynamicObjectCollection getCycleTableList(Long modelId, List<Long> ids, boolean isContainRoot, List<Long> scenarioIds) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        if (CollectionUtils.isNotEmpty(ids)) {
            filter.and("id", "in", ids);
        }
        if (!isContainRoot) {
            filter.and("parent.id", "!=", (Object)0);
        }
        if (CollectionUtils.isNotEmpty(scenarioIds)) {
            scenarioIds.add(0L);
            filter.and("scenario", "in", scenarioIds);
        }
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id,name,number,scenario,parent,number as longnumber,belongtask";
        String orderBys = "sequence";
        return QueryServiceHelper.query((String)"bcm_cycletable", (String)selectFields, (QFilter[])filters, (String)orderBys);
    }

    public static Set<Long> getAllCycleTables(Long modelid) {
        Collection allCycleIds = CycleTablesServiceHelper.getAllCycleTables((Long)modelid);
        return null != allCycleIds ? Sets.newHashSet((Iterable)allCycleIds) : Collections.emptySet();
    }

    public static DynamicObjectCollection getTemplatecatalogList(Long modelId) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{filter, TemplateCatalogTypeEnum.getTemplateCalcogFilter()};
        String selectFields = "id,parent,name,longnumber,number";
        String orderBys = "longnumber";
        return QueryServiceHelper.query((String)"bcm_templatecatalog", (String)selectFields, (QFilter[])filters, (String)orderBys);
    }

    public static void replaceByCycletable(Long modelId, DynamicObjectCollection result) {
        Map<Long, Long> cycletableMap = TaskReportHelper.getTempDisCycletable(modelId);
        result.forEach(c -> {
            Long cycletableId = (Long)cycletableMap.get(c.getLong("id"));
            if (LongUtil.isvalidLong((Object)cycletableId)) {
                c.set("templatecatalog", (Object)cycletableId);
            }
        });
    }

    public static DynamicObjectCollection queryTemplate(Collection<Long> ids) {
        return TaskReportHelper.queryTemplate(new QFilter("id", "in", ids));
    }

    public static DynamicObjectCollection queryTemplate(QFilter filter) {
        String selectFields = "id,name,templatecatalog,number,group,templatecatalog.name";
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"bcm_templateentity", (String)selectFields, (QFilter[])filter.toArray(), (String)"sequence,number asc,versionnumber asc");
        return queryResult;
    }

    public static Map<Long, Set<Long>> getTemplate2OrgMap(Set<Long> selectTemplateIdSet, Set<Long> orgRangeBsaeMembers) {
        if (CollectionUtils.isEmpty(selectTemplateIdSet) || CollectionUtils.isEmpty(orgRangeBsaeMembers)) {
            return Collections.emptyMap();
        }
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(selectTemplateIdSet.size());
        selectTemplateIdSet.forEach(e -> map.put((Long)e, orgRangeBsaeMembers));
        return map;
    }

    public static Map<Long, Set<Long>> getCycleTablesDisByOrg(Set<Long> cycleIds, Set<Long> orgIds) {
        if (CollectionUtils.isEmpty(cycleIds) || CollectionUtils.isEmpty(orgIds)) {
            return Collections.emptyMap();
        }
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(orgIds.size());
        orgIds.forEach(e -> map.put((Long)e, cycleIds));
        return map;
    }

    public static String checkCommitByUserTask(boolean isTabUsertask, boolean isCycleTablesView, boolean isShowCTStatus, IPageCache pageCache, Map<Pair<Object, Object>, Pair<List<Long>, List<Long>>> orgCtCheckTemplateResult, Map<Pair<Object, Object>, DynamicObject> orgCtReportMap, boolean isFinishOper) {
        String taskErrorMsg;
        Set commitedTemplate;
        Set dealTemplate;
        DynamicObjectCollection reports;
        Set<Long> allTemplates;
        List successIds;
        if (isCycleTablesView && !isShowCTStatus || !isTabUsertask || !TaskReportHelper.reportSubmitByUsertask(pageCache)) {
            return null;
        }
        List errorCtList = orgCtCheckTemplateResult.entrySet().stream().filter(e -> CollectionUtils.isNotEmpty((Collection)((Collection)((Pair)e.getValue()).p2))).map(e -> (Pair)e.getKey()).collect(Collectors.toList());
        if (!isCycleTablesView) {
            successIds = orgCtCheckTemplateResult.entrySet().stream().flatMap(e -> ((List)((Pair)e.getValue()).p1).stream()).distinct().collect(Collectors.toList());
        } else {
            successIds = orgCtCheckTemplateResult.entrySet().stream().filter(e -> CollectionUtils.isNotEmpty((Collection)((Collection)((Pair)e.getValue()).p1)) && CollectionUtils.isEmpty((Collection)((Collection)((Pair)e.getValue()).p2))).map(e -> ((DynamicObject)orgCtReportMap.get(e.getKey())).getLong("cycletablerpt.id")).collect(Collectors.toList());
            List commitCtByError = errorCtList.stream().filter(e -> Objects.equals(ReportStatusEnum.COMMIT.status(), ((DynamicObject)orgCtReportMap.get(e)).getString("reportstatus"))).collect(Collectors.toList());
            errorCtList.removeAll(commitCtByError);
            successIds.addAll(commitCtByError.stream().map(e -> ((DynamicObject)orgCtReportMap.get(e)).getLong("cycletablerpt.id")).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty(errorCtList) || CollectionUtils.isEmpty(successIds)) {
            return null;
        }
        Set<Long> tplByUsertask = TaskReportHelper.getTemplateByUserTask(pageCache).stream().collect(Collectors.toSet());
        if (!isCycleTablesView) {
            allTemplates = TaskReportHelper.queryTemplate(tplByUsertask).stream().map(e -> e.getLong("group")).collect(Collectors.toSet());
            reports = ReportServiceHelper.queryReport(successIds);
            dealTemplate = reports.stream().map(e -> e.getLong("template.group")).collect(Collectors.toSet());
            commitedTemplate = ReportServiceHelper.getCommitTemplateByReport((DynamicObject)((DynamicObject)reports.get(0)));
        } else {
            allTemplates = tplByUsertask;
            reports = ReportServiceHelper.queryCycleTableReport(successIds);
            dealTemplate = reports.stream().map(e -> e.getLong("cycletable.id")).collect(Collectors.toSet());
            commitedTemplate = ReportServiceHelper.getCommitCycleTableByReport((DynamicObject)((DynamicObject)reports.get(0)), tplByUsertask);
        }
        if (isFinishOper) {
            commitedTemplate.addAll(dealTemplate);
            if (!commitedTemplate.containsAll(allTemplates)) {
                return null;
            }
        } else {
            HashSet commitedTemplate2 = new HashSet(commitedTemplate);
            commitedTemplate2.removeAll(dealTemplate);
            if (!commitedTemplate.containsAll(allTemplates) || commitedTemplate2.containsAll(allTemplates)) {
                return null;
            }
        }
        String message = null;
        TaskOperateResult result = TaskOperateHelper.checkFinishByActivity(TaskReportHelper.getUsertaskinfoId(pageCache), isFinishOper);
        String string = taskErrorMsg = CollectionUtils.isNotEmpty((Collection)result.getResult().getTipList()) ? ((MessageInfo)result.getResult().getTipList().get(0)).getMessage() : "";
        if (TaskOperateMsgEnum.NEED_FINISH_BEFORE == result.getMsgEnum()) {
            message = String.format(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u4e0a\u62a5\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5\uff1a\u201c%s\u201d\u3002", (String)"TaskReportHelper_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), taskErrorMsg);
        }
        if (TaskOperateMsgEnum.NO_LAST_FINISH == result.getMsgEnum()) {
            message = String.format(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u6253\u56de\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5\uff1a\u201c%s\u201d\u3002", (String)"TaskReportHelper_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), taskErrorMsg);
        }
        ThreadCache.put((Object)UserTaskCheckCommit, (Object)String.valueOf(result.getResult().isSuccess()));
        return message;
    }

    public static String commitByUserTask(Long orgId, boolean isTabUsertask, IPageCache pageCache, boolean isFinishOper) {
        if (!(isTabUsertask && TaskReportHelper.reportSubmitByUsertask(pageCache) && TaskReportHelper.isCommitByUserTask())) {
            return null;
        }
        String message = null;
        TaskOperateResult result = TaskOperateHelper.finishByActivity(orgId, TaskReportHelper.getUsertaskinfoId(pageCache), isFinishOper);
        if (!result.getResult().isSuccess()) {
            message = result.getResult().isError() ? ((MessageInfo)result.getResult().getErrorList().get(0)).getMessage() : ((MessageInfo)result.getResult().getTipList().get(0)).getMessage();
        } else if (null == result.getLastStatusResult().getData() || !((Boolean)result.getLastStatusResult().getData()).booleanValue()) {
            String title = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5b58\u5728\u672a\u5904\u7406\u7684\u8bb0\u5f55\u3002", (String)"MergeControlListPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]), result.getOperName());
            List msgs = result.getLastStatusResult().getMessageList().stream().map(MessageInfo::getMessage).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(msgs)) {
                msgs.add(0, title);
                message = Joiner.on((String)"\n").join(msgs);
            }
        }
        return message;
    }

    public static boolean isCommitByUserTask() {
        return Objects.equals(Boolean.TRUE.toString(), ThreadCache.get((Object)UserTaskCheckCommit));
    }
}

