/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.taskmanage.helper;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.formplugin.SavePlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.taskmanage.helper.TaskRecordServiceHelper;
import kd.fi.bcm.business.taskmanage.model.TaskRecordModel;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.task.TaskRecordTask;
import org.apache.commons.collections4.CollectionUtils;

public class TaskScheduleHelper {
    public static final String TaskRecordId = "taskRecordId";
    public static final String Operate = "operate";
    public static final String OperateBegin = "begin";
    public static final String OperateEnd = "end";
    public static final String EndTime = "endTime";
    public static final String DateFormat = "yyyy-MM-dd HH:mm:ss";

    public static String createSchedule(Long taskRecordId, Date recordBeginTime, Date recordEndTime) {
        if (null == recordBeginTime && null == recordEndTime) {
            return "";
        }
        String scheduleNumber = TaskScheduleHelper.numberFormat(taskRecordId, true);
        DynamicObject scheduleDyn = TaskScheduleHelper.getScheduleDyn(scheduleNumber);
        if (null != scheduleDyn) {
            String scheduleId = (String)scheduleDyn.getPkValue();
            return scheduleId;
        }
        String scheduleId = Uuid16.create().toString();
        String name = ResManager.loadKDString((String)"\u4efb\u52a1\u7ba1\u7406\u5b9e\u4f8b%s", (String)"TaskScheduleHelper_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String scheduleName = String.format(name, ResManager.loadKDString((String)"\u8ba1\u5212", (String)"TaskScheduleHelper_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        Calendar expireTime = Calendar.getInstance();
        expireTime.setTime(null != recordEndTime ? recordEndTime : recordBeginTime);
        expireTime.add(11, 1);
        Date planTime = null != recordBeginTime ? recordBeginTime : recordEndTime;
        Map<String, Object> paramMap = TaskScheduleHelper.buildJobParamMap(taskRecordId, recordBeginTime, recordEndTime);
        String jobName = String.format(name, ResManager.loadKDString((String)"\u4f5c\u4e1a", (String)"TaskScheduleHelper_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        String jobNumber = TaskScheduleHelper.numberFormat(taskRecordId, false);
        DynamicObject jobDyn = TaskScheduleHelper.saveJobInfo(jobNumber, jobName, paramMap);
        scheduleDyn = ORM.create().newDynamicObject("sch_schedule");
        scheduleDyn.set("id", (Object)scheduleId);
        scheduleDyn.set("number", (Object)scheduleNumber);
        scheduleDyn.set("name", (Object)scheduleName);
        scheduleDyn.set("status", (Object)"1");
        scheduleDyn.set("txthost", (Object)SavePlugin.getHostIpAddress());
        scheduleDyn.set("starttime", (Object)TimeServiceHelper.now());
        scheduleDyn.set("endtime", (Object)expireTime.getTime());
        scheduleDyn.set("repeatmode", (Object)"def");
        scheduleDyn.set("cyclenum", (Object)1);
        scheduleDyn.set("plan", (Object)TaskScheduleHelper.dateToCron(planTime));
        scheduleDyn.set("schprincipal", (Object)RequestContext.get().getUserId());
        scheduleDyn.set("job", jobDyn.getPkValue());
        DynamicObjectCollection joblist = scheduleDyn.getDynamicObjectCollection("entryentity");
        DynamicObject job = ORM.create().newDynamicObject(joblist.getDynamicObjectType());
        job.set("jobnumber", jobDyn.getPkValue());
        joblist.add((Object)job);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheduleDyn});
        return scheduleId;
    }

    public static Map<String, Object> buildJobParamMap(Long taskRecordId, Date recordBeginTime, Date recordEndTime) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        paramMap.put(TaskRecordId, String.valueOf(taskRecordId));
        paramMap.put(Operate, null != recordBeginTime ? OperateBegin : OperateEnd);
        return paramMap;
    }

    private static String numberFormat(Long taskRecordId, boolean isSchedule) {
        String numberPre = "bcm_taskrecord";
        if (isSchedule) {
            return String.format("cm_%s_%s_SKDP_S", numberPre, taskRecordId);
        }
        return String.format("cm_%s_%s_SKDJ_S", numberPre, taskRecordId);
    }

    private static DynamicObject saveJobInfo(String jobNumber, String jobName, Map<String, Object> paramMap) {
        String classname = TaskRecordTask.class.getName();
        String taskDefineId = TaskScheduleHelper.getTaskDefineId(classname);
        if (StringUtils.isEmpty((CharSequence)taskDefineId)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u5ea6\u4efb\u52a1\u7c7b\u201c%s\u201c\u4e0d\u5b58\u5728\u3002", (String)"TaskScheduleHelper_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), classname));
        }
        String number = jobNumber;
        DynamicObject jobInfo = ORM.create().newDynamicObject("sch_job");
        jobInfo.set("id", (Object)Uuid16.create().toString());
        jobInfo.set("name", (Object)jobName);
        jobInfo.set("number", (Object)(StringUtils.isNotBlank((CharSequence)number) ? number : "JOB" + new SecureRandom().nextDouble() * 10000.0));
        jobInfo.set("jobtype", (Object)"BIZ");
        jobInfo.set("classname", (Object)classname);
        jobInfo.set("taskclassname", (Object)taskDefineId);
        TaskScheduleHelper.setJobParams(jobInfo, paramMap);
        jobInfo.set("status", (Object)1);
        jobInfo.set("runbyuser", (Object)RequestContext.get().getUserId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{jobInfo});
        return jobInfo;
    }

    public static void setJobParams(DynamicObject jobInfo, Map<String, Object> paramMap) {
        if (null == paramMap || paramMap.isEmpty()) {
            return;
        }
        jobInfo.set("params", (Object)JacksonUtils.toJson(paramMap));
        DynamicObjectCollection entrys = jobInfo.getDynamicObjectCollection("entryentity");
        entrys.clear();
        int seq = 0;
        for (Map.Entry<String, Object> param : paramMap.entrySet()) {
            DynamicObject row = (DynamicObject)entrys.getDynamicObjectType().createInstance();
            row.set("paramname", (Object)param.getKey());
            row.set("paramvalue", (Object)param.getValue().toString());
            row.set("paramtype", (Object)"0");
            row.set("seq", (Object)seq++);
            entrys.add((Object)row);
        }
    }

    public static String dateToCron(Date cronDate) {
        String cronPattern = "%s %s %s %s %s ?";
        Calendar cronCal = Calendar.getInstance();
        cronCal.setTime(cronDate);
        String cron = String.format(cronPattern, cronCal.get(13), cronCal.get(12), cronCal.get(11), cronCal.get(5), cronCal.get(2) + 1);
        return cron;
    }

    public static void deleteSchedule(String scheduleId) {
        if (StringUtils.isEmpty((CharSequence)scheduleId)) {
            return;
        }
        HashSet<String> scheduleIds = new HashSet<String>(1);
        scheduleIds.add(scheduleId);
        TaskScheduleHelper.deleteSchedule(scheduleIds);
    }

    public static void deleteSchedule(Set<String> scheduleIds) {
        if (CollectionUtils.isEmpty(scheduleIds)) {
            return;
        }
        QFilter filter = new QFilter("id", "in", scheduleIds);
        DynamicObjectCollection scheduleList = QueryServiceHelper.query((String)"sch_schedule", (String)"id,job.id", (QFilter[])filter.toArray());
        Set<String> jobIds = scheduleList.stream().map(e -> e.getString("job.id")).collect(Collectors.toSet());
        DeleteServiceHelper.delete((String)"sch_task", (QFilter[])new QFilter("schedule", "in", scheduleIds).toArray());
        DeleteServiceHelper.delete((String)"sch_schedule", (QFilter[])filter.toArray());
        DeleteServiceHelper.delete((String)"sch_job", (QFilter[])new QFilter("id", "in", jobIds).toArray());
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleIds.forEach(e -> scheduleManager.afterDeleteSchedule(e));
        jobIds.forEach(e -> scheduleManager.afterDeleteJob(e));
    }

    public static String getTaskDefineId(String className) {
        QFilter filter = new QFilter("classname", "=", (Object)className);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"sch_taskdefine", (String)"id,number", (QFilter[])filter.toArray());
        return null != dyn ? dyn.getString("id") : null;
    }

    public static DynamicObject getScheduleDyn(String number) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        return BusinessDataServiceHelper.loadSingle((String)"sch_schedule", (String)"id,number,job", (QFilter[])filter.toArray());
    }

    public static void addSchedule(String scheduleId) {
        if (StringUtils.isEmpty((CharSequence)scheduleId)) {
            return;
        }
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.afterAddSchedule(scheduleId);
    }

    public static void taskRecordJobRun(Map<String, Object> map) {
        Long taskRecordId = Long.valueOf((String)map.get(TaskRecordId));
        String operate = (String)map.get(Operate);
        TaskRecordModel recordModel = TaskRecordServiceHelper.beginRecord((Long)taskRecordId, (boolean)Objects.equals(operate, OperateBegin));
        String scheduleId = recordModel.getScheduleId();
        if (Objects.equals(operate, OperateEnd)) {
            return;
        }
        Date endTime = recordModel.getEndTime();
        DynamicObject scheduleDyn = BusinessDataServiceHelper.loadSingle((Object)scheduleId, (String)"sch_schedule", (String)"id,job,plan");
        DynamicObject jobDyn = BusinessDataServiceHelper.loadSingle((Object)scheduleDyn.getString("job.id"), (String)"sch_job");
        boolean updatePlan = null != endTime;
        map.put(Operate, OperateEnd);
        TaskScheduleHelper.setJobParams(jobDyn, map);
        try (TXHandle tx = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{jobDyn});
                if (updatePlan) {
                    scheduleDyn.set("plan", (Object)TaskScheduleHelper.dateToCron(endTime));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheduleDyn});
                }
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
        if (updatePlan) {
            ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            scheduleManager.afterUpdateSchedule(scheduleId);
            scheduleManager.afterUpdateJob((String)jobDyn.getPkValue());
        }
    }

    public static void updateTaskRecordEndTime(List<String> scheduleIds, Date endTime) {
        DynamicObject[] scheduleDyns = BusinessDataServiceHelper.load((String)"sch_schedule", (String)"id,job,plan,endtime", (QFilter[])new QFilter("id", "in", scheduleIds).toArray());
        List jobIds = Arrays.stream(scheduleDyns).map(e -> e.getString("job.id")).collect(Collectors.toList());
        DynamicObject[] jobDyns = BusinessDataServiceHelper.load((String)"sch_job", (String)"id,entryentity.paramname,entryentity.paramvalue", (QFilter[])new QFilter("id", "in", jobIds).toArray());
        Map<String, DynamicObject> jobDynsMap = Arrays.stream(jobDyns).collect(Collectors.toMap(e -> e.getString("id"), e -> e));
        Calendar expireTime = Calendar.getInstance();
        if (null != endTime) {
            expireTime.setTime(endTime);
            expireTime.add(11, 1);
        }
        for (DynamicObject scheduleDyn : scheduleDyns) {
            DynamicObject jobDyn = jobDynsMap.get(scheduleDyn.getString("job.id"));
            DynamicObjectCollection jobParams = jobDyn.getDynamicObjectCollection("entryentity");
            DynamicObject operateParam = jobParams.stream().filter(e -> Objects.equals(Operate, e.getString("paramname"))).findFirst().orElseGet(() -> null);
            if (!Objects.equals(OperateEnd, null != operateParam ? operateParam.getString("paramvalue") : "")) continue;
            if (null != endTime) {
                scheduleDyn.set("plan", (Object)TaskScheduleHelper.dateToCron(endTime));
            }
            scheduleDyn.set("endtime", (Object)expireTime.getTime());
        }
        SaveServiceHelper.save((DynamicObject[])scheduleDyns);
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        for (String scheduleId : scheduleIds) {
            scheduleManager.afterUpdateSchedule(scheduleId);
        }
    }
}

