/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template;

import com.google.common.collect.Lists;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.business.template.model.MembSettingBaseDetail;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.SystemSeparatorChar;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.PositionTypeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.formplugin.spread.SpreadBasePlugin;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.spread.SpreadUtils;
import kd.fi.bcm.formplugin.template.model.ISpreadModelSupplier;
import kd.fi.bcm.formplugin.template.model.ISupportPageCacheProxy;
import kd.fi.bcm.formplugin.template.multiview.validators.TemplateEntryFormulaCheck;
import kd.fi.bcm.formplugin.template.multiview.validators.TemplateVerification;
import kd.fi.bcm.formplugin.util.ObjectConvertUtils;
import kd.fi.bcm.formplugin.util.TemplateUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.ColumnDimDomain;
import kd.fi.bcm.spread.domain.Domain;
import kd.fi.bcm.spread.domain.RowDimDomain;
import kd.fi.bcm.spread.domain.view.FilterView;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.SpreadSelector;
import kd.fi.bcm.spread.domain.view.builder.FreeStyleTemplateBuilder;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.model.StatusBarModel;
import org.apache.commons.collections.CollectionUtils;

public class AbstractTemplateBasePlugin
extends SpreadBasePlugin
implements ISpreadModelSupplier,
ISupportPageCacheProxy {
    protected String KEY_TEMPLATE_MODEL = "template_model";
    protected String KEY_SPREAD_MODEL = "KEY_SPREAD_MODEL";
    protected final String SPREAD_KEY = "template_spread";
    protected final String PREFIX = "bcm_";
    protected final String SUFFIX = "4formula";
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, AbstractTemplateBasePlugin.class);
    protected TemplateModel template;
    protected SpreadManager spread;
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String MODEL = "model";
    private static final String NUMBER = "number";

    @Override
    public String getSpreadKey() {
        return "template_spread";
    }

    protected Sheet getEffectiveSheet() {
        return this.getSpreadModel().getBook().getSheet(0);
    }

    protected String sugarKey(String key) {
        return ("bcm_" + key).toLowerCase(Locale.ENGLISH);
    }

    protected TemplateModel getTemplateModelFromSerial(String serial) {
        return (TemplateModel)this.deSerializedBytes(serial);
    }

    protected SpreadManager getSpreadModelFromSerial(String serial) {
        return JsonSerializerUtil.toSpreadManager((String)serial);
    }

    protected String toSerialTemplateModel(TemplateModel model) {
        return this.toByteSerialized(model);
    }

    public String toSerialSpreadModel(SpreadManager spread) {
        return JsonSerializerUtil.toJson((SpreadManager)spread);
    }

    protected boolean isTemplatePlugin() {
        return true;
    }

    @Override
    public SpreadManager getSpreadModel() {
        if (this.spread != null) {
            return this.spread;
        }
        Predicate<String> p = t -> StringUtils.isEmpty((String)t);
        String schema = this.getPageCache().get(this.KEY_SPREAD_MODEL);
        if (p.test(schema)) {
            schema = (String)this.getFormCustomParam(this.KEY_SPREAD_MODEL);
        }
        boolean hasCache = true;
        if (p.test(schema)) {
            String string = schema = this.isTemplatePlugin() ? this.getTemplateModel().getData() : this.getTemplateModel().getRptData();
            if (p.test(schema)) {
                schema = this.getTemplateModel().getData();
            }
            hasCache = false;
        }
        this.spread = !p.test(schema) ? JsonSerializerUtil.toSpreadManager((String)schema) : this.buildSpread(false);
        if (!hasCache) {
            SpreadUtils.updateCellOnUnchangeState(this.spread.getBook(), false);
            this.cacheSpreadModel();
        }
        return this.spread;
    }

    protected QFilter getQFilterByModelID() {
        return new QFilter(MODEL, "=", (Object)this.getTemplateModel().getModelId());
    }

    @Override
    public long getModelId() {
        long id = super.getModelId();
        return id == 0L ? this.getTemplateModel().getModelId() : id;
    }

    protected boolean isFromWp() {
        return "bcm_papertmpl_process".equals(this.getPlugin().getView().getFormShowParameter().getParentFormId()) || "bcm_paperlist".equals(this.getPlugin().getView().getFormShowParameter().getParentFormId());
    }

    protected SpreadManager buildSpread(boolean hasSpread) {
        SpreadManager spread;
        TemplateModel template = this.getTemplateModel();
        if (hasSpread) {
            spread = this.getSpreadModel();
            spread.setFilter(this.builderFiltView());
            spread.getAreaManager().reSetRowColDimDomain();
        } else {
            spread = new SpreadManager(this.getTemplateModel().getName(), this.builderFiltView());
            for (AreaRangeEntry e : template.getAreaRangeEntries()) {
                PositionInfo p = new PositionInfo(e.getStartPosition(), e.getAreaRange());
                spread.getAreaManager().addArea(p, new RowDimDomain(), new ColumnDimDomain());
            }
        }
        if (!this.getTemplateModel().getAreaRangeEntries().isEmpty() && !this.isFromWp()) {
            for (AreaRangeEntry e : template.getAreaRangeEntries()) {
                PositionInfo p = new PositionInfo(e.getStartPosition(), e.getAreaRange());
                RowDimDomain rowDimDomain = spread.getAreaManager().getRowDimDoman(p);
                ColumnDimDomain colDimDomain = spread.getAreaManager().getColDimDomain(p);
                if (rowDimDomain == null) {
                    rowDimDomain = new RowDimDomain();
                }
                if (colDimDomain == null) {
                    colDimDomain = new ColumnDimDomain();
                }
                this.buildDom((Domain)rowDimDomain, e.getRowDimEntries());
                this.buildDom((Domain)colDimDomain, e.getColDimEntries());
                FreeStyleTemplateBuilder builder = new FreeStyleTemplateBuilder(spread.getBook().getSheet(0), spread.getFilter(), rowDimDomain, colDimDomain, p);
                builder.doBuild();
                spread.getAreaManager().addArea(p, rowDimDomain, colDimDomain);
            }
        }
        this.spread = spread;
        this.getPageCache().put(this.KEY_SPREAD_MODEL, this.toSerialSpreadModel(spread));
        return spread;
    }

    protected FilterView builderFiltView() {
        return null;
    }

    private void buildDom(Domain dom, List<? extends MembSettingBaseDetail> entries) {
        if (CollectionUtils.isEmpty(entries)) {
            return;
        }
        for (MembSettingBaseDetail membSettingBaseDetail : entries) {
            Dimension d = membSettingBaseDetail.getDimension();
            IDimension dim = ObjectConvertUtils.toIDimension(d);
            dom.addDimension(dim);
            for (Member m : membSettingBaseDetail.getMembers()) {
                dim.addMember(m == null ? null : ObjectConvertUtils.toDimMember(m, dim));
            }
        }
    }

    public TemplateModel getTemplateModel() {
        if (this.template != null) {
            return this.template;
        }
        Predicate<String> p = t -> StringUtils.isEmpty((String)t);
        String serial = this.getPageCache().get(this.KEY_TEMPLATE_MODEL);
        if (p.test(serial)) {
            serial = (String)this.getFormCustomParam(this.KEY_TEMPLATE_MODEL);
            this.template = !p.test(serial) ? this.getTemplateModelFromSerial(serial) : new TemplateModel();
            this.getPageCache().put(this.KEY_TEMPLATE_MODEL, this.toSerialTemplateModel(this.template));
        } else {
            this.template = this.getTemplateModelFromSerial(serial);
        }
        return this.template;
    }

    protected void cacheTemplateModel() {
        this.getTemplateModel().setRptData(null);
        this.getPageCache().put(this.KEY_TEMPLATE_MODEL, this.getTemplateModelSerial());
    }

    protected void cacheTemplateModel(TemplateModel template) {
        this.getPageCache().put(this.KEY_TEMPLATE_MODEL, this.toSerialTemplateModel(template));
    }

    protected String beforeSaveTemplate(String spreadJson, boolean isWp, List<Map<String, Object>> delFormulas) {
        Pair<String, String> pair;
        ArrayList<Map<String, Object>> delValues = new ArrayList<Map<String, Object>>(16);
        if (!delFormulas.isEmpty()) {
            delFormulas.forEach(e -> delValues.add(SpreadEasyInvoker.packedUpdateCellMap((Integer)e.get(SpreadProperties.UpdataValueMethod.R.k()), (Integer)e.get(SpreadProperties.UpdataValueMethod.C.k()), null)));
        }
        if ((pair = TemplateVerification.beforeSaveTemplate(spreadJson, this.getSpreadModel(), this.getTemplateModel(), isWp, delValues, delFormulas)) != null) {
            spreadJson = (String)pair.p1;
            if (StringUtils.isNotEmpty((String)((String)pair.p2))) {
                this.getView().showTipNotification((String)pair.p2);
            }
        }
        if (!delValues.isEmpty()) {
            SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), "template_spread", delValues);
        }
        if (!delFormulas.isEmpty()) {
            SpreadClientInvoker.invokeSetFormulaMethod(this.getClientViewProxy(), "template_spread", delFormulas);
        }
        this.cacheSpreadModel();
        return spreadJson;
    }

    protected String getTemplateModelSerial() {
        return this.toSerialTemplateModel(this.getTemplateModel());
    }

    protected String getSpreadModelSerial() {
        return this.toSerialSpreadModel(this.getSpreadModel());
    }

    protected String getSpreadModelSerial(SpreadManager spread) {
        return this.toSerialSpreadModel(spread);
    }

    public SpreadManager getCopyOfSpread() {
        return this.getSpreadModelFromSerial(this.getSpreadModelSerial());
    }

    public void cacheSpreadModel() {
        this.cacheSpreadModel(this.getSpreadModel());
    }

    @Override
    public void cacheSpreadModel(SpreadManager spread) {
        this.getPageCache().put(this.KEY_SPREAD_MODEL, JsonSerializerUtil.toJson((SpreadManager)spread));
    }

    protected Dimension convertDynaObj2Dimension(DynamicObject dynaObj) {
        Dimension dim = new Dimension();
        dim.setId(dynaObj.getLong("id"));
        dim.setNumber(dynaObj.getString(NUMBER));
        dim.setName(dynaObj.getString("name"));
        dim.setDataEntityNumber(dynaObj.getDataEntityType().getName());
        dim.setMemberEntityNumber(dynaObj.getString("membermodel"));
        return dim;
    }

    public PositionInfo getMappingFloatPosition(String tarArea, boolean isFloat) {
        AtomicReference<PositionInfo> position = new AtomicReference<PositionInfo>(TemplateUtil.getOverlapPosition(tarArea, true, this.getSpreadModel()));
        if (position.get() != null) {
            return position.get();
        }
        for (PositionInfo e : this.getSpreadModel().getAreaManager().getPostionInfoSet()) {
            List basePoints = e.getBasePoints();
            if (basePoints == null || basePoints.isEmpty()) continue;
            basePoints.forEach(basePoint -> {
                if (basePoint.getDynaRange().equals(tarArea) || ExcelUtils.isOverlap((String)basePoint.getDynaRange(), (String)tarArea)) {
                    position.set(e);
                }
            });
            if (position.get() == null) continue;
            return position.get();
        }
        for (PositionInfo e : this.getSpreadModel().getAreaManager().getPostionInfoSet()) {
            if (!ExcelUtils.isBeforeRange((String)e.getAreaRange(), (String)tarArea) || isFloat && (!isFloat || e.getExtendInfo() != null)) continue;
            return e;
        }
        return null;
    }

    public boolean isExtDataAreaRanage(String tarArea) {
        List<PositionInfo> positions = TemplateUtil.getOverlapPositions(tarArea, this.getSpreadModel());
        return !positions.isEmpty() && positions.stream().anyMatch(ps -> ps.getExtendInfo() != null);
    }

    public List<PositionInfo> getOverlapPositions(String tarArea) {
        return TemplateUtil.getOverlapPositions(tarArea, this.getSpreadModel());
    }

    protected void invokeJsupdateCellValues(int r, int c) {
        String msg = this.getEffectiveSheet().getCell(r, c).displayDimMsg();
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>();
        cellValues.add(this.packedUpdateCellMap(r, c, msg));
        this.invokeSpreadUpdateValueMethod(cellValues);
    }

    protected void invokeJsupdateCellValues(int r, int c, Object value) {
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>();
        cellValues.add(this.packedUpdateCellMap(r, c, value));
        this.invokeSpreadUpdateValueMethod(cellValues);
    }

    protected void invokeJsupdateCellValues(int r, int c, List<IDimMember> members) {
        String msg = Cell.formatDimMsg(members);
        this.getEffectiveSheet().getCell(r, c).setUserObject("cross_name", (Object)msg);
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>();
        cellValues.add(this.packedUpdateCellMap(r, c, msg));
        this.invokeSpreadUpdateValueMethod(cellValues);
    }

    protected void invokeSpreadUpdateValueMethod(List<Map<String, Object>> cellValues) {
        SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), "template_spread", cellValues);
    }

    public Map<String, Object> packedUpdateCellMap(int r, int c, Object value) {
        HashMap<String, Object> valMap = new HashMap<String, Object>();
        valMap.put(SpreadProperties.UpdataValueMethod.R.k(), r);
        valMap.put(SpreadProperties.UpdataValueMethod.C.k(), c);
        valMap.put(SpreadProperties.UpdataValueMethod.V.k(), value);
        return valMap;
    }

    public Map<String, Object> packedSetFormulaCellMap(int r, int c, Object value) {
        HashMap<String, Object> valMap = new HashMap<String, Object>();
        valMap.put(SpreadProperties.SetFormulaMethod.R.k(), r);
        valMap.put(SpreadProperties.SetFormulaMethod.C.k(), c);
        valMap.put(SpreadProperties.SetFormulaMethod.F.k(), value);
        return valMap;
    }

    protected PositionInfo checkAreaSetting(PositionInfo ps, boolean isFloat) {
        AreaRangeEntry area;
        String name;
        String string = name = isFloat ? ResManager.loadKDString((String)"\u6d6e\u52a8", (String)"AbstractTemplateBasePlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u884c\u6b21", (String)"AbstractTemplateBasePlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
        if (ps == null) {
            if (CollectionUtils.isNotEmpty((Collection)this.getSpreadModel().getAreaManager().getPostionInfoSet())) {
                ps = (PositionInfo)this.getSpreadModel().getAreaManager().getPostionInfoSet().iterator().next();
            } else {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6a21\u677f\u672a\u8bbe\u7f6e\u533a\u57df\uff0c\u4e0d\u53ef\u8bbe\u7f6e%s\u3002", (String)"AbstractTemplateBasePlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), name));
            }
        }
        if (isFloat && ((area = this.getTemplateModel().findAreaByArea(ps.getAreaRange())) == null || area.getRowDimEntries() == null || area.getColDimEntries() == null || area.getRowDimEntries().isEmpty() || area.getColDimEntries().isEmpty())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8fdb\u884c%s\u8bbe\u7f6e\u4e4b\u524d\u5fc5\u987b\u5148\u8bbe\u7f6e\u884c\u5217\u7ef4\u3002", (String)"AbstractTemplateBasePlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), name));
        }
        return ps;
    }

    protected void displaySelectCellDimCrossInfoUsedByTemplate() {
        Cell cell = this.getEffectiveSheet().getCell(this.getSelectorStartRow(), this.getSelectorStartCol());
        StatusBarModel statusBarModel = new StatusBarModel();
        List dimMembers = this.getCrossDimMember(cell);
        if (dimMembers.isEmpty() && cell.getUserObject("KEY_DIM_FLAG") != null) {
            if (((Boolean)cell.getUserObject("not_cross", (Object)false)).booleanValue() && !((Boolean)cell.getUserObject("edit_cross", (Object)false)).booleanValue()) {
                SpreadClientInvoker.invokeSetDisplayContent(this.getClientViewProxy(), "template_spread", statusBarModel);
                return;
            }
            dimMembers = (List)cell.getUserObject("KEY_DIM_FLAG");
        }
        if (!dimMembers.isEmpty()) {
            String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
            Map numberMapName = MemberReader.getDimNumberMapNameById((long)this.getModelId());
            StringBuilder dimMemberDetail = new StringBuilder("[");
            dimMembers.forEach(dimMember -> {
                String dimNumber = dimMember.getDimension().getNumber();
                String memberNumber = dimMember.getNumber();
                if (DimTypesEnum.ENTITY.getNumber().equals(dimNumber) && StringUtils.isNotEmpty((String)dimMember.getPar_SonNum())) {
                    memberNumber = dimMember.getPar_SonNum();
                }
                String dimName = "";
                String memberName = "";
                if (SystemVarsEnum.CURRENT.getNumber().equals(memberNumber)) {
                    memberName = SystemVarsEnum.CURRENT.getName();
                    if (numberMapName.get(dimNumber) != null) {
                        dimName = (String)numberMapName.get(dimNumber);
                    }
                } else {
                    IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNum, (String)dimNumber, (String)memberNumber);
                    if (node != IDNumberTreeNode.NotFoundTreeNode) {
                        dimName = (String)numberMapName.get(node.getDimNumber());
                        memberName = node.getName();
                    }
                }
                dimMemberDetail.append(dimName).append(SystemSeparatorChar.LONGNUMBER_SEPARAROT).append(memberName).append(SystemSeparatorChar.NAME_AND_NUMBER).append(memberNumber).append(SystemSeparatorChar.ADJUST_ACCOUNT);
            });
            if (dimMemberDetail.length() > 0) {
                dimMemberDetail.deleteCharAt(dimMemberDetail.lastIndexOf(SystemSeparatorChar.ADJUST_ACCOUNT.toString()));
            }
            dimMemberDetail.append("]");
            statusBarModel.setCellNameStr(dimMemberDetail.toString());
        }
        SpreadClientInvoker.invokeSetDisplayContent(this.getClientViewProxy(), "template_spread", statusBarModel);
    }

    protected void showdiplayCellDimMember() {
        int r = this.getSelectorStartRow();
        int c = this.getSelectorStartCol();
        StatusBarModel statusBarModel = new StatusBarModel();
        PositionInfo pos = TemplateUtil.getOverlapPosition(r, c, this.getSpreadModel());
        if (pos != null && pos.getExtendInfo() == null) {
            StringBuilder dimMemberDetail = new StringBuilder();
            Pair<List<DimMember>, List<DynaMembScopeInfo>> pair = new TemplateEntryFormulaCheck(this.getTemplateModel(), this.getSpreadModel()).getCellDimMember(r, c, pos, false);
            if (pair != null && !((List)pair.p1).isEmpty() && ((List)pair.p2).isEmpty()) {
                dimMemberDetail = new StringBuilder("[");
                this.getDimMemberDetail((List)pair.p1, dimMemberDetail);
                if (dimMemberDetail.length() > 0) {
                    dimMemberDetail.deleteCharAt(dimMemberDetail.lastIndexOf(SystemSeparatorChar.ADJUST_ACCOUNT.toString()));
                }
                dimMemberDetail.append("]");
            }
            if (dimMemberDetail != null && StringUtils.isNotEmpty((String)dimMemberDetail.toString())) {
                statusBarModel.setCellNameStr(dimMemberDetail.toString());
            }
        }
        SpreadClientInvoker.invokeSetDisplayContent(this.getClientViewProxy(), "template_spread", statusBarModel);
    }

    protected List<DimMember> getCrossDimMember(Cell cell) {
        return new TemplateEntryFormulaCheck(this.getTemplateModel(), this.getSpreadModel()).getCrossDimMember(cell);
    }

    public List<DimMember> cloneDimMemberList(List<DimMember> cellDims) {
        ArrayList<DimMember> dimMemberList = new ArrayList<DimMember>(cellDims.size());
        cellDims.forEach(dimMember -> dimMemberList.add(new DimMember(dimMember.getName(), dimMember.getNumber(), null, dimMember.getDimension())));
        return dimMemberList;
    }

    protected List<String> getDimNumber(AreaRangeEntry e, boolean isRow) {
        ArrayList<String> dimNumbers = new ArrayList<String>(8);
        if (isRow && e.getRowDimEntries() != null) {
            e.getRowDimEntries().forEach(rowDimensionEntry -> dimNumbers.add(rowDimensionEntry.getDimension().getNumber()));
        } else if (!isRow && e.getColDimEntries() != null) {
            e.getColDimEntries().forEach(colDimensionEntry -> dimNumbers.add(colDimensionEntry.getDimension().getNumber()));
        }
        return dimNumbers;
    }

    private StringBuilder getDimMemberDetail(List<DimMember> dimMembers, StringBuilder dimMemberDetail) {
        dimMembers.forEach(dimMember -> {
            if (dimMemberDetail.indexOf(dimMember.getDimension().getName() + SystemSeparatorChar.LONGNUMBER_SEPARAROT) < 0) {
                String number = dimMember.getNumber();
                if (DimTypesEnum.ENTITY.getNumber().equals(dimMember.getDimension().getNumber()) && StringUtils.isNotEmpty((String)dimMember.getPar_SonNum())) {
                    number = dimMember.getPar_SonNum();
                }
                dimMemberDetail.append(dimMember.getDimension().getName()).append(SystemSeparatorChar.LONGNUMBER_SEPARAROT).append(dimMember.getName()).append(SystemSeparatorChar.NAME_AND_NUMBER).append(number).append(SystemSeparatorChar.ADJUST_ACCOUNT);
            }
        });
        return dimMemberDetail;
    }

    protected List<Tuple<String, String, String>> findRowColDimList(String position, boolean isCross) {
        for (AreaRangeEntry e : this.getTemplateModel().getAreaRangeEntries()) {
            PositionInfo spreadPositionInfo = this.getSpreadModel().getAreaManager().findPositionInfo(e.getStartPosition(), e.getAreaRange());
            if (spreadPositionInfo != null) continue;
            this.getView().showConfirm(ResManager.loadKDString((String)"\u7ef4\u5ea6\u8bbe\u7f6e\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u8fd8\u539f\u6211\u7684\u6a21\u677f\u3002", (String)"AbstractMultiReportPlugin_203", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("exit_save", (IFormPlugin)this));
            break;
        }
        return new TemplateEntryFormulaCheck(this.getTemplateModel(), this.getSpreadModel()).findRowColDimList(position, isCross);
    }

    protected void fillDimTupleList(AreaRangeEntry e, List<Tuple<String, String, String>> rowColDimMesList, PositionTypeEnum positionTypeEnum) {
        new TemplateEntryFormulaCheck(this.getTemplateModel(), this.getSpreadModel()).fillDimTupleList(e, rowColDimMesList, positionTypeEnum);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String key = e.getCallBackId();
        if ("exit_save".equals(key)) {
            this.getView().close();
        }
    }

    protected void registSpreadShortcutKey() {
        SpreadClientInvoker.invokeRegistShortcutKey(this.getClientViewProxy(), this.getSpreadKey(), "openDebug", "F8", true, true, true);
        SpreadClientInvoker.invokeRegistShortcutKey(this.getClientViewProxy(), this.getSpreadKey(), "showDebugSwitcher", "F10", true, true, true);
        SpreadClientInvoker.invokeRegistShortcutKey(this.getClientViewProxy(), this.getSpreadKey(), "showCalcFormulaDebug", "F11", true, true, true);
    }

    public void showCalcFormulaDebug() {
        FormShowParameter formparam = new FormShowParameter();
        formparam.setFormId("bcm_calcformuladebug");
        formparam.setParentPageId(this.getView().getPageId());
        formparam.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formparam);
    }

    public void openDebug() {
        FormShowParameter formShowParameter = new FormShowParameter();
        IFormView parentView = this.getView().getParentView();
        formShowParameter.setFormId("bcm_query_mainpage");
        formShowParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
        formShowParameter.setParentFormId(this.getView().getEntityId());
        formShowParameter.setParentPageId(this.getView().getPageId());
        parentView.showForm(formShowParameter);
        this.getView().sendFormAction(parentView);
    }

    public void showDebugSwitcher() {
        FormShowParameter formparam = new FormShowParameter();
        formparam.setFormId("bcm_debugsetting");
        formparam.setParentPageId(this.getView().getPageId());
        formparam.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formparam);
    }

    @Override
    public boolean isOpenPageCacheProxy() {
        return true;
    }

    public static List<Map<String, Object>> judgeNeedClearFormula(Sheet sheet, SpreadSelector selector, List<Map<String, Integer>> selections, List<Map<String, Object>> cellValues) {
        ArrayList<Map<String, Object>> cellFormulas = new ArrayList<Map<String, Object>>(12);
        if (CollectionUtils.isNotEmpty(selections)) {
            for (Map<String, Integer> selection : selections) {
                Integer row = selection.get("row");
                Integer col = selection.get("col");
                Cell cell = sheet.getCell(row.intValue(), col.intValue());
                AbstractTemplateBasePlugin.clearCell(cell, cellFormulas, cellValues);
            }
        } else {
            for (int i = selector.getStartRow(); i < selector.getEndRow() + 1; ++i) {
                for (int j = selector.getStartCol(); j < selector.getEndCol() + 1; ++j) {
                    Cell cell = sheet.getCell(i, j);
                    AbstractTemplateBasePlugin.clearCell(cell, cellFormulas, cellValues);
                }
            }
        }
        return cellFormulas;
    }

    private static void clearCell(Cell cell, List<Map<String, Object>> cellFormulas, List<Map<String, Object>> cellValues) {
        if (cell.hasFormula()) {
            HashMap<String, Integer> e = new HashMap<String, Integer>(3);
            e.put(SpreadProperties.SetFormulaMethod.R.k(), cell.getRow());
            e.put(SpreadProperties.SetFormulaMethod.C.k(), cell.getCol());
            e.put(SpreadProperties.SetFormulaMethod.F.k(), null);
            if (cell.getValue() != null && cellValues != null) {
                HashMap<String, Object> eV = new HashMap<String, Object>(3);
                eV.put(SpreadProperties.SetFormulaMethod.R.k(), cell.getRow());
                eV.put(SpreadProperties.SetFormulaMethod.C.k(), cell.getCol());
                eV.put(SpreadProperties.UpdataValueMethod.V.k(), cell.getValue());
                cellValues.add(eV);
            }
            cellFormulas.add(e);
            cell.setFormula(null);
        }
    }

    protected String checkCanAddFormula(int row, int col) {
        TemplateEntryFormulaCheck formulaCheck = new TemplateEntryFormulaCheck(this.getTemplateModel(), this.getSpreadModel());
        formulaCheck.collectRangeModels();
        return formulaCheck.singleCellFormulaCheck(this.getEffectiveSheet().getCell(row, col), true, false);
    }

    protected AreaRangeEntry getOverlapAreaRange(String tarArea) {
        for (AreaRangeEntry e : this.getTemplateModel().getAreaRangeEntries()) {
            if (!ExcelUtils.isOverlap((String)e.getAreaRange(), (String)tarArea)) continue;
            return e;
        }
        return null;
    }

    public List<String> getAllSeqAreas() {
        ArrayList results = Lists.newArrayListWithExpectedSize((int)3);
        for (PositionInfo positionInfo : this.getSpreadModel().getAreaManager().getPostionInfoSet()) {
            if (positionInfo.getSequenceInfo() == null) continue;
            results.add(positionInfo.getSequenceInfo().getSeqArea());
        }
        return results;
    }

    public void supportGroupRC(SpreadEasyInvoker invoker) {
        if (ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"spreadgroup")) {
            invoker.addContextMenuItem("createRGroup", ResManager.loadKDString((String)"\u7ec4\u5408", (String)"AbstractTemplateBasePlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), new String[]{"rowHeader"});
            invoker.addContextMenuItem("cancelRGroup", ResManager.loadKDString((String)"\u53d6\u6d88\u7ec4\u5408", (String)"AbstractTemplateBasePlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), new String[]{"rowHeader"});
            invoker.addContextMenuItem("createCGroup", ResManager.loadKDString((String)"\u7ec4\u5408", (String)"AbstractTemplateBasePlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), new String[]{"colHeader"});
            invoker.addContextMenuItem("cancelCGroup", ResManager.loadKDString((String)"\u53d6\u6d88\u7ec4\u5408", (String)"AbstractTemplateBasePlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), new String[]{"colHeader"});
        }
    }

    public void createRGroup() {
        HashMap param = new HashMap(16);
        HashMap<String, Integer> group = new HashMap<String, Integer>(16);
        ArrayList<HashMap<String, Integer>> groups = new ArrayList<HashMap<String, Integer>>(16);
        group.put(SpreadProperties.SetOutlines.INDEX.k(), this.getSpreadSelector().getStartRow());
        group.put(SpreadProperties.SetOutlines.COUNT.k(), this.getSpreadSelector().getEndRow() - this.getSpreadSelector().getStartRow() + 1);
        groups.add(group);
        param.put(SpreadProperties.SetOutlines.GROUPS.k(), groups);
        SpreadClientInvoker.invokeSetRowOutlines(this.getClientViewProxy(), "template_spread", param);
    }

    public void cancelRGroup() {
        HashMap param = new HashMap(16);
        HashMap<String, Constable> group = new HashMap<String, Constable>(16);
        ArrayList<HashMap<String, Constable>> groups = new ArrayList<HashMap<String, Constable>>(16);
        group.put(SpreadProperties.SetOutlines.INDEX.k(), Integer.valueOf(this.getSpreadSelector().getStartRow()));
        group.put(SpreadProperties.SetOutlines.COUNT.k(), Integer.valueOf(this.getSpreadSelector().getEndRow() - this.getSpreadSelector().getStartRow() + 1));
        group.put(SpreadProperties.SetOutlines.ISHIDE.k(), Boolean.valueOf(true));
        groups.add(group);
        param.put(SpreadProperties.SetOutlines.GROUPS.k(), groups);
        SpreadClientInvoker.invokeSetRowOutlines(this.getClientViewProxy(), "template_spread", param);
    }

    public void createCGroup() {
        HashMap param = new HashMap(16);
        HashMap<String, Integer> group = new HashMap<String, Integer>(16);
        ArrayList<HashMap<String, Integer>> groups = new ArrayList<HashMap<String, Integer>>(16);
        group.put(SpreadProperties.SetOutlines.INDEX.k(), this.getSpreadSelector().getStartCol());
        group.put(SpreadProperties.SetOutlines.COUNT.k(), this.getSpreadSelector().getEndCol() - this.getSpreadSelector().getStartCol() + 1);
        groups.add(group);
        param.put(SpreadProperties.SetOutlines.GROUPS.k(), groups);
        SpreadClientInvoker.invokeSetColOutlines(this.getClientViewProxy(), "template_spread", param);
    }

    public void cancelCGroup() {
        HashMap param = new HashMap(16);
        HashMap<String, Constable> group = new HashMap<String, Constable>(16);
        ArrayList<HashMap<String, Constable>> groups = new ArrayList<HashMap<String, Constable>>(16);
        group.put(SpreadProperties.SetOutlines.INDEX.k(), Integer.valueOf(this.getSpreadSelector().getStartCol()));
        group.put(SpreadProperties.SetOutlines.COUNT.k(), Integer.valueOf(this.getSpreadSelector().getEndCol() - this.getSpreadSelector().getStartCol() + 1));
        group.put(SpreadProperties.SetOutlines.ISHIDE.k(), Boolean.valueOf(true));
        groups.add(group);
        param.put(SpreadProperties.SetOutlines.GROUPS.k(), groups);
        SpreadClientInvoker.invokeSetColOutlines(this.getClientViewProxy(), "template_spread", param);
    }
}

