/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassCache;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.template.TemplatePermCrossUtil;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.common.IRefreshList;
import kd.fi.bcm.formplugin.template.AbstractTemplateTreePlugin;
import kd.fi.bcm.formplugin.util.TemplateUtil;
import kd.fi.bcm.spread.common.TemplateConstant;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class AbstractTemplateListPlugin
extends AbstractTemplateTreePlugin
implements IRefreshList {
    private static final String BILL_LIST_AP = "billlistap";
    protected static final String TREE_CHECK_BOX = "treecheckbox";
    private static final String TEMPLATE_CATALOG = "templatecatalog";
    protected static final String[] btnAuth = new String[]{"btn_movetemplate", "btn_deltemplate", "btn_enable", "btn_addcustomtemplate", "btn_version", "btn_more", "barcopy", "btn_disable", "btn_distribution"};
    protected String isCategoryReadOnly;

    @Override
    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.setBillFormId(this.getFormTemplateEntity());
    }

    @NotNull
    protected String getFormTemplateEntity() {
        return "bcm_templateentity";
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.addListRowClickListener(new ListRowClickListener(){

            public void listRowClick(ListRowClickEvent evt) {
                if (!AbstractTemplateListPlugin.this.setButtonEnableForPerm(evt)) {
                    AbstractTemplateListPlugin.this.afterPermissionCross(evt);
                }
            }
        });
    }

    private void afterPermissionCross(ListRowClickEvent evt) {
        if (this.isUsePermissionCross()) {
            ListSelectedRowCollection rows = evt.getListSelectedRowCollection();
            for (ListSelectedRow next : rows) {
                if (this.dealTemplatePermission(LongUtil.toLong((Object)next.getPrimaryKeyValue()))) continue;
                this.getView().setEnable(Boolean.valueOf(true), btnAuth);
                return;
            }
        }
    }

    protected boolean dealTemplatePermission(long templateId) {
        List onlyRead;
        String readOnly = this.getPageCache().get("readOnlytemplates");
        boolean isOnlyRead = false;
        this.getPageCache().remove("templateonlyreader");
        if (null != readOnly && (onlyRead = (List)SerializationUtils.fromJsonString((String)readOnly, List.class)).contains(templateId)) {
            isOnlyRead = true;
        }
        if (!isOnlyRead && this.getPageCache().get("categoryReadOnly") != null) {
            if (this.isUsePermissionCross()) {
                List permissionMap = PermClassCache.getPermissionMap((IPageCache)this.getPageCache(), (String)this.getFormTemplateEntity(), (DataTypeEnum)DataTypeEnum.WRITEIN);
                if (!permissionMap.contains(templateId)) {
                    isOnlyRead = true;
                }
            } else {
                isOnlyRead = true;
            }
        }
        if (isOnlyRead) {
            this.getPageCache().put("templateonlyreader", "true");
        }
        return isOnlyRead;
    }

    @Override
    protected void refrushBillList() {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.setClearSelection(true);
        billList.setOrderBy(TemplateUtil.getListEntryOrderBy(true));
        billList.refresh();
    }

    private boolean setButtonEnableForPerm(ListRowClickEvent evt) {
        boolean hasPerm = this.checkTmpAuth(evt);
        this.getView().setEnable(Boolean.valueOf(hasPerm), btnAuth);
        return hasPerm;
    }

    private boolean checkTmpAuth(ListRowClickEvent evt) {
        ListSelectedRowCollection rows = evt.getListSelectedRowCollection();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            return true;
        }
        boolean modelManager = MemberPermHelper.isModelManager((Long)this.getModelId());
        if (modelManager) {
            return true;
        }
        if (Objects.equals("cycletableview", this.getPageCache().get("currentview"))) {
            return true;
        }
        if (this.getPageCache().get("categoryReadOnly") != null) {
            return false;
        }
        if (this.getPageCache().get("readOnlytemplates") == null) {
            return true;
        }
        List readOnlyTmpIds = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("readOnlytemplates"), List.class);
        if (!readOnlyTmpIds.isEmpty() && rows.stream().anyMatch(e -> readOnlyTmpIds.contains(e.getPrimaryKeyValue()))) {
            return false;
        }
        List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(TemplateConstant.TREELIST), List.class);
        Collection templateCatelogs = BusinessDataServiceHelper.loadFromCache((String)this.getFormTemplateEntity(), (String)"templatecatalog.id", (QFilter[])new QFilter("model", "=", (Object)this.getModelId()).and(new QFilter("id", "in", (Object)rows.getPrimaryKeyValues())).toArray()).values();
        Iterator catelogIterator = templateCatelogs.iterator();
        ArrayListMultimap catalogToTemplate = ArrayListMultimap.create();
        while (catelogIterator.hasNext()) {
            DynamicObject next = (DynamicObject)catelogIterator.next();
            catalogToTemplate.put((Object)((Long)next.get("templatecatalog.id")), (Object)((Long)next.get("id")));
        }
        this.cachePermClass(this.getTemplateCataLogEntryEntity());
        for (Map.Entry entry : catalogToTemplate.asMap().entrySet()) {
            Long key = (Long)entry.getKey();
            Map<String, String> curTreeNode = this.getCurTreeNode(treeList, key.toString());
            if (curTreeNode == null || !this.findReadParentNode(treeList, curTreeNode)) continue;
            readOnlyTmpIds.addAll((Collection)entry.getValue());
            this.getPageCache().put("readOnlytemplates", SerializationUtils.toJsonString((Object)readOnlyTmpIds));
            return false;
        }
        return true;
    }

    protected Map<String, String> getCurTreeNode(List<Map<String, String>> treeList, String nodeId) {
        for (Map<String, String> next : treeList) {
            if (!next.get("id").equals(nodeId)) continue;
            return next;
        }
        return null;
    }

    protected void cachePermClass(String entityName) {
        if (!PermClassCache.isExistsPermClassCache((IPageCache)this.getPageCache(), (String)entityName)) {
            PermClassCache.cacheNewPermission((IPageCache)this.getPageCache(), (String)entityName, (String)Long.toString(this.getModelId()));
        }
    }

    protected boolean findReadParentNode(List<Map<String, String>> treeList, Map<String, String> node) {
        List readPermIds = new ArrayList(16);
        if (this.isUsePermissionCross()) {
            readPermIds = PermClassCache.getPermissionMap((IPageCache)this.getPageCache(), (String)this.getTemplateCataLogEntryEntity(), (DataTypeEnum)DataTypeEnum.READ);
            readPermIds.addAll(PermClassCache.getPermissionMap((IPageCache)this.getPageCache(), (String)this.getTemplateCataLogEntryEntity(), (DataTypeEnum)DataTypeEnum.NO));
        } else {
            readPermIds = PermClassCache.getPermissionMap((IPageCache)this.getPageCache(), (String)this.getTemplateCataLogEntryEntity(), (DataTypeEnum)DataTypeEnum.READ);
        }
        for (Map<String, String> next : treeList) {
            if (readPermIds.contains(Long.parseLong(node.get("id")))) {
                return true;
            }
            if (!node.get(TemplateConstant.PARENTID).equals(next.get("id"))) continue;
            if (readPermIds.contains(Long.parseLong(next.get("id")))) {
                return true;
            }
            return this.findReadParentNode(treeList, next);
        }
        return false;
    }

    protected QFilter getCatalogqFilter(boolean isContainNull) {
        String nodeid = this.getPageCache().get(FOCUS_NODE_ID);
        if (this.getPageCache().get(FOCUS_NODE_ID) != null) {
            boolean isallchild = Boolean.parseBoolean(this.getModel().getValue(TREE_CHECK_BOX).toString());
            QFilter qFilter1 = new QFilter(TEMPLATE_CATALOG, "=", (Object)LongUtil.toLong((Object)nodeid));
            if (isContainNull) {
                qFilter1.or(TEMPLATE_CATALOG, "in", (Object)new Object[]{0});
            }
            if (isallchild) {
                List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(TemplateConstant.TREELIST), List.class);
                ArrayList<String> list = new ArrayList<String>(16);
                this.queryAllChildNodeList(nodeid, treeList, list);
                if (!list.isEmpty()) {
                    qFilter1.or(TEMPLATE_CATALOG, "in", (Object)LongUtil.toLongList(list));
                }
            }
            return this.getTemplateIdsQFilter(qFilter1);
        }
        return null;
    }

    protected void movetemplate() {
        DynamicObject[] tempObjs = this.getSelectedTempDynaObjs(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u52a8\u7684\u6a21\u677f\u8bb0\u5f55\u3002", (String)"AbstractTemplateListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        if (tempObjs != null) {
            List treeList;
            String nodeid = this.getPageCache().get(FOCUS_NODE_ID);
            boolean isallchild = Boolean.parseBoolean(this.getModel().getValue(TREE_CHECK_BOX).toString());
            if (isallchild && (treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(TemplateConstant.TREELIST), List.class)).size() == 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u65b0\u589e\u6a21\u677f\u5206\u7c7b\u3002", (String)"AbstractTemplateListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            String modelkey = this.getPageCache().get("KEY_MODEL_ID");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bcm_templatemove");
            showParameter.setCustomParam("KEY_MODEL_ID", (Object)modelkey);
            showParameter.setCustomParam("cataLogType", (Object)this.getCatalogtypeQFilter().recombine());
            showParameter.setCustomParam("entryentity", (Object)this.getEntryEntity());
            showParameter.setCustomParam("cataLogEntryentity", (Object)this.getTemplateCataLogEntryEntity());
            showParameter.setCustomParam("nodeid", (Object)nodeid);
            showParameter.setCustomParam("pluginName", (Object)this.getPluginName());
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_templatemove");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        }
    }

    @Override
    public void refreshList() {
        this.refrushBillList();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        if (!this.validator()) {
            return;
        }
        switch (key = evt.getItemKey()) {
            case "btn_movetemplate": {
                this.movetemplate();
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "bcm_templatemove": {
                this.refrushBillList();
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        this.getPageCache().remove("readOnlytemplates");
        QFilter filter = this.getCatalogqFilter(false);
        if (filter == null) {
            e.getQFilters().add(new QFilter("id", "=", (Object)-1));
            return;
        }
        e.getQFilters().add(filter);
        if (!MemberPermHelper.isModelManager((Long)this.getModelId())) {
            this.cachePermClass(this.getFormTemplateEntity());
            List readPermIds = new ArrayList(16);
            List noPermIds = new ArrayList(16);
            if (this.isUsePermissionCross()) {
                readPermIds = PermClassCache.getPermissionMap((IPageCache)this.getPageCache(), (String)this.getFormTemplateEntity(), (DataTypeEnum)DataTypeEnum.READ);
                List templates = TemplatePermCrossUtil.getTemplatesWithOutNoPerm((IPageCache)this.getPageCache(), (long)this.getModelId());
                QFilter qFilter = new QFilter("1", "=", (Object)0);
                if (!templates.isEmpty()) {
                    qFilter.clearNests();
                    qFilter = new QFilter("id", "in", (Object)templates);
                }
                e.getQFilters().add(qFilter);
            } else {
                noPermIds = PermClassCache.getPermissionMap((IPageCache)this.getPageCache(), (String)this.getFormTemplateEntity(), (DataTypeEnum)DataTypeEnum.NO);
                readPermIds = PermClassCache.getPermissionMap((IPageCache)this.getPageCache(), (String)this.getFormTemplateEntity(), (DataTypeEnum)DataTypeEnum.READ);
            }
            if (CollectionUtils.isNotEmpty(noPermIds)) {
                QFilter qFilter = new QFilter("id", "not in", noPermIds);
                e.getQFilters().add(qFilter);
            }
            if (CollectionUtils.isNotEmpty(readPermIds)) {
                this.getPageCache().put("readOnlytemplates", SerializationUtils.toJsonString(readPermIds));
            }
            if (this.isCategoryReadOnly != null) {
                this.getPageCache().put("categoryReadOnly", this.isCategoryReadOnly);
            } else {
                this.getPageCache().remove("categoryReadOnly");
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        if (!this.validator()) {
            return;
        }
        switch (key = e.getProperty().getName()) {
            case "treecheckbox": {
                this.refrushBillList();
                break;
            }
        }
    }
}

