/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.serviceHelper.CycleTablesServiceHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.TemplatePermCrossUtil;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.spread.common.TemplateConstant;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;

public class AbstractTemplateTreePlugin
extends AbstractBaseListPlugin {
    public static final String TEMPLATECATALOG = "templatecatalog";
    protected static final String MODEL = "model";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    protected static final String FOCUS_NODE_ID = TemplateConstant.FOCUSNODEID;
    protected static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";

    private String getOperationStatusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"AbstractTemplateTreePlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private String getOperationDelete() {
        return ResManager.loadKDString((String)"\u5220\u9664", (String)"AbstractTemplateTreePlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private String getOperationDeleteTemplate() {
        return ResManager.loadKDString((String)"\u5220\u9664\u6a21\u677f\u5206\u7c7b", (String)"AbstractTemplateTreePlugin_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private String getOperationDeleteAnalysisHelper() {
        return ResManager.loadKDString((String)"\u5220\u9664\u52a9\u624b\u65b9\u6848\u5206\u7c7b", (String)"AbstractTemplateTreePlugin_19", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refrushTree();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addListeners();
    }

    @Override
    public String getModelSign() {
        return "modelbd";
    }

    protected void addListeners() {
        this.addClickListeners("btn_addnew", "btn_delete", "btn_modify", "btn_up", "btn_down", "baritemup", "baritemdown", "btn_reset");
        TreeView tview = (TreeView)this.getControl(TEMPLATECATALOG);
        tview.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                AbstractTemplateTreePlugin.this.getPageCache().put(FOCUS_NODE_ID, evt.getNodeId().toString());
                AbstractTemplateTreePlugin.this.getPageCache().put(TemplateConstant.PARENT, evt.getParentNodeId().toString());
                AbstractTemplateTreePlugin.this.refrushBillList();
                AbstractTemplateTreePlugin.this.treeNodeClick1(LongUtil.toLong((Object)evt.getNodeId().toString()));
            }
        });
    }

    protected void treeNodeClick1(Long nodeId) {
    }

    protected void refrushBillList() {
    }

    protected QFilter getCatalogtypeQFilter() {
        return TemplateCatalogTypeEnum.getTemplateCalcog();
    }

    protected QFilter getTemplateIdsQFilter(QFilter qFilter1) {
        return null;
    }

    protected String getSelectFields() {
        return "id,name,number,parent,catalogtype";
    }

    protected boolean isUsePermissionCross() {
        return false;
    }

    protected void initTree() {
        TreeNode templatecatalog = new TreeNode();
        String nodeid = this.getPageCache().get(FOCUS_NODE_ID);
        if (this.isUsePermissionCross()) {
            TemplatePermCrossUtil.buildTemplateTree((IPageCache)this.getPageCache(), (long)this.getModelId(), (TreeNode)templatecatalog, null);
        } else if ("bcm_rptadjust".equals(this.getEntryEntity())) {
            TemplatePermCrossUtil.buildAdjustCalogTree((IPageCache)this.getPageCache(), (long)this.getModelId(), (TreeNode)templatecatalog);
        } else {
            TemplatePermCrossUtil.buildOldTemplateTree((IPageCache)this.getPageCache(), (long)this.getModelId(), (TreeNode)templatecatalog, (String)this.getClass().getName(), (String)this.getTemplateCataLogEntryEntity(), (String)this.getSelectFields(), (QFilter)this.getCatalogtypeQFilter(), Collections.emptyMap());
        }
        templatecatalog.setText(this.getRootName());
        if (StringUtils.isEmpty((String)templatecatalog.getId())) {
            return;
        }
        if (StringUtils.isEmpty((String)nodeid)) {
            nodeid = this.getPageCache().get(FOCUS_NODE_ID);
        }
        TreeView tree = (TreeView)this.getControl(TEMPLATECATALOG);
        tree.addNode(templatecatalog);
        TreeNode fo = this.findFocusNodeById(nodeid, templatecatalog);
        if (fo == null) {
            fo = templatecatalog;
            this.getPageCache().put(TemplateConstant.PARENT, fo.getParentid());
        } else {
            this.getPageCache().put(FOCUS_NODE_ID, fo.getId());
        }
        tree.focusNode(fo);
    }

    protected String getRootName() {
        return ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b", (String)"AbstractTemplateTreePlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private TreeNode findFocusNodeById(String id, TreeNode tree) {
        if (StringUtils.isEmpty((String)id) || tree == null) {
            return null;
        }
        if (id.equals(tree.getId())) {
            return tree;
        }
        if (tree.getChildren() != null) {
            for (TreeNode c : tree.getChildren()) {
                TreeNode fc = this.findFocusNodeById(id, c);
                if (fc == null) continue;
                return fc;
            }
        }
        return null;
    }

    protected List<String> queryAllChildNodeList(String nodeid, List<Map<String, String>> treeList, List<String> allnodelist) {
        for (Map<String, String> m : treeList) {
            if (!m.get(TemplateConstant.PARENTID).equals(nodeid)) continue;
            allnodelist.add(m.get("id"));
            this.queryAllChildNodeList(m.get("id"), treeList, allnodelist);
        }
        return allnodelist;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        if (!this.validator()) {
            return;
        }
        String nodeId = this.getPageCache().get(FOCUS_NODE_ID);
        if (StringUtil.isEmptyString((String)nodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u6a21\u677f\u5206\u7c7b\u6811\u8282\u70b9\u540e\u518d\u64cd\u4f5c\u3002", (String)"AbstractTemplateTreePlugin_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btn_addnew": {
                if ("cycletableview".equals(this.getPageCache().get("currentview"))) {
                    this.newCycleTable(nodeId, true);
                    break;
                }
                this.newTemplateCatalog(nodeId, true);
                break;
            }
            case "btn_delete": {
                if (nodeId.equals(this.getPageCache().get(TemplateConstant.HEADNODEID))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u5220\u9664\u6839\u8282\u70b9\u3002", (String)"AbstractTemplateTreePlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                if ("bcm_rptadjust".equals(this.getEntryEntity())) {
                    List<String> ids = this.queryAllChildNodeList(nodeId, (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(TemplateConstant.TREELIST), List.class), new ArrayList<String>(16));
                    ids.add(nodeId);
                    if (QueryServiceHelper.exists((String)"bcm_checktmpl", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId()), new QFilter("adjustcatalog.id", "in", (Object)LongUtil.toLongList(ids))})) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5206\u7c7b\u6216\u5176\u4e0b\u7ea7\u5206\u7c7b\u5df2\u88ab\u5bf9\u8d26\u6a21\u677f\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"AbstractTemplateTreePlugin_22", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                        return;
                    }
                    if (QueryServiceHelper.exists((String)"bcm_adjsetting", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId()), new QFilter("adjustcatalog.id", "in", (Object)LongUtil.toLongList(ids))})) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5206\u7c7b\u6216\u5176\u4e0b\u7ea7\u5206\u7c7b\u5df2\u88ab\u5185\u90e8\u4ea4\u6613\u5206\u5f55\u8bbe\u7f6e\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"AbstractTemplateTreePlugin_24", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                        return;
                    }
                    if (QueryServiceHelper.exists((String)"bcm_papertemplate", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId()), new QFilter("adjustcatalog.id", "in", (Object)LongUtil.toLongList(ids))})) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5206\u7c7b\u6216\u5176\u4e0b\u7ea7\u5206\u7c7b\u5df2\u88ab\u901a\u7528\u5206\u5f55\u6a21\u677f\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"AbstractTemplateTreePlugin_25", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                        return;
                    }
                    if (QueryServiceHelper.exists((String)"bcm_invelimtemplate", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId()), new QFilter("adjustcatalog.id", "in", (Object)LongUtil.toLongList(ids))})) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5206\u7c7b\u6216\u5176\u4e0b\u7ea7\u5206\u7c7b\u5df2\u88ab\u901a\u7528\u5206\u5f55\u6a21\u677f\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"AbstractTemplateTreePlugin_25", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                        return;
                    }
                    if (QueryServiceHelper.exists((String)"bcm_invsheetttplentrys", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId()), new QFilter("adjustcatalog.id", "in", (Object)LongUtil.toLongList(ids))})) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5206\u7c7b\u6216\u5176\u4e0b\u7ea7\u5206\u7c7b\u5df2\u88ab\u901a\u7528\u5206\u5f55\u6a21\u677f\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"AbstractTemplateTreePlugin_25", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                        return;
                    }
                }
                if ("cycletableview".equals(this.getPageCache().get("currentview"))) {
                    if (CycleTablesServiceHelper.isExitCycleTableRecord((Long)this.getModelId(), (Long)LongUtil.toLong((Object)nodeId))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5957\u8868\u5b58\u5728\u7f16\u5236\u5b8c\u6210\u6216\u5df2\u4e0a\u62a5\u7684\u5957\u8868\u7f16\u5236\u8bb0\u5f55\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"AbstractTemplateTreePlugin_18", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                        return;
                    }
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u5957\u8868\u5c06\u4f1a\u5220\u9664\u8be5\u5957\u8868\u7684\u6a21\u677f\u5206\u914d\u8bb0\u5f55\u53ca\u8be5\u5957\u8868\u5206\u914d\u7ec4\u7ec7\u7684\u8bb0\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\u5220\u9664\uff1f", (String)"AbstractTemplateTreePlugin_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deletecycletable_comfirm", (IFormPlugin)this));
                    break;
                }
                String msg = ResManager.loadKDString((String)"\u88ab\u5220\u6a21\u677f\u5206\u7c7b\u4e0b\u7684\u6a21\u677f\u5c06\u4f1a\u88ab\u79fb\u52a8\u5230\u5176\u76f4\u63a5\u4e0a\u7ea7\u6a21\u677f\u5206\u7c7b\u4e0a\uff0c\u662f\u5426\u7ee7\u7eed\u5220\u9664\uff1f", (String)"AbstractTemplateTreePlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                if ("bcm_rptadjust".equals(this.getEntryEntity())) {
                    msg = ResManager.loadKDString((String)"\u88ab\u5220\u5206\u5f55\u5206\u7c7b\u53ca\u5176\u4e0b\u7ea7\u7684\u5206\u5f55\u5c06\u88ab\u79fb\u52a8\u5230\u6839\u8282\u70b9\uff0c\u662f\u5426\u7ee7\u7eed\u5220\u9664\uff1f", (String)"AbstractTemplateTreePlugin_23", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                }
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deletecatalog_comfirm", (IFormPlugin)this));
                break;
            }
            case "btn_modify": {
                if (!"cycletableview".equals(this.getPageCache().get("currentview"))) {
                    this.newTemplateCatalog(nodeId, false);
                    break;
                }
                if (nodeId.equals(this.getPageCache().get(TemplateConstant.HEADNODEID))) {
                    return;
                }
                this.newCycleTable(nodeId, false);
                break;
            }
            case "btn_up": {
                if ("cycletableview".equals(this.getPageCache().get("currentview"))) {
                    this.downAndUpCycleTable(c.getKey().toLowerCase(Locale.ENGLISH));
                    break;
                }
                this.downAndUpMember(c.getKey().toLowerCase(Locale.ENGLISH));
                break;
            }
            case "btn_down": {
                if ("cycletableview".equals(this.getPageCache().get("currentview"))) {
                    this.downAndUpCycleTable(c.getKey().toLowerCase(Locale.ENGLISH));
                    break;
                }
                this.downAndUpMember(c.getKey().toLowerCase(Locale.ENGLISH));
                break;
            }
        }
    }

    private void downAndUpCycleTable(String key) {
        TreeView treeView = (TreeView)this.getView().getControl(TEMPLATECATALOG);
        TreeView.TreeState treeState = treeView.getTreeState();
        List selectNodeIds = treeState.getSelectedNodeId();
        String selectedNodeId = (String)selectNodeIds.get(selectNodeIds.size() - 1);
        if ("btn_up".equals(key)) {
            this.moveCatelogUp(selectedNodeId, "bcm_cycletable");
        } else if ("btn_down".equals(key)) {
            this.moveCatalogDown(selectedNodeId, "bcm_cycletable");
        }
    }

    protected void downAndUpMember(String key) {
        TreeView treeView = (TreeView)this.getView().getControl(TEMPLATECATALOG);
        TreeView.TreeState treeState = treeView.getTreeState();
        List selectNodeIds = treeState.getSelectedNodeId();
        if (CollectionUtils.isEmpty((Collection)selectNodeIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u6a21\u677f\u5206\u7c7b\u3002", (String)"AbstractTemplateTreePlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        String selectedNodeId = (String)selectNodeIds.get(selectNodeIds.size() - 1);
        if ("btn_up".equals(key)) {
            this.checkCatalogSeq(selectedNodeId);
            this.moveCatelogUp(selectedNodeId, this.getTemplateCataLogEntryEntity());
        } else if ("btn_down".equals(key)) {
            this.checkCatalogSeq(selectedNodeId);
            this.moveCatalogDown(selectedNodeId, this.getTemplateCataLogEntryEntity());
        }
    }

    protected void checkCatalogSeq(String selectNodeId) {
        String parentId = this.queryParentId(selectNodeId, this.getTemplateCataLogEntryEntity());
        this.dealChildSeq(parentId);
    }

    protected void moveCatelogUp(String id, String formId) {
        DynamicObject dyTree = BusinessDataServiceHelper.newDynamicObject((String)formId);
        DynamicObject dyTree2 = BusinessDataServiceHelper.newDynamicObject((String)formId);
        dyTree = BusinessDataReader.loadSingle((Object)id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)dyTree.getDynamicObjectType().getName()));
        int seq = this.getDSeq(Long.parseLong(id), formId);
        if (seq == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u76ee\u5f55\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u9876\u5c42\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"AbstractTemplateTreePlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            this.writeOperationLog(OpItemEnum.UP.getName(), dyTree.getString(NUMBER), dyTree.getString(NAME), ResultStatusEnum.FAIL.getName());
            return;
        }
        QFilter qf1 = new QFilter("sequence", "<", (Object)dyTree.getInt("sequence"));
        String parentId = this.queryParentId(id, formId);
        QFilter filter = new QFilter(TemplateConstant.PARENT, "=", (Object)LongUtil.toLong((Object)parentId));
        QFilter[] filters = new QFilter[]{qf1, filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)formId, (String)"id,sequence", (QFilter[])filters, (String)"sequence desc", (int)1);
        if (seq != 0) {
            if (CollectionUtils.isNotEmpty((Collection)dcs)) {
                dyTree2 = BusinessDataReader.loadSingle((Object)((DynamicObject)dcs.get(0)).get("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)dyTree.getDynamicObjectType().getName()));
                int seq2 = dyTree2.getInt("sequence");
                dyTree2.set("sequence", (Object)seq);
                dyTree.set("sequence", (Object)seq2);
                SaveServiceHelper.save((IDataEntityType)dyTree.getDataEntityType(), (Object[])new Object[]{dyTree, dyTree2});
                ((TreeView)this.getControl(TEMPLATECATALOG)).deleteAllNodes();
                this.initTree();
                TreeNode node = new TreeNode(parentId, id, dyTree.getString(NAME));
                ((TreeView)this.getControl(TEMPLATECATALOG)).focusNode(node);
                this.writeOperationLog(OpItemEnum.UP.getName(), dyTree.getString(NUMBER), dyTree.getString(NAME), ResultStatusEnum.SUCCESS.getName());
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u76ee\u5f55\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u9876\u5c42\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"AbstractTemplateTreePlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                this.writeOperationLog(OpItemEnum.UP.getName(), dyTree.getString(NUMBER), dyTree.getString(NAME), ResultStatusEnum.FAIL.getName());
                return;
            }
        }
    }

    protected String queryParentId(String id, String entityId) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)LongUtil.toLong((Object)id))};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)entityId, (String)"parent", (QFilter[])filters, (String)"");
        if (dcs != null && dcs.size() == 1) {
            return ((DynamicObject)dcs.get(0)).getString("parent");
        }
        return "";
    }

    protected void dealChildSeq(String parentId) {
        QFilter parent = new QFilter("parent", "=", (Object)LongUtil.toLong((Object)parentId));
        QFilter[] filters = new QFilter[]{parent};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)this.getTemplateCataLogEntryEntity(), (String)"id,sequence", (QFilter[])filters, (String)"longnumber");
        if (CollectionUtils.isNotEmpty((Collection)dcs)) {
            HashMap<Long, Integer> map = new HashMap<Long, Integer>(16);
            ArrayList<Long> arrayList = new ArrayList<Long>(16);
            for (DynamicObject dy : dcs) {
                Long id = dy.getLong("id");
                arrayList.add(id);
                map.put(id, dy.getInt("sequence"));
            }
            if (map.values().contains(0)) {
                DynamicObject dyCatelog = BusinessDataServiceHelper.newDynamicObject((String)this.getTemplateCataLogEntryEntity());
                Object[] dyDealSeq = (DynamicObject[])BusinessDataReader.load((Object[])arrayList.toArray(), (IDataEntityType)EntityMetadataCache.getDataEntityType((String)dyCatelog.getDynamicObjectType().getName()));
                for (int i = 0; i < dyDealSeq.length; ++i) {
                    dyDealSeq[i].set("sequence", (Object)(i + 1));
                }
                SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)dyCatelog.getDynamicObjectType().getName()), (Object[])dyDealSeq);
            }
        }
    }

    protected int getDSeq(long id, String formId) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)id)};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)formId, (String)"sequence", (QFilter[])filters, (String)"sequence");
        if (dcs != null && dcs.size() == 1) {
            return ((DynamicObject)dcs.get(0)).getInt("sequence");
        }
        return 1;
    }

    protected void moveCatalogDown(String id, String formId) {
        DynamicObject dyTree = BusinessDataServiceHelper.newDynamicObject((String)formId);
        dyTree = BusinessDataReader.loadSingle((Object)id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)dyTree.getDynamicObjectType().getName()));
        int seq = this.getDSeq(Long.parseLong(id), formId);
        QFilter qf1 = new QFilter("sequence", ">", (Object)dyTree.getInt("sequence"));
        String parentId = this.queryParentId(id, formId);
        QFilter filter = new QFilter("parent", "=", (Object)LongUtil.toLong((Object)parentId));
        QFilter[] filters = new QFilter[]{qf1, filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)formId, (String)"id,sequence", (QFilter[])filters, (String)"sequence asc", (int)1);
        if (seq != 0) {
            if (CollectionUtils.isNotEmpty((Collection)dcs)) {
                DynamicObject dyTree2 = BusinessDataReader.loadSingle((Object)((DynamicObject)dcs.get(0)).get("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)dyTree.getDynamicObjectType().getName()));
                int seq2 = dyTree2.getInt("sequence");
                dyTree2.set("sequence", (Object)seq);
                dyTree.set("sequence", (Object)seq2);
                SaveServiceHelper.save((IDataEntityType)dyTree.getDataEntityType(), (Object[])new Object[]{dyTree, dyTree2});
                ((TreeView)this.getControl(TEMPLATECATALOG)).deleteAllNodes();
                this.initTree();
                TreeNode node = new TreeNode(parentId, id, dyTree.getString(NAME));
                ((TreeView)this.getControl(TEMPLATECATALOG)).focusNode(node);
                this.writeOperationLog(OpItemEnum.DOWN.getName(), dyTree.getString(NUMBER), dyTree.getString(NAME), ResultStatusEnum.SUCCESS.getName());
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u76ee\u5f55\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u5e95\u5c42\uff0c\u4e0d\u80fd\u4e0b\u79fb\u3002", (String)"AbstractTemplateTreePlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                this.writeOperationLog(OpItemEnum.DOWN.getName(), dyTree.getString(NUMBER), dyTree.getString(NAME), ResultStatusEnum.FAIL.getName());
                return;
            }
        }
    }

    protected void newCycleTable(String nodeId, boolean isAddNew) {
        BaseShowParameter param = new BaseShowParameter();
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put(MODEL, this.getPageCache().get("KEY_MODEL_ID"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_cycletable");
        long id = Long.parseLong(nodeId);
        params.put(TemplateConstant.PARENT, this.getPageCache().get(TemplateConstant.HEADNODEID));
        if (isAddNew) {
            params.put("type", "add");
            param.setStatus(OperationStatus.ADDNEW);
        } else {
            if (nodeId.equals(this.getPageCache().get(TemplateConstant.HEADNODEID))) {
                // empty if block
            }
            params.put("type", "edit");
            param.setPkId((Object)id);
            param.setStatus(OperationStatus.EDIT);
        }
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId(this.getCycleTableEntity());
        params.put("entity", this.getCycleTableEntity());
        param.setCustomParams(params);
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)param);
    }

    protected void newTemplateCatalog(String nodeId, boolean isAddNew) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put(MODEL, this.getPageCache().get("KEY_MODEL_ID"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_templatecatalog");
        if (isAddNew) {
            long id = Long.parseLong(nodeId);
            params.put(TemplateConstant.PARENT, id);
            params.put("catcalogType", this.getCatalogType());
            params.put("type", "add");
            this.showForm(this.getTemplateCataLogEntryEntity(), params, closeCallBack, ShowType.Modal, 0L);
        } else {
            long id = Long.parseLong(nodeId);
            params.put("catcalogType", this.getCatalogType());
            params.put(TemplateConstant.PARENT, this.getCatalogTreeParentId());
            params.put("type", "edit");
            this.showForm(this.getTemplateCataLogEntryEntity(), params, closeCallBack, ShowType.Modal, id);
        }
    }

    protected void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType, long id) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        params.put("entity", this.getTemplateCataLogEntryEntity());
        if ("3".equals(params.get("catcalogType"))) {
            param.setCaption(ResManager.loadKDString((String)"\u5206\u5f55\u5206\u7c7b", (String)"AbstractTemplateTreePlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        } else if (String.valueOf(TemplateCatalogTypeEnum.CHANGECASELOG.getType()).equals(params.get("catcalogType"))) {
            param.setCaption(TemplateCatalogTypeEnum.CHANGECASELOG.getName());
        }
        if (id != 0L) {
            param.setPkId((Object)id);
            param.setStatus(OperationStatus.EDIT);
        }
        if (params.size() > 0) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    protected DynamicObject[] getSelectedTempDynaObjs(String noSelectedMsg) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        if (CollectionUtils.isEmpty((Collection)billList.getSelectedRows())) {
            if (StringUtils.isNotEmpty((String)noSelectedMsg)) {
                this.getView().showTipNotification(noSelectedMsg);
            }
            return null;
        }
        return BusinessDataServiceHelper.load((Object[])billList.getSelectedRows().getPrimaryKeyValues(), (DynamicObjectType)billList.getEntityType());
    }

    protected DynamicObject[] getSelectedTempDynaObjs() {
        return this.getSelectedTempDynaObjs(null);
    }

    public void refrushTree() {
        TreeView treeView = (TreeView)this.getControl(TEMPLATECATALOG);
        treeView.deleteAllNodes();
        this.initTree();
    }

    private String getCatalogTreeParentId() {
        return StringUtils.isNotEmpty((String)this.getPageCache().get(TemplateConstant.PARENT)) ? this.getPageCache().get(TemplateConstant.PARENT) : "0";
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        String callBackId = mbce.getCallBackId();
        if (callBackId.equals("deletecatalog_comfirm")) {
            if (MessageBoxResult.Yes == mbce.getResult()) {
                PlatUtil.executeWithTX(tx -> {
                    TreeView tree = (TreeView)this.getControl(TEMPLATECATALOG);
                    Map map = tree.getTreeState().getFocusNode();
                    String nodeId = (String)map.get("id");
                    String parentId = (String)map.get(TemplateConstant.PARENTID);
                    List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(TemplateConstant.TREELIST), List.class);
                    ArrayList<String> list = new ArrayList<String>(16);
                    this.queryAllChildNodeList(nodeId, treeList, list);
                    list.add(nodeId);
                    DynamicObject[] oo = (DynamicObject[])this.queryTemplateByCatalogIds(LongUtil.toLongList(list));
                    ArrayList<Long> idList = new ArrayList<Long>(oo.length);
                    for (DynamicObject dd : oo) {
                        dd.set(TEMPLATECATALOG, (Object)parentId);
                        idList.add(dd.getLong("id"));
                    }
                    SaveServiceHelper.save((DynamicObject[])oo);
                    TemplateServiceHelper.removeTemplateModelCacheByIds((Object)modelId, (Object[])idList.toArray());
                    List ids = list.stream().map(a -> Long.parseLong(a)).collect(Collectors.toList());
                    QFilter qfilter = new QFilter("id", "in", ids);
                    DynamicObject[] delTemplates = BusinessDataServiceHelper.load((String)this.getTemplateCataLogEntryEntity(), (String)"id,number,name", (QFilter[])new QFilter[]{qfilter});
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)this.getTemplateCataLogEntryEntity()), (Object[])list.toArray());
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AbstractTemplateTreePlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    String formId = this.getView().getFormShowParameter().getFormId();
                    if ("bcm_invelimlist".equals(formId) || "bcm_templatelist".equals(formId)) {
                        this.writeDelLog(delTemplates, this.getOperationDeleteTemplate());
                    } else if ("bcm_anaysishelper_list".equals(formId)) {
                        this.writeDelLog(delTemplates, this.getOperationDeleteAnalysisHelper());
                    } else {
                        this.writeDelLog(delTemplates, this.getOperationDelete());
                    }
                });
                this.refrushTree();
                this.refrushBillList();
            }
        } else if (callBackId.equals("deletecycletable_comfirm") && MessageBoxResult.Yes == mbce.getResult()) {
            this.deleteCycleTable();
            this.refrushTree();
            this.refrushBillList();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AbstractTemplateTreePlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private void deleteCycleTable() {
        TreeView tree = (TreeView)this.getControl(TEMPLATECATALOG);
        Map map = tree.getTreeState().getFocusNode();
        String nodeId = (String)map.get("id");
        QFilter qFilter = new QFilter("id", "=", (Object)LongUtil.toLong((Object)nodeId));
        QFilter ctQF = new QFilter("cycletable", "=", (Object)LongUtil.toLong((Object)nodeId));
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,cycletable", (QFilter[])ctQF.toArray());
        if (!dynamicObjectCollection.isEmpty()) {
            ArrayList dyos = new ArrayList(16);
            dynamicObjectCollection.forEach(dyo -> {
                dyo.set("cycletable", (Object)0);
                dyos.add(dyo);
            });
            SaveServiceHelper.update((DynamicObject[])dyos.toArray(new DynamicObject[0]));
        }
        try {
            DeleteServiceHelper.delete((String)"bcm_cycletable", (QFilter[])new QFilter[]{qFilter});
            DeleteServiceHelper.delete((String)"bcm_tempdiscycletable", (QFilter[])new QFilter[]{ctQF});
            DeleteServiceHelper.delete((String)"bcm_cycletabledisentity", (QFilter[])new QFilter[]{ctQF});
        }
        catch (Exception e) {
            return;
        }
    }

    public void writeDelLog(DynamicObject[] delTemplates, String opName) {
        for (DynamicObject dy : delTemplates) {
            String number = dy.getString(NUMBER);
            String name = dy.getString(NAME);
            String log = String.format("%s %s,%s%s", number, name, this.getOperationDelete(), this.getOperationStatusSuccess());
            ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
            AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)opName, (String)log, (Long)this.getModelId(), (String)this.getTemplateCataLogEntryEntity());
            logService.addLog(logInfo);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "bcm_templatecatalog": {
                ArrayList ids;
                ArrayList arrayList = ids = closedCallBackEvent.getReturnData() == null ? null : (ArrayList)closedCallBackEvent.getReturnData();
                if (ids == null || ids.isEmpty()) break;
                String nodeid = ((Long)ids.get(0)).toString();
                boolean isUpdate = this.isUpdate(nodeid);
                this.refrushTree();
                List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(TemplateConstant.TREELIST), List.class);
                for (Map m : treeList) {
                    if (!nodeid.equals(m.get("id"))) continue;
                    TreeNode node = new TreeNode((String)m.get(TemplateConstant.PARENTID), (String)m.get("id"), (String)m.get(NAME));
                    ((TreeView)this.getControl(TEMPLATECATALOG)).focusNode(node);
                    this.getPageCache().put(FOCUS_NODE_ID, nodeid);
                    this.getPageCache().put(TemplateConstant.PARENT, (String)m.get(TemplateConstant.PARENTID));
                }
                this.refrushBillList();
                QFilter filter1 = new QFilter(TEMPLATECATALOG, "in", (Object)ids);
                DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getEntryEntity(), (String)"id", (QFilter[])new QFilter[]{filter1});
                if (dcs != null && !dcs.isEmpty()) {
                    for (DynamicObject dd : dcs) {
                        ids.add(dd.getLong("id"));
                    }
                    TemplateServiceHelper.removeTemplateModelCacheByIds((Object)this.getModelId(), (Object[])ids.toArray());
                }
                if (isUpdate) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f\u3002", (String)"AbstractTemplateTreePlugin_13", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65b0\u589e\u6210\u529f\u3002", (String)"AbstractTemplateTreePlugin_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
            case "bcm_cycletable": {
                ArrayList ids1;
                ArrayList arrayList = ids1 = closedCallBackEvent.getReturnData() == null ? null : (ArrayList)closedCallBackEvent.getReturnData();
                if (ids1 == null || ids1.isEmpty()) break;
                this.refrushTree();
                String nodeid = ((Long)ids1.get(0)).toString();
                List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(TemplateConstant.TREELIST), List.class);
                for (Map m : treeList) {
                    if (!nodeid.equals(m.get("id"))) continue;
                    TreeNode node = new TreeNode((String)m.get(TemplateConstant.PARENTID), (String)m.get("id"), (String)m.get(NAME));
                    ((TreeView)this.getControl(TEMPLATECATALOG)).focusNode(node);
                    this.getPageCache().put(FOCUS_NODE_ID, nodeid);
                    this.getPageCache().put(TemplateConstant.PARENT, (String)m.get(TemplateConstant.PARENTID));
                }
                this.refrushBillList();
            }
        }
    }

    private boolean isUpdate(String nodeid) {
        List treeList1 = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(TemplateConstant.TREELIST), List.class);
        for (Map stringStringMap : treeList1) {
            if (!((String)stringStringMap.get("id")).equals(nodeid)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected Object[] queryTemplateByCatalogIds(List<Long> pks) {
        QFilter filter1 = new QFilter(TEMPLATECATALOG, "in", pks);
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getEntryEntity(), (String)"id", (QFilter[])new QFilter[]{filter1});
        ArrayList<Long> ids = new ArrayList<Long>(dcs.size());
        for (DynamicObject dd : dcs) {
            ids.add(dd.getLong("id"));
        }
        return BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getEntryEntity()));
    }

    protected String getEntryEntity() {
        return "bcm_templateentity";
    }

    protected String getCatalogType() {
        return TemplateCatalogTypeEnum.TEMPLATECATALOG.getType() + "";
    }

    protected String getTemplateCataLogEntryEntity() {
        return "bcm_templatecatalog";
    }

    protected String getCycleTableEntity() {
        return "bcm_cycletable";
    }
}

