/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.serviceHelper.MyTaskStatusHelper;
import kd.fi.bcm.business.template.TemplatePermCrossUtil;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.datatypeutil.DataTypeConvertUtil;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.template.SearchResult;
import kd.fi.bcm.formplugin.util.FormUtils;
import org.apache.commons.collections.CollectionUtils;

public class CycleTableDisEntityPlugin
extends AbstractBaseFormPlugin {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String MODEL = "model";
    private static final String ENTITY = "entity";
    private static final String ROOT_NODE = "rootNode";
    private static final String CYCLETABLE = "cycletable";
    private static final String CACHE_SEARCH = "cache_search";
    private static final String RANGE = "range";
    private static final String COPY_FROM = "copyfrom";
    private static final String RANGE_VALUE = "rangevalue";
    private static final String BILL_LIST_AP = "billlistap";
    public static final String selectOrg_entityID = "dentity";
    public static final String cycleTable_treeID = "cycletabletree";
    private static final String VIEW_COMBO = "viewcombo";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private final TreeNodeCheckListener treeNodeCheckListener = new TreeNodeCheckListener(){

        public void treeNodeCheck(TreeNodeCheckEvent evt) {
            CycleTableDisEntityPlugin.this.refreshBillList();
        }
    };
    private final SetFilterListener setFilterListener = new SetFilterListener(){

        public void setFilter(SetFilterEvent evt) {
            Control source = (Control)evt.getSource();
            String viewid = (String)source.getModel().getValue(CycleTableDisEntityPlugin.VIEW_COMBO);
            BillList billList = (BillList)source.getView().getControl(CycleTableDisEntityPlugin.BILL_LIST_AP);
            List filters = evt.getQFilters();
            if (viewid.equals("20")) {
                FormUtils.setBillFormId4FormBill(billList, "bcm_cycletabledisentity");
            }
            QFilter filter1 = CycleTableDisEntityPlugin.this.getTemQueryFilter();
            QFilter filter2 = CycleTableDisEntityPlugin.this.getOrgQueryFilter("oid");
            if (filter1 == null && filter2 == null) {
                filters.add(new QFilter("1", "!=", (Object)1));
            } else if (filter1 == null) {
                filters.add(new QFilter("1", "!=", (Object)1));
            } else if (filter2 == null) {
                filters.add(filter1);
            } else {
                filters.add(filter1.and(filter2));
            }
        }
    };

    private static OpNameMultiLangEnumBridge getOperationSend() {
        return new OpNameMultiLangEnumBridge("\u5206\u914d", "DistributionPlugin_0", FI_BCM_FORMPLUGIN, "Allocate");
    }

    private static OpNameMultiLangEnumBridge getOperationBackSend() {
        return new OpNameMultiLangEnumBridge("\u53cd\u5206\u914d", "DistributionPlugin_20", FI_BCM_FORMPLUGIN, "Anti allocate");
    }

    private static final String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"DistributionPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private static final String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"DistributionPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addListeners();
    }

    private void addListeners() {
        this.addClickListeners("selectorg", "deleteorg", "deletedistribution", "details", "imageup", "imagedown");
        this.addItemClickListeners("toolbarap");
        TreeView tree = (TreeView)this.getControl(cycleTable_treeID);
        tree.addTreeNodeCheckListener(this.treeNodeCheckListener);
        EntryGrid orgeg = (EntryGrid)this.getControl(selectOrg_entityID);
        orgeg.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                super.entryRowClick(evt);
                CycleTableDisEntityPlugin.this.refreshBillList();
            }
        });
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.addSetFilterListener(this.setFilterListener);
        Search se = (Search)this.getControl("searchap");
        se.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent var1) {
                String text = var1.getText();
                if (text != null && !"".equals(text)) {
                    CycleTableDisEntityPlugin.this.searchTemplate(text.trim());
                } else {
                    CycleTableDisEntityPlugin.this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                }
            }
        });
    }

    private void searchTemplate(String search) {
        TreeView tree = (TreeView)this.getControl(cycleTable_treeID);
        String rootNodeCache = this.getPageCache().get(ROOT_NODE);
        if (rootNodeCache != null) {
            TreeNode root = (TreeNode)ObjectSerialUtil.deSerializedBytes((String)rootNodeCache);
            ArrayList<TreeNode> hitNode = new ArrayList<TreeNode>(16);
            root.getTreeNodeListByText(hitNode, search, 999);
            SearchResult result = null;
            if (!hitNode.isEmpty()) {
                result = new SearchResult(hitNode);
                TreeNode next = result.next(1);
                tree.checkNode(next);
                this.refreshBillList();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5173\u8282\u70b9\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u540d\u79f0\u540e\u641c\u7d22\u3002", (String)"DistributionPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            this.getPageCache().put(CACHE_SEARCH, result == null ? null : ObjectSerialUtil.toByteSerialized((Object)result));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_distribute": {
                this.distributeMember();
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "selectorg": {
                this.showSelectOrgView();
                break;
            }
            case "deleteorg": {
                this.deleteOrgMember();
                break;
            }
            case "deletedistribution": {
                this.deleteDistribution();
                break;
            }
            case "details": {
                this.showDetailsView();
                break;
            }
            case "imageup": {
                this.searchNext(-1);
                break;
            }
            case "imagedown": {
                this.searchNext(1);
            }
        }
    }

    private void searchNext(int i) {
        IPageCache pageCache = this.getPageCache();
        String searchResultCache = pageCache.get(CACHE_SEARCH);
        if (searchResultCache != null) {
            SearchResult result = (SearchResult)ObjectSerialUtil.deSerializedBytes((String)searchResultCache);
            TreeNode next = result.next(i);
            TreeView tree = (TreeView)this.getControl(cycleTable_treeID);
            if (next == null) {
                if (i > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"DistributionPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"DistributionPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                }
            } else {
                tree.checkNode(next);
                tree.treeNodeClick(next.getParentid(), next.getId());
                pageCache.put(CACHE_SEARCH, ObjectSerialUtil.toByteSerialized((Object)result));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"DistributionPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private void showDetailsView() {
        BillList billlist = (BillList)this.getControl(BILL_LIST_AP);
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_disentity_details");
        param.setCaption(ResManager.loadKDString((String)"\u5957\u8868\u5206\u914d\u8be6\u60c5", (String)"DistributionPlugin_25", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        Object[] ids = billlist.getSelectedRows().getPrimaryKeyValues().length < 1 ? billlist.getCurrentListAllRowCollection().getPrimaryKeyValues() : billlist.getSelectedRows().getPrimaryKeyValues();
        param.setCustomParam("ids", (Object)SerializationUtils.toJsonString((Object)ids));
        param.setCustomParam("modelid", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        param.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(param);
    }

    private void deleteDistribution() {
        BillList billlist = (BillList)this.getControl(BILL_LIST_AP);
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)list)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u53cd\u5206\u914d\u8bb0\u5f55\u7684\u6570\u636e\u884c\u3002", (String)"DistributionPlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u53cd\u5206\u914d\u3002", (String)"DistributionPlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_comfirm", (IFormPlugin)this));
    }

    private void distributeMember() {
        List<Long> cycleTableList = this.getSelectedCycleTables();
        this.checkRoot(cycleTableList);
        List<DynamicObject> orgList = this.getOrgSelectedAndResultList();
        if (cycleTableList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u5957\u8868\u3002", (String)"DistributionPlugin_26", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (orgList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u7ec4\u7ec7\u3002", (String)"DistributionPlugin_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        QFilter qcf = new QFilter(ID, "in", cycleTableList);
        DynamicObjectCollection data = QueryServiceHelper.query((String)"bcm_cycletable", (String)"number, name", (QFilter[])new QFilter[]{qcf});
        try {
            for (int i = 0; i < data.size(); ++i) {
                this.writeOperationLog(CycleTableDisEntityPlugin.getOperationSend(), ((DynamicObject)data.get(i)).getString(NUMBER), ((DynamicObject)data.get(i)).getString(NAME), CycleTableDisEntityPlugin.getOperationStstusSuccess());
            }
            List<DynamicObject> disList = this.mergeResult(orgList, cycleTableList);
            this.saveDistributeRecord(disList, cycleTableList);
        }
        catch (Exception e) {
            for (int i = 0; i < data.size(); ++i) {
                this.writeOperationLog(CycleTableDisEntityPlugin.getOperationSend(), ((DynamicObject)data.get(i)).getString(NUMBER), ((DynamicObject)data.get(i)).getString(NAME), CycleTableDisEntityPlugin.getOperationStstusFail());
            }
            throw e;
        }
    }

    private void checkRoot(List<Long> cycleTableList) {
        QFilter qFilter = new QFilter(ID, "in", cycleTableList);
        DynamicObjectCollection data = QueryServiceHelper.query((String)"bcm_cycletable", (String)"id, number", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject ct : data) {
            if (!"root".equals(ct.get(NUMBER))) continue;
            cycleTableList.remove(ct.getLong(ID));
        }
    }

    private List<Long> getSelectedCycleTables() {
        TreeView tree = (TreeView)this.getControl(cycleTable_treeID);
        List tids = tree.getTreeState().getSelectedNodeId();
        return DataTypeConvertUtil.convert((List)tids);
    }

    private List<DynamicObject> getOrgSelectedAndResultList() {
        EntryGrid eg = (EntryGrid)this.getControl(selectOrg_entityID);
        int[] rows = eg.getEntryState().getSelectedRows();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
        for (int row : rows) {
            DynamicObject dd = this.getModel().getEntryRowEntity(selectOrg_entityID, row);
            if (dd == null) continue;
            list.add(dd);
        }
        return list;
    }

    private void saveDistributeRecord(List<DynamicObject> disList, List<Long> cycleTablelist) {
        long modelid = this.getModelId();
        QFilter filter = new QFilter(MODEL, "=", (Object)modelid);
        QFilter ctFilter = new QFilter(CYCLETABLE, "in", cycleTablelist);
        QFilter[] filters = new QFilter[]{filter, ctFilter};
        String selectFields = "id, entity, cycletable, range";
        DynamicObjectCollection oldDisData = QueryServiceHelper.query((String)"bcm_cycletabledisentity", (String)selectFields, (QFilter[])filters);
        block12: for (DynamicObject dis : oldDisData) {
            int index = 0;
            for (DynamicObject newDis : disList) {
                if (dis.getLong(CYCLETABLE) == newDis.getLong(CYCLETABLE) && dis.getLong(ENTITY) == newDis.getLong(ENTITY) && dis.getString(RANGE).equals(newDis.getString(RANGE))) {
                    disList.remove(index);
                    continue block12;
                }
                ++index;
            }
        }
        if (disList.isEmpty()) {
            return;
        }
        try (TXHandle tx = TX.required((String)"bcm_actionsave");){
            try {
                DynamicObject[] newDis = disList.toArray(new DynamicObject[disList.size()]);
                Object[] oo = SaveServiceHelper.save((DynamicObject[])newDis);
                Long[] templateids = new Long[newDis.length];
                int i = 0;
                for (DynamicObject dd : newDis) {
                    Long tempid;
                    templateids[i] = tempid = Long.valueOf(dd.getLong(CYCLETABLE));
                    ++i;
                }
                MyTaskStatusHelper.refreshTaskStatusRecord4TempleteID((Long[])templateids);
                if (oo.length > 0) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"DistributionPlugin_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                }
                AppCacheServiceHelper.removeTemplateDispenseCache((String)MemberReader.findModelNumberById((Object)modelid));
            }
            catch (KDBizException e) {
                tx.markRollback();
                throw e;
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
        this.refreshBillList();
    }

    private void refreshBillList() {
        BillList billlist = (BillList)this.getControl(BILL_LIST_AP);
        billlist.addSetFilterListener(this.setFilterListener);
        billlist.refresh();
        billlist.clearSelection();
    }

    private QFilter getTemQueryFilter() {
        List<Long> rows = this.getSelectedCycleTables();
        QFilter filter = null;
        if (!rows.isEmpty()) {
            filter = new QFilter(CYCLETABLE, "in", (Object)rows.toArray());
        }
        return filter;
    }

    private QFilter getOrgQueryFilter(String idname) {
        List<DynamicObject> orglist = this.getOrgSelectedAndResultList();
        LinkedList<Long> mrows = new LinkedList<Long>();
        Object[] orgids = new Long[orglist.size()];
        for (int i = 0; i < orglist.size(); ++i) {
            orgids[i] = orglist.get(i).getLong("oid");
        }
        Map orgs = BusinessDataServiceHelper.loadFromCache((Object[])orgids, (String)"bcm_entitymembertree");
        for (DynamicObject org : orglist) {
            DynamicObject nowOrg = (DynamicObject)orgs.get(org.getLong(idname));
            if (nowOrg.get(COPY_FROM) != null) {
                mrows.add(nowOrg.getDynamicObject(COPY_FROM).getLong(ID));
                continue;
            }
            mrows.add(Long.valueOf(org.getString(idname)));
        }
        QFilter filter = null;
        if (!mrows.isEmpty()) {
            filter = new QFilter(ENTITY, "in", (Object)mrows.toArray());
        }
        return filter;
    }

    private List<DynamicObject> mergeResult(List<DynamicObject> orgList, List<Long> cycleTableList) {
        Object[] orgids = new Long[orgList.size()];
        for (int i = 0; i < orgList.size(); ++i) {
            orgids[i] = orgList.get(i).getLong("oid");
        }
        Map orgs = BusinessDataServiceHelper.loadFromCache((Object[])orgids, (String)"bcm_entitymembertree");
        ArrayList<DynamicObject> disList = new ArrayList<DynamicObject>(16);
        for (Long ct : cycleTableList) {
            for (DynamicObject org : orgList) {
                DynamicObject distribute = BusinessDataServiceHelper.newDynamicObject((String)"bcm_cycletabledisentity");
                if (StringUtils.isEmpty((CharSequence)org.getString("pid").trim())) {
                    DynamicObject nowOrg = (DynamicObject)orgs.get(org.getLong("oid"));
                    if (nowOrg.get(COPY_FROM) != null) {
                        distribute.set(ENTITY, nowOrg.getDynamicObject(COPY_FROM).get(ID));
                    } else {
                        distribute.set(ENTITY, org.get("oid"));
                    }
                }
                distribute.set(RANGE, org.get(RANGE_VALUE));
                distribute.set(CYCLETABLE, (Object)ct);
                distribute.set(MODEL, (Object)this.getModelId());
                disList.add(distribute);
            }
        }
        return disList;
    }

    private void showSelectOrgView() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_mulmemberf7base_dis");
        formShowParameter.setCustomParam("dimension", (Object)"1");
        formShowParameter.setCustomParam("isFilterRateScheme", (Object)Boolean.TRUE);
        formShowParameter.setCustomParam("isHiddenLocalradio", (Object)Boolean.TRUE.toString());
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9 - \u7ec4\u7ec7", (String)"DistributionPlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectmember");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long modelid = this.getModelId();
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelid));
        TreeView treeView = (TreeView)this.getControl(cycleTable_treeID);
        treeView.deleteAllNodes();
        this.initCycleTableTree();
        FilterParameter fp = new FilterParameter();
        QFilter filter = new QFilter(MODEL, "=", (Object)modelid);
        fp.setFilter(filter);
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        billList.setFilterParameter(fp);
        billList.addSetFilterListener(this.setFilterListener);
    }

    private void initCycleTableTree() {
        TreeView tree = (TreeView)this.getControl(cycleTable_treeID);
        TreeNode rootView = this.getCycleTableTree();
        this.getPageCache().put(ROOT_NODE, ObjectSerialUtil.toByteSerialized((Object)rootView));
        BCMTreeUtils.spreadAllNode((TreeNode)rootView);
        tree.addNode(rootView);
    }

    public TreeNode getCycleTableTree() {
        TreeNode cycleTableTree = new TreeNode();
        TemplatePermCrossUtil.buildOldTemplateTree((IPageCache)this.getPageCache(), (long)this.getModelId(), (TreeNode)cycleTableTree, (String)this.getClass().getName(), (String)"bcm_cycletable", (String)"id,name,number,parent", (QFilter)new QFilter("1", "=", (Object)1), Collections.emptyMap());
        cycleTableTree.setText(this.getRootName());
        return cycleTableTree;
    }

    private String getRootName() {
        return ResManager.loadKDString((String)"\u5957\u8868", (String)"TemplateListPlugin_66", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "viewcombo": {
                this.refreshBillList();
            }
        }
    }

    private void selectOrgMember(DynamicObjectCollection olddoc, DynamicObjectCollection newdoc) {
        IDataModel model = this.getModel();
        boolean isexist = false;
        HashSet<Integer> list = new HashSet<Integer>(16);
        EntryGrid eg = (EntryGrid)this.getControl(selectOrg_entityID);
        int[] rows = eg.getSelectRows();
        for (DynamicObject newone : newdoc) {
            isexist = false;
            for (DynamicObject oldone : olddoc) {
                if (!newone.get(4).equals(oldone.get("oid")) || !newone.get(5).equals(oldone.get(RANGE_VALUE))) continue;
                isexist = true;
                break;
            }
            if (isexist) continue;
            int index = model.createNewEntryRow(selectOrg_entityID);
            model.setValue(ENTITY, newone.get(3), index);
            model.setValue(RANGE_VALUE, newone.get(5), index);
            model.setValue("oid", newone.get(4), index);
            model.setValue("pid", newone.get(6), index);
            list.add(index);
        }
        for (Object t : (Object)rows) {
            list.add((int)t);
        }
        if (list.isEmpty()) {
            return;
        }
        rows = new int[list.size()];
        int index = 0;
        for (Integer row : list) {
            rows[index++] = row;
        }
        eg.selectRows(rows, rows[0]);
    }

    private void deleteOrgMember() {
        EntryGrid eg = (EntryGrid)this.getControl(selectOrg_entityID);
        int[] row = eg.getEntryState().getSelectedRows();
        if (row.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"DistributionPlugin_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryRows(selectOrg_entityID, row);
        this.refreshBillList();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        DynamicObjectCollection olddoc = this.getModel().getEntryEntity(selectOrg_entityID);
        switch (actionId) {
            case "selectmember": {
                if (e.getReturnData() == null) break;
                DynamicObjectCollection newdoc = (DynamicObjectCollection)e.getReturnData();
                this.selectOrgMember(olddoc, newdoc);
                this.refreshBillList();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "delete_comfirm": {
                this.deleteDisCT(event);
            }
        }
    }

    private void deleteDisCT(MessageBoxClosedEvent event) {
        if (MessageBoxResult.Yes == event.getResult()) {
            BillList billlist = (BillList)this.getControl(BILL_LIST_AP);
            ListSelectedRowCollection listrows = billlist.getSelectedRows();
            String selectFields = "id, entity, cycletable, range, cycletable.number, cycletable.name";
            Object[] rows = listrows.getPrimaryKeyValues();
            QFilter filter = new QFilter(ID, "in", (Object)rows);
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_cycletabledisentity", (String)selectFields, (QFilter[])new QFilter[]{filter});
            ArrayList<Long> idList = new ArrayList<Long>(16);
            HashMap<String, String> numberNameMap = new HashMap<String, String>(doc.size());
            for (DynamicObject d : doc) {
                idList.add(d.getLong(ID));
                String cycletableName = d.getString("cycletable.name");
                String cycletableNumber = d.getString("cycletable.number");
                numberNameMap.put(cycletableName, cycletableNumber);
            }
            if (!idList.isEmpty()) {
                try (TXHandle tx = TX.required((String)"bcm_deleteDisCT");){
                    try {
                        DeleteServiceHelper.delete((String)"bcm_cycletabledisentity", (QFilter[])new QFilter[]{new QFilter(ID, "in", idList)});
                        this.backSendOpLog(numberNameMap, CycleTableDisEntityPlugin.getOperationStstusSuccess());
                    }
                    catch (KDBizException e1) {
                        this.backSendOpLog(numberNameMap, CycleTableDisEntityPlugin.getOperationStstusFail());
                        tx.markRollback();
                        throw e1;
                    }
                    catch (Throwable e1) {
                        this.backSendOpLog(numberNameMap, CycleTableDisEntityPlugin.getOperationStstusFail());
                        tx.markRollback();
                        throw e1;
                    }
                }
            }
            AppCacheServiceHelper.removeTemplateDispenseCache((String)MemberReader.findModelNumberById((Object)this.getPageCache().get("KEY_MODEL_ID")));
            this.refreshBillList();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5206\u914d\u5b8c\u6210\u3002", (String)"DistributionPlugin_19", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private void backSendOpLog(HashMap<String, String> numberNameMap, String status) {
        for (Map.Entry<String, String> numberName : numberNameMap.entrySet()) {
            this.writeOperationLog(CycleTableDisEntityPlugin.getOperationBackSend(), numberName.getKey(), numberName.getValue(), status);
        }
    }
}

