/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.Save;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.CycleTablesServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.IOperationLog;
import org.apache.commons.collections.CollectionUtils;

public class CycleTableEditPlugin
extends AbstractBaseFormPlugin
implements IOperationLog {
    private static final String MODEL = "model";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String PARENT = "parent";
    private static final String SEQUENCE = "sequence";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl("permclass")), (Object)this.getModelId());
        BasedataEdit multitemplate = (BasedataEdit)this.getControl("scenario");
        multitemplate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        beforeF7SelectEvent.addCustomQFilter(new QFilter(MODEL, "=", (Object)this.getModelId()).and(new QFilter("isleaf", "=", (Object)true)));
    }

    private void setBtnEnable() {
        long modelId = this.getModelId();
        Long id = (Long)this.getModel().getValue("id");
        if (id != 0L) {
            boolean exitTmplDisCycleTables = CycleTablesServiceHelper.isExitTmplDisCycleTables((Long)modelId, (Long)id);
            this.getView().setEnable(Boolean.valueOf(!exitTmplDisCycleTables), new String[]{"scenario"});
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.dealIsRPT();
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Object parent = map.get(PARENT);
        Object scene = map.get("scenario");
        this.getModel().setValue(MODEL, (Object)this.getModelId());
        if (!ObjectUtils.isEmpty(scene)) {
            this.getModel().setValue("scenario", scene);
        }
        this.getModel().setValue(PARENT, parent);
        if ("add".equals(map.get("type"))) {
            int seq = this.getCurNodeSequence(map.get(PARENT).toString());
            this.getModel().setValue(SEQUENCE, (Object)seq);
        }
        this.getModel().setDataChanged(false);
        this.setBtnEnable();
    }

    private void dealIsRPT() {
        if (this.isRPT()) {
            ComboEdit belongtask = (ComboEdit)this.getControl("belongtask");
            belongtask.hideTips();
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u65e0", (String)"CycleTableEditPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "0"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u62a5\u8868\u4efb\u52a1", (String)"CycleTableEditPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "1"));
            belongtask.setComboItems(items);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Object parent = map.get(PARENT);
        Object scene = map.get("scenario");
        this.getModel().setValue(MODEL, (Object)this.getModelId());
        if (!ObjectUtils.isEmpty(scene)) {
            this.getModel().setValue("scenario", scene);
        }
        this.getModel().setValue(PARENT, parent);
        int seq = this.getCurNodeSequence(map.get(PARENT).toString());
        this.getModel().setValue(SEQUENCE, (Object)seq);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            boolean exists;
            String number = this.getModel().getValue(NUMBER).toString();
            QFilter mqFilter = new QFilter(MODEL, "=", (Object)LongUtil.toLong((Object)this.getModelId()));
            QFilter nqFilter = new QFilter(NUMBER, "=", (Object)number);
            Long id = (Long)this.getModel().getValue("id");
            if (id != 0L) {
                nqFilter.and("id", "!=", (Object)id);
            }
            if (exists = QueryServiceHelper.exists((String)"bcm_cycletable", (QFilter[])new QFilter[]{mqFilter, nqFilter})) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"CycleTableEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean issuccess = e.getOperationResult().getValidateResult().isSuccess();
        List ids = e.getOperationResult().getSuccessPkIds();
        Object number = this.getModel().getValue(NUMBER);
        Object name = this.getModel().getValue(NUMBER);
        if (e.getSource() instanceof Save && issuccess) {
            PermClassEntityHelper.savePermClass((DynamicObject)this.getModel().getDataEntity(), (Long)ConvertUtil.convertObjToLong((Object)this.getModelId()));
            this.getView().returnDataToParent((Object)ids);
            this.getView().close();
            OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u65b0\u589e\u5957\u8868\u5206\u7c7b", (String)"CycleTableEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"%1$s %2$s,\u65b0\u589e\u6210\u529f", (String)"CycleTableEditPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), number.toString(), name.toString()), (Long)ConvertUtil.convertObjToLong((Object)this.getModelId()));
        }
    }

    private int getCurNodeSequence(String parentId) {
        QFilter model = new QFilter(MODEL, "=", (Object)this.getModelId());
        QFilter parent = new QFilter(PARENT, "=", (Object)Long.valueOf(parentId));
        QFilter[] filters = new QFilter[]{model, parent};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)this.getBizEntityNumber(), (String)SEQUENCE, (QFilter[])filters, (String)"sequence desc");
        if (CollectionUtils.isNotEmpty((Collection)dcs)) {
            DynamicObject dyMaxSeq = (DynamicObject)dcs.iterator().next();
            String strSeq = dyMaxSeq.getString(SEQUENCE);
            return (strSeq.isEmpty() ? 0 : Integer.parseInt(strSeq)) + 1;
        }
        return 1;
    }

    @Override
    public String getBizEntityNumber() {
        return "bcm_cycletable";
    }

    @Override
    public void writeLog(String opName, String opDescriotion) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)opName, (String)opDescriotion, (Long)this.getModelId(), (String)this.getBizEntityNumber());
        logInfo.setBizObjID("bcm_cycletable");
        logService.addLog(logInfo);
    }

    @Override
    public long getModelId() {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        return LongUtil.toLong(map.get(MODEL));
    }
}

