/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.log.api.AppLogInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.serviceHelper.MyTaskStatusHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.enums.template.DisEffectWayEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.impexport.BillResult;

public class DistributionImport
extends BatchImportPlugin {
    public static final int BATCH_SINGLE = 100;
    public static final int BATCH_THRESHOLD = 200;
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(DistributionImport.class);
    private static final String DATATYPE = "dataType";
    private static final String ISCUSTOM = "isCustom";
    private boolean success = false;
    private Long modelId;
    private String modelNumber;
    private Map<String, Set<Long>> allVersiontemplates = new HashMap<String, Set<Long>>(16);
    private Map<String, DynamicObject> dpMap = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> dpValueMap = new HashMap<String, DynamicObject>(16);
    private Map<Tuple<Boolean, Pair<String, Integer>, String>, List<DynamicObject>> disMap = new HashMap<Tuple<Boolean, Pair<String, Integer>, String>, List<DynamicObject>>(16);

    private OPDescMultiLangEnumBridge getResultBridge() {
        if (this.success) {
            return OPDescMultiLangEnumBridge.genOpDescBridge((MultiLangEnumBridge)ResultStatusEnum.SUCCESS.getBridge(), null);
        }
        return OPDescMultiLangEnumBridge.genOpDescBridge((MultiLangEnumBridge)ResultStatusEnum.FAIL.getBridge(), null);
    }

    private void clear() {
        this.disMap.clear();
        this.allVersiontemplates.clear();
        this.dpMap.clear();
        this.dpValueMap.clear();
    }

    private String getOperationImport() {
        return ResManager.loadKDString((String)"\u5bfc\u5165", (String)"DistributionImport_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        ArrayList<ComboItem> onlyNumberShow = new ArrayList<ComboItem>(10);
        for (ComboItem item : super.getOverrideFieldsConfig()) {
            if (!"id".equals(item.getValue())) continue;
            onlyNumberShow.add(item);
        }
        return onlyNumberShow;
    }

    public String getDefaultKeyFields() {
        return "id";
    }

    protected void importData() throws Throwable {
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        if (ImportOperateType.OVERRIDE != importType && ImportOperateType.OVERRIDENEW != importType) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u7c7b\u578b\u6709\u8bef\u3002", (String)"DistributionImport_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        try {
            super.importData();
        }
        catch (Throwable e) {
            log.error("DistributionImport error :", e);
        }
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo();
        logInfo.setBizAppID(AppMetadataCache.getAppInfo((String)this.ctx.getAppId()).getId());
        OperationLogUtil.buildLogInfo((AppLogInfo)logInfo, (Long)LongUtil.toLong(this.ctx.getOption().get("BcmModelId")), (String)"bcm_distributionentity", (OpNameMultiLangEnumBridge)new OpNameMultiLangEnumBridge("\u5bfc\u5165", "DistributionImport_0", "fi-bcm-formplugin", "import"), (OPDescMultiLangEnumBridge)this.getResultBridge());
        OperationLogUtil.writeOperationLog((AppLogInfo)logInfo);
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        this.prepareData();
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        ApiResult apiResult = new ApiResult();
        ArrayList<Long> templateIds = new ArrayList<Long>(16);
        List allValidateResults = BatchProcessHelper.batchHandle(rowdatas, (int)200, (int)100, this::validateBatchBills, null, (BatchProcessHelper.Scene)BatchProcessHelper.Scene.CPU);
        ArrayList<BillResult> savedBillResults = new ArrayList<BillResult>(16);
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        int index = 0;
        int validIndex = 0;
        while (iterator.hasNext()) {
            ImportBillData importBillData = iterator.next();
            Optional validMsg = (Optional)allValidateResults.get(index);
            if (validMsg.isPresent()) {
                logger.log(Integer.valueOf(importBillData.getStartIndex()), (String)validMsg.get()).fail();
                iterator.remove();
            } else {
                String templateNumber = ImportHelper.getImportBillProp(importBillData, "template.number").toString();
                BillResult result = new BillResult();
                result.setIndex(validIndex++);
                result.setNumber(templateNumber);
                result.setSucess(true);
                result.setData((Map<String, Object>)importBillData.getData());
                result.setId(importBillData.getData().getLong("id"));
                savedBillResults.add(result);
                Set<Long> ids = this.allVersiontemplates.get(templateNumber);
                if (ids != null) {
                    templateIds.addAll(ids);
                }
            }
            ++index;
        }
        if (!rowdatas.isEmpty()) {
            Map<Long, String> errResult = this.batchSave(rowdatas, templateIds);
            this.afterSaveBatch(templateIds);
            if (errResult.size() != rowdatas.size()) {
                this.success = true;
            }
            if (!errResult.isEmpty()) {
                savedBillResults.forEach(t -> {
                    String message = (String)errResult.get(t.getId());
                    if (message != null) {
                        t.setSucess(false);
                        t.setMessage(message);
                    }
                });
                apiResult.setSuccess(false);
            }
        }
        ArrayList apiResultData = new ArrayList(10);
        savedBillResults.forEach(t -> apiResultData.add(t.toMap()));
        apiResult.setData(apiResultData);
        return apiResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Optional<String>> validateBatchBills(List<ImportBillData> bills) {
        ArrayList<Optional<String>> billValidateResults = new ArrayList<Optional<String>>(bills.size());
        long[] ids = DBServiceHelper.genLongIds((String)"bcm_distributionentity", (int)bills.size());
        int index = 0;
        for (ImportBillData bill : bills) {
            try {
                billValidateResults.add(this.validateBillData(bill, ids[index]));
            }
            catch (Exception e) {
                log.error("Failed to validate distribution bill: " + bill.getData() + " for " + e.getMessage(), (Throwable)e);
                billValidateResults.add(Optional.of(e.getMessage()));
            }
            finally {
                ++index;
            }
        }
        return billValidateResults;
    }

    private Optional<String> validateBillData(ImportBillData bill, long id) {
        List<DynamicObject> dynamicObjects;
        String templateNumber = ImportHelper.getImportBillProp(bill, "template.number").toString();
        if (StringUtils.isEmpty((String)templateNumber)) {
            return Optional.of(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DistributionImport_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (this.allVersiontemplates.get(templateNumber) == null) {
            return Optional.of(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u6a21\u677f\u5728\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"DistributionImport_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), templateNumber));
        }
        String memrangdecombo = ImportHelper.getImportBillProp(bill, "memrangdecombo").toString();
        if (StringUtils.isEmpty((String)memrangdecombo)) {
            return Optional.of(ResManager.loadKDString((String)"\u7ec4\u7ec7\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DistributionImport_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (!(ImportHelper.getImportBillProp(bill, "memrangdecombo") instanceof String) || RangeEnum.getTempDistributeRangeByVal((int)Integer.parseInt(memrangdecombo)) == null) {
            return Optional.of(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u8303\u56f4%s\u4e0d\u5408\u6cd5\u3002", (String)"DistributionImport_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), memrangdecombo));
        }
        String effectway = ImportHelper.getImportBillProp(bill, "effectway").toString();
        if (StringUtils.isEmpty((String)effectway)) {
            return Optional.of(ResManager.loadKDString((String)"\u9002\u7528\u4f8b\u5916\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DistributionImport_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (!(ImportHelper.getImportBillProp(bill, "memrangdecombo") instanceof String) || DisEffectWayEnum.getDisEffectWayEnum((int)Integer.parseInt(effectway)) == null) {
            return Optional.of(String.format(ResManager.loadKDString((String)"\u9002\u7528\u4f8b\u5916%s\u4e0d\u5408\u6cd5\u3002", (String)"DistributionImport_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), effectway));
        }
        String dpNumber = ImportHelper.getImportBillProp(bill, "definedproperty.number").toString();
        String dpValueNumber = ImportHelper.getImportBillProp(bill, "definedpropertyvalue.number").toString();
        String orgNumber = ImportHelper.getImportBillProp(bill, "entity.number").toString();
        boolean isDp = StringUtils.isEmpty((String)orgNumber) && (StringUtils.isNotEmpty((String)dpNumber) || StringUtils.isNotEmpty((String)dpValueNumber));
        boolean isCustom = false;
        if (isDp) {
            isCustom = true;
            bill.getData().put(ISCUSTOM, (Object)isCustom);
            if (StringUtils.isEmpty((String)dpNumber)) {
                return Optional.of(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DistributionImport_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (this.dpMap.get(dpNumber) == null) {
                return Optional.of(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u81ea\u5b9a\u4e49\u5c5e\u6027\u5728\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"DistributionImport_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dpNumber));
            }
            if (StringUtils.isEmpty((String)dpValueNumber)) {
                return Optional.of(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5c5e\u6027\u503c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DistributionImport_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (this.dpValueMap.get(dpValueNumber) == null) {
                return Optional.of(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u81ea\u5b9a\u4e49\u5c5e\u6027\u503c\u5728\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"DistributionImport_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dpNumber));
            }
        } else {
            bill.getData().put(ISCUSTOM, (Object)isCustom);
            if (StringUtils.isEmpty((String)orgNumber)) {
                return Optional.of(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DistributionImport_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (MemberReader.findEntityMemberByNum((String)this.modelNumber, (String)orgNumber) == IDNumberTreeNode.NotFoundTreeNode) {
                return Optional.of(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7ec4\u7ec7\u5728\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"DistributionImport_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgNumber));
            }
        }
        if ((dynamicObjects = this.disMap.get(Tuple.create((Object)isCustom, (Object)Pair.onePair((Object)(isCustom ? dpValueNumber : orgNumber), (Object)Integer.parseInt(memrangdecombo)), (Object)templateNumber))) != null && !dynamicObjects.isEmpty()) {
            bill.getData().put("id", (Object)dynamicObjects.get(0).getLong("id"));
            bill.getData().put(DATATYPE, (Object)true);
        } else {
            bill.getData().put("id", (Object)id);
            bill.getData().put(DATATYPE, (Object)false);
        }
        return Optional.empty();
    }

    private void prepareData() {
        DynamicObject[] disDyos;
        DynamicObjectCollection dynamicObjects;
        this.modelId = LongUtil.toLong(this.ctx.getOption().get("BcmModelId"));
        this.modelNumber = MemberReader.findModelNumberById((Object)this.modelId);
        QFilter modelFilter = new QFilter("model", "=", (Object)this.modelId);
        QFilter templatetypeFilter = new QFilter("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
        DynamicObjectCollection templateDyo = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number", (QFilter[])new QFilter[]{modelFilter, templatetypeFilter});
        templateDyo.stream().forEach(dyo -> {
            String number = dyo.getString("number");
            if (this.allVersiontemplates.get(number) == null) {
                this.allVersiontemplates.put(number, new HashSet(16));
            }
            Set<Long> ids = this.allVersiontemplates.get(number);
            ids.add(dyo.getLong("id"));
        });
        QFilter dimFilter = new QFilter("dimension.number", "=", (Object)DimEntityNumEnum.ENTITY.getNumber());
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"bcm_definedproperty", (String)"id,number,name", (QFilter[])new QFilter[]{modelFilter, dimFilter});
        if (!objects.isEmpty()) {
            objects.forEach(dyo -> this.dpMap.put(dyo.getString("number"), (DynamicObject)dyo));
        }
        if (!(dynamicObjects = QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)"id,number,name", (QFilter[])new QFilter[]{modelFilter, dimFilter})).isEmpty()) {
            dynamicObjects.forEach(dyo -> this.dpValueMap.put(dyo.getString("number"), (DynamicObject)dyo));
        }
        if ((disDyos = BusinessDataServiceHelper.load((String)"bcm_distributionentity", (String)"id,entity,template,memrangdecombo,definedproperty,definedpropertyvalue,textname,effectway", (QFilter[])modelFilter.toArray())).length != 0) {
            Arrays.stream(disDyos).forEach(dyo -> {
                Tuple tuple = null;
                tuple = dyo.get("entity") != null ? Tuple.create((Object)false, (Object)Pair.onePair((Object)dyo.getString("entity.number"), (Object)dyo.getInt("memrangdecombo")), (Object)dyo.getString("template.number")) : Tuple.create((Object)true, (Object)Pair.onePair((Object)dyo.getString("definedpropertyvalue.number"), (Object)dyo.getInt("memrangdecombo")), (Object)dyo.getString("template.number"));
                if (this.disMap.get(tuple) == null) {
                    this.disMap.put((Tuple<Boolean, Pair<String, Integer>, String>)tuple, new ArrayList(16));
                }
                this.disMap.get(tuple).add((DynamicObject)dyo);
            });
        }
    }

    private Map<Long, String> batchSave(List<ImportBillData> billDataList, List<Long> templateIds) {
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        if (ImportOperateType.OVERRIDE == importType || ImportOperateType.OVERRIDENEW == importType) {
            return this.saveDb(billDataList, importType, templateIds);
        }
        return new HashMap<Long, String>(16);
    }

    private Map<Long, String> saveDb(List<ImportBillData> billDataList, ImportOperateType importType, List<Long> templateIds) {
        HashMap<Long, String> errorMap = new HashMap<Long, String>(16);
        HashMap exitDyo = new HashMap(16);
        ArrayList<DynamicObject> updateDyos = new ArrayList<DynamicObject>(billDataList.size());
        ArrayList<DynamicObject> newDyos = new ArrayList<DynamicObject>(billDataList.size());
        billDataList.forEach(billData -> {
            boolean isExit;
            String templateNumber = ImportHelper.getImportBillProp(billData, "template.number").toString();
            boolean isDp = (Boolean)billData.getData().get((Object)ISCUSTOM);
            String dpValueNumber = ImportHelper.getImportBillProp(billData, "definedpropertyvalue.number").toString();
            String orgNumber = ImportHelper.getImportBillProp(billData, "entity.number").toString();
            String scope = ImportHelper.getImportBillProp(billData, "memrangdecombo").toString();
            String effectway = ImportHelper.getImportBillProp(billData, "effectway").toString();
            Tuple tuple = Tuple.create((Object)isDp, (Object)Pair.onePair((Object)(isDp ? dpValueNumber : orgNumber), (Object)Integer.parseInt(scope)), (Object)templateNumber);
            List<DynamicObject> dynamicObjects = this.disMap.get(tuple);
            String dpNumber = ImportHelper.getImportBillProp(billData, "definedproperty.number").toString();
            Set<Long> ids = this.allVersiontemplates.get(templateNumber);
            List fontPrePareDyo = (List)exitDyo.get(tuple);
            boolean bl = isExit = fontPrePareDyo != null && !fontPrePareDyo.isEmpty();
            if (((Boolean)billData.getData().get((Object)DATATYPE)).booleanValue() && dynamicObjects != null && !dynamicObjects.isEmpty()) {
                if (isExit) {
                    updateDyos.removeAll(fontPrePareDyo);
                }
                dynamicObjects.forEach(dyo -> dyo.set("effectway", (Object)effectway));
                updateDyos.addAll(dynamicObjects);
                exitDyo.put(tuple, dynamicObjects);
            } else if (ImportOperateType.OVERRIDE == importType) {
                if (!ids.isEmpty()) {
                    templateIds.removeAll(ids);
                }
                errorMap.put(billData.getData().getLong("id"), ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u8bb0\u5f55\u4e0d\u66f4\u65b0\u3002", (String)"DistributionImport_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else if (ImportOperateType.OVERRIDENEW == importType && !ids.isEmpty()) {
                ArrayList nDyos = new ArrayList(16);
                ids.forEach(id -> {
                    DynamicObject distribute = BusinessDataServiceHelper.newDynamicObject((String)"bcm_distributionentity");
                    String textName = "";
                    if (isDp) {
                        DynamicObject dpDyo = this.dpMap.get(dpNumber);
                        DynamicObject dpValueDyo = this.dpValueMap.get(dpValueNumber);
                        distribute.set("definedproperty", (Object)dpDyo.getLong("id"));
                        distribute.set("definedpropertyvalue", (Object)dpValueDyo.getLong("id"));
                        if (dpDyo != null && dpValueDyo != null) {
                            textName = dpDyo.getString("name") + ":" + dpValueDyo.getString("name");
                        }
                    } else {
                        IDNumberTreeNode node = MemberReader.findEntityMemberByNum((String)this.modelNumber, (String)orgNumber);
                        distribute.set("entity", (Object)node.getId());
                        textName = node.getName();
                    }
                    distribute.set("memrangdecombo", (Object)scope);
                    distribute.set("effectway", (Object)effectway);
                    distribute.set("template", id);
                    distribute.set("model", (Object)this.modelId);
                    distribute.set("textname", (Object)textName);
                    nDyos.add(distribute);
                });
                if (isExit) {
                    newDyos.removeAll(fontPrePareDyo);
                }
                newDyos.addAll(nDyos);
                exitDyo.put(tuple, nDyos);
            }
        });
        this.batchSaveDistribution(updateDyos, newDyos, errorMap);
        return errorMap;
    }

    private void batchSaveDistribution(List<DynamicObject> updateDyos, List<DynamicObject> newDyos, Map<Long, String> errorMap) {
        try (TXHandle tx = TX.requiresNew((String)"batchSaveDistribution");){
            try {
                if (!updateDyos.isEmpty()) {
                    SaveServiceHelper.update((DynamicObject[])updateDyos.toArray(new DynamicObject[0]));
                }
                if (!newDyos.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])newDyos.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                log.error("batchSaveDistribution rollback, error:" + e.getMessage(), (Throwable)e);
                tx.markRollback();
                updateDyos.forEach(dyo -> errorMap.put(dyo.getLong("id"), this.buildExceptionMsg(e, 2, true)));
                newDyos.forEach(dynamicObject -> errorMap.put(dynamicObject.getLong("id"), this.buildExceptionMsg(e, 2, true)));
            }
        }
    }

    private String buildExceptionMsg(Exception e, int stackLimit, boolean isSimple) {
        List stackMsgs = Arrays.stream(e.getStackTrace()).filter(ele -> ele.getClassName().startsWith("kd.fi.bcm")).map(ele -> isSimple ? String.format("%s:%s", ele.getFileName(), ele.getLineNumber()) : ele.toString()).collect(Collectors.toList());
        if (stackLimit > 0) {
            stackMsgs = stackMsgs.subList(0, Math.min(stackMsgs.size(), stackLimit));
        }
        return String.format("%s %s[%s] %s", ImportMsgUtils.unexpectedError(), e.getMessage(), RequestContext.get().getTraceId(), String.join((CharSequence)",", stackMsgs));
    }

    private void afterSaveBatch(List<Long> templateIds) {
        if (!templateIds.isEmpty()) {
            MyTaskStatusHelper.refreshTaskStatusRecord4TempleteID((Long[])templateIds.toArray(new Long[templateIds.size()]));
            AppCacheServiceHelper.removeTemplateDispenseCache((String)MemberReader.findModelNumberById((Object)this.modelId));
        }
        this.clear();
    }
}

