/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.export.NewExportUtil;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.serviceHelper.MyTaskStatusHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.util.TemplateDistributionOrgUtil;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.datatypeutil.DataTypeConvertUtil;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.template.SearchResult;
import kd.fi.bcm.formplugin.util.ReportListUtil;

public class DistributionPlugin
extends AbstractBaseFormPlugin {
    public static final String selectOrg_entityID = "dentity";
    public static final String temCatalog_treeID = "temcatalogtree";
    private static final String ROOT_NODE = "rootNode";
    private static final String CACHE_SEARCH = "cache_search";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String MODEL = "model";
    private static final String TEMPLATE = "template";
    private static final String ENTITY = "entity";
    private static final String VIEW_COMBO = "viewcombo";
    private static final String BILL_LIST_AP = "billlistap";
    private static final String ORG_IDS = "orgids";
    private static final String MEM_RANGE_COMBO = "memrangdecombo";
    private static final String GROUP = "group";
    private static final String TEXT_NAME = "textname";
    private static final String RANGE_VALUE = "rangevalue";
    private static final String EFFECTWAY = "effectway";
    private static final String DEFINED_PROPERTY_VALUE = "definedpropertyvalue";
    private static final String DEFINED_PROPERTY = "definedproperty";
    private static final String COPY_FROM = "copyfrom";
    private static final String TEMPLATE_IDS = "templeteids";
    private static final String TEMPLATELIST_TEMPLATE_IDS = "templatelist_template_ids";
    private final TreeNodeCheckListener treeNodeCheckListener = new TreeNodeCheckListener(){

        public void treeNodeCheck(TreeNodeCheckEvent evt) {
            DistributionPlugin.this.getPageCache().remove(DistributionPlugin.TEMPLATELIST_TEMPLATE_IDS);
            DistributionPlugin.this.refreshBillList();
        }
    };
    private final SetFilterListener setFilterListener = new SetFilterListener(){

        public void setFilter(SetFilterEvent evt) {
            List filters = evt.getQFilters();
            QFilter filter1 = DistributionPlugin.this.getTemQueryFilter(DistributionPlugin.temCatalog_treeID, DistributionPlugin.TEMPLATE);
            QFilter filter2 = DistributionPlugin.this.getOrgQueryFilter(DistributionPlugin.selectOrg_entityID, "oid", DistributionPlugin.ENTITY);
            if (filter1 == null && filter2 == null) {
                filters.add(new QFilter("1", "!=", (Object)1));
            } else if (filter1 == null) {
                filters.add(new QFilter("1", "!=", (Object)1));
            } else if (filter2 == null) {
                filters.add(filter1);
            } else {
                filters.add(filter1.and(filter2));
            }
        }
    };

    private static OpNameMultiLangEnumBridge getOperationSend() {
        return new OpNameMultiLangEnumBridge("\u5206\u914d", "DistributionPlugin_0", FI_BCM_FORMPLUGIN, "Allocate");
    }

    private static OpNameMultiLangEnumBridge getOperationBackSend() {
        return new OpNameMultiLangEnumBridge("\u53cd\u5206\u914d", "DistributionPlugin_20", FI_BCM_FORMPLUGIN, "Anti allocate");
    }

    private static final String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"DistributionPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private static final String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"DistributionPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addListeners();
    }

    private void addListeners() {
        this.addClickListeners("selectorg", "deleteorg", "deletedistribution", "details", "imageup", "imagedown");
        this.addItemClickListeners("toolbarap");
        TreeView tree = (TreeView)this.getControl(temCatalog_treeID);
        tree.addTreeNodeCheckListener(this.treeNodeCheckListener);
        EntryGrid orgeg = (EntryGrid)this.getControl(selectOrg_entityID);
        orgeg.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                super.entryRowClick(evt);
                DistributionPlugin.this.refreshBillList();
            }
        });
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.addSetFilterListener(this.setFilterListener);
        billList.addCreateListColumnsListener(new CreateListColumnsListener(){

            public void createListColumns(BeforeCreateListColumnsArgs args) {
                List listCol = args.getListColumns();
                String viewid = (String)DistributionPlugin.this.getModel().getValue(DistributionPlugin.VIEW_COMBO);
                if (kd.bos.util.StringUtils.isNotEmpty((String)viewid)) {
                    DistributionPlugin.this.swapColOrder(viewid, listCol);
                }
            }
        });
        Search se = (Search)this.getControl("searchap");
        se.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent var1) {
                String text = var1.getText();
                if (text != null && !"".equals(text)) {
                    DistributionPlugin.this.searchTemplate(text.trim());
                } else {
                    DistributionPlugin.this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                }
            }
        });
    }

    private void swapColOrder(String viewid, List<IListColumn> listCol) {
        String listFieldKey = listCol.get(0).getListFieldKey();
        if ("template.number".equals(listFieldKey) && "10".equals(viewid) || TEXT_NAME.equals(listFieldKey) && "20".equals(viewid)) {
            return;
        }
        if ("10".equals(viewid)) {
            Collections.swap(listCol, 0, 1);
            Collections.swap(listCol, 1, 2);
        } else if ("20".equals(viewid)) {
            Collections.swap(listCol, 0, 2);
            Collections.swap(listCol, 1, 2);
        }
        if (this.getPageCache().get("viewcombo_change") != null) {
            this.getPageCache().remove("viewcombo_change");
            this.getView().updateView(BILL_LIST_AP);
        }
    }

    private void searchTemplate(String search) {
        TreeView tree = (TreeView)this.getControl(temCatalog_treeID);
        String rootNodeCache = this.getPageCache().get(ROOT_NODE);
        if (rootNodeCache != null) {
            TreeNode root = (TreeNode)ObjectSerialUtil.deSerializedBytes((String)rootNodeCache);
            ArrayList<TreeNode> hitNode = new ArrayList<TreeNode>();
            root.getTreeNodeListByText(hitNode, search, 999);
            SearchResult result = null;
            if (!hitNode.isEmpty()) {
                result = new SearchResult(hitNode);
                TreeNode next = result.next(1);
                tree.checkNode(next);
                tree.focusNode(next);
                this.refreshBillList();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5173\u8282\u70b9\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u540d\u79f0\u540e\u641c\u7d22\u3002", (String)"DistributionPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            this.getPageCache().put(CACHE_SEARCH, result == null ? null : ObjectSerialUtil.toByteSerialized((Object)result));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_distribute": {
                this.distributeMember();
                break;
            }
            case "btn_import": {
                this.importData();
                break;
            }
            case "btn_export": {
                this.exportData();
                break;
            }
            case "btn_clear": {
                String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
                AppCacheServiceHelper.removeTemplateDispenseCache((String)modelNum);
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6e05\u7406\u5206\u914d\u7f13\u5b58%s\u3002", (String)"DistributionPlugin_28", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), ResultStatusEnum.SUCCESS.getName()));
                OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u6e05\u7406\u5206\u914d\u7f13\u5b58", "DistributionPlugin_27", FI_BCM_FORMPLUGIN, "clearDistributionCache");
                this.writeOperationLog(opName, ResultStatusEnum.SUCCESS.getName());
                break;
            }
        }
    }

    private void importData() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bcm_batch_bos_importstart");
        HashMap parameter = new HashMap();
        ArrayList plugins = new ArrayList();
        LinkedHashMap<String, Object> plugin = new LinkedHashMap<String, Object>();
        plugin.put("Type", 0);
        plugin.put("_Type_", "Plugin");
        plugin.put("ClassName", "kd.fi.bcm.formplugin.template.DistributionImport");
        plugin.put("Enabled", true);
        plugin.put("rowKey", null);
        plugin.put("modelid", this.getModelId());
        plugins.add(plugin);
        parameter.put("plugins", plugins);
        showParameter.setCustomParams(parameter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("ServiceAppId", (Object)this.getBizAppId());
        showParameter.setCustomParam("modelid", (Object)this.getModelId());
        showParameter.setCustomParam("ListName", (Object)ResManager.loadKDString((String)"\u6a21\u677f\u5206\u914d\u7ec4\u7ec7\u8bb0\u5f55", (String)"DistributionPlugin_23", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        showParameter.setCustomParam("BillFormId", (Object)"bcm_distributionentity");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_distributionentity_IMPT_S"));
        this.getView().showForm(showParameter);
    }

    private QFilter getExportFilter() {
        List<Long> tempIds;
        QFilter filter;
        DynamicObjectCollection doc;
        QFilter exportFilter = null;
        BillList billlist = (BillList)this.getControl(BILL_LIST_AP);
        ListSelectedRowCollection listrows = billlist.getSelectedRows();
        String selectFields = "id,entity,template,memrangdecombo,definedproperty,definedpropertyvalue,textname";
        Object[] rows = listrows.getPrimaryKeyValues();
        if (rows.length != 0 && !(doc = QueryServiceHelper.query((String)"bcm_distributionentity", (String)selectFields, (QFilter[])new QFilter[]{filter = new QFilter("id", "in", (Object)rows)})).isEmpty()) {
            exportFilter = new QFilter("id", "in", doc.stream().map(dyo -> dyo.getLong("id")).collect(Collectors.toList()));
        }
        if (exportFilter == null && !(tempIds = this.getTemSelectedAndResultList(temCatalog_treeID)).isEmpty()) {
            exportFilter = new QFilter(TEMPLATE, "in", tempIds);
        }
        return exportFilter;
    }

    private void exportData() {
        String routeAppId = this.getView().getFormShowParameter().getServiceAppId();
        long modelid = this.getModelId();
        QFilter filter = new QFilter(MODEL, "=", (Object)modelid);
        QFilter exportFilter = this.getExportFilter();
        if (exportFilter == null) {
            DynamicObjectCollection templateColls = this.getTemplateColls(modelid);
            exportFilter = templateColls != null && !templateColls.isEmpty() ? new QFilter(TEMPLATE, "in", templateColls.stream().map(d -> d.getLong("id")).collect(Collectors.toSet())) : new QFilter("1", "=", (Object)1);
        }
        String selectFields = "id,entity,template,memrangdecombo,definedproperty,definedpropertyvalue,textname,effectway";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bcm_distributionentity", (String)selectFields, (QFilter[])new QFilter[]{filter, exportFilter});
        boolean flag = false;
        if (dynamicObjects.length != 0) {
            try {
                String url = NewExportUtil.export((String)routeAppId, (DynamicObject[])dynamicObjects, (String)"bcm_distributionentity_IMPT_S", (String)"bcm_distributionentity", (String)ResManager.loadKDString((String)"\u6a21\u677f\u5206\u914d\u7ec4\u7ec7\u8bb0\u5f55", (String)"DistributionPlugin_23", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                if (StringUtils.isNotEmpty((CharSequence)url)) {
                    this.downloadFile(url, "bcm_templatelist", "47150e89000000ac");
                }
                flag = true;
            }
            catch (Exception e) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6a21\u677f\u5206\u914d\u7ec4\u7ec7\u8bb0\u5f55\u5bfc\u51fa\u5931\u8d25\uff1a%s", (String)"DistributionPlugin_22", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), e.getMessage()));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6a21\u677f\u5206\u914d\u8bb0\u5f55\uff0c\u65e0\u6cd5\u5bfc\u51fa\u3002", (String)"DistributionPlugin_24", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u6a21\u677f\u5206\u914d\u7ec4\u7ec7\u8bb0\u5f55\u5bfc\u51fa", "DistributionPlugin_21", FI_BCM_FORMPLUGIN, "exportDistributionRecord");
        this.writeOperationLog(opName, flag ? ResultStatusEnum.SUCCESS.getName() : ResultStatusEnum.FAIL.getName());
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "selectorg": {
                this.showSelectOrgView();
                break;
            }
            case "deleteorg": {
                this.deleteOrgMember();
                break;
            }
            case "deletedistribution": {
                this.deleteDistribution();
                break;
            }
            case "details": {
                this.showDetailsView();
                break;
            }
            case "imageup": {
                this.searchNext(-1);
                break;
            }
            case "imagedown": {
                this.searchNext(1);
                break;
            }
        }
    }

    private void searchNext(int i) {
        IPageCache pageCache = this.getPageCache();
        String searchResultCache = pageCache.get(CACHE_SEARCH);
        if (searchResultCache != null) {
            SearchResult result = (SearchResult)ObjectSerialUtil.deSerializedBytes((String)searchResultCache);
            TreeNode next = result.next(i);
            TreeView tree = (TreeView)this.getControl(temCatalog_treeID);
            if (next == null) {
                if (i > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"DistributionPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"DistributionPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                }
            } else {
                tree.checkNode(next);
                tree.treeNodeClick(next.getParentid(), next.getId());
                pageCache.put(CACHE_SEARCH, ObjectSerialUtil.toByteSerialized((Object)result));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"DistributionPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private void showDetailsView() {
        BillList billlist = (BillList)this.getControl(BILL_LIST_AP);
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_distribution_details");
        param.setCaption(ResManager.loadKDString((String)"\u6a21\u677f\u5206\u914d\u8be6\u60c5", (String)"DistributionPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        Object[] ids = null;
        ids = billlist.getSelectedRows().getPrimaryKeyValues().length < 1 ? billlist.getCurrentListAllRowCollection().getPrimaryKeyValues() : billlist.getSelectedRows().getPrimaryKeyValues();
        param.setCustomParam("ids", (Object)SerializationUtils.toJsonString((Object)ids));
        param.setCustomParam("modelid", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        param.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(param);
    }

    private void deleteDistribution() {
        BillList billlist = (BillList)this.getControl(BILL_LIST_AP);
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u53cd\u5206\u914d\u8bb0\u5f55\u7684\u6570\u636e\u884c\u3002", (String)"DistributionPlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u53cd\u5206\u914d\u3002", (String)"DistributionPlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_comfirm", (IFormPlugin)this));
    }

    private void distributeMember() {
        List<Long> temlist = this.getTemSelectedAndResultList(temCatalog_treeID);
        List<DynamicObject> orglist = this.getOrgSelectedAndResultList(selectOrg_entityID);
        if (temlist.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u6a21\u677f\u3002", (String)"DistributionPlugin_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (orglist.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u7ec4\u7ec7\u3002", (String)"DistributionPlugin_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        String msg = this.removeOrgMenberTemplate(temlist);
        if (temlist.isEmpty()) {
            return;
        }
        String modelid = this.getPageCache().get("KEY_MODEL_ID");
        QFilter qcf = new QFilter("id", "in", temlist);
        DynamicObjectCollection data = QueryServiceHelper.query((String)"bcm_templateentity", (String)"name,number", (QFilter[])new QFilter[]{qcf});
        try {
            for (int i = 0; i < data.size(); ++i) {
                this.writeOperationLog(DistributionPlugin.getOperationSend(), ((DynamicObject)data.get(i)).getString("number"), ((DynamicObject)data.get(i)).getString("name"), DistributionPlugin.getOperationStstusSuccess());
            }
            this.saveDistributeRecord(this.mergeResult(orglist, temlist, modelid), msg);
        }
        catch (Exception e) {
            for (int i = 0; i < data.size(); ++i) {
                this.writeOperationLog(DistributionPlugin.getOperationSend(), ((DynamicObject)data.get(i)).getString("number"), ((DynamicObject)data.get(i)).getString("name"), DistributionPlugin.getOperationStstusFail());
            }
            throw e;
        }
    }

    private String removeOrgMenberTemplate(List<Long> tlist) {
        List temids;
        String oo = this.getPageCache().get(ORG_IDS);
        if (!StringUtils.isEmpty((CharSequence)oo) && tlist.removeAll(temids = (List)SerializationUtils.fromJsonString((String)oo, List.class))) {
            return String.format(ResManager.loadKDString((String)"\u5df2\u8df3\u8fc7\u7ec4\u7ec7\u7ef4\u5ea6\u540d\u79f0\u201c%s\u201d\u5728\u89c6\u70b9\u7ef4\u7684\u62a5\u8868\u6a21\u677f\u3002", (String)"DistributionPlugin_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), this.getEntityName().getString("name"));
        }
        return "";
    }

    private DynamicObject getEntityName() {
        QFilter filter1 = new QFilter(MODEL, "=", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        QFilter filter2 = new QFilter("number", "=", (Object)DimTypesEnum.ENTITY.getNumber());
        QFilter[] filters = new QFilter[]{filter1, filter2};
        return QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"name", (QFilter[])filters);
    }

    private List<Long> getTemSelectedAndResultList(String entityid) {
        TreeView tree = (TreeView)this.getControl(entityid);
        List tids = tree.getTreeState().getSelectedNodeId();
        if (tids.isEmpty()) {
            String cache = this.getPageCache().get(TEMPLATE_IDS);
            tids = StringUtils.isNotEmpty((CharSequence)cache) ? (List)SerializationUtils.fromJsonString((String)cache, List.class) : new ArrayList();
            this.getPageCache().remove(TEMPLATE_IDS);
            if (tids.isEmpty()) {
                cache = this.getPageCache().get(TEMPLATELIST_TEMPLATE_IDS);
                tids = StringUtils.isNotEmpty((CharSequence)cache) ? (List)SerializationUtils.fromJsonString((String)cache, List.class) : new ArrayList();
            }
        }
        DynamicObjectCollection doc = this.getTemplatecatalogList();
        LinkedList<String> clist = new LinkedList<String>();
        for (DynamicObject dd : doc) {
            clist.add(dd.getString("id"));
        }
        tids.removeAll(clist);
        return DataTypeConvertUtil.convert(tids);
    }

    private List<DynamicObject> getOrgSelectedAndResultList(String entityid) {
        EntryGrid eg = (EntryGrid)this.getControl(entityid);
        int[] rows = eg.getEntryState().getSelectedRows();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (int row : rows) {
            DynamicObject dd = this.getModel().getEntryRowEntity(entityid, row);
            if (dd == null) continue;
            list.add(dd);
        }
        return list;
    }

    private void saveDistributeRecord(List<DynamicObject> dlist, String msg) {
        long modelid = this.getModelId();
        QFilter filter = new QFilter(MODEL, "=", (Object)modelid);
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id,entity,template,memrangdecombo,definedpropertyvalue ";
        DynamicObjectCollection oldoc = QueryServiceHelper.query((String)"bcm_distributionentity", (String)selectFields, (QFilter[])filters);
        int index = 0;
        block12: for (DynamicObject tem : oldoc) {
            index = 0;
            for (DynamicObject dd : dlist) {
                String cloname;
                Object entityid = dd.get(ENTITY);
                String string = cloname = !ObjectUtils.isEmpty((Object)entityid) ? ENTITY : DEFINED_PROPERTY_VALUE;
                if (tem.getLong(TEMPLATE) == dd.getLong(TEMPLATE) && tem.get(MEM_RANGE_COMBO).equals(dd.get(MEM_RANGE_COMBO)) && tem.getLong(cloname) == dd.getLong(cloname)) {
                    dlist.remove(index);
                    continue block12;
                }
                ++index;
            }
        }
        if (dlist.isEmpty()) {
            return;
        }
        try (TXHandle tx = TX.required((String)"bcm_actionsave");){
            try {
                this.copyVersionDistribute(dlist);
                DynamicObject[] newdoc = dlist.toArray(new DynamicObject[dlist.size()]);
                Object[] oo = SaveServiceHelper.save((DynamicObject[])newdoc);
                Long[] templateids = new Long[newdoc.length];
                int i = 0;
                for (DynamicObject dd : newdoc) {
                    Long tempid;
                    templateids[i] = tempid = Long.valueOf(dd.getLong(TEMPLATE));
                    ++i;
                }
                MyTaskStatusHelper.refreshTaskStatusRecord4TempleteID((Long[])templateids);
                if (oo.length > 0) {
                    this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f%s\u3002", (String)"DistributionPlugin_13", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), msg));
                }
                AppCacheServiceHelper.removeTemplateDispenseCache((String)MemberReader.findModelNumberById((Object)modelid));
            }
            catch (KDBizException e) {
                tx.markRollback();
                throw e;
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
        this.refreshBillList();
    }

    public void copyVersionDistribute(List<DynamicObject> dlist) {
        HashSet templateIds = Sets.newHashSet();
        HashMap tpl2Group = Maps.newHashMap();
        HashBasedTable tpl2group2tpl = HashBasedTable.create();
        ArrayListMultimap id2Dyn = ArrayListMultimap.create();
        dlist.forEach(arg_0 -> DistributionPlugin.lambda$copyVersionDistribute$2(templateIds, (Multimap)id2Dyn, arg_0));
        try (DataSet templateDs = QueryServiceHelper.queryDataSet((String)"kd.fi.bcm.formplugin.template.DistributionPlugin.saveDistributeRecord", (String)"bcm_templateentity", (String)"id, group", (QFilter[])new QFilter("id", "in", (Object)templateIds).toArray(), null);){
            templateDs.forEach(ds -> tpl2Group.put(ds.getLong(GROUP), ds.getLong("id")));
        }
        templateDs = QueryServiceHelper.queryDataSet((String)"kd.fi.bcm.formplugin.template.DistributionPlugin.saveDistributeRecord", (String)"bcm_templateentity", (String)"id, group", (QFilter[])new QFilter(GROUP, "in", tpl2Group.keySet()).toArray(), null);
        var7_7 = null;
        try {
            templateDs.forEach(arg_0 -> DistributionPlugin.lambda$copyVersionDistribute$4((Table)tpl2group2tpl, tpl2Group, arg_0));
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (templateDs != null) {
                if (var7_7 != null) {
                    try {
                        templateDs.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    templateDs.close();
                }
            }
        }
        tpl2group2tpl.cellSet().forEach(arg_0 -> DistributionPlugin.lambda$copyVersionDistribute$6((Multimap)id2Dyn, dlist, arg_0));
    }

    @Override
    public String getBizEntityNumber() {
        return "bcm_distributionentity";
    }

    private void refreshBillList() {
        BillList billlist = (BillList)this.getControl(BILL_LIST_AP);
        billlist.addSetFilterListener(this.setFilterListener);
        billlist.refresh();
        billlist.clearSelection();
    }

    private QFilter getTemQueryFilter(String entityid, String columnname) {
        List<Long> rows = this.getTemSelectedAndResultList(entityid);
        QFilter filter = null;
        if (!rows.isEmpty()) {
            filter = new QFilter(columnname, "in", (Object)rows.toArray());
        }
        return filter;
    }

    private QFilter getOrgQueryFilter(String entityid, String idname, String columnname) {
        List<DynamicObject> orglist = this.getOrgSelectedAndResultList(entityid);
        LinkedList<Long> mrows = new LinkedList<Long>();
        LinkedList<Long> lrows = new LinkedList<Long>();
        Object[] orgids = new Long[orglist.size()];
        for (int i = 0; i < orglist.size(); ++i) {
            orgids[i] = orglist.get(i).getLong("oid");
        }
        Map orgs = BusinessDataServiceHelper.loadFromCache((Object[])orgids, (String)"bcm_entitymembertree");
        for (DynamicObject org : orglist) {
            if (StringUtils.isEmpty((CharSequence)org.getString("pid").trim())) {
                DynamicObject nowOrg = (DynamicObject)orgs.get(org.getLong(idname));
                if (nowOrg.get(COPY_FROM) != null) {
                    mrows.add(nowOrg.getDynamicObject(COPY_FROM).getLong("id"));
                    continue;
                }
                mrows.add(Long.valueOf(org.getString(idname)));
                continue;
            }
            lrows.add(Long.valueOf(org.getString(idname)));
        }
        QFilter filter = null;
        if (!mrows.isEmpty()) {
            filter = new QFilter(columnname, "in", (Object)mrows.toArray());
        }
        if (!lrows.isEmpty()) {
            QFilter filter2 = new QFilter(DEFINED_PROPERTY_VALUE, "in", (Object)lrows.toArray());
            filter = filter == null ? filter2 : filter.or(filter2);
        }
        return filter;
    }

    private List<DynamicObject> mergeResult(List<DynamicObject> orglist, List<Long> temlist, String modelid) {
        Object[] orgids = new Long[orglist.size()];
        for (int i = 0; i < orglist.size(); ++i) {
            orgids[i] = orglist.get(i).getLong("oid");
        }
        Map orgs = BusinessDataServiceHelper.loadFromCache((Object[])orgids, (String)"bcm_entitymembertree");
        ArrayList<DynamicObject> dlist = new ArrayList<DynamicObject>();
        for (Long tem : temlist) {
            for (DynamicObject org : orglist) {
                DynamicObject distribute = BusinessDataServiceHelper.newDynamicObject((String)"bcm_distributionentity");
                if (StringUtils.isEmpty((CharSequence)org.getString("pid").trim())) {
                    DynamicObject nowOrg = (DynamicObject)orgs.get(org.getLong("oid"));
                    if (nowOrg.get(COPY_FROM) != null) {
                        distribute.set(ENTITY, nowOrg.getDynamicObject(COPY_FROM).get("id"));
                    } else {
                        distribute.set(ENTITY, org.get("oid"));
                    }
                } else {
                    distribute.set(DEFINED_PROPERTY, org.get("pid"));
                    distribute.set(DEFINED_PROPERTY_VALUE, org.get("oid"));
                }
                distribute.set(MEM_RANGE_COMBO, org.get(RANGE_VALUE));
                distribute.set(TEMPLATE, (Object)tem);
                distribute.set(MODEL, (Object)modelid);
                distribute.set(TEXT_NAME, org.get(ENTITY));
                distribute.set(EFFECTWAY, org.get("org_effectway"));
                dlist.add(distribute);
            }
        }
        return dlist;
    }

    private void showSelectOrgView() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_mulmemberf7base_dis");
        formShowParameter.setCustomParam("dimension", (Object)"1");
        formShowParameter.setCustomParam("isFilterRateScheme", (Object)Boolean.TRUE);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9 - \u7ec4\u7ec7", (String)"DistributionPlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectmember");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long modelid = this.getModelId();
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelid));
        if (modelid != 0L) {
            TemplateDistributionOrgUtil.updateOldDistribuition((long)modelid);
            this.setTempalteDate2View(modelid);
        }
        FilterParameter fp = new FilterParameter();
        QFilter filter = new QFilter(MODEL, "=", (Object)modelid);
        fp.setFilter(filter);
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        billList.setFilterParameter(fp);
        billList.addSetFilterListener(this.setFilterListener);
    }

    private void setTempalteDate2View(long modelid) {
        TreeNode rootview = null;
        DynamicObjectCollection temlist = this.getTemplateColls(modelid);
        rootview = ReportListUtil.getTemplateTree(this.mergeTemplatecatalogList(modelid), temlist, new ArrayList<TreeNode>(), "0", new TreeNode());
        this.getPageCache().put(ROOT_NODE, ObjectSerialUtil.toByteSerialized((Object)rootview));
        TreeView tree = (TreeView)this.getControl(temCatalog_treeID);
        BCMTreeUtils.spreadAllNode((TreeNode)rootview);
        List rows = (List)this.getView().getFormShowParameter().getCustomParam("rows");
        ArrayList orgIds = new ArrayList();
        ArrayList<TreeNode> selNodes = new ArrayList<TreeNode>();
        for (DynamicObject dd : temlist) {
            if (rows == null || !rows.contains(dd.getString("number"))) continue;
            TreeNode node = rootview.getTreeNode(dd.getString("id"), 10);
            selNodes.add(node);
        }
        tree.addNode(rootview);
        if (!selNodes.isEmpty()) {
            tree.checkNodes(selNodes);
            this.getPageCache().put(TEMPLATELIST_TEMPLATE_IDS, SerializationUtils.toJsonString(selNodes.stream().map(selNode -> selNode.getId()).collect(Collectors.toList())));
            this.getPageCache().put(TEMPLATE_IDS, SerializationUtils.toJsonString(selNodes.stream().map(selNode -> selNode.getId()).collect(Collectors.toList())));
        }
        this.getPageCache().put(ORG_IDS, SerializationUtils.toJsonString(orgIds));
        this.getView().updateView(temCatalog_treeID);
    }

    private DynamicObjectCollection getTemplateColls(long modelid) {
        QFilter filter = new QFilter(MODEL, "=", (Object)modelid);
        filter.and("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
        Object pks = this.getView().getFormShowParameter().getCustomParam("tpks");
        if (pks != null) {
            QFilter filter1 = new QFilter("id", "in", pks);
            filter.and(filter1);
        }
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id,name,templatecatalog,number,group";
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"bcm_templateentity", (String)selectFields, (QFilter[])filters, (String)"sequence,number asc,versionnumber asc");
        DynamicObjectCollection result = new DynamicObjectCollection();
        HashSet groupIds = Sets.newHashSet();
        queryResult.forEach(c -> {
            Long groupId = c.getLong(GROUP);
            if (groupIds.add(groupId)) {
                result.add(c);
            }
        });
        return result;
    }

    private List<Map<String, String>> mergeTemplatecatalogList(long modelid) {
        DynamicObjectCollection doc = this.getTemplatecatalogList();
        ArrayList<Map<String, String>> clist = new ArrayList<Map<String, String>>();
        for (DynamicObject dd : doc) {
            if ("0".equals(dd.getString("parent")) && (dd.getString("longnumber") == null || dd.getString("longnumber") == "")) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", dd.getString("id"));
            map.put("name", dd.getString("name"));
            map.put("parentid", dd.getString("parent"));
            clist.add(map);
        }
        return clist;
    }

    private DynamicObjectCollection getTemplatecatalogList() {
        QFilter filter = new QFilter(MODEL, "=", (Object)this.getModelId());
        QFilter[] filters = new QFilter[]{filter, TemplateCatalogTypeEnum.getTemplateCalcogFilter()};
        String selectFields = "id,parent,name,longnumber,number";
        String orderBys = "longnumber";
        return QueryServiceHelper.query((String)"bcm_templatecatalog", (String)selectFields, (QFilter[])filters, (String)orderBys);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "viewcombo": {
                this.getPageCache().put("viewcombo_change", "true");
                this.refreshBillList();
            }
        }
    }

    private void selectOrgMember(DynamicObjectCollection olddoc, DynamicObjectCollection newdoc) {
        IDataModel model = this.getModel();
        boolean isexist = false;
        HashSet<Integer> list = new HashSet<Integer>(16);
        EntryGrid eg = (EntryGrid)this.getControl(selectOrg_entityID);
        int[] rows = eg.getSelectRows();
        for (DynamicObject newone : newdoc) {
            isexist = false;
            for (DynamicObject oldone : olddoc) {
                if (!newone.get(4).equals(oldone.get("oid")) || !newone.get(5).equals(oldone.get(RANGE_VALUE))) continue;
                isexist = true;
                break;
            }
            if (isexist) continue;
            int index = model.createNewEntryRow(selectOrg_entityID);
            model.setValue(ENTITY, newone.get(3), index);
            model.setValue(RANGE_VALUE, newone.get(5), index);
            model.setValue("oid", newone.get(4), index);
            model.setValue("pid", newone.get(6), index);
            list.add(index);
        }
        for (Object t : (Object)rows) {
            list.add((int)t);
        }
        if (list.isEmpty()) {
            return;
        }
        rows = new int[list.size()];
        int index = 0;
        for (Integer row : list) {
            rows[index++] = row;
        }
        eg.selectRows(rows, rows[0]);
    }

    private void deleteOrgMember() {
        EntryGrid eg = (EntryGrid)this.getControl(selectOrg_entityID);
        int[] row = eg.getEntryState().getSelectedRows();
        if (row.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"DistributionPlugin_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryRows(selectOrg_entityID, row);
        this.refreshBillList();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        DynamicObjectCollection olddoc = this.getModel().getEntryEntity(selectOrg_entityID);
        switch (actionId) {
            case "selectmember": {
                if (e.getReturnData() == null) break;
                DynamicObjectCollection newdoc = (DynamicObjectCollection)e.getReturnData();
                this.selectOrgMember(olddoc, newdoc);
                this.refreshBillList();
                break;
            }
            case "bcm_distributionentity_IMPT_S": {
                if (this.getPageCache().get("isImport") == null) break;
                TreeView tree = (TreeView)this.getControl(temCatalog_treeID);
                String rootNodeCache = this.getPageCache().get(ROOT_NODE);
                if (rootNodeCache != null) {
                    ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(16);
                    TreeNode root = (TreeNode)ObjectSerialUtil.deSerializedBytes((String)rootNodeCache);
                    tree.checkNodes(this.getAllTreeNodes(root, treeNodes));
                }
                EntryGrid orgEg = (EntryGrid)this.getControl(selectOrg_entityID);
                orgEg.clearEntryState();
                this.refreshBillList();
                this.getPageCache().remove("isImport");
                break;
            }
        }
    }

    private List<TreeNode> getAllTreeNodes(TreeNode root, List<TreeNode> treeNodes) {
        List children;
        if (root != null && (children = root.getChildren()) != null && !children.isEmpty()) {
            treeNodes.addAll(children);
            for (TreeNode child : children) {
                if (child.getChildren() == null || child.getChildren().isEmpty()) continue;
                this.getAllTreeNodes(child, treeNodes);
            }
        }
        return treeNodes;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "delete_comfirm": {
                if (MessageBoxResult.Yes != e.getResult()) break;
                BillList billlist = (BillList)this.getControl(BILL_LIST_AP);
                ListSelectedRowCollection listrows = billlist.getSelectedRows();
                String selectFields = "id,template,template.number,template.name,entity,memrangdecombo,definedpropertyvalue,definedpropertyvalue.id,definedpropertyvalue.number";
                Object[] rows = listrows.getPrimaryKeyValues();
                QFilter filter = new QFilter("id", "in", (Object)rows);
                DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_distributionentity", (String)selectFields, (QFilter[])new QFilter[]{filter});
                doc = this.findAllVersionNeedDelete(doc);
                ArrayList<Long> idlist = new ArrayList<Long>();
                HashMap<String, String> numberNameMap = new HashMap<String, String>(doc.size());
                HashSet<Long> removeTempidList = new HashSet<Long>();
                HashSet<Long> removeOrgidList = new HashSet<Long>();
                QFilter removeacct = null;
                List temids = new ArrayList();
                String oo = this.getPageCache().get(ORG_IDS);
                if (!StringUtils.isEmpty((CharSequence)oo)) {
                    temids = (List)SerializationUtils.fromJsonString((String)oo, List.class);
                }
                String orgmsg = "";
                for (DynamicObject d : doc) {
                    Long tid = d.getLong(TEMPLATE);
                    if (temids.contains(tid.toString())) {
                        if (!StringUtils.isEmpty((CharSequence)orgmsg)) continue;
                        orgmsg = String.format(ResManager.loadKDString((String)"\u5df2\u8df3\u8fc7%s\u5728\u9690\u85cf\u7ef4\u7684\u62a5\u8868\u6a21\u677f", (String)"DistributionPlugin_17", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), this.getEntityName().getString("name"));
                        continue;
                    }
                    Long oid = d.getLong(ENTITY);
                    Set oids = new HashSet();
                    if (0L == oid) {
                        if (d.getLong("definedpropertyvalue.id") != 0L && d.getString("definedpropertyvalue.number") != null) {
                            oids = QueryMemberDetailsHelper.getMemberIdsByDefinedRange((String)"bcm_entitymembertree", (Long)d.getLong("definedpropertyvalue.id"), (String)d.getString("definedpropertyvalue.number"), (int)d.getInt(MEM_RANGE_COMBO), (String)this.getPageCache().get("KEY_MODEL_ID"), (DetailTypeEnum)DetailTypeEnum.TEMPLATEDIS);
                        }
                    } else {
                        oids = QueryMemberDetailsHelper.queryMemberIdsByRange((String)"bcm_entitymembertree", (Long)oid, (int)d.getInt(MEM_RANGE_COMBO), (String)this.getPageCache().get("KEY_MODEL_ID"), (DetailTypeEnum)DetailTypeEnum.TEMPLATEDIS);
                    }
                    idlist.add(d.getLong("id"));
                    String templateName = d.getString("template.name");
                    String templateNumber = d.getString("template.number");
                    numberNameMap.put(templateNumber, templateName);
                    removeTempidList.add(tid);
                    removeOrgidList.add(oid);
                    if (removeacct == null) {
                        removeacct = new QFilter(TEMPLATE, "=", (Object)tid).and("org", "in", oids);
                        continue;
                    }
                    removeacct.or(new QFilter(TEMPLATE, "=", (Object)tid).and("org", "in", oids));
                }
                if (!idlist.isEmpty()) {
                    try (TXHandle tx = TX.required((String)"bcm_actionDelete");){
                        try {
                            BusinessDataServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_distributionentity"), (Object[])idlist.toArray());
                            Long[] removeTempArray = new Long[removeTempidList.size()];
                            MyTaskStatusHelper.refreshTaskStatusRecord4TempleteID((Long[])removeTempidList.toArray(removeTempArray));
                            this.deletePageSelcetRecord(removeOrgidList, removeTempidList);
                            this.backSendOpLog(numberNameMap, DistributionPlugin.getOperationStstusSuccess());
                        }
                        catch (KDBizException e1) {
                            this.backSendOpLog(numberNameMap, DistributionPlugin.getOperationStstusFail());
                            tx.markRollback();
                            throw e1;
                        }
                        catch (Throwable e1) {
                            this.backSendOpLog(numberNameMap, DistributionPlugin.getOperationStstusFail());
                            tx.markRollback();
                            throw e1;
                        }
                    }
                }
                AppCacheServiceHelper.removeTemplateDispenseCache((String)MemberReader.findModelNumberById((Object)this.getPageCache().get("KEY_MODEL_ID")));
                this.refreshBillList();
                if (StringUtils.isEmpty((CharSequence)orgmsg)) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5206\u914d\u5b8c\u6210\u3002", (String)"DistributionPlugin_19", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u53cd\u5206\u914d\u5b8c\u6210\uff0c%s\u3002", (String)"DistributionPlugin_18", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), orgmsg));
            }
        }
    }

    private void backSendOpLog(HashMap<String, String> numberNameMap, String status) {
        for (Map.Entry<String, String> numberName : numberNameMap.entrySet()) {
            this.writeOperationLog(DistributionPlugin.getOperationBackSend(), numberName.getKey(), numberName.getValue(), status);
        }
    }

    private DynamicObjectCollection findAllVersionNeedDelete(DynamicObjectCollection doc) {
        HashSet templateIds = Sets.newHashSet();
        ArrayListMultimap id2CommonInfo = ArrayListMultimap.create();
        doc.forEach(arg_0 -> DistributionPlugin.lambda$findAllVersionNeedDelete$10(templateIds, (Multimap)id2CommonInfo, arg_0));
        HashMap group2Id = Maps.newHashMap();
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.bcm.formplugin.template.DistributionPlugin.findAllVersionNeedDelete(DynamicObjectCollection)", (String)"bcm_templateentity", (String)"id, group", (QFilter[])new QFilter("id", "in", (Object)templateIds).toArray(), null);){
            queryDataSet.forEach(q -> {
                Long groupId = q.getLong(GROUP);
                Long id = q.getLong("id");
                group2Id.put(groupId, id);
            });
        }
        HashMap tpl2Origin = Maps.newHashMap();
        QFilter templateTypeFilter = new QFilter("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
        QFilter groupFilter = new QFilter(GROUP, "in", group2Id.keySet());
        try (DataSet templateDs = QueryServiceHelper.queryDataSet((String)"kd.fi.bcm.formplugin.template.DistributionPlugin.findAllVersionNeedDelete(DynamicObjectCollection)", (String)"bcm_templateentity", (String)"id, group", (QFilter[])new QFilter[]{templateTypeFilter, groupFilter}, null);){
            templateDs.forEach(ds -> {
                Long groupId = ds.getLong(GROUP);
                tpl2Origin.put(ds.getLong("id"), group2Id.get(groupId));
            });
        }
        DynamicObjectCollection distributeRecord = QueryServiceHelper.query((String)"bcm_distributionentity", (String)"id,template,template.number,template.name,entity,memrangdecombo,definedpropertyvalue,definedpropertyvalue.id,definedpropertyvalue.number", (QFilter[])new QFilter(TEMPLATE, "in", tpl2Origin.keySet()).toArray(), null);
        distributeRecord.forEach(arg_0 -> DistributionPlugin.lambda$findAllVersionNeedDelete$13((Multimap)id2CommonInfo, tpl2Origin, doc, arg_0));
        return doc;
    }

    private void deletePageSelcetRecord(Set<Long> idlist, Set<Long> removeTempidList) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(TEMPLATE, "in", removeTempidList);
        qfBuilder.add("org", "in", idlist);
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"bcm_pageselect", (String)"id", (QFilter[])qfBuilder.toArray());
        if (dys.length > 0) {
            Object[] ids = new Object[dys.length];
            for (int i = 0; i < dys.length; ++i) {
                ids[i] = dys[i].getLong("id");
            }
            BusinessDataServiceHelper.delete((IDataEntityType)dys[0].getDataEntityType(), (Object[])ids);
        }
    }

    private static /* synthetic */ void lambda$findAllVersionNeedDelete$13(Multimap id2CommonInfo, Map tpl2Origin, DynamicObjectCollection doc, DynamicObject d) {
        Long templateId = d.getLong(TEMPLATE);
        StringBuilder sBuild = new StringBuilder();
        sBuild.append(d.getLong(ENTITY));
        sBuild.append(d.getLong(MEM_RANGE_COMBO));
        sBuild.append(d.getLong(DEFINED_PROPERTY_VALUE));
        if (id2CommonInfo.get(tpl2Origin.get(templateId)).contains(sBuild.toString())) {
            doc.add((Object)d);
        }
    }

    private static /* synthetic */ void lambda$findAllVersionNeedDelete$10(Set templateIds, Multimap id2CommonInfo, DynamicObject d) {
        long templateId = d.getLong(TEMPLATE);
        templateIds.add(templateId);
        StringBuilder sBuild = new StringBuilder();
        sBuild.append(d.getLong(ENTITY));
        sBuild.append(d.getLong(MEM_RANGE_COMBO));
        sBuild.append(d.getLong(DEFINED_PROPERTY_VALUE));
        id2CommonInfo.put((Object)templateId, (Object)sBuild.toString());
    }

    private static /* synthetic */ void lambda$copyVersionDistribute$6(Multimap id2Dyn, List dlist, Table.Cell v) {
        if ((Long)v.getValue() - (Long)v.getRowKey() == 0L) {
            return;
        }
        Collection collection = id2Dyn.get(v.getValue());
        collection.forEach(c -> {
            DynamicObject distribute = BusinessDataServiceHelper.newDynamicObject((String)"bcm_distributionentity");
            distribute.set(ENTITY, c.get(ENTITY));
            distribute.set(DEFINED_PROPERTY, c.get(DEFINED_PROPERTY));
            distribute.set(DEFINED_PROPERTY_VALUE, c.get(DEFINED_PROPERTY_VALUE));
            distribute.set(MEM_RANGE_COMBO, c.get(MEM_RANGE_COMBO));
            distribute.set(EFFECTWAY, c.get(EFFECTWAY));
            distribute.set(TEMPLATE, v.getRowKey());
            distribute.set(MODEL, c.get(MODEL));
            distribute.set(TEXT_NAME, c.get(TEXT_NAME));
            dlist.add(distribute);
        });
    }

    private static /* synthetic */ void lambda$copyVersionDistribute$4(Table tpl2group2tpl, Map tpl2Group, Row ds) {
        Long groupId = ds.getLong(GROUP);
        tpl2group2tpl.put((Object)ds.getLong("id"), (Object)groupId, tpl2Group.get(groupId));
    }

    private static /* synthetic */ void lambda$copyVersionDistribute$2(Set templateIds, Multimap id2Dyn, DynamicObject d) {
        templateIds.add(d.getLong(TEMPLATE));
        id2Dyn.put((Object)d.getLong(TEMPLATE), (Object)d);
    }
}

