/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.TemplateRangeService;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.datatypeutil.DataTypeConvertUtil;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.template.SearchResult;
import kd.fi.bcm.formplugin.util.ReportListUtil;
import org.apache.commons.collections4.CollectionUtils;

public class DistributionPluginStage
extends AbstractBaseFormPlugin {
    public static final String TEMCATALOGTREE = "temcatalogtree";
    private static final String BILL_LIST_AP = "billlistap";
    private static final String STAGE_BILL = "billlistap1";
    private static final String ROOT_NODE = "rootNode";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String MODEL = "model";
    private static final String TEMPLATE = "template";

    private static OpNameMultiLangEnumBridge getOperationSend() {
        return new OpNameMultiLangEnumBridge("\u5206\u914d", "DistributionPlugin_0", FI_BCM_FORMPLUGIN, "Allocate");
    }

    private static OpNameMultiLangEnumBridge getOperationBackSend() {
        return new OpNameMultiLangEnumBridge("\u53cd\u5206\u914d", "DistributionPlugin_20", FI_BCM_FORMPLUGIN, "Anti allocate");
    }

    private static String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"DistributionPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private static final String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"DistributionPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
        HashMap<String, SingleF7TypeEnum> map = new HashMap<String, SingleF7TypeEnum>(16);
        map.put("scenario", SingleF7TypeEnum.LEAF);
        this.initSingleMemberF7(map);
        this.addListeners();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    private void addListeners() {
        this.addClickListeners("deletedistribution", "imageup", "imagedown");
        this.addItemClickListeners("toolbarap");
        TreeView tree = (TreeView)this.getControl(TEMCATALOGTREE);
        tree.addTreeNodeCheckListener(this::templateTreeNodeCheck);
        final BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.addSetFilterListener(this::setFilter);
        BillList stageBill = (BillList)this.getView().getControl(STAGE_BILL);
        stageBill.addSetFilterListener(this::setFilter4Stage);
        stageBill.setOrderBy("stage");
        stageBill.addListRowClickListener(new ListRowClickListener(){

            public void listRowClick(ListRowClickEvent evt) {
                billList.refresh();
                billList.clearSelection();
            }
        });
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent var) {
                String text = var.getText();
                if (StringUtils.isNotEmpty((CharSequence)text)) {
                    DistributionPluginStage.this.searchTemplate(text.trim());
                } else {
                    DistributionPluginStage.this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                }
            }
        });
    }

    public void setFilter4Stage(SetFilterEvent evt) {
        List filters = evt.getQFilters();
        filters.clear();
        QFilter qFilter = this.getFilter4Stage();
        filters.add(qFilter);
    }

    private QFilter getFilter4Stage() {
        QFilter qFilter = new QFilter(MODEL, "=", (Object)this.getModelId());
        long scenarioId = this.getSceneId();
        qFilter.and("scenario", "=", (Object)scenarioId);
        return qFilter;
    }

    private void searchTemplate(String search) {
        TreeView tree = (TreeView)this.getControl(TEMCATALOGTREE);
        String rootNodeCache = this.getPageCache().get(ROOT_NODE);
        if (rootNodeCache != null) {
            TreeNode root = (TreeNode)ObjectSerialUtil.deSerializedBytes((String)rootNodeCache);
            ArrayList<TreeNode> hitNode = new ArrayList<TreeNode>(16);
            root.getTreeNodeListByText(hitNode, search, 999);
            SearchResult result = null;
            if (!hitNode.isEmpty()) {
                result = new SearchResult(hitNode);
                TreeNode next = result.next(1);
                tree.checkNode(next);
                tree.focusNode(next);
                this.refreshBillList();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5173\u8282\u70b9\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u540d\u79f0\u540e\u641c\u7d22\u3002", (String)"DistributionPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            this.getPageCache().put("cache_search", result == null ? null : ObjectSerialUtil.toByteSerialized((Object)result));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        long sceneId = this.getSceneId();
        this.getView().getPageCache().remove("selecttemplates");
        this.setTempalteDate2View(this.getModelId(), false, sceneId);
        this.refreshBillList();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object sceneCus = this.getView().getFormShowParameter().getCustomParam("scenario");
        if (sceneCus != null) {
            this.getView().getModel().setValue("scenario", sceneCus);
        }
        long modelid = this.getModelId();
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelid));
        long sceneId = this.getSceneId();
        if (modelid != 0L && sceneId != 0L) {
            this.setTempalteDate2View(modelid, true, sceneId);
            FilterParameter fp4bill = new FilterParameter();
            TreeView tree = (TreeView)this.getControl(TEMCATALOGTREE);
            List selectTemplates = tree.getTreeState().getCheckedNodeIds();
            if (CollectionUtils.isNotEmpty((Collection)selectTemplates)) {
                List<Long> selectTemplateRows = this.getSelectTemplateIds();
                if (CollectionUtils.isNotEmpty(selectTemplateRows)) {
                    this.getView().getPageCache().put("selecttemplates", this.toByteSerialized(selectTemplateRows));
                    QFilter qFilter = this.getTemplateFilter(sceneId, selectTemplateRows);
                    fp4bill.setFilter(qFilter);
                }
            } else {
                fp4bill.setFilter(new QFilter("1", "!=", (Object)1));
            }
            BillList billList = (BillList)this.getControl(BILL_LIST_AP);
            billList.setFilterParameter(fp4bill);
            BillList stageBill = (BillList)this.getControl(STAGE_BILL);
            FilterParameter fp4Stage = new FilterParameter();
            fp4Stage.setFilter(this.getFilter4Stage());
            stageBill.setFilterParameter(fp4Stage);
        } else {
            BillList billList = (BillList)this.getControl(BILL_LIST_AP);
            BillList stageBill = (BillList)this.getControl(STAGE_BILL);
            FilterParameter fp = new FilterParameter();
            fp.setFilter(new QFilter("1", "!=", (Object)1));
            billList.setFilterParameter(fp);
            stageBill.setFilterParameter(fp);
        }
    }

    private QFilter getTemplateFilter(long sceneId, List<Long> selectTemplateRows) {
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_templateentity", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", selectTemplateRows)});
        List templateNums = templates.stream().map(t -> t.getString("number")).collect(Collectors.toList());
        QFilter qFilter = new QFilter(MODEL, "=", (Object)this.getModelId());
        qFilter.and("templateNum", "in", templateNums);
        qFilter.and("stage.scenario", "=", (Object)sceneId);
        return qFilter;
    }

    private void setTempalteDate2View(long modelid, boolean needCheckNode, long sceneId) {
        try {
            DynamicObjectCollection templates = this.getTemplateColls(modelid, sceneId);
            TreeNode rootview = ReportListUtil.getTemplateTree(this.genCatalogMaps4tree(), templates, new ArrayList<TreeNode>(), "0", new TreeNode());
            this.getPageCache().put(ROOT_NODE, ObjectSerialUtil.toByteSerialized((Object)rootview));
            TreeView tree = (TreeView)this.getControl(TEMCATALOGTREE);
            tree.deleteAllNodes();
            tree.release();
            BCMTreeUtils.spreadAllNode((TreeNode)rootview);
            tree.addNode(rootview);
            if (needCheckNode) {
                ArrayList<TreeNode> selectNodes = new ArrayList<TreeNode>(16);
                List rows = (List)this.getView().getFormShowParameter().getCustomParam("rows");
                if (CollectionUtils.isNotEmpty((Collection)rows)) {
                    for (DynamicObject template : templates) {
                        if (!rows.contains(template.getString("number"))) continue;
                        TreeNode node = rootview.getTreeNode(template.getString("id"), 20);
                        selectNodes.add(node);
                    }
                }
                if (!selectNodes.isEmpty()) {
                    tree.checkNodes(selectNodes);
                }
            }
            this.getView().updateView(TEMCATALOGTREE);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getView().showErrorNotification(DistributionPluginStage.getOperationStstusFail());
        }
    }

    private DynamicObjectCollection getTemplateColls(long modelid, long sceneId) {
        DynamicObjectCollection result = new DynamicObjectCollection();
        if (modelid == 0L || sceneId == 0L) {
            return result;
        }
        QFilter filter = new QFilter(MODEL, "=", (Object)modelid);
        filter.and("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
        String selectFields = "id,name,templatecatalog,number,group";
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_templateentity", (String)selectFields, (QFilter[])filter.toArray(), (String)"sequence,number asc,versionnumber asc");
        QFilter filterStage = new QFilter(MODEL, "=", (Object)modelid);
        filterStage.and("stage.scenario", "=", (Object)sceneId);
        DynamicObjectCollection stages = QueryServiceHelper.query((String)"bcm_distributionstage", (String)"templatenum", (QFilter[])filterStage.toArray());
        Set stageTemplateNums = stages.stream().map(e -> e.getString("templatenum")).collect(Collectors.toSet());
        DynamicObjectCollection collect = templates.stream().filter(t -> stageTemplateNums.contains(t.getString("number")) || TemplateRangeService.isInnerRange((String)"bcm_scenemembertree", (TemplateModel)TemplateUtil.getTemplateModel((Object)t.getLong("id")), (Object)sceneId)).collect(Collectors.toCollection(DynamicObjectCollection::new));
        HashSet groupIds = Sets.newHashSet();
        collect.forEach(c -> {
            Long groupId = c.getLong("group");
            if (groupIds.add(groupId)) {
                result.add(c);
            }
        });
        return result;
    }

    private List<Map<String, String>> genCatalogMaps4tree() {
        DynamicObjectCollection catalogs = this.getTemplatecatalogList();
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(16);
        for (DynamicObject catalog : catalogs) {
            if ("0".equals(catalog.getString("parent")) && (catalog.getString("longnumber") == null || catalog.getString("longnumber") == "")) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", catalog.getString("id"));
            map.put("name", catalog.getString("name"));
            map.put("parentid", catalog.getString("parent"));
            result.add(map);
        }
        return result;
    }

    private DynamicObjectCollection getTemplatecatalogList() {
        QFilter filter = new QFilter(MODEL, "=", (Object)this.getModelId());
        QFilter[] filters = new QFilter[]{filter, TemplateCatalogTypeEnum.getTemplateCalcogFilter()};
        String selectFields = "id,parent,name,longnumber,number";
        String orderBys = "longnumber";
        return QueryServiceHelper.query((String)"bcm_templatecatalog", (String)selectFields, (QFilter[])filters, (String)orderBys);
    }

    public void templateTreeNodeCheck(TreeNodeCheckEvent evt) {
        this.getView().getPageCache().remove("selecttemplates");
        BillList billlist = (BillList)this.getControl(BILL_LIST_AP);
        billlist.refresh();
        billlist.clearSelection();
    }

    private void refreshBillList() {
        BillList billlist = (BillList)this.getControl(BILL_LIST_AP);
        BillList stageBill = (BillList)this.getControl(STAGE_BILL);
        stageBill.refresh();
        stageBill.clearSelection();
        billlist.refresh();
        billlist.clearSelection();
    }

    private long getSceneId() {
        Object scenario = this.getValue("scenario");
        long scenarioId = 0L;
        if (scenario instanceof DynamicObject) {
            scenarioId = ((DynamicObject)scenario).getLong("id");
        }
        return scenarioId;
    }

    public void setFilter(SetFilterEvent evt) {
        List filters = evt.getQFilters();
        filters.clear();
        TreeView tree = (TreeView)this.getControl(TEMCATALOGTREE);
        List selectTemplates = tree.getTreeState().getCheckedNodeIds();
        BillList stageBill = (BillList)this.getControl(STAGE_BILL);
        ListSelectedRowCollection selectedStageRows = stageBill.getSelectedRows();
        String selecttemplates = this.getPageCache().get("selecttemplates");
        if (CollectionUtils.isNotEmpty((Collection)selectedStageRows) || CollectionUtils.isNotEmpty((Collection)selectTemplates) || StringUtils.isNotEmpty((CharSequence)selecttemplates)) {
            QFilter qFilter;
            long sceneId = this.getSceneId();
            List selectTemplateRows = this.getSelectTemplateIds();
            if (CollectionUtils.isEmpty(selectTemplateRows) && StringUtils.isNotEmpty((CharSequence)selecttemplates)) {
                selectTemplateRows = (List)this.deSerializedBytes(selecttemplates);
            }
            if (CollectionUtils.isNotEmpty(selectTemplateRows)) {
                qFilter = this.getTemplateFilter(sceneId, selectTemplateRows);
                filters.add(qFilter);
            }
            if (CollectionUtils.isNotEmpty((Collection)selectedStageRows)) {
                qFilter = new QFilter("stage", "=", selectedStageRows.get(0).getPrimaryKeyValue());
                filters.add(qFilter);
            }
            if (CollectionUtils.isEmpty((Collection)selectedStageRows) && CollectionUtils.isEmpty((Collection)selectTemplateRows)) {
                qFilter = new QFilter("1", "!=", (Object)1);
                filters.add(qFilter);
            }
        } else {
            QFilter qFilter = new QFilter("1", "!=", (Object)1);
            filters.add(qFilter);
        }
    }

    private List<Long> getSelectTemplateIds() {
        TreeView tree = (TreeView)this.getControl(TEMCATALOGTREE);
        List selectIds = tree.getTreeState().getCheckedNodeIds();
        if (CollectionUtils.isNotEmpty((Collection)selectIds)) {
            DynamicObjectCollection catalogs = this.getTemplatecatalogList();
            ArrayList<String> catalogIds = new ArrayList<String>(16);
            for (DynamicObject catalog : catalogs) {
                catalogIds.add(catalog.getString("id"));
            }
            selectIds.removeAll(catalogIds);
        }
        ArrayList<Long> result = new ArrayList<Long>(16);
        if (CollectionUtils.isNotEmpty((Collection)selectIds)) {
            result.addAll(DataTypeConvertUtil.convert((List)selectIds));
        }
        return result;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_distribute": {
                this.distributeMember();
                break;
            }
        }
    }

    private void distributeMember() {
        List<Long> templateIds = this.getSelectTemplateIds();
        BillList stageBill = (BillList)this.getControl(STAGE_BILL);
        ListSelectedRowCollection selectedStageRows = stageBill.getSelectedRows();
        if (templateIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u6a21\u677f\u3002", (String)"DistributionPlugin_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (CollectionUtils.isEmpty((Collection)selectedStageRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u9636\u6bb5\u3002", (String)"DistributionPlugin_29", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        long modelId = this.getModelId();
        QFilter qcf = new QFilter("id", "in", templateIds);
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_templateentity", (String)"name,number,id", (QFilter[])new QFilter[]{qcf});
        try (TXHandle tx = TX.required();){
            try {
                QFilter stageFilter;
                DynamicObject strageDy;
                Object stageId = selectedStageRows.get(0).getPrimaryKeyValue();
                List templateNums = templates.stream().map(t -> t.getString("number")).collect(Collectors.toList());
                QFilter qFilter = new QFilter(MODEL, "=", (Object)modelId);
                qFilter.and("templatenum", "in", templateNums);
                qFilter.and("stage.scenario", "=", (Object)this.getSceneId());
                BusinessDataWriter.delete((String)"bcm_distributionstage", (QFilter[])qFilter.toArray());
                ArrayList<DynamicObject> saveDatas = new ArrayList<DynamicObject>(16);
                for (DynamicObject template : templates) {
                    DynamicObject distribute = BusinessDataServiceHelper.newDynamicObject((String)"bcm_distributionstage");
                    distribute.set(MODEL, (Object)modelId);
                    distribute.set(TEMPLATE, (Object)template.getLong("id"));
                    distribute.set("stage", stageId);
                    distribute.set("templatenum", (Object)template.getString("number"));
                    distribute.set("modifier", (Object)this.getUserId());
                    distribute.set("modifytime", (Object)TimeServiceHelper.now());
                    distribute.set("creator", (Object)this.getUserId());
                    distribute.set("createtime", (Object)TimeServiceHelper.now());
                    saveDatas.add(distribute);
                }
                if (!saveDatas.isEmpty()) {
                    BusinessDataWriter.save((IDataEntityType)((DynamicObject)saveDatas.get(0)).getDataEntityType(), (Object[])saveDatas.toArray());
                }
                String strageName = (strageDy = QueryServiceHelper.queryOne((String)"bcm_datalockscene", (String)"stage,name", (QFilter[])(stageFilter = new QFilter("id", "=", stageId)).toArray())) != null ? strageDy.getString("name") : "";
                for (int i = 0; i < templates.size(); ++i) {
                    this.writeOperationLog(DistributionPluginStage.getOperationSend(), ((DynamicObject)templates.get(i)).getString("number"), strageName, DistributionPluginStage.getOperationStstusSuccess());
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"DistributionPlugin_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                BillList billlist = (BillList)this.getControl(BILL_LIST_AP);
                billlist.refresh();
                billlist.clearSelection();
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                tx.markRollback();
            }
        }
    }

    private long getStageSelectIds() {
        BillList stageBill = (BillList)this.getControl(STAGE_BILL);
        ListSelectedRowCollection selectedRows = stageBill.getSelectedRows();
        long selectId = 0L;
        if (CollectionUtils.isNotEmpty((Collection)selectedRows)) {
            selectId = (Long)selectedRows.get(0).getPrimaryKeyValue();
        }
        return selectId;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "deletedistribution": {
                this.checkPerm("btn_distribute", "bcm_template_stage");
                this.deleteDistribution();
                break;
            }
            case "imageup": {
                this.searchNext(-1);
                break;
            }
            case "imagedown": {
                this.searchNext(1);
                break;
            }
        }
    }

    private void searchNext(int i) {
        IPageCache pageCache = this.getPageCache();
        String searchResultCache = pageCache.get("cache_search");
        if (searchResultCache != null) {
            SearchResult result = (SearchResult)ObjectSerialUtil.deSerializedBytes((String)searchResultCache);
            TreeNode next = result.next(i);
            TreeView tree = (TreeView)this.getControl(TEMCATALOGTREE);
            if (next == null) {
                if (i > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"DistributionPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"DistributionPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                }
            } else {
                tree.checkNode(next);
                tree.treeNodeClick(next.getParentid(), next.getId());
                pageCache.put("cache_search", ObjectSerialUtil.toByteSerialized((Object)result));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"DistributionPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private void deleteDistribution() {
        BillList billlist = (BillList)this.getControl(BILL_LIST_AP);
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u53cd\u5206\u914d\u8bb0\u5f55\u7684\u6570\u636e\u884c\u3002", (String)"DistributionPlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u53cd\u5206\u914d\u3002", (String)"DistributionPlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_comfirm", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "delete_comfirm": {
                if (MessageBoxResult.Yes != messageBoxClosedEvent.getResult()) break;
                BillList billlistap = (BillList)this.getControl(BILL_LIST_AP);
                ListSelectedRowCollection selectedStageRows = billlistap.getSelectedRows();
                if (CollectionUtils.isNotEmpty((Collection)selectedStageRows)) {
                    List selectIds = selectedStageRows.stream().map(r -> r.getPrimaryKeyValue()).collect(Collectors.toList());
                    QFilter qFilter = new QFilter("id", "in", selectIds);
                    DynamicObjectCollection selectStageTemplate = QueryServiceHelper.query((String)"bcm_distributionstage", (String)"templatenum, stage.name", (QFilter[])qFilter.toArray());
                    BusinessDataWriter.delete((String)"bcm_distributionstage", (QFilter[])qFilter.toArray());
                    for (int i = 0; i < selectStageTemplate.size(); ++i) {
                        this.writeOperationLog(DistributionPluginStage.getOperationBackSend(), ((DynamicObject)selectStageTemplate.get(i)).getString("templateNum"), ((DynamicObject)selectStageTemplate.get(i)).getString("stage.name"), DistributionPluginStage.getOperationStstusSuccess());
                    }
                }
                BillList billlist = (BillList)this.getControl(BILL_LIST_AP);
                billlist.refresh();
                billlist.clearSelection();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5206\u914d\u5b8c\u6210\u3002", (String)"DistributionPlugin_19", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
    }
}

