/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.SaveDimMemberHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryTreenodeHelper;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.common.LogConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.localcache.SyncCacheUtil;
import kd.fi.bcm.common.datatypeutil.DataTypeConvertUtil;
import kd.fi.bcm.common.enums.AggOprtEnum;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.log.DimMemberOperateTypeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.SpreadAreaUtil;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.formplugin.util.CodeRuleUtil;
import kd.fi.bcm.spread.domain.view.MultiAreaPositionsManager;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimension;

public class FloatMaintainPlugin
extends AbstractTemplateBasePlugin
implements RowClickEventListener {
    protected static final String ENTRY_ENTITY = "entryentity";
    private static String modelcache = "modelcache";
    protected static String entityname = "entitynamecache";
    private static String dimensionname = "dimensionname";
    protected static String dimensionnumber = "dimensionnumber";
    protected static String dimenmemberid = "dimenmemberid";
    protected static String dimenmembernumber = "dimenmembernumber";
    protected static String numbercache = "number";
    protected static String spreadCache = "spread";
    private static String selectrow = "selectrow";
    private static String isparent = "isparent";
    private static final String FLOAT_AREA = "floatarea";
    private static String beginsize = "beginsize";
    private static String notfloatnumber = "notfloatnumber";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String DIMENSION = "dimension";
    private static final String MEMBER = "member";
    private static final String MODEL = "model";
    private static final String LONG_NUMBER = "longnumber";
    private static final String LEVEL = "level";
    private static final String PARENT = "parent";
    private static final String IS_LEAF = "isleaf";
    private static final String SAVED = "saved";
    private static final String STORAGE_TYPE = "storagetype";
    private static final String IS_SYS_MEMBER = "issysmember";
    private static final String CREATOR_FIELD = "createrfield";
    private static final String CREATOR = "creator";
    private static final String CREATE_TIME = "createtime";
    private static final String MODIFIER = "modifier";
    private static final String MODIFY_TIME = "modifytime";
    private static final String TEXT_FIELD = "textfield";
    private static final String SELECT_AREA = "selectarea";
    private static final String SAVE_CONFIRM = "save_comfirm";
    private static final String CREATE_DATE_FIELD = "createdatefield";
    private static final String IS_CHANGE = "ischange";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_cancel", "btn_save");
        this.addItemClickListeners("toolbar");
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        int[] selected = ((EntryGrid)evt.getSource()).getSelectRows();
        this.getPageCache().put(selectrow, ObjectSerialUtil.toByteSerialized((Object)selected));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.cacheParam();
        this.initCombox();
        this.refreshEntity();
    }

    private void cacheParam() {
        String defaultModelId = this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID").toString();
        String spread = (String)this.getView().getFormShowParameter().getCustomParam("KEY_SPREAD_MODEL");
        String area = (String)this.getView().getFormShowParameter().getCustomParam(SELECT_AREA);
        this.getPageCache().put(modelcache, defaultModelId);
        this.getPageCache().put(spreadCache, spread);
        this.getPageCache().put(numbercache, "1");
        this.getPageCache().put(beginsize, "0");
        this.getPageCache().put(SELECT_AREA, area);
    }

    private void initCombox() {
        ArrayList<String> arealist;
        ComboEdit areaedit = (ComboEdit)this.getControl(FLOAT_AREA);
        ComboEdit dimenedit = (ComboEdit)this.getControl(DIMENSION);
        Map<String, List<FloatInfo>> map = this.analyseSpeadInfo();
        ArrayList<ComboItem> areas = new ArrayList<ComboItem>(10);
        String defaultArea = this.getArea(map);
        if (defaultArea == null && !(arealist = new ArrayList<String>(map.keySet())).isEmpty()) {
            Collections.sort(arealist);
            defaultArea = (String)arealist.get(0);
        }
        int location = 0;
        int i = 0;
        for (String area : map.keySet()) {
            areas.add(new ComboItem(new LocaleString(area), area));
            if (area.equals(defaultArea)) {
                location = i;
            }
            ++i;
        }
        areaedit.setComboItems(areas);
        if (!areas.isEmpty()) {
            List<FloatInfo> infos = map.get(((ComboItem)areas.get(location)).getValue());
            ArrayList<ComboItem> dimens = new ArrayList<ComboItem>(infos.size());
            for (FloatInfo info : infos) {
                String dimenname = info.getDimension().getName();
                String dimNum = info.getDimension().getNumber();
                ComboItem dimen = new ComboItem(new LocaleString(dimenname), dimNum);
                dimens.add(dimen);
            }
            dimenedit.setComboItems(dimens);
            FloatInfo deFloatInfo = infos.get(0);
            String membername = deFloatInfo.getMember().getName();
            String position = deFloatInfo.getPosition() == 1 ? ResManager.loadKDString((String)"\u76f4\u63a5\u4e0b\u7ea7", (String)"FloatMaintainPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e73\u7ea7", (String)"FloatMaintainPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            this.getModel().getDataEntity().set(FLOAT_AREA, (Object)((ComboItem)areas.get(location)).getValue());
            this.getModel().getDataEntity().set(DIMENSION, (Object)((ComboItem)dimens.get(0)).getValue());
            this.getModel().setValue(TEXT_FIELD, (Object)String.format(ResManager.loadKDString((String)"\u65b0\u589e\u6210\u5458\u4f5c\u4e3a\u201c%1$s\u201d\u7684%2$s\u3002", (String)"FloatMaintainPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), membername, position));
            this.getPageCache().put(FLOAT_AREA, ((ComboItem)areas.get(0)).getValue());
            this.writeToCache(deFloatInfo);
        }
    }

    private String getArea(Map<String, List<FloatInfo>> map) {
        String select = this.getPageCache().get(SELECT_AREA);
        for (String area : map.keySet()) {
            ArrayList<String> temp = new ArrayList<String>();
            temp.add(area);
            if (!SpreadAreaUtil.Area_Contains((String)select, temp)) continue;
            return area;
        }
        return null;
    }

    private boolean checkSaved() {
        IDataModel model = this.getModel();
        DynamicObjectCollection rateColl = model.getEntryEntity(ENTRY_ENTITY);
        int size = Integer.parseInt(this.getPageCache().get(beginsize));
        boolean allsaved = true;
        if (rateColl.size() != size) {
            allsaved = false;
        }
        if (!rateColl.isEmpty() && rateColl.size() == size) {
            for (DynamicObject row : rateColl) {
                if (!row.get(SAVED).equals("false")) continue;
                allsaved = false;
                break;
            }
        }
        return allsaved;
    }

    protected void refreshEntity() {
        this.getPageCache().put(IS_CHANGE, "true");
        IDataModel model = this.getModel();
        model.getDataEntity(true);
        model.deleteEntryData(ENTRY_ENTITY);
        String selectid = this.getPageCache().get(dimenmemberid);
        String dimennumber = this.getPageCache().get(dimenmembernumber);
        long parentid = this.getParent(selectid);
        QFilter qf = new QFilter(PARENT, "=", (Object)parentid);
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"", (String)this.getPageCache().get(entityname), (String)"id,number,name,issysmember,creator,modifier,createtime,modifytime", (QFilter[])new QFilter[]{qf}, null);
        int temp = 1;
        int rowsize = 0;
        for (DynamicObject dot : dcs) {
            if (dot.getInt(IS_SYS_MEMBER) != 5) continue;
            ++rowsize;
        }
        if (!dcs.isEmpty()) {
            if (rowsize > 0) {
                this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, rowsize);
            }
            int i = 0;
            for (DynamicObject dot : dcs) {
                String number = dot.getString("number");
                if (dot.getInt(IS_SYS_MEMBER) == 5) {
                    model.setValue("number", (Object)number, i);
                    model.setValue("name", (Object)dot.getString("name"), i);
                    model.setValue(CREATOR_FIELD, dot.get(CREATOR), i);
                    model.setValue("modifierfield", dot.get(MODIFIER), i);
                    model.setValue(CREATE_DATE_FIELD, dot.get(CREATE_TIME), i);
                    model.setValue("modifydatefield", dot.get(MODIFY_TIME), i);
                    model.setValue("id", dot.get("id"), i);
                    model.setValue(SAVED, (Object)true, i);
                    this.getView().setEnable(Boolean.valueOf(false), i++, new String[]{"name"});
                }
                if (!number.startsWith(dimennumber)) continue;
                number = number.substring(dimennumber.length());
                String reg = "[0-9]{6}";
                Pattern p = Pattern.compile(reg);
                Matcher m = p.matcher(number);
                if (!m.matches()) continue;
                int x = Integer.parseInt(number) + 1;
                temp = x > temp ? x : temp;
            }
        }
        this.getPageCache().put(notfloatnumber, String.valueOf(dcs.size() - rowsize));
        this.getPageCache().put(numbercache, String.valueOf(temp));
        this.getPageCache().put(beginsize, String.valueOf(rowsize));
        this.getPageCache().remove(IS_CHANGE);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (this.getPageCache().get(IS_CHANGE) != null) {
            return;
        }
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String name = e.getProperty().getName();
        if (name.equals(FLOAT_AREA) || name.equals(DIMENSION)) {
            Map<String, List<FloatInfo>> map = this.analyseSpeadInfo();
            String area = (String)model.getValue(FLOAT_AREA);
            List<FloatInfo> infos = map.get(area);
            if (name.equals(FLOAT_AREA)) {
                if (!this.checkSaved()) {
                    view.showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u4fdd\u5b58\u7684\u64cd\u4f5c\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"FloatMaintainPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("change_areacomfirm", (IFormPlugin)this));
                } else {
                    this.refreshAreaInfo(area, infos);
                }
            }
            if (name.equals(DIMENSION)) {
                String dimen = (String)model.getValue(DIMENSION);
                if (!this.checkSaved()) {
                    view.showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u4fdd\u5b58\u7684\u64cd\u4f5c\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"FloatMaintainPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("change_dimencomfirm", (IFormPlugin)this));
                } else {
                    this.refreshDimenInfo(infos, dimen);
                }
            }
        }
    }

    private void refreshAreaInfo(String area, List<FloatInfo> infos) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        ArrayList<ComboItem> dimens = new ArrayList<ComboItem>(infos.size());
        for (FloatInfo info : infos) {
            String dimenname = info.getDimension().getName();
            ComboItem dimenitem = new ComboItem(new LocaleString(dimenname), dimenname);
            dimens.add(dimenitem);
        }
        ComboEdit dimenedit = (ComboEdit)this.getControl(DIMENSION);
        dimenedit.setComboItems(dimens);
        FloatInfo deFloatInfo = infos.get(0);
        String membername = deFloatInfo.getMember().getName();
        String position = deFloatInfo.getPosition() == 1 ? ResManager.loadKDString((String)"\u76f4\u63a5\u4e0b\u7ea7", (String)"FloatMaintainPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e73\u7ea7", (String)"FloatMaintainPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
        model.getDataEntity().set(DIMENSION, (Object)((ComboItem)dimens.get(0)).getValue());
        model.setValue(TEXT_FIELD, (Object)String.format(ResManager.loadKDString((String)"\u65b0\u589e\u6210\u5458\u4f5c\u4e3a\u201c%1$s\u201d\u7684%2$s\u3002", (String)"FloatMaintainPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), membername, position));
        view.updateView(DIMENSION);
        this.getPageCache().put(numbercache, "1");
        this.getPageCache().put(FLOAT_AREA, area);
        this.writeToCache(deFloatInfo);
        this.refreshEntity();
    }

    protected void refreshDimenInfo(List<FloatInfo> infos, String dimen) {
        IDataModel model = this.getModel();
        for (FloatInfo info : infos) {
            String dimenname = info.getDimension().getNumber();
            if (!dimen.equals(dimenname)) continue;
            String membername = info.getMember().getName();
            String position = info.getPosition() == 1 ? ResManager.loadKDString((String)"\u76f4\u63a5\u4e0b\u7ea7", (String)"FloatMaintainPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e73\u7ea7", (String)"FloatMaintainPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            model.setValue(TEXT_FIELD, (Object)String.format(ResManager.loadKDString((String)"\u65b0\u589e\u6210\u5458\u4f5c\u4e3a\u201c%1$s\u201d\u7684%2$s\u3002", (String)"FloatMaintainPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), membername, position));
            this.writeToCache(info);
        }
        this.refreshEntity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        var3_3 = key = evt.getItemKey();
        var4_4 = -1;
        switch (var3_3.hashCode()) {
            case -1422495335: {
                if (!var3_3.equals("addrow")) break;
                var4_4 = 0;
                break;
            }
            case -2050735099: {
                if (!var3_3.equals("similaritycheck")) break;
                var4_4 = 1;
                break;
            }
            case -358690737: {
                if (!var3_3.equals("deleterow")) break;
                var4_4 = 2;
            }
        }
        switch (var4_4) {
            case 0: {
                row = this.getModel().createNewEntryRow("entryentity");
                temp = Integer.parseInt(this.getPageCache().get(FloatMaintainPlugin.numbercache));
                dimennumber = this.getPageCache().get(FloatMaintainPlugin.dimenmembernumber);
                uid = RequestContext.getOrCreate().getUserId();
                now = TimeServiceHelper.now();
                this.getView().setEnable(Boolean.valueOf(true), row, new String[]{"name"});
                lock = DLock.create((String)("fi/bcm/" + this.getPageCache().get(FloatMaintainPlugin.dimenmemberid)));
                var11_12 = null;
                try {
                    lock.lock();
                    number = this.createNumber();
                    this.getModel().setValue("number", (Object)number, row);
                    this.getModel().setValue("createrfield", (Object)uid, row);
                    this.getModel().setValue("createdatefield", (Object)now, row);
                    lock.unlock();
                }
                finally {
                    lock.unlock();
                }
                if (lock == null) break;
                if (var11_12 == null) ** GOTO lbl46
                try {
                    lock.close();
                }
                catch (Throwable number) {
                    var11_12.addSuppressed(number);
                }
                break;
lbl46:
                // 1 sources

                lock.close();
                break;
                catch (Throwable number) {
                    try {
                        var11_12 = number;
                        throw number;
                    }
                    catch (Throwable var14_20) {
                        if (lock != null) {
                            if (var11_12 != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable var15_22) {
                                    var11_12.addSuppressed(var15_22);
                                }
                            } else {
                                lock.close();
                            }
                        }
                        throw var14_20;
                    }
                }
            }
            case 1: {
                break;
            }
            case 2: {
                select = this.getPageCache().get(FloatMaintainPlugin.selectrow);
                if (StringUtils.isEmpty((CharSequence)select)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u884c\u3002", (String)"FloatMaintainPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                selected = (int[])ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(FloatMaintainPlugin.selectrow));
                if (selected.length <= 0 || selected[0] == -1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u884c\u3002", (String)"FloatMaintainPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                entityNum = (String)this.getModel().getValue("dimension");
                memberNums = new ArrayList<String>(16);
                for (int i : selected) {
                    doc = this.getModel().getEntryEntity("entryentity");
                    if (doc.size() - 1 < i) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f13\u5b58\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"FloatMaintainPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    entryentity = (DynamicObject)doc.get(i);
                    number = entryentity.getString("number");
                    memberNums.add(number);
                }
                isHasData = this.checkHasDataB4DelMemb(memberNums, entityNum);
                if (isHasData.booleanValue()) {
                    this.openTipB4DelMemberForm();
                    break;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\uff1f", (String)"FloatMaintainPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_comfirm", (IFormPlugin)this));
                break;
            }
        }
    }

    private void openTipB4DelMemberForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bcm_dimensionoperation");
        parameter.setCaption(ResManager.loadKDString((String)"\u7ef4\u5ea6\u64cd\u4f5c\u63d0\u793a", (String)"DimensionDisplayList_171", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dimension_quote_report"));
        this.getView().showForm(parameter);
    }

    private Boolean checkHasDataB4DelMemb(List<String> memberNums, String dimensionNum) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String modelNum = (String)formShowParameter.getCustomParam("model_number");
        Set notExistMembs = OlapServiceHelper.batCheckMemberIsExistOlap((String)dimensionNum, (String[])memberNums.toArray(new String[0]), (String)modelNum);
        for (Object m : notExistMembs) {
            memberNums.remove(m);
        }
        if (memberNums.isEmpty()) {
            return false;
        }
        boolean flag = OlapServiceHelper.hasOlapData((String)modelNum, memberNums, (String)dimensionNum);
        return flag;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control evtSource = (Control)evt.getSource();
        String key = evtSource.getKey();
        if (key.equals("btn_save")) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            for (DynamicObject dy : entryEntity) {
                if (!StringUtils.isBlank((CharSequence)dy.getString("name"))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d6e\u52a8\u6210\u5458\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FloatMaintainPlugin_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            this.save();
        } else if (key.equals("btn_cancel")) {
            if (this.checkNeedSave()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u4fdd\u5b58\u7684\u64cd\u4f5c\uff0c\u662f\u5426\u9000\u51fa\uff1f", (String)"FloatMaintainPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("cancel_comfirm", (IFormPlugin)this));
            } else {
                this.getView().close();
            }
        }
    }

    private boolean checkNeedSave() {
        DynamicObjectCollection rateColl = this.getModel().getEntryEntity(ENTRY_ENTITY);
        int saved = 0;
        int notsaved = 0;
        for (DynamicObject row : rateColl) {
            if (row.get(SAVED).equals("true")) {
                ++saved;
                continue;
            }
            ++notsaved;
        }
        return notsaved != 0 || Integer.parseInt(this.getPageCache().get(beginsize)) - saved != 0;
    }

    private void save() {
        DynamicObjectCollection rateColl = this.getModel().getEntryEntity(ENTRY_ENTITY);
        ArrayList<Integer> todel = new ArrayList<Integer>();
        int i = 0;
        for (DynamicObject row : rateColl) {
            if (row.get("name").equals(" ")) {
                todel.add(i);
            }
            ++i;
        }
        int[] del = new int[todel.size()];
        for (int k = 0; k < del.length; ++k) {
            del[k] = (Integer)todel.get(k);
        }
        this.getModel().deleteEntryRows(ENTRY_ENTITY, del);
        int saved = 0;
        DynamicObjectCollection notSaveCol = new DynamicObjectCollection();
        DynamicObjectCollection notDel = new DynamicObjectCollection();
        rateColl = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (DynamicObject row : rateColl) {
            if (row.get(SAVED).equals("true")) {
                ++saved;
                continue;
            }
            notSaveCol.add((Object)row);
        }
        if (notSaveCol.isEmpty() && Integer.parseInt(this.getPageCache().get(beginsize)) - saved == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4efb\u4f55\u65b0\u589e/\u5220\u9664\u6570\u636e\u3002", (String)"FloatMaintainPlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        String selectid = this.getPageCache().get(dimenmemberid);
        long parentid = this.getParent(selectid);
        QFilter qf = new QFilter(PARENT, "=", (Object)parentid);
        if (Integer.parseInt(this.getPageCache().get(beginsize)) - saved != 0) {
            QFilter qf1 = new QFilter(IS_SYS_MEMBER, "=", (Object)5);
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)"", (String)this.getPageCache().get(entityname), (String)"id,number,name,creator,modifier,createtime,modifytime", (QFilter[])new QFilter[]{qf, qf1}, null);
            for (DynamicObject dot : dcs) {
                for (DynamicObject viewdot : rateColl) {
                    if (!dot.get("number").equals(viewdot.get("number"))) continue;
                    notDel.add((Object)dot);
                }
            }
            for (DynamicObject dot : notDel) {
                dcs.remove((Object)dot);
            }
            this.delDimension(dcs);
        }
        if (!notSaveCol.isEmpty()) {
            this.saveDimension(Integer.parseInt(this.getPageCache().get(notfloatnumber)), saved, notSaveCol, parentid, selectid);
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff0c\u662f\u5426\u9000\u51fa\uff1f", (String)"FloatMaintainPlugin_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(SAVE_CONFIRM, (IFormPlugin)this));
    }

    private void delDimension(DynamicObjectCollection col) {
        ArrayList<String> ls = new ArrayList<String>();
        for (DynamicObject dot : col) {
            ls.addAll(this.getpks(dot.getString("id")));
        }
        ArrayList<String> ls2 = new ArrayList<String>();
        long modelid = this.getModelId();
        String dimennumber = this.getPageCache().get(dimensionnumber);
        QFilter qf2 = new QFilter("model.id", "=", (Object)modelid);
        DynamicObjectCollection dots = QueryServiceHelper.query((String)"", (String)"bcm_dimension", (String)"id,number", (QFilter[])new QFilter[]{qf2}, null);
        String dimensionid = null;
        for (DynamicObject dot : dots) {
            if (!dot.getString("number").equals(dimennumber)) continue;
            dimensionid = dot.getString("id");
            break;
        }
        QFilter qfilter = new QFilter("id", "=", (Object)modelid);
        QFilter[] qfilters = new QFilter[]{qfilter};
        DynamicObject modelObj = QueryServiceHelper.queryOne((String)"bcm_model", (String)"number", (QFilter[])qfilters);
        String modelNum = modelObj.getString("number");
        ArrayList<String> members = new ArrayList<String>();
        ArrayListMultimap multimap = ArrayListMultimap.create();
        try (TXHandle tx = TX.required();){
            try {
                String entityId = this.getPageCache().get(entityname);
                String dimNum = this.getPageCache().get(dimensionnumber);
                String selectFields = "member,storagetype,model,dimension,number,parent.number,aggoprt";
                QFilter fdimenId = new QFilter("id", "in", (Object)DataTypeConvertUtil.convert(ls));
                DataSet dSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityId, (String)selectFields, (QFilter[])new QFilter[]{fdimenId}, null);
                for (Row row : dSet) {
                    if (StorageTypeEnum.SHARE.index.equals(row.getString(STORAGE_TYPE))) continue;
                    ls2.add(row.getString(MEMBER));
                    String number = row.getString("number");
                    members.add(number);
                    multimap.put((Object)row.getString("parent.number"), (Object)Pair.onePair((Object)number, (Object)row.getInteger("aggoprt")));
                }
                if (SyncCacheUtil.isIncrementCache((String)"bcm_icmembertree")) {
                    Set ids = ls.stream().map(m -> LongUtil.toLong((Object)m)).collect(Collectors.toSet());
                    SyncCacheUtil.saveMemberCache((Long)modelid, (Long)MemberReader.getDimensionIdByNum((long)modelid, (String)dimNum), ids);
                }
                OlapServiceHelper.batchDropAggFactor((String)modelNum, (String)dimNum, (Multimap)multimap);
                OlapServiceHelper.batchDropDimensionMembers((String)modelNum, (String)dimNum, members);
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5220\u9664", "FloatMaintainPlugin_11", FI_BCM_FORMPLUGIN, "delete"), new OPDescMultiLangEnumBridge("\u7f16\u53f7%s\u5220\u9664\u6210\u529f\u3002", "AbstractMultiReportPlugin_392", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{((Object)members).toString()})));
                String member = this.getPageCache().get(entityname);
                String cs1 = "icmembertree";
                if (member.contains(cs1)) {
                    member = "bcm_intercompanymember";
                } else if (!(member = member.substring(0, member.length() - 4)).endsWith(MEMBER)) {
                    member = member + MEMBER;
                }
                BusinessDataWriter.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)member), (Object[])DataTypeConvertUtil.convert(ls2).toArray());
                HashSet<String> lstreeparent = new HashSet<String>();
                HashSet deleteTreeMember = new HashSet();
                List treelist = QueryTreenodeHelper.getallnode((String)entityId, (String)dimensionid, (String)String.valueOf(this.getModelId()));
                for (String ssg : ls2) {
                    long memberid = Long.parseLong(ssg);
                    String selects = "id,parent";
                    QFilter qff1 = new QFilter(MEMBER, "=", (Object)memberid);
                    QFilter[] filters1 = new QFilter[]{qff1};
                    DynamicObjectCollection dcs1 = QueryServiceHelper.query((String)this.getPageCache().get(entityname), (String)selects, (QFilter[])filters1);
                    if (dcs1 == null || dcs1.isEmpty()) continue;
                    for (DynamicObject obj : dcs1) {
                        String treeid = obj.getString("id");
                        String treeparent = obj.getString(PARENT);
                        lstreeparent.add(treeparent);
                        Set setchild = QueryTreenodeHelper.queryAllChildNodeSet((String)treeid, (Collection)treelist, new HashSet());
                        deleteTreeMember.addAll(setchild);
                    }
                }
                DeleteServiceHelper.delete((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)entityId).getDataEntityType(), (Object[])DataTypeConvertUtil.convert(deleteTreeMember).toArray());
                for (String ss : lstreeparent) {
                    this.updateParentIsLeafByParent(Long.parseLong(ss), entityId);
                }
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private List<String> getpks(String nodeId) {
        String entityId = this.getPageCache().get(entityname);
        long modelid = this.getModelId();
        String dimennumber = this.getPageCache().get(dimensionnumber);
        QFilter qf2 = new QFilter("model.id", "=", (Object)modelid);
        DynamicObjectCollection dots = QueryServiceHelper.query((String)"", (String)"bcm_dimension", (String)"id,number", (QFilter[])new QFilter[]{qf2}, null);
        String dimensionid = null;
        for (DynamicObject dot : dots) {
            if (!dot.getString("number").equals(dimennumber)) continue;
            dimensionid = dot.getString("id");
            break;
        }
        List treelist = QueryTreenodeHelper.getallnode((String)entityId, dimensionid, (String)String.valueOf(modelid));
        Set list = QueryTreenodeHelper.queryAllChildNodeSet((String)nodeId, (Collection)treelist, new HashSet());
        return new ArrayList<String>(list);
    }

    private void saveDimension(int notfloat, int saved, DynamicObjectCollection col, long parentid, String selectid) {
        long memberid;
        ArrayList<DynamicObject> listobj = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> memberlist = new ArrayList<DynamicObject>();
        ArrayList<String> derivenumlist = new ArrayList<String>();
        ArrayList sharelist = new ArrayList();
        DynamicObject type = null;
        DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)parentid, (String)this.getPageCache().get(entityname));
        DynamicObject brother = BusinessDataServiceHelper.loadSingle((Object)selectid, (String)this.getPageCache().get(entityname));
        if (brother.get(PARENT) == null) {
            QFilter filter = new QFilter("parent.id", "=", brother.get("id"));
            DynamicObjectCollection collection = QueryServiceHelper.query((String)this.getPageCache().get(entityname), (String)"id", (QFilter[])new QFilter[]{filter});
            String id = ((DynamicObject)collection.get(0)).getString("id");
            brother = BusinessDataServiceHelper.loadSingle((Object)id, (String)this.getPageCache().get(entityname));
        }
        ArrayList<TreeNode> parentlist = new ArrayList<TreeNode>(10);
        TreeNode parentnode = new TreeNode(parent.getString("id"), "", "0");
        String entity = this.getPageCache().get(entityname);
        for (DynamicObject dot : col) {
            String cs1 = "icmembertree";
            String membertable = entity.contains(cs1) ? "bcm_intercompanymember" : entity.substring(0, entity.length() - 4);
            DynamicObject member = BusinessDataServiceHelper.newDynamicObject((String)membertable);
            Date now = TimeServiceHelper.now();
            member.set("id", (Object)DBServiceHelper.genGlobalLongId());
            member.set("number", dot.get("number"));
            member.set(DIMENSION, parent.get(DIMENSION));
            member.set(MODEL, parent.get(MODEL));
            member.set("status", (Object)"C");
            member.set("enable", (Object)1);
            member.set(MODIFY_TIME, (Object)now);
            member.set(CREATE_TIME, dot.get(CREATE_DATE_FIELD));
            DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
            RequestContext tx = RequestContext.get();
            user.set("id", (Object)tx.getUserId());
            member.set(CREATOR, dot.get(CREATOR_FIELD));
            member.set(MODIFIER, (Object)user);
            type = member;
            memberlist.add(member);
            DynamicObject node = (DynamicObject)OrmUtils.clone((Object)brother, (IDataEntityType)brother.getDataEntityType(), (boolean)true, (boolean)true);
            long id = DBServiceHelper.genGlobalLongId();
            node.set("id", (Object)id);
            node.set(MEMBER, (Object)member);
            node.set("name", dot.get("name"));
            node.set(LONG_NUMBER, (Object)(parent.get(LONG_NUMBER) + "!" + dot.get("number")));
            node.set("number", dot.get("number"));
            node.set(LEVEL, (Object)String.valueOf((Integer)parent.get(LEVEL) + 1));
            node.set("dseq", (Object)String.valueOf(++saved + notfloat));
            node.set(STORAGE_TYPE, (Object)StorageTypeEnum.STORAGE.getOIndex());
            node.set("aggoprt", (Object)AggOprtEnum.ADD.getSign());
            node.set(CREATOR, dot.get(CREATOR_FIELD));
            node.set(CREATE_TIME, dot.get(CREATE_DATE_FIELD));
            node.set(MODIFIER, (Object)user);
            node.set(MODIFY_TIME, (Object)now);
            node.set(PARENT, (Object)parent);
            node.set(IS_LEAF, (Object)true);
            node.set(IS_SYS_MEMBER, (Object)5);
            if ("1".equals(this.getPageCache().get(isparent))) {
                node.set("addtext", (Object)"baritemaddsub");
            } else {
                node.set("addtext", (Object)"");
            }
            if (!"bcm_icmembertree".equalsIgnoreCase(entity)) {
                node.set("datatype", (Object)DataTypeEnum.DEFAULT.index);
            }
            String string = node.getString("number");
            derivenumlist.add(string);
            TreeNode childnode = new TreeNode(String.valueOf(id), (String)dot.get("number"), "0");
            childnode.setData(node);
            parentnode.addChild((ITreeNode)childnode);
            listobj.add(node);
        }
        try {
            memberid = ((DynamicObject)parent.get(MEMBER)).getLong("id");
        }
        catch (Exception e) {
            memberid = 0L;
        }
        long modelid = this.getModelId();
        String dimennumber = this.getPageCache().get(dimensionnumber);
        QFilter qf2 = new QFilter("model.id", "=", (Object)modelid);
        DynamicObjectCollection dots = QueryServiceHelper.query((String)"", (String)"bcm_dimension", (String)"id,number", (QFilter[])new QFilter[]{qf2}, null);
        long dimensionid = 0L;
        for (Object dot : dots) {
            if (!dot.getString("number").equals(dimennumber)) continue;
            dimensionid = dot.getLong("id");
            break;
        }
        parentlist.add(parentnode);
        this.alterIsleaf(parentid, this.getPageCache().get(entityname));
        Map<Object, Object> idCopyfrom = new HashMap();
        if (memberid != 0L) {
            idCopyfrom = FloatMaintainPlugin.getallShareCopyNode(this.getPageCache().get(entityname), modelid, memberid, parentid, dimensionid);
        }
        for (Map.Entry entry : idCopyfrom.entrySet()) {
            String nodeid = (String)entry.getKey();
            TreeNode parentnodetemp = new TreeNode(nodeid, "", (String)entry.getValue());
            parentlist.add(parentnodetemp);
            this.alterIsleaf(Long.parseLong(nodeid), this.getPageCache().get(entityname));
        }
        HashSet<String> neadsave = new HashSet<String>();
        neadsave.add(parentnode.getId());
        block16: do {
            for (TreeNode node : parentlist) {
                if (neadsave.contains(node.getCopyfrom())) {
                    ArrayList<DynamicObject> share = new ArrayList<DynamicObject>(listobj.size());
                    DynamicObject parenttemp = BusinessDataServiceHelper.loadSingle((Object)node.getId(), (String)this.getPageCache().get(entityname));
                    for (DynamicObject a : listobj) {
                        DynamicObject nodetemp = (DynamicObject)OrmUtils.clone((Object)a, (IDataEntityType)a.getDataEntityType(), (boolean)true, (boolean)true);
                        nodetemp.set(PARENT, (Object)parenttemp);
                        nodetemp.set("id", (Object)DBServiceHelper.genGlobalLongId());
                        TreeNode copyfrom = this.search(parentlist, node.getCopyfrom());
                        if (copyfrom == null) {
                            return;
                        }
                        TreeNode child = (TreeNode)this.searchChild(copyfrom, a.getString("number"));
                        if (child == null) {
                            return;
                        }
                        nodetemp.set("copyfrom", child.getData());
                        nodetemp.set(LONG_NUMBER, (Object)(parenttemp.get(LONG_NUMBER) + "!" + a.get("number")));
                        nodetemp.set(STORAGE_TYPE, parenttemp.get(STORAGE_TYPE));
                        nodetemp.set(LEVEL, (Object)String.valueOf((Integer)parenttemp.get(LEVEL) + 1));
                        nodetemp.set("share", (Object)1);
                        nodetemp.set(IS_SYS_MEMBER, (Object)5);
                        TreeNode treeNode = new TreeNode(a.getString("id"), a.getString("number"), child.getId());
                        treeNode.setData(nodetemp);
                        node.addChild((ITreeNode)treeNode);
                        share.add(nodetemp);
                    }
                    neadsave.add(node.getId());
                    sharelist.add(share);
                }
                if (!this.checkFinish(parentlist)) continue;
                continue block16;
            }
        } while (!this.checkFinish(parentlist));
        QFilter qFilter = new QFilter("id", "=", (Object)dimensionid);
        DynamicObject dimension = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"number", (QFilter[])new QFilter[]{qFilter});
        QFilter modelFilterID = new QFilter("id", "=", (Object)Long.valueOf(this.getPageCache().get(modelcache)));
        DynamicObject model = QueryServiceHelper.queryOne((String)"bcm_model", (String)"number", (QFilter[])new QFilter[]{modelFilterID});
        LogConstant result = new LogConstant();
        try (TXHandle th = TX.requiresNew();){
            try {
                if (type != null) {
                    BusinessDataWriter.save((IDataEntityType)type.getDynamicObjectType(), (Object[])memberlist.toArray());
                }
                BusinessDataWriter.save((IDataEntityType)parent.getDynamicObjectType(), (Object[])listobj.toArray());
                ArrayList<Tuple> list = new ArrayList<Tuple>(listobj.size());
                for (DynamicObject dynamicObject : listobj) {
                    list.add(Tuple.create((Object)dynamicObject.getString("number"), (Object)dynamicObject.getInt("aggoprt"), (Object)DimensionServiceHelper.getMemberNumber((String)DimEntityNumEnum.getEntieyNumByNumber((String)dimension.getString("number")), (Object)dynamicObject.get("parent.id"))));
                }
                if (!derivenumlist.isEmpty()) {
                    OlapServiceHelper.batchCreateDimensionMembers((String)model.getString("number"), (String)dimension.getString("number"), list);
                }
                for (List list2 : sharelist) {
                    BusinessDataWriter.save((IDataEntityType)parent.getDynamicObjectType(), (Object[])list2.toArray());
                }
                this.getPageCache().put(beginsize, String.valueOf(saved));
                this.getModel().setValue(SAVED, (Object)"true");
                this.refreshEntity();
            }
            catch (Exception e) {
                th.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        SaveDimMemberHelper.saveLog(listobj, (DimMemberOperateTypeEnum)DimMemberOperateTypeEnum.NEW);
    }

    private static Map<String, String> getallShareCopyNode(String entityname, long modelid, long memberid, long selectid, long dimensionid) {
        QFilter qf2 = new QFilter("model.id", "=", (Object)modelid);
        QFilter qf1 = new QFilter("dimension.id", "=", (Object)dimensionid);
        QFilter qf3 = new QFilter("member.id", "=", (Object)memberid);
        QFilter qf4 = new QFilter("id", "!=", (Object)selectid);
        QFilter qf5 = new QFilter("share", "=", (Object)1);
        QFilter[] qfs = new QFilter[]{qf1, qf2, qf3, qf4, qf5};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"", (String)entityname, (String)"id,copyfrom.id", (QFilter[])qfs, null);
        HashMap<String, String> map = new HashMap<String, String>();
        for (DynamicObject a : dcs) {
            map.put(String.valueOf(a.get(0)), String.valueOf(a.get(1)));
        }
        return map;
    }

    private void updateParentIsLeafByParent(long parentId, String entityName) {
        QFilter filter = new QFilter(PARENT, "=", (Object)parentId);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)entityName, (String)"number", (QFilter[])filters);
        if (dcs == null || dcs.isEmpty()) {
            DynamicObject dynamicObject = null;
            try {
                dynamicObject = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)entityName);
            }
            catch (Exception e) {
                return;
            }
            dynamicObject.set(IS_LEAF, (Object)1);
            BusinessDataWriter.save((IDataEntityType)dynamicObject.getDataEntityType(), (Object[])new Object[]{dynamicObject});
        }
    }

    private TreeNode search(List<TreeNode> list, String copyfrom) {
        for (TreeNode node : list) {
            if (!node.getId().equals(copyfrom)) continue;
            return node;
        }
        return null;
    }

    private ITreeNode<DynamicObject> searchChild(TreeNode root, String name) {
        List children = root.getChildren();
        for (ITreeNode child : children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    private boolean checkFinish(List<TreeNode> list) {
        int x = 0;
        for (TreeNode node : list) {
            if (!node.getChildren().isEmpty()) continue;
            ++x;
        }
        return x == 0;
    }

    protected long getParent(String selectid) {
        String position = this.getPageCache().get(isparent);
        if (position.equals("1")) {
            return Long.parseLong(selectid);
        }
        DynamicObject dot = BusinessDataServiceHelper.loadSingle((Object)selectid, (String)this.getPageCache().get(entityname));
        return dot.getDynamicObject(PARENT).getLong("id");
    }

    private void alterIsleaf(long parentselectid, String entityname) {
        DynamicObject dot = BusinessDataServiceHelper.loadSingle((Object)parentselectid, (String)entityname);
        boolean isleaf = dot.getBoolean(IS_LEAF);
        if (isleaf) {
            dot.set(IS_LEAF, (Object)"0");
            dot.set(STORAGE_TYPE, (Object)StorageTypeEnum.DYNAMIC.index);
            BusinessDataWriter.save((IDataEntityType)dot.getDataEntityType(), (Object[])new Object[]{dot});
        }
    }

    protected Map<String, List<FloatInfo>> analyseSpeadInfo() {
        QFilter qFilter = new QFilter(MODEL, "=", (Object)this.getModelId());
        DataSet ds = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)"bcm_dimension", (String)"name,number", (QFilter[])new QFilter[]{qFilter}, null);
        HashMap<String, String> dims = new HashMap<String, String>(16);
        while (ds.hasNext()) {
            Row row = ds.next();
            dims.put(row.getString("number"), row.getString("name"));
        }
        HashMap<String, List<FloatInfo>> map = new HashMap<String, List<FloatInfo>>();
        SpreadManager spreadManager = this.getSpreadModelFromSerial(this.getPageCache().get(spreadCache));
        MultiAreaPositionsManager pm = spreadManager.getAreaManager();
        Set pSet = pm.getPostionInfoSet();
        for (PositionInfo info : pSet) {
            List basePointInfos = info.getBasePoints();
            for (BasePointInfo bInfo : basePointInfos) {
                List bininfo = bInfo.getBasePointInnerLineInfo();
                String area = bInfo.getDynaRange();
                ArrayList<FloatInfo> infolist = new ArrayList<FloatInfo>();
                for (BasePointInnerLineInfo xx : bininfo) {
                    if (!xx.isFloated() || xx.getAddPositionEnum() == null) continue;
                    int position = xx.getAddPositionEnum().getVal();
                    String number = xx.getDimension().getNumber();
                    xx.getDimension().setName((String)dims.get(number));
                    infolist.add(new FloatInfo(position, xx.getDimension(), (DimMember)xx.getMemberAddOf()));
                }
                map.put(area, infolist);
            }
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            if (!((List)map.get(iterator.next())).isEmpty()) continue;
            iterator.remove();
        }
        return map;
    }

    private void writeToCache(FloatInfo info) {
        this.getPageCache().put(entityname, info.getDimension().getUqCode());
        this.getPageCache().put(dimenmemberid, String.valueOf(info.getMember().getId()));
        this.getPageCache().put(isparent, String.valueOf(info.getPosition()));
        this.getPageCache().put(dimenmembernumber, info.getMember().getNumber());
        this.getPageCache().put(dimensionname, info.getDimension().getName());
        this.getPageCache().put(dimensionnumber, info.getDimension().getNumber());
    }

    protected String createNumber() {
        DynamicObject member = BusinessDataServiceHelper.loadSingle((Object)this.getPageCache().get(dimenmemberid), (String)this.getPageCache().get(entityname));
        String[] numbers = CodeRuleUtil.getDimensionNumber(this.getPageCache().get(entityname), member, 1);
        String number = numbers[0];
        QFilter qf = new QFilter("number", "=", (Object)number);
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"", (String)this.getPageCache().get(entityname), (String)"number", (QFilter[])new QFilter[]{qf}, null);
        while (!dcs.isEmpty()) {
            number = CodeRuleUtil.getDimensionNumber(this.getPageCache().get(entityname), member, 1)[0];
            qf = new QFilter("number", "=", (Object)number);
            dcs = QueryServiceHelper.query((String)"", (String)this.getPageCache().get(entityname), (String)"number", (QFilter[])new QFilter[]{qf}, null);
        }
        int temp = Integer.parseInt(this.getPageCache().get(numbercache));
        this.getPageCache().put(numbercache, String.valueOf(++temp));
        return number;
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        List<FloatInfo> infos;
        String area;
        Map<String, List<FloatInfo>> map;
        IDataModel model;
        boolean flag;
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        boolean bl = flag = MessageBoxResult.Yes == mbce.getResult();
        if (callBackId.equals("delete_comfirm") && flag) {
            int[] selected = (int[])ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(selectrow));
            this.getModel().deleteEntryRows(ENTRY_ENTITY, selected);
        }
        if (callBackId.equals("change_areacomfirm") || callBackId.equals("change_dimencomfirm")) {
            if (flag) {
                this.save();
            }
            model = this.getModel();
            map = this.analyseSpeadInfo();
            area = (String)model.getValue(FLOAT_AREA);
            infos = map.get(area);
            if (callBackId.equals("change_areacomfirm")) {
                this.refreshAreaInfo(area, infos);
            } else {
                String dimen = (String)model.getValue(DIMENSION);
                this.refreshDimenInfo(infos, dimen);
            }
        }
        if (callBackId.equals(SAVE_CONFIRM) && flag) {
            this.getView().close();
        } else if (callBackId.equals(SAVE_CONFIRM) && MessageBoxResult.Cancel == mbce.getResult()) {
            model = this.getModel();
            map = this.analyseSpeadInfo();
            area = (String)model.getValue(FLOAT_AREA);
            infos = map.get(area);
            this.refreshAreaInfo(area, infos);
        }
        if (callBackId.equals("cancel_comfirm") && flag) {
            this.getView().close();
        }
    }

    public static class FloatInfo {
        private IDimension dimension;
        private int position;
        private DimMember member;

        public FloatInfo(int position, IDimension dimension, DimMember member) {
            this.position = position;
            this.dimension = dimension;
            this.member = member;
        }

        public IDimension getDimension() {
            return this.dimension;
        }

        public int getPosition() {
            return this.position;
        }

        public DimMember getMember() {
            return this.member;
        }
    }

    public static class TreeNode
    extends AbstractTreeNode<DynamicObject> {
        private static final long serialVersionUID = 1L;
        private String copyfrom;

        public TreeNode(String id, String name, String copyfrom) {
            super(id, name);
            this.copyfrom = copyfrom;
        }

        public String getCopyfrom() {
            return this.copyfrom;
        }
    }
}

