/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.permission.perm.PermCacheKey;
import kd.fi.bcm.business.permission.perm.PermPackageList;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.serviceHelper.UserSelectServiceHelper;
import kd.fi.bcm.business.template.TemplatePermCrossUtil;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.TemplateDistributionOrgUtil;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.template.OrgRptTemplateUpdateEnum;
import kd.fi.bcm.common.json.JSONObjectUtil;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.fel.common.ArrayUtils;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.report.floatreport.AutoFloatUtil;
import kd.fi.bcm.formplugin.template.util.SaveTemplateUtil;
import kd.fi.bcm.formplugin.util.NewMyTemplateUtil;
import kd.fi.bcm.formplugin.util.ReportListUtil;
import kd.fi.bcm.formplugin.util.SearchUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.common.TemplateConstant;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.util.DataAndJsonTranslator;
import org.apache.commons.lang3.StringUtils;

public class MyTemplatePlugin
extends AbstractBaseListPlugin
implements TreeNodeClickListener {
    private static final String TREEVIEW_ORG = "treeview_org";
    private static final String BILLLISTAP = "billlistap";
    public static final String modelCacheKey = "KEY_MODEL_ID";
    private static final String MODEL = "model";
    private static final String ALLSUBORDINATE = "allsubordinate";
    private static final String CTL_SHOWORGTYPE = "showorgtype";
    private static final String CACHE_SHOWORGTYPE = "cache_showorgtype";
    private static final String CACHE_SELECTNODE = "cache_selectnode";
    private static final String SELECTORGS = "selectorgs";
    private static final String BTN_SHOWHISTORY = "btn_showhistory";
    private static final String BTN_HIDEHISTORY = "btn_hidehistory";
    private static final String BTN_UPDATE = "btn_update";
    private static final String PAGE_ID = "pageid";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String BTN_RESET = "btn_reset";
    private static final String NUMBER = "number";
    private static final String SEARCH_BEFORE = "searchbefore";
    private static final String SEARCH_NEXT = "searchnext";
    private static final String VERSION_NUMBER = "versionnumber";
    private static final String NEEDUPDATE = "needupdate";
    private static final String FINISH = "finish";

    private static String getOperationReduction() {
        return ResManager.loadKDString((String)"\u8fd8\u539f", (String)"MyTemplatePlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private static String getOperationView() {
        return ResManager.loadKDString((String)"\u67e5\u770b", (String)"MyTemplatePlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private static String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"MyTemplatePlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private static String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"MyTemplatePlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private static String getUpdate() {
        return ResManager.loadKDString((String)"\u6a21\u677f\u5347\u7ea7", (String)"MyTemplatePlugin_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        TreeView orgTreeView = (TreeView)this.getControl(TREEVIEW_ORG);
        String selOrgId = orgTreeView.getTreeState().getFocusNodeId();
        QFilter filters = null;
        String string = selOrgId = selOrgId == null ? this.getPageCache().get(CACHE_SELECTNODE) : selOrgId;
        if (kd.bos.util.StringUtils.isEmpty((String)selOrgId)) {
            filters = new QFilter("1", "!=", (Object)1);
        } else if (this.isOrgMemberHavePerm(selOrgId, null)) {
            filters = new QFilter(PAGE_ID, "=", (Object)this.getView().getPageId());
            filters = this.getMyTemplateIdsQFilter(filters);
        } else {
            filters = new QFilter("1", "!=", (Object)1);
        }
        e.getQFilters().add(filters);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), MODEL);
        String showType = (String)this.getModel().getValue(CTL_SHOWORGTYPE);
        this.getPageCache().put(CACHE_SHOWORGTYPE, showType);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_UPDATE});
        if (kd.bos.util.StringUtils.isNotEmpty((String)modelId) && !modelId.equals("0")) {
            this.getModel().setValue(MODEL, (Object)modelId);
            this.getPageCache().put(modelCacheKey, modelId);
            this.initCslschemeValue(modelId, false);
            this.refreshTree(modelId);
            this.showBtnhistory(true, false);
            if (this.getPageCache().get(CACHE_SELECTNODE) != null) {
                this.prepareData(this.getPageCache().get(CACHE_SELECTNODE));
            }
            this.refreshBillList();
        }
        this.checkGradeOrgScheme();
        this.checkItemAuthForHide(new String[]{"baritemap_alteracct", BTN_RESET});
        this.getView().setVisible(Boolean.valueOf(ConfigServiceHelper.getBoolParam((String)this.getCurModelNumber(), (String)"isSupportNewMytemplate")), new String[]{NEEDUPDATE, FINISH});
    }

    private void showUpdate(String cube) {
        boolean needUpdate = (Boolean)this.getModel().getValue(NEEDUPDATE);
        boolean supportNewMytemplate = ConfigServiceHelper.getBoolParam((String)cube, (String)"isSupportNewMytemplate");
        this.getView().setVisible(Boolean.valueOf(supportNewMytemplate && needUpdate), new String[]{BTN_UPDATE});
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView orgTreeView = (TreeView)this.getControl(TREEVIEW_ORG);
        orgTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.addListRowDoubleClickListener((ListRowClickListener)this);
        billList.addListRowClickListener((ListRowClickListener)this);
        final IFormView view = this.getView();
        this.addBeforeF7SelectListener("cslscheme");
        final IPageCache pageCache = this.getPageCache();
        final TreeView treeView = (TreeView)this.getControl(TREEVIEW_ORG);
        Search sl = (Search)this.getControl("entitysearchap");
        sl.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent p0) {
                if (p0.getText() != null && !"".equals(p0.getText())) {
                    SearchUtil.searchMember(p0.getText().toLowerCase(Locale.ENGLISH).trim(), view, pageCache, treeView, MyTemplatePlugin.TREEVIEW_ORG);
                } else {
                    MyTemplatePlugin.this.getPageCache().put("resultlist", null);
                    MyTemplatePlugin.this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                }
            }
        });
        this.addClickListeners(SEARCH_BEFORE, SEARCH_NEXT);
    }

    protected void addBeforeF7SelectListener(String ... idenitiys) {
        for (String idenitiy : idenitiys) {
            BasedataEdit edit = (BasedataEdit)this.getControl(idenitiy);
            if (edit == null || !"cslscheme".equalsIgnoreCase(idenitiy)) continue;
            edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            edit.setQFilter(new QFilter(NUMBER, "!=", (Object)"DefaultRateScheme"));
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String orgId = evt.getNodeId().toString();
        if (kd.bos.util.StringUtils.isNotEmpty((String)orgId)) {
            this.getPageCache().put(CACHE_SELECTNODE, orgId);
            UserSelectServiceHelper.setEntity((Long)this.getUserId(), (Long)this.getModelId(), (Object)orgId);
            Set<String> selectnodes = new HashSet<String>();
            if (this.getPageCache().get(SELECTORGS) != null) {
                selectnodes = (Set)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(SELECTORGS));
            }
            selectnodes.add(orgId);
            this.getPageCache().put(SELECTORGS, ObjectSerialUtil.toByteSerialized(selectnodes));
            this.deleteTemplateByPageid();
            this.prepareData(orgId);
            this.refreshBillList();
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("baritemap_alteracct".equals(key)) {
            this.openForm();
        } else if ("baritemap_refresh".equals(key)) {
            this.refreshTree(this.getPageCache().get(modelCacheKey));
            TreeView orgTreeView = (TreeView)this.getControl(TREEVIEW_ORG);
            String selOrgId = orgTreeView.getTreeState().getFocusNodeId();
            this.deleteTemplateByPageid();
            if (selOrgId != null && kd.bos.util.StringUtils.isNotEmpty((String)selOrgId)) {
                TreeNodeEvent tevt = new TreeNodeEvent((Object)evt, null, (Object)selOrgId);
                this.treeNodeClick(tevt);
            } else {
                this.refreshBillList();
            }
        } else if (BTN_RESET.equals(key)) {
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            if (billList.getSelectedRows().isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MyTemplatePlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u6e05\u9664\u9009\u4e2d\u7ec4\u7ec7\u7684\u62a5\u8868\u6a21\u677f\u7684\u4e2a\u6027\u5316\u5185\u5bb9\uff0c\u8986\u76d6\u4e3a\u5bf9\u5e94\u6a21\u677f\u7684\u6700\u65b0\u5185\u5bb9\uff0c\u786e\u5b9a\u6267\u884c\uff1f", (String)"MyTemplatePlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_RESET, (IFormPlugin)this));
        } else if (BTN_HIDEHISTORY.equals(key) || BTN_SHOWHISTORY.equals(key)) {
            boolean isShowHistory = StringUtil.equals((String)BTN_HIDEHISTORY, (String)key);
            this.showBtnhistory(isShowHistory, true);
            this.refreshBillList();
        } else if (BTN_UPDATE.equals(key)) {
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            if (billList.getSelectedRows().isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MyTemplatePlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (billList.getSelectedRows().size() > 10) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u900910\u6761\u4ee5\u5185\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MyTemplatePlugin_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u5347\u7ea7\u9009\u4e2d\u7684\u4e2a\u6027\u5316\u6a21\u677f\uff0c\u786e\u5b9a\u6267\u884c\uff1f", (String)"MyTemplatePlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_UPDATE, (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        switch (callBackId = e.getCallBackId()) {
            case "btn_update": {
                if (MessageBoxResult.Yes != e.getResult()) break;
                String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
                BillList billList = (BillList)this.getControl(BILLLISTAP);
                Object[] selectRows = billList.getSelectedRows().getPrimaryKeyValues();
                Map mytemplates = BusinessDataServiceHelper.loadFromCache((Object[])selectRows, (String)"bcm_mytemplatelist");
                if (mytemplates.size() == 0) {
                    return;
                }
                QFBuilder qfBuilder = new QFBuilder("1", "!=", (Object)1);
                mytemplates.values().forEach(mytemplate -> {
                    Long orgId = LongUtil.toLong((Object)mytemplate.get("entity.id"));
                    qfBuilder.or(new QFilter("template", "=", (Object)LongUtil.toLong((Object)mytemplate.get("template.id"))).and("org", "=", BcmThreadCache.get((Object)modelNum, (Object)DimTypesEnum.ENTITY.getNumber(), (Object)orgId, () -> MemberReader.change2BaseMember((String)modelNum, (Long)orgId))));
                });
                qfBuilder.add(new QFilter("isupdate", "=", (Object)Character.valueOf(OrgRptTemplateUpdateEnum.getCode((boolean)false))));
                Set files = EntityMetadataCache.getDataEntityType((String)"bcm_orgrpttemplate").getAllFields().keySet();
                long modelId = this.getModelId();
                DynamicObject[] mytemplate2 = BusinessDataServiceHelper.load((String)"bcm_orgrpttemplate", (String)String.join((CharSequence)",", files), (QFilter[])qfBuilder.toArray());
                Map<Long, List<DynamicObject>> template2mytemplate = Arrays.stream(mytemplate2).filter(t -> kd.bos.util.StringUtils.isNotEmpty((String)t.getString("data"))).collect(Collectors.groupingBy(t -> t.getLong("template.id")));
                CloneUtils cloneUtils = new CloneUtils(true, true);
                for (Map.Entry<Long, List<DynamicObject>> entry : template2mytemplate.entrySet()) {
                    DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)entry.getKey(), (String)"bcm_templateentity", (String)"id,number,versionnumber,name,data,rptdata,issavebydim");
                    if (template == null) continue;
                    String templateNum = template.getString(NUMBER);
                    String templateName = template.getString("name");
                    BigDecimal versionNumber = (BigDecimal)template.get(VERSION_NUMBER);
                    String version = String.format("V%.1f", Float.valueOf(versionNumber.floatValue()));
                    SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)template.getString("data"));
                    SpreadManager rptSpreadManager = JsonSerializerUtil.toSpreadManager((String)template.getString("rptdata"));
                    NewMyTemplateUtil.repairCellIdForSm(spreadManager);
                    NewMyTemplateUtil.repairCellIdForSm(rptSpreadManager);
                    for (DynamicObject mytem : entry.getValue()) {
                        String spreadjson;
                        DynamicObject newMytemplate = (DynamicObject)cloneUtils.clone(mytem.getDataEntityType(), (Object)mytem);
                        newMytemplate.set("data", (Object)"");
                        newMytemplate.set("spreadjson", (Object)"");
                        newMytemplate.set("isupdate", (Object)Character.valueOf(OrgRptTemplateUpdateEnum.NO_UPDATE.getCode()));
                        mytem.set("isupdate", (Object)Character.valueOf(OrgRptTemplateUpdateEnum.NEED_UPDATE.getCode()));
                        String orgNumber = mytem.getString("org.number");
                        String orgName = mytem.getString("org.name");
                        SpreadManager mytemSpredManager = JsonSerializerUtil.toSpreadManager((String)mytem.getString("data"));
                        if (!template.getBoolean("issavebydim") && !AutoFloatUtil.isSyncLockStatus(mytemSpredManager.getBook().getSheet(0)) && StringUtils.isNotEmpty((CharSequence)(spreadjson = mytem.getString("spreadjson")))) {
                            JSONObject object = JSONObjectUtil.parseObjectOrder((String)JsonSerializerUtil.uncompress((String)spreadjson));
                            kd.fi.bcm.formplugin.util.TemplateUtil.setTemplateLockedCellStatus(DataAndJsonTranslator.getDataTable((JSONObject)object, (String)""), mytemSpredManager);
                        }
                        Map<String, Object> resultMap = NewMyTemplateUtil.getCellFormulasAndLocks(mytemSpredManager, orgNumber, modelId, template, spreadManager, rptSpreadManager);
                        QFilter delFilter = new QFilter(MODEL, "=", (Object)modelId);
                        delFilter.and("template", "=", (Object)entry.getKey());
                        delFilter.and("orgnumber", "=", (Object)orgNumber);
                        DynamicObject originTem = (DynamicObject)resultMap.get("template");
                        Object[] myCellFormulas = (DynamicObject[])resultMap.get("myCellFormulas");
                        Object[] myCellLocks = (DynamicObject[])resultMap.get("myCellLocks");
                        TXHandle tx = TX.required();
                        Throwable throwable = null;
                        try {
                            try {
                                BusinessDataWriter.update((IDataEntityType)originTem.getDataEntityType(), (Object[])new Object[]{originTem});
                                BusinessDataWriter.update((IDataEntityType)mytem.getDataEntityType(), (Object[])new Object[]{mytem});
                                BusinessDataWriter.save((IDataEntityType)newMytemplate.getDataEntityType(), (Object[])new Object[]{newMytemplate});
                                if (!ArrayUtils.isEmpty((Object[])myCellFormulas)) {
                                    BusinessDataWriter.delete((String)"bcm_cellformula", (QFilter[])delFilter.toArray());
                                    BusinessDataWriter.save((IDataEntityType)myCellFormulas[0].getDataEntityType(), (Object[])myCellFormulas);
                                }
                                if (!ArrayUtils.isEmpty((Object[])myCellLocks)) {
                                    BusinessDataWriter.delete((String)"bcm_mytemplate_celllock", (QFilter[])delFilter.toArray());
                                    BusinessDataWriter.save((IDataEntityType)myCellLocks[0].getDataEntityType(), (Object[])myCellLocks);
                                }
                                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u6a21\u677f\u5347\u7ea7", "MyTemplatePlugin_11", FI_BCM_FORMPLUGIN, "Upgrade Template"), new OPDescMultiLangEnumBridge("%1$s %2$s %3$s %4$s %5$s,\u6a21\u677f\u5347\u7ea7\u6210\u529f", "MyTemplatePlugin_12", FI_BCM_FORMPLUGIN, new String[]{orgName, orgNumber, templateNum, templateName, version}));
                            }
                            catch (Exception ex) {
                                tx.markRollback();
                                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u6a21\u677f\u5347\u7ea7", "MyTemplatePlugin_11", FI_BCM_FORMPLUGIN, "Upgrade Template"), new OPDescMultiLangEnumBridge("%1$s %2$s %3$s %4$s %5$s,\u6a21\u677f\u5347\u7ea7\u5931\u8d25", "MyTemplatePlugin_13", FI_BCM_FORMPLUGIN, new String[]{orgName, orgNumber, templateNum, templateName, version}));
                                throw new KDBizException(ThrowableHelper.printError((Throwable)ex));
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (tx == null) continue;
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            tx.close();
                        }
                    }
                }
                if (template2mytemplate.size() > 0) {
                    TemplateServiceHelper.removeTemplateModelCacheByIds((Object)modelId, (Object[])template2mytemplate.keySet().toArray());
                }
                this.refreshBillList();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\u3002", (String)"MyTemplatePlugin_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
            case "btn_reset": {
                if (MessageBoxResult.Yes == e.getResult()) {
                    String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
                    Throwable throwable = null;
                    try (TXHandle tx = TX.required();){
                        BillList billList = (BillList)this.getControl(BILLLISTAP);
                        Object[] selectRows = billList.getSelectedRows().getPrimaryKeyValues();
                        Map mytemplates = BusinessDataServiceHelper.loadFromCache((Object[])selectRows, (String)"bcm_mytemplatelist");
                        if (mytemplates.size() == 0) {
                            return;
                        }
                        try {
                            QFBuilder qfBuilder = new QFBuilder("1", "!=", (Object)1);
                            HashSet templateIds = new HashSet();
                            mytemplates.values().forEach(mytemplate -> {
                                Long orgId = LongUtil.toLong((Object)mytemplate.get("entity.id"));
                                qfBuilder.or(new QFilter("template", "=", (Object)LongUtil.toLong((Object)mytemplate.get("template.id"))).and("org", "=", BcmThreadCache.get((Object)modelNum, (Object)DimTypesEnum.ENTITY.getNumber(), (Object)orgId, () -> MemberReader.change2BaseMember((String)modelNum, (Long)orgId))));
                                templateIds.add(mytemplate.getLong("template.id"));
                            });
                            DeleteServiceHelper.delete((String)"bcm_intergration_entity", (QFilter[])qfBuilder.toArray());
                            DeleteServiceHelper.delete((String)"bcm_orgrpttemplate", (QFilter[])qfBuilder.toArray());
                            QFilter delFilter = new QFilter(MODEL, "=", (Object)this.getModelId());
                            TreeView orgTreeView = (TreeView)this.getControl(TREEVIEW_ORG);
                            String selOrgId = orgTreeView.getTreeState().getFocusNodeId();
                            String orgNumber = MemberReader.findEntityMemberById((String)modelNum, (Long)LongUtil.toLong((Object)selOrgId)).getNumber();
                            delFilter.and("orgnumber", "=", (Object)orgNumber);
                            delFilter.and("template", "in", templateIds);
                            DeleteServiceHelper.delete((String)"bcm_cellformula", (QFilter[])new QFilter[]{delFilter});
                            DeleteServiceHelper.delete((String)"bcm_mytemplate_celllock", (QFilter[])new QFilter[]{delFilter});
                            this.refreshBillList();
                            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8fd8\u539f\u6210\u529f\u3002", (String)"MyTemplatePlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                            mytemplates.values().forEach(mytemplate -> this.writeOperationLog(MyTemplatePlugin.getOperationReduction(), mytemplate.getString(NUMBER), mytemplate.getString("name"), MyTemplatePlugin.getOperationStstusSuccess()));
                        }
                        catch (Throwable e1) {
                            BillList billList2 = (BillList)this.getControl(BILLLISTAP);
                            Object[] selectRows2 = billList2.getSelectedRows().getPrimaryKeyValues();
                            Map mytemplates2 = BusinessDataServiceHelper.loadFromCache((Object[])selectRows2, (String)"bcm_mytemplatelist");
                            mytemplates2.values().forEach(mytemplate -> this.writeOperationLog(MyTemplatePlugin.getOperationReduction(), mytemplate.getString(NUMBER), mytemplate.getString("name"), MyTemplatePlugin.getOperationStstusFail()));
                            tx.markRollback();
                            throw e1;
                        }
                    }
                }
                return;
            }
        }
        super.confirmCallBack(e);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (SEARCH_BEFORE.equals(key) || SEARCH_NEXT.equals(key)) {
            String[] btns = new String[]{SEARCH_BEFORE, SEARCH_NEXT};
            SearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), key, (TreeView)this.getControl(TREEVIEW_ORG), btns, TREEVIEW_ORG);
        }
    }

    private void prepareData(String orgId) {
        String modelId = this.getPageCache().get(modelCacheKey);
        boolean ishaveChild = (Boolean)this.getModel().getValue(ALLSUBORDINATE);
        Set<String> orgSet = this.getOrgCollection(orgId, ishaveChild);
        if (orgSet == null || kd.bos.util.StringUtils.isEmpty((String)modelId)) {
            return;
        }
        this.insertTemplate(modelId, orgSet);
    }

    private Set<String> getOrgCollection(String orgId, boolean ishaveChild) {
        HashSet<String> orglist = new HashSet<String>();
        String tree = this.getPageCache().get(TemplateConstant.TREELIST);
        if (tree == null) {
            return null;
        }
        if (orgId == null) {
            return orglist;
        }
        List treelist = (List)SerializationUtils.fromJsonString((String)tree, List.class);
        HashSet<String> set = new HashSet<String>();
        set.add(orgId);
        if (ishaveChild) {
            HashSet all = new HashSet(16);
            for (Map m : treelist) {
                all.add(m.get("id"));
            }
            for (IDNumberTreeNode child : MemberReader.findEntityMemberById((String)this.getCurModelNumber(), (Long)Long.parseLong(orgId)).getAllChildren()) {
                if (!all.contains(child.getId().toString())) continue;
                set.add(child.getId().toString());
            }
        }
        PermPackageList permMapFromCache = this.getPermMapFromCache();
        for (String oid : set) {
            if (!this.isOrgMemberHavePerm(oid, permMapFromCache)) continue;
            orglist.add(oid);
        }
        return orglist;
    }

    private void deleteTemplateByPageid() {
        String pageid = this.getView().getPageId();
        QFilter qf = new QFilter(PAGE_ID, "=", (Object)pageid);
        DeleteServiceHelper.delete((String)"bcm_mytemplatelist", (QFilter[])new QFilter[]{qf});
    }

    private void insertTemplate(String modelId, Set<String> orgId) {
        Collection<DynamicObject> dyobList = this.getMyTemplatesForOrgs(modelId, orgId);
        if (!CollectionUtils.isEmpty(dyobList)) {
            if (dyobList.size() <= 1000) {
                SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_mytemplatelist"), (Object[])dyobList.toArray());
            } else {
                HashSet temp = Sets.newHashSetWithExpectedSize((int)1000);
                for (DynamicObject dyob : dyobList) {
                    temp.add(dyob);
                    if (temp.size() != 1000) continue;
                    SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_mytemplatelist"), (Object[])temp.toArray());
                    temp.clear();
                }
                if (!CollectionUtils.isEmpty((Collection)temp)) {
                    SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_mytemplatelist"), (Object[])temp.toArray());
                }
            }
        }
    }

    public void refreshTree(String modelId) {
        String showType = this.getPageCache().get(CACHE_SHOWORGTYPE);
        TreeNode treeNode = this.getTreeNodeByModelId(modelId, showType);
        if (treeNode != null) {
            this.initTree(treeNode);
        } else {
            this.clearTree();
        }
    }

    private Set<Long> doPrepareDataForOrg(Set<Long> currentOrgs, String modelId, Map<String, Set<Long>> numberToIdsMap, Map<String, Long> noShareOrgMap, Map<Object, DynamicObject> orgMap, Table<String, String, IDataEntityProperty> form2key2DTProps) {
        orgMap.forEach((k, o) -> {
            String orgNum = o.getString(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_entitymembertree", (String)NUMBER, (DynamicObject)o));
            long orgId = o.getLong(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_entitymembertree", (String)"id", (DynamicObject)o));
            if (Objects.isNull(numberToIdsMap.get(orgNum))) {
                numberToIdsMap.put(orgNum, Sets.newHashSet((Object[])new Long[]{orgId}));
            } else {
                ((Set)numberToIdsMap.get(orgNum)).add(orgId);
            }
        });
        HashSet<Long> orgIdSet = new HashSet<Long>(currentOrgs.size());
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        currentOrgs.forEach(e -> {
            IDNumberTreeNode treeNode = MemberReader.findEntityMemberById((String)modelNum, (Long)e);
            if (treeNode != IDNumberTreeNode.NotFoundTreeNode) {
                IDNumberTreeNode baseTreeNode = treeNode.getBaseTreeNode();
                String orgNum = baseTreeNode.getNumber();
                long orgId = baseTreeNode.getId();
                if (Objects.isNull(noShareOrgMap.get(orgNum))) {
                    noShareOrgMap.put(orgNum, orgId);
                    orgIdSet.add(orgId);
                }
            }
        });
        return orgIdSet;
    }

    private Set<Long> getTemplatesByOrgs(String modelId, Map<Object, DynamicObject> orgMap, Set<Long> orgIdSet, Map<String, Set<Long>> templateIdMap, Map<String, Long> noShareOrgMap, Table<String, String, IDataEntityProperty> form2key2DTProps) {
        Map templateIdsMap = TemplateDistributionOrgUtil.getOrgDisTemplateMap((Object)modelId, orgIdSet);
        HashSet<Long> allTemplateId = new HashSet<Long>(16);
        if (templateIdsMap.isEmpty()) {
            return allTemplateId;
        }
        for (Map.Entry<Object, DynamicObject> entry : orgMap.entrySet()) {
            Set templateIds;
            DynamicObject o = entry.getValue();
            String orgNumber = o.getString(TemplateUtil.getDTProperty(form2key2DTProps, (String)"bcm_entitymembertree", (String)NUMBER, (DynamicObject)o));
            Long orgBaseId = noShareOrgMap.get(orgNumber);
            if (!Objects.nonNull(orgBaseId) || (templateIds = (Set)templateIdsMap.get(orgBaseId)) == null || templateIds.isEmpty()) continue;
            allTemplateId.addAll(templateIds);
            if (templateIdMap.containsKey(orgNumber)) {
                templateIdMap.get(orgNumber).addAll(templateIds);
                continue;
            }
            templateIdMap.put(orgNumber, Sets.newHashSet((Iterable)templateIds));
        }
        form2key2DTProps.clear();
        return allTemplateId;
    }

    private Map<Object, DynamicObject> doPrepareData(Set<Long> allTemplateId, Map<String, DynamicObject> orgTemplateMap, Table<String, String, IDataEntityProperty> form2key2DTProps) {
        Map templateObjs = BusinessDataServiceHelper.loadFromCache((String)"bcm_templateentity", (String)"id,number,name,templatecatalog,versionnumber,effectivedate,expiringdate,usage,status", (QFilter[])new QFilter("id", "in", allTemplateId).toArray());
        if (templateObjs.isEmpty()) {
            return null;
        }
        QFilter filter = new QFilter(MODEL, "=", (Object)this.getModelId()).and("isupdate", "=", (Object)Character.valueOf(OrgRptTemplateUpdateEnum.NO_UPDATE.getCode()));
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"bcm_orgrpttemplate", (String)"template,org,creator,createtime,modifier,modifytime", (QFilter[])filter.toArray());
        for (DynamicObject orgTemplate : objects) {
            orgTemplateMap.put(orgTemplate.getLong(TemplateUtil.getDTProperty(form2key2DTProps, (String)"bcm_orgrpttemplate", (String)"template", (DynamicObject)orgTemplate)) + "-" + orgTemplate.getLong(TemplateUtil.getDTProperty(form2key2DTProps, (String)"bcm_orgrpttemplate", (String)"org", (DynamicObject)orgTemplate)), orgTemplate);
        }
        return templateObjs;
    }

    private Set<DynamicObject> getMyTemplateDyos(Map<String, Set<Long>> templateIdMap, Map<String, Long> noShareOrgMap, Map<String, Set<Long>> numberToIdsMap, Map<Object, DynamicObject> templateObjs, Map<String, DynamicObject> orgTemplateMap, Table<String, String, IDataEntityProperty> form2key2DTProps) {
        HashSet<DynamicObject> dynamicObjectSet = new HashSet<DynamicObject>(16);
        templateIdMap.forEach((orgNumber, tempIds) -> {
            Long orgbaseid = (Long)noShareOrgMap.get(orgNumber);
            ((Set)numberToIdsMap.get(orgNumber)).forEach(k -> {
                for (Long templateId : tempIds) {
                    DynamicObject myTemplateObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_mytemplatelist");
                    myTemplateObj.set("entity", k);
                    myTemplateObj.set("template", (Object)templateId);
                    myTemplateObj.set(PAGE_ID, (Object)this.getView().getPageId());
                    DynamicObject templateObj = (DynamicObject)templateObjs.get(templateId);
                    if (templateObj == null) continue;
                    String number = templateObj.getString(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_templateentity", (String)NUMBER, (DynamicObject)templateObj));
                    myTemplateObj.set(NUMBER, (Object)number);
                    myTemplateObj.set("name", templateObj.get(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_templateentity", (String)"name", (DynamicObject)templateObj)));
                    myTemplateObj.set("templatecatalog", templateObj.get(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_templateentity", (String)"templatecatalog", (DynamicObject)templateObj)));
                    myTemplateObj.set(VERSION_NUMBER, templateObj.get(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_templateentity", (String)VERSION_NUMBER, (DynamicObject)templateObj)));
                    myTemplateObj.set("effectivedate", templateObj.get(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_templateentity", (String)"effectivedate", (DynamicObject)templateObj)));
                    myTemplateObj.set("expiringdate", templateObj.get(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_templateentity", (String)"expiringdate", (DynamicObject)templateObj)));
                    myTemplateObj.set("recordcreatetime", (Object)new Date());
                    myTemplateObj.set("usage", templateObj.get(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_templateentity", (String)"usage", (DynamicObject)templateObj)));
                    myTemplateObj.set("status", templateObj.get(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_templateentity", (String)"status", (DynamicObject)templateObj)));
                    myTemplateObj.set("isorgrpt", (Object)0);
                    String key = templateId + "-" + orgbaseid;
                    DynamicObject orgTemplate = (DynamicObject)orgTemplateMap.get(key);
                    if (orgTemplate != null) {
                        Object creator = orgTemplate.get(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_orgrpttemplate", (String)"creator", (DynamicObject)orgTemplate));
                        Object modifier = orgTemplate.get(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_orgrpttemplate", (String)"modifier", (DynamicObject)orgTemplate));
                        Object createtime = orgTemplate.get(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_orgrpttemplate", (String)"createtime", (DynamicObject)orgTemplate));
                        Object modifytime = orgTemplate.get(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_orgrpttemplate", (String)"modifytime", (DynamicObject)orgTemplate));
                        myTemplateObj.set("creator", creator != null ? creator : modifier);
                        myTemplateObj.set("createtime", createtime != null ? createtime : modifytime);
                        myTemplateObj.set("modifier", modifier);
                        myTemplateObj.set("modifytime", modifytime);
                        myTemplateObj.set("isorgrpt", (Object)1);
                    }
                    dynamicObjectSet.add(myTemplateObj);
                }
            });
        });
        form2key2DTProps.clear();
        return dynamicObjectSet;
    }

    private Collection<DynamicObject> getMyTemplatesForOrgs(String modelId, Set<String> orgIds) {
        HashMap<String, Long> noShareOrgMap;
        HashMap<String, Set<Long>> templateIdMap = new HashMap<String, Set<Long>>(16);
        Set<Long> currentOrgs = orgIds.stream().map(o -> LongUtil.toLong((Object)o)).collect(Collectors.toSet());
        HashBasedTable form2key2DTProps = HashBasedTable.create();
        Map orgMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", currentOrgs)});
        if (orgMap.isEmpty()) {
            return new HashSet<DynamicObject>(16);
        }
        HashMap<String, Set<Long>> numberToIdsMap = new HashMap<String, Set<Long>>(currentOrgs.size());
        Set<Long> orgIdSet = this.doPrepareDataForOrg(currentOrgs, modelId, numberToIdsMap, noShareOrgMap = new HashMap<String, Long>(currentOrgs.size()), orgMap, (Table<String, String, IDataEntityProperty>)form2key2DTProps);
        Set<Long> allTemplateId = this.getTemplatesByOrgs(modelId, orgMap, orgIdSet, templateIdMap, noShareOrgMap, (Table<String, String, IDataEntityProperty>)form2key2DTProps);
        if (allTemplateId.isEmpty()) {
            return new HashSet<DynamicObject>(16);
        }
        HashMap orgTemplateMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<Object, DynamicObject> templateObjs = this.doPrepareData(allTemplateId, orgTemplateMap, (Table<String, String, IDataEntityProperty>)form2key2DTProps);
        if (Objects.isNull(templateObjs)) {
            return new HashSet<DynamicObject>(16);
        }
        return this.getMyTemplateDyos(templateIdMap, noShareOrgMap, numberToIdsMap, templateObjs, orgTemplateMap, (Table<String, String, IDataEntityProperty>)form2key2DTProps);
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.clearSelection();
        billList.setOrderBy("template.sequence asc,number asc");
        billList.refresh();
    }

    protected QFilter getMyTemplateIdsQFilter(QFilter qFilter1) {
        TemplatePermCrossUtil.dealTemplatePermClassFilter((long)this.getModelId(), (QFilter)qFilter1, (boolean)true);
        DynamicObjectCollection values = QueryServiceHelper.query((String)"bcm_mytemplatelist", (String)"id,entity,entity.number,number, versionnumber,template", (QFilter[])qFilter1.toArray());
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)values)) {
            return new QFilter("1", "=", (Object)0);
        }
        HashBasedTable form2key2DTProps = HashBasedTable.create();
        HashSet<Long> ids = new HashSet<Long>(values.size());
        if (this.getPageCache().get("isHideHistory") != null) {
            MyTemplatePlugin.filterVersionMyTemplateTree((Collection<DynamicObject>)values);
        }
        HashSet<Long> templateIds = new HashSet<Long>(values.size());
        HashSet<String> orgIds = new HashSet<String>(values.size());
        HashMap<String, Long> templateAndEntity2MyTemplate = new HashMap<String, Long>(values.size());
        for (DynamicObject mytemplate : values) {
            long templateId = mytemplate.getLong(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_mytemplatelist", (String)"template", (DynamicObject)mytemplate));
            String orgNum = mytemplate.getString(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_mytemplatelist", (String)"entity.number", (DynamicObject)mytemplate));
            long id = mytemplate.getLong(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_mytemplatelist", (String)"id", (DynamicObject)mytemplate));
            templateAndEntity2MyTemplate.put(String.join((CharSequence)"|", String.valueOf(templateId), orgNum), id);
            templateIds.add(templateId);
            orgIds.add(orgNum);
            ids.add(id);
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(ids)) {
            return new QFilter("1", "=", (Object)0);
        }
        boolean needUpdate = (Boolean)this.getModel().getValue(NEEDUPDATE);
        boolean isFinish = (Boolean)this.getModel().getValue(FINISH);
        if (needUpdate || isFinish) {
            QFilter qFilter = new QFilter(MODEL, "=", (Object)this.getModelId());
            qFilter.and("isupdate", "=", (Object)Character.valueOf(OrgRptTemplateUpdateEnum.getCode((!needUpdate ? 1 : 0) != 0)));
            qFilter.and("template", "in", templateIds);
            qFilter.and("org.number", "in", orgIds);
            DynamicObjectCollection myTemplates = QueryServiceHelper.query((String)"bcm_orgrpttemplate", (String)"data,template,org.number", (QFilter[])qFilter.toArray());
            HashSet<Long> myTemplateIds = new HashSet<Long>(16);
            for (DynamicObject t : myTemplates) {
                String key;
                Long myTemplateId;
                if (!kd.bos.util.StringUtils.isNotEmpty((String)t.getString(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_orgrpttemplate", (String)"data", (DynamicObject)t))) || !Objects.nonNull(myTemplateId = (Long)templateAndEntity2MyTemplate.get(key = String.join((CharSequence)"|", String.valueOf(t.getLong(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_orgrpttemplate", (String)"template", (DynamicObject)t))), t.getString(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_orgrpttemplate", (String)"org.number", (DynamicObject)t)))))) continue;
                myTemplateIds.add(myTemplateId);
            }
            ids = myTemplateIds;
        }
        form2key2DTProps.clear();
        return new QFilter("id", "in", ids);
    }

    public static void filterVersionMyTemplateTree(Collection<DynamicObject> templateColls) {
        HashSet passes = new HashSet();
        HashBasedTable form2key2DTProps = HashBasedTable.create();
        Map<String, List<DynamicObject>> templateGroups = templateColls.stream().collect(Collectors.groupingBy(arg_0 -> MyTemplatePlugin.lambda$filterVersionMyTemplateTree$13((Table)form2key2DTProps, arg_0)));
        templateGroups.forEach((arg_0, arg_1) -> MyTemplatePlugin.lambda$filterVersionMyTemplateTree$14(passes, (Table)form2key2DTProps, arg_0, arg_1));
        templateColls.removeIf(arg_0 -> MyTemplatePlugin.lambda$filterVersionMyTemplateTree$15(passes, (Table)form2key2DTProps, arg_0));
        form2key2DTProps.clear();
    }

    private void initTree(TreeNode root) {
        TreeView tree = this.clearTree();
        if (tree == null) {
            return;
        }
        root.setIsOpened(true);
        tree.addNode(root);
        tree.setRootVisible(false);
        String selectId = (String)UserSelectServiceHelper.getEntity((Long)this.getUserId(), (Long)this.getModelId());
        TreeNode selectNode = this.getSelectNode(root, selectId);
        if (selectNode == null || selectNode.getId().equals(root.getId())) {
            selectNode = root.getChildren() == null || root.getChildren().isEmpty() ? root : (TreeNode)root.getChildren().get(0);
            UserSelectServiceHelper.setEntity((Long)this.getUserId(), (Long)this.getModelId(), (Object)selectNode.getId());
        }
        if (!root.getId().equals(selectNode.getId())) {
            this.getPageCache().put(CACHE_SELECTNODE, selectNode.getId());
            Set<String> selectnodes = new HashSet<String>();
            if (this.getPageCache().get(SELECTORGS) != null) {
                selectnodes = (Set)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(SELECTORGS));
            }
            selectnodes.add(selectNode.getId());
            this.getPageCache().put(SELECTORGS, ObjectSerialUtil.toByteSerialized(selectnodes));
            tree.focusNode(selectNode);
            this.expandAllSelected(root, tree);
            this.getPageCache().put(TREEVIEW_ORG, SerializationUtils.toJsonString((Object)root));
        }
    }

    private void expandAllSelected(TreeNode root, TreeView tree) {
        if (this.getPageCache().get(SELECTORGS) != null) {
            Set orgs = (Set)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(SELECTORGS));
            for (String selectid : orgs) {
                TreeNode selectNode = this.getSelectNode(root, selectid);
                if (selectNode == null) continue;
                String parentid = selectNode.getParentid();
                while (parentid != null && !parentid.equals(root.getId()) && !StringUtil.isEmptyString((String)parentid)) {
                    tree.expand(parentid);
                    if (selectNode == null || (parentid = selectNode.getParentid()) == null) continue;
                    selectNode = this.getSelectNode(root, parentid);
                }
            }
        }
    }

    private TreeNode getSelectNode(TreeNode root, String selectId) {
        if (!kd.bos.util.StringUtils.isEmpty((String)selectId)) {
            if (selectId.equals(root.getId())) {
                return root;
            }
            List children = root.getChildren();
            if (children != null && !children.isEmpty()) {
                for (TreeNode child : children) {
                    TreeNode selectNode = this.getSelectNode(child, selectId);
                    if (selectNode == null) continue;
                    return selectNode;
                }
            }
        }
        return null;
    }

    private TreeNode getTreeNodeByModelId(String modelId, String showType) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)modelId)) {
            List<Map<String, String>> rootNodeList = this.getTreeList(modelId);
            this.getPageCache().put(TemplateConstant.TREELIST, SerializationUtils.toJsonString(rootNodeList));
            if (rootNodeList != null) {
                return ReportListUtil.getTree(rootNodeList, showType, false);
            }
        }
        return null;
    }

    private TreeView clearTree() {
        TreeView tree = (TreeView)this.getControl(TREEVIEW_ORG);
        if (tree != null) {
            tree.deleteAllNodes();
        }
        return tree;
    }

    private List<Map<String, String>> getTreeList(String modelid) {
        DynamicObjectCollection doc = this.getOrgDynamicObjectCollection(modelid);
        this.delOrgMenberPerm(doc, modelid);
        return ReportListUtil.getTreeList(doc);
    }

    private void openForm() {
        BillList list = (BillList)this.getControl(BILLLISTAP);
        Object[] pks = list.getSelectedRows().getPrimaryKeyValues();
        if (pks.length > 0) {
            for (Object obt : pks) {
                DynamicObject dyna = list.getModel().loadReferenceData((DynamicObjectType)list.getEntityType(), obt);
                long templateid = dyna.getLong("template.id");
                long orgid = dyna.getLong("entity.id");
                String orgname = dyna.getString("entity.name");
                this.handleOpenProcess(BusinessDataServiceHelper.loadSingle((Object)templateid, (String)"bcm_templateentity"), orgid, orgname);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u8868\u6a21\u677f\u8bb0\u5f55\u3002", (String)"MyTemplatePlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        this.openForm();
        args.setCancel(true);
        BillList list = (BillList)this.getControl(BILLLISTAP);
        Object[] pks = list.getSelectedRows().getPrimaryKeyValues();
        if (pks.length > 0) {
            for (Object obt : pks) {
                DynamicObject dy = list.getModel().loadReferenceData((DynamicObjectType)list.getEntityType(), obt);
                this.writeOperationLog(MyTemplatePlugin.getOperationView(), dy.getString(NUMBER), dy.getString("name"), MyTemplatePlugin.getOperationStstusSuccess());
            }
        }
    }

    @Override
    public void listRowDoubleClick(ListRowClickEvent evt) {
        this.openForm();
        evt.setCancel(true);
    }

    private void handleOpenProcess(DynamicObject dyna, long orgid, String orgname) {
        TemplateModel template = this.constructTemplateModel(dyna);
        boolean isnofi = dyna.getBoolean("isfintemplate");
        if (!isnofi) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u8d22\u52a1\u6a21\u677f\u4e0d\u5141\u8bb8\u7f16\u8f91\u3002", (String)"MyTemplatePlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        } else {
            this.openTemplateProcessPage(template, orgid, orgname);
        }
    }

    private TemplateModel constructTemplateModel(DynamicObject dyna) {
        TemplateModel template = new TemplateModel();
        template.loadDynaObj2Model(dyna);
        return template;
    }

    private void openTemplateProcessPage(TemplateModel template, long orgid, String orgname) {
        IFormView mainPageView = this.getView().getMainView();
        String pageId = this.getView().getPageId() + template.getId() + orgid;
        IFormView parentView = this.getView().getParentView();
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            boolean isNewPage;
            boolean bl = isNewPage = !template.isOldTemplate();
            if (!isNewPage) {
                SaveTemplateUtil.showOldTemplateTips(this.getModelId(), this.getView());
                return;
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bcm_mytemplatemulview");
            formShowParameter.setPageId(pageId);
            formShowParameter.setCustomParam(modelCacheKey, (Object)this.getPageCache().get(modelCacheKey));
            formShowParameter.setCustomParam("listPageID", (Object)this.getView().getPageId());
            formShowParameter.setCustomParam("orgid", (Object)orgid);
            formShowParameter.setCaption(orgname + "-" + template.getName());
            formShowParameter.setCustomParam("template_model", (Object)ObjectSerialUtil.toByteSerialized((Object)template));
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
            formShowParameter.setCustomParam("List_entry", (Object)Boolean.TRUE);
            formShowParameter.setCustomParam("rank", (Object)this.getPageCache().get("rank"));
            formShowParameter.setCustomParam("isOnlyAcct", (Object)"true");
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "processClosedCallBack");
            formShowParameter.setCloseCallBack(closeCallBack);
            if (mainPageView == null) {
                this.getView().showForm(formShowParameter);
                return;
            }
            formShowParameter.setParentPageId(parentView.getPageId());
            formShowParameter.setParentFormId(parentView.getEntityId());
            parentView.showForm(formShowParameter);
            this.getView().sendFormAction(parentView);
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        switch (e.getProperty().getName()) {
            case "model": {
                this.getModel().setValue(ALLSUBORDINATE, (Object)false);
                String modelId = UserSelectUtil.getF7SelectId(this.getView(), MODEL);
                if (modelId == null) {
                    this.getModel().setValue(MODEL, (Object)this.getPageCache().get(modelCacheKey));
                } else {
                    if (modelId.equals(this.getPageCache().get(modelCacheKey))) {
                        return;
                    }
                    UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
                    this.getPageCache().put(modelCacheKey, modelId);
                    this.getModel().setValue(CTL_SHOWORGTYPE, (Object)"4");
                    this.getPageCache().put(CACHE_SHOWORGTYPE, "4");
                    this.deletePageCache();
                    this.initCslschemeValue(modelId, true);
                    this.refreshTree(modelId);
                    if (this.getPageCache().get(CACHE_SELECTNODE) != null) {
                        this.prepareData(this.getPageCache().get(CACHE_SELECTNODE));
                    }
                    this.refreshBillList();
                }
                this.getView().setVisible(Boolean.valueOf(ConfigServiceHelper.getBoolParam((String)this.getCurModelNumber(), (String)"isSupportNewMytemplate")), new String[]{NEEDUPDATE, FINISH});
                break;
            }
            case "cslscheme": {
                this.saveUserChangedCslscheme((DynamicObject)e.getChangeSet()[0].getNewValue());
                String modelId = UserSelectUtil.getF7SelectId(this.getView(), MODEL);
                this.deletePageCache();
                this.refreshTree(modelId);
                if (this.getPageCache().get(CACHE_SELECTNODE) != null) {
                    this.prepareData(this.getPageCache().get(CACHE_SELECTNODE));
                }
                this.refreshBillList();
                break;
            }
            case "needupdate": {
                Object value;
                boolean needUpdate = (Boolean)this.getModel().getValue(NEEDUPDATE);
                boolean isFinish = (Boolean)this.getModel().getValue(FINISH);
                if (!needUpdate || !isFinish) {
                    this.getView().setEnable(Boolean.valueOf(!needUpdate), new String[]{FINISH});
                }
                if ((value = this.getModel().getValue(MODEL)) != null) {
                    this.showUpdate(MemberReader.findModelNumberById((Object)((DynamicObject)value).getLong("id")));
                }
                this.refreshBillList();
                break;
            }
            case "finish": {
                boolean needUpdate1 = (Boolean)this.getModel().getValue(NEEDUPDATE);
                boolean isFinish1 = (Boolean)this.getModel().getValue(FINISH);
                if (!needUpdate1 || !isFinish1) {
                    this.getView().setEnable(Boolean.valueOf(!isFinish1), new String[]{NEEDUPDATE});
                }
                this.refreshBillList();
                break;
            }
            case "allsubordinate": {
                TreeView treeview = (TreeView)this.getControl(TREEVIEW_ORG);
                this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e...", (String)"MyTemplatePlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
                this.deleteTemplateByPageid();
                this.prepareData(treeview.getTreeState().getFocusNodeId());
                this.refreshBillList();
                this.getView().hideLoading();
                break;
            }
            case "showorgtype": {
                String showType = (String)this.getModel().getValue(CTL_SHOWORGTYPE);
                this.getPageCache().put(CACHE_SHOWORGTYPE, showType);
                this.refreshTree(this.getPageCache().get(modelCacheKey));
                break;
            }
        }
    }

    private void deletePageCache() {
        this.deleteTemplateByPageid();
        this.getPageCache().remove(CACHE_SELECTNODE);
        this.getPageCache().remove(SELECTORGS);
        this.getPageCache().remove(TREEVIEW_ORG);
        this.getPageCache().remove("resultlist");
        this.getPageCache().remove("focus");
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.deleteTemplateByPageid();
    }

    private boolean isOrgMemberHavePerm(String memId, PermPackageList permMap) {
        PermEnum permEnum;
        if (Boolean.parseBoolean(this.getPageCache().get("isroot"))) {
            return true;
        }
        if (kd.bos.util.StringUtils.isEmpty((String)memId)) {
            return false;
        }
        if (Objects.isNull(permMap)) {
            permMap = (PermPackageList)SerializationUtils.fromJsonString((String)this.getPageCache().get(PermCacheKey.ORG_PERM_CACHE_KEY), PermPackageList.class);
        }
        return (permEnum = permMap.getPermEnum(memId)) == null || PermEnum.NOPERM != permEnum;
    }

    private void showBtnhistory(Boolean isShowHistory, boolean isClick) {
        this.getView().setVisible(isShowHistory, new String[]{BTN_SHOWHISTORY});
        this.getView().setVisible(Boolean.valueOf(isShowHistory == false), new String[]{BTN_HIDEHISTORY});
        if (isShowHistory.booleanValue()) {
            this.getPageCache().put("isHideHistory", "true");
        } else {
            this.getPageCache().remove("isHideHistory");
        }
        if (isClick) {
            OpNameMultiLangEnumBridge opName = isShowHistory != false ? OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.HIDEHISTORY.getMultiLangEnumBridge(), (String)"Hide HistoryVersion") : OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.SHOWHISTORY.getMultiLangEnumBridge(), (String)"Show HistoryVersion");
            this.writeMultiLangLog(opName, new OPDescMultiLangEnumBridge("%s \u6210\u529f", "MyTemplatePlugin_16", FI_BCM_FORMPLUGIN, new String[]{opName.loadKDString()}));
        }
    }

    private static /* synthetic */ boolean lambda$filterVersionMyTemplateTree$15(Set passes, Table form2key2DTProps, DynamicObject t) {
        return !passes.contains(t.getLong(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_mytemplatelist", (String)"id", (DynamicObject)t)));
    }

    private static /* synthetic */ void lambda$filterVersionMyTemplateTree$14(Set passes, final Table form2key2DTProps, String number, List tmpList) {
        if (tmpList.size() == 1) {
            passes.add(((DynamicObject)tmpList.get(0)).getLong(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_mytemplatelist", (String)"id", (DynamicObject)((DynamicObject)tmpList.get(0)))));
        } else {
            tmpList.sort(new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    return -1 * o1.getBigDecimal(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_mytemplatelist", (String)MyTemplatePlugin.VERSION_NUMBER, (DynamicObject)o1)).compareTo(o2.getBigDecimal(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_mytemplatelist", (String)MyTemplatePlugin.VERSION_NUMBER, (DynamicObject)o2)));
                }
            });
            passes.add(((DynamicObject)tmpList.get(0)).getLong(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_mytemplatelist", (String)"id", (DynamicObject)((DynamicObject)tmpList.get(0)))));
        }
    }

    private static /* synthetic */ String lambda$filterVersionMyTemplateTree$13(Table form2key2DTProps, DynamicObject e) {
        return e.getString(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_mytemplatelist", (String)NUMBER, (DynamicObject)e)) + "_" + e.getLong(TemplateUtil.getDTProperty((Table)form2key2DTProps, (String)"bcm_mytemplatelist", (String)"entity", (DynamicObject)e));
    }
}

