/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.CommonSqlMsgUtil;
import kd.fi.bcm.business.util.MyTemplateUtil;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.template.OrgRptTemplateUpdateEnum;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.multiview.MultiViewTemplateProcess;
import kd.fi.bcm.formplugin.template.multiview.TempFormulaUtil;
import kd.fi.bcm.formplugin.util.NewMyTemplateUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.datacollect.SpecialCalLogic;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.event.EventConstant;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import org.apache.commons.collections.CollectionUtils;

public class MyTemplateProcessPlugin
extends MultiViewTemplateProcess {
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String TEMPLATE = "template";
    private static final String ORG_ID = "orgid";
    private static final String VERSION = "version";
    private static final String BTN_RESTACCT_FORMULA = "btn_restacctformula";

    private static String getOperationReset() {
        return ResManager.loadKDString((String)"\u8fd8\u539f", (String)"MyTemplateProcessPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private static OpNameMultiLangEnumBridge getOperationSaveNew() {
        return new OpNameMultiLangEnumBridge("\u65b0\u589e\u4fdd\u5b58", "MyTemplateProcessPlugin_1", FI_BCM_FORMPLUGIN, "Add Save");
    }

    private static OpNameMultiLangEnumBridge getOperationSave() {
        return new OpNameMultiLangEnumBridge("\u4fdd\u5b58", "MyTemplateProcessPlugin_2", FI_BCM_FORMPLUGIN, "Save");
    }

    private static String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"MyTemplateProcessPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_dimsetting", "btn_areasetting", "btn_membsetting", "btn_membmatch", "btn_floatposition", "btn_import", "btn_baseinfo", "btn_weaveinfo", "btn_stylesetting", "btn_preview"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_setreportdata", "btn_rptparam", "btn_component"});
        this.refreshAcctFormula();
        this.cacheTrueOrFalseFlag("close_window", true);
        if (this.template.isSaveByDim()) {
            MyTemplateProcessPlugin.invokeSpreadMenuItems(this.getClientViewProxy(), this.getSpreadKey(), true);
        }
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), "template_spread");
        invoker.setWorksheetOptions(SpreadProperties.SetWorkSheetOptions.CLIPBOARDOPTIONS.k(), 0);
        long templateId = this.template.getId();
        if (this.isUseNewMyTemplate()) {
            DynamicObject tem = BusinessDataServiceHelper.loadSingle((String)"bcm_templateentity", (String)"data,rptdata", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)});
            SpreadManager dataSpreadManager = JsonSerializerUtil.toSpreadManager((String)tem.getString("data"));
            boolean isDataChange = NewMyTemplateUtil.repairCellIdForSm(dataSpreadManager);
            SpreadManager sm = this.getSpreadModel();
            boolean isRptDataChange = NewMyTemplateUtil.repairCellIdForSm(sm);
            if (isDataChange || isRptDataChange) {
                tem.set("data", (Object)JsonSerializerUtil.toJson((SpreadManager)dataSpreadManager));
                tem.set("rptdata", (Object)JsonSerializerUtil.toJson((SpreadManager)sm));
                BusinessDataWriter.update((IDataEntityType)tem.getDataEntityType(), (Object[])new Object[]{tem});
            }
            this.loadNewMyTemplate();
        }
        SpreadClientInvoker.invokeHideContextMenuItems(this.getClientViewProxy(), "template_spread", MapInitHelper.ofMap((Object)"isHide", (Object)false));
    }

    @Override
    protected boolean isFromMyTemplate() {
        return true;
    }

    @Override
    protected SpreadManager getOrgRptSpreadManager() {
        return this.getSpreadModel();
    }

    @Override
    public String getMutexKey() {
        return this.getTemplateModel().getId() + this.getOrgMemId() + "";
    }

    private static void invokeSpreadMenuItems(IClientViewProxy view, String spreadKey, boolean lockinfo) {
        ArrayList<Map> toolbarItems = new ArrayList<Map>(10);
        toolbarItems.add(MapInitHelper.ofMap((Object)SpreadProperties.LockToolbarItemsMethod.NAME.k(), (Object)SpreadProperties.ToolbarItemNamesEnum.DeleteRowAndCol, (Object)SpreadProperties.LockToolbarItemsMethod.ISLOCK.k(), (Object)lockinfo));
        toolbarItems.add(MapInitHelper.ofMap((Object)SpreadProperties.LockToolbarItemsMethod.NAME.k(), (Object)SpreadProperties.ToolbarItemNamesEnum.InsertRowAndCol, (Object)SpreadProperties.LockToolbarItemsMethod.ISLOCK.k(), (Object)lockinfo));
        SpreadClientInvoker.invokeLockToolbarItems(view, spreadKey, toolbarItems);
        ArrayList<Map> MenuItems = new ArrayList<Map>(10);
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.deleteColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)lockinfo));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.deleteRows, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)lockinfo));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)lockinfo));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertRows, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)lockinfo));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertColMany, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)lockinfo));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertRowMany, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)lockinfo));
        SpreadClientInvoker.invokeHideContextMenuItems(view, spreadKey, MenuItems);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "btn_restacctformula": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u8fd8\u539f\u53d6\u6570\u516c\u5f0f,\u8fd8\u539f\u540e\u5c06\u4f7f\u7528\u62a5\u8868\u6a21\u677f\u6700\u65b0\u7248\u672c\u7684\u53d6\u6570\u516c\u5f0f\uff1f", (String)"MyTemplateProcessPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_RESTACCT_FORMULA, (IFormPlugin)this));
                return;
            }
        }
    }

    @Override
    public void showFormulaView(String json) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_tempformula_view");
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("sm", (Object)JsonSerializerUtil.toJson((SpreadManager)this.getSpreadModel()));
        formShowParameter.setCustomParam("json", (Object)json);
        formShowParameter.setCustomParam("templateId", (Object)this.getTemplateModel().getId());
        formShowParameter.setCustomParam(ORG_ID, (Object)String.valueOf(this.getOrgMemId()));
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        this.getView().showForm(formShowParameter);
    }

    protected void refreshAcctFormula() {
        Table table;
        boolean flag = this.updateSpread();
        if (this.getTemplateModel().isSaveByDim() && !flag && (table = TempFormulaUtil.collectFormulas(this.template, this.getSpreadModel(), (Long)this.getFormCustomParam(ORG_ID))) != null) {
            Map<String, String> managerAndSpreadJson = TempFormulaUtil.dealSpreadManagerAndSpreadJson(table, this.getSpreadModel(), this.template.getRptSpreadJson());
            this.spread = JsonSerializerUtil.toSpreadManager((String)managerAndSpreadJson.get("data"));
            Map resultRowMap = table.rowMap();
            ArrayList<Map<String, Object>> formulapas = new ArrayList<Map<String, Object>>(table.size());
            for (Map.Entry resultRow : resultRowMap.entrySet()) {
                Map resultCVs = (Map)resultRowMap.get(resultRow.getKey());
                for (Map.Entry resultCol : resultCVs.entrySet()) {
                    formulapas.add(SpreadEasyInvoker.packedFormulaCellMap((Integer)resultRow.getKey(), (Integer)resultCol.getKey(), resultCol.getValue().toString().equals("null") ? null : resultCol.getValue().toString()));
                }
            }
            SpreadClientInvoker.invokeSetFormulaMethod(this.getClientViewProxy(), "template_spread", formulapas);
            this.cacheSpreadModel(this.spread);
        }
        if (this.isUseNewMyTemplate()) {
            this.sendShowLockCell();
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        if (MessageBoxResult.Yes == e.getResult()) {
            this.checkPerm(e.getCallBackId());
        }
        switch (callBackId = e.getCallBackId()) {
            case "btn_restacctformula": {
                if (MessageBoxResult.Yes == e.getResult()) {
                    try (TXHandle tx = TX.required();){
                        try {
                            QFilter qf1 = new QFilter(TEMPLATE, "=", (Object)this.getTemplateModel().getId());
                            QFilter qf2 = new QFilter("org", "=", (Object)this.getOrgMemId());
                            DeleteServiceHelper.delete((String)"bcm_intergration_entity", (QFilter[])new QFilter[]{qf1, qf2});
                            DeleteServiceHelper.delete((String)"bcm_orgrpttemplate", (QFilter[])new QFilter[]{qf1, qf2});
                            QFilter delFilter = new QFilter("model", "=", (Object)this.getModelId());
                            String orgNumber = MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)this.getModelId()), (Long)this.getOrgMemId()).getNumber();
                            delFilter.and("orgnumber", "=", (Object)orgNumber);
                            DeleteServiceHelper.delete((String)"bcm_cellformula", (QFilter[])new QFilter[]{qf1, delFilter});
                            DeleteServiceHelper.delete((String)"bcm_mytemplate_celllock", (QFilter[])new QFilter[]{qf1, delFilter});
                            this.refreshAcctFormula();
                            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8fd8\u539f\u6a21\u677f\u6210\u529f\u3002", (String)"MyTemplateProcessPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                            String log = String.format("%s %s,%s%s", this.getTemplateModel().getNumber(), this.getTemplateModel().getName(), MyTemplateProcessPlugin.getOperationReset(), MyTemplateProcessPlugin.getOperationStstusSuccess());
                            OperationLogUtil.writeOperationLog((String)MyTemplateProcessPlugin.getOperationReset(), (String)log, (Long)this.getModelId(), (String)"bcm_mytemplatemulview");
                        }
                        catch (Throwable e1) {
                            tx.markRollback();
                            throw e1;
                        }
                    }
                }
                return;
            }
        }
        super.confirmCallBack(e);
    }

    private boolean updateSpread() {
        DynamicObject orgTmp = MyTemplateUtil.getOwnOrgTemplate((TemplateModel)this.getTemplateModel(), (long)this.getOrgMemId());
        boolean flag = true;
        boolean isNewTemplate = false;
        QFilter qf = new QFilter("id", "=", (Object)this.getTemplateModel().getId()).and("model", "=", (Object)this.getModelId());
        String data = " ";
        if (orgTmp == null) {
            flag = false;
            orgTmp = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"spreadjson,rptdata data", (QFilter[])new QFilter[]{qf});
            data = orgTmp.getString("data");
        } else if (StringUtil.isEmptyString((String)orgTmp.getString("data"))) {
            orgTmp = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"spreadjson,rptdata data", (QFilter[])new QFilter[]{qf});
            SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)orgTmp.getString("data"));
            SpecialCalLogic.loadMyTemplateFormulasAndLocks((SpreadManager)spreadManager, (long)this.getModelId(), (long)this.template.getId(), (long)this.getOrgMemId(), (boolean)false);
            data = JsonSerializerUtil.toJson((SpreadManager)spreadManager);
            isNewTemplate = true;
        } else {
            data = orgTmp.getString("data");
        }
        String spreadjson = orgTmp.getString("spreadjson");
        if (!spreadjson.startsWith("base64")) {
            spreadjson = "base64" + spreadjson;
        }
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), "template_spread", spreadjson);
        if (ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"isSupportNewMytemplate") && (!flag || isNewTemplate)) {
            this.markColorForNewMyTemplate();
        }
        this.spread = null;
        this.getPageCache().put(this.KEY_SPREAD_MODEL, data);
        this.cacheSpreadModel();
        return flag;
    }

    @Override
    protected void initSpreadListener() {
        super.initSpreadListener();
        if (!this.getTemplateModel().isOldTemplate()) {
            this.registerAfterEvent(EventConstant.ActionName.CELL_SELECT, e -> this.displaySelectCellDimCrossInfoUsedByTemplate());
        }
    }

    @Override
    protected void handleSaveEvent() {
        this.invokeSaveEvent();
    }

    private void invokeSaveEvent() {
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("callback", "invokeAction");
        params.put("invokemethod", "actionSave");
        SpreadClientInvoker.invokeGetSpreadJsonMethod(this.getClientViewProxy(), "template_spread", params);
    }

    @Override
    protected long getOrgMemId() {
        if (this.getPageCache().get("baseOrgId") != null) {
            return Long.parseLong(this.getPageCache().get("baseOrgId"));
        }
        long orgId = (Long)this.getFormCustomParam(ORG_ID);
        if (orgId != 0L) {
            orgId = MemberReader.change2BaseMember((String)MemberReader.findModelNumberById((Object)this.getModelId()), (Long)orgId);
            this.getPageCache().put("baseOrgId", Long.toString(orgId));
        }
        return orgId;
    }

    @Override
    public void actionSave(String spreadJson) {
        long modelId = this.getModelId();
        long templateId = this.template.getId();
        long orgId = this.getOrgMemId();
        boolean newMyTemplate = this.isUseNewMyTemplate();
        spreadJson = this.beforeSaveTemplate(spreadJson, false, new ArrayList<Map<String, Object>>(16));
        this.getSpreadModel().setFilter(null);
        TemplateModel template = this.getTemplateModel();
        DynamicObject orgTemplate = this.getOrgTemplate(templateId, orgId);
        if (newMyTemplate) {
            String orgNumber = MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)orgId).getNumber();
            SpreadManager sm = this.getSpreadModel();
            NewMyTemplateUtil.saveMyTemplateDyos(modelId, templateId, orgNumber, sm, false);
            this.cacheSpreadModel(sm);
        } else {
            String serial = JsonSerializerUtil.toJson((SpreadManager)this.getSpreadModel());
            orgTemplate.set("spreadjson", (Object)spreadJson);
            orgTemplate.set("data", (Object)serial);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{orgTemplate});
        Object isNew = this.getFormCustomParam("isNew");
        if (null != isNew) {
            this.writeOperationLog(MyTemplateProcessPlugin.getOperationSaveNew(), template.getNumber(), template.getName(), MyTemplateProcessPlugin.getOperationStstusSuccess());
        } else {
            this.writeOperationLog(MyTemplateProcessPlugin.getOperationSave(), template.getNumber(), template.getName(), MyTemplateProcessPlugin.getOperationStstusSuccess());
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"MyTemplateProcessPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        this.getPageCache().remove("isModified");
        if (newMyTemplate) {
            this.markColorForNewMyTemplate();
        }
    }

    private void loadNewMyTemplate() {
        List cells = SpecialCalLogic.loadMyTemplateFormulasAndLocks((SpreadManager)this.getSpreadModel(), (long)this.getModelId(), (long)this.getTemplateModel().getId(), (long)this.getOrgMemId(), (boolean)false);
        ArrayList<Map<String, Object>> formulapas = new ArrayList<Map<String, Object>>(cells.size());
        ArrayList cellLocks = new ArrayList(cells.size());
        ArrayList cellUnLocks = new ArrayList(cells.size());
        for (Cell cell : cells) {
            if (cell.getFormula() != null) {
                formulapas.add(SpreadEasyInvoker.packedFormulaCellMap(cell.getRow(), cell.getCol(), StringUtils.isNotEmpty((String)cell.getFormula()) ? cell.getFormula() : null));
            }
            if (cell.getUserObject("locked") == null) continue;
            HashMap<String, Integer> map = new HashMap<String, Integer>(16);
            map.put(SpreadProperties.UnlockCellMethod.R.k(), cell.getRow());
            map.put(SpreadProperties.UnlockCellMethod.C.k(), cell.getCol());
            map.put(SpreadProperties.UnlockCellMethod.RC.k(), 1);
            map.put(SpreadProperties.UnlockCellMethod.CC.k(), 1);
            if (cell.isLock()) {
                cellLocks.add(map);
                continue;
            }
            cellUnLocks.add(map);
        }
        if (CollectionUtils.isNotEmpty(formulapas)) {
            SpreadClientInvoker.invokeSetFormulaMethod(this.getClientViewProxy(), "template_spread", formulapas);
        }
        if (CollectionUtils.isNotEmpty(cellLocks)) {
            SpreadClientInvoker.invokeLockCellMethod(this.getClientViewProxy(), "template_spread", cellLocks);
        }
        if (CollectionUtils.isNotEmpty(cellUnLocks)) {
            SpreadClientInvoker.invokeUnLockCellMethod(this.getClientViewProxy(), "template_spread", cellUnLocks);
        }
        this.cacheSpreadModel();
        SpreadClientInvoker.invokeLockAllToolbarItems(this.getClientViewProxy(), this.getSpreadKey(), true);
        SpreadClientInvoker.invokeLockToolbarItems(this.getClientViewProxy(), this.getSpreadKey(), Collections.singletonList(MapInitHelper.ofMap((Object)SpreadProperties.LockToolbarItemsMethod.NAME.k(), (Object)SpreadProperties.ToolbarItemNamesEnum.LockCells, (Object)SpreadProperties.LockToolbarItemsMethod.ISLOCK.k(), (Object)false)));
    }

    @Override
    protected void refreshFromulas() {
        DynamicObject dyna = BusinessDataReader.loadSingle((Object)this.getTemplateModel().getId(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_templateentity"));
        TemplateModel templateModel = new TemplateModel();
        templateModel.loadDynaObj2Model(dyna);
        this.template = null;
        this.cacheTemplateModel(templateModel);
        if (this.isUseNewMyTemplate()) {
            this.spread = null;
            SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), "template_spread", templateModel.getSpreadJson());
            this.cacheSpreadModel(JsonSerializerUtil.toSpreadManager((String)templateModel.getData()));
            this.loadNewMyTemplate();
            this.markColorForNewMyTemplate();
            this.sendShowLockCell();
            return;
        }
        DynamicObject dynamicObject = MyTemplateUtil.getOwnOrgTemplate((TemplateModel)this.getTemplateModel(), (long)this.getOrgMemId());
        if (dynamicObject != null && StringUtils.isNotEmpty((String)dynamicObject.getString("data")) && StringUtils.isNotEmpty((String)dynamicObject.getString("spreadjson"))) {
            this.cacheSpreadModel(JsonSerializerUtil.toSpreadManager((String)dynamicObject.getString("data")));
            SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), "template_spread", dynamicObject.getString("spreadjson"));
        }
    }

    private void markColorForNewMyTemplate() {
        IDNumberTreeNode orgMember = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_entitymembertree", (Long)this.getOrgMemId());
        TempFormulaUtil.markColor(this.getModelId(), this.getSpreadModel(), this.getClientViewProxy(), "template_spread", this.getTemplateModel().getId(), orgMember.getNumber());
    }

    private boolean isUseNewMyTemplate() {
        return (Boolean)ThreadCache.get((Object)("isUseNewMyTemplate_" + this.getModelId()), () -> {
            DynamicObject dyo;
            if (ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"isSupportNewMytemplate") && ((dyo = MyTemplateUtil.getOwnOrgTemplate((TemplateModel)this.getTemplateModel(), (long)this.getOrgMemId())) == null || StringUtil.isEmptyString((String)dyo.getString("data")))) {
                return true;
            }
            return false;
        });
    }

    private DynamicObject getOrgTemplate(long templateId, long orgId) {
        DynamicObject obj;
        int version = this.template.getVersionNumber().intValue();
        QFilter versionfilter = new QFilter(VERSION, ">", (Object)(version * 100)).and(VERSION, "<", (Object)((version + 1) * 100));
        QFilter filter = new QFilter(TEMPLATE, "=", (Object)this.template.getId()).and("org", "=", (Object)this.getOrgMemId()).and("isupdate", "=", (Object)Character.valueOf(OrgRptTemplateUpdateEnum.NO_UPDATE.getCode()));
        DynamicObject[] docs = BusinessDataServiceHelper.load((String)"bcm_orgrpttemplate", (String)"spreadjson,data,modifier,modifytime,creator,createtime,isorgrpt, isupdate", (QFilter[])new QFilter[]{filter, versionfilter}, (String)"version desc");
        if (docs.length > 0) {
            obj = docs[0];
            CommonSqlMsgUtil.modifi((DynamicObject)obj);
            if (obj.get("creator") == null || obj.get("creator") == "0") {
                CommonSqlMsgUtil.create((DynamicObject)obj);
            }
        } else {
            obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_orgrpttemplate");
            obj.set("model", (Object)this.getModelId());
            obj.set(TEMPLATE, (Object)templateId);
            obj.set("org", (Object)orgId);
            obj.set(VERSION, (Object)(version * 100 + 1));
            obj.set("status", (Object)1);
            obj.set("isupdate", (Object)Character.valueOf(OrgRptTemplateUpdateEnum.NO_UPDATE.getCode()));
            CommonSqlMsgUtil.create((DynamicObject)obj);
        }
        obj.set("isorgrpt", (Object)1);
        return obj;
    }

    @Override
    public void spreadF7Click(int row, int col) {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4e2a\u6027\u5316\u4fee\u6539\u6210\u5458\uff0c\u8bf7\u5230\u57fa\u7840\u6a21\u677f\u4e2d\u4fee\u6539\u3002", (String)"MyTemplateProcessPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
    }

    @Override
    public void spreadF7LookUpData(LookUpDataArgs args) {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4e2a\u6027\u5316\u4fee\u6539\u6210\u5458\uff0c\u8bf7\u5230\u57fa\u7840\u6a21\u677f\u4e2d\u4fee\u6539\u3002", (String)"MyTemplateProcessPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
    }
}

