/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassCache;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.MyTaskStatusHelper;
import kd.fi.bcm.business.template.TemplatePermCrossUtil;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.TemplateRangeService;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.datatypeutil.DataTypeConvertUtil;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.report.multi.ModelDataProvider;
import kd.fi.bcm.formplugin.template.SearchResult;
import kd.fi.bcm.formplugin.util.ReportListUtil;
import org.apache.commons.collections.CollectionUtils;

public class TempDisCycleTablePlugin
extends AbstractBaseFormPlugin {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String MODEL = "model";
    private static final String GROUP = "group";
    private static final String ENTITY = "entity";
    private static final String TEMPLATE = "template";
    private static final String ROOT_NODE = "rootNode";
    private static final String CYCLETABLE = "cycletable";
    private static final String TEMPLATE_NAME = "template.name";
    private static final String TEMPLATE_NUM = "template.number";
    private static final String CACHE_SEARCH = "cache_search";
    private static final String TEMPLATE_IDS = "templeteids";
    private static final String BILL_LIST_AP = "billlistap";
    public static final String temCatalog_treeID = "temcatalogtree";
    private static final String CYCLETABLE_COMBO = "cycletablecombo";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private final TreeNodeCheckListener treeNodeCheckListener = new TreeNodeCheckListener(){

        public void treeNodeCheck(TreeNodeCheckEvent evt) {
            TempDisCycleTablePlugin.this.refreshBillList();
        }
    };
    private final SetFilterListener setFilterListener = new SetFilterListener(){

        public void setFilter(SetFilterEvent evt) {
            List filters = evt.getQFilters();
            QFilter filter = TempDisCycleTablePlugin.this.getTemQueryFilter();
            if (filter == null) {
                filters.add(new QFilter("1", "=", (Object)1));
            } else {
                filters.add(filter);
            }
            evt.setOrderBy("template.sequence,template.number,template.versionnumber,template.name,cycletable.name,cycletable.belongtask");
        }
    };

    private static OpNameMultiLangEnumBridge getOperationSend() {
        return new OpNameMultiLangEnumBridge("\u5206\u914d", "DistributionPlugin_0", FI_BCM_FORMPLUGIN, "Allocate");
    }

    private static OpNameMultiLangEnumBridge getOperationBackSend() {
        return new OpNameMultiLangEnumBridge("\u53cd\u5206\u914d", "DistributionPlugin_20", FI_BCM_FORMPLUGIN, "Anti allocate");
    }

    private static final String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"DistributionPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private static final String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"DistributionPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addListeners();
    }

    private QFilter getTemQueryFilter() {
        List<Long> rows = this.getTemSelectedAndResultList(temCatalog_treeID);
        DynamicObjectCollection temDis = this.getTemDis(true);
        ArrayList<String> temNum = new ArrayList<String>(16);
        for (DynamicObject temdis : temDis) {
            for (Long templateId : rows) {
                if (!templateId.equals(temdis.getLong(TEMPLATE))) continue;
                temNum.add(temdis.getString(TEMPLATE_NUM));
            }
        }
        for (DynamicObject temdis : temDis) {
            if (!temNum.contains(temdis.getString(TEMPLATE_NUM))) continue;
            rows.add(temdis.getLong(TEMPLATE));
        }
        QFilter filter = null;
        if (!rows.isEmpty()) {
            filter = new QFilter(TEMPLATE, "in", (Object)rows.toArray());
        }
        return filter;
    }

    private void addListeners() {
        this.addClickListeners("deletedistribution", "imageup", "imagedown");
        this.addItemClickListeners("toolbarap");
        TreeView tree = (TreeView)this.getControl(temCatalog_treeID);
        tree.addTreeNodeCheckListener(this.treeNodeCheckListener);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.addSetFilterListener(this.setFilterListener);
        Search se = (Search)this.getControl("searchap");
        se.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent var1) {
                String text = var1.getText();
                if (text != null && !"".equals(text)) {
                    TempDisCycleTablePlugin.this.searchTemplate(text.trim());
                } else {
                    TempDisCycleTablePlugin.this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                }
            }
        });
    }

    private void searchTemplate(String search) {
        TreeView tree = (TreeView)this.getControl(temCatalog_treeID);
        String rootNodeCache = this.getPageCache().get(ROOT_NODE);
        if (rootNodeCache != null) {
            TreeNode root = (TreeNode)ObjectSerialUtil.deSerializedBytes((String)rootNodeCache);
            ArrayList<TreeNode> hitNode = new ArrayList<TreeNode>(16);
            root.getTreeNodeListByText(hitNode, search, 999);
            SearchResult result = null;
            if (!hitNode.isEmpty()) {
                result = new SearchResult(hitNode);
                TreeNode next = result.next(1);
                tree.checkNode(next);
                this.refreshBillList();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5173\u8282\u70b9\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u540d\u79f0\u5e76\u91cd\u65b0\u641c\u7d22\u3002", (String)"TempDisCycleTablePlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            this.getPageCache().put(CACHE_SEARCH, result == null ? null : ObjectSerialUtil.toByteSerialized((Object)result));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_distribute": {
                this.distributeMember(new ArrayList<Long>(16));
                break;
            }
            case "autodis": {
                this.autoDisMember();
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "imageup": {
                this.searchNext(-1);
                break;
            }
            case "imagedown": {
                this.searchNext(1);
                break;
            }
            case "deletedistribution": {
                this.deleteDistribution();
            }
        }
    }

    private void searchNext(int i) {
        IPageCache pageCache = this.getPageCache();
        String searchResultCache = pageCache.get(CACHE_SEARCH);
        if (searchResultCache != null) {
            SearchResult result = (SearchResult)ObjectSerialUtil.deSerializedBytes((String)searchResultCache);
            TreeNode next = result.next(i);
            TreeView tree = (TreeView)this.getControl(temCatalog_treeID);
            if (next == null) {
                if (i > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"TempDisCycleTablePlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"TempDisCycleTablePlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                }
            } else {
                tree.checkNode(next);
                tree.treeNodeClick(next.getParentid(), next.getId());
                pageCache.put(CACHE_SEARCH, ObjectSerialUtil.toByteSerialized((Object)result));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"TempDisCycleTablePlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private void deleteDistribution() {
        BillList billlist = (BillList)this.getControl(BILL_LIST_AP);
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u53cd\u5206\u914d\u8bb0\u5f55\u7684\u6570\u636e\u884c\u3002", (String)"TempDisCycleTablePlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u53cd\u5206\u914d\u3002", (String)"TempDisCycleTablePlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_comfirm", (IFormPlugin)this));
    }

    private void distributeMember(List<Long> temList) {
        if (temList.isEmpty()) {
            temList = this.getTemSelectedAndResultList(temCatalog_treeID);
        }
        if (temList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u6a21\u677f\u3002", (String)"TempDisCycleTablePlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        QFilter qcf = new QFilter(ID, "in", temList);
        DynamicObjectCollection data = QueryServiceHelper.query((String)"bcm_templateentity", (String)"name,number", (QFilter[])new QFilter[]{qcf});
        try {
            for (int i = 0; i < data.size(); ++i) {
                this.writeOperationLog(TempDisCycleTablePlugin.getOperationSend(), ((DynamicObject)data.get(i)).getString(NUMBER), ((DynamicObject)data.get(i)).getString(NAME), TempDisCycleTablePlugin.getOperationStstusSuccess());
            }
            this.checkListForCt(temList);
            this.saveDistributeRecord(this.getDisList(temList), temList);
        }
        catch (Exception e) {
            for (int i = 0; i < data.size(); ++i) {
                this.writeOperationLog(TempDisCycleTablePlugin.getOperationSend(), ((DynamicObject)data.get(i)).getString(NUMBER), ((DynamicObject)data.get(i)).getString(NAME), TempDisCycleTablePlugin.getOperationStstusFail());
            }
            throw e;
        }
    }

    private void checkListForCt(List<Long> temList) {
        Object cycletable = this.getModel().getValue(CYCLETABLE_COMBO);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_cycletable", (String)"id,scenario,scenario.name", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)LongUtil.toLong((Object)cycletable))});
        if (dynamicObject != null) {
            ArrayList<String> errorTemplateName = new ArrayList<String>(16);
            Set temSet = temList.stream().collect(Collectors.toSet());
            for (Long id : temSet) {
                TemplateModel templateModel = ModelDataProvider.getTemplateModel(id);
                if (TemplateRangeService.isInnerRange((String)"bcm_scenemembertree", (TemplateModel)templateModel, (Object)dynamicObject.getLong("scenario"))) continue;
                temList.remove(templateModel.getId());
                errorTemplateName.add(templateModel.getName());
            }
            if (!errorTemplateName.isEmpty()) {
                this.getPageCache().put("errorTemplateName", ObjectSerialUtil.toByteSerialized(errorTemplateName));
                this.getPageCache().put("cycletablename", dynamicObject.getString("scenario.name"));
            }
        }
    }

    private List<DynamicObject> getDisList(List<Long> temList) {
        Object cycletable = this.getModel().getValue(CYCLETABLE_COMBO);
        ArrayList<DynamicObject> disList = new ArrayList<DynamicObject>(16);
        for (Long tem : temList) {
            DynamicObject distribute = BusinessDataServiceHelper.newDynamicObject((String)"bcm_tempdiscycletable");
            distribute.set(MODEL, (Object)this.getModelId());
            distribute.set(CYCLETABLE, cycletable);
            distribute.set(TEMPLATE, (Object)tem);
            disList.add(distribute);
        }
        return disList;
    }

    private void saveDistributeRecord(List<DynamicObject> disList, List<Long> temList) {
        long modelid = this.getModelId();
        QFilter filter = new QFilter(MODEL, "=", (Object)modelid);
        QFilter temFilter = new QFilter(TEMPLATE, "in", temList);
        QFilter[] filters = new QFilter[]{filter, temFilter};
        String selectFields = "id, model, cycletable, template";
        DynamicObjectCollection oldDisData = QueryServiceHelper.query((String)"bcm_tempdiscycletable", (String)selectFields, (QFilter[])filters);
        block12: for (DynamicObject dis : oldDisData) {
            int index = 0;
            for (DynamicObject newDis : disList) {
                if (dis.getLong(TEMPLATE) == newDis.getLong(TEMPLATE) && dis.getLong(CYCLETABLE) == newDis.getLong(CYCLETABLE)) {
                    disList.remove(index);
                    continue block12;
                }
                ++index;
            }
        }
        if (disList.isEmpty()) {
            this.showTips();
            return;
        }
        try (TXHandle tx = TX.required((String)"bcm_actionsave");){
            try {
                this.copyVersionDistribute(disList);
                DynamicObject[] newdoc = disList.toArray(new DynamicObject[disList.size()]);
                Object[] oo = SaveServiceHelper.save((DynamicObject[])newdoc);
                Long[] templateids = new Long[newdoc.length];
                int i = 0;
                for (DynamicObject dd : newdoc) {
                    Long tempid;
                    templateids[i] = tempid = Long.valueOf(dd.getLong(TEMPLATE));
                    ++i;
                }
                MyTaskStatusHelper.refreshTaskStatusRecord4TempleteID((Long[])templateids);
                if (oo.length > 0) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"TempDisCycleTablePlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                }
                this.showTips();
            }
            catch (KDBizException e) {
                tx.markRollback();
                throw e;
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
        this.refreshBillList();
    }

    private void showTips() {
        if (this.getPageCache().get("errorTemplateName") != null && this.getPageCache().get("cycletablename") != null) {
            List errorTemplateName = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("errorTemplateName"));
            String ctcyleName = this.getPageCache().get("cycletablename");
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u6a21\u677f\u4e2d\u60c5\u666f\u4e0d\u5305\u542b%2$s\uff0c\u5206\u914d\u5931\u8d25\u3002", (String)"TempDisCycleTablePlugin_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), errorTemplateName.toString(), ctcyleName));
            this.getPageCache().remove("errorTemplateName");
            this.getPageCache().remove("cycletablename");
        }
    }

    public void copyVersionDistribute(List<DynamicObject> disList) {
        DynamicObject cycleTable = this.getCycleTable();
        HashSet templateIds = Sets.newHashSet();
        HashMap tpl2Group = Maps.newHashMap();
        HashBasedTable tpl2group2tpl = HashBasedTable.create();
        ArrayListMultimap id2Dyn = ArrayListMultimap.create();
        disList.forEach(arg_0 -> TempDisCycleTablePlugin.lambda$copyVersionDistribute$0(templateIds, (Multimap)id2Dyn, arg_0));
        try (DataSet templateDs = QueryServiceHelper.queryDataSet((String)"TempDisCycleTablePlugin", (String)"bcm_templateentity", (String)"id, group", (QFilter[])new QFilter(ID, "in", (Object)templateIds).toArray(), null);){
            templateDs.forEach(ds -> tpl2Group.put(ds.getLong(GROUP), ds.getLong(ID)));
        }
        templateDs = QueryServiceHelper.queryDataSet((String)"TempDisCycleTablePlugin", (String)"bcm_templateentity", (String)"id, group", (QFilter[])new QFilter(GROUP, "in", tpl2Group.keySet()).toArray(), null);
        var8_8 = null;
        try {
            templateDs.forEach(arg_0 -> TempDisCycleTablePlugin.lambda$copyVersionDistribute$2(cycleTable, (Table)tpl2group2tpl, tpl2Group, arg_0));
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (templateDs != null) {
                if (var8_8 != null) {
                    try {
                        templateDs.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    templateDs.close();
                }
            }
        }
        tpl2group2tpl.cellSet().forEach(arg_0 -> this.lambda$copyVersionDistribute$4((Multimap)id2Dyn, disList, arg_0));
    }

    private List<Long> getTemSelectedAndResultList(String entityid) {
        TreeView tree = (TreeView)this.getControl(entityid);
        List tids = tree.getTreeState().getSelectedNodeId();
        if (tids.isEmpty()) {
            String cache = this.getPageCache().get(TEMPLATE_IDS);
            tids = StringUtils.isNotEmpty((CharSequence)cache) ? (List)SerializationUtils.fromJsonString((String)cache, List.class) : new ArrayList(16);
            this.getPageCache().remove(TEMPLATE_IDS);
        }
        DynamicObjectCollection doc = this.getTemplatecatalogList();
        LinkedList<String> clist = new LinkedList<String>();
        for (DynamicObject dd : doc) {
            clist.add(dd.getString(ID));
        }
        tids.removeAll(clist);
        return DataTypeConvertUtil.convert(tids);
    }

    private void autoDisMember() {
        List<Long> templateIds = new ArrayList<Long>(16);
        String tempIds = this.getPageCache().get("tempIds");
        if (!StringUtils.isEmpty((CharSequence)tempIds)) {
            templateIds = (List)SerializationUtils.fromJsonString((String)tempIds, List.class);
        }
        this.distributeMember(templateIds);
    }

    private void refreshBillList() {
        BillList billlist = (BillList)this.getControl(BILL_LIST_AP);
        billlist.addSetFilterListener(this.setFilterListener);
        billlist.refresh();
        billlist.clearSelection();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long modelid = this.getModelId();
        this.setcycleTableComboEdit();
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelid));
        if (modelid != 0L) {
            this.setTempalteDate2View(modelid, null, (String)this.getView().getFormShowParameter().getCustomParam("cycletableid"));
        }
        FilterParameter fp = new FilterParameter();
        QFilter filter = new QFilter(MODEL, "=", (Object)modelid);
        QFilter ctFilter = new QFilter(CYCLETABLE, "=", (Object)LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("cycletableid")));
        fp.setFilter(filter.and(ctFilter));
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        billList.setFilterParameter(fp);
        billList.addSetFilterListener(this.setFilterListener);
    }

    private Map<String, String> setcycleTableComboEdit() {
        QFilter qFilter = new QFilter(MODEL, "=", (Object)this.getModelId());
        qFilter = qFilter.and(new QFilter("parent.id", "!=", (Object)0));
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)"bcm_cycletable", (String)"id,name,number,scenario,parent", (QFilter[])new QFilter[]{qFilter}, (String)"sequence");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        HashMap<String, String> idScenarioMap = new HashMap<String, String>(16);
        if (CollectionUtils.isNotEmpty((Collection)dcs)) {
            List noPerms = new ArrayList(16);
            boolean adminUserBol = MemberPermHelper.isModelManager((Long)this.getModelId());
            if (!adminUserBol) {
                PermClassCache.cacheNewPermission((IPageCache)this.getPageCache(), (String)"bcm_cycletable", (String)String.valueOf(this.getModelId()));
                noPerms = PermClassCache.getPermissionMap((IPageCache)this.getPageCache(), (String)"bcm_cycletable", (DataTypeEnum)DataTypeEnum.NO);
            }
            for (DynamicObject cycletable : dcs) {
                if (!adminUserBol && noPerms.contains(cycletable.getLong(ID))) continue;
                items.add(new ComboItem(new LocaleString(cycletable.getString(NAME)), cycletable.getString(ID)));
                idScenarioMap.put(cycletable.getString(ID), cycletable.getString("scenario"));
            }
        }
        ComboEdit edit = (ComboEdit)this.getView().getControl(CYCLETABLE_COMBO);
        edit.setComboItems(items);
        String cycletableid = (String)this.getView().getFormShowParameter().getCustomParam("cycletableid");
        this.getModel().setValue(CYCLETABLE_COMBO, (Object)cycletableid);
        this.getPageCache().put("idscenariomap", this.toByteSerialized(idScenarioMap));
        return idScenarioMap;
    }

    private void setTempalteDate2View(long modelid, String scenario, String cycletableId) {
        DynamicObjectCollection temlist = this.getTemplateColls(modelid, scenario, cycletableId);
        TreeNode rootview = ReportListUtil.getTemplateTree(this.mergeTemplatecatalogList(modelid), temlist, new ArrayList<TreeNode>(8), "0", new TreeNode());
        this.getPageCache().put(ROOT_NODE, ObjectSerialUtil.toByteSerialized((Object)rootview));
        TreeView tree = (TreeView)this.getControl(temCatalog_treeID);
        BCMTreeUtils.spreadAllNode((TreeNode)rootview);
        List rows = (List)this.getView().getFormShowParameter().getCustomParam("rows");
        ArrayList<TreeNode> selNodes = new ArrayList<TreeNode>(16);
        List<Long> templateIds = temlist.stream().map(o -> o.getLong(ID)).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> templateDimensionMap = this.getTemplateDimension(templateIds);
        for (DynamicObject dd : temlist) {
            if (rows != null && rows.contains(dd.getString(NUMBER))) {
                TreeNode node = rootview.getTreeNode(dd.getString(ID), 10);
                selNodes.add(node);
            }
            for (DynamicObject dim : templateDimensionMap.get(dd.getLong(ID))) {
                TreeNode node;
                if (ENTITY.equals(dim.getString("mnumber"))) {
                    node = rootview.getTreeNode(dd.getString(ID), 10);
                    if (node == null) continue;
                    node.setColor("#999999");
                    continue;
                }
                node = rootview.getTreeNode(dd.getString(ID), 10);
                if (node == null) continue;
                node.setColor("#333333");
            }
        }
        tree.addNode(rootview);
        if (!selNodes.isEmpty()) {
            tree.checkNodes(selNodes);
            this.getPageCache().put(TEMPLATE_IDS, SerializationUtils.toJsonString(selNodes.stream().map(selNode -> selNode.getId()).collect(Collectors.toList())));
        }
        this.getPageCache().put("tempIds", SerializationUtils.toJsonString(templateIds));
    }

    private DynamicObjectCollection getTemplateColls(long modelid, String scenarioId, String cycletableId) {
        QFilter filter = TemplatePermCrossUtil.getCommonTemplateQfilter((boolean)false, (Long)modelid, (boolean)true);
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id, name, templatecatalog, number, group";
        DynamicObjectCollection templateObjs = QueryServiceHelper.query((String)"bcm_templateentity", (String)selectFields, (QFilter[])filters, (String)"sequence,number asc,versionnumber asc");
        DynamicObjectCollection result = new DynamicObjectCollection();
        HashSet groupIds = Sets.newHashSet();
        if (scenarioId == null) {
            String idScenarioMapStr = this.getPageCache().get("idscenariomap");
            Map idScenarioMap = (Map)this.deSerializedBytes(idScenarioMapStr);
            scenarioId = (String)idScenarioMap.get(this.getView().getFormShowParameter().getCustomParam("cycletableid"));
        }
        for (DynamicObject temp : templateObjs) {
            Long groupId = temp.getLong(GROUP);
            TemplateModel templateModel = ModelDataProvider.getTemplateModel(temp.getLong(ID));
            boolean innerRange = TemplateRangeService.isInnerRange((String)"bcm_scenemembertree", (TemplateModel)templateModel, (Object)LongUtil.toLong((Object)scenarioId));
            if (!innerRange || !groupIds.add(groupId)) continue;
            result.add((Object)temp);
        }
        DynamicObjectCollection removeTemp = new DynamicObjectCollection();
        DynamicObjectCollection temDis = this.getTemDis(false);
        for (DynamicObject temp : result) {
            for (DynamicObject temdis : temDis) {
                if (!temp.getString(NUMBER).equals(temdis.getString(TEMPLATE_NUM)) || cycletableId.equals(temdis.getString(CYCLETABLE))) continue;
                removeTemp.add((Object)temp);
            }
        }
        result.removeAll((Collection)removeTemp);
        return result;
    }

    private Map<Long, List<DynamicObject>> getTemplateDimension(List<Long> temIds) {
        QFilter filter = new QFilter(ID, "in", temIds);
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id,viewpointmembentry.viewdimension.number as mnumber";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_templateentity", (String)selectFields, (QFilter[])filters);
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject obj : query) {
            Long key = obj.getLong(ID);
            List dynamicObjects = (List)result.get(key);
            if (dynamicObjects == null) {
                dynamicObjects = Lists.newArrayListWithExpectedSize((int)16);
            }
            dynamicObjects.add(obj);
            result.put(key, dynamicObjects);
        }
        return result;
    }

    private List<Map<String, String>> mergeTemplatecatalogList(long modelid) {
        DynamicObjectCollection doc = this.getTemplatecatalogList();
        ArrayList<Map<String, String>> clist = new ArrayList<Map<String, String>>(16);
        for (DynamicObject dd : doc) {
            if ("0".equals(dd.getString("parent")) && (dd.getString("longnumber") == null || dd.getString("longnumber") == "")) continue;
            HashMap<String, String> map = new HashMap<String, String>(1);
            map.put(ID, dd.getString(ID));
            map.put(NAME, dd.getString(NAME));
            map.put("parentid", dd.getString("parent"));
            clist.add(map);
        }
        return clist;
    }

    private DynamicObjectCollection getTemplatecatalogList() {
        QFilter filter = new QFilter(MODEL, "=", (Object)this.getModelId());
        QFilter[] filters = new QFilter[]{filter, TemplateCatalogTypeEnum.getTemplateCalcogFilter()};
        String selectFields = "id,parent,name,longnumber";
        String orderBys = "longnumber";
        return QueryServiceHelper.query((String)"bcm_templatecatalog", (String)selectFields, (QFilter[])filters, (String)orderBys);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "cycletablecombo": {
                String cycletableId = this.getModel().getValue(CYCLETABLE_COMBO).toString();
                DynamicObject cycleTable = this.getCycleTable();
                TreeView tree = (TreeView)this.getControl(temCatalog_treeID);
                tree.deleteAllNodes();
                this.setTempalteDate2View(this.getModelId(), cycleTable.getString("scenario"), cycletableId);
                this.getView().updateView();
                FilterParameter fp = new FilterParameter();
                QFilter filter = new QFilter(MODEL, "=", (Object)this.getModelId());
                fp.setFilter(filter.and(new QFilter(CYCLETABLE, "=", (Object)LongUtil.toLong((Object)cycletableId))));
                BillList billList = (BillList)this.getControl(BILL_LIST_AP);
                billList.setFilterParameter(fp);
                this.refreshBillList();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "delete_comfirm": {
                this.deleteDisCT(event);
            }
        }
    }

    private void deleteDisCT(MessageBoxClosedEvent event) {
        if (MessageBoxResult.Yes == event.getResult()) {
            BillList billlist = (BillList)this.getControl(BILL_LIST_AP);
            ListSelectedRowCollection listRows = billlist.getSelectedRows();
            String selectFields = "id, model, cycletable, template, template.number, template.name";
            Object[] rows = listRows.getPrimaryKeyValues();
            QFilter filter = new QFilter(ID, "in", (Object)rows);
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_tempdiscycletable", (String)selectFields, (QFilter[])new QFilter[]{filter});
            doc = this.findAll(doc);
            ArrayList<Long> idList = new ArrayList<Long>(16);
            HashMap<String, String> numberNameMap = new HashMap<String, String>(doc.size());
            for (DynamicObject d : doc) {
                idList.add(d.getLong(ID));
                String templateName = d.getString(TEMPLATE_NAME);
                String templateNumber = d.getString(TEMPLATE_NUM);
                if (templateName == null) continue;
                numberNameMap.put(templateNumber, templateName);
            }
            if (!idList.isEmpty()) {
                try (TXHandle tx = TX.required((String)"bcm_deleteDisCT");){
                    try {
                        DeleteServiceHelper.delete((String)"bcm_tempdiscycletable", (QFilter[])new QFilter[]{new QFilter(ID, "in", idList)});
                        this.backSendOpLog(numberNameMap, TempDisCycleTablePlugin.getOperationStstusSuccess());
                    }
                    catch (KDBizException e1) {
                        this.backSendOpLog(numberNameMap, TempDisCycleTablePlugin.getOperationStstusFail());
                        tx.markRollback();
                        throw e1;
                    }
                    catch (Throwable e1) {
                        this.backSendOpLog(numberNameMap, TempDisCycleTablePlugin.getOperationStstusFail());
                        tx.markRollback();
                        throw e1;
                    }
                }
            }
            this.refreshBillList();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5206\u914d\u5b8c\u6210\u3002", (String)"TempDisCycleTablePlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private DynamicObjectCollection findAll(DynamicObjectCollection doc) {
        ArrayList tempNum = new ArrayList(16);
        doc.forEach(d -> tempNum.add(d.getString(TEMPLATE_NUM)));
        DynamicObjectCollection temDis = this.getTemDis(true);
        for (DynamicObject temdis : temDis) {
            if (!tempNum.contains(temdis.getString(TEMPLATE_NUM))) continue;
            doc.add((Object)temdis);
        }
        return doc;
    }

    private DynamicObject getCycleTable() {
        String cycletableId = this.getModel().getValue(CYCLETABLE_COMBO).toString();
        QFilter filter = new QFilter(MODEL, "=", (Object)this.getModelId());
        QFilter ctFilter = new QFilter(ID, "=", (Object)LongUtil.toLong((Object)cycletableId));
        return QueryServiceHelper.queryOne((String)"bcm_cycletable", (String)"id, number, name, scenario", (QFilter[])new QFilter[]{filter, ctFilter});
    }

    private DynamicObjectCollection getTemDis(boolean isCheckNode) {
        QFilter filter = new QFilter(MODEL, "=", (Object)this.getModelId());
        if (isCheckNode) {
            String cycletableId = this.getModel().getValue(CYCLETABLE_COMBO).toString();
            filter.and(new QFilter(CYCLETABLE, "=", (Object)LongUtil.toLong((Object)cycletableId)));
        }
        String selectFields = "id, cycletable, template, template.number, template.versionnumber";
        return QueryServiceHelper.query((String)"bcm_tempdiscycletable", (String)selectFields, (QFilter[])new QFilter[]{filter});
    }

    private void backSendOpLog(HashMap<String, String> numberNameMap, String status) {
        for (Map.Entry<String, String> numberName : numberNameMap.entrySet()) {
            this.writeOperationLog(TempDisCycleTablePlugin.getOperationBackSend(), numberName.getKey(), numberName.getValue(), status);
        }
    }

    private /* synthetic */ void lambda$copyVersionDistribute$4(Multimap id2Dyn, List disList, Table.Cell v) {
        if ((Long)v.getValue() - (Long)v.getRowKey() == 0L) {
            return;
        }
        Collection collection = id2Dyn.get(v.getValue());
        collection.forEach(c -> {
            DynamicObject distribute = BusinessDataServiceHelper.newDynamicObject((String)"bcm_tempdiscycletable");
            distribute.set(MODEL, (Object)this.getModelId());
            distribute.set(CYCLETABLE, this.getModel().getValue(CYCLETABLE_COMBO));
            distribute.set(TEMPLATE, v.getRowKey());
            disList.add(distribute);
        });
    }

    private static /* synthetic */ void lambda$copyVersionDistribute$2(DynamicObject cycleTable, Table tpl2group2tpl, Map tpl2Group, Row ds) {
        Long groupId = ds.getLong(GROUP);
        TemplateModel templateModel = ModelDataProvider.getTemplateModel(ds.getLong(ID));
        boolean innerRange = TemplateRangeService.isInnerRange((String)"bcm_scenemembertree", (TemplateModel)templateModel, (Object)cycleTable.getLong("scenario"));
        if (innerRange) {
            tpl2group2tpl.put((Object)ds.getLong(ID), (Object)groupId, tpl2Group.get(groupId));
        }
    }

    private static /* synthetic */ void lambda$copyVersionDistribute$0(Set templateIds, Multimap id2Dyn, DynamicObject d) {
        templateIds.add(d.getLong(TEMPLATE));
        id2Dyn.put((Object)d.getLong(TEMPLATE), (Object)d);
    }
}

