/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.basedata.MultiF7Results;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.exchangeRate.ExchageRateServiceHelper;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.BaseEditElement;
import kd.fi.bcm.business.page.model.CheckBox;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.page.model.TextEditElement;
import kd.fi.bcm.business.page.model.util.DragUtil;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.DimAndMemberPareEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.formplugin.util.TemplateDimSettingUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;

public class TemplateDimSettingPlugin
extends AbstractTemplateBasePlugin
implements ClickListener,
DynamicPage {
    private static final String ALL = "allPoint";
    private static final String ISEDIT = "edit";
    private static final String NAME_KEY = "name";
    private static final String NUMBER_KEY = "number";
    private static final String ENTITY_KEY = "entity";
    private static final String SEQ_KEY = "seq";
    private static final String SIGN_KEY = "sign";
    private static final String PANEL_KEY = "panel";
    private static final String VALUE_KEY = "value";
    private static final String RANKINIT_KEY = "rankinit";
    private static final String RANK_KEY = "rank";
    private static final String FILTER_DIMENSION_SIGN = "fd";
    private static final String CHECK_BOX_SIGN = "cb";
    private static final String SEPARATOR_SIGN = "!";
    private static final String VIEWPANEL_SIGN = "viewpanel";
    private static final String PAGEPANEL_SIGN = "pagepanel";
    private static final String RANKPANEL_SIGN = "rankpanel";
    private static final Set<String> RptUnUseDim = Sets.newHashSet((Object[])new String[]{DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.PROCESS.getNumber(), DimTypesEnum.AUDITTRIAL.getNumber()});
    private static final Set<String> FILTERUNUSEDIM = Sets.newHashSet((Object[])new String[]{DimTypesEnum.SCENARIO.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber(), DimTypesEnum.CURRENCY.getNumber()});

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_confirm", "btn_cancel");
        this.initAreaValueOrListener(this.getPage(this.getView()), true);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("change", "true");
        if (this.isEditState()) {
            this.initPage(this.getTemplateModel());
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u914d\u7f6e\u9ed8\u8ba4\u503c\u65f6\u7f3a\u5c11\u6210\u5458\uff0c\u8bf7\u7ef4\u62a4\u597d\u9884\u7f6e\u6210\u5458\u3002", (String)"TemplateDimSettingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void initPage(TemplateModel template) {
        Page page = new Page();
        page.setChangeable(true);
        this.addArea(template, page, PAGEPANEL_SIGN);
        this.addArea(template, page, RANKPANEL_SIGN);
        this.addArea(template, page, VIEWPANEL_SIGN);
        this.commomAction(page);
        this.initAreaValueOrListener(page, false);
        this.setDimVisible(template);
    }

    private void setDimVisible(TemplateModel template) {
        if (ApplicationTypeEnum.RPT == ModelUtil.queryApp(this.getView())) {
            template = template == null ? this.getTemplateModel() : template;
            for (ViewPointDimensionEntry a : template.getViewPointDimensionEntries()) {
                if (!RptUnUseDim.contains(a.getDimension().getNumber())) continue;
                this.getView().setVisible(Boolean.valueOf(false), new String[]{this.buildSign(a.getDimension().getMemberEntityNumber(), a.getDimension().getNumber(), VIEWPANEL_SIGN, false)});
            }
            for (ViewPointDimensionEntry a : template.getPageDimensionEntries()) {
                if (!RptUnUseDim.contains(a.getDimension().getNumber())) continue;
                this.getView().setVisible(Boolean.valueOf(false), new String[]{this.buildSign(a.getDimension().getMemberEntityNumber(), a.getDimension().getNumber(), PAGEPANEL_SIGN, false)});
            }
        }
    }

    private boolean isShowDim(long modelId, String dimNumber) {
        return !DimTypesEnum.INTERCOMPANY.getNumber().equals(dimNumber) || !this.isNotShowIC(modelId);
    }

    private boolean isNotShowIC(long modelId) {
        return (Boolean)ThreadCache.get((Object)(modelId + "TemplateDimSettingPlugin"), () -> !QueryDimensionServiceHelper.checkIcEnt((long)modelId));
    }

    private void addArea(TemplateModel template, Page page, String sign) {
        Area area = new Area(sign);
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(16);
        if (template == null) {
            if (this.getPageCache().get(ALL) != null) {
                List ap = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(ALL), List.class);
                ap.forEach(tempMap -> {
                    if (sign.equals(tempMap.get(PANEL_KEY))) {
                        list.add((Map<String, String>)tempMap);
                    }
                });
            }
        } else {
            String modelNumber = MemberReader.findModelNumberById((Object)template.getModelId());
            switch (sign) {
                case "viewpanel": {
                    ArrayList numbers = new ArrayList(16);
                    if (!template.getViewPointDimensionEntries().isEmpty()) {
                        template.getViewPointDimensionEntries().forEach(vp -> {
                            String dimNumber = vp.getDimension().getNumber();
                            if (MemberReader.isExistDimension((String)modelNumber, (String)dimNumber) && this.isShowDim(template.getModelId(), dimNumber)) {
                                numbers.add(dimNumber);
                                list.add(this.getDimMessageMap(dimNumber, vp.getDimension().getName(), vp.getDimension().getMemberEntityNumber(), VIEWPANEL_SIGN, Long.toString(vp.getMember().getId())));
                                this.getPageCache().put(this.buildSign(vp.getDimension().getMemberEntityNumber(), vp.getDimension().getNumber(), VIEWPANEL_SIGN, false), Long.toString(vp.getMember().getId()));
                            }
                        });
                    }
                    this.getPointEntry().forEach(map -> numbers.add(map.get(NUMBER_KEY)));
                    List rank = QueryDimensionServiceHelper.getOthersDim(numbers, (Long)template.getModelId());
                    rank.forEach(dyo -> {
                        if (this.isShowDim(template.getModelId(), dyo.getString(NUMBER_KEY))) {
                            list.add(this.getDimMessageMap(dyo.getString(NUMBER_KEY), dyo.getString(NAME_KEY), dyo.getString("membermodel"), VIEWPANEL_SIGN, ""));
                        }
                    });
                    break;
                }
                case "pagepanel": {
                    if (!template.getPageDimensionEntries().isEmpty()) {
                        template.getPageDimensionEntries().forEach(pageDimensionEntry -> {
                            String dimNumber = pageDimensionEntry.getDimension().getNumber();
                            if (MemberReader.isExistDimension((String)modelNumber, (String)dimNumber) && this.isShowDim(template.getModelId(), dimNumber)) {
                                String value = "";
                                if (!DimTypesEnum.ENTITY.getNumber().equals(dimNumber)) {
                                    MultiF7Results multiF7Results = MultiF7Results.buildParam((List)pageDimensionEntry.getMembers(), (long)this.getModelId());
                                    value = multiF7Results.getShowText();
                                    this.getPageCache().put(this.buildSign(pageDimensionEntry.getDimension().getMemberEntityNumber(), pageDimensionEntry.getDimension().getNumber(), PAGEPANEL_SIGN, false), SerializationUtils.toJsonString((Object)multiF7Results.toList()));
                                }
                                list.add(this.getDimMessageMap(dimNumber, pageDimensionEntry.getDimension().getName(), pageDimensionEntry.getDimension().getMemberEntityNumber(), PAGEPANEL_SIGN, value));
                            }
                        });
                    }
                    if (!template.getPagePropEntries().isEmpty()) {
                        template.getPagePropEntries().forEach(pe -> {
                            String dimNumber = pe.getDimension().getNumber();
                            if (MemberReader.isExistDimension((String)modelNumber, (String)dimNumber) && this.isShowDim(template.getModelId(), dimNumber)) {
                                String value = "";
                                if (!DimTypesEnum.ENTITY.getNumber().equals(dimNumber)) {
                                    MultiF7Results multiF7Results = MultiF7Results.buildParam((List)pe.getAllMembProperties(), (long)this.getModelId(), (boolean)false);
                                    value = multiF7Results.getShowText();
                                    this.getPageCache().put(this.buildSign(pe.getDimension().getMemberEntityNumber(), pe.getDimension().getNumber(), PAGEPANEL_SIGN, false), SerializationUtils.toJsonString((Object)multiF7Results.toList()));
                                }
                                list.add(this.getDimMessageMap(dimNumber, pe.getDimension().getName(), pe.getDimension().getMemberEntityNumber(), PAGEPANEL_SIGN, value));
                            }
                        });
                    }
                    if (template.getFilterDimensionEntries().isEmpty()) break;
                    template.getFilterDimensionEntries().forEach(tf -> {
                        String dimNumber = tf.getDimension().getNumber();
                        if (MemberReader.isExistDimension((String)modelNumber, (String)dimNumber) && this.isShowDim(template.getModelId(), dimNumber)) {
                            String value = "";
                            List filterDimMembers = tf.getMembers();
                            MultiF7Results multiF7Results = MultiF7Results.buildParamForFd((List)filterDimMembers, (long)this.getModelId());
                            value = multiF7Results.getShowText();
                            this.getPageCache().put(this.buildSign(tf.getDimension().getMemberEntityNumber(), tf.getDimension().getNumber(), PAGEPANEL_SIGN, true), SerializationUtils.toJsonString((Object)multiF7Results.toList()));
                            list.add(this.getDimMessageMap(dimNumber, tf.getDimension().getName(), tf.getDimension().getMemberEntityNumber(), PAGEPANEL_SIGN, value, true));
                        }
                    });
                    break;
                }
                case "rankpanel": {
                    AreaRangeEntry areaRangeEntry = this.getCommonAreaRangeEntry(template);
                    List rankDims = template.getRank();
                    if (areaRangeEntry != null && !areaRangeEntry.getColDimEntries().isEmpty() && !areaRangeEntry.getRowDimEntries().isEmpty()) {
                        areaRangeEntry.getColDimEntries().forEach(colDimensionEntry -> this.addSingleDimMap((DimAndMemberPareEntry)colDimensionEntry, modelNumber, list));
                        areaRangeEntry.getRowDimEntries().forEach(rowDimensionEntry -> this.addSingleDimMap((DimAndMemberPareEntry)rowDimensionEntry, modelNumber, list));
                    } else if (rankDims != null && !rankDims.isEmpty()) {
                        Map dimNumberMapNameById = MemberReader.getDimNumberMapNameById((long)template.getModelId());
                        rankDims.forEach(dimNumber -> {
                            if (this.isShowDim(template.getModelId(), (String)dimNumber)) {
                                list.add(this.getDimMessageMap((String)dimNumber, (String)dimNumberMapNameById.get(dimNumber), DimensionServiceHelper.getDimMembEntityNumByDimNum((String)dimNumber), RANKPANEL_SIGN, (String)dimNumberMapNameById.get(dimNumber)));
                            }
                        });
                    } else {
                        String dimName = TemplateUtil.getDimName((Long)template.getModelId(), (String)DimTypesEnum.ACCOUNT.getNumber());
                        list.add(this.getDimMessageMap(DimTypesEnum.ACCOUNT.getNumber(), dimName, "bcm_accountmembertree", RANKPANEL_SIGN, dimName));
                        if (MemberReader.isExistDimension((String)modelNumber, (String)DimTypesEnum.CHANGETYPE.getNumber())) {
                            dimName = TemplateUtil.getDimName((Long)template.getModelId(), (String)DimTypesEnum.CHANGETYPE.getNumber());
                            list.add(this.getDimMessageMap(DimTypesEnum.CHANGETYPE.getNumber(), dimName, "bcm_changetypemembertree", RANKPANEL_SIGN, dimName));
                        }
                    }
                    this.checkRankForFd(list, template);
                    break;
                }
            }
            this.cacheAllPoint(list);
        }
        if (!list.isEmpty()) {
            list.forEach(map1 -> {
                if (RANKPANEL_SIGN.equals(sign)) {
                    area.addElement(this.fillValueElememt((Map<String, String>)map1, sign, true));
                }
                area.addElement(this.fillValueElememt((Map<String, String>)map1, sign, false));
            });
        }
        page.addArea(area);
    }

    private void checkRankForFd(List<Map<String, String>> list, TemplateModel template) {
        List filterDimensionEntry = template.getFilterDimensionEntries();
        if (!filterDimensionEntry.isEmpty()) {
            ArrayList fdNumbers = new ArrayList(16);
            filterDimensionEntry.forEach(fd -> fdNumbers.add(fd.getDimension().getNumber()));
            list.forEach(map -> {
                if (fdNumbers.contains(map.get(NUMBER_KEY)) && RANKPANEL_SIGN.equals(map.get(PANEL_KEY))) {
                    map.put(VALUE_KEY, "true");
                }
            });
        }
    }

    private AreaRangeEntry getCommonAreaRangeEntry(TemplateModel template) {
        Pair<AreaRangeEntry, List<String>> pair = kd.fi.bcm.formplugin.util.TemplateUtil.getCommonAreaRangeEntry(template);
        return pair == null ? null : (AreaRangeEntry)pair.p1;
    }

    private void cacheAllPoint(List<Map<String, String>> list) {
        if (!list.isEmpty()) {
            ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>(16);
            if (this.getPageCache().get(ALL) != null) {
                List ap = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(ALL), List.class);
                mapList.addAll(ap);
            }
            mapList.addAll(list);
            this.getPageCache().put(ALL, SerializationUtils.toJsonString(mapList));
        }
    }

    private Map<String, String> getSingleElementMap(String sign) {
        Map<String, String> map = new HashMap<String, String>(16);
        if (this.getPageCache().get(ALL) != null) {
            List ap = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(ALL), List.class);
            for (Map map1 : ap) {
                String s = (String)map1.get(SIGN_KEY);
                if (!Arrays.asList(s + SEPARATOR_SIGN + CHECK_BOX_SIGN, s).contains(sign)) continue;
                map = map1;
                break;
            }
        }
        return map;
    }

    private Element fillValueElememt(Map<String, String> map, String sign, boolean isCheckBox) {
        String name = map.get(NAME_KEY);
        String elementSign = map.get(SIGN_KEY);
        String entityNumber = map.get(ENTITY_KEY);
        BaseEditElement element = null;
        switch (sign) {
            case "viewpanel": {
                element = new BaseEditElement(name, elementSign, entityNumber);
                break;
            }
            case "pagepanel": {
                element = new TextEditElement(name, elementSign, entityNumber);
                break;
            }
            case "rankpanel": {
                if (isCheckBox) {
                    elementSign = elementSign + SEPARATOR_SIGN + CHECK_BOX_SIGN;
                    element = new CheckBox("", elementSign);
                    break;
                }
                element = new TextEditElement("", elementSign, entityNumber);
                ((TextEditElement)element).setEditStyle(0);
                ((TextEditElement)element).setLock("new,edit");
                break;
            }
        }
        boolean isFilterDim = this.isFilterDim(elementSign);
        if (element != null) {
            element.setCustomStyle(fieldAp -> {
                FieldAp newfilap = (FieldAp)fieldAp;
                newfilap.setQuickAddNew(false);
                newfilap.setFireUpdEvt(true);
                newfilap.setFieldTextAlign("center");
                newfilap.setTextAlign("left");
                newfilap.setHeight(new LocaleString("40px"));
                newfilap.setFontSize(14);
                Style style = new Style();
                Margin margin = new Margin();
                Padding padding = new Padding();
                if (RANKPANEL_SIGN.equals(sign)) {
                    if (isCheckBox) {
                        fieldAp.setWidth(new LocaleString("40px"));
                    } else {
                        newfilap.setWidth(new LocaleString("216px"));
                    }
                    newfilap.setShowTitle(false);
                } else {
                    newfilap.setLabelWidth(new LocaleString("110px"));
                    if (PAGEPANEL_SIGN.equals(sign) && isFilterDim) {
                        newfilap.setForeColor("#8594f0");
                    }
                }
                padding.setTop("14px");
                margin.setTop("1px");
                margin.setBottom("10px");
                newfilap.setLabelDirection("h");
                padding.setRight("14px");
                padding.setLeft("14px");
                margin.setLeft("30px");
                margin.setRight("1px");
                style.setMargin(margin);
                style.setPadding(padding);
                newfilap.setStyle(style);
            });
        }
        return element;
    }

    private Map<String, String> getDimMessageMap(String dimNumber, String dimName, String entityNumber, String sign, String value) {
        return this.getDimMessageMap(dimNumber, dimName, entityNumber, sign, value, false);
    }

    private Map<String, String> getDimMessageMap(String dimNumber, String dimName, String entityNumber, String sign, String value, boolean isFilterDim) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put(NAME_KEY, dimName);
        map.put(NUMBER_KEY, dimNumber);
        map.put(ENTITY_KEY, entityNumber);
        String seq = QueryDimensionServiceHelper.getMsgByNumber((long)this.template.getModelId(), (String)dimNumber).getString("dseq");
        map.put(SEQ_KEY, seq);
        String buildSign = "";
        buildSign = isFilterDim ? this.buildSign(entityNumber, dimNumber, sign, true) : this.buildSign(entityNumber, dimNumber, sign, false);
        map.put(SIGN_KEY, buildSign);
        map.put(PANEL_KEY, sign);
        map.put(VALUE_KEY, value);
        return map;
    }

    private void addSingleDimMap(DimAndMemberPareEntry dimAndMemberPareEntry, String modelNumber, List<Map<String, String>> list) {
        String dimNumber = dimAndMemberPareEntry.getDimension().getNumber();
        if (MemberReader.isExistDimension((String)modelNumber, (String)dimNumber)) {
            if (DimTypesEnum.INTERCOMPANY.getNumber().equals(dimNumber) && !MemberReader.isExistDimension((String)modelNumber, (String)dimNumber)) {
                return;
            }
            list.add(this.getDimMessageMap(dimNumber, dimAndMemberPareEntry.getDimension().getName(), dimAndMemberPareEntry.getDimension().getMemberEntityNumber(), RANKPANEL_SIGN, dimAndMemberPareEntry.getDimension().getName()));
        }
    }

    private void initAreaValueOrListener(Page page, boolean isListener) {
        List areaList = page.getAreaList();
        ArrayList elementListenerList = new ArrayList(16);
        this.getModel().beginInit();
        IFormView view = this.getView();
        areaList.forEach(area -> {
            String sign = area.getSign();
            area.getElementListList().forEach(element -> {
                String elementSign = element.getSign();
                Map<String, String> map = this.getSingleElementMap(elementSign);
                if (element instanceof CheckBox) {
                    view.setEnable(Boolean.valueOf(!FILTERUNUSEDIM.contains(map.get(NUMBER_KEY))), new String[]{elementSign});
                }
                if (!isListener) {
                    if (!map.isEmpty()) {
                        String value = map.get(VALUE_KEY);
                        String entity = map.get(ENTITY_KEY);
                        if (VIEWPANEL_SIGN.equals(sign) && StringUtils.isNotEmpty((String)value)) {
                            this.setValue(elementSign, LongUtil.toLong((Object)value));
                        } else {
                            if (RANKPANEL_SIGN.equals(sign) && elementSign.equals(map.get(SIGN_KEY))) {
                                value = map.get(NAME_KEY);
                            }
                            this.setValue(elementSign, value);
                            if (RANKPANEL_SIGN.equals(sign)) {
                                view.updateView(elementSign);
                            }
                        }
                        if (PAGEPANEL_SIGN.equals(sign) && "bcm_entitymembertree".equals(entity) && !this.isFilterDim(elementSign)) {
                            view.setEnable(Boolean.valueOf(false), new String[]{elementSign});
                        }
                    }
                } else if (PAGEPANEL_SIGN.equals(sign)) {
                    elementListenerList.add(elementSign);
                } else if (VIEWPANEL_SIGN.equals(sign)) {
                    BasedataEdit basedataEdit = (BasedataEdit)this.getControl(elementSign);
                    basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
                }
            });
        });
        this.getModel().endInit();
        if (!elementListenerList.isEmpty()) {
            this.addClickListeners((String[])elementListenerList.stream().toArray(String[]::new));
        }
    }

    private void commomAction(Page page) {
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        this.allDrag(page);
    }

    private void allDrag(Page page) {
        IFormView view = this.getView();
        page.getAreaList().forEach(a -> {
            view.getControl(a.getSign()).setDroppable(true);
            a.getElementListList().forEach(e -> {
                String sign = e.getSign();
                view.getControl(sign).setDroppable(true);
                if (!this.isFilterDim(sign)) {
                    view.getControl(sign).setDraggable(true);
                }
            });
        });
    }

    private String buildSign(String entity, String number, String sign, boolean isFilterDim) {
        if (isFilterDim) {
            sign = sign + SEPARATOR_SIGN + FILTER_DIMENSION_SIGN;
        }
        return (entity + SEPARATOR_SIGN + number + SEPARATOR_SIGN + sign).toLowerCase(Locale.ENGLISH);
    }

    private String getRealEntity(String sign) {
        return sign.split(SEPARATOR_SIGN)[0];
    }

    private boolean isEditState() {
        boolean is = this.getTemplateModel().getPageDimensionEntries().size() > 0 || this.getTemplateModel().getViewPointDimensionEntries().size() > 0 || this.getTemplateModel().getPagePropEntries().size() > 0;
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        if (pageCache.get(ISEDIT) == null) {
            if (!is) {
                return QueryServiceHelper.exists((String)"bcm_templateentity", (Object)this.getTemplateModel().getId());
            }
            return true;
        }
        return pageCache.get(ISEDIT).equals("1");
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent p0) {
        super.beforeF7Select(p0);
        String methodName = PlatUtil.getOpMethod();
        BasedataEdit bs = (BasedataEdit)p0.getSource();
        if ("getLookupList".equalsIgnoreCase(methodName)) {
            String sign = bs.getKey();
            String dimNumber = this.getDimNumberBySign(sign);
            long modelId = this.getModelId();
            Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimNumber);
            ListShowParameter showParameter = (ListShowParameter)p0.getFormShowParameter();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
            String entity = this.getRealEntity(sign);
            QFilter qFilter = new QFilter("1", "=", (Object)1);
            if ("bcm_userdefinedmembertree".equals(entity)) {
                qFilter.and("dimension", "=", (Object)dimensionId);
            }
            if (DimTypesEnum.PERIOD.getNumber().equals(dimNumber)) {
                qFilter.and(this.sceneFilterForPeriod());
            }
            QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
            QFilter permissonFilter = SingleMemberF7Util.getPermissionFilter(entity, dimensionId, modelId);
            ExchageRateServiceHelper.delExchangeRatePlanFilter((QFilter)modelFilter, (String)entity);
            qFilters.add(modelFilter.and(permissonFilter).and(qFilter));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
        } else if ("click".equals(methodName) || "showMore".equals(methodName)) {
            this.showSingleF7(bs);
            p0.setCancel(true);
        }
    }

    private QFilter sceneFilterForPeriod() {
        Pair<Boolean, Set<Long>> scenarioinfo = this.getScenarioInfo();
        if (((Boolean)scenarioinfo.p1).booleanValue() && ((Set)scenarioinfo.p2).isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u60c5\u666f\u3002", (String)"TemplateDimSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (((Set)scenarioinfo.p2).isEmpty()) {
            return new QFilter("1", "in", (Object)1);
        }
        QFilter filter2 = new QFilter("id", "in", (Object)((Set)scenarioinfo.p2).toArray());
        DynamicObject[] col = BusinessDataServiceHelper.load((String)"bcm_scenemembertree", (String)"sceneperiod", (QFilter[])new QFilter[]{filter2});
        ArrayList ids = new ArrayList();
        for (DynamicObject dot : col) {
            DynamicObjectCollection sceneperiod = dot.getDynamicObjectCollection("sceneperiod");
            sceneperiod.forEach(p -> ids.add(p.getDynamicObject("fbasedataid").getLong("id")));
        }
        if (ids.isEmpty()) {
            return new QFilter("1", "in", (Object)1);
        }
        return new QFilter("id", "in", (Object)ids.toArray());
    }

    private void showSingleF7(BasedataEdit bs) {
        String sign = bs.getKey();
        String dimNumber = this.getDimNumberBySign(sign);
        long modelId = this.getModelId();
        Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimNumber);
        BasedataEditSingleMemberF7 f7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), modelId, dimensionId, sign, null, true, SingleF7TypeEnum.COMMON);
        f7.setF7title(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"TemplateDimSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        if (DimTypesEnum.PERIOD.getNumber().equals(dimNumber)) {
            f7.setCustomFilter(this.sceneFilterForPeriod());
        }
        if (DimTypesEnum.ENTITY.getNumber().equals(dimNumber)) {
            Map<String, Object> customData = f7.getCustomData();
            if (customData == null) {
                customData = new HashMap<String, Object>(16);
            }
            customData.put("disableRateCls", "true");
            f7.setCustomData(customData);
        }
        f7.setCallBackClassName(this.getClass().getName());
        f7.setStatus(OperationStatus.EDIT);
        f7.click();
    }

    private String getDimNumberBySign(String elementSign) {
        Map<String, String> cacheMap = this.getSingleElementMap(elementSign);
        if (cacheMap != null && cacheMap.get(NUMBER_KEY) != null) {
            return cacheMap.get(NUMBER_KEY);
        }
        return null;
    }

    private Pair<Boolean, Set<Long>> getScenarioInfo() {
        List<Map<String, String>> list = this.getPointEntry();
        boolean sceneInViewPage = false;
        HashSet<Long> scenarioids = new HashSet<Long>();
        for (Map<String, String> map : list) {
            String sign = map.get(SIGN_KEY);
            String panel = map.get(PANEL_KEY);
            if (!sign.startsWith("bcm_scenemembertree") || !VIEWPANEL_SIGN.equals(panel) && !PAGEPANEL_SIGN.equals(panel)) continue;
            sceneInViewPage = true;
            String temp = this.getPageCache().get(sign);
            if (temp == null) continue;
            if (VIEWPANEL_SIGN.equals(panel)) {
                scenarioids.add(Long.valueOf(temp));
                continue;
            }
            if (!PAGEPANEL_SIGN.equals(panel)) continue;
            List list2 = (List)SerializationUtils.fromJsonString((String)temp, List.class);
            list2.forEach(scinfo -> {
                MembRangeItem item = new MembRangeItem("bcm_scenemembertree", Long.valueOf((String)scinfo.get("id")), (String)scinfo.get(NUMBER_KEY), Integer.parseInt((String)scinfo.get("scope")), StringUtils.isNotEmpty((String)((String)scinfo.get("pid"))), (Object)this.getModelId());
                item.matchItems(c -> scenarioids.add((Long)c.getId()));
            });
        }
        return Pair.onePair((Object)sceneInViewPage, scenarioids);
    }

    private List<Map<String, String>> getPointEntry() {
        return TemplateDimSettingUtil.getPointEntry(this, this.getTemplateModel(), false);
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (this.checkControlKeyPrefix(this.getView(), key)) {
            this.openShowFormForPageDim(key);
        }
    }

    private void openShowFormForPageDim(String key) {
        String entityNumber = this.getRealEntity(key);
        String dimNumber = this.getDimNumberBySign(key);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        if (DimTypesEnum.PERIOD.getNumber().equals(dimNumber)) {
            Pair<Boolean, Set<Long>> scenarioInfo = this.getScenarioInfo();
            if (((Boolean)scenarioInfo.p1).booleanValue() && ((Set)scenarioInfo.p2).isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u60c5\u666f\u3002", (String)"TemplateDimSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (((Boolean)scenarioInfo.p1).booleanValue() && !((Set)scenarioInfo.p2).isEmpty()) {
                params.put("scenario", SerializationUtils.toJsonString((Object)scenarioInfo.p2));
            }
        }
        FormShowParameter para = new FormShowParameter();
        if ("bcm_icmembertree".equals(entityNumber) || key.startsWith("bcm_userdefinedmembertree") && BCMTreeUtils.getMaxCount((long)0L) > 0) {
            para.setFormId("bcm_mulmemberf7_tem_ic");
        } else {
            para.setFormId("bcm_mulmemberf7base_tem");
        }
        para.getOpenStyle().setShowType(ShowType.Modal);
        long modelId = this.getModelId();
        Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimNumber);
        String dimName = MemberReader.getDimensionNameById((long)dimensionId);
        params.put("dimensionid", dimensionId);
        params.put(SIGN_KEY, key);
        params.put("KEY_MODEL_ID", Long.toString(this.getModelId()));
        if ("bcm_entitymembertree".equals(entityNumber)) {
            params.put("disableRateCls", "true");
        }
        para.setCustomParams(params);
        para.setCaption(String.format(ResManager.loadKDString((String)"%s - \u6210\u5458\u9009\u62e9", (String)"TemplateDimSettingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimName));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map<String, String> elementMap;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (this.checkControlKeyPrefix(this.getView(), actionId) && !(elementMap = this.getSingleElementMap(actionId)).isEmpty() && elementMap.get(SIGN_KEY) != null) {
            if (VIEWPANEL_SIGN.equals(elementMap.get(PANEL_KEY))) {
                DynamicObject dynamicObject = (DynamicObject)closedCallBackEvent.getReturnData();
                if (dynamicObject != null) {
                    this.getModel().setValue(actionId, (Object)dynamicObject.getLong("id"));
                    this.getPageCache().put(actionId, dynamicObject.getString("id"));
                    this.updateAllPointMapBySign(actionId, dynamicObject.getString("id"));
                }
            } else if (PAGEPANEL_SIGN.equals(elementMap.get(PANEL_KEY))) {
                DynamicObjectCollection doc = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
                if (doc == null && ThreadCache.get((Object)"okbtn") == null) {
                    return;
                }
                if (doc != null && !doc.isEmpty()) {
                    MultiF7Results results = MultiF7Results.buildParam((DynamicObjectCollection)doc, (long)this.getModelId());
                    this.getModel().setValue(actionId, (Object)results.getShowText());
                    this.getPageCache().put(actionId, SerializationUtils.toJsonString((Object)results.toList()));
                    this.updateAllPointMapBySign(actionId, results.getShowText());
                } else if (doc != null && doc.isEmpty()) {
                    this.getModel().setValue(actionId, (Object)" ");
                    this.getPageCache().put(actionId, null);
                    this.updateAllPointMapBySign(actionId, "");
                }
            }
        }
    }

    private void updateAllPointMapBySign(String sign, String value) {
        List<Map<String, String>> pointEntry = this.getPointEntry();
        pointEntry.forEach(map -> {
            if (((String)map.get(SIGN_KEY)).equals(sign)) {
                map.put(VALUE_KEY, value);
            }
        });
        this.getPageCache().put(ALL, SerializationUtils.toJsonString(pointEntry));
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if ("confirm_modify".equals(callBackId)) {
            if (MessageBoxResult.Yes == mbce.getResult()) {
                QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
                QFilter numQFilter = new QFilter("template.number", "=", (Object)this.getTemplateModel().getNumber());
                DeleteServiceHelper.delete((String)"bcm_tempdiscycletable", (QFilter[])new QFilter[]{filter, numQFilter});
                this.getPageCache().remove("isInclude");
                this.getPageCache().remove("cycletable");
                ThreadCache.put((Object)"unbind", (Object)true);
                this.handlePageDataAndClose();
            }
        } else if ("close_save_comfirm".equals(callBackId)) {
            if (MessageBoxResult.Yes == mbce.getResult()) {
                if (!this.showConfirm()) {
                    ThreadCache.put((Object)"unbind", (Object)true);
                    this.handlePageDataAndClose();
                }
            } else {
                this.getPageCache().put("isFromSave", "true");
                this.getView().close();
            }
        }
    }

    private DynamicObjectCollection getTempDisCTObjs() {
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and(new QFilter("template.number", "=", (Object)this.getTemplateModel().getNumber()));
        String selectFields = "id, model, template, cycletable";
        return QueryServiceHelper.query((String)"bcm_tempdiscycletable", (String)selectFields, (QFilter[])new QFilter[]{filter});
    }

    private DynamicObjectCollection queryReportRecord() {
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and(new QFilter("template.id", "=", (Object)this.getTemplateModel().getId()));
        String selectFields = "id,entity.id,template.id,currency.id,modifier,modifytime";
        return QueryServiceHelper.query((String)"bcm_reportentity", (String)selectFields, (QFilter[])new QFilter[]{filter});
    }

    private DynamicObject getCycleTable(long cycletableId) {
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        QFilter ctFilter = new QFilter("id", "=", (Object)cycletableId);
        return QueryServiceHelper.queryOne((String)"bcm_cycletable", (String)"id, number, name, scenario", (QFilter[])new QFilter[]{filter, ctFilter});
    }

    public void customEvent(CustomEventArgs e) {
        String name = e.getEventName();
        if ("drop".equals(name)) {
            String eventArgs = e.getEventArgs();
            this.dealElementDrop(eventArgs);
        }
    }

    private void dealElementDrop(String eventArgs) {
        String[] msg = DragUtil.translateMessage((String)eventArgs);
        String target = msg[0];
        String source = msg[1];
        if (this.getControl(source) != null) {
            boolean hasSplit = (Boolean)this.getFormCustomParam("hasSplit");
            String targetPanel = this.getPanelForEventArgs(target);
            String sourcePanel = this.getPanelForEventArgs(source);
            if (RANKPANEL_SIGN.equals(targetPanel) || RANKPANEL_SIGN.equals(sourcePanel)) {
                DynamicObjectCollection record = this.queryReportRecord();
                if (!record.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u8868\u6a21\u677f\u5df2\u6709\u7f16\u5236\u8bb0\u5f55\uff0c\u5982\u679c\u4fee\u6539\u7ef4\u5ea6\u5e03\u5c40\uff0c\u53ef\u80fd\u4f1a\u5bfc\u81f4\u5386\u53f2\u62a5\u8868\u4e0d\u53ef\u7528\uff1b\u8bf7\u4f7f\u7528\u7248\u672c\u5316\u7684\u529f\u80fd\u6765\u505a\u53d8\u66f4\u3002", (String)"TemplateDimSettingPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (hasSplit) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6709\u6570\u636e\u533a\u57df\uff0c\u4e0d\u53ef\u4fee\u6539\u884c\u5217\u7ef4\u5ea6\uff0c\u8bf7\u5220\u9664\u6570\u636e\u533a\u57df\u540e\u518d\u8c03\u6574\u884c\u5217\u7ef4\u5ea6\u3002", (String)"TemplateDimSettingPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (!targetPanel.equals(sourcePanel) && source.startsWith("bcm_scenemembertree")) {
                this.clearPeriodValue();
            }
            this.updateAllDimMap(source, target);
            this.initPage(null);
            this.getPageCache().put("templateisModified", "true");
        }
    }

    private void updateSourceElement(String source) {
        this.getPageCache().remove(source);
        this.setValue(source, null);
        this.getView().updateView(source);
    }

    private boolean isFilterDim(String target) {
        return target.split(SEPARATOR_SIGN).length == 4;
    }

    private void updateAllDimMap(String source, String target) {
        String targetPanel = target;
        String sourcePanel = "";
        List<Map<String, String>> mapList = this.getPointEntry();
        int sourceNum = -1;
        int targetNum = -1;
        int pageNum = -1;
        boolean isfilterDim = this.isFilterDim(target);
        boolean isPanel = VIEWPANEL_SIGN.equals(target) || PAGEPANEL_SIGN.equals(target) || RANKPANEL_SIGN.equals(target);
        Map<String, String> sourceMap = new HashMap<String, String>(16);
        for (int i = 0; i < mapList.size(); ++i) {
            Map<String, String> map = mapList.get(i);
            String s = map.get(SIGN_KEY);
            if (source.equals(s)) {
                sourcePanel = map.get(PANEL_KEY);
                sourceNum = i;
                sourceMap = map;
            } else if (!isPanel && target.equals(s)) {
                targetPanel = map.get(PANEL_KEY);
                targetNum = i;
            }
            if (!PAGEPANEL_SIGN.equals(map.get(PANEL_KEY)) || this.isFilterDim(s)) continue;
            pageNum = i;
        }
        String number = (String)sourceMap.get(NUMBER_KEY);
        String entity = (String)sourceMap.get(ENTITY_KEY);
        Map<String, String> cloneMap = this.cloneMap(sourceMap);
        if (this.isFilterDim(targetPanel)) {
            targetPanel = targetPanel.split(SEPARATOR_SIGN)[2];
        }
        if (isPanel && sourcePanel.equals(target)) {
            int index;
            int n = index = PAGEPANEL_SIGN.equals(target) ? pageNum + 1 : mapList.size();
            if (index <= sourceNum) {
                ++sourceNum;
            }
            mapList.add(index, cloneMap);
            mapList.remove(sourceNum);
        } else if (isPanel) {
            cloneMap.put(PANEL_KEY, target);
            cloneMap.put(SIGN_KEY, this.buildSign(entity, number, target, false));
            cloneMap.put(VALUE_KEY, "");
            mapList.add(PAGEPANEL_SIGN.equals(target) ? pageNum + 1 : mapList.size(), cloneMap);
            this.deleteElementMap(mapList, source);
        } else if (!targetPanel.equals(sourcePanel)) {
            cloneMap.put(PANEL_KEY, targetPanel);
            cloneMap.put(VALUE_KEY, "");
            cloneMap.put(SIGN_KEY, this.buildSign(entity, number, targetPanel, false));
            mapList.add(isfilterDim ? pageNum + 1 : targetNum, cloneMap);
            this.deleteElementMap(mapList, source);
        } else {
            int insertIndex;
            int n = insertIndex = isfilterDim ? pageNum + 1 : targetNum;
            if (insertIndex <= sourceNum) {
                ++sourceNum;
            }
            mapList.add(insertIndex, cloneMap);
            mapList.remove(sourceNum);
        }
        if (sourcePanel.equals(RANKPANEL_SIGN) && !targetPanel.equals(RANKPANEL_SIGN)) {
            this.deleteElementMap(mapList, this.buildSign(entity, number, PAGEPANEL_SIGN, true));
        }
        this.getPageCache().put(ALL, SerializationUtils.toJsonString(mapList));
    }

    private Map<String, String> cloneMap(Map<String, String> sourceMap) {
        HashMap<String, String> newMap = new HashMap<String, String>(16);
        newMap.put(NAME_KEY, sourceMap.get(NAME_KEY));
        newMap.put(NUMBER_KEY, sourceMap.get(NUMBER_KEY));
        newMap.put(ENTITY_KEY, sourceMap.get(ENTITY_KEY));
        newMap.put(SEQ_KEY, sourceMap.get(SEQ_KEY));
        newMap.put(SIGN_KEY, sourceMap.get(SIGN_KEY));
        newMap.put(PANEL_KEY, sourceMap.get(PANEL_KEY));
        newMap.put(VALUE_KEY, sourceMap.get(VALUE_KEY));
        return newMap;
    }

    private void deleteElementMap(List<Map<String, String>> mapList, String sign) {
        Iterator<Map<String, String>> iterator = mapList.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().get(SIGN_KEY).equals(sign)) continue;
            iterator.remove();
            this.updateSourceElement(sign);
            break;
        }
    }

    private String getPanelForEventArgs(String key) {
        if (VIEWPANEL_SIGN.equals(key) || PAGEPANEL_SIGN.equals(key) || RANKPANEL_SIGN.equals(key)) {
            return key;
        }
        Map<String, String> targetElementMap = this.getSingleElementMap(key);
        return targetElementMap.get(PANEL_KEY);
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String objectId;
        super.afterDoOperation(eventArgs);
        switch (objectId = eventArgs.getOperateKey()) {
            case "confirm": {
                if (eventArgs.getOperationResult().isSuccess()) {
                    ThreadCache.put((Object)"unbind", (Object)true);
                    this.handlePageDataAndClose();
                    break;
                }
                List errorInfos = eventArgs.getOperationResult().getAllErrorOrValidateInfo();
                this.getView().showErrorNotification(((IOperateInfo)errorInfos.get(0)).getMessage());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs eventArgs) {
        super.beforeDoOperation(eventArgs);
        if (eventArgs.getSource() instanceof FormOperate) {
            String operateKey;
            FormOperate formOp = (FormOperate)eventArgs.getSource();
            switch (operateKey = formOp.getOperateKey()) {
                case "confirm": {
                    if (!this.showConfirm()) break;
                    eventArgs.setCancel(true);
                }
            }
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        if (this.getPageCache().get("isFromSave") == null && this.isExitChange()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u754c\u9762\u6570\u636e\u5df2\u53d8\u66f4\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"TemplateEditPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("close_save_comfirm", (IFormPlugin)this));
            e.setCancel(true);
        } else {
            this.getPageCache().remove("isFromSave");
        }
    }

    private boolean isExitChange() {
        boolean flag = !Objects.isNull(this.getPageCache().get("templateisModified"));
        try {
            if (!flag) {
                TemplateModel oldTem = (TemplateModel)ObjectSerialUtil.deSerializedBytes((String)ObjectSerialUtil.toByteSerialized((Object)this.getTemplateModel()));
                TemplateDimSettingUtil.fillBack2TemplateModel(this, this.getTemplateModel(), false);
                flag = kd.fi.bcm.formplugin.util.TemplateUtil.isChangeForTemplate(this.getTemplateModel(), oldTem);
            }
            return flag;
        }
        catch (Exception e) {
            return true;
        }
    }

    private boolean showConfirm() {
        DynamicObjectCollection disObjs = this.getTempDisCTObjs();
        if (!disObjs.isEmpty()) {
            Pair<Boolean, Set<Long>> scenarioInfo = this.getScenarioInfo();
            long cycletableId = ((DynamicObject)disObjs.get(0)).getLong("cycletable");
            DynamicObject cycleTable = this.getCycleTable(cycletableId);
            long scenario = cycleTable.getLong("scenario");
            if (!((Set)scenarioInfo.p2).isEmpty() && !((Set)scenarioInfo.p2).contains(scenario)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u60c5\u666f\u4e0e\u6240\u5206\u914d%s\u5957\u8868\u60c5\u666f\u4e0d\u4e00\u81f4\uff0c\u4fdd\u7559\u4fee\u6539\u4f1a\u53cd\u5206\u914d\u5957\u8868\uff0c\u662f\u5426\u4fee\u6539\uff1f", (String)"TemplateListPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[]{cycleTable.getString(NAME_KEY)}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirm_modify", (IFormPlugin)this));
                return true;
            }
        }
        return false;
    }

    private void handlePageDataAndClose() {
        boolean flag = !Objects.isNull(this.getPageCache().get("templateisModified"));
        TemplateModel oldTem = null;
        if (!flag) {
            oldTem = (TemplateModel)ObjectSerialUtil.deSerializedBytes((String)ObjectSerialUtil.toByteSerialized((Object)this.getTemplateModel()));
        }
        if (TemplateDimSettingUtil.fillBack2TemplateModel(this, this.getTemplateModel(), false)) {
            if (flag || kd.fi.bcm.formplugin.util.TemplateUtil.isChangeForTemplate(this.getTemplateModel(), oldTem)) {
                this.getTemplateModel().put("templateisModified", (Object)true);
            }
            this.getPageCache().put("isFromSave", "true");
            this.returnDataToParent(this.getTemplateModel());
            this.getView().close();
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
        String realctr = e.getProperty().getName();
        Map<String, String> elementMap = this.getSingleElementMap(realctr);
        if (!elementMap.isEmpty()) {
            Object oldValue;
            String panel = elementMap.get(PANEL_KEY);
            String entity = elementMap.get(ENTITY_KEY);
            Object newValue = e.getChangeSet()[0].getNewValue();
            boolean isNoChange = newValue == (oldValue = e.getChangeSet()[0].getOldValue());
            Object value = this.getValue(realctr);
            if (PAGEPANEL_SIGN.equals(panel) && isNoChange && StringUtils.isEmpty((String)newValue.toString()) && value != null) {
                if ("bcm_scenemembertree".equals(entity)) {
                    this.clearPeriodValue();
                }
                this.getPageCache().remove(realctr);
                this.updateAllPointMapBySign(realctr, newValue.toString());
            } else if (RANKPANEL_SIGN.equals(panel) && isNoChange && value != null && !value.toString().equals(newValue.toString()) && !realctr.equals(elementMap.get(SIGN_KEY))) {
                if (newValue.toString().equals("false") && value.toString().equals("true") && this.isSetSystemVarsEnum(elementMap.get(NUMBER_KEY))) {
                    this.showTipAndResetValue(realctr);
                    return;
                }
                this.updateFilterDim((Boolean)newValue, realctr);
            }
        }
    }

    private void showTipAndResetValue(String realctr) {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u884c\u5217\u7ef4\u4e2d\u7684\u6210\u5458\u6216\u6210\u5458\u8303\u56f4\u5df2\u8bbe\u7f6e\u4e86\u7cfb\u7edf\u53d8\u91cf\uff0c\u53d6\u6d88\u52fe\u9009\u8054\u52a8\u9875\u9762\u7ef4\u524d\uff0c\u8bf7\u5148\u4fee\u6539\u884c\u5217\u7ef4\u8bbe\u7f6e\u3002", (String)"TemplateDimSettingPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getModel().beginInit();
        this.getModel().setDataChanged(false);
        this.getModel().getDataEntity().set(realctr, (Object)true);
        this.getView().updateView(realctr);
        this.getModel().endInit();
    }

    private boolean isSetSystemVarsEnum(String dimNum) {
        Set postionInfoSet = this.getSpreadModel().getAreaManager().getPostionInfoSet();
        if (postionInfoSet.stream().anyMatch(ps -> ps.getBasePoints().stream().anyMatch(basePointInfo -> basePointInfo.getBasePointInnerLineInfo().stream().anyMatch(lineInfo -> lineInfo.getDimension().getNumber().equals(dimNum) && lineInfo.getDynaMembScopes().stream().anyMatch(mem -> mem.getMember().getNumber().equals(SystemVarsEnum.CURRENT.getNumber())))))) {
            return true;
        }
        if (!postionInfoSet.isEmpty()) {
            Sheet sheet = this.getEffectiveSheet();
            AtomicBoolean flag = new AtomicBoolean(false);
            for (PositionInfo e : postionInfoSet) {
                RangeModel rangeModel = new RangeModel(e.getAreaRange());
                sheet.iteratorRangeByPredicateBreak(rangeModel.getY_start(), rangeModel.getY_end(), rangeModel.getX_start(), rangeModel.getX_end(), cell -> {
                    if (cell.getMemberFromUserObject() != null && cell.getNotNullMemberUserObject().stream().anyMatch(dimMember -> SystemVarsEnum.CURRENT.getNumber().equals(dimMember.getNumber()))) {
                        flag.set(true);
                        return true;
                    }
                    return false;
                });
                if (!flag.get()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String realctr = e.getProperty().getName();
        Map<String, String> elementMap = this.getSingleElementMap(realctr);
        if (!elementMap.isEmpty()) {
            String panel = elementMap.get(PANEL_KEY);
            String entity = elementMap.get(ENTITY_KEY);
            if (VIEWPANEL_SIGN.equals(panel)) {
                DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
                String oldValue = this.getPageCache().get(realctr);
                if (newValue == null) {
                    this.getPageCache().put(realctr, null);
                    this.updateAllPointMapBySign(realctr, "");
                } else {
                    this.getPageCache().put(realctr, newValue.getString("id"));
                    this.updateAllPointMapBySign(realctr, newValue.getString("id"));
                }
                if ("bcm_scenemembertree".equals(entity) && oldValue != null && newValue != null && !oldValue.equals(newValue.getString("id"))) {
                    this.clearPeriodValue();
                }
            } else if (PAGEPANEL_SIGN.equals(panel)) {
                if (e.getChangeSet()[0].getNewValue() instanceof String && StringUtils.isEmpty((String)((String)e.getChangeSet()[0].getNewValue()))) {
                    this.getPageCache().put(realctr, null);
                    this.updateAllPointMapBySign(realctr, "");
                }
                if ("bcm_scenemembertree".equals(entity)) {
                    this.clearPeriodValue();
                }
            } else if (RANKPANEL_SIGN.equals(panel)) {
                Object newValue = e.getChangeSet()[0].getNewValue();
                if (newValue.toString().equals("false") && this.isSetSystemVarsEnum(elementMap.get(NUMBER_KEY))) {
                    this.showTipAndResetValue(realctr);
                    return;
                }
                this.updateFilterDim((Boolean)newValue, realctr);
            }
        }
    }

    private void updateFilterDim(boolean isAdd, String sign) {
        List<Map<String, String>> mapList = this.getPointEntry();
        Map<Object, Object> map = new HashMap(16);
        int pageNum = -1;
        for (int i = 0; i < mapList.size(); ++i) {
            String s = mapList.get(i).get(SIGN_KEY);
            if (Arrays.asList(s, s + SEPARATOR_SIGN + CHECK_BOX_SIGN).contains(sign)) {
                map = mapList.get(i);
                map.put(VALUE_KEY, Boolean.toString(isAdd));
            }
            if (!mapList.get(i).get(PANEL_KEY).equals(PAGEPANEL_SIGN)) continue;
            pageNum = i;
        }
        if (!map.isEmpty()) {
            String entity = (String)map.get(ENTITY_KEY);
            String number = (String)map.get(NUMBER_KEY);
            if (isAdd) {
                mapList.add(pageNum + 1, this.getDimMessageMap(number, (String)map.get(NAME_KEY), entity, PAGEPANEL_SIGN, "", true));
            } else {
                this.deleteElementMap(mapList, this.buildSign(entity, number, PAGEPANEL_SIGN, true));
            }
            this.getPageCache().put(ALL, SerializationUtils.toJsonString(mapList));
            this.initPage(null);
        }
    }

    private void clearPeriodValue() {
        List<Map<String, String>> list = this.getPointEntry();
        list.forEach(p -> {
            String sign = (String)p.get(SIGN_KEY);
            if (sign.startsWith("bcm_periodmembertree") && !((String)p.get(PANEL_KEY)).equals(RANKPANEL_SIGN)) {
                this.getModel().setValue(sign, null);
                this.getPageCache().put(sign, null);
                this.getView().updateView(sign);
                p.put(VALUE_KEY, "");
                return;
            }
        });
        this.getPageCache().put(ALL, SerializationUtils.toJsonString(list));
    }
}

