/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.basedata.MultiF7Results;
import kd.fi.bcm.business.dimension.data.DimensionMsgCache;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.MembSettingBaseDetail;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.MembAddPositionEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.SelectPageType;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.SpreadSelectTypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.util.DynamicEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.SpreadAreaUtil;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.dimension.util.DimensionUtil;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.SubPage;
import kd.fi.bcm.formplugin.report.floatreport.SeqLogicImpl;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.formplugin.template.util.TemplateExtendModelRefUtil;
import kd.fi.bcm.formplugin.template.util.TemplateFloatUtil;
import kd.fi.bcm.formplugin.util.ObjectConvertUtils;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.Dimension;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.util.TemplateUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class TemplateFloatSettingPlugin
extends AbstractTemplateBasePlugin
implements BeforeF7SelectListener,
SubPage {
    public static final String DISPLAYPATTERN = "displaypattern";
    private static final String entryentity = "entryentity";
    private static final String PAFETYPE = "pagetype";
    private static final String SELECTAREAS = "selectareas";
    private static final String SELECTAREA = "selectarea";
    private static final String DATAAREA = "dataarea";
    private static final String DATAAREAMAP = "dataareamap";
    private static final String FLOATTYPE = "floattype";
    private static final String FLOATMEMTEXT = "floatmemtext";
    private static final String NEWMEMBAS = "newmembas";
    private static final String ISSEQ = "isseq";
    private static final String NEWMEMAREA = "newmemarea";
    private static final String UNFLOATMEM = "unfloatmem";
    private static final String FLOATAREA = "showfloatarea";
    private static final String FLOATAREAINDEX = "floatareaindex";
    private static final String DELETEFLOATAREA = "deletefloatarea";
    private static final String ISHIDE = "ishide";
    private static final String ISFLOAT = "isfloat";
    private static final String NUMBERFROM = "numberfrom";
    private static final String ISSHOWTEXT = "isshowtext";
    private static final String ISSHOWNULL = "isshownull";
    private static final String SORTTOPSETTING = "sorttopsetting";
    private static final String ISSHOWFLOATMEMBER = "isshowfloatmember";
    private static final String FLOATCONFIGSETTING = "floatconfigsetting";
    private static final String POSITIONCACHE = "positioncache";
    private static final String SHOWTIPSISSEQ = "showtipsisseq";
    private static final String MYCOMAUTOCONV = "mycomautoconv";
    private static final String FLEXPANELAP1 = "flexpanelap1";
    private static final String FLEXPANELAP11 = "flexpanelap11";
    private static final String OFFSET = "offset";
    private static final String DIMNUMBER = "dimnumber";
    private DimMember member;

    @Override
    public void initialize() {
        super.initialize();
        BasedataEdit unfloatmem = (BasedataEdit)this.getControl(UNFLOATMEM);
        unfloatmem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid treeEntry = (EntryGrid)this.getControl(entryentity);
        treeEntry.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                TemplateFloatSettingPlugin.this.checkSelectRow(evt);
            }
        });
    }

    private void checkSelectRow(RowClickEvent evt) {
        DynamicObject[] dataEntities;
        int[] rows = ((EntryGrid)evt.getSource()).getSelectRows();
        if (this.checkSelectSameConfig(rows, dataEntities = ((EntryGrid)evt.getSource()).getEntryData().getDataEntitys())) {
            if (rows.length >= 1) {
                this.updateFloatConfigSetting(dataEntities[rows[0]], null);
            } else if (dataEntities.length > 0) {
                this.updateFloatConfigSetting(dataEntities[0], null);
            } else {
                this.updateFloatConfigSetting(null, null);
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEXPANELAP11});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEXPANELAP1});
        }
    }

    private void updateFloatConfigSetting(DynamicObject dataEntity, PositionInfo.FloatConfigSetting configSetting) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEXPANELAP11});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEXPANELAP1});
        this.getView().getModel().beginInit();
        this.showFloatAreaInfo(dataEntity, configSetting);
        this.getView().getModel().endInit();
        this.getView().updateView(FLEXPANELAP1);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEXPANELAP1});
    }

    private boolean checkSelectSameConfig(int[] rows, DynamicObject[] dataEntities) {
        String spreadSerial = this.getPageCache().get(POSITIONCACHE);
        SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)spreadSerial);
        Set psSets = spreadManager.getAreaManager().getPostionInfoSet();
        ArrayList<Integer> myCompanyAutoConvent = new ArrayList<Integer>(16);
        ArrayList<Integer> floatConfigSetting = new ArrayList<Integer>(1);
        ArrayList<Integer> displayPattern = new ArrayList<Integer>(1);
        ArrayList<Boolean> isShowText = new ArrayList<Boolean>(1);
        ArrayList<Boolean> isShowNull = new ArrayList<Boolean>(1);
        ArrayList<Boolean> isShowFloatMember = new ArrayList<Boolean>(1);
        String areaRang = this.getModel().getValue(DATAAREA).toString();
        String ca = this.getPageCache().get(DATAAREAMAP);
        Map map = (Map)SerializationUtils.fromJsonString((String)ca, Map.class);
        for (PositionInfo ps : psSets) {
            if (ps == null || !((String)map.get(areaRang)).equals(ps.getAreaRange())) continue;
            List bps = ps.getBasePoints();
            if (bps != null && !bps.isEmpty()) {
                if (rows != null && rows.length >= 1) {
                    for (int i = 0; i < rows.length; ++i) {
                        for (BasePointInfo basePointInfo : bps) {
                            if (!basePointInfo.getDynaRange().equals(dataEntities[rows[i]].getString(SELECTAREA))) continue;
                            myCompanyAutoConvent.add(basePointInfo.getMyCompanyAutoConvent(ps).getIndex());
                            floatConfigSetting.add(basePointInfo.getFloatConfigSetting(ps).getIndex());
                            displayPattern.add(basePointInfo.getFloatMemDisplayPattern(ps).getIndex());
                            isShowFloatMember.add(basePointInfo.getShowFloatMember(ps));
                            isShowText.add(basePointInfo.getShowFloatText(ps, false));
                            isShowNull.add(basePointInfo.getShowFloatNullOrZero(ps, false));
                        }
                    }
                } else {
                    for (BasePointInfo basePointInfo : bps) {
                        myCompanyAutoConvent.add(basePointInfo.getMyCompanyAutoConvent(ps).getIndex());
                        floatConfigSetting.add(basePointInfo.getFloatConfigSetting(ps).getIndex());
                        displayPattern.add(basePointInfo.getFloatMemDisplayPattern(ps).getIndex());
                        isShowFloatMember.add(basePointInfo.getShowFloatMember(ps));
                        isShowText.add(basePointInfo.getShowFloatText(ps, false));
                        isShowNull.add(basePointInfo.getShowFloatNullOrZero(ps, false));
                    }
                }
            } else {
                return true;
            }
            if (!TemplateFloatSettingPlugin.hasSame(floatConfigSetting) || !TemplateFloatSettingPlugin.hasSame(displayPattern) || !TemplateFloatSettingPlugin.hasSame(isShowFloatMember) || !TemplateFloatSettingPlugin.hasSame(isShowNull) || !TemplateFloatSettingPlugin.hasSame(isShowText) || !TemplateFloatSettingPlugin.hasSame(myCompanyAutoConvent)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSame(List<? extends Object> list) {
        if (null == list) {
            return false;
        }
        return 1 == new HashSet<Object>(list).size();
    }

    private void showFloatAreaInfo(DynamicObject entryData, PositionInfo.FloatConfigSetting configSetting) {
        String spreadSerial = this.getPageCache().get(POSITIONCACHE);
        SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)spreadSerial);
        Set psSets = spreadManager.getAreaManager().getPostionInfoSet();
        String areaRang = this.getModel().getValue(DATAAREA).toString();
        String ca = this.getPageCache().get(DATAAREAMAP);
        Map map = (Map)SerializationUtils.fromJsonString((String)ca, Map.class);
        block0: for (PositionInfo posio : psSets) {
            if (posio == null || !((String)map.get(areaRang)).equals(posio.getAreaRange())) continue;
            List bps = posio.getBasePoints();
            if (bps == null) {
                return;
            }
            if (bps.isEmpty()) {
                this.setDefaultFloatConfigSetting(posio);
            }
            for (BasePointInfo basePointInfo : bps) {
                if (configSetting != null) {
                    basePointInfo.setFloatConfigSetting(configSetting);
                }
                this.getModel().setValue(FLOATCONFIGSETTING, (Object)basePointInfo.getFloatConfigSetting().getIndex());
                this.setOffsetCombox(posio);
                if (entryData == null) {
                    this.setDefaultFloatConfigSetting(posio);
                    break block0;
                }
                if (!basePointInfo.getDynaRange().equals(entryData.getString(SELECTAREA))) continue;
                if (basePointInfo.getFloatConfigSetting().getIndex() == PositionInfo.FloatConfigSetting.TOTAL.getIndex()) {
                    this.setDefaultFloatConfigSetting(posio);
                    break block0;
                }
                if (basePointInfo.getFloatMemDisplayPattern() != null) {
                    this.getModel().setValue(DISPLAYPATTERN, (Object)basePointInfo.getFloatMemDisplayPattern().getIndex());
                }
                this.getModel().setValue(ISSHOWTEXT, (Object)basePointInfo.getShowFolatText());
                this.getModel().setValue(ISSHOWNULL, (Object)basePointInfo.getShowFolatNullOrZero());
                this.getModel().setValue(ISSHOWFLOATMEMBER, (Object)basePointInfo.getShowFloatMember());
                this.getModel().setValue(MYCOMAUTOCONV, (Object)basePointInfo.getMyCompanyAutoConvent().getIndex());
                if (basePointInfo.getShowFloatMember().booleanValue()) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{ISSHOWTEXT, ISSHOWNULL});
                } else {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{ISSHOWTEXT, ISSHOWNULL});
                }
                this.getView().setEnable(Boolean.valueOf(false), new String[]{OFFSET});
                break block0;
            }
        }
    }

    private void setDefaultFloatConfigSetting(PositionInfo posio) {
        if (posio.getFloatMemDisplayPattern() != null) {
            this.getModel().setValue(DISPLAYPATTERN, (Object)posio.getFloatMemDisplayPattern().getIndex());
        }
        if (posio.getOffsetIndex() != null) {
            String value = Joiner.on((String)",").join((Iterable)posio.getOffsetIndex());
            this.getModel().setValue(OFFSET, (Object)value);
        }
        this.getModel().setValue(ISSHOWTEXT, (Object)posio.getShowFolatText());
        this.getModel().setValue(ISSHOWNULL, (Object)posio.getShowFolatNullOrZero());
        this.getModel().setValue(ISSHOWFLOATMEMBER, (Object)posio.getShowFloatMember());
        this.getModel().setValue(MYCOMAUTOCONV, (Object)posio.getMyCompanyAutoConvent().getIndex());
        if (posio.getShowFloatMember().booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{ISSHOWTEXT, ISSHOWNULL});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{ISSHOWTEXT, ISSHOWNULL});
        }
        this.getView().setEnable(Boolean.valueOf(MemberReader.isExistMember((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)DimTypesEnum.AUDITTRIAL.getNumber(), (String)"AutoCWP")), new String[]{OFFSET});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().remove(POSITIONCACHE);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"showpanel"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"areapanel"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"combopanel"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"orglocal"});
        this.getModel().setValue("textfield2", (Object)ResManager.loadKDString((String)"\u8981\u8bbe\u7f6e/\u4fee\u6539\u6d6e\u52a8\u53c2\u6570\uff0c\u9700\u8981\u5148\u8bbe\u7f6e\u597d\u6d6e\u52a8\u8303\u56f4\u3002", (String)"TemplateFloatSettingPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getPageCache().put(PAFETYPE, "show");
        String select = (String)this.getFormCustomParam("select");
        this.getModel().setValue("area", (Object)select);
        this.setDataList();
        this.loadFloatArea();
        this.setValue("isshowseq", ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM007"));
        this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEXPANELAP1});
        this.getPageCache().put(POSITIONCACHE, JsonSerializerUtil.toJson((SpreadManager)this.getSpreadModel()));
        if (this.checkSelectSameConfig(null, null) && this.getPageCache().get(FLOATTYPE) != null) {
            EntryGrid treeEntry = (EntryGrid)this.getControl(entryentity);
            if (treeEntry.getEntryData().getDataEntitys().length > 0) {
                this.updateFloatConfigSetting(treeEntry.getEntryData().getDataEntitys()[0], null);
            } else {
                this.updateFloatConfigSetting(null, null);
            }
        }
        if (!ConfigServiceHelper.getGlobalBoolParam((String)"isShowAllFloatMember")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ISSHOWFLOATMEMBER});
        }
        if (this.getPageCache().get("ischanged") != null) {
            this.getPageCache().remove("ischanged");
        }
        if (!MemberReader.isExistMember((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)DimTypesEnum.AUDITTRIAL.getNumber(), (String)"AutoCWP")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{OFFSET});
        }
        if (TemplateExtendModelRefUtil.isOnlyReadOrQueryTm(this.getTemplateModel()) || this.getFormCustomParam("mycompanyisrc", false).booleanValue() || !ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM043")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{MYCOMAUTOCONV});
        } else if (this.isHideMycomAutoConv()) {
            this.getModel().setValue(MYCOMAUTOCONV, (Object)PositionInfo.MyCompanyAutoConvent.NO.getIndex());
            this.getView().setEnable(Boolean.valueOf(false), new String[]{MYCOMAUTOCONV});
        }
    }

    private boolean isHideMycomAutoConv() {
        Optional<ViewPointDimensionEntry> viewPointDimensionEntry = this.getTemplateModel().getViewPointDimensionEntries().stream().filter(v -> v.getDimension().getNumber().equals(DimTypesEnum.MYCOMPANY.getNumber())).findFirst();
        if (viewPointDimensionEntry.isPresent() && this.isMycompany(viewPointDimensionEntry.get().getMember())) {
            return false;
        }
        Optional<PageDimensionEntry> optional = this.getTemplateModel().getPageDimensionEntries().stream().filter(v -> v.getDimension().getNumber().equals(DimTypesEnum.MYCOMPANY.getNumber())).findFirst();
        return !optional.isPresent() || !optional.get().getMembers().stream().anyMatch(e -> this.isMycompany((Member)e));
    }

    private boolean isMycompany(Member member) {
        String number = member.getNumber();
        IDNumberTreeNode treeNode = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)DimTypesEnum.MYCOMPANY.getNumber(), (String)number);
        if (treeNode.getStorageType() == StorageTypeEnum.DYNAMIC) {
            RangeEnum rangeEnum = RangeEnum.getRangeByVal((int)member.getScope());
            return RangeEnum.VALUE_20 != rangeEnum && RangeEnum.VALUE_40 != rangeEnum && RangeEnum.VALUE_60 != rangeEnum && RangeEnum.VALUE_90 != rangeEnum;
        }
        return false;
    }

    private void setDataList() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        String pssch = (String)this.getView().getFormShowParameter().getCustomParam("ps");
        PositionInfo ps = (PositionInfo)this.deSerializedBytes(pssch);
        ComboEdit comboEdit = (ComboEdit)this.getControl(DATAAREA);
        ArrayList items = new ArrayList(10);
        ArrayList<String[]> keysAndValues = new ArrayList<String[]>(10);
        int i = 1;
        int val = 1;
        for (PositionInfo e : this.getSpreadModel().getAreaManager().getPostionInfoSet()) {
            String[] keysAndValue = new String[]{e.getAreaRange(), String.valueOf(i)};
            map.put(keysAndValue[1], keysAndValue[0]);
            keysAndValues.add(keysAndValue);
            if (ps.getAreaRange().equals(e.getAreaRange())) {
                val = i;
            }
            ++i;
        }
        keysAndValues.forEach(new DynamicEnum(items));
        comboEdit.setComboItems(items);
        this.getPageCache().put(DATAAREAMAP, SerializationUtils.toJsonString(map));
        this.getModel().setValue(DATAAREA, (Object)val);
        this.getView().setVisible(Boolean.valueOf(i > 2), new String[]{"lab_datanoti"});
    }

    private String getFloatTypeFromModel() {
        for (PositionInfo p : this.getSpreadModel().getAreaManager().getPostionInfoSet()) {
            if (p.getExtendInfo() != null) {
                return "row";
            }
            Iterator iterator = p.getBasePoints().iterator();
            if (!iterator.hasNext()) continue;
            BasePointInfo bs = (BasePointInfo)iterator.next();
            if (1 == bs.getDirect()) {
                return "col";
            }
            return "row";
        }
        return null;
    }

    public void addFloatArea(String select) {
        TemplateFloatUtil.checkCell(select);
        String spreadSerial = this.getPageCache().get(POSITIONCACHE);
        SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)spreadSerial);
        Set psSets = spreadManager.getAreaManager().getPostionInfoSet();
        String areaRang = this.getModel().getValue(DATAAREA).toString();
        String ca = this.getPageCache().get(DATAAREAMAP);
        Map map = (Map)SerializationUtils.fromJsonString((String)ca, Map.class);
        for (PositionInfo ps : psSets) {
            if (ps == null || !((String)map.get(areaRang)).equals(ps.getAreaRange())) continue;
            SpreadSelectTypeEnum type0 = SpreadAreaUtil.selectedInCanFloatArea((String)select, (String)ps.getStartPosition(), (String)ps.getAreaRange());
            String floattype = this.getPageCache().get(FLOATTYPE);
            DynamicObjectCollection dcs = this.getModel().getEntryEntity(entryentity);
            int index = dcs.size();
            if (index == 0) {
                floattype = null;
            }
            if (floattype == null) {
                floattype = this.getFloatTypeFromModel();
            }
            switch (type0) {
                case LEFT_BOTTOM: {
                    if (kd.bos.util.StringUtils.isNotEmpty((String)floattype) && "col".equals(floattype)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u5df2\u7ecf\u8bbe\u7f6e\u5217\u6d6e\u52a8\uff0c\u53ea\u53ef\u652f\u6301\u5217\u6d6e\u52a8\u3002", (String)"TemplateFloatSettingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                    if (TemplateFloatUtil.isCanFloatSet(2, select, ps.getAreaRange(), this.getSpreadModel().getAreaManager().getPostionInfoSet())) {
                        this.getPageCache().put(FLOATTYPE, "row");
                        break;
                    }
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u662f\u7eaf\u4e0a\u4e0b\u7ed3\u6784\uff0c\u4e0d\u652f\u6301\u884c\u6d6e\u52a8\u3002", (String)"TemplateFloatSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                case RIGHT_TOP: {
                    if (kd.bos.util.StringUtils.isNotEmpty((String)floattype) && "row".equals(floattype)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u5df2\u7ecf\u8bbe\u7f6e\u884c\u6d6e\u52a8\uff0c\u53ea\u53ef\u652f\u6301\u884c\u6d6e\u52a8\u3002", (String)"TemplateFloatSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                    if (TemplateFloatUtil.isCanFloatSet(1, select, ps.getAreaRange(), this.getSpreadModel().getAreaManager().getPostionInfoSet())) {
                        this.getPageCache().put(FLOATTYPE, "col");
                        break;
                    }
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u662f\u7eaf\u5de6\u53f3\u7ed3\u6784\uff0c\u4e0d\u652f\u6301\u5217\u6d6e\u52a8\u3002", (String)"TemplateFloatSettingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                default: {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u8303\u56f4\u4e0d\u53ef\u8bbe\u7f6e\u5f53\u524d\u533a\u57df\u7684\u6d6e\u52a8\u3002", (String)"TemplateFloatSettingPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
            this.put2SelectAreas(select);
            MainEntityType maintype = this.getModel().getDataEntityType();
            EntryType entityType = (EntryType)maintype.getAllEntities().get(entryentity);
            floattype = this.getPageCache().get(FLOATTYPE);
            List list = null;
            AreaRangeEntry are = this.getAreaRangeEntryBySelectArea(ps.getAreaRange());
            list = "row".equals(floattype) ? are.getRowDimEntries() : are.getColDimEntries();
            for (MembSettingBaseDetail dim : list) {
                DynamicObject rowObj = new DynamicObject((DynamicObjectType)entityType);
                rowObj.set(SELECTAREA, (Object)select);
                String dimNum = dim.getDimension().getNumber();
                rowObj.set("dim", (Object)dim.getDimension().getMemberEntityNumber());
                rowObj.set("muldim", (Object)dim.getDimension().getMemberEntityNumber());
                rowObj.set("showdim", (Object)dim.getDimension().getName());
                rowObj.set(DIMNUMBER, (Object)dimNum);
                this.getModel().createNewEntryRow(entryentity, index, rowObj);
                this.doHidePageRuler(false, dimNum, index);
                this.checkEnable(dim.getDimension().getMemberEntityNumber(), dimNum, index);
                ++index;
            }
            this.setOffsetCombox(ps);
            int direct = "row".equals(floattype) ? 2 : 1;
            BasePointInfo basePointInfo = new BasePointInfo(select, direct);
            List basePoints = ps.getBasePoints();
            basePoints.add(basePointInfo);
            ps.setBasePoints(basePoints);
            this.setNewAddFloatConfigSetting(ps);
            this.setEntryData(ps);
        }
        this.showTipsForIsseq();
    }

    private void setNewAddFloatConfigSetting(PositionInfo ps) {
        String spreadSerial = this.getPageCache().get(POSITIONCACHE);
        SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)spreadSerial);
        Set psSets = spreadManager.getAreaManager().getPostionInfoSet();
        for (PositionInfo positionInfo : psSets) {
            if (positionInfo == null || ps == null) continue;
            this.setPositionInfoConfig(ps, positionInfo);
            break;
        }
    }

    private AreaRangeEntry getAreaRangeEntryBySelectArea(String selectarea) {
        AreaRangeEntry are = null;
        for (AreaRangeEntry entity : this.getTemplateModel().getAreaRangeEntries()) {
            if (!SpreadAreaUtil.isInArea((String)selectarea, (String)entity.getAreaRange())) continue;
            are = entity;
            break;
        }
        if (are == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7b26\u5408\u7684\u533a\u57df\u3002", (String)"TemplateFloatSettingPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return are;
    }

    private void checkEnable(String entity, String dimnum, int index) {
        if ("bcm_userdefinedmembertree".equals(entity) || "bcm_icmembertree".equals(entity)) {
            if (!this.getTemplateModel().isAllowaddic() && "bcm_icmembertree".equals(entity)) {
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{NEWMEMBAS});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), index, new String[]{NEWMEMBAS});
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{NEWMEMBAS});
        }
        DimMember member = this.getSeqMem();
        if (dimnum != null && member != null) {
            if (dimnum.equals(member.getDimension().getNumber())) {
                this.getView().setEnable(Boolean.valueOf(true), index, new String[]{ISSEQ});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{ISSEQ});
                this.getView().setEnable(Boolean.valueOf(DimTypesEnum.MYCOMPANY.getNumber().equals(dimnum)), index, new String[]{ISHIDE});
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{ISSEQ});
            this.getView().setEnable(Boolean.valueOf(DimTypesEnum.MYCOMPANY.getNumber().equals(dimnum)), index, new String[]{ISHIDE});
        }
        if (!((Boolean)this.getModel().getValue(ISFLOAT, index)).booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{ISHIDE});
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("advcontoolbarap", "toolbarap", "toolbarap1", "toolbaraporg");
        this.addClickListeners("btn-cancel", "btn-confirm");
        this.addClickListeners(NEWMEMBAS, FLOATMEMTEXT, FLOATAREA, SORTTOPSETTING);
        BasedataEdit numberfrom = (BasedataEdit)this.getControl(NUMBERFROM);
        numberfrom.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                QFBuilder qb = new QFBuilder("model", "=", (Object)TemplateFloatSettingPlugin.this.getModelId());
                qb.add("number", "=", (Object)DimTypesEnum.ENTITY.getNumber());
                beforeF7SelectEvent.getCustomQFilters().addAll(qb.toList());
            }
        });
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar-add": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"showpanel"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"areapanel"});
                this.getPageCache().put(PAFETYPE, SelectPageType.FLOAT.getName());
                break;
            }
            case "bar-confirm": {
                String select = (String)this.getModel().getValue("area");
                this.addFloatArea(select);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"showpanel"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"areapanel"});
                this.getPageCache().put(PAFETYPE, "show");
                this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEXPANELAP11});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEXPANELAP1});
                this.showFloatConfigInfo();
                break;
            }
            case "bar-confirmfloat": {
                EntryGrid eg = (EntryGrid)this.getControl(entryentity);
                List<String> list = this.getSelectRowFloatRowOrCol();
                if (kd.bos.util.StringUtils.isNotEmpty((String)((String)this.getModel().getValue("combofield")))) {
                    int index = Integer.parseInt((String)this.getModel().getValue("combofield"));
                    this.getModel().setValue(FLOATAREAINDEX, (Object)index, eg.getSelectRows()[0]);
                    this.getModel().setValue(FLOATAREA, (Object)this.buildComboShowName(list.get(index)), eg.getSelectRows()[0]);
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"showpanel"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"combopanel"});
                this.getPageCache().put(PAFETYPE, "show");
                break;
            }
            case "bar-del": {
                EntryGrid entry = (EntryGrid)this.getControl(entryentity);
                int[] selectrows = entry.getEntryState().getSelectedRows();
                if (selectrows.length < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"TemplateFloatSettingPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    break;
                }
                StringBuilder sb = new StringBuilder();
                HashSet<String> areas = new HashSet<String>(selectrows.length);
                for (int selectttt : selectrows) {
                    DynamicObjectCollection dcs = this.getModel().getEntryEntity(entryentity);
                    String area = ((DynamicObject)dcs.get(selectttt)).getString(SELECTAREA);
                    areas.add(area);
                }
                Object object = areas.iterator();
                while (object.hasNext()) {
                    String area = (String)object.next();
                    sb.append(area).append(",");
                }
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u6d6e\u52a8\u8303\u56f4\uff1a%s\u3002", (String)"TemplateFloatSettingPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sb.substring(0, sb.length() - 1) + "?"), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DELETEFLOATAREA, (IFormPlugin)this));
                break;
            }
        }
    }

    private void showFloatConfigInfo() {
        DynamicObject[] dataEntities;
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryentity);
        int[] rows = entryGrid.getSelectRows();
        if (this.checkSelectSameConfig(rows, dataEntities = entryGrid.getEntryData().getDataEntitys())) {
            if (rows.length >= 1) {
                this.updateFloatConfigSetting(dataEntities[rows[0]], null);
            } else if (dataEntities.length > 0) {
                this.updateFloatConfigSetting(dataEntities[0], null);
            } else {
                this.updateFloatConfigSetting(null, null);
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEXPANELAP11});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEXPANELAP1});
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callback;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callback = messageBoxClosedEvent.getCallBackId()) {
            case "deletefloatarea": {
                if (MessageBoxResult.Yes != messageBoxClosedEvent.getResult()) break;
                this.deleteFloatArea();
                break;
            }
            case "ICADDAS": {
                if (MessageBoxResult.Yes != messageBoxClosedEvent.getResult()) break;
                EntryGrid eg = (EntryGrid)this.getControl(entryentity);
                DynamicObject ic = QueryServiceHelper.queryOne((String)"bcm_icmembertree", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("number", "=", (Object)"ICOEntity")});
                String showtext = this.buildNewmembasShowname(ic.getString("name"), 1);
                this.getModel().setValue(NEWMEMBAS, (Object)showtext, eg.getSelectRows()[0]);
                this.getModel().setValue(NEWMEMAREA, ic.get("id"), eg.getSelectRows()[0]);
                this.getModel().setValue("scope", (Object)1, eg.getSelectRows()[0]);
                break;
            }
            case "floatconfigsettingpart": {
                if (MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
                    EntryGrid eg = (EntryGrid)this.getControl(entryentity);
                    this.getPageCache().put("ischanged", "true");
                    this.getModel().beginInit();
                    this.resetFloatConfig(eg.getSelectRows(), eg.getEntryData().getDataEntitys(), PositionInfo.FloatConfigSetting.TOTAL);
                    if (eg.getSelectRows().length > 0) {
                        this.showFloatAreaInfo(eg.getEntryData().getDataEntitys()[eg.getSelectRows()[0]], PositionInfo.FloatConfigSetting.PART);
                    } else {
                        this.showFloatAreaInfo(null, PositionInfo.FloatConfigSetting.PART);
                    }
                    this.getModel().endInit();
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{OFFSET});
                    this.getView().updateView(FLEXPANELAP1);
                } else {
                    this.getModel().beginInit();
                    this.getModel().setValue(FLOATCONFIGSETTING, (Object)PositionInfo.FloatConfigSetting.TOTAL.getIndex());
                    this.getModel().endInit();
                    this.getView().updateView(FLEXPANELAP1);
                }
                this.updatePageCache();
                break;
            }
            case "floatconfigsettingtotal": {
                if (MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
                    EntryGrid eg = (EntryGrid)this.getControl(entryentity);
                    if (eg.getSelectRows().length > 0) {
                        DynamicObject obj = this.getModel().getEntryRowEntity(entryentity, eg.getSelectRows()[0]);
                        this.showFloatAreaInfo(obj, PositionInfo.FloatConfigSetting.TOTAL);
                    } else {
                        this.showFloatAreaInfo(null, PositionInfo.FloatConfigSetting.TOTAL);
                    }
                    this.getPageCache().put("ischanged", "true");
                } else {
                    this.getModel().beginInit();
                    this.getModel().setValue(FLOATCONFIGSETTING, (Object)PositionInfo.FloatConfigSetting.PART.getIndex());
                    this.getModel().endInit();
                    this.getView().updateView(FLEXPANELAP1);
                }
                this.updatePageCache();
                break;
            }
        }
    }

    private void resetFloatConfig(int[] selectRows, DynamicObject[] dataEntitys, PositionInfo.FloatConfigSetting configSetting) {
        String spreadSerial = this.getPageCache().get(POSITIONCACHE);
        SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)spreadSerial);
        Set psSets = spreadManager.getAreaManager().getPostionInfoSet();
        String areaRang = this.getModel().getValue(DATAAREA).toString();
        String ca = this.getPageCache().get(DATAAREAMAP);
        Map map = (Map)SerializationUtils.fromJsonString((String)ca, Map.class);
        for (PositionInfo ps : psSets) {
            if (ps == null || !((String)map.get(areaRang)).equals(ps.getAreaRange()) || selectRows.length <= 0 || configSetting.getIndex() != 1) continue;
            HashSet<String> selectArea = new HashSet<String>(selectRows.length);
            for (int i = 0; i < selectRows.length; ++i) {
                selectArea.add(dataEntitys[selectRows[i]].getString(SELECTAREA));
            }
            List basePointInfos = ps.getBasePoints();
            if (basePointInfos == null || basePointInfos.isEmpty()) continue;
            for (BasePointInfo basePointInfo : basePointInfos) {
                if (!selectArea.contains(basePointInfo.getDynaRange())) continue;
                basePointInfo.setFloatMemDisplayPattern(PositionInfo.FloatMemDisplayPattern.NAME);
                basePointInfo.setShowFolatText(Boolean.valueOf(true));
                basePointInfo.setShowFolatNullOrZero(Boolean.valueOf(false));
                basePointInfo.setShowFloatMember(Boolean.valueOf(false));
                basePointInfo.setMyCompanyAutoConvent(PositionInfo.MyCompanyAutoConvent.NO);
            }
        }
        this.getPageCache().put(POSITIONCACHE, JsonSerializerUtil.toJson((SpreadManager)spreadManager));
    }

    private void deleteFloatArea() {
        EntryGrid entry = (EntryGrid)this.getControl(entryentity);
        int[] selectrows = entry.getEntryState().getSelectedRows();
        DynamicObjectCollection dcs = this.getModel().getEntryEntity(entryentity);
        HashSet<Integer> deleteset = new HashSet<Integer>(16);
        for (int selectttt : selectrows) {
            String area = ((DynamicObject)dcs.get(selectttt)).getString(SELECTAREA);
            for (int i = 0; i < dcs.size(); ++i) {
                if (area.equals(((DynamicObject)dcs.get(i)).getString(SELECTAREA))) {
                    String selectarea = ((DynamicObject)dcs.get(i)).getString(SELECTAREA);
                    this.removeFromSelectAreas(selectarea);
                    deleteset.add(i);
                }
                this.getPageCache().remove(area + SORTTOPSETTING);
            }
        }
        int[] focus = ArrayUtils.toPrimitive((Integer[])deleteset.toArray(new Integer[deleteset.size()]));
        this.getModel().deleteEntryRows(entryentity, focus);
    }

    private void loadFloatArea() {
        this.getModel().deleteEntryData(entryentity);
        String pssch = (String)this.getView().getFormShowParameter().getCustomParam("ps");
        PositionInfo ps = (PositionInfo)this.deSerializedBytes(pssch);
        PositionInfo posio = this.getSpreadModel().getAreaManager().searchStorePositionInfodev(ps);
        DimensionMsgCache dmc = new DimensionMsgCache(this.getModelId());
        HashMap<String, Map<String, Map<String, List<IDimMember>>>> notExitMember = new HashMap<String, Map<String, Map<String, List<IDimMember>>>>(16);
        String modelNumber = MemberReader.findModelNumberById((Object)this.getModelId());
        String templateNumber = this.getTemplateModel().getNumber();
        if (posio != null) {
            List bps = posio.getBasePoints();
            if (bps == null) {
                return;
            }
            for (BasePointInfo basePointInfo : bps) {
                List lines = basePointInfo.getBasePointInnerLineInfo();
                String floatRange = basePointInfo.getDynaRange();
                int direct = basePointInfo.getDirect();
                String floattype = direct == 1 ? "col" : "row";
                this.getPageCache().put(FLOATTYPE, floattype);
                List settingOrder = basePointInfo.getTopSettingOrder();
                if (settingOrder != null && !settingOrder.isEmpty()) {
                    this.getPageCache().put(basePointInfo.getDynaRange() + SORTTOPSETTING, ObjectSerialUtil.toByteSerialized((Object)settingOrder));
                }
                for (BasePointInnerLineInfo basePointInnerLineInfo : lines) {
                    List roclist;
                    String dimNum = basePointInnerLineInfo.getDimension().getNumber();
                    int newrow = this.getModel().createNewEntryRow(entryentity);
                    DynamicObject rowObj = this.getModel().getEntryRowEntity(entryentity, newrow);
                    rowObj.set(SELECTAREA, (Object)basePointInfo.getDynaRange());
                    String entity = DimensionUtil.getDimMembEntityNumByDimNum(dimNum);
                    rowObj.set("dim", (Object)entity);
                    rowObj.set("muldim", (Object)entity);
                    rowObj.set("showdim", (Object)basePointInnerLineInfo.getDimension().getName());
                    rowObj.set(DIMNUMBER, (Object)dimNum);
                    rowObj.set(ISFLOAT, (Object)basePointInnerLineInfo.isFloated());
                    rowObj.set(ISSEQ, (Object)basePointInnerLineInfo.isSeq());
                    rowObj.set(ISHIDE, (Object)basePointInnerLineInfo.isIshide());
                    if ((basePointInnerLineInfo.isIshide() || DimTypesEnum.MYCOMPANY.getNumber().equals(dimNum)) && kd.bos.util.StringUtils.isNotEmpty((String)basePointInnerLineInfo.getNumberfrom())) {
                        DynamicObject numberfrom = MemberReader.getDimensionDynById((long)dmc.getDimId(basePointInnerLineInfo.getNumberfrom()));
                        rowObj.set(NUMBERFROM, (Object)numberfrom);
                    }
                    if (basePointInnerLineInfo.isFloated()) {
                        if (settingOrder != null && !settingOrder.isEmpty()) {
                            rowObj.set(SORTTOPSETTING, (Object)this.creatSortTopSettingStr(settingOrder, basePointInfo.getDynaRange(), posio.getAreaRange()));
                        }
                        if (basePointInnerLineInfo.getMemberAddOf(false) != null) {
                            IDimMember memberAddOf = basePointInnerLineInfo.getMemberAddOf(false);
                            Object newmemarea = null;
                            try {
                                newmemarea = BusinessDataServiceHelper.loadSingle((Object)((DimMember)memberAddOf).getId(), (String)entity);
                                rowObj.set(NEWMEMAREA, newmemarea);
                                rowObj.set(NEWMEMBAS, (Object)this.buildNewmembasShowname(newmemarea.getString("name"), basePointInnerLineInfo.getAddPositionEnum(false).getVal()));
                                rowObj.set("scope", (Object)basePointInnerLineInfo.getAddPositionEnum(false).getVal());
                            }
                            catch (Exception e) {
                                TemplateFloatUtil.collectNotExitMemForFLoat(floatRange, memberAddOf, NEWMEMBAS, notExitMember, templateNumber);
                            }
                        }
                        roclist = "row".equals(floattype) ? (List)SpreadAreaUtil.getCol((String)basePointInfo.getDynaRange()) : (List)SpreadAreaUtil.getRow((String)basePointInfo.getDynaRange());
                        if (!basePointInnerLineInfo.isSeq() && !basePointInnerLineInfo.isIshide()) {
                            if (roclist.size() <= basePointInnerLineInfo.getOffset()) {
                                basePointInnerLineInfo.setOffset(0);
                            }
                            rowObj.set(FLOATAREAINDEX, (Object)basePointInnerLineInfo.getOffset());
                            rowObj.set(FLOATAREA, (Object)this.buildComboShowName((String)roclist.get(basePointInnerLineInfo.getOffset())));
                        }
                        List ds = basePointInnerLineInfo.getDynaMembScopes();
                        for (DynaMembScopeInfo dynaMembScopeInfo : ds) {
                            IDimMember member;
                            if (dynaMembScopeInfo.isCustom()) {
                                if (SystemVarsEnum.PR_NONE.getNumber().equals(dynaMembScopeInfo.getMember().getNumber())) continue;
                                entity = "bcm_definedpropertyvalue";
                                IDNumberTreeNode node = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_definedpropertyvalue", (Long)dynaMembScopeInfo.getMember().getId());
                                if (node == IDNumberTreeNode.NotFoundTreeNode) continue;
                                rowObj.set("muldim", (Object)"bcm_definedpropertyvalue");
                                continue;
                            }
                            if (dynaMembScopeInfo.getMember() == null || MemberReader.findMemberByNumber((String)modelNumber, (String)(member = dynaMembScopeInfo.getMember()).getDimension().getNumber(), (String)member.getNumber()) != IDNumberTreeNode.NotFoundTreeNode) continue;
                            TemplateFloatUtil.collectNotExitMemForFLoat(floatRange, member, FLOATMEMTEXT, notExitMember, templateNumber);
                        }
                        MultiF7Results multiF7Results = MultiF7Results.buildParam((long)this.getModelId(), (List)ds);
                        if (multiF7Results != null) {
                            rowObj.set(FLOATMEMTEXT, (Object)multiF7Results.getShowText());
                            this.put2FloatMemMap(basePointInfo.getDynaRange(), dimNum, multiF7Results.toList());
                        }
                        this.doHidePageRuler(basePointInnerLineInfo.isIshide(), dimNum, newrow);
                    } else if (!basePointInnerLineInfo.getDynaMembScopes().isEmpty()) {
                        DynaMembScopeInfo ms = (DynaMembScopeInfo)basePointInnerLineInfo.getDynaMembScopes().get(0);
                        try {
                            DynamicObject unfloatmem = BusinessDataServiceHelper.loadSingle((Object)((DimMember)ms.getMember()).getId(), (String)entity);
                            rowObj.set(UNFLOATMEM, (Object)unfloatmem);
                        }
                        catch (Exception e) {
                            TemplateFloatUtil.collectNotExitMemForFLoat(floatRange, ms.getMember(), UNFLOATMEM, notExitMember, templateNumber);
                        }
                        roclist = "row".equals(floattype) ? (List)SpreadAreaUtil.getCol((String)basePointInfo.getDynaRange()) : (List)SpreadAreaUtil.getRow((String)basePointInfo.getDynaRange());
                        if (!basePointInnerLineInfo.isSeq() && !basePointInnerLineInfo.isIshide() && basePointInnerLineInfo.getOffset() != -1 && roclist.size() > basePointInnerLineInfo.getOffset()) {
                            rowObj.set(FLOATAREAINDEX, (Object)basePointInnerLineInfo.getOffset());
                            rowObj.set(FLOATAREA, (Object)this.buildComboShowName((String)roclist.get(basePointInnerLineInfo.getOffset())));
                        }
                    }
                    this.checkEnable(entity, dimNum, newrow);
                }
                this.put2SelectAreas(basePointInfo.getDynaRange());
            }
            this.setOffsetCombox(posio);
            if (posio.getFloatMemDisplayPattern() != null) {
                this.getModel().setValue(DISPLAYPATTERN, (Object)posio.getFloatMemDisplayPattern().getIndex());
            }
            if (posio.getOffsetIndex() != null) {
                String value = Joiner.on((String)",").join((Iterable)posio.getOffsetIndex());
                this.getModel().setValue(OFFSET, (Object)value);
            }
            this.getModel().setValue(ISSHOWTEXT, (Object)posio.getShowFolatText());
            this.getModel().setValue(ISSHOWNULL, (Object)posio.getShowFolatNullOrZero());
            this.getModel().setValue(MYCOMAUTOCONV, (Object)posio.getMyCompanyAutoConvent().getIndex());
        }
        this.showTipsForIsseq();
        if (!notExitMember.isEmpty()) {
            this.getView().showTipNotification(TemplateFloatUtil.getTipsForNotExitMember(notExitMember, false), Integer.valueOf(7000));
        }
    }

    private void showTipsForIsseq() {
        if (this.getPageCache().get(SHOWTIPSISSEQ) != null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f5c\u4e3a\u5e8f\u53f7\u7684\u6210\u5458\u4e0d\u552f\u4e00\u3002", (String)"TemplateFloatSettingPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getPageCache().remove(SHOWTIPSISSEQ);
        }
    }

    private void checkTopSetting(Map<String, List<Integer>> floatMap) {
        if (floatMap.isEmpty()) {
            return;
        }
        floatMap.forEach((k, v) -> {
            String temp = this.getPageCache().get(k + SORTTOPSETTING);
            if (temp != null) {
                List map = (List)ObjectSerialUtil.deSerializedBytes((String)temp);
                ArrayList<Integer> memshowOneList = new ArrayList<Integer>(16);
                for (Map single : map) {
                    if (!single.getOrDefault("memshowone", false).booleanValue()) continue;
                    memshowOneList.add((Integer)single.get("orderby"));
                }
                if (!memshowOneList.isEmpty() && v.size() <= memshowOneList.size()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6d6e\u52a8\u533a\u57df\u4e2d\uff0c\u6d6e\u52a8\u7684\u884c\u6216\u5217\u4e0d\u80fd\u90fd\u8bbe\u7f6e\u91cd\u590d\u6210\u5458\u5355\u4e00\u663e\u793a\uff0c\u5fc5\u987b\u81f3\u5c11\u6709\u4e00\u4e2a\u5e38\u89c4\u663e\u793a\u7684\u6d6e\u52a8\u884c\u6216\u5217\u3002", (String)"TemplateFloatSettingPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    private void saveModel() {
        String pssch = (String)this.getView().getFormShowParameter().getCustomParam("ps");
        PositionInfo ps = (PositionInfo)this.deSerializedBytes(pssch);
        PositionInfo posio = this.getSpreadModel().getAreaManager().searchStorePositionInfodev(ps);
        DynamicObjectCollection doc = this.getModel().getEntryEntity(entryentity);
        EntryGrid entryen = (EntryGrid)this.getControl(entryentity);
        int[] selectrows = entryen.getEntryState().getSelectedRows();
        HashSet<String> selectArea = new HashSet<String>(selectrows.length);
        for (int i = 0; i < selectrows.length; ++i) {
            selectArea.add(entryen.getEntryData().getDataEntitys()[selectrows[i]].getString(SELECTAREA));
        }
        HashMap<String, List<Integer>> floatMap = new HashMap<String, List<Integer>>(16);
        LinkedHashMap map = new LinkedHashMap(16);
        for (DynamicObject obj : doc) {
            int index;
            String select = obj.getString(SELECTAREA);
            List list = map.get(select) == null ? new ArrayList(10) : (List)map.get(select);
            list.add(obj);
            map.put(select, list);
            List list1 = floatMap.computeIfAbsent(select, k -> new ArrayList(16));
            if (!obj.getBoolean(ISFLOAT) || !kd.bos.util.StringUtils.isNotEmpty((String)obj.getString(FLOATAREAINDEX)) || list1.contains(index = obj.getInt(FLOATAREAINDEX))) continue;
            list1.add(index);
        }
        Set set = map.entrySet();
        ArrayList<BasePointInfo> basePoints = new ArrayList<BasePointInfo>(set.size());
        HashSet emptyRangeAreaSet = Sets.newHashSetWithExpectedSize((int)16);
        boolean orgInRank = this.getTemplateModel().getRank().contains(DimTypesEnum.ENTITY.getNumber());
        for (Map.Entry entry : set) {
            Object floattype;
            if (this.isFloatAreaCrossSeqArea((String)entry.getKey(), posio)) {
                this.seqCrossWarning((String)entry.getKey(), posio.getSequenceInfo().getSeqArea());
            }
            int direct = "row".equals(floattype = this.getPageCache().get(FLOATTYPE)) ? 2 : 1;
            BasePointInfo bp = new BasePointInfo((String)entry.getKey(), direct);
            this.dealTopSetting(bp);
            List list = (List)entry.getValue();
            boolean present = list.stream().filter(dynamicObject -> dynamicObject.getBoolean(ISFLOAT)).findAny().isPresent();
            if (!present) {
                this.noFloatDataWarning();
            }
            boolean isExitMemFrom = false;
            for (DynamicObject obj : list) {
                boolean isFloated = obj.getBoolean(ISFLOAT);
                boolean isSeq = obj.getBoolean(ISSEQ);
                boolean ishide = obj.getBoolean(ISHIDE);
                DynamicObject numberfrom = obj.getDynamicObject(NUMBERFROM);
                if (numberfrom != null) {
                    if (orgInRank) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u7ec4\u7ec7\u5728\u884c\u5217\u7ef4\u65f6\uff0c\u4e0d\u652f\u6301\u8bbe\u7f6e\u6d6e\u52a8\u7ef4\u5ea6\u7684\u7f16\u7801\u6765\u6e90\u4e3a\u7ec4\u7ec7\u3002", (String)"TemplateFloatSettingPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                    if (isExitMemFrom) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4e00\u4e2a\u6d6e\u52a8\u533a\u57df\u8bbe\u7f6e\u4e2d\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u7f16\u7801\u6765\u6e90\u4e3a\u7ec4\u7ec7\u7684\u8bb0\u5f55\u3002", (String)"TemplateFloatSettingPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                }
                String name = obj.getString("showdim");
                String number = obj.getString(DIMNUMBER);
                String dimentity = obj.getString("dim");
                Dimension dimension = new Dimension(name, number, dimentity);
                BasePointInnerLineInfo bpl = new BasePointInnerLineInfo(bp, (IDimension)dimension, isFloated);
                if (isFloated) {
                    DynamicObject memto;
                    String message;
                    if (!ishide && kd.bos.util.StringUtils.isNotEmpty((String)(message = this.dealMemRange(bpl, obj, dimension)))) {
                        emptyRangeAreaSet.add(message);
                    }
                    if ((memto = obj.getDynamicObject(NEWMEMAREA)) != null && !isSeq) {
                        DimMember memberAddOf = (DimMember)ObjectConvertUtils.toDimMember(memto, (IDimension)dimension);
                        memberAddOf.setId(memto.getLong("id"));
                        bpl.setMemberAddOf((IDimMember)memberAddOf);
                        int scope = obj.getInt("scope");
                        if (scope == 1) {
                            bpl.setAddPositionEnum(MembAddPositionEnum.DirectChild);
                        } else {
                            bpl.setAddPositionEnum(MembAddPositionEnum.Brother);
                        }
                    }
                    if (!isSeq && !ishide) {
                        if (kd.bos.util.StringUtils.isEmpty((String)obj.getString(FLOATAREAINDEX))) {
                            String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u5b8c\u6574\u586b\u5199\u7b2c%s\u884c\u7684\u663e\u793a\u4f4d\u7f6e\u3002", (String)"TemplateFloatSettingPlugin_44", (String)"fi-bcm-formplugin", (Object[])new Object[0]), obj.getInt("seq"));
                            throw new KDBizException(msg);
                        }
                        int offset = obj.getInt(FLOATAREAINDEX);
                        bpl.setOffset(offset);
                    }
                    boolean isContinue = DimTypesEnum.MYCOMPANY.getNumber().equals(number);
                    if (ishide) {
                        bpl.setIshide(true);
                        if (numberfrom == null) {
                            String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u5b8c\u6574\u586b\u5199\u7b2c%s\u884c\u7684\u7f16\u7801\u6765\u6e90\u3002", (String)"TemplateFloatSettingPlugin_41", (String)"fi-bcm-formplugin", (Object[])new Object[0]), obj.getInt("seq"));
                            throw new KDBizException(msg);
                        }
                        if (memto == null && !isContinue) {
                            String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u5b8c\u6574\u586b\u5199\u7b2c%s\u884c\u7684\u65b0\u589e\u6210\u5458\u3002", (String)"TemplateFloatSettingPlugin_42", (String)"fi-bcm-formplugin", (Object[])new Object[0]), obj.getInt("seq"));
                            throw new KDBizException(msg);
                        }
                        isContinue = true;
                    }
                    if (Objects.nonNull(numberfrom) && isContinue) {
                        bpl.setNumberfrom(numberfrom.getString("number"));
                        isExitMemFrom = true;
                    }
                } else {
                    ArrayList<DynaMembScopeInfo> ds = new ArrayList<DynaMembScopeInfo>(1);
                    DynamicObject unfloatmem = obj.getDynamicObject(UNFLOATMEM);
                    if (unfloatmem == null) {
                        String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u5b8c\u6574\u586b\u5199\u7b2c%s\u884c\u7684\u975e\u6d6e\u52a8\u6210\u5458\u3002", (String)"TemplateFloatSettingPlugin_43", (String)"fi-bcm-formplugin", (Object[])new Object[0]), obj.getInt("seq"));
                        throw new KDBizException(msg);
                    }
                    DimMember member = (DimMember)ObjectConvertUtils.toDimMember(unfloatmem, (IDimension)dimension);
                    member.setId(unfloatmem.getLong("id"));
                    DynaMembScopeInfo ms = new DynaMembScopeInfo((IDimMember)member, RangeEnum.VALUE_10.getValue());
                    ds.add(ms);
                    bpl.setDynaMembScopes(ds);
                    if (!isSeq && !ishide && kd.bos.util.StringUtils.isNotEmpty((String)obj.getString(FLOATAREAINDEX))) {
                        int offset = obj.getInt(FLOATAREAINDEX);
                        bpl.setOffset(offset);
                    }
                }
                if (isSeq) {
                    bpl.setSeq(true);
                    bpl.setOffset(-1);
                }
                bp.addBasePointInnerLineInfo(bpl);
            }
            if (selectrows.length > 0 && this.checkSelectSameConfig(selectrows, entryen.getEntryData().getDataEntitys()) && selectArea.contains(bp.getDynaRange())) {
                this.setConfigInfo(bp);
            } else {
                this.setConfigInfo(bp, posio);
            }
            basePoints.add(bp);
        }
        this.checkTopSetting(floatMap);
        String areaRange = posio.getAreaRange();
        StringBuilder sb = new StringBuilder();
        if (CollectionUtils.isNotEmpty((Collection)emptyRangeAreaSet)) {
            for (String message : emptyRangeAreaSet) {
                sb.append(ResManager.loadKDString((String)"\u6570\u636e\u533a\u57df", (String)"TemplateFloatSettingPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(areaRange).append('\u3001').append(ResManager.loadKDString((String)"\u6d6e\u52a8\u8303\u56f4", (String)"TemplateFloatSettingPlugin_39", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(message).append('\uff0c');
            }
        }
        this.getView().returnDataToParent((Object)sb.toString());
        posio.setBasePoints(basePoints);
        if (selectrows.length == 0 || PositionInfo.FloatConfigSetting.TOTAL.getIndex() == this.getIntValue(FLOATCONFIGSETTING)) {
            this.setInfo(posio);
        }
        this.setAreaFloatConfigSetting(posio);
        this.setEntryData(posio);
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        pageCache.put("returnpositioninfo", this.getPageCache().get(POSITIONCACHE));
        String spreadSerial = this.getPageCache().get(POSITIONCACHE);
        SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)spreadSerial);
        this.cacheSpreadModel(spreadManager);
    }

    private boolean isFloatAreaCrossSeqArea(String floatArea, PositionInfo posio) {
        return posio.getSequenceInfo() != null && ExcelUtils.isOverlap((String)floatArea, (String)posio.getSequenceInfo().getSeqArea());
    }

    private void setEntryData(PositionInfo posio) {
        String spreadSerial = this.getPageCache().get(POSITIONCACHE);
        SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)spreadSerial);
        Set psSets = spreadManager.getAreaManager().getPostionInfoSet();
        boolean isExist = false;
        for (PositionInfo ps : psSets) {
            if (ps == null || !posio.getAreaRange().equals(ps.getAreaRange())) continue;
            ps.setBasePoints(posio.getBasePoints());
            isExist = true;
            break;
        }
        if (!isExist) {
            psSets.add(posio);
        }
        this.getPageCache().remove("ischanged_area");
        this.getPageCache().put(POSITIONCACHE, JsonSerializerUtil.toJson((SpreadManager)spreadManager));
    }

    private void setAreaFloatConfigSetting(PositionInfo posio) {
        String spreadSerial = this.getPageCache().get(POSITIONCACHE);
        SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)spreadSerial);
        Set psSets = spreadManager.getAreaManager().getPostionInfoSet();
        for (PositionInfo ps : psSets) {
            if (ps == null || posio == null || !posio.getAreaRange().equals(ps.getAreaRange())) continue;
            List bps = ps.getBasePoints();
            List bp = posio.getBasePoints();
            if (bps != null && bp != null) {
                block1: for (BasePointInfo basePointInfo : bps) {
                    for (BasePointInfo basePoint : bp) {
                        if (!basePoint.getDynaRange().equals(basePointInfo.getDynaRange())) continue;
                        this.setBasePointInfoConfig(basePointInfo, basePoint);
                        continue block1;
                    }
                }
            }
            this.setPositionInfoConfig(posio, ps);
        }
    }

    private void setPositionInfoConfig(PositionInfo posio, PositionInfo ps) {
        posio.setFloatConfigSetting(ps.getFloatConfigSetting());
        posio.setFloatMemDisplayPattern(ps.getFloatMemDisplayPattern());
        posio.setShowFloatMember(ps.getShowFloatMember());
        posio.setShowFolatNullOrZero(ps.getShowFolatNullOrZero());
        posio.setShowFolatText(ps.getShowFolatText());
    }

    private void setBasePointInfoConfig(BasePointInfo basePointInfo, BasePointInfo basePoint) {
        basePoint.setFloatConfigSetting(basePointInfo.getFloatConfigSetting());
        basePoint.setFloatMemDisplayPattern(basePointInfo.getFloatMemDisplayPattern());
        basePoint.setShowFloatMember(basePointInfo.getShowFloatMember());
        basePoint.setShowFolatNullOrZero(basePointInfo.getShowFolatNullOrZero());
        basePoint.setShowFolatText(basePointInfo.getShowFolatText());
        basePoint.setMyCompanyAutoConvent(basePointInfo.getMyCompanyAutoConvent());
    }

    private void setConfigInfo(BasePointInfo bp, PositionInfo posio) {
        List basePointInfos = posio.getBasePoints();
        for (BasePointInfo basePointInfo : basePointInfos) {
            if (!bp.getDynaRange().equals(basePointInfo.getDynaRange())) continue;
            this.setBasePointInfoConfig(basePointInfo, bp);
            break;
        }
    }

    private int getIntValue(String sign) {
        Object value = this.getModel().getValue(sign);
        if (Objects.isNull(value) || StringUtils.isEmpty((CharSequence)value.toString())) {
            switch (sign) {
                case "floatconfigsetting": {
                    value = PositionInfo.FloatConfigSetting.TOTAL.getIndex();
                    break;
                }
                case "displaypattern": {
                    value = PositionInfo.FloatMemDisplayPattern.NAME.getIndex();
                    break;
                }
                case "mycomautoconv": {
                    value = PositionInfo.MyCompanyAutoConvent.NO.getIndex();
                    break;
                }
                default: {
                    value = "0";
                }
            }
        }
        return Integer.parseInt(value.toString());
    }

    private void setConfigInfo(BasePointInfo bp) {
        Object isShowFloatMember = this.getModel().getValue(ISSHOWFLOATMEMBER);
        Boolean isshowtext = (Boolean)this.getModel().getValue(ISSHOWTEXT);
        Boolean isshownull = (Boolean)this.getModel().getValue(ISSHOWNULL);
        bp.setShowFolatText(isshowtext);
        bp.setShowFolatNullOrZero(isshownull);
        bp.setFloatConfigSetting(PositionInfo.FloatConfigSetting.getPattern((int)this.getIntValue(FLOATCONFIGSETTING)));
        bp.setMyCompanyAutoConvent(PositionInfo.MyCompanyAutoConvent.getPattern((int)this.getIntValue(MYCOMAUTOCONV)));
        if (isShowFloatMember != null) {
            bp.setShowFloatMember((Boolean)isShowFloatMember);
        }
        bp.setFloatMemDisplayPattern(PositionInfo.FloatMemDisplayPattern.getPattern((int)this.getIntValue(DISPLAYPATTERN)));
    }

    private void dealTopSetting(BasePointInfo basePointInfo) {
        String key = basePointInfo.getDynaRange() + SORTTOPSETTING;
        String memsc = this.getPageCache().get(key);
        if (kd.bos.util.StringUtils.isEmpty((String)memsc)) {
            return;
        }
        List list = (List)ObjectSerialUtil.deSerializedBytes((String)memsc);
        basePointInfo.setTopSettingOrder(list);
    }

    private String dealMemRange(BasePointInnerLineInfo bpl, DynamicObject obj, Dimension dimension) {
        String key = obj.getString(SELECTAREA) + obj.getString(DIMNUMBER);
        String memsc = this.getPageCache().get(key);
        if (kd.bos.util.StringUtils.isEmpty((String)memsc) || "[]".equals(memsc)) {
            return obj.getString(SELECTAREA);
        }
        List list = (List)SerializationUtils.fromJsonString((String)memsc, List.class);
        ArrayList<DynaMembScopeInfo> ds = new ArrayList<DynaMembScopeInfo>(list.size());
        for (Map map : list) {
            DimMember member = new DimMember((String)map.get("name"), (String)map.get("number"), null, (IDimension)dimension);
            member.setId(Long.parseLong((String)map.get("id")));
            String scope = (String)map.get("scope");
            DynaMembScopeInfo ms = kd.bos.util.StringUtils.isEmpty((String)((String)map.get("pid"))) ? new DynaMembScopeInfo((IDimMember)member, Integer.parseInt(scope)) : new DynaMembScopeInfo((IDimMember)member, Integer.parseInt(scope), true);
            ds.add(ms);
        }
        bpl.setDynaMembScopes(ds);
        return null;
    }

    @Override
    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn-confirm": {
                this.saveModel();
                CommandParam com = new CommandParam("bcm_template_floatsetting", null, "changeMark", this.getSpreadModel());
                this.sendMsg(this.getView(), com);
                if (ModelUtil.queryApp(this.getView()) == ApplicationTypeEnum.RPT) {
                    this.getView().returnDataToParent((Object)this.getSpreadModel());
                }
                this.getView().close();
                break;
            }
            case "newmembas": {
                EntryGrid eg = (EntryGrid)this.getControl(entryentity);
                DynamicObject obj = this.getModel().getEntryRowEntity(entryentity, eg.getSelectRows()[0]);
                if (DimTypesEnum.INTERCOMPANY.getNumber().equals(obj.getString(DIMNUMBER))) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5f80\u6765\u7ec4\u7ec7\u786e\u8ba4\u8981\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7\uff1f", (String)"TemplateFloatSettingPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f80\u6765\u7ec4\u7ec7\u53ea\u80fd\u9009\u62e9\u5916\u90e8\u7ec4\u7ec7\u53ca\u5176\u4e0b\u7ea7\u4f5c\u4e3a\u65b0\u589e\u6210\u5458\u4f4d\u7f6e\u3002", (String)"TemplateFloatSettingPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("ICADDAS", (IFormPlugin)this));
                    break;
                }
                this.showSingleF7(key, SingleF7TypeEnum.COMMON);
                break;
            }
            case "floatmemtext": {
                List dimList;
                EntryGrid eg = (EntryGrid)this.getControl(entryentity);
                DynamicObject obj = this.getModel().getEntryRowEntity(entryentity, eg.getSelectRows()[0]);
                DynamicObject dim = QueryDimensionServiceHelper.getMsgByNumber((long)this.getTemplateModel().getModelId(), (String)obj.getString(DIMNUMBER));
                FormShowParameter para = null;
                para = new FormShowParameter();
                if (dim.getString("number").equals(DimTypesEnum.INTERCOMPANY.getNumber())) {
                    para.setFormId("bcm_mulmemberf7_tem_ic");
                } else {
                    para.setFormId("bcm_mulmemberf7base_tem");
                }
                para.getOpenStyle().setShowType(ShowType.Modal);
                this.getPageCache().put("KEY_MODEL_ID", String.valueOf(this.getTemplateModel().getModelId()));
                HashMap<String, Object> params = new HashMap<String, Object>(16);
                params.put("KEY_MODEL_ID", String.valueOf(this.getTemplateModel().getModelId()));
                params.put("dimension", dim.getInt("dseq") + "");
                params.put("sign", obj.getString(SELECTAREA) + obj.getString(DIMNUMBER));
                params.put("memrangdecombo", RangeEnum.VALUE_90.getValue());
                if (dim.getString("number").equals(DimTypesEnum.ENTITY.getNumber())) {
                    params.put("disableRateCls", true);
                }
                if ((dimList = (List)this.getFormCustomParam("FilterDimensions", new ArrayList(16))).contains(dim.getString("number"))) {
                    params.put("isShowSystemVariables", SystemVarsEnum.getReportVars());
                }
                para.setCustomParams(params);
                para.setCaption(String.format(ResManager.loadKDString((String)"%s - \u6210\u5458\u9009\u62e9", (String)"TemplateFloatSettingPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dim.getString("name")));
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, FLOATMEMTEXT);
                para.setCloseCallBack(closeCallBack);
                this.getView().showForm(para);
                break;
            }
            case "showfloatarea": {
                List<String> list = this.getSelectRowFloatRowOrCol();
                ComboEdit comboEdit = (ComboEdit)this.getControl("combofield");
                ArrayList items = new ArrayList(10);
                ArrayList<String[]> keysAndValues = new ArrayList<String[]>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    String[] keysAndValue = new String[]{this.buildComboShowName(list.get(i)), String.valueOf(i)};
                    keysAndValues.add(keysAndValue);
                }
                keysAndValues.forEach(new DynamicEnum(items));
                comboEdit.setComboItems(items);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"showpanel"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"combopanel"});
                this.getModel().setValue("combofield", (Object)0);
                this.getPageCache().put(PAFETYPE, SelectPageType.FLOAT.getName());
                break;
            }
            case "sorttopsetting": {
                EntryGrid eg = (EntryGrid)this.getControl(entryentity);
                DynamicObject obj = this.getModel().getEntryRowEntity(entryentity, eg.getSelectRows()[0]);
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("bcm_float_sortsetting");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
                String dataarea = (String)this.getValue(DATAAREA);
                String ca = this.getPageCache().get(DATAAREAMAP);
                Map map = (Map)SerializationUtils.fromJsonString((String)ca, Map.class);
                String s = obj.getString(SELECTAREA);
                paramMap.put(SELECTAREA, obj.getString(SELECTAREA));
                paramMap.put(DATAAREA, map.get(dataarea));
                paramMap.put(FLOATTYPE, this.getPageCache().get(FLOATTYPE));
                paramMap.put(SORTTOPSETTING, this.getPageCache().get(s + SORTTOPSETTING));
                Pair pair = this.getCanBlockFloat(s);
                paramMap.put("memshowone", pair.p1);
                paramMap.put("floatdimnums", pair.p2);
                parameter.setCustomParams(paramMap);
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, SORTTOPSETTING);
                parameter.setCloseCallBack(callBack);
                this.getView().showForm(parameter);
                break;
            }
        }
    }

    private Pair getCanBlockFloat(String floatArea) {
        ArrayList showOneList = new ArrayList(16);
        ArrayList floatList = new ArrayList(16);
        DynamicObjectCollection dyos = this.getModel().getEntryEntity(entryentity);
        if (CollectionUtils.isNotEmpty((Collection)dyos) && kd.bos.util.StringUtils.isNotEmpty((String)floatArea)) {
            HashMap<Integer, List> temp = new HashMap<Integer, List>(16);
            dyos.forEach(e -> {
                if (e.getString(SELECTAREA).equals(floatArea) && e.getBoolean(ISFLOAT)) {
                    floatList.add(e.getInt(FLOATAREAINDEX));
                    if (e.get(ISHIDE) != null && !e.getBoolean(ISHIDE)) {
                        temp.computeIfAbsent(e.getInt(FLOATAREAINDEX), k -> new ArrayList(16)).add(e.getString(DIMNUMBER));
                    }
                }
            });
            if (!temp.isEmpty() && temp.size() != 1) {
                temp.forEach((k, v) -> {
                    if (v.size() == 1) {
                        showOneList.add(k);
                    }
                });
            }
        }
        return Pair.onePair(showOneList, floatList);
    }

    private String buildComboShowName(String in) {
        String floattype = this.getPageCache().get(FLOATTYPE);
        String name = "row".equals(floattype) ? ResManager.loadKDString((String)"\u5217", (String)"TemplateFloatSettingPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u884c", (String)"TemplateFloatSettingPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        return String.format(ResManager.loadKDString((String)"\u7b2c%1$s%2$s", (String)"TemplateFloatSettingPlugin_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]), in, name);
    }

    private List<String> getSelectRowFloatRowOrCol() {
        EntryGrid eg = (EntryGrid)this.getControl(entryentity);
        DynamicObject obj = this.getModel().getEntryRowEntity(entryentity, eg.getSelectRows()[0]);
        String floattype = this.getPageCache().get(FLOATTYPE);
        List list = new ArrayList(10);
        list = "row".equals(floattype) ? (List)SpreadAreaUtil.getCol((String)obj.getString(SELECTAREA)) : (List)SpreadAreaUtil.getRow((String)obj.getString(SELECTAREA));
        return list;
    }

    private void showSingleF7(String key, SingleF7TypeEnum typeEnum) {
        EntryGrid eg = (EntryGrid)this.getControl(entryentity);
        DynamicObject obj = this.getModel().getEntryRowEntity(entryentity, eg.getSelectRows()[0]);
        long modelId = this.getTemplateModel().getModelId();
        QFilter numberFilter = new QFilter("number", "=", (Object)obj.getString(DIMNUMBER));
        DynamicObject dimObj = BusinessDataServiceHelper.loadSingle((String)"bcm_dimension", (String)"id,number,name,dseq,membermodel", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), numberFilter});
        BasedataEditSingleMemberF7 f7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), modelId, dimObj.getLong("id"), key, null, true, typeEnum);
        f7.setF7title(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"TemplateFloatSettingPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        if (NEWMEMBAS.equals(key)) {
            List ids;
            f7.setFormId("bcm_singlemember_float");
            HashMap customData = f7.getCustomData();
            if (MapUtils.isEmpty(customData)) {
                customData = Maps.newHashMap();
            }
            if ("bcm_userdefinedmembertree".equals(DimEntityNumEnum.getEntieyNumByNumber((String)obj.getString(DIMNUMBER))) && CollectionUtils.isNotEmpty((Collection)(ids = TemplateUtil.getMemberAddOfIds((long)modelId)))) {
                f7.setCustomFilter(new QFilter("id", "not in", (Object)ids));
            }
            customData.put(NEWMEMBAS, Boolean.TRUE);
            f7.setCustomData(customData);
        }
        f7.setCallBackClassName(this.getClass().getName());
        f7.setStatus(OperationStatus.EDIT);
        f7.setScope(obj.getInt("scope"));
        f7.click();
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String pagetype = this.getPageCache().get(PAFETYPE);
        if (SelectPageType.FLOAT.getName().equals(pagetype)) {
            e.setCancel(true);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"showpanel"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"areapanel", "combopanel", "orglocal"});
            this.getPageCache().put(PAFETYPE, "show");
        }
    }

    private void noDataWarning() {
        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5b8c\u6574\u586b\u5199\u6bcf\u4e00\u884c\u3002", (String)"TemplateFloatSettingPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void noFloatDataWarning() {
        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u6d6e\u52a8\u7ef4\u5ea6\u3002", (String)"TemplateFloatSettingPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void noDataWarning(int row, String value) {
        String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u5b8c\u6574\u586b\u5199\u7b2c%1$s\u884c\u7684%2$s\u3002", (String)"TemplateFloatSettingPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]), row, value);
        throw new KDBizException(msg);
    }

    private void seqCrossWarning(String floatArea, String seaArea) {
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6240\u9009\u6d6e\u52a8\u533a\u57df%1$s\u4e0e\u884c\u6b21\u533a\u57df%2$s\u91cd\u5408\u3002", (String)"TemplateFloatSettingPlugin_40", (String)"fi-bcm-formplugin", (Object[])new Object[0]), floatArea, seaArea));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        BasedataEdit bs = (BasedataEdit)arg0.getSource();
        String methodName = PlatUtil.getOpMethod();
        if ("click".equalsIgnoreCase(methodName)) {
            arg0.setCancel(true);
            this.showSingleF7(bs.getKey(), SingleF7TypeEnum.COMMON);
        } else if ("getLookupList".equalsIgnoreCase(methodName) || "showMore".equalsIgnoreCase(methodName)) {
            EntryGrid eg = (EntryGrid)this.getControl(entryentity);
            DynamicObject obj = this.getModel().getEntryRowEntity(entryentity, eg.getSelectRows()[0]);
            String dimNumber = obj.getString(DIMNUMBER);
            QFilter numberFilter = new QFilter("number", "=", (Object)dimNumber);
            DynamicObject dimObj = BusinessDataServiceHelper.loadSingle((String)"bcm_dimension", (String)"id,number,name,dseq,membermodel", (QFilter[])new QFilter[]{this.getQFilterByModelID(), numberFilter});
            long dimId = dimObj.getLong("id");
            QFilter filter = new QFilter("dimension", "=", (Object)dimId);
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
            qFilters.add(filter);
            qFilters.add(SingleMemberF7Util.getPermissionFilter(DimEntityNumEnum.getEntieyNumByNumber((String)dimNumber), dimId, this.getTemplateModel().getModelId()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilters, (String)null));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (FLOATMEMTEXT.equals(actionId)) {
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            DynamicObjectCollection doc = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
            EntryGrid eg = (EntryGrid)this.getControl(entryentity);
            DynamicObject selobj = this.getModel().getEntryRowEntity(entryentity, eg.getSelectRows()[0]);
            MultiF7Results multiF7Results = MultiF7Results.buildParam((DynamicObjectCollection)doc);
            String value = null;
            ArrayList<Map<String, String>> list = new ArrayList(10);
            if (multiF7Results != null) {
                value = multiF7Results.getShowText();
                list = multiF7Results.toList();
            }
            if (doc != null && !doc.isEmpty()) {
                if (((DynamicObject)doc.get(0)).get(6) != null && !kd.bos.util.StringUtils.isEmpty((String)((DynamicObject)doc.get(0)).getString(6).trim())) {
                    this.getModel().setValue("muldim", (Object)"bcm_definedpropertyvalue", eg.getSelectRows()[0]);
                } else {
                    this.getModel().setValue("muldim", this.getModel().getValue("dim"), eg.getSelectRows()[0]);
                }
            }
            this.getModel().setValue(FLOATMEMTEXT, (Object)value, eg.getSelectRows()[0]);
            this.put2FloatMemMap(selobj.getString(SELECTAREA), selobj.getString(DIMNUMBER), list);
        } else if (NEWMEMBAS.equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            DynamicObject result = (DynamicObject)closedCallBackEvent.getReturnData();
            EntryGrid eg = (EntryGrid)this.getControl(entryentity);
            int scope = result.getDataEntityType().getProperties().contains((Object)"scopeval") ? result.getInt("scopeval") : 1;
            String showtext = this.buildNewmembasShowname(result.getString("name"), scope);
            this.getModel().setValue(actionId, (Object)showtext, eg.getSelectRows()[0]);
            this.getModel().setValue(NEWMEMAREA, result.get("id"), eg.getSelectRows()[0]);
            this.getModel().setValue("scope", (Object)scope, eg.getSelectRows()[0]);
        } else if (SORTTOPSETTING.equals(actionId)) {
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            Pair pair = (Pair)ObjectSerialUtil.deSerializedBytes((String)closedCallBackEvent.getReturnData().toString());
            this.getPageCache().put("ischanged", "true");
            this.showSortTopSetting(pair);
            this.getPageCache().put(pair.p1.toString() + SORTTOPSETTING, ObjectSerialUtil.toByteSerialized((Object)pair.p2));
            this.showFloatConfigInfo();
        } else if (closedCallBackEvent.getReturnData() != null) {
            DynamicObject result = (DynamicObject)closedCallBackEvent.getReturnData();
            EntryGrid eg = (EntryGrid)this.getControl(entryentity);
            this.getModel().setValue(actionId, result.get("id"), eg.getSelectRows()[0]);
        }
    }

    private void showSortTopSetting(Pair pair) {
        String floatArea = (String)pair.p1;
        List p2 = (List)pair.p2;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryentity);
        PositionInfo position = this.getMappingFloatPosition(floatArea, true);
        String areaRange = floatArea;
        if (position != null) {
            areaRange = position.getAreaRange();
        }
        String value = this.creatSortTopSettingStr(p2, floatArea, areaRange);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            this.getModel().beginInit();
            if (!dynamicObject.getString(SELECTAREA).equals(floatArea)) continue;
            if (dynamicObject.getBoolean(ISFLOAT)) {
                this.getModel().setValue(SORTTOPSETTING, (Object)value, i);
            } else {
                this.getModel().setValue(SORTTOPSETTING, null, i);
            }
            this.getView().updateView(SORTTOPSETTING, i);
            this.getModel().endInit();
        }
        this.getPageCache().put(floatArea + SORTTOPSETTING, ObjectSerialUtil.toByteSerialized((Object)p2));
    }

    private String getOrderBy(String floatArea, String areaRange, int i) {
        String type = this.getPageCache().get(FLOATTYPE);
        List list = new ArrayList(10);
        String temp = "";
        if ("row".equals(type)) {
            list = (List)SpreadAreaUtil.getCol((String)floatArea);
            list.addAll((List)SpreadAreaUtil.getCol((String)areaRange));
            temp = ResManager.loadKDString((String)"\u5217", (String)"TemplateFloatSettingPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        } else {
            list = (List)SpreadAreaUtil.getRow((String)floatArea);
            list.addAll((List)SpreadAreaUtil.getRow((String)areaRange));
            temp = ResManager.loadKDString((String)"\u884c", (String)"TemplateFloatSettingPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return (String)list.get(i) + temp;
    }

    private String creatSortTopSettingStr(List<Map<String, Object>> p2, String floatArea, String areaRange) {
        StringBuilder stringBuffer = new StringBuilder();
        int index = 1;
        for (Map<String, Object> map : p2) {
            int sortorder = Integer.parseInt(map.get("sortorder").toString());
            stringBuffer.append(this.getOrderBy(floatArea, areaRange, Integer.parseInt(map.get("orderby").toString()))).append("\uff0c").append(sortorder == 0 ? ResManager.loadKDString((String)"\u5347\u5e8f", (String)"TemplateFloatSettingPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : (sortorder == 1 ? ResManager.loadKDString((String)"\u964d\u5e8f", (String)"TemplateFloatSettingPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6210\u5458\u987a\u5e8f", (String)"TemplateFloatSettingPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            int top = Integer.parseInt(map.get("top").toString());
            if (top != 0) {
                stringBuffer.append("\uff0cTOP\uff1a").append(top);
            }
            if (map.get("memshowone") != null && Boolean.parseBoolean(map.get("memshowone").toString())) {
                stringBuffer.append("\uff0c");
                stringBuffer.append(ResManager.loadKDString((String)"\u91cd\u590d\u6210\u5458\u5355\u6b21\u663e\u793a\u3002", (String)"TemplateFloatSettingPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (index != p2.size()) {
                stringBuffer.append("\uff1b").append("\n");
            }
            ++index;
        }
        return stringBuffer.toString();
    }

    private void put2SelectAreas(String select) {
        String floattype;
        SpreadSelectTypeEnum areainwhere;
        String selectarea = this.getPageCache().get(SELECTAREAS);
        List alist = kd.bos.util.StringUtils.isEmpty((String)selectarea) ? new ArrayList(10) : (List)SerializationUtils.fromJsonString((String)selectarea, List.class);
        if (SpreadAreaUtil.Area_contains_xy((String)select, alist, (SpreadSelectTypeEnum)(areainwhere = "col".equals(floattype = this.getPageCache().get(FLOATTYPE)) ? SpreadSelectTypeEnum.RIGHT_TOP : SpreadSelectTypeEnum.LEFT_BOTTOM))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u533a\u57df\u548c\u5df2\u9009\u62e9\u7684\u8303\u56f4\u91cd\u53e0\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TemplateFloatSettingPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        alist.add(select);
        this.getPageCache().put(SELECTAREAS, SerializationUtils.toJsonString(alist));
    }

    private void removeFromSelectAreas(String select) {
        String selectarea = this.getPageCache().get(SELECTAREAS);
        if (kd.bos.util.StringUtils.isNotEmpty((String)selectarea)) {
            List alist = (List)SerializationUtils.fromJsonString((String)selectarea, List.class);
            alist.remove(select);
            this.getPageCache().put(SELECTAREAS, SerializationUtils.toJsonString((Object)alist));
        }
    }

    private void put2FloatMemMap(String select, String dimnum, List<Map<String, String>> doc) {
        String key = select + dimnum;
        this.getPageCache().put(key, SerializationUtils.toJsonString(doc));
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        DynamicObject rowEntity;
        super.propertyChanged(e);
        boolean flag = false;
        EntryGrid eg = (EntryGrid)this.getControl(entryentity);
        if (eg.getSelectRows().length == 0) {
            return;
        }
        if (ISFLOAT.equals(e.getProperty().getName())) {
            if (e.getChangeSet()[0].getNewValue() != null && e.getChangeSet()[0].getNewValue() != e.getChangeSet()[0].getOldValue() && !Boolean.parseBoolean(e.getChangeSet()[0].getNewValue().toString())) {
                flag = true;
            }
        } else if (FLOATAREAINDEX.equals(e.getProperty().getName()) && e.getChangeSet()[0].getNewValue() != e.getChangeSet()[0].getOldValue()) {
            boolean bl = flag = ThreadCache.get((Object)("isfloat_floatrow" + eg.getSelectRows()[0])) == null;
        }
        if (flag && (rowEntity = this.getModel().getEntryRowEntity(entryentity, eg.getSelectRows()[0])) != null && rowEntity.getString(SELECTAREA) != null && this.getPageCache().get(rowEntity.getString(SELECTAREA) + SORTTOPSETTING) != null) {
            ThreadCache.put((Object)(e.getProperty().getName() + "_floatrow" + eg.getSelectRows()[0]), (Object)ObjectSerialUtil.toByteSerialized((Object)rowEntity));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (this.getPageCache() == null || "false".equals(this.getPageCache().get("change"))) {
            return;
        }
        switch (key) {
            case "floatareaindex": {
                EntryGrid eg = (EntryGrid)this.getControl(entryentity);
                Integer index = null;
                if (e.getChangeSet()[0].getNewValue() != null) {
                    index = Integer.parseInt(e.getChangeSet()[0].getNewValue().toString());
                }
                this.updateTopSettingForCIndex(eg.getSelectRows()[0], index);
                break;
            }
            case "floatmemtext": {
                Object value = e.getChangeSet()[0].getNewValue();
                if (value != null && !kd.bos.util.StringUtils.isEmpty((String)value.toString())) break;
                EntryGrid eg = (EntryGrid)this.getControl(entryentity);
                DynamicObject selobj = this.getModel().getEntryRowEntity(entryentity, eg.getSelectRows()[0]);
                String cakey = selobj.getString(SELECTAREA) + selobj.getString(DIMNUMBER);
                this.getPageCache().put(cakey, null);
                break;
            }
            case "area": {
                String area = e.getChangeSet()[0].getNewValue().toString();
                if (kd.bos.util.StringUtils.isEmpty((String)area)) {
                    return;
                }
                String cell = area.split(":")[0];
                if (this.getPageCache().get(FLOATTYPE) == null) break;
                String pssch = (String)this.getView().getFormShowParameter().getCustomParam("ps");
                PositionInfo ps = (PositionInfo)this.deSerializedBytes(pssch);
                String stpo = ps.getStartPosition();
                String type = this.getPageCache().get(FLOATTYPE);
                String val = "";
                if ("col".equals(type)) {
                    ExcelUtils.pos2Y((String)stpo);
                    val = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"TemplateFloatSettingPlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ExcelUtils.pos2Y((String)cell) + 1);
                } else {
                    val = String.format(ResManager.loadKDString((String)"\u7b2c%s\u5217", (String)"TemplateFloatSettingPlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ExcelUtils.int2pos((int)ExcelUtils.pos2X((String)cell)));
                }
                this.getModel().setValue("select", (Object)val);
                break;
            }
            case "dataarea": {
                String area = e.getChangeSet()[0].getNewValue().toString();
                String oldArea = e.getChangeSet()[0].getOldValue().toString();
                this.getPageCache().put("ischanged_oldarea", oldArea);
                this.saveModel();
                String ca = this.getPageCache().get(DATAAREAMAP);
                if (!StringUtils.isNotEmpty((CharSequence)ca)) break;
                Map result = (Map)SerializationUtils.fromJsonString((String)ca, Map.class);
                this.switchDataArea((String)result.get(area));
                break;
            }
            case "isfloat": {
                EntryGrid eg = (EntryGrid)this.getControl(entryentity);
                if (e.getChangeSet()[0].getNewValue().equals(true)) {
                    String dimnum;
                    List<String> list = this.getSelectRowFloatRowOrCol();
                    if (list.size() == 1 && !this.getModel().getEntryRowEntity(entryentity, eg.getSelectRows()[0]).getBoolean(ISSEQ)) {
                        this.getModel().setValue(FLOATAREAINDEX, (Object)0, eg.getSelectRows()[0]);
                        this.getModel().setValue(FLOATAREA, (Object)this.buildComboShowName(list.get(0)), eg.getSelectRows()[0]);
                    }
                    if ("bcm_userdefinedmembertree".equals(DimEntityNumEnum.getEntieyNumByNumber((String)(dimnum = (String)this.getModel().getValue(DIMNUMBER, e.getChangeSet()[0].getRowIndex())))) || DimTypesEnum.MYCOMPANY.getNumber().equals(dimnum)) {
                        this.getView().setEnable(Boolean.valueOf(true), e.getChangeSet()[0].getRowIndex(), new String[]{ISHIDE});
                    } else {
                        this.getView().setEnable(Boolean.valueOf(false), e.getChangeSet()[0].getRowIndex(), new String[]{ISHIDE});
                    }
                    this.updateTopSettingForFloat(eg.getSelectRows()[0]);
                    break;
                }
                this.getView().setEnable(Boolean.valueOf(false), e.getChangeSet()[0].getRowIndex(), new String[]{ISHIDE});
                if (ThreadCache.get((Object)("isfloat_floatrow" + eg.getSelectRows()[0])) == null) break;
                this.updateTopSetting(eg.getSelectRows()[0]);
                this.getModel().beginInit();
                this.getModel().setValue(SORTTOPSETTING, null, e.getChangeSet()[0].getRowIndex());
                this.getView().updateView(SORTTOPSETTING, e.getChangeSet()[0].getRowIndex());
                this.getModel().endInit();
                break;
            }
            case "isseq": {
                EntryGrid eg = (EntryGrid)this.getControl(entryentity);
                if (e.getChangeSet()[0].getNewValue().equals(true)) {
                    DimMember mem = SeqLogicImpl.getParentSeqMem(this.getModelId());
                    StringBuilder sb = new StringBuilder();
                    ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(10);
                    DynamicObject selobj = this.getModel().getEntryRowEntity(entryentity, eg.getSelectRows()[0]);
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    map.put("id", String.valueOf(mem.getId()));
                    map.put("scope", String.valueOf(RangeEnum.VALUE_90.getValue()));
                    map.put("number", mem.getNumber());
                    map.put("name", mem.getName());
                    map.put("pid", "");
                    sb.append(this.buildFloatMemShowname(mem.getName(), RangeEnum.VALUE_90.getValue())).append(",");
                    list.add(map);
                    this.getModel().setValue(FLOATMEMTEXT, (Object)sb.substring(0, sb.length() - 1), eg.getSelectRows()[0]);
                    this.getModel().setValue(NEWMEMBAS, null, eg.getSelectRows()[0]);
                    this.getModel().setValue(NEWMEMAREA, null, eg.getSelectRows()[0]);
                    this.getModel().setValue("scope", null, eg.getSelectRows()[0]);
                    this.put2FloatMemMap(selobj.getString(SELECTAREA), selobj.getString(DIMNUMBER), list);
                    break;
                }
                this.getModel().setValue(ISFLOAT, (Object)false, eg.getSelectRows()[0]);
                break;
            }
            case "newmembas": {
                if (e.getChangeSet()[0].getNewValue() != null && !kd.bos.util.StringUtils.isEmpty((String)e.getChangeSet()[0].getNewValue().toString())) break;
                this.getModel().setValue(NEWMEMAREA, null, e.getChangeSet()[0].getRowIndex());
                break;
            }
            case "sorttopsetting": {
                if (e.getChangeSet()[0].getNewValue() != null && !kd.bos.util.StringUtils.isEmpty((String)e.getChangeSet()[0].getNewValue().toString())) break;
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryentity);
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(e.getChangeSet()[0].getRowIndex());
                String floatArea = dynamicObject.getString(SELECTAREA);
                for (int i = 0; i < entryEntity.size(); ++i) {
                    if (!((DynamicObject)entryEntity.get(i)).getString(SELECTAREA).equals(floatArea)) continue;
                    this.getModel().setValue(SORTTOPSETTING, null, i);
                }
                this.getPageCache().remove(floatArea + SORTTOPSETTING);
                break;
            }
            case "floatconfigsetting": {
                EntryGrid eg = (EntryGrid)this.getControl(entryentity);
                if (eg.getSelectRows().length == 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8981\u8bbe\u7f6e/\u4fee\u6539\u6d6e\u52a8\u53c2\u6570\uff0c\u9700\u8981\u5148\u8bbe\u7f6e\u597d\u6d6e\u52a8\u8303\u56f4\u3002", (String)"TemplateFloatSettingPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    String oldValue = e.getChangeSet()[0].getOldValue().toString();
                    this.getModel().beginInit();
                    this.getModel().setDataChanged(false);
                    this.getModel().getDataEntity().set(FLOATCONFIGSETTING, (Object)Integer.valueOf(oldValue));
                    this.getView().updateView(FLEXPANELAP1);
                    this.getModel().endInit();
                    return;
                }
                if (PositionInfo.FloatConfigSetting.TOTAL == PositionInfo.FloatConfigSetting.getPattern((int)this.getIntValue(FLOATCONFIGSETTING))) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u6309\u533a\u57df\u53c2\u6570\u65e0\u6548\uff0c\u5982\u679c\u7ee7\u7eed\uff0c\u53c2\u6570\u91cd\u7f6e\u4e3a\u9ed8\u8ba4\u503c", (String)"TemplateFloatSettingPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("floatconfigsettingtotal", (IFormPlugin)this));
                    break;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6309\u5168\u5c40\u53c2\u6570\u65e0\u6548\uff0c\u5982\u679c\u7ee7\u7eed\uff0c\u53c2\u6570\u91cd\u7f6e\u4e3a\u9ed8\u8ba4\u503c", (String)"TemplateFloatSettingPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("floatconfigsettingpart", (IFormPlugin)this));
                break;
            }
            case "isshowfloatmember": {
                if (e.getChangeSet()[0].getNewValue().equals(true)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8c28\u614e\u5f00\u542f\u3002\u4ec5\u9002\u7528\u6d6e\u52a8\u8303\u56f4\u5185\u6210\u5458\u8f83\u5c11\uff0c\u9884\u4f30\u73b0\u5728\u548c\u672a\u6765\u6574\u5f20\u62a5\u8868\u884c\u6570\u5728\u4e00\u5343\u4ee5\u5185\u3002\u5982\u679c\u6d6e\u52a8\u6210\u5458\u8fc7\u591a\uff0c\u6839\u636ePC\u3001\u7f51\u7edc\u7b49\u60c5\u51b5\uff0c\u53ef\u80fd\u4f1a\u7ec8\u6b62\u6253\u5f00\u62a5\u8868\u3002", (String)"TemplateFloatSettingPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{ISSHOWNULL, ISSHOWTEXT});
                    break;
                }
                this.getView().setEnable(Boolean.valueOf(true), new String[]{ISSHOWNULL, ISSHOWTEXT});
                break;
            }
            case "ishide": {
                boolean flag;
                EntryGrid eg = (EntryGrid)this.getControl(entryentity);
                DynamicObject selobj = this.getModel().getEntryRowEntity(entryentity, eg.getSelectRows()[0]);
                boolean bl = flag = e.getChangeSet()[0].getNewValue() == null ? false : (Boolean)e.getChangeSet()[0].getNewValue();
                if (flag) {
                    this.updateTopSetting(eg.getSelectRows()[0]);
                }
                this.doHidePageRuler(flag, selobj.getString(DIMNUMBER), eg.getSelectRows()[0]);
                break;
            }
        }
        if (key != null) {
            if (ISSHOWFLOATMEMBER.equals(key) || ISSHOWTEXT.equals(key) || ISSHOWNULL.equals(key) || DISPLAYPATTERN.equals(key)) {
                this.getPageCache().put("ischanged", "true");
            }
            if (ISSHOWFLOATMEMBER.equals(key)) {
                this.getModel().setValue(ISSHOWFLOATMEMBER, e.getChangeSet()[0].getNewValue());
            }
            if (ISSHOWTEXT.equals(key)) {
                this.getModel().setValue(ISSHOWTEXT, e.getChangeSet()[0].getNewValue());
            }
            if (ISSHOWNULL.equals(key)) {
                this.getModel().setValue(ISSHOWNULL, e.getChangeSet()[0].getNewValue());
            }
            if (DISPLAYPATTERN.equals(key)) {
                this.getModel().setValue(DISPLAYPATTERN, e.getChangeSet()[0].getNewValue());
            }
            if (ISSHOWFLOATMEMBER.equals(key) || ISSHOWTEXT.equals(key) || ISSHOWNULL.equals(key) || DISPLAYPATTERN.equals(key) || MYCOMAUTOCONV.equals(key)) {
                this.updatePageCache();
            }
        }
    }

    private Integer getFloatAreaIndex(DynamicObject e) {
        if (e.get(FLOATAREAINDEX) != null && kd.bos.util.StringUtils.isNotEmpty((String)e.get(FLOATAREAINDEX).toString())) {
            return e.getInt(FLOATAREAINDEX);
        }
        return null;
    }

    private void updateTopSettingForCIndex(int row, Integer offset) {
        Object o = ThreadCache.get((Object)("floatareaindex_floatrow" + row));
        if (o == null) {
            return;
        }
        DynamicObject selobj = (DynamicObject)ObjectSerialUtil.deSerializedBytes((String)o.toString());
        String selectFloatArea = selobj.getString(SELECTAREA);
        if (this.getPageCache().get(selectFloatArea + SORTTOPSETTING) != null) {
            Integer curOffset = this.getFloatAreaIndex(selobj);
            if (offset != null && offset.equals(curOffset)) {
                return;
            }
            List settingOrder = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(selectFloatArea + SORTTOPSETTING));
            boolean isChange = false;
            Iterator iterator = settingOrder.iterator();
            DynamicObjectCollection dyos = this.getModel().getEntryEntity(entryentity);
            boolean isMoreDims = false;
            if (curOffset != null) {
                for (int i = 0; i < dyos.size(); ++i) {
                    DynamicObject e;
                    if (row == i || !(e = (DynamicObject)dyos.get(i)).getString(SELECTAREA).equals(selectFloatArea) || !e.getBoolean(ISFLOAT) || this.getFloatAreaIndex(e) == null || e.getInt(FLOATAREAINDEX) != curOffset.intValue()) continue;
                    isMoreDims = true;
                }
            }
            while (iterator.hasNext()) {
                boolean flag;
                Map map = (Map)iterator.next();
                if (map.get("orderby") == null) continue;
                if (!isMoreDims && curOffset != null && curOffset.intValue() == ((Integer)map.get("orderby")).intValue()) {
                    iterator.remove();
                    isChange = true;
                    continue;
                }
                if (offset == null || offset.intValue() != ((Integer)map.get("orderby")).intValue() || !(flag = map.get("memshowone") == null ? false : (Boolean)map.get("memshowone"))) continue;
                map.put("memshowone", false);
                isChange = true;
            }
            if (isChange) {
                if (settingOrder.isEmpty()) {
                    this.getPageCache().remove(selectFloatArea + SORTTOPSETTING);
                } else {
                    this.getPageCache().put(selectFloatArea + SORTTOPSETTING, ObjectSerialUtil.toByteSerialized((Object)settingOrder));
                }
                this.showSortTopSetting(Pair.onePair((Object)selectFloatArea, (Object)settingOrder));
            }
        }
    }

    private void updateTopSettingForFloat(int row) {
        List settingOrder;
        DynamicObject selobj = this.getModel().getEntryRowEntity(entryentity, row);
        String selectFloatArea = selobj.getString(SELECTAREA);
        if (kd.bos.util.StringUtils.isNotEmpty((String)selectFloatArea) && this.getPageCache().get(selectFloatArea + SORTTOPSETTING) != null && !(settingOrder = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(selectFloatArea + SORTTOPSETTING))).isEmpty()) {
            PositionInfo position = this.getMappingFloatPosition(selectFloatArea, true);
            String areaRange = selectFloatArea;
            if (position != null) {
                areaRange = position.getAreaRange();
            }
            this.getModel().beginInit();
            this.getModel().setValue(SORTTOPSETTING, (Object)this.creatSortTopSettingStr(settingOrder, selectFloatArea, areaRange), row);
            this.getView().updateView(SORTTOPSETTING, row);
            this.getModel().endInit();
        }
    }

    private void updateTopSetting(int row) {
        DynamicObject selobj = null;
        selobj = ThreadCache.get((Object)("isfloat_floatrow" + row)) != null ? (DynamicObject)ObjectSerialUtil.deSerializedBytes((String)ThreadCache.get((Object)("isfloat_floatrow" + row)).toString()) : this.getModel().getEntryRowEntity(entryentity, row);
        String selectFloatArea = selobj.getString(SELECTAREA);
        if (kd.bos.util.StringUtils.isNotEmpty((String)selectFloatArea) && this.getFloatAreaIndex(selobj) != null) {
            final int offset = selobj.getInt(FLOATAREAINDEX);
            String temp = this.getPageCache().get(selectFloatArea + SORTTOPSETTING);
            if (kd.bos.util.StringUtils.isNotEmpty((String)temp)) {
                HashSet<Integer> floatSet = new HashSet<Integer>(16);
                DynamicObjectCollection dyos = this.getModel().getEntryEntity(entryentity);
                boolean isMoreDims = false;
                for (int i = 0; i < dyos.size(); ++i) {
                    DynamicObject e;
                    if (row == i || !(e = (DynamicObject)dyos.get(i)).getString(SELECTAREA).equals(selectFloatArea) || !e.getBoolean(ISFLOAT) || this.getFloatAreaIndex(e) == null) continue;
                    int index = e.getInt(FLOATAREAINDEX);
                    if (index == offset) {
                        isMoreDims = true;
                        continue;
                    }
                    floatSet.add(index);
                }
                if (isMoreDims) {
                    return;
                }
                List settingOrder = (List)ObjectSerialUtil.deSerializedBytes((String)temp);
                Predicate<Map<String, Object>> predicate = new Predicate<Map<String, Object>>(){

                    @Override
                    public boolean test(Map<String, Object> map) {
                        return map.get("orderby") != null && offset != (Integer)map.get("orderby");
                    }
                };
                if ((settingOrder = settingOrder.stream().filter(predicate).collect(Collectors.toList())).isEmpty()) {
                    this.getPageCache().remove(selectFloatArea + SORTTOPSETTING);
                } else {
                    if (floatSet.size() == 1) {
                        for (Map map : settingOrder) {
                            map.put("memshowone", false);
                        }
                    }
                    this.getPageCache().put(selectFloatArea + SORTTOPSETTING, ObjectSerialUtil.toByteSerialized(settingOrder));
                }
                this.showSortTopSetting(Pair.onePair((Object)selectFloatArea, settingOrder));
            }
        }
    }

    private void doHidePageRuler(boolean isHide, String dimNum, int row) {
        this.getView().setEnable(Boolean.valueOf(!isHide), row, new String[]{FLOATMEMTEXT, FLOATAREA, FLOATAREAINDEX});
        this.getView().setEnable(Boolean.valueOf(isHide || DimTypesEnum.MYCOMPANY.getNumber().equals(dimNum)), row, new String[]{NUMBERFROM});
        if (isHide) {
            this.getModel().setValue(FLOATMEMTEXT, null, row);
            this.getModel().setValue(FLOATAREA, null, row);
            this.getModel().setValue(FLOATAREAINDEX, null, row);
        } else if (!DimTypesEnum.MYCOMPANY.getNumber().equals(dimNum)) {
            this.getModel().setValue(NUMBERFROM, null, row);
        }
    }

    private void updatePageCache() {
        String spreadSerial = this.getPageCache().get(POSITIONCACHE);
        SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)spreadSerial);
        Set psSets = spreadManager.getAreaManager().getPostionInfoSet();
        String areaRang = this.getModel().getValue(DATAAREA).toString();
        String ca = this.getPageCache().get(DATAAREAMAP);
        Map map = (Map)SerializationUtils.fromJsonString((String)ca, Map.class);
        EntryGrid eg = (EntryGrid)this.getControl(entryentity);
        int[] selectRows = eg.getSelectRows();
        HashSet<String> selectArea = new HashSet<String>(selectRows.length);
        for (int i = 0; i < selectRows.length; ++i) {
            selectArea.add(eg.getEntryData().getDataEntitys()[selectRows[i]].getString(SELECTAREA));
        }
        for (PositionInfo ps : psSets) {
            List bps;
            if (ps != null && ((String)map.get(areaRang)).equals(ps.getAreaRange()) && (bps = ps.getBasePoints()) != null) {
                for (BasePointInfo basePointInfo : bps) {
                    if (this.getIntValue(FLOATCONFIGSETTING) == PositionInfo.FloatConfigSetting.PART.getIndex()) {
                        if (!selectArea.isEmpty() && selectArea.contains(basePointInfo.getDynaRange())) {
                            this.setConfigInfo(basePointInfo);
                        }
                        if (!selectArea.isEmpty()) continue;
                        this.setConfigInfo(basePointInfo);
                        continue;
                    }
                    if (selectArea.isEmpty() || !selectArea.contains(basePointInfo.getDynaRange())) continue;
                    basePointInfo.setFloatConfigSetting(PositionInfo.FloatConfigSetting.TOTAL);
                }
            }
            if (ps == null || this.getIntValue(FLOATCONFIGSETTING) != PositionInfo.FloatConfigSetting.TOTAL.getIndex()) continue;
            this.setInfo(ps);
        }
        this.getPageCache().remove(POSITIONCACHE);
        this.getPageCache().put(POSITIONCACHE, JsonSerializerUtil.toJson((SpreadManager)spreadManager));
    }

    private void switchDataArea(String area) {
        PositionInfo p = null;
        for (PositionInfo e : this.getSpreadModel().getAreaManager().getPostionInfoSet()) {
            if (!e.getAreaRange().equals(area)) continue;
            p = e;
            break;
        }
        if (p != null) {
            this.getView().getFormShowParameter().setCustomParam("ps", (Object)this.toByteSerialized(p));
            this.getView().cacheFormShowParameter();
            this.getPageCache().put("change", "false");
            this.getPageCache().put(SELECTAREAS, null);
            this.loadFloatArea();
            this.getView().updateView(entryentity);
            this.getPageCache().put("change", "true");
            EntryGrid treeEntry = (EntryGrid)this.getControl(entryentity);
            if (treeEntry.getEntryData().getDataEntitys() != null && treeEntry.getEntryData().getDataEntitys().length > 0 && this.checkSelectSameConfig(null, null)) {
                this.updateFloatConfigSetting(treeEntry.getEntryData().getDataEntitys()[0], null);
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEXPANELAP1});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEXPANELAP11});
            }
        }
    }

    private void setInfo(PositionInfo posio) {
        Object isShowFloatMember = this.getModel().getValue(ISSHOWFLOATMEMBER);
        Boolean isshowtext = (Boolean)this.getModel().getValue(ISSHOWTEXT);
        Boolean isshownull = (Boolean)this.getModel().getValue(ISSHOWNULL);
        posio.setShowFolatText(isshowtext);
        posio.setShowFolatNullOrZero(isshownull);
        posio.setFloatConfigSetting(PositionInfo.FloatConfigSetting.getPattern((int)this.getIntValue(FLOATCONFIGSETTING)));
        if (isShowFloatMember != null) {
            posio.setShowFloatMember((Boolean)isShowFloatMember);
        }
        posio.setOrgMemColIndex(-1);
        posio.setFloatSummaryWay(PositionInfo.FloatSummaryWay.SUPPORT);
        posio.setFloatMemDisplayPattern(PositionInfo.FloatMemDisplayPattern.getPattern((int)this.getIntValue(DISPLAYPATTERN)));
        posio.setMyCompanyAutoConvent(PositionInfo.MyCompanyAutoConvent.getPattern((int)this.getIntValue(MYCOMAUTOCONV)));
        if (this.getModel().getValue(OFFSET) != null) {
            String offset = this.getModel().getValue(OFFSET).toString();
            ArrayList offsetindex = new ArrayList(10);
            Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)offset).forEach(i -> offsetindex.add(Integer.valueOf(i)));
            posio.setOffsetIndex(offsetindex);
        } else {
            posio.setOffsetIndex(null);
        }
    }

    private void setOffsetCombox(PositionInfo info) {
        String floattype = this.getPageCache().get(FLOATTYPE);
        if (kd.bos.util.StringUtils.isEmpty((String)floattype)) {
            return;
        }
        MulComboEdit mce = (MulComboEdit)this.getControl(OFFSET);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        String arearange = info.getStartPosition() + ":" + info.getAreaRange().split(":")[1];
        String[] colnums = ExcelUtils.calColAxisSerial((String)arearange);
        String name = ResManager.loadKDString((String)"\u5217", (String)"TemplateFloatSettingPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        if ("col".equals(floattype)) {
            colnums = ExcelUtils.calRowAxisSerial((String)arearange);
            name = ResManager.loadKDString((String)"\u884c", (String)"TemplateFloatSettingPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        int i = 0;
        for (String col : colnums) {
            items.add(new ComboItem(new LocaleString(String.format(ResManager.loadKDString((String)"\u7b2c%1$s%2$s", (String)"TemplateFloatSettingPlugin_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]), col, name)), String.valueOf(i++)));
        }
        this.getPageCache().put("listsize", String.valueOf(i > 0 ? i - 1 : 0));
        mce.setComboItems(items);
    }

    private String buildNewmembasShowname(String name, int scope) {
        String showtext = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684%2$s", (String)"TemplateFloatSettingPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]), name, MembAddPositionEnum.getMembAddPositionEnumByVal((int)scope).getName());
        return showtext;
    }

    private String buildFloatMemShowname(String name, int scope) {
        String showtext = RangeEnum.getRangeByVal((int)scope) == RangeEnum.VALUE_10 ? name : String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684%2$s", (String)"TemplateFloatSettingPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]), name, RangeEnum.getRangeByVal((int)scope).getName());
        return showtext;
    }

    private DimMember getSeqMem() {
        if (this.member != null) {
            return this.member;
        }
        QFBuilder qb = new QFBuilder();
        qb.add(new QFilter("model", "=", (Object)this.getModelId()));
        qb.add(new QFilter(ISSEQ, "=", (Object)"1"));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_userdefinedmembertree", (String)"dimension.number,number", (QFilter[])qb.toArray());
        if (doc != null && !doc.isEmpty()) {
            if (doc.size() == 1) {
                DimMember member;
                String dimnum = ((DynamicObject)doc.get(0)).getString("dimension.number");
                String memnum = ((DynamicObject)doc.get(0)).getString("number");
                Dimension dim = new Dimension(null, dimnum, null);
                this.member = member = new DimMember(null, memnum, null, (IDimension)dim);
                return member;
            }
            if (this.getPageCache().get(SHOWTIPSISSEQ) == null) {
                this.getPageCache().put(SHOWTIPSISSEQ, "true");
            }
        }
        return null;
    }
}

