/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.papertemplate.ExtDimHelper;
import kd.fi.bcm.business.papertemplate.InnerTradeTemplateModel;
import kd.fi.bcm.business.papertemplate.PaperTemplateCatalog;
import kd.fi.bcm.business.papertemplate.PaperTemplateFieldEntry;
import kd.fi.bcm.business.papertemplate.PaperTemplateHelper;
import kd.fi.bcm.business.papertemplate.PaperTemplateService;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.ColDimensionEntry;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.RowDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateCatalog;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.business.util.LanguageUtil;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.TemplateUsageEnum;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateTypeEnum;
import kd.fi.bcm.common.enums.template.DisEffectWayEnum;
import kd.fi.bcm.common.log.DebugHelper;
import kd.fi.bcm.common.papertemplate.PaperTemplateScenarioSettingConstant;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.template.util.TemplateScanMemberService;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.FreeStyleTemplateFinalBuilder;
import kd.fi.bcm.spread.domain.view.builder.extend.ExtendInfo;
import org.apache.commons.io.IOUtils;

public final class TemplateImport {
    private static final String SCENARIO_MEMBER_NUMBER_CM = "MRpt";
    private static final String INTERCOMPANY_MEMBER_NUMBER = "ICNone";
    private static final String MYCOMPANY_MEMBER_NUMBER = "MCNone";
    private static final String ORG_MEMBER_NUMBER = "";
    private static final String FY_MEMBER_NUMBER = "AllYear";
    private static final String PERIOD_MEMBER_NUMBER = "Period";
    private static final String CURRENCY_MEMBER_NUMBER = "Currency";
    private static final String PROCESS_MEMBER_NUMBER = "Process";
    private static final String PROCESS_MEMBER_NUMBER_2 = "EIRpt";
    private static final String AUDITTRIAL_MEMBER_NUMBER = "AuditTrail";
    private static final String MULTIGAAP_MEMBER_NUMBER = "PRCGAAP";
    private static final String DATASORT_MEMBER_NUMBER = "Actual";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String NUMBER = "number";
    private static final String NAEM = "name";
    private static final String PRENUMBER = "pre_number";
    private static final String MODEL = "model";
    private static final String XINTERNALPURCHASE = "XInternalPurchase";
    private static final String XINTERNALSALES = "XInternalSales";
    private static final String XINTERNALCONSOL = "XInternalConsol";
    private static final String XP_AREARANAGE = "A4:L13";
    private static final String XS_AREARANAGE = "A4:E13";
    private static final String EXTMODEL_INTR_SALE = "INTR_SALE";
    private static final String EXTMODEL_INTR_PURCHASE = "INTR_PURCHASE";
    private static final String EXTMODEL_INTR_CONSOL = "INTR_CONSOL";

    public void importTemplates(DynamicObject model, ApplicationTypeEnum app, boolean isImportExtTemplate) {
        block15: {
            Long modelId = model.getLong("id");
            List<Map<String, String>> templateInfo = this.getTemplateInfo(modelId, app, isImportExtTemplate);
            DynamicObject[] dimensionDyObjArray = this.getACDimension(modelId);
            TemplateCatalog catalog = this.getTemplateCatalog(new QFilter(MODEL, "=", (Object)modelId));
            long icId = isImportExtTemplate ? this.getICEntityId(modelId) : 0L;
            Date time = new Date();
            ArrayList list = new ArrayList(16);
            ArrayList<String> numberList = new ArrayList<String>(16);
            templateInfo.forEach(map -> list.add(this.getTemplateDyo(dimensionDyObjArray, icId, time, model, catalog, app, (Map<String, String>)map, (List<String>)numberList, isImportExtTemplate)));
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bcm_templateentity");
            if (isImportExtTemplate) {
                try (TXHandle tx = TX.requiresNew((String)"ext_template_pre_save");){
                    try {
                        BusinessDataWriter.save((IDataEntityType)dataEntityType, (Object[])list.toArray());
                        this.importTemplateDistribution(modelId, numberList);
                        this.saveExtModelRefTemplate(modelId, numberList);
                        this.saveInnerTradeTpl(model);
                        break block15;
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw e;
                    }
                }
            }
            BusinessDataWriter.save((IDataEntityType)dataEntityType, (Object[])list.toArray());
            this.importTemplateDistribution(modelId, numberList);
        }
    }

    private List<Map<String, String>> getTemplateInfo(Long modelId, ApplicationTypeEnum app, boolean isImportExtTemplate) {
        ArrayList<Map<String, String>> templateInfo = new ArrayList<Map<String, String>>(16);
        if (isImportExtTemplate) {
            this.addExtTemplateInfo(templateInfo, modelId);
        } else {
            this.insertBasicData(templateInfo, app);
        }
        return templateInfo;
    }

    private void addExtTemplateInfo(List<Map<String, String>> templateInfo, long modelId) {
        QFilter qFilter = new QFilter(MODEL, "=", (Object)modelId);
        qFilter.and("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
        ArrayList numberList = new ArrayList(16);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_templateentity", (String)NUMBER, (QFilter[])qFilter.toArray());
        if (!dynamicObjects.isEmpty()) {
            dynamicObjects.forEach(dyo -> numberList.add(dyo.getString(NUMBER)));
        }
        Arrays.asList(XINTERNALPURCHASE, XINTERNALSALES).forEach(templateNum -> {
            HashMap<String, String> baseInfoMap = new HashMap<String, String>(16);
            switch (templateNum) {
                case "XInternalPurchase": {
                    baseInfoMap.put(NAEM, ResManager.loadKDString((String)"\u5185\u90e8\u91c7\u8d2d\u6570\u636e\u8868", (String)"TemplateImport_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    baseInfoMap.put(NUMBER, XINTERNALPURCHASE);
                    baseInfoMap.put(PRENUMBER, XINTERNALPURCHASE);
                    break;
                }
                case "XInternalSales": {
                    baseInfoMap.put(NAEM, ResManager.loadKDString((String)"\u5185\u90e8\u9500\u552e\u6570\u636e\u8868", (String)"TemplateImport_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    baseInfoMap.put(NUMBER, XINTERNALSALES);
                    baseInfoMap.put(PRENUMBER, XINTERNALSALES);
                    break;
                }
            }
            if (numberList.contains(templateNum)) {
                baseInfoMap.put(NUMBER, this.getAutoDeTemplateNumber(numberList, (String)templateNum));
            }
            templateInfo.add(baseInfoMap);
        });
    }

    private DynamicObject[] getACDimension(Long modelId) {
        String algoKey = this.getClass().getName();
        QFilter filterModel = new QFilter(MODEL, "=", (Object)modelId);
        QFilter filterNumber = new QFilter(NUMBER, "not in", (Object)new String[]{DimTypesEnum.ACCOUNT.getNumber(), DimTypesEnum.CHANGETYPE.getNumber()});
        DynamicObjectCollection collection = QueryServiceHelper.query((String)algoKey, (String)"bcm_dimension", (String)"id", (QFilter[])new QFilter[]{filterModel, filterNumber}, (String)"id");
        ArrayList ids = new ArrayList(16);
        collection.forEach(e -> ids.add(e.getLong("id")));
        DynamicObject[] dimensionDyObjArray = null;
        try {
            dimensionDyObjArray = BusinessDataReader.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_dimension"), (Boolean)true);
        }
        catch (Exception e2) {
            DebugHelper.debugDataObjectType((String[])new String[]{"bcm_dimension", "bcm_model"});
            throw new RuntimeException(e2);
        }
        return dimensionDyObjArray;
    }

    private long getICEntityId(Long modelId) {
        QFilter filterModel = new QFilter(MODEL, "=", (Object)modelId);
        QFilter numberFilter = new QFilter(NUMBER, "=", (Object)"ICEntity");
        return QueryServiceHelper.queryOne((String)"bcm_icmembertree", (String)"id", (QFilter[])new QFilter[]{filterModel, numberFilter}).getLong("id");
    }

    private DynamicObject getTemplateDyo(DynamicObject[] dimensionDyObjArray, long icId, Date time, DynamicObject model, TemplateCatalog catalog, ApplicationTypeEnum app, Map<String, String> map, List<String> numberList, boolean isImportExtTemplate) {
        Long modelId = model.getLong("id");
        String spreadJson = this.getTemplateSpreadJsonFromResources(app, map.get(isImportExtTemplate ? PRENUMBER : NUMBER));
        TemplateModel template = new TemplateModel();
        template.setSpreadJson(spreadJson);
        template.setNumber(map.get(NUMBER));
        template.setName(map.get(NAEM));
        template.setTemplateCatalog(catalog);
        template.setUsage(TemplateUsageEnum.FORWEAVE.getValue());
        template.setVersionNumber(new BigDecimal("1.0"));
        template.setVersionStatus("1");
        template.setModelId(modelId.longValue());
        template.setGroup(DBServiceHelper.genGlobalLongId());
        template.setTemplateType(TemplateTypeEnum.FIX.getType());
        template.setIsOnlyRead(false);
        template.setIsOldTemplate(false);
        template.setCreatorId(Long.parseLong(RequestContext.get().getUserId()));
        template.setCreateTime(time);
        template.setModifierId(Long.parseLong(RequestContext.get().getUserId()));
        template.setModifyTime(time);
        template.setCreateOrgId(RequestContext.get().getOrgId());
        template.setStatus("1");
        template.setEffectiveDate(EntityVersioningUtil.getModelBeginDate((DynamicObject)model));
        boolean isRptCf = app == ApplicationTypeEnum.RPT && "CF".equals(map.get(NUMBER));
        this.fillViewDimAndPageDim(template, dimensionDyObjArray, isRptCf);
        this.fillAreaRangeEntrys(template, isImportExtTemplate, map, app);
        template.setRptData(isImportExtTemplate ? this.getDataSerialforExtTemplate(app, map.get(PRENUMBER) + "_rptdata", icId) : this.getTemplateSpreadModelSerial(app, map.get(NUMBER) + "_rptdata"));
        template.setData(isImportExtTemplate ? this.getDataSerialforExtTemplate(app, map.get(PRENUMBER) + "_data", icId) : this.getTemplateSpreadModelSerial(app, map.get(NUMBER) + "_data"));
        template.setRptSpreadJson(this.getTemplateSpreadJsonFromResources(app, map.get(isImportExtTemplate ? PRENUMBER : NUMBER) + "_rptspreadjson"));
        SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)template.getData());
        FreeStyleTemplateFinalBuilder builder = new FreeStyleTemplateFinalBuilder(sm, template);
        TemplateScanMemberService service = new TemplateScanMemberService(sm, template);
        service.setFromCreateModel(!isImportExtTemplate);
        builder.doBuildReport(true, false);
        service.scan();
        DynamicObject dynamicObject = template.genDynamicObject();
        String name = dynamicObject.getString(NAEM);
        String number = dynamicObject.getString(NUMBER);
        Map transName = LanguageUtil.getTranslate((String)name, (String)("TemplateImport_" + number + "_" + app.getAppnum()), (String)"fi-bcm-business");
        dynamicObject.set(NAEM, LanguageUtil.getName((String)name, (Map)transName));
        numberList.add(number);
        return dynamicObject;
    }

    private QFilter getModelFilter(TemplateModel template) {
        return new QFilter(MODEL, "=", (Object)template.getModelId());
    }

    private void fillAreaRangeEntrys(TemplateModel template, boolean isImportExtTemplate, Map<String, String> map, ApplicationTypeEnum app) {
        if (isImportExtTemplate) {
            AreaRangeEntry areaRangeEntry = new AreaRangeEntry(template);
            if (map.get(NUMBER).startsWith(XINTERNALPURCHASE)) {
                areaRangeEntry.setAreaRange(XP_AREARANAGE);
                areaRangeEntry.setStartPosition(XP_AREARANAGE.split(":")[0]);
            } else if (map.get(NUMBER).startsWith(XINTERNALSALES)) {
                areaRangeEntry.setAreaRange(XS_AREARANAGE);
                areaRangeEntry.setStartPosition(XS_AREARANAGE.split(":")[0]);
            }
            template.getAreaRangeEntries().add(areaRangeEntry);
        } else {
            ArrayList<AreaRangeEntry> areaRangeEntryList = new ArrayList<AreaRangeEntry>(16);
            QFilter filterModel = this.getModelFilter(template);
            boolean isRpt = app == ApplicationTypeEnum.RPT;
            switch (map.get(NUMBER)) {
                case "BS": {
                    areaRangeEntryList.add(this.getAreaRangeEntry(template, filterModel, isRpt ? "B4:C44" : "C4:D40", isRpt ? "B4" : "C4", app));
                    areaRangeEntryList.add(this.getAreaRangeEntry(template, filterModel, isRpt ? "E4:F44" : "G4:H40", isRpt ? "E4" : "G4", app));
                    break;
                }
                case "PL": {
                    areaRangeEntryList.add(this.getAreaRangeEntry(template, filterModel, isRpt ? "B4:C47" : "C4:D36", isRpt ? "B4" : "C4", app));
                    break;
                }
                case "CF": {
                    if (isRpt) {
                        areaRangeEntryList.add(this.getAreaRangeEntry(template, filterModel, "B4:C41", "B4", app));
                        break;
                    }
                    areaRangeEntryList.add(this.getAreaRangeEntry(template, filterModel, "C4:D42", "C4", app));
                    areaRangeEntryList.add(this.getAreaRangeEntry(template, filterModel, "G4:H42", "G4", app));
                    break;
                }
            }
            template.getAreaRangeEntries().addAll(areaRangeEntryList);
        }
    }

    private void fillViewDimAndPageDim(TemplateModel template, DynamicObject[] dimensionDyObjArray, boolean isRptCf) {
        QFilter filterModel = this.getModelFilter(template);
        ArrayList<ViewPointDimensionEntry> viewPointDimensionEntryList = new ArrayList<ViewPointDimensionEntry>(16);
        ArrayList<PageDimensionEntry> pageDimensionEntryList = new ArrayList<PageDimensionEntry>(16);
        block13: for (DynamicObject dimensionDyObj : dimensionDyObjArray) {
            String dimensionNumber = dimensionDyObj.getString(NUMBER);
            long dimensionId = dimensionDyObj.getLong("id");
            QFilter filterDimension = new QFilter("dimension", "=", (Object)dimensionId);
            DimTypesEnum dimEnum = this.getDimTypesEnum(dimensionNumber);
            if (dimEnum == null) {
                viewPointDimensionEntryList.add(this.getViewPointDimensionEntry(template, dimensionDyObj, filterModel, filterDimension, "bcm_userdefinedmembertree", dimensionDyObj.getString("shortnumber") + "None"));
                continue;
            }
            switch (dimEnum) {
                case SCENARIO: {
                    pageDimensionEntryList.add(this.getPageDimensionEntry(template, dimensionDyObj, filterModel, filterDimension, "bcm_scenemembertree", SCENARIO_MEMBER_NUMBER_CM));
                    continue block13;
                }
                case INTERCOMPANY: {
                    viewPointDimensionEntryList.add(this.getViewPointDimensionEntry(template, dimensionDyObj, filterModel, filterDimension, "bcm_icmembertree", INTERCOMPANY_MEMBER_NUMBER));
                    continue block13;
                }
                case ENTITY: {
                    pageDimensionEntryList.add(this.getPageDimensionEntry(template, dimensionDyObj, filterModel, filterDimension, "bcm_entitymembertree", ORG_MEMBER_NUMBER));
                    continue block13;
                }
                case MYCOMPANY: {
                    viewPointDimensionEntryList.add(this.getViewPointDimensionEntry(template, dimensionDyObj, filterModel, filterDimension, "bcm_mycompanymembertree", MYCOMPANY_MEMBER_NUMBER));
                    continue block13;
                }
                case YEAR: {
                    pageDimensionEntryList.add(this.getPageDimensionEntry(template, dimensionDyObj, filterModel, filterDimension, "bcm_fymembertree", FY_MEMBER_NUMBER));
                    continue block13;
                }
                case PERIOD: {
                    if (isRptCf) continue block13;
                    pageDimensionEntryList.add(this.getPageDimensionEntry(template, dimensionDyObj, filterModel, filterDimension, "bcm_periodmembertree", PERIOD_MEMBER_NUMBER));
                    continue block13;
                }
                case CURRENCY: {
                    pageDimensionEntryList.add(this.getPageDimensionEntry(template, dimensionDyObj, filterModel, filterDimension, "bcm_currencymembertree", CURRENCY_MEMBER_NUMBER));
                    continue block13;
                }
                case PROCESS: {
                    pageDimensionEntryList.add(this.getPageDimensionEntry(template, dimensionDyObj, filterModel, filterDimension, "bcm_processmembertree", PROCESS_MEMBER_NUMBER));
                    continue block13;
                }
                case AUDITTRIAL: {
                    pageDimensionEntryList.add(this.getPageDimensionEntry(template, dimensionDyObj, filterModel, filterDimension, "bcm_audittrialmembertree", AUDITTRIAL_MEMBER_NUMBER));
                    continue block13;
                }
                case MULTIGAAP: {
                    pageDimensionEntryList.add(this.getPageDimensionEntry(template, dimensionDyObj, filterModel, filterDimension, "bcm_rulemembertree", MULTIGAAP_MEMBER_NUMBER));
                    continue block13;
                }
                case DATASORT: {
                    pageDimensionEntryList.add(this.getPageDimensionEntry(template, dimensionDyObj, filterModel, filterDimension, "bcm_datasortmembertree", DATASORT_MEMBER_NUMBER));
                    continue block13;
                }
            }
        }
        template.getViewPointDimensionEntries().addAll(viewPointDimensionEntryList);
        template.getPageDimensionEntries().addAll(pageDimensionEntryList);
    }

    private void saveInnerTradeTpl(DynamicObject model) {
        if (Objects.isNull(model)) {
            return;
        }
        InnerTradeTemplateModel innerModel = this.bulidInnerModel(model);
        Long modelId = model.getLong("id");
        QFilter filterModel = new QFilter(MODEL, "=", (Object)modelId);
        QFilter numberFilter = new QFilter(NUMBER, "in", Arrays.asList(EXTMODEL_INTR_PURCHASE, EXTMODEL_INTR_SALE, EXTMODEL_INTR_CONSOL));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"id,number", (QFilter[])new QFilter[]{filterModel, numberFilter});
        Map<String, Long> extDataModelmap = dynamicObjects.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString(NUMBER), dynamicObject -> dynamicObject.getLong("id")));
        innerModel.setSeller(extDataModelmap.get(EXTMODEL_INTR_SALE));
        innerModel.setPurchaser(extDataModelmap.get(EXTMODEL_INTR_PURCHASE));
        innerModel.setMergeNode(extDataModelmap.get(EXTMODEL_INTR_CONSOL));
        innerModel.setUsage("0");
        QFilter filterNumber = new QFilter(NUMBER, "=", (Object)"Entity");
        DynamicObject org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id, name", (QFilter[])new QFilter[]{filterModel, filterNumber});
        if (Objects.nonNull(org)) {
            innerModel.setEffectivescope(org.getString(NAEM) + "," + RangeEnum.VALUE_110.getName());
        }
        DynamicObject t = innerModel.genDynamicObject();
        t.set(NAEM, LanguageUtil.getValue((String)innerModel.getName(), (String)"TemplateImport_14", (String)FI_BCM_FORMPLUGIN));
        BusinessDataWriter.save((IDataEntityType)t.getDataEntityType(), (Object[])new Object[]{t});
        this.distributeInnerTpl(modelId, org);
        this.saveTmplScene(innerModel);
    }

    private void saveTmplScene(InnerTradeTemplateModel innerModel) {
        HashMap<String, Object> item = new HashMap<String, Object>(16);
        IDNumberTreeNode node = MemberReader.findScenaMemberByNum((String)MemberReader.findModelNumberById((Object)innerModel.getModelId()), (String)PresetConstant.SCENE_DIM);
        item.put("id", node.getId());
        item.put("scope", String.valueOf(PaperTemplateScenarioSettingConstant.MemRangeEnum.ALL_SUB_BASE.getCode()));
        item.put("isexcept", String.valueOf(PaperTemplateScenarioSettingConstant.ExceptEnum.APPLICABLE.getCode()));
        PaperTemplateHelper.saveTmplScene((long)innerModel.getModelId(), (PaperTemplateTypeEnum)PaperTemplateTypeEnum.INNERTRADE, (long)innerModel.getGroup(), (List)Lists.newArrayList((Object[])new Map[]{item}));
    }

    private InnerTradeTemplateModel bulidInnerModel(DynamicObject model) {
        Long modelId = model.getLong("id");
        QFilter filterModel = new QFilter(MODEL, "=", (Object)modelId);
        Date time = new Date();
        String templateData = this.getTemplateSpreadModelSerial(ApplicationTypeEnum.CM, "XInternalConsol_data");
        InnerTradeTemplateModel template = (InnerTradeTemplateModel)ObjectSerialUtil.deSerializedBytes((String)templateData);
        PaperTemplateCatalog catalog = this.getPaperTemplateCatalog(modelId);
        template.setTemplateCatalog(catalog);
        template.setModelId(modelId.longValue());
        template.setGroup(DBServiceHelper.genGlobalLongId());
        template.setId(DBServiceHelper.genGlobalLongId());
        template.setCreatorId(Long.parseLong(RequestContext.get().getUserId()));
        template.setCreateTime(time);
        template.setModifierId(Long.parseLong(RequestContext.get().getUserId()));
        template.setModifyTime(time);
        template.setEffectiveDate(EntityVersioningUtil.getModelBeginDate((DynamicObject)model));
        QFilter filterNumber = new QFilter(NUMBER, "=", (Object)DimTypesEnum.SCENARIO.getNumber());
        DynamicObject scene = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id", (QFilter[])new QFilter[]{filterModel, filterNumber});
        long dimensionId = scene.getLong("id");
        QFilter filterDimension = new QFilter("dimension", "=", (Object)dimensionId).and(NUMBER, "=", (Object)SCENARIO_MEMBER_NUMBER_CM);
        DynamicObject mrpt = QueryServiceHelper.queryOne((String)"bcm_scenemembertree", (String)"id", (QFilter[])new QFilter[]{filterDimension});
        template.setScenario(Long.valueOf(mrpt.getLong("id")));
        QFilter numberFilter = new QFilter(NUMBER, "=", (Object)EXTMODEL_INTR_CONSOL);
        DynamicObject extmodel = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id,number", (QFilter[])new QFilter[]{filterModel, numberFilter});
        List fields = ExtDimHelper.getTmpFieldByExtModelId((Long)extmodel.getLong("id"));
        HashMap<String, IntrField> number2Field = new HashMap<String, IntrField>(16);
        fields.forEach(field -> {
            if (field != null && StringUtils.isNotEmpty((String)field.getNumber()) && field.getId() != 0L) {
                number2Field.put(field.getNumber(), (IntrField)field);
            }
        });
        return this.copyPaperField(template, number2Field, extmodel.getLong("id"));
    }

    private void distributeInnerTpl(Long modelId, DynamicObject org) {
        QFilter filterModel = new QFilter(MODEL, "=", (Object)modelId);
        QFilter templateFilter = new QFilter(NUMBER, "=", (Object)XINTERNALCONSOL);
        DynamicObject template = QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)"id", (QFilter[])new QFilter[]{filterModel, templateFilter});
        DynamicObject t = BusinessDataServiceHelper.newDynamicObject((String)"bcm_templateassignrecord");
        t.set(MODEL, (Object)modelId);
        t.set("template", (Object)template.getLong("id"));
        t.set("range", (Object)RangeEnum.VALUE_110.getValue());
        t.set("isexcept", (Object)"0");
        if (Objects.nonNull(org)) {
            t.set("entity", (Object)org.getLong("id"));
            t.set("textname", org.get(NAEM));
        }
        BusinessDataWriter.save((IDataEntityType)t.getDataEntityType(), (Object[])new DynamicObject[]{t});
    }

    private InnerTradeTemplateModel copyPaperField(InnerTradeTemplateModel template, Map<String, IntrField> number2Field, Long extmodelId) {
        ArrayList<PaperTemplateFieldEntry> formulas = new ArrayList<PaperTemplateFieldEntry>(template.getPaperTemplateField().size());
        for (PaperTemplateFieldEntry one : template.getPaperTemplateField()) {
            IntrField field = number2Field.get(one.getExtModelFieldNumber());
            one.setFieldId(field.getExtFieldRefType(), field.getExtFieldRefId());
            one.setExtModelId(extmodelId);
            one.setEntryId(0L);
            one.setId(0L);
            formulas.add(one);
        }
        template.setPaperTemplateField(formulas);
        return template;
    }

    private void saveExtModelRefTemplate(long modelId, List<String> templateList) {
        QFilter numberFilter;
        QFilter templateFilter = new QFilter(NUMBER, "in", templateList);
        QFilter filterModel = new QFilter(MODEL, "=", (Object)modelId);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"id,number", (QFilter[])new QFilter[]{filterModel, numberFilter = new QFilter(NUMBER, "in", Arrays.asList(EXTMODEL_INTR_PURCHASE, EXTMODEL_INTR_SALE, EXTMODEL_INTR_CONSOL))});
        if (!dynamicObjects.isEmpty()) {
            HashMap extDataModelmap = new HashMap(16);
            dynamicObjects.forEach(dyo -> {
                if (dyo != null && StringUtils.isNotEmpty((String)dyo.getString(NUMBER)) && dyo.getLong("id") != 0L) {
                    extDataModelmap.put(dyo.getString(NUMBER), dyo.getLong("id"));
                }
            });
            DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number", (QFilter[])new QFilter[]{filterModel, templateFilter});
            ArrayList<DynamicObject> ds = new ArrayList<DynamicObject>(3);
            for (DynamicObject template : templates) {
                DynamicObject t = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extmodelref");
                t.set(MODEL, (Object)modelId);
                t.set("template", (Object)template.getLong("id"));
                String extModelNumber = template.getString(NUMBER).startsWith(XINTERNALPURCHASE) ? EXTMODEL_INTR_PURCHASE : EXTMODEL_INTR_SALE;
                if (Objects.isNull(extDataModelmap.get(extModelNumber))) continue;
                t.set("extmodel", extDataModelmap.get(extModelNumber));
                ds.add(t);
            }
            BusinessDataWriter.save((IDataEntityType)((DynamicObject)ds.get(0)).getDataEntityType(), (Object[])ds.toArray());
        }
    }

    private String getAutoDeTemplateNumber(List<String> numberList, String number) {
        if (number != null && numberList.contains(number = number + 1)) {
            number = this.getAutoDeTemplateNumber(numberList, number);
        }
        return number;
    }

    private DimTypesEnum getDimTypesEnum(String dimensionNumber) {
        DimTypesEnum[] dimTypesEnumArray;
        for (DimTypesEnum dimTypesEnum : dimTypesEnumArray = DimTypesEnum.values()) {
            if (!dimTypesEnum.getNumber().equals(dimensionNumber)) continue;
            return dimTypesEnum;
        }
        return null;
    }

    private void importTemplateDistribution(long modelId, List<String> templateList) {
        ArrayList<DynamicObject> ds = new ArrayList<DynamicObject>(16);
        QFilter filterModel = new QFilter(MODEL, "=", (Object)modelId);
        QFilter filterNumber = new QFilter(NUMBER, "=", (Object)"Entity");
        DynamicObject org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id, name", (QFilter[])new QFilter[]{filterModel, filterNumber});
        if (org != null) {
            QFilter templateFilter = new QFilter(NUMBER, "in", templateList);
            DynamicObjectCollection templates = QueryServiceHelper.query((String)this.getClass().getName(), (String)"bcm_templateentity", (String)"id", (QFilter[])new QFilter[]{filterModel, templateFilter}, null);
            for (DynamicObject template : templates) {
                DynamicObject t = BusinessDataServiceHelper.newDynamicObject((String)"bcm_distributionentity");
                t.set(MODEL, (Object)modelId);
                t.set("template", (Object)template.getLong("id"));
                t.set("memrangdecombo", (Object)RangeEnum.VALUE_40.getValue());
                t.set("effectway", (Object)DisEffectWayEnum.APPLY.getIndex());
                t.set("entity", (Object)org.getLong("id"));
                t.set("textname", org.get(NAEM));
                ds.add(t);
            }
        }
        if (!ds.isEmpty()) {
            BusinessDataWriter.save((IDataEntityType)((DynamicObject)ds.get(0)).getDataEntityType(), (Object[])ds.toArray());
        }
    }

    private void insertBasicData(List<Map<String, String>> templateInfo, ApplicationTypeEnum app) {
        HashMap<String, String> bs = new HashMap<String, String>(16);
        HashMap<String, String> cf = new HashMap<String, String>(16);
        HashMap<String, String> pl = new HashMap<String, String>(16);
        if (app != ApplicationTypeEnum.RPT) {
            bs.put(NAEM, ResManager.loadKDString((String)"\u8d44\u4ea7\u8d1f\u503a\u8868", (String)"TemplateImport_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            bs.put(NUMBER, "BS");
            templateInfo.add(bs);
            cf.put(NAEM, ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u8868", (String)"TemplateImport_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            cf.put(NUMBER, "CF");
            templateInfo.add(cf);
            pl.put(NAEM, ResManager.loadKDString((String)"\u5229\u6da6\u8868", (String)"TemplateImport_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            pl.put(NUMBER, "PL");
            templateInfo.add(pl);
        } else {
            bs.put(NAEM, ResManager.loadKDString((String)"\u8d44\u4ea7\u8d1f\u503a\u8868\uff082021\u7248\uff09", (String)"TemplateImport_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            bs.put(NUMBER, "BS");
            templateInfo.add(bs);
            cf.put(NAEM, ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u8868\uff082021\u7248\uff09", (String)"TemplateImport_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            cf.put(NUMBER, "CF");
            templateInfo.add(cf);
            pl.put(NAEM, ResManager.loadKDString((String)"\u5229\u6da6\u8868\uff082021\u7248\uff09", (String)"TemplateImport_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            pl.put(NUMBER, "PL");
            templateInfo.add(pl);
        }
    }

    private TemplateCatalog getTemplateCatalog(QFilter filterModel) {
        QFilter filterParent = new QFilter("parent", "=", (Object)0);
        DynamicObject catalogDynaObj = QueryServiceHelper.queryOne((String)"bcm_templatecatalog", (String)"id,name", (QFilter[])new QFilter[]{filterModel, filterParent});
        TemplateCatalog catalog = new TemplateCatalog();
        catalog.setId(catalogDynaObj.getLong("id"));
        catalog.setName(catalogDynaObj.getString(NAEM));
        return catalog;
    }

    private PaperTemplateCatalog getPaperTemplateCatalog(Long modelId) {
        QFilter filterModel = new QFilter(MODEL, "=", (Object)modelId);
        PaperTemplateService.initPresetCatalog((String)String.valueOf(modelId));
        QFilter filter = new QFilter("longnumber", "=", (Object)TemplateCatalogEnum.INNERTRADE.getLongnumber());
        DynamicObject catalogDynaObj = QueryServiceHelper.queryOne((String)"bcm_papertemplatecatalog", (String)"id,name", (QFilter[])new QFilter[]{filterModel, filter});
        PaperTemplateCatalog catalog = new PaperTemplateCatalog();
        catalog.setId(catalogDynaObj.getLong("id"));
        catalog.setName(catalogDynaObj.getString(NAEM));
        return catalog;
    }

    private AreaRangeEntry getAreaRangeEntry(TemplateModel template, QFilter filterModel, String areaRange, String startPosition, ApplicationTypeEnum app) {
        String rowDimNumber = DimTypesEnum.ACCOUNT.getNumber();
        String colDimNumber = DimTypesEnum.CHANGETYPE.getNumber();
        String colDimNumberPeriod = DimTypesEnum.PERIOD.getNumber();
        AreaRangeEntry areaRangeEntry = new AreaRangeEntry(template);
        areaRangeEntry.setAreaRange(areaRange);
        areaRangeEntry.setStartPosition(startPosition);
        DynamicObject rowDimDynaObj = this.getDimensionDynaObj(filterModel, rowDimNumber);
        if (rowDimDynaObj != null) {
            Dimension dimension = this.convertDynaObj2Dimension(rowDimDynaObj);
            RowDimensionEntry rowDimensionEntry = new RowDimensionEntry(areaRangeEntry);
            rowDimensionEntry.setDimension(dimension);
            areaRangeEntry.addRowDimEntry(rowDimensionEntry);
        }
        DynamicObject colDimDynaObj = this.getDimensionDynaObj(filterModel, colDimNumber);
        DynamicObject colDimDynaObjPeriod = null;
        if (ApplicationTypeEnum.RPT == app && "CF".equals(template.getNumber())) {
            colDimDynaObjPeriod = this.getDimensionDynaObj(filterModel, colDimNumberPeriod);
        }
        if (colDimDynaObj != null) {
            Dimension dimension = this.convertDynaObj2Dimension(colDimDynaObj);
            ColDimensionEntry colDimensiobEntry = new ColDimensionEntry(areaRangeEntry);
            colDimensiobEntry.setDimension(dimension);
            areaRangeEntry.addColDimEntry(colDimensiobEntry);
        }
        if (colDimDynaObjPeriod != null) {
            Dimension dimensionPeriod = this.convertDynaObj2Dimension(colDimDynaObjPeriod);
            ColDimensionEntry colDimensiobEntryPeriod = new ColDimensionEntry(areaRangeEntry);
            colDimensiobEntryPeriod.setDimension(dimensionPeriod);
            areaRangeEntry.addColDimEntry(colDimensiobEntryPeriod);
        }
        return areaRangeEntry;
    }

    private DynamicObject getDimensionDynaObj(QFilter filterModel, String number) {
        QFilter filterNumber = new QFilter(NUMBER, "=", (Object)number);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id,number,name,membermodel", (QFilter[])new QFilter[]{filterModel, filterNumber});
        return dynamicObject;
    }

    private ViewPointDimensionEntry getViewPointDimensionEntry(TemplateModel template, DynamicObject dimensionDyObj, QFilter filterModel, QFilter filterDimension, String entityName, String memberName) {
        ViewPointDimensionEntry viewEntry = new ViewPointDimensionEntry(template);
        Dimension dim = this.convertDynaObj2Dimension(dimensionDyObj);
        viewEntry.setDimension(dim);
        QFilter filterMember = new QFilter(NUMBER, "=", (Object)memberName);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)entityName, (String)"id, name, number", (QFilter[])new QFilter[]{filterModel, filterDimension, filterMember});
        Member member = this.convertDynaObj2Member(dynamicObject);
        member.setDimension(dim);
        member.setScope(10);
        viewEntry.setMember(member);
        return viewEntry;
    }

    private PageDimensionEntry getPageDimensionEntry(TemplateModel template, DynamicObject dimensionDyObj, QFilter filterModel, QFilter filterDimension, String entityName, String memberName) {
        PageDimensionEntry pageEntry = new PageDimensionEntry(template);
        Dimension dim = this.convertDynaObj2Dimension(dimensionDyObj);
        pageEntry.setDimension(dim);
        if (StringUtils.isEmpty((String)memberName)) {
            return pageEntry;
        }
        Member member = this.getMember(filterModel, filterDimension, entityName, memberName);
        Preconditions.checkNotNull((Object)member, (Object)ResManager.loadKDString((String)"\u9884\u7f6e\u7684\u7ef4\u5ea6\u6210\u5458\u6709\u8bef\u3002", (String)"TemplateImport_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        if (member != null) {
            member.setDimension(dim);
        }
        pageEntry.getMembers().add(member);
        return pageEntry;
    }

    private Member getMember(QFilter filterModel, QFilter filterDimension, String entityName, String memberName) {
        switch (memberName) {
            case "MRpt": {
                return this.getMemberAndSetScope(filterModel, filterDimension, entityName, memberName, RangeEnum.VALUE_10.getValue());
            }
            case "AllYear": {
                return this.getMemberAndSetScope(filterModel, filterDimension, entityName, memberName, RangeEnum.VALUE_40.getValue());
            }
            case "Period": {
                return this.getMemberAndSetScope(filterModel, filterDimension, entityName, memberName, RangeEnum.VALUE_40.getValue());
            }
            case "Currency": {
                return this.getMemberAndSetScope(filterModel, filterDimension, entityName, memberName, RangeEnum.VALUE_40.getValue());
            }
            case "Process": {
                return this.getMemberAndSetScope(filterModel, filterDimension, entityName, memberName, RangeEnum.VALUE_50.getValue());
            }
            case "EIRpt": {
                return this.getMemberAndSetScope(filterModel, filterDimension, entityName, memberName, RangeEnum.VALUE_10.getValue());
            }
            case "AuditTrail": {
                return this.getMemberAndSetScope(filterModel, filterDimension, entityName, memberName, RangeEnum.VALUE_50.getValue());
            }
            case "PRCGAAP": {
                return this.getMemberAndSetScope(filterModel, filterDimension, entityName, memberName, RangeEnum.VALUE_10.getValue());
            }
            case "Actual": {
                return this.getMemberAndSetScope(filterModel, filterDimension, entityName, memberName, RangeEnum.VALUE_10.getValue());
            }
        }
        return null;
    }

    private Member getMemberAndSetScope(QFilter filterModel, QFilter filterDimension, String entityName, String memberName, int scope) {
        QFilter fiterMember = new QFilter(NUMBER, "=", (Object)memberName);
        DynamicObject memberDynaObj = QueryServiceHelper.queryOne((String)entityName, (String)"id, name, number", (QFilter[])new QFilter[]{filterModel, filterDimension, fiterMember});
        Member member = this.convertDynaObj2Member(memberDynaObj);
        member.setScope(scope);
        return member;
    }

    private String getTemplateSpreadJsonFromResources(ApplicationTypeEnum app, String name) {
        InputStream in = null;
        boolean isEN = Lang.get() != Lang.zh_CN && Lang.get() != Lang.zh_TW;
        in = isEN ? this.getClass().getClassLoader().getResourceAsStream("template/fi/" + app.toString().toLowerCase(Locale.ENGLISH) + "_en/" + name + ".ssjson") : this.getClass().getClassLoader().getResourceAsStream("template/fi/" + app.toString().toLowerCase(Locale.ENGLISH) + "/" + name + ".ssjson");
        try {
            String string = IOUtils.toString((InputStream)in, (String)"UTF-8");
            return string;
        }
        catch (IOException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u6e90\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\u3002", (String)"TemplateImport_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private String getTemplateSpreadModelSerial(ApplicationTypeEnum app, String name) {
        InputStream in = null;
        boolean isEN = Lang.get() != Lang.zh_CN && Lang.get() != Lang.zh_TW;
        in = isEN ? this.getClass().getClassLoader().getResourceAsStream("template/fi/" + app.toString().toLowerCase(Locale.ENGLISH) + "_en/" + name + ".serial") : this.getClass().getClassLoader().getResourceAsStream("template/fi/" + app.toString().toLowerCase(Locale.ENGLISH) + "/" + name + ".serial");
        try {
            String string = IOUtils.toString((InputStream)in, (String)"UTF-8");
            return string;
        }
        catch (IOException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u6e90\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\u3002", (String)"TemplateImport_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private String getDataSerialforExtTemplate(ApplicationTypeEnum app, String name, long icId) {
        String templateSpreadModelSerial = this.getTemplateSpreadModelSerial(app, name);
        SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)templateSpreadModelSerial);
        Set postionInfoSet = spreadManager.getAreaManager().getPostionInfoSet();
        if (!postionInfoSet.isEmpty()) {
            postionInfoSet.forEach(ps -> {
                List floatdims;
                ExtendInfo extendInfo = ps.getExtendInfo();
                if (extendInfo != null && !(floatdims = extendInfo.getFloatdims()).isEmpty()) {
                    floatdims.forEach(floatDimInfo -> {
                        List dynaMembScopes = floatDimInfo.getDynaMembScopes();
                        if (!dynaMembScopes.isEmpty()) {
                            dynaMembScopes.forEach(dynaMembScopeInfo -> dynaMembScopeInfo.getMember().setId(icId));
                        }
                    });
                }
            });
        }
        return JsonSerializerUtil.toJson((SpreadManager)spreadManager);
    }

    private Member convertDynaObj2Member(DynamicObject dynaObj) {
        Member member = new Member();
        member.setId(dynaObj.getLong("id"));
        member.setNumber(dynaObj.getString(NUMBER));
        member.setName(dynaObj.getString(NAEM));
        member.setDataEntityNumber(dynaObj.getDataEntityType().getName());
        return member;
    }

    private Dimension convertDynaObj2Dimension(DynamicObject dynaObj) {
        Dimension dim = new Dimension();
        dim.setId(dynaObj.getLong("id"));
        dim.setNumber(dynaObj.getString(NUMBER));
        dim.setName(dynaObj.getString(NAEM));
        dim.setDataEntityNumber(dynaObj.getDataEntityType().getName());
        dim.setMemberEntityNumber(dynaObj.getString("membermodel"));
        return dim;
    }
}

