/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.list.IListColumn;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.fi.bcm.business.serviceHelper.CycleTablesServiceHelper;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;

public class TemplateListEntityPlugin
extends AbstractListPlugin {
    private static final String CACHE_TEMPLATE_DIS_CYCLETABLE = "templatediscycletable";

    public void beforePackageData(BeforePackageDataEvent e) {
        this.getPageCache().remove(CACHE_TEMPLATE_DIS_CYCLETABLE);
        if (this.isFromWorkPaper()) {
            return;
        }
        DynamicObjectCollection pageData = e.getPageData();
        if (pageData != null && !pageData.isEmpty() && ((DynamicObject)pageData.get(0)).getDataEntityType().getProperties().containsKey((Object)"model")) {
            long modelId = ((DynamicObject)pageData.get(0)).getLong("model.id");
            Map tmplDisCtDetail = CycleTablesServiceHelper.getTmplDisCtDetail((Object)modelId);
            this.getPageCache().put(CACHE_TEMPLATE_DIS_CYCLETABLE, ObjectSerialUtil.toByteSerialized((Object)tmplDisCtDetail));
        }
    }

    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        if ("templatetype".equals(args.getListFieldKey())) {
            List<String> templateType = this.getTemplateType();
            List comboItems = args.getComboItems();
            Iterator iterator = comboItems.iterator();
            while (iterator.hasNext()) {
                ValueMapItem next = (ValueMapItem)iterator.next();
                if (templateType.contains(next.getValue())) continue;
                iterator.remove();
            }
        }
        super.listColumnCompareTypesSet(args);
    }

    private List<String> getTemplateType() {
        ArrayList<String> templateType = new ArrayList<String>(16);
        if (this.isFromWorkPaper()) {
            templateType.add(TemplateTypeEnum.MSN.getType() + "");
        } else {
            templateType = TemplateTypeEnum.getCommonTemplateType();
        }
        return templateType;
    }

    public void packageData(PackageDataEvent e) {
        String key;
        super.packageData(e);
        if (this.isFromWorkPaper()) {
            return;
        }
        if (ColumnDesc.class.isAssignableFrom(e.getSource().getClass()) && "cycletable.name".equals(key = ((ColumnDesc)e.getSource()).getKey())) {
            long id;
            Map cacheMap;
            String ctName = "";
            if (this.getPageCache().get(CACHE_TEMPLATE_DIS_CYCLETABLE) != null && (cacheMap = (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(CACHE_TEMPLATE_DIS_CYCLETABLE))).get(id = e.getRowData().getLong("id")) != null) {
                ctName = (String)cacheMap.get(id);
            }
            e.setFormatValue((Object)ctName);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        if (this.isFromWorkPaper()) {
            List listColumns = args.getListColumns();
            Iterator iterator = listColumns.iterator();
            while (iterator.hasNext()) {
                if (!((IListColumn)iterator.next()).getListFieldKey().equals("cycletable.name")) continue;
                iterator.remove();
            }
            args.setListColumns(listColumns);
        }
        super.beforeCreateListColumns(args);
    }

    private boolean isFromWorkPaper() {
        return this.getView().getFormShowParameter().getCustomParam("fromworkpaper") != null;
    }
}

