/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.page.model.PageBasicInfo;
import kd.fi.bcm.business.page.model.TextEditElement;
import kd.fi.bcm.business.page.model.util.DragUtil;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.TemplatePermCrossUtil;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;

public class TemplateListOrderPopupPlugin
extends AbstractBaseListPlugin
implements DynamicPage {
    private static String ORDERBY_STR = "sequence asc,number asc";
    private static String NUMBER_LIST = "numberlist";
    private static String PANEL = "datapanel";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btnok", "btncancel");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        this.getModel().setValue("model", (Object)modelId);
        this.getModel().setValue("textfield", (Object)ResManager.loadKDString((String)"\u7f16\u7801 | \u540d\u79f0", (String)"TemplateListOrderPopupPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"model"});
        this.modelChange(modelId);
    }

    private boolean isFromWp() {
        return "bcm_paperlist".equals(this.getView().getFormShowParameter().getParentFormId());
    }

    private void modelChange(String modelid) {
        this.getPageCache().put("KEY_MODEL_ID", modelid);
        Long modelId = LongUtil.toLong((Object)modelid);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        boolean fromWp = this.isFromWp();
        if (fromWp) {
            qFilter.and("templatetype", "in", (Object)TemplateTypeEnum.getWPTypes());
            qFilter.and("templatecatalog.number", "=", (Object)TemplateCatalogEnum.MERGE_WP.getNumber());
        } else {
            qFilter.and("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
            TemplatePermCrossUtil.dealTemplatePermClassFilter((long)modelId, (QFilter)qFilter, (boolean)false);
        }
        DynamicObjectCollection adjustStatus = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number,name,sequence,versionnumber", (QFilter[])qFilter.toArray(), (String)ORDERBY_STR);
        if (!adjustStatus.isEmpty()) {
            DynamicObject[] statusDyn = this.filterVersionTemplate((DynamicObject[])adjustStatus.toArray((Object[])new DynamicObject[0]));
            this.bindEntry(statusDyn);
        }
    }

    private void bindEntry(DynamicObject[] adjustStatus) {
        this.getModel().beginInit();
        if (adjustStatus.length > 0) {
            int j;
            Page page = new Page();
            Area area = new Area(PANEL);
            String sign = "";
            LocaleString width = new LocaleString("90%");
            Long seq = 0L;
            for (j = 0; j < adjustStatus.length; ++j) {
                sign = "sign_" + adjustStatus[j].getString("id");
                TextEditElement textEditElement = this.createTextEditElement(adjustStatus[j].getString("number"), sign.toLowerCase(), width, 1, seq);
                textEditElement.addUserObject("seq", (Object)(j + 1));
                textEditElement.addUserObject("template_number_id", (Object)adjustStatus[j].getLong("id"));
                textEditElement.addUserObject("template_number", (Object)adjustStatus[j].getString("number"));
                area.addElement((Element)textEditElement);
            }
            page.addArea(area);
            this.setPage(this.getView(), page);
            page.updatePage(this.getView());
            page.setChangeable(true);
            this.setDraggable(page);
            for (j = 0; j < adjustStatus.length; ++j) {
                sign = "sign_" + adjustStatus[j].getString("id");
                StringBuilder stringBuffer = new StringBuilder();
                stringBuffer.append(adjustStatus[j].getString("number")).append(" | ").append(adjustStatus[j].getString("name"));
                this.getModel().setValue(sign, (Object)stringBuffer.toString());
            }
        }
        this.getModel().endInit();
        this.getView().updateView();
    }

    private void setDraggable(Page page) {
        page.getAreaList().forEach(a -> a.getElementListList().forEach(e -> {
            this.getView().getControl(e.getSign()).setDroppable(true);
            this.getView().getControl(e.getSign()).setDraggable(true);
        }));
    }

    private TextEditElement createTextEditElement(String name, String sign, LocaleString width, int editStyle, long seq) {
        TextEditElement textEditElement = new TextEditElement(name, sign, "");
        textEditElement.setEditStyle(editStyle);
        textEditElement.setWidth(width);
        textEditElement.setFieldStyle(1);
        textEditElement.setShowLabel(false);
        textEditElement.setHeight(new LocaleString("30px"));
        textEditElement.setLabelWidth(new LocaleString("0%"));
        textEditElement.setFieldTextAlign("left");
        textEditElement.setLock("new");
        return textEditElement;
    }

    public void customEvent(CustomEventArgs e) {
        String name = e.getEventName();
        if ("drop".equals(name)) {
            String eventArgs = e.getEventArgs();
            Page page = this.getPage(this.getView());
            boolean rebuildPageState = this.rebuildPage(page, eventArgs);
            if (rebuildPageState) {
                page.updatePage(this.getView());
                this.setPage(this.getView(), page);
                this.setDraggable(page);
            }
        }
    }

    private boolean rebuildPage(Page page, String command) {
        String[] msg = DragUtil.translateMessage((String)command);
        PageBasicInfo target = page.seaechSign(msg[0]);
        Element source = (Element)page.seaechSign(msg[1]);
        String dropSign = source.getSign();
        Area sourceArea = source.getArea();
        Area targetArea = ((Element)target).getArea();
        Element dropElement = source;
        int i = targetArea.getElementListList().indexOf(target);
        targetArea.removeElememt(dropSign);
        sourceArea.removeElememt(dropSign);
        dropElement.setArea(targetArea);
        targetArea.getElementListList().add(i, dropElement);
        return true;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control evtSource = (Control)evt.getSource();
        String key = evtSource.getKey();
        if (!this.validator()) {
            return;
        }
        Page page = this.getPage(this.getView());
        if (page == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4efb\u4f55\u6570\u636e\uff0c\u4e0d\u9700\u8981\u4fdd\u5b58\u3002", (String)"TemplateListOrderPopupPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            if ("btncancel".equals(key)) {
                this.getView().close();
            }
            return;
        }
        Area area = (Area)page.seaechSign(PANEL);
        if (area == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4efb\u4f55\u6570\u636e\uff0c\u4e0d\u9700\u8981\u4fdd\u5b58\u3002", (String)"TemplateListOrderPopupPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            if ("btncancel".equals(key)) {
                this.getView().close();
            }
            return;
        }
        List elementList = area.getElementListList();
        switch (key) {
            case "btnok": {
                if (elementList.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4efb\u4f55\u6570\u636e\uff0c\u4e0d\u9700\u8981\u4fdd\u5b58\u3002", (String)"TemplateListOrderPopupPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.templateSequenceOrderSave(elementList);
                OPDescMultiLangEnumBridge opDescMultiLangEnumBridge = null;
                opDescMultiLangEnumBridge = this.isFromWp() ? new OPDescMultiLangEnumBridge("\u5de5\u4f5c\u5e95\u7a3f\u6a21\u677f\u6392\u5e8f %1$s%2$s", "TemplateListOrderPopupPlugin_4", "fi-bcm-formplugin", new String[]{OpItemEnum.SAVE.getName(), ResultStatusEnum.SUCCESS.getName()}) : new OPDescMultiLangEnumBridge("\u62a5\u8868\u6a21\u677f\u6392\u5e8f %1$s%2$s", "TemplateListOrderPopupPlugin_3", "fi-bcm-formplugin", new String[]{OpItemEnum.SAVE.getName(), ResultStatusEnum.SUCCESS.getName()});
                this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.SAVE.getMultiLangEnumBridge(), (String)"save"), opDescMultiLangEnumBridge);
                this.getView().setReturnData((Object)true);
                this.getView().returnDataToParent((Object)true);
                this.getView().close();
                break;
            }
            case "btncancel": {
                if (!this.templateChangedSeq(elementList)) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u6a21\u677f\u987a\u5e8f\u5df2\u53d8\u66f4\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"MultiViewTemplateProcess_69", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("exit_save", (IFormPlugin)this));
                    break;
                }
                this.getView().close();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String key = e.getCallBackId();
        if ("exit_save".equals(key)) {
            if (MessageBoxResult.Yes == e.getResult()) {
                Area area = (Area)this.getPage(this.getView()).seaechSign(PANEL);
                List elementList = area.getElementListList();
                if (elementList.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4efb\u4f55\u6570\u636e\uff0c\u4e0d\u9700\u8981\u4fdd\u5b58\u3002", (String)"TemplateListOrderPopupPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    this.getView().close();
                    return;
                }
                this.templateSequenceOrderSave(elementList);
                this.getView().setReturnData((Object)true);
                this.getView().returnDataToParent((Object)true);
                this.getView().close();
            } else {
                this.getView().close();
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject modelDyn;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (key.equals("model") && (modelDyn = (DynamicObject)this.getModel().getValue("model")) != null) {
            this.modelChange(modelDyn.getString("id"));
        }
    }

    private DynamicObject[] filterVersionTemplate(DynamicObject[] adjustStatus) {
        HashMap stringListMap = new HashMap(adjustStatus.length);
        LinkedHashMap<String, DynamicObject> dyCollections = new LinkedHashMap<String, DynamicObject>(adjustStatus.length);
        for (DynamicObject dynamicObject : adjustStatus) {
            ArrayList<Long> ids = new ArrayList<Long>(8);
            String number = dynamicObject.getString("number");
            if (!dyCollections.containsKey(number) || ((DynamicObject)dyCollections.get(number)).getInt("versionnumber") <= dynamicObject.getInt("versionnumber")) {
                dyCollections.put(number, dynamicObject);
            }
            if (stringListMap.containsKey(number)) {
                ((List)stringListMap.get(number)).add(dynamicObject.getLong("id"));
                continue;
            }
            ids.add(dynamicObject.getLong("id"));
            stringListMap.put(number, ids);
        }
        if (!dyCollections.isEmpty()) {
            adjustStatus = dyCollections.values().toArray(new DynamicObject[0]);
        }
        if (!stringListMap.isEmpty()) {
            this.getPageCache().put(NUMBER_LIST, JSONObject.toJSONString(stringListMap));
        }
        return adjustStatus;
    }

    private void templateSequenceOrderSave(List<Element> elementList) {
        DynamicObject entity = null;
        String stringListMap = this.getPageCache().get(NUMBER_LIST);
        Map hashMap = (Map)SerializationUtils.fromJsonString((String)stringListMap, HashMap.class);
        ArrayList<DynamicObject> notVersionTemplate = new ArrayList<DynamicObject>(hashMap.size());
        HashMap<String, String> map1 = new HashMap<String, String>(elementList.size());
        for (int i = 0; i < elementList.size(); ++i) {
            entity = BusinessDataServiceHelper.newDynamicObject((String)"bcm_templateentity");
            Element obj = elementList.get(i);
            Long templateId = Long.valueOf(obj.getUserObject("template_number_id").toString());
            int sequence = i + 1;
            String number = obj.getUserObject("template_number").toString();
            map1.put(Long.toString(templateId), Integer.toString(sequence));
            if (hashMap.containsKey(number) && hashMap.get(number) instanceof List && ((List)hashMap.get(number)).size() > 1) {
                for (Long id : (List)hashMap.get(number)) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_templateentity");
                    dynamicObject.set("id", (Object)id);
                    dynamicObject.set("sequence", (Object)sequence);
                    notVersionTemplate.add(dynamicObject);
                }
                continue;
            }
            entity.set("id", (Object)templateId);
            entity.set("sequence", (Object)sequence);
            notVersionTemplate.add(entity);
        }
        OperateOption op = OperateOption.create();
        op.setVariableValue("updateModifyDate", "false");
        SaveServiceHelper.update((DynamicObject[])notVersionTemplate.toArray(new DynamicObject[notVersionTemplate.size()]), (OperateOption)op);
        List ids = notVersionTemplate.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        TemplateServiceHelper.removeTemplateModelCacheByIds((Object)this.getModelId(), (Object[])ids.toArray());
        this.getPageCache().put(map1);
    }

    private boolean templateChangedSeq(List<Element> elementList) {
        for (int i = 0; i < elementList.size(); ++i) {
            if (Long.parseLong(elementList.get(i).getUserObject("seq").toString()) == (long)(i + 1)) continue;
            return false;
        }
        return true;
    }
}

