/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.ColDimensionEntry;
import kd.fi.bcm.business.template.model.MembSettingBaseDetail;
import kd.fi.bcm.business.template.model.RowDimensionEntry;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.PositionTypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.util.DataEntityUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.formplugin.template.util.TemplateFloatUtil;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;

public class TemplateMembSetting4SpreadF7Plugin
extends AbstractTemplateBasePlugin {
    private static final String FLEX_PANEL_AP = "flexpanelap";
    private static final String NUMBER = "number";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String POSITION_TYPE = "positionType";
    private static final String ROW_TAB = "rowtab";
    private static final String COL_TAB = "coltab";

    @Override
    public void initialize() {
        super.initialize();
        this.bindCtrlMapping();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.bindCtrlMapping();
        this.buildPageViewPanel();
        this.initPageviewPanelValues();
        this.checkLock();
        SingleMemberF7Util.cacheModelPrem(this.getPageCache(), this.getTemplateModel().getModelId(), this.getApplicationType());
    }

    private void checkLock() {
        List<?> ls;
        String lock = (String)this.getFormCustomParam("lock");
        String lockDim = (String)this.getFormCustomParam("lockDim");
        if (StringUtils.isNotEmpty((String)lock)) {
            RowDimensionEntry c;
            ls = this.getDimMemberDetail();
            Object object = c = "row".equals(lock) ? new RowDimensionEntry(null) : new ColDimensionEntry(null);
            if (ls != null) {
                for (MembSettingBaseDetail m : ls) {
                    if (!m.getClass().isInstance(c)) continue;
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{this.sugarF7Key(m.getDimension().getMemberEntityNumber(), m.getDimension().getNumber())});
                }
            }
        }
        if (StringUtils.isNotEmpty((String)lockDim)) {
            ls = this.getDimMemberDetail();
            for (MembSettingBaseDetail m : ls) {
                if (!m.getDimension().getNumber().equals(lockDim)) continue;
                this.getView().setEnable(Boolean.valueOf(false), new String[]{this.sugarF7Key(m.getDimension().getMemberEntityNumber(), m.getDimension().getNumber())});
            }
        }
    }

    private void bindCtrlMapping() {
        List<?> ls = this.getDimMemberDetail();
        String infoStr = (String)this.getFormCustomParam("innerInfo");
        ArrayList<BasePointInnerLineInfo> bls = new ArrayList<BasePointInnerLineInfo>(16);
        BasePointInnerLineInfo[] innerInfos = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)infoStr)) {
            for (BasePointInnerLineInfo innerInfo : innerInfos = (BasePointInnerLineInfo[])ObjectSerialUtil.deSerializedBytes((String)infoStr)) {
                bls.add(innerInfo);
            }
        }
        if (ls != null) {
            MainEntityType mainEntityType = this.getModel().getDataEntityType();
            DataEntityPropertyCollection props = mainEntityType.getProperties();
            ls.forEach(e -> {
                String membEntityNum = e.getDimension().getMemberEntityNumber();
                String f7Key = this.sugarF7Key(membEntityNum, e.getDimension().getNumber());
                for (BasePointInnerLineInfo innerInfo : bls) {
                    if (!innerInfo.getDimension().getNumber().equals(e.getDimension().getNumber()) || innerInfo.isSeq() || innerInfo.isIshide() || innerInfo.isFloated()) continue;
                    return;
                }
                if (!props.containsKey((Object)f7Key)) {
                    DataEntityUtils.addBasedataF7ToMainEntity((Container)((Container)this.getControl(FLEX_PANEL_AP)), (MainEntityType)mainEntityType, (String)f7Key.toLowerCase(Locale.ENGLISH), (String)membEntityNum, (IDataModel)this.getModel(), (IFormView)this.getView());
                }
                BasedataEdit f7 = (BasedataEdit)this.getControl(f7Key);
                if (!"bcm_cslreportprocess".equals(this.getView().getParentView().getFormShowParameter().getFormId())) {
                    f7.getQFilters().add(new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex()));
                }
                if (membEntityNum.equals("bcm_userdefinedmembertree")) {
                    QFilter dimFilter = new QFilter("dimension.number", "=", (Object)e.getDimension().getNumber());
                    f7.getQFilters().add(dimFilter);
                }
            });
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
    }

    @Override
    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void initPageviewPanelValues() {
        List<?> ls = this.getDimMemberDetail();
        String ids = (String)this.getFormCustomParam("ids");
        if (ls != null && StringUtils.isNotEmpty((String)ids)) {
            Map dimMemberMap = (Map)ObjectSerialUtil.deSerializedBytes((String)ids);
            for (MembSettingBaseDetail m : ls) {
                String membEntityNum = m.getDimension().getMemberEntityNumber();
                String dimNumber = m.getDimension().getNumber();
                if (dimMemberMap.get(dimNumber) == null) continue;
                Long memberId = (Long)dimMemberMap.get(dimNumber);
                Long currentId = LongUtil.toLong((Object)SystemVarsEnum.CURRENT.getId());
                String number = null;
                String name = null;
                if (currentId.equals(memberId)) {
                    name = SystemVarsEnum.CURRENT.getName();
                    number = SystemVarsEnum.CURRENT.getNumber();
                } else {
                    DynamicObject dynaObj = QueryServiceHelper.queryOne((String)membEntityNum, (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)memberId), new QFilter("dimension.number", "=", (Object)dimNumber)});
                    if (dynaObj != null) {
                        name = dynaObj.getString("name");
                        number = dynaObj.getString(NUMBER);
                    }
                }
                if (name == null || number == null) continue;
                DynamicObject o = ORM.create().newDynamicObject(membEntityNum);
                o.set("id", (Object)memberId);
                o.set("name", (Object)name);
                o.set(NUMBER, (Object)number);
                this.getModel().setValue(this.sugarF7Key(m.getDimension().getMemberEntityNumber(), dimNumber), (Object)o);
            }
        }
    }

    private void buildPageViewPanel() {
        int positionType = (Integer)this.getFormCustomParam(POSITION_TYPE);
        PositionTypeEnum type = PositionTypeEnum.getPositionTypeByVal((int)positionType);
        FlexPanelAp flex = new FlexPanelAp();
        flex.setKey(FLEX_PANEL_AP);
        List<MembSettingBaseDetail> ls = this.getDimMemberDetail();
        switch (type) {
            case ONROW: {
                FieldsetPanelAp rowDimFieldPanel = this.contructTabAp(flex, ROW_TAB, ROW_TAB, true);
                this.fillDimItemField(rowDimFieldPanel, null, ls);
                break;
            }
            case ONCOL: {
                FieldsetPanelAp colDimFieldPanel = this.contructTabAp(flex, COL_TAB, COL_TAB, false);
                this.fillDimItemField(null, colDimFieldPanel, ls);
                break;
            }
            case ONCROSS: {
                FieldsetPanelAp rowDimFieldPanel = this.contructTabAp(flex, ROW_TAB, ROW_TAB, true);
                FieldsetPanelAp colDimFieldPanel = this.contructTabAp(flex, COL_TAB, COL_TAB, false);
                this.fillDimItemField(rowDimFieldPanel, colDimFieldPanel, ls);
            }
        }
        this.getView().updateControlMetadata(FLEX_PANEL_AP, flex.createControl());
    }

    private void fillDimItemField(FieldsetPanelAp rowFieldPanel, FieldsetPanelAp colFieldPanel, List<MembSettingBaseDetail> ls) {
        if (ls != null) {
            Style style = new Style();
            Margin margin = new Margin();
            margin.setTop("1px");
            margin.setBottom("15px");
            style.setMargin(margin);
            if (rowFieldPanel != null) {
                rowFieldPanel.setStyle(style);
                rowFieldPanel.setAlignItems("right");
            }
            if (colFieldPanel != null) {
                colFieldPanel.setStyle(style);
                colFieldPanel.setAlignItems("right");
            }
            Style f7Style = new Style();
            Margin f7Margin = new Margin();
            f7Margin.setLeft("20px");
            f7Margin.setTop("1px");
            f7Margin.setBottom("15px");
            f7Style.setMargin(f7Margin);
            String infoStr = (String)this.getFormCustomParam("innerInfo");
            ArrayList<BasePointInnerLineInfo> bls = new ArrayList<BasePointInnerLineInfo>(16);
            BasePointInnerLineInfo[] innerInfos = null;
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)infoStr)) {
                for (BasePointInnerLineInfo innerInfo : innerInfos = (BasePointInnerLineInfo[])ObjectSerialUtil.deSerializedBytes((String)infoStr)) {
                    bls.add(innerInfo);
                }
            }
            ls.forEach(e -> {
                for (BasePointInnerLineInfo innerInfo : bls) {
                    if (!innerInfo.getDimension().getNumber().equals(e.getDimension().getNumber()) || innerInfo.isSeq() || innerInfo.isIshide() || innerInfo.isFloated()) continue;
                    return;
                }
                EntryFieldAp f7Field = new EntryFieldAp();
                BasedataField basedata = new BasedataField();
                f7Field.setName(new LocaleString(e.getDimension().getName()));
                f7Field.setKey(this.sugarF7Key(e.getDimension().getMemberEntityNumber(), e.getDimension().getNumber()));
                f7Field.setFieldTextAlign("center");
                f7Field.setTextAlign("left");
                f7Field.setAlignSelf("center");
                f7Field.setLabelDirection("h");
                f7Field.setLabelWidth(new LocaleString("100px"));
                f7Field.setWidth(new LocaleString("250px"));
                f7Field.setStyle(f7Style);
                f7Field.setQuickAddNew(false);
                basedata.setViewDetail(false);
                basedata.setKey(e.getDimension().getMemberEntityNumber());
                basedata.setBaseEntityId(e.getDimension().getMemberEntityNumber());
                f7Field.setField((Field)basedata);
                if (e instanceof RowDimensionEntry) {
                    rowFieldPanel.getItems().add(f7Field);
                } else {
                    colFieldPanel.getItems().add(f7Field);
                }
            });
        }
    }

    private FieldsetPanelAp contructTabAp(FlexPanelAp flex, String key, String name, boolean isRowDim) {
        TabAp tabap = new TabAp();
        tabap.setKey(key);
        tabap.setName(new LocaleString(name));
        TabPageAp page = new TabPageAp();
        page.setKey(isRowDim ? "rowpage" : "colpage");
        page.setName(new LocaleString(isRowDim ? ResManager.loadKDString((String)"\u884c\u7ef4", (String)"TemplateMembSetting4SpreadF7Plugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5217\u7ef4", (String)"TemplateMembSetting4SpreadF7Plugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
        FieldsetPanelAp fieldsetpanelap = new FieldsetPanelAp();
        fieldsetpanelap.setKey(isRowDim ? "rowdimpanel" : "coldimpanel");
        page.getItems().add(fieldsetpanelap);
        tabap.getItems().add(page);
        flex.getItems().add(tabap);
        return fieldsetpanelap;
    }

    private List<?> getDimMemberDetail() {
        int positionType = (Integer)this.getFormCustomParam(POSITION_TYPE);
        String isFloat = (String)this.getFormCustomParam("isFloat");
        String areaRange = (String)this.getFormCustomParam("areaRange");
        String originalAreaRange = (String)this.getFormCustomParam("originalarearange");
        if (Boolean.parseBoolean(isFloat)) {
            String[] numbers = (String[])SerializationUtils.fromJsonString((String)((String)this.getFormCustomParam("numbers")), String[].class);
            ArrayList<MembSettingBaseDetail> ls = new ArrayList<MembSettingBaseDetail>();
            List areaRangeEntry = this.getTemplateModel().getAreaRangeEntries().stream().filter(r -> originalAreaRange.equals(r.getAreaRange())).collect(Collectors.toList());
            if (!areaRangeEntry.isEmpty()) {
                for (MembSettingBaseDetail memb : ((AreaRangeEntry)areaRangeEntry.get(0)).getColDimEntries()) {
                    if (!Arrays.asList(numbers).contains(memb.getDimension().getNumber())) continue;
                    ls.add(memb);
                }
                for (MembSettingBaseDetail memb : ((AreaRangeEntry)areaRangeEntry.get(0)).getRowDimEntries()) {
                    if (!Arrays.asList(numbers).contains(memb.getDimension().getNumber())) continue;
                    ls.add(memb);
                }
            }
            return ls;
        }
        PositionTypeEnum type = PositionTypeEnum.getPositionTypeByVal((int)positionType);
        for (AreaRangeEntry ar : this.getTemplateModel().getAreaRangeEntries()) {
            if (!ar.getAreaRange().equals(areaRange)) continue;
            switch (type) {
                case ONROW: {
                    return ar.getRowDimEntries();
                }
                case ONCOL: {
                    return ar.getColDimEntries();
                }
                case ONCROSS: {
                    ArrayList ls = new ArrayList();
                    ls.addAll(ar.getRowDimEntries());
                    ls.addAll(ar.getColDimEntries());
                    return ls;
                }
            }
        }
        return null;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String oprtId = args.getOperateKey();
        ListSelectedRowCollection coll = new ListSelectedRowCollection();
        int rowdimSize = 0;
        int coldimSize = 0;
        int notSelectRowdimCount = 0;
        int notSelectColdimCount = 0;
        boolean checkAllFill = this.getFormCustomParam("checkAllFill", false);
        if ("confirm".equals(oprtId)) {
            List<?> ls = this.getDimMemberDetail();
            boolean isRow = false;
            if (ls != null) {
                for (MembSettingBaseDetail m : ls) {
                    if (m instanceof RowDimensionEntry) {
                        ++rowdimSize;
                        isRow = true;
                    } else {
                        ++coldimSize;
                        isRow = false;
                    }
                    String f7Key = this.sugarF7Key(m.getDimension().getMemberEntityNumber(), m.getDimension().getNumber());
                    if (!this.getModel().getDataEntityType().getProperties().containsKey((Object)f7Key)) continue;
                    if (this.getModel().getValue(f7Key) == null) {
                        if (isRow) {
                            ++notSelectRowdimCount;
                            continue;
                        }
                        ++notSelectColdimCount;
                        continue;
                    }
                    ListSelectedRow row = new ListSelectedRow(this.getModel().getDataEntity().getDynamicObject(f7Key).get("id"));
                    coll.add((Object)row);
                }
                if (rowdimSize != notSelectRowdimCount && notSelectRowdimCount > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u884c\u7ef4\u5b58\u5728\u672a\u9009\u62e9\u7684\u6210\u5458\u3002", (String)"TemplateMembSetting4SpreadF7Plugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                if (coldimSize != notSelectColdimCount && notSelectColdimCount > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5217\u7ef4\u5b58\u5728\u672a\u9009\u62e9\u7684\u6210\u5458\u3002", (String)"TemplateMembSetting4SpreadF7Plugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                if (checkAllFill && notSelectRowdimCount + notSelectColdimCount > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u9009\u62e9\u7684\u6210\u5458\u3002", (String)"TemplateMembSetting4SpreadF7Plugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
            }
        }
        if (!coll.isEmpty()) {
            int positionType = (Integer)this.getFormCustomParam(POSITION_TYPE);
            if (PositionTypeEnum.ONCROSS.getValue() == positionType) {
                HashMap<String, Integer> result = new HashMap<String, Integer>();
                result.put(POSITION_TYPE, notSelectColdimCount + notSelectRowdimCount == 0 ? PositionTypeEnum.ONCROSS.getValue() : (notSelectRowdimCount == 0 ? PositionTypeEnum.ONROW.getValue() : PositionTypeEnum.ONCOL.getValue()));
                result.put("result", (Integer)coll);
                this.getView().returnDataToParent(result);
            } else {
                this.getView().returnDataToParent((Object)coll);
            }
        }
        this.getView().close();
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        String ctrlKey = e.getKey();
        if (this.checkControlKeyPrefix(this.getView(), ctrlKey) && !ctrlKey.endsWith("_id")) {
            String isFloat = (String)this.getFormCustomParam("isFloat");
            if (Boolean.parseBoolean(isFloat)) {
                BasePointInnerLineInfo[] innerInfos = (BasePointInnerLineInfo[])ObjectSerialUtil.deSerializedBytes((String)((String)this.getFormCustomParam("innerInfo")));
                BasePointInnerLineInfo info = null;
                String dimNum = this.splitUserDefineDimNumByF7key(ctrlKey);
                if (dimNum == null) {
                    dimNum = DimEntityNumEnum.getNumberByEntieyNum((String)ctrlKey);
                }
                for (BasePointInnerLineInfo basePointInnerLineInfo : innerInfos) {
                    if (!dimNum.equalsIgnoreCase(basePointInnerLineInfo.getDimension().getNumber())) continue;
                    info = basePointInnerLineInfo;
                    break;
                }
                if (info == null) {
                    return;
                }
                QFilter numberFilter = new QFilter(NUMBER, "=", (Object)info.getDimension().getNumber());
                DynamicObject dimObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_dimension", (String)"id,number,name,dseq,membermodel", (QFilter[])new QFilter[]{this.getQFilterByModelID(), numberFilter});
                QFilter filter = TemplateFloatUtil.getFilterByInnerInfo(info, this.getTemplateModel().getModelId(), dimObj.getLong("id"));
                if (filter == null) {
                    filter = new QFilter("dimension", "=", dimObj.get("id"));
                }
                BasedataEdit basedataEdit = DataEntityUtils.createF7Component((String)ctrlKey, (IDataModel)this.getModel(), (IFormView)this.getView(), (QFilter)filter, null);
                e.setControl((Control)basedataEdit);
            } else {
                String entityNum = this.getEntityNumByF7key(ctrlKey);
                String dimNum = this.splitUserDefineDimNumByF7key(ctrlKey);
                long dimId = 0L;
                List<?> ls = this.getDimMemberDetail();
                for (MembSettingBaseDetail p : ls) {
                    if (!p.getDimension().getMemberEntityNumber().equals(entityNum) || (dimNum == null || !dimNum.equalsIgnoreCase(p.getDimension().getNumber())) && dimNum != null) continue;
                    dimId = p.getDimension().getId();
                    break;
                }
                if (dimId == 0L) {
                    throw new KDBizException("not found dimension number ->" + dimNum);
                }
                BasedataEditSingleMemberF7 basedataSingleF7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getTemplateModel().getModelId(), dimId, ctrlKey, null, false);
                basedataSingleF7.setDisplayAllFyOrPeriodMemb(true);
                HashMap<String, Object> customData = new HashMap<String, Object>();
                customData.put("f7Click", "true");
                if (entityNum.equals("bcm_entitymembertree")) {
                    customData.put("disableRateCls", true);
                }
                if (dimNum == null) {
                    dimNum = DimEntityNumEnum.getNumberByEntieyNum((String)entityNum).toLowerCase(Locale.ENGLISH);
                }
                if (this.getFilterDimList().contains(dimNum)) {
                    basedataSingleF7.setSystemVariables(SystemVarsEnum.getAdjustVars());
                }
                basedataSingleF7.setCustomData(customData);
                e.setControl((Control)basedataSingleF7);
            }
        }
    }

    private List<String> getFilterDimList() {
        ArrayList<String> filterDimList = new ArrayList<String>(16);
        Object filterDimensions = this.getFormCustomParam("FilterDimensions");
        if (filterDimensions != null) {
            ((List)ObjectSerialUtil.deSerializedBytes((String)filterDimensions.toString())).forEach(dim -> filterDimList.add(dim.toLowerCase(Locale.ENGLISH)));
        }
        return filterDimList;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "bcm_entitymembertree": 
            case "bcm_accountmembertree": 
            case "bcm_fymembertree": 
            case "bcm_periodmembertree": 
            case "bcm_scenemembertree": 
            case "bcm_processmembertree": 
            case "bcm_currencymembertree": 
            case "bcm_audittrialmembertree": 
            case "bcm_changetypemembertree": 
            case "bcm_icmembertree": 
            case "bcm_rulemembertree": {
                this.propertyChangedDimUse(key, newValue);
                break;
            }
            default: {
                if (!key.startsWith("bcm_userdefinedmembertree")) break;
                this.propertyChangedDimUse(key, newValue);
            }
        }
    }
}

