/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import org.apache.commons.lang3.StringUtils;

public class TemplateOrganizationRecordInfoPlugin
extends AbstractBaseListPlugin {
    private static String ORDERBY_STR = "fyear.number desc,period.number desc";
    private static final String billlistap = "billlistap";

    @Override
    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(billlistap);
        billList.setBillFormId("bcm_reportentity");
        billList.addCreateListDataProviderListener(new CreateListDataProviderListener(){

            public void createListDataProvider(BeforeCreateListDataProviderArgs arg0) {
                TemplateOrganizationRecordInfoPlugin.this.beforeCreateListDataProvider(arg0);
            }
        });
        billList.addSetFilterListener(this::setFilter);
        billList.addPackageDataListener(this::packageData);
    }

    public void packageData(PackageDataEvent e) {
        if (ColumnDesc.class.isAssignableFrom(e.getSource().getClass())) {
            String key;
            switch (key = ((ColumnDesc)e.getSource()).getKey()) {
                case "template.versionnumber": {
                    BigDecimal versionnumber = e.getRowData().getBigDecimal("template.versionnumber");
                    e.setFormatValue((Object)(versionnumber == null ? "" : String.format("V%.1f", Float.valueOf(versionnumber.floatValue()))));
                    break;
                }
                case "entity.name": {
                    FilterOrgStructParam param = new FilterOrgStructParam(this.getModelId(), e.getRowData().getLong("scene.id"), e.getRowData().getLong("fyear.id"), e.getRowData().getLong("period.id"));
                    Map<Long, String> orgNameMap = this.filterEffectiveOrgByMergeStruct(param);
                    if (!orgNameMap.containsKey(e.getRowData().getLong("entity.id")) || !StringUtils.isNotEmpty((CharSequence)orgNameMap.get(e.getRowData().getLong("entity.id")))) break;
                    e.setFormatValue((Object)orgNameMap.get(e.getRowData().getLong("entity.id")));
                }
            }
        }
    }

    @Override
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                DynamicObjectCollection pageDatas = new DynamicObjectCollection();
                try {
                    List row = rows.stream().sorted(Comparator.comparingLong(x -> x.getLong("template.sequence")).thenComparing(x -> x.getString("template.number"))).collect(Collectors.toList());
                    List<Long> idList = row.stream().map(dy -> dy.getLong("template.id")).distinct().collect(Collectors.toList());
                    Map<Long, List<DynamicObject>> pageMap = rows.stream().collect(Collectors.groupingBy(t -> t.getLong("template.id")));
                    idList.forEach(id -> pageDatas.addAll((Collection)pageMap.get(id)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return pageDatas;
            }
        });
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Object modelId = this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        QFilter qFilter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        qFilter.and("template.id", "in", this.getView().getFormShowParameter().getCustomParam("templateId"));
        e.getQFilters().add(qFilter);
        e.setOrderBy(ORDERBY_STR);
    }

    private List<Long> getOrgChangeRecords() {
        return (List)ThreadCache.get((Object)"filterEffectiveOrgByMergeStruct", () -> {
            Object modelId = this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
            QFilter qFilter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
            qFilter.and("template.id", "in", this.getView().getFormShowParameter().getCustomParam("templateId"));
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_reportentity", (String)"entity.id", (QFilter[])qFilter.toArray());
            return doc.stream().map(m -> m.getLong("entity.id")).collect(Collectors.toList());
        });
    }

    public Map<Long, String> filterEffectiveOrgByMergeStruct(FilterOrgStructParam param) {
        return (Map)ThreadCache.get((Object)param.getUniqueKey(), () -> EntityVersioningUtil.filterEffectiveOrgByMergeStruct((FilterOrgStructParam)param, this.getOrgChangeRecords()));
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "close": {
                this.getView().close();
                break;
            }
            case "btn_refresh": {
                BillList billList = (BillList)this.getControl(billlistap);
                billList.refresh();
                break;
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Object modelId = this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        this.getModel().setValue("model", (Object)LongUtil.toLong((Object)modelId));
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"model"});
        this.refresh();
    }

    private void refresh() {
        BillList billList = (BillList)this.getControl(billlistap);
        billList.refresh();
    }
}

