/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.RedisModelCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.ColDimensionEntry;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.business.template.model.RowDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;

public class TemplateRankSettingPlugin
extends AbstractTemplateBasePlugin {
    private static final String ROW = "row";
    private static final String COL = "col";
    private static final String ROW_PANEL = "rowpanel";
    private static final String COL_PANEL = "colpanel";
    private static final String ALL_NAME = "map";
    private static final String ALL_SEQ = "seq";
    private static final String NUMBER = "number";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners("toolbarap");
        this.addClickListeners("btn_confirm", "btn_cancel");
        this.bindCtrlMapping();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadColEntry(this.template);
        this.loadRowEntry(this.template);
        this.bindCtrlMapping();
        this.getControl(ROW_PANEL).setDroppable(true);
        this.getControl(COL_PANEL).setDroppable(true);
        this.getModel().setValue("textareafield", (Object)ResManager.loadKDString((String)"\u884c\u7ef4\u6216\u5217\u7ef4\u591a\u4e8e\u4e00\u4e2a\u7ef4\u5ea6\u65f6\uff0c\u53ef\u4ee5\u901a\u8fc7\u5728Excel\u4e2d\u6309\u201c\u7ef4\u5ea6\u7b80\u78011@\u7ef4\u5ea6\u6210\u5458\u7f16\u78011,\u7ef4\u5ea6\u7b80\u78012@\u7ef4\u5ea6\u6210\u5458\u7f16\u78012,......\u201d\u683c\u5f0f\u6574\u7406\u597d\u540e\u7c98\u8d34\u5230\u76f8\u5e94\u5355\u5143\u683c\u4e2d\uff0c\u7cfb\u7edf\u4f1a\u81ea\u52a8\u8bc6\u522b\u586b\u5145\u597d\u6210\u5458\u7ec4\u5408\uff0c\u5982\uff1a\u201cA@6001.01,CT@YTD\u201d\uff0c\u8bc6\u522b\u6210\u529f\u540e\u5c06\u663e\u793a\u4e3a\u201c[\u79d1\u76ee!\u4e3b\u8425\u4e1a\u52a1\u6536\u5165|6001.01;\u53d8\u52a8\u7c7b\u578b!\u672c\u5e74\u7d2f\u8ba1|YTD]\u201d", (String)"TemplateRankSettingPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
    }

    private void bindCtrlMapping(String item) {
        String f7MapFields = this.getPageCache().get(item + "Fields");
        if (StringUtils.isEmpty((String)f7MapFields)) {
            return;
        }
        String[] fields = f7MapFields.split(";");
        MainEntityType mainEntityType = this.getModel().getDataEntityType();
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainEntityType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        for (String sign : fields) {
            this.addTextFieldToMainEntity((Container)this.getControl(item + "panel"), mainEntityType, entityMeta, sign, this.getModel(), this.getView());
            this.getModel().setValue(sign, (Object)this.getNameMap().get(sign));
            this.getControl(sign).setDraggable(true);
            this.getControl(sign).setDroppable(true);
        }
    }

    private void bindCtrlMapping() {
        this.bindCtrlMapping(ROW);
        this.bindCtrlMapping(COL);
    }

    @Override
    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        String ctrlKey = e.getKey();
        if (ctrlKey.startsWith("bcm_")) {
            TextEdit edit = new TextEdit();
            edit.setKey(ctrlKey);
            edit.setModel(this.getModel());
            edit.setView(this.getView());
            edit.setDraggable(true);
            edit.setDroppable(true);
            e.setControl((Control)edit);
        }
    }

    private void loadRowEntry(TemplateModel template) {
        List<String> row = this.getRowEntry();
        FlexPanelAp rowpanel = new FlexPanelAp();
        rowpanel.setKey(ROW_PANEL);
        if (!row.isEmpty()) {
            this.addItems(rowpanel, row);
        }
        this.updateControlMetadata(ROW_PANEL, rowpanel.createControl());
        StringBuilder sb = new StringBuilder();
        for (String string : row) {
            sb.append(string).append(';');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        this.getPageCache().put("rowFields", sb.toString());
    }

    private void loadColEntry(TemplateModel template) {
        List<String> col = this.getColEntry();
        FlexPanelAp colpanel = new FlexPanelAp();
        colpanel.setKey(COL_PANEL);
        if (!col.isEmpty()) {
            this.addItems(colpanel, col);
        }
        this.updateControlMetadata(COL_PANEL, colpanel.createControl());
        StringBuilder sb = new StringBuilder();
        for (String string : col) {
            sb.append(string).append(';');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        this.getPageCache().put("colFields", sb.toString());
    }

    private List<String> getRowEntry() {
        if (this.getPageCache().get(ROW) == null) {
            Map<String, String> map = this.getNameMap();
            Map<String, String> seq = this.getSeqMap();
            ArrayList<String> list = new ArrayList<String>();
            AreaRangeEntry ae = null;
            List<DynamicObject> rank = this.getRankDim();
            for (AreaRangeEntry area : this.getTemplateModel().getAreaRangeEntries()) {
                if (!area.getAreaRange().equals(this.getArea()) || area.getRowDimEntries().size() <= 0 && area.getColDimEntries().size() <= 0) continue;
                ae = area;
                break;
            }
            if (ae == null) {
                DynamicObject obj = rank.get(0);
                list.add("bcm_" + obj.getString(NUMBER).toLowerCase(Locale.ENGLISH));
                map.put("bcm_" + obj.getString(NUMBER).toLowerCase(Locale.ENGLISH), obj.getString("name"));
                seq.put("bcm_" + obj.getString(NUMBER).toLowerCase(Locale.ENGLISH), QueryDimensionServiceHelper.getMsgByNumber((long)this.getTemplateModel().getModelId(), (String)obj.getString(NUMBER)).getString("dseq"));
            } else {
                for (RowDimensionEntry re : ae.getRowDimEntries()) {
                    list.add("bcm_" + re.getDimension().getNumber().toLowerCase(Locale.ENGLISH));
                    map.put("bcm_" + re.getDimension().getNumber().toLowerCase(Locale.ENGLISH), re.getDimension().getName());
                    seq.put("bcm_" + re.getDimension().getNumber().toLowerCase(Locale.ENGLISH), QueryDimensionServiceHelper.getMsgByNumber((long)this.getTemplateModel().getModelId(), (String)re.getDimension().getNumber()).getString("dseq"));
                }
            }
            this.getPageCache().put(ROW, SerializationUtils.toJsonString(list));
            this.getPageCache().put(ALL_NAME, SerializationUtils.toJsonString(map));
            this.getPageCache().put(ALL_SEQ, SerializationUtils.toJsonString(seq));
        }
        List rp = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(ROW), List.class);
        return rp;
    }

    private List<String> getColEntry() {
        if (this.getPageCache().get(COL) == null) {
            Map<String, String> map = this.getNameMap();
            Map<String, String> seq = this.getSeqMap();
            ArrayList<String> list = new ArrayList<String>();
            AreaRangeEntry ae = null;
            List<DynamicObject> rank = this.getRankDim();
            for (AreaRangeEntry area : this.getTemplateModel().getAreaRangeEntries()) {
                if (!area.getAreaRange().equals(this.getArea()) || area.getRowDimEntries().size() <= 0 && area.getColDimEntries().size() <= 0) continue;
                ae = area;
                break;
            }
            if (ae == null) {
                rank.remove(0);
                for (DynamicObject obj : rank) {
                    list.add("bcm_" + obj.getString(NUMBER).toLowerCase(Locale.ENGLISH));
                    map.put("bcm_" + obj.getString(NUMBER).toLowerCase(Locale.ENGLISH), obj.getString("name"));
                    seq.put("bcm_" + obj.getString(NUMBER).toLowerCase(Locale.ENGLISH), QueryDimensionServiceHelper.getMsgByNumber((long)this.getTemplateModel().getModelId(), (String)obj.getString(NUMBER)).getString("dseq"));
                }
            } else {
                for (ColDimensionEntry re : ae.getColDimEntries()) {
                    list.add("bcm_" + re.getDimension().getNumber().toLowerCase(Locale.ENGLISH));
                    map.put("bcm_" + re.getDimension().getNumber().toLowerCase(Locale.ENGLISH), re.getDimension().getName());
                    seq.put("bcm_" + re.getDimension().getNumber().toLowerCase(Locale.ENGLISH), QueryDimensionServiceHelper.getMsgByNumber((long)this.getTemplateModel().getModelId(), (String)re.getDimension().getNumber()).getString("dseq"));
                }
            }
            this.getPageCache().put(COL, SerializationUtils.toJsonString(list));
            this.getPageCache().put(ALL_NAME, SerializationUtils.toJsonString(map));
            this.getPageCache().put(ALL_SEQ, SerializationUtils.toJsonString(seq));
        }
        List cp = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(COL), List.class);
        return cp;
    }

    private Map<String, String> getNameMap() {
        HashMap<String, String> map;
        if (this.getPageCache().get(ALL_NAME) == null) {
            map = new HashMap();
            this.getPageCache().put(ALL_NAME, SerializationUtils.toJsonString(map));
        }
        map = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(ALL_NAME), Map.class);
        return map;
    }

    private Map<String, String> getSeqMap() {
        HashMap<String, String> map;
        if (this.getPageCache().get(ALL_SEQ) == null) {
            map = new HashMap();
            this.getPageCache().put(ALL_SEQ, SerializationUtils.toJsonString(map));
        }
        map = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(ALL_SEQ), Map.class);
        return map;
    }

    private void addItems(FlexPanelAp pageviewpanel, List<String> list) {
        for (String e : list) {
            EntryFieldAp lb = new EntryFieldAp();
            lb.setName(new LocaleString(e));
            lb.setKey(e);
            TextField asd = new TextField();
            lb.setField((Field)asd);
            lb.setShowTitle(false);
            lb.setTextAlign("center");
            lb.setFieldTextAlign("center");
            lb.setLock("new,edit,view");
            pageviewpanel.getItems().add(lb);
        }
    }

    private void addTextFieldToMainEntity(Container targContainer, MainEntityType targetEntity, EntityMetadata entityMeta, String fieldKey, IDataModel model, IFormView view) {
        TextProp fieldprop = new TextProp();
        fieldprop.setName(fieldKey);
        targetEntity.addProperty((DynamicProperty)fieldprop);
        if (targContainer instanceof EntryGrid) {
            ((EntryProp)targetEntity.getProperties().get((Object)targContainer.getKey()))._collectionItemPropertyType.addProperty((DynamicProperty)fieldprop);
        }
        FieldAp field = new FieldAp();
        field.setName(new LocaleString(fieldKey));
        field.setKey(fieldKey);
        TextField textFiled = new TextField();
        textFiled.setKey(fieldKey);
        textFiled.setEntityMetadata(entityMeta);
        entityMeta.getItems().add(textFiled);
        field.setField((Field)textFiled);
        Control control = field.buildRuntimeControl();
        control.setModel(model);
        control.setView(view);
        targContainer.getItems().add(control);
    }

    public void customEvent(CustomEventArgs e) {
        String name = e.getEventName();
        if ("drop".equals(name)) {
            String eventArgs = e.getEventArgs();
            String[] msg = this.translateMessage(eventArgs);
            String target = msg[0];
            String source = msg[1];
            if (source.startsWith("bcm_")) {
                if (this.interChange(target, source)) {
                    FlexPanelAp colpanel = new FlexPanelAp();
                    colpanel.setKey(COL_PANEL);
                    FlexPanelAp rowpanel = new FlexPanelAp();
                    rowpanel.setKey(ROW_PANEL);
                    this.updateControlMetadata(COL_PANEL, colpanel.createControl());
                    this.updateControlMetadata(ROW_PANEL, rowpanel.createControl());
                    this.loadColEntry(this.template);
                    this.loadRowEntry(this.template);
                    this.bindCtrlMapping();
                    RedisModelCache cache = new RedisModelCache((IRefrencedataProvider)this.getView().getService(IDataModel.class), this.getModel().getDataEntityType(), this.getView().getPageId());
                    cache.storeAll(this.getModel().getDataEntity());
                    this.getModel().setDataChanged(true);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u884c\u7ef4\u6216\u5217\u7ef4\u81f3\u5c11\u4fdd\u75591\u4e2a\u7ef4\u5ea6\u3002", (String)"TemplateRankSettingPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                }
            }
        }
    }

    private String[] translateMessage(String text) {
        text = text.substring(1, text.length() - 1);
        String[] msg = text.split(",");
        for (int i = 0; i < msg.length; ++i) {
            msg[i] = msg[i].substring(1, msg[i].length() - 1);
        }
        return msg;
    }

    private boolean interChange(String target, String source) {
        List<String> rowlist = this.getRowEntry();
        List<String> collist = this.getColEntry();
        String sourcePanel = rowlist.contains(source) ? ROW_PANEL : COL_PANEL;
        String targetPanel = "";
        if (target.startsWith("bcm_")) {
            List<String> sorlist;
            targetPanel = rowlist.contains(target) ? ROW_PANEL : COL_PANEL;
            List<String> tarlist = targetPanel.equals(ROW_PANEL) ? rowlist : collist;
            List<String> list = sorlist = sourcePanel.equals(ROW_PANEL) ? rowlist : collist;
            if (sorlist.size() == 1) {
                return false;
            }
            int tarnum = tarlist.indexOf(target);
            int sornum = sorlist.indexOf(source);
            sorlist.remove(sornum);
            tarlist.add(tarnum, source);
        } else if (ROW_PANEL.equals(target) || COL_PANEL.equals(target)) {
            List<String> sorlist;
            targetPanel = target;
            List<String> tarlist = targetPanel.equals(ROW_PANEL) ? rowlist : collist;
            List<String> list = sorlist = sourcePanel.equals(ROW_PANEL) ? rowlist : collist;
            if (sorlist.size() == 1) {
                // empty if block
            }
            int sornum = sorlist.indexOf(source);
            sorlist.remove(sornum);
            tarlist.add(source);
        }
        this.getPageCache().put(COL, SerializationUtils.toJsonString(collist));
        this.getPageCache().put(ROW, SerializationUtils.toJsonString(rowlist));
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String objectId;
        super.afterDoOperation(eventArgs);
        switch (objectId = eventArgs.getOperateKey()) {
            case "confirm": {
                if (eventArgs.getOperationResult().isSuccess()) {
                    if (!this.getColEntry().isEmpty() && !this.getRowEntry().isEmpty()) {
                        this.handleAreaRangAndClose(true);
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u884c\u7ef4\u6216\u5217\u7ef4\u81f3\u5c11\u4fdd\u75591\u4e2a\u7ef4\u5ea6\u3002", (String)"TemplateRankSettingPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                List errorInfos = eventArgs.getOperationResult().getAllErrorOrValidateInfo();
                this.getView().showErrorNotification(((IOperateInfo)errorInfos.get(0)).getMessage());
            }
        }
    }

    private void handleAreaRangAndClose(boolean b) {
        boolean isFromChangeArea;
        String after;
        Dimension dim;
        TemplateModel model = this.getTemplateModel();
        DynamicObject temp = null;
        AreaRangeEntry areaentry = null;
        String before = this.collectRowAndColDimNum();
        boolean is = false;
        for (AreaRangeEntry area : model.getAreaRangeEntries()) {
            if (!area.getAreaRange().equals(this.getArea())) continue;
            areaentry = area;
            area.setStartPosition(this.getStartPoint());
            break;
        }
        if (areaentry == null) {
            areaentry = new AreaRangeEntry(model);
            areaentry.setAreaRange(this.getArea());
            areaentry.setStartPosition(this.getStartPoint());
            is = true;
        }
        areaentry.getRowDimEntries().clear();
        areaentry.getColDimEntries().clear();
        for (String row : this.getRowEntry()) {
            temp = QueryDimensionServiceHelper.getDimByDseq((int)Integer.parseInt(this.getSeqMap().get(row)), (String)String.valueOf(model.getModelId()));
            dim = this.convertDynaObj2Dimension(temp);
            RowDimensionEntry rowDimEntry = new RowDimensionEntry(areaentry);
            rowDimEntry.setDimension(dim);
            rowDimEntry.setSeq(Integer.parseInt(this.getSeqMap().get(row)));
            areaentry.addRowDimEntry(rowDimEntry);
        }
        for (String col : this.getColEntry()) {
            temp = QueryDimensionServiceHelper.getDimByDseq((int)Integer.parseInt(this.getSeqMap().get(col)), (String)String.valueOf(model.getModelId()));
            dim = this.convertDynaObj2Dimension(temp);
            ColDimensionEntry colDimEntry = new ColDimensionEntry(areaentry);
            colDimEntry.setDimension(dim);
            colDimEntry.setSeq(Integer.parseInt(this.getSeqMap().get(col)));
            areaentry.addColDimEntry(colDimEntry);
        }
        if (is) {
            model.getAreaRangeEntries().add(areaentry);
        }
        model.put("isChange", (Object)(!before.equals(after = this.collectRowAndColDimNum()) ? 1 : 0));
        boolean bl = isFromChangeArea = this.getFormCustomParam("isFromChangeArea") == null ? false : (Boolean)this.getFormCustomParam("isFromChangeArea");
        if (isFromChangeArea) {
            model.put("templateisModified", (Object)true);
            this.returnDataToParent(model);
            this.getView().close();
        } else if (before.equals(after)) {
            this.getView().close();
        } else if (StringUtils.isNotEmpty((String)before) && !"|".equals(before)) {
            this.cacheTemplateModel();
            this.getView().showConfirm(ResManager.loadKDString((String)"\u884c\u5217\u7ef4\u5df2\u53d1\u751f\u53d8\u52a8\uff0c\u8bf7\u786e\u8ba4\u6e05\u7a7a\u7ef4\u5ea6\u6210\u5458\u8bbe\u7f6e\u4fe1\u606f\uff1f", (String)"TemplateRankSettingPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("change_confirm", (IFormPlugin)this));
        } else {
            this.returnDataToParent(this.getTemplateModel());
            this.getView().close();
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        if ("change_confirm".equals(callBackId)) {
            if (MessageBoxResult.Yes == e.getResult()) {
                this.getTemplateModel().put("isChange", (Object)true);
                this.returnDataToParent(this.getTemplateModel());
            }
            this.getView().close();
        }
    }

    private String collectRowAndColDimNum() {
        StringBuilder sb = new StringBuilder();
        String area = this.getArea();
        this.getTemplateModel().getAreaRangeEntries().forEach(e -> {
            if (area.equals(e.getAreaRange())) {
                e.getRowDimEntries().forEach(r -> sb.append(r.getDimension().getNumber()));
                sb.append('|');
                e.getColDimEntries().forEach(c -> sb.append(c.getDimension().getNumber()));
            }
        });
        return sb.toString();
    }

    private String getArea() {
        String area = (String)this.getView().getFormShowParameter().getCustomParam("areaRange");
        return area;
    }

    private String getStartPoint() {
        String start = (String)this.getView().getFormShowParameter().getCustomParam("startPosition");
        return start;
    }

    private List<DynamicObject> getRankDim() {
        List rank = QueryDimensionServiceHelper.getrank((List)this.getTemplateModel().getRank(), (Long)this.getTemplateModel().getModelId());
        for (DynamicObject obj : rank) {
            if (!DimTypesEnum.INTERCOMPANY.getNumber().equals(obj.getString(NUMBER)) || QueryDimensionServiceHelper.checkIcEnt((long)this.getTemplateModel().getModelId())) continue;
            rank.remove(obj);
            break;
        }
        return rank;
    }

    private void updateControlMetadata(String key, Map<String, Object> ctl) {
        ArrayList<Object> paras = new ArrayList<Object>(2);
        paras.add(key);
        if (ctl.get("items") == null) {
            ctl.put("items", new Object[0]);
        }
        paras.add(ctl);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("updateControlMetadata", paras);
    }
}

