/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.template.util.TemplateSeqUtil;
import kd.fi.bcm.spread.domain.view.builder.SequenceInfo;

public class TemplateSeqAreaListPlugin
extends AbstractFormPlugin {
    public static final String SEQ_INFO_MAP = "seqinfomap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_cancel", "btn_confirm"});
    }

    public void afterCreateNewData(EventObject e) {
        List<SequenceInfo> data = (List<SequenceInfo>)ObjectSerialUtil.deSerializedBytes((String)((String)this.getView().getFormShowParameter().getCustomParam("data")));
        data = data.stream().sorted(Comparator.comparing(o -> new RangeModel(o.getSeqArea()).getY_start())).collect(Collectors.toList());
        String dataarea = (String)this.getView().getFormShowParameter().getCustomParam("dataarea");
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int index = 0;
        TemplateSeqUtil.filterCycleRefrence(data, dataarea);
        for (SequenceInfo sequenceInfo : data) {
            if (sequenceInfo.isFixValue()) continue;
            ts.set("dataarea", (Object)sequenceInfo.getDataArea(), index);
            ts.set("area", (Object)sequenceInfo.getSeqArea(), index);
            ts.set("initvalue", (Object)sequenceInfo.getInitvalue(), index);
            ts.set("fromarea", (Object)(sequenceInfo.getFromarea() == null ? null : sequenceInfo.getFromarea().getSeqArea()), index);
            ts.set("prefix", (Object)sequenceInfo.getPrefix(), index);
            ts.set("suffix", (Object)sequenceInfo.getSuffix(), index);
            map.put(index, sequenceInfo.getSeqArea());
            ++index;
        }
        this.getPageCache().put(SEQ_INFO_MAP, ObjectSerialUtil.toByteSerialized((Object)map));
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", ts);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.setPageIndex(1);
        entryGrid.clearEntryState();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"entryentity"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_confirm": {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
                if (entryGrid.getSelectRows().length > 0) {
                    Map map = (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(SEQ_INFO_MAP));
                    this.getView().returnDataToParent(map.get(entryGrid.getSelectRows()[0]));
                }
                this.getView().close();
                break;
            }
            case "btn_cancel": {
                this.getView().close();
            }
        }
    }
}

