/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.DynamicEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.SubPage;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.formplugin.template.util.TemplateFloatUtil;
import kd.fi.bcm.formplugin.template.util.TemplateSeqUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.SequenceInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import org.apache.commons.lang3.StringUtils;

public class TemplateSeqSettingPlugin
extends AbstractTemplateBasePlugin
implements BeforeF7SelectListener,
SubPage {
    private static final String ENTRYENTITY = "entryentity";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_cancel", "btn_confirm", "fromarea");
        this.addItemClickListeners("advcontoolbarap");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initSequenceInfo();
    }

    private void initSequenceInfo() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        String pssch = (String)this.getView().getFormShowParameter().getCustomParam("ps");
        PositionInfo ps = (PositionInfo)this.deSerializedBytes(pssch);
        ComboEdit comboEdit = (ComboEdit)this.getControl("dataarea");
        ArrayList items = new ArrayList(10);
        List positionInfoList = this.getSpreadModel().getAreaManager().getPostionInfoSet().stream().sorted(Comparator.comparing(o -> new RangeModel(o.getAreaRange()).getY_start())).collect(Collectors.toList());
        ArrayList<String[]> keysAndValues = new ArrayList<String[]>(10);
        int i = 1;
        int val = 1;
        for (PositionInfo e : positionInfoList) {
            String[] keysAndValue = new String[]{e.getAreaRange(), String.valueOf(i)};
            map.put(keysAndValue[1], keysAndValue[0]);
            keysAndValues.add(keysAndValue);
            if (ps.getAreaRange().equals(e.getAreaRange())) {
                val = i;
            }
            ++i;
        }
        keysAndValues.forEach(new DynamicEnum(items));
        comboEdit.setComboItems(items);
        this.getPageCache().put("dataareamap", SerializationUtils.toJsonString(map));
        this.getModel().setValue("dataarea", (Object)val);
        this.loadSequenceInfoToPage(ps.getSequenceInfo());
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar-add": {
                this.getModel().createNewEntryRow(ENTRYENTITY);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar-add"});
                this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"fromarea"});
                break;
            }
            case "bar-del": {
                if (!this.checkCanDelete()) break;
                this.getModel().deleteEntryRow(ENTRYENTITY, 0);
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"bar-add"});
            }
        }
    }

    private boolean checkCanDelete() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        if (entryGrid.getSelectRows().length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"TemplateSeqSettingPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        String dataareaKey = (String)this.getModel().getValue("dataarea");
        Map dataareamap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("dataareamap"), Map.class);
        String dataarea = (String)dataareamap.get(dataareaKey);
        for (PositionInfo positionInfo : this.getSpreadModel().getAreaManager().getPostionInfoSet()) {
            if (positionInfo.getSequenceInfo() == null || positionInfo.getSequenceInfo().getFromarea() == null || !positionInfo.getSequenceInfo().getFromarea().getDataArea().equals(dataarea)) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5\u884c\u6b21\u8303\u56f4\u5df2\u88ab\u6570\u636e\u533a\u57df%s\u7684\u884c\u6b21\u8bbe\u7f6e\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"TemplateSeqSettingPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), positionInfo.getSequenceInfo().getDataArea()));
            return false;
        }
        return true;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        String dataareaKey = (String)this.getModel().getValue("dataarea");
        Map dataareamap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("dataareamap"), Map.class);
        String dataarea = (String)dataareamap.get(dataareaKey);
        switch (key) {
            case "btn_confirm": {
                this.save(false);
                break;
            }
            case "btn_cancel": {
                this.getView().close();
                break;
            }
            case "fromarea": {
                this.openSeqAreaList(dataarea);
            }
        }
    }

    private void openSeqAreaList(String dataarea) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
        for (PositionInfo positionInfo : this.getSpreadModel().getAreaManager().getPostionInfoSet()) {
            if (positionInfo.getSequenceInfo() == null) continue;
            list.add(positionInfo.getSequenceInfo());
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bcm_template_seqarea_list");
        parameter.setCustomParam("data", (Object)this.toByteSerialized(list));
        parameter.setCustomParam("dataarea", (Object)dataarea);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "formArea");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private Pair<Boolean, String> checkSeqInfoValid(String dataarea) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (!entryEntity.isEmpty()) {
            Matcher matcher;
            String seqarea = (String)this.getModel().getValue("area");
            if (StringUtil.isEmptyString((String)(seqarea = seqarea.trim()))) {
                return Pair.onePair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u884c\u6b21\u8303\u56f4\u3002", (String)"TemplateSeqSettingPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            TemplateFloatUtil.checkCell(seqarea);
            String[] seqSplit = seqarea.split(":");
            if (seqSplit.length < 2) {
                return Pair.onePair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u884c\u6b21\u8303\u56f4\u3002", (String)"TemplateSeqSettingPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            RangeModel seqRange = new RangeModel(seqarea);
            if (seqRange.getY_start() != seqRange.getY_end() && seqRange.getX_start() != seqRange.getX_end()) {
                return Pair.onePair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u884c\u6b21\u8303\u56f4\u5fc5\u987b\u662f\u5355\u5217/\u5355\u884c\u3002", (String)"TemplateSeqSettingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            RangeModel dataRange = new RangeModel(dataarea);
            int direct = TemplateSeqUtil.getDirect(seqarea, dataarea);
            if (direct == 1) {
                if (seqRange.getX_start() != dataRange.getX_start() || seqRange.getX_end() != dataRange.getX_end()) {
                    return Pair.onePair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u884c\u6b21\u8303\u56f4\u5fc5\u987b\u4e0e\u6240\u9009\u6570\u636e\u533a\u57df\u7684\u5217\u8303\u56f4\u4e00\u81f4\u3002", (String)"TemplateSeqSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                if (seqRange.getY_start() != seqRange.getY_end()) {
                    return Pair.onePair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u884c\u6b21\u8303\u56f4\u8bbe\u7f6e\u5728\u6570\u636e\u533a\u57df\u4e0a\u4e0b\u65b9\u65f6\uff0c\u53ea\u80fd\u4e3a\u5355\u884c\u533a\u57df\u3002", (String)"TemplateSeqSettingPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            } else if (direct == 2) {
                if (seqRange.getY_start() != dataRange.getY_start() || seqRange.getY_end() != dataRange.getY_end()) {
                    return Pair.onePair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u884c\u6b21\u8303\u56f4\u5fc5\u987b\u4e0e\u6240\u9009\u6570\u636e\u533a\u57df\u7684\u884c\u8303\u56f4\u4e00\u81f4\u3002", (String)"TemplateSeqSettingPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                if (seqRange.getX_start() != seqRange.getX_end()) {
                    return Pair.onePair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u884c\u6b21\u8303\u56f4\u8bbe\u7f6e\u5728\u6570\u636e\u533a\u57df\u5de6\u53f3\u4fa7\u65f6\uff0c\u53ea\u80fd\u4e3a\u5355\u5217\u533a\u57df\u3002", (String)"TemplateSeqSettingPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            } else {
                return Pair.onePair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u884c\u6b21\u8303\u56f4\u4e0e\u6570\u636e\u533a\u57df\u91cd\u5408\u3002", (String)"TemplateSeqSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            for (PositionInfo positionInfo : this.getSpreadModel().getAreaManager().getPostionInfoSet()) {
                if (!positionInfo.getAreaRange().equals(dataarea)) continue;
                for (BasePointInfo basePoint : positionInfo.getBasePoints()) {
                    if (!ExcelUtils.isOverlap((String)basePoint.getDynaRange(), (String)seqarea)) continue;
                    return Pair.onePair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u884c\u6b21\u8303\u56f4\u4e0e\u6d6e\u52a8\u533a\u57df\u91cd\u5408\u3002", (String)"TemplateSeqSettingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
            boolean isFix = (Boolean)this.getModel().getValue("isfixedvalue");
            Boolean isrecount = (Boolean)this.getModel().getValue("isrecount");
            String fromarea = (String)this.getModel().getValue("fromarea");
            String fixValue = (String)this.getModel().getValue("fixvalue");
            if (!isrecount.booleanValue() && StringUtil.isEmptyString((String)fromarea) && !isFix) {
                return Pair.onePair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u4e0d\u91cd\u65b0\u8ba1\u6570\u65f6\uff0c\u5ef6\u7eed\u81ea\u8303\u56f4\u4e3a\u5fc5\u586b\u9879\u3002", (String)"TemplateSeqSettingPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (isFix && StringUtil.isEmptyString((String)fixValue)) {
                return Pair.onePair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u56fa\u5b9a\u503c\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u8bbe\u7f6e\u3002", (String)"TemplateSeqSettingPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (isrecount.booleanValue()) {
                if (this.getModel().getValue("initvalue") == null) {
                    return Pair.onePair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u6570\u65f6\uff0c\u8d77\u59cb\u503c\u4e3a\u5fc5\u586b\u9879\u3002", (String)"TemplateSeqSettingPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                int initvalue = (Integer)this.getModel().getValue("initvalue");
                if (initvalue < 0) {
                    return Pair.onePair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u8d77\u59cb\u503c\u5fc5\u987b\u4e3a\u975e\u8d1f\u6574\u6570\u3002", (String)"TemplateSeqSettingPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
            String regex = "^[a-zA-Z._\\-+]+$";
            Pattern pattern = Pattern.compile(regex);
            String prefix = (String)this.getModel().getValue("prefix");
            String suffix = (String)this.getModel().getValue("suffix");
            if (!StringUtil.isEmptyString((String)prefix) && !(matcher = pattern.matcher(prefix)).matches()) {
                return Pair.onePair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u524d\u7f00\u548c\u81ea\u5b9a\u4e49\u540e\u7f00\u53ea\u5141\u8bb8\u8f93\u5165\u5b57\u6bcd\u3001\u4e0b\u5212\u7ebf\u3001\u82f1\u6587\u52a0\u53f7\u3001\u82f1\u6587\u51cf\u53f7\u548c\u53e5\u53f7\u3002", (String)"TemplateSeqSettingPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (!StringUtil.isEmptyString((String)suffix) && !(matcher = pattern.matcher(suffix)).matches()) {
                return Pair.onePair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u524d\u7f00\u548c\u81ea\u5b9a\u4e49\u540e\u7f00\u53ea\u5141\u8bb8\u8f93\u5165\u5b57\u6bcd\u3001\u4e0b\u5212\u7ebf\u3001\u82f1\u6587\u52a0\u53f7\u3001\u82f1\u6587\u51cf\u53f7\u548c\u53e5\u53f7\u3002", (String)"TemplateSeqSettingPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        return Pair.onePair((Object)Boolean.TRUE, null);
    }

    private void saveSeqSetting(String dataarea) {
        if (this.isExitChange()) {
            this.getSpreadModel().getBook().getSheet(0).putUserObject("templateisModified", (Object)true);
        }
        SequenceInfo sequenceInfo = null;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        boolean isNew = false;
        Optional<PositionInfo> infoOptional = this.getSpreadModel().getAreaManager().getPostionInfoSet().stream().filter(e -> e.getAreaRange().equals(dataarea)).findAny();
        if (!entryEntity.isEmpty()) {
            String seqarea = (String)this.getModel().getValue("area");
            seqarea = seqarea.trim();
            boolean isrecount = (Boolean)this.getModel().getValue("isrecount");
            int initvalue = (Integer)this.getModel().getValue("initvalue");
            String prefix = (String)this.getModel().getValue("prefix");
            String suffix = (String)this.getModel().getValue("suffix");
            String fromareaStr = (String)this.getModel().getValue("fromarea");
            SequenceInfo fromArea = null;
            if (!StringUtil.isEmptyString((String)fromareaStr)) {
                fromArea = this.findSeqInfoByArea(fromareaStr);
            }
            int direct = TemplateSeqUtil.getDirect(seqarea, dataarea);
            if (infoOptional.isPresent() && infoOptional.get().getSequenceInfo() != null) {
                sequenceInfo = infoOptional.get().getSequenceInfo();
            } else {
                isNew = true;
                sequenceInfo = new SequenceInfo(dataarea);
            }
            sequenceInfo.initAllValue(seqarea, isrecount, initvalue, fromArea, prefix, suffix, direct, (String)this.getModel().getValue("fixvalue"));
        }
        if ((isNew || sequenceInfo == null) && infoOptional.isPresent()) {
            infoOptional.get().setSequenceInfo(sequenceInfo);
        }
        TemplateSeqUtil.updateSequenceInfo(this.getSpreadModel());
        this.cacheSpreadModel(this.getSpreadModel());
    }

    private SequenceInfo findSeqInfoByArea(String fromareaStr) {
        for (PositionInfo positionInfo : this.getSpreadModel().getAreaManager().getPostionInfoSet()) {
            if (positionInfo.getSequenceInfo() == null || !positionInfo.getSequenceInfo().getSeqArea().equals(fromareaStr)) continue;
            return positionInfo.getSequenceInfo();
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "formArea": {
                if (evt.getReturnData() == null) break;
                this.getModel().setValue("fromarea", evt.getReturnData(), 0);
            }
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
        String propName = e.getProperty().getName();
        if ("dataarea".equals(propName)) {
            this.save(true);
        } else if ("isfixedvalue".equals(propName)) {
            EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
            if (eg.getSelectRows().length == 0) {
                return;
            }
            if (e.getChangeSet()[0].getNewValue() != null && e.getChangeSet()[0].getNewValue() != e.getChangeSet()[0].getOldValue() && Boolean.parseBoolean(e.getChangeSet()[0].getNewValue().toString())) {
                String seqArea = (String)this.getModel().getValue("dataarea");
                if (StringUtils.isEmpty((CharSequence)seqArea)) {
                    return;
                }
                Map dataareamap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("dataareamap"), Map.class);
                String dataarea = (String)dataareamap.get(seqArea);
                for (PositionInfo positionInfo : this.getSpreadModel().getAreaManager().getPostionInfoSet()) {
                    if (positionInfo.getSequenceInfo() == null || positionInfo.getSequenceInfo().getFromarea() == null || !positionInfo.getSequenceInfo().getFromarea().getDataArea().equals(dataarea)) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u6570\u636e\u533a\u57df\u7684\u884c\u6b21\u8bbe\u7f6e\uff0c\u662f%2$s\u6570\u636e\u533a\u57df\u884c\u6b21\u8bbe\u7f6e\u7684\u5ef6\u7eed\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u4e3a\u56fa\u5b9a\u503c\u3002", (String)"TemplateSeqSettingPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dataarea, positionInfo.getSequenceInfo().getDataArea()));
                }
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (key.equals("dataarea")) {
            String dataareaKey = e.getChangeSet()[0].getNewValue().toString();
            Map dataareamap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("dataareamap"), Map.class);
            String dataarea = (String)dataareamap.get(dataareaKey);
            this.getModel().deleteEntryData(ENTRYENTITY);
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"bar-add"});
            for (PositionInfo ps : this.getSpreadModel().getAreaManager().getPostionInfoSet()) {
                if (!ps.getAreaRange().equals(dataarea)) continue;
                this.loadSequenceInfoToPage(ps.getSequenceInfo());
            }
        } else if (key.equals("isrecount")) {
            boolean newValue = e.getChangeSet()[0].getNewValue() != null ? (Boolean)e.getChangeSet()[0].getNewValue() : true;
            this.doRecountPageRuler(newValue);
        } else if ("isfixedvalue".equals(key) && e.getChangeSet()[0].getNewValue() != null && e.getChangeSet()[0].getNewValue() != e.getChangeSet()[0].getOldValue() && Boolean.parseBoolean(e.getChangeSet()[0].getNewValue().toString())) {
            this.getModel().setValue("isrecount", (Object)false, 0);
        }
    }

    private void loadSequenceInfoToPage(SequenceInfo seqInfo) {
        if (seqInfo != null) {
            this.getModel().createNewEntryRow(ENTRYENTITY);
            this.getModel().setValue("area", (Object)seqInfo.getSeqArea(), 0);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar-add"});
            if (seqInfo.isFixValue()) {
                this.getModel().setValue("isfixedvalue", (Object)true, 0);
                this.getModel().setValue("fixvalue", (Object)seqInfo.getFixValue(), 0);
                this.getModel().setValue("isrecount", (Object)false, 0);
                return;
            }
            this.getModel().setValue("isrecount", (Object)seqInfo.isRecount(), 0);
            this.getModel().setValue("initvalue", (Object)seqInfo.getInitvalue(), 0);
            if (seqInfo.getFromarea() != null) {
                this.getModel().setValue("fromarea", (Object)seqInfo.getFromarea().getSeqArea(), 0);
            }
            this.getModel().setValue("prefix", (Object)seqInfo.getPrefix(), 0);
            this.getModel().setValue("suffix", (Object)seqInfo.getSuffix(), 0);
            this.doRecountPageRuler(seqInfo.isRecount());
        }
    }

    private void doRecountPageRuler(boolean isRecount) {
        if (isRecount) {
            this.getModel().setValue("fromarea", null, 0);
            this.getView().setEnable(Boolean.FALSE, 0, new String[]{"fromarea"});
            this.getView().setEnable(Boolean.TRUE, 0, new String[]{"initvalue"});
        } else {
            this.getModel().setValue("initvalue", null, 0);
            this.getView().setEnable(Boolean.TRUE, 0, new String[]{"fromarea"});
            this.getView().setEnable(Boolean.FALSE, 0, new String[]{"initvalue"});
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String key = e.getCallBackId();
        if ("close_save_comfirm".equals(key)) {
            if (MessageBoxResult.Yes == e.getResult()) {
                this.save(false);
            } else {
                this.getPageCache().put("isFromSave", "true");
                this.getView().close();
            }
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        if (this.getPageCache().get("isFromSave") == null && this.isExitChange()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u754c\u9762\u6570\u636e\u5df2\u53d8\u66f4\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"TemplateEditPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("close_save_comfirm", (IFormPlugin)this));
            e.setCancel(true);
        } else {
            this.getPageCache().remove("isFromSave");
        }
    }

    private boolean isExitChange() {
        DynamicObjectCollection entryEntity;
        String dataareaKey = (String)this.getModel().getValue("dataarea");
        Map dataareamap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("dataareamap"), Map.class);
        String dataarea = (String)dataareamap.get(dataareaKey);
        Optional<PositionInfo> optional = this.getSpreadModel().getAreaManager().getPostionInfoSet().stream().filter(e -> e.getAreaRange().equals(dataarea)).findAny();
        SequenceInfo oldSequenceInfo = null;
        if (optional.isPresent()) {
            oldSequenceInfo = optional.get().getSequenceInfo();
        }
        if (!(entryEntity = this.getModel().getEntryEntity(ENTRYENTITY)).isEmpty()) {
            String suffix;
            String prefix;
            int initValue;
            if (oldSequenceInfo == null) {
                return true;
            }
            boolean isFix = (Boolean)this.getModel().getValue("isfixedvalue");
            if (isFix != oldSequenceInfo.isFixValue()) {
                return true;
            }
            boolean isrecount = (Boolean)this.getModel().getValue("isrecount");
            String seqarea = this.getStringValue("area");
            seqarea = seqarea.trim();
            if (!StringUtils.equals((CharSequence)oldSequenceInfo.getSeqArea(), (CharSequence)seqarea)) {
                return true;
            }
            if (isFix) {
                String fixValue = this.getStringValue("fixvalue").trim();
                return !fixValue.equals(oldSequenceInfo.getFixValue());
            }
            if (oldSequenceInfo.isRecount() != isrecount) {
                return true;
            }
            int n = initValue = Objects.isNull(oldSequenceInfo.getInitvalue()) ? 0 : oldSequenceInfo.getInitvalue();
            if (initValue != this.getIntValue("initvalue")) {
                return true;
            }
            if (!isrecount) {
                String fromareaStr = this.getStringValue("fromarea");
                String oldFromarea = null;
                if (oldSequenceInfo.getFromarea() != null) {
                    oldFromarea = oldSequenceInfo.getFromarea().getSeqArea();
                }
                if (!StringUtils.equals(oldFromarea, (CharSequence)fromareaStr)) {
                    return true;
                }
            }
            String string = prefix = StringUtils.isNotEmpty((CharSequence)oldSequenceInfo.getPrefix()) ? oldSequenceInfo.getPrefix() : "";
            if (!StringUtils.equals((CharSequence)prefix, (CharSequence)this.getStringValue("prefix"))) {
                return true;
            }
            String string2 = suffix = StringUtils.isNotEmpty((CharSequence)oldSequenceInfo.getSuffix()) ? oldSequenceInfo.getSuffix() : "";
            if (!StringUtils.equals((CharSequence)suffix, (CharSequence)this.getStringValue("suffix"))) {
                return true;
            }
            int direct = TemplateSeqUtil.getDirect(seqarea, oldSequenceInfo.getDataArea());
            return oldSequenceInfo.getDirect() != direct;
        }
        return !Objects.isNull(oldSequenceInfo);
    }

    private int getIntValue(String key) {
        Object value = this.getModel().getValue(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return 0;
    }

    private String getStringValue(String key) {
        Object value = this.getModel().getValue(key);
        if (Objects.isNull(value)) {
            return "";
        }
        return value.toString();
    }

    private void save(boolean isFromProChange) {
        String dataareaKey = (String)this.getModel().getValue("dataarea");
        Map dataareamap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("dataareamap"), Map.class);
        String dataarea = (String)dataareamap.get(dataareaKey);
        Pair<Boolean, String> result = this.checkSeqInfoValid(dataarea);
        if (((Boolean)result.p1).booleanValue()) {
            this.saveSeqSetting(dataarea);
            if (!isFromProChange) {
                this.getPageCache().put("isFromSave", "true");
                CommandParam com = new CommandParam("bcm_template_seqsetting", null, "changeSeq", this.getSpreadModel());
                this.sendMsg(this.getView(), com);
                this.getView().close();
            }
        } else {
            this.getView().showTipNotification((String)result.p2);
        }
    }
}

