/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template;

import java.io.IOException;
import java.util.EventObject;
import java.util.List;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.enums.TemplateSyncFormulaStatusEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.template.util.TemplateExportPlugin;
import kd.fi.bcm.formplugin.util.TemplateUtil;

public class TemplateSyncFormulasReportListPlugin
extends AbstractBaseListPlugin {
    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Object param = this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (param != null && kd.bos.util.StringUtils.isNotEmpty((String)param.toString())) {
            Long modelId = LongUtil.toLong((Object)param);
            this.getModel().setValue("model", (Object)modelId);
            this.initData();
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        DynamicObject modelDyn = (DynamicObject)this.getModel().getValue("model");
        if (modelDyn != null) {
            this.initData();
        } else {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.clearData();
            billList.clearSelection();
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(this.getQfilter());
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        DynamicObject dyna = BusinessDataReader.loadSingle((Object)list.getFocusRowPkId(), (DynamicObjectType)list.getEntityType());
        String reportdetails = dyna.getString("reportdetails");
        args.setCancel(true);
        if (ResManager.loadKDString((String)"\u524d\u540e\u7aef\u516c\u5f0f\u4e00\u81f4\uff0c\u4e0d\u9700\u8981\u540c\u6b65\u3002", (String)"TemplateListPlugin_52", (String)"fi-bcm-formplugin", (Object[])new Object[0]).equals(reportdetails)) {
            return;
        }
        try {
            TemplateExportPlugin exportor = new TemplateExportPlugin();
            String url = exportor.export(dyna);
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                this.downloadFile(url, "bcm_templatelist", "47150e89000000ac");
            }
        }
        catch (IOException e) {
            throw new KDBizException(ResManager.loadKDString((String)"IO\u5f02\u5e38", (String)"TemplateListPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("baritemap_refresh".equals(itemKey)) {
            this.refreshBillList();
        }
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.clearSelection();
        billList.getQueryFilterParameter().setFilter(this.getQfilter());
        billList.refresh();
    }

    private void initData() {
        if (!this.queryData()) {
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId()).and("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
            List list = QueryServiceHelper.queryPrimaryKeys((String)"bcm_templateentity", (String)"bcm_templateentity", (QFilter[])qFilter.toArray(), (String)"", (int)-1);
            TemplateUtil.updateSyncFormulasStatus(list, this.getModelId(), TemplateSyncFormulaStatusEnum.UNEXECUTED);
        }
        this.refreshBillList();
    }

    private boolean queryData() {
        QFilter qFilter = this.getQfilter();
        List objects = QueryServiceHelper.queryPrimaryKeys((String)"bcm_sync_formulas_report", (QFilter[])qFilter.toArray(), (String)"", (int)-1);
        return objects != null && !objects.isEmpty();
    }

    private QFilter getQfilter() {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        qFilter.and("template.templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
        return qFilter;
    }
}

