/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Button;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.template.TemplatePermCrossUtil;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.TreeBuilder;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.business.tree.report.TemplateTreeNode;
import kd.fi.bcm.business.util.TemplateRangeService;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.common.IRefreshList;
import kd.fi.bcm.formplugin.report.multi.ModelDataProvider;
import kd.fi.bcm.formplugin.tree.chk.ChkTreeBuilder;

public class TemplateTreeListPlugin
extends AbstractBaseListPlugin
implements TreeNodeClickListener,
IRefreshList {
    private static final String TREEVIEW = "treeviewap";
    private static final String billlistap = "billlistap";
    private static final String allvisibletree = "allvisibletree";
    private static final String selectnode = "selectnode";
    private static final String INITSELECTEDROWS = "initSelectedRows";
    private static final String BILLLISTUPDATE = "billlistupdate";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initLeftTree();
        this.refreshbilllist();
        this.initSelctedRows(true, false);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!ThreadCache.exists((Object)BILLLISTUPDATE)) {
            this.initSelctedRows(false, true);
        }
    }

    private void initSelctedRows(boolean setListSelect, boolean setF7Select) {
        DynamicObjectCollection entryEntity = this.getView().getParentView().getModel().getEntryEntity("reportentry");
        ArrayList<Long> ids = new ArrayList<Long>(16);
        ArrayList<String> seqNumbers = new ArrayList<String>(16);
        ArrayList<Long> seqIds = new ArrayList<Long>(16);
        for (DynamicObject object : entryEntity) {
            ids.add(object.getLong("report_number_id"));
            seqIds.add(object.getLong("report_number_id"));
            if (object.getDynamicObject("report_number") == null) continue;
            seqNumbers.add(object.getDynamicObject("report_number").getString("number"));
        }
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_templateentity", (String)"group", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        List groupIds = doc.stream().map(m -> m.getLong("group")).collect(Collectors.toList());
        DynamicObjectCollection groupRptDoc = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number,name,group,versionnumber", (QFilter[])new QFilter[]{new QFilter("group", "in", groupIds)});
        HashMap<Long, DynamicObject> id2Dys = new HashMap<Long, DynamicObject>(16);
        HashMap<String, DynamicObject> num2Dys = new HashMap<String, DynamicObject>(16);
        for (DynamicObject object : groupRptDoc) {
            id2Dys.put(object.getLong("id"), object);
        }
        TemplateUtil.filterVersionTemplateTree((Collection)groupRptDoc);
        for (DynamicObject object : groupRptDoc) {
            num2Dys.put(object.getString("number"), object);
        }
        BillList billList = (BillList)this.getView().getControl(billlistap);
        HashMap<Long, Object> id2Rows = new HashMap<Long, Object>(16);
        for (Object listSelectedRow : billList.getCurrentListAllRowCollection()) {
            id2Rows.put((Long)listSelectedRow.getPrimaryKeyValue(), listSelectedRow);
        }
        ListSelectedRowCollection ls = billList.getSelectedRows();
        ls.clear();
        for (Long id : seqIds) {
            DynamicObject verDy;
            ListSelectedRow listSelectedRow = (ListSelectedRow)id2Rows.get(id);
            if (listSelectedRow != null) {
                listSelectedRow.setSelected(true);
                ls.add((Object)listSelectedRow);
                continue;
            }
            if (id2Dys.get(id) == null || (verDy = (DynamicObject)num2Dys.get(((DynamicObject)id2Dys.get(id)).getString("number"))) == null) continue;
            ListSelectedRow selectedRow = new ListSelectedRow((Object)verDy.getLong("id"));
            selectedRow.setSelected(true);
            selectedRow.setNumber(verDy.getString("number"));
            selectedRow.setName(verDy.getString("name"));
            ls.add((Object)selectedRow);
        }
        if (setListSelect) {
            billList.putSelectedRows(ls);
        }
        this.getPageCache().put(INITSELECTEDROWS, SerializationUtils.serializeToBase64((Object)ls));
        if (setF7Select) {
            F7SelectedList fs = (F7SelectedList)this.getControl("f7selectedlistap");
            ArrayList<ValueTextItem> listValue = new ArrayList<ValueTextItem>(16);
            Map<String, ListSelectedRow> seqNum2Rows = ls.stream().collect(Collectors.toMap(k -> k.getNumber(), v -> v, (o1, o2) -> o1));
            for (String seqNumber : seqNumbers) {
                ListSelectedRow selectedRow = seqNum2Rows.get(seqNumber);
                listValue.add(new ValueTextItem(selectedRow.getPrimaryKeyValue().toString(), selectedRow.getName()));
            }
            fs.addItems(listValue);
        }
    }

    private void refreshbilllist() {
        String selectnodeId = this.getPageCache().get(selectnode);
        TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache());
        List treeNodes = treeModel.seekAllChildrenIf(selectnodeId, t -> t.isIstemplate());
        List ids = treeNodes.stream().map(m -> Long.valueOf(m.getId())).collect(Collectors.toList());
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and(this.isFromWorkPaper() ? new QFilter("templatetype", "=", (Object)(TemplateTypeEnum.MSN.getType() + "")) : new QFilter("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType()));
        filter.and(new QFilter("status", "=", (Object)"1"));
        filter.and(new QFilter("id", "in", ids));
        BillList billList = (BillList)this.getView().getControl(billlistap);
        billList.getFilterParameter().getQFilters().add(filter);
        billList.refresh();
    }

    @Override
    public void refreshList() {
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        final BillList billList = (BillList)this.getView().getControl(billlistap);
        billList.getContext().setLookup(true);
        billList.addSetFilterListener(this::setFilter);
        TreeView treeView = (TreeView)this.getControl(TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners("btnok");
        final F7SelectedList fs = (F7SelectedList)this.getControl("f7selectedlistap");
        fs.addF7SelectedListRemoveListener(e12 -> {
            billList.removeSelectRow((String)e12.getParam());
            ThreadCache.put((Object)BILLLISTUPDATE, (Object)"1");
            billList.getView().updateView();
        });
        fs.addF7SelectedListRemoveAllListener(e1 -> billList.clearSelection());
        billList.addListRowClickListener(new ListRowClickListener(){

            public void listRowClick(ListRowClickEvent evt) {
                ListSelectedRowCollection ls = TemplateTreeListPlugin.this.getAndCacheListSelectedRows(evt);
                billList.putSelectedRows(ls);
                ArrayList<ValueTextItem> listValue = new ArrayList<ValueTextItem>();
                for (ListSelectedRow selectedRow : ls) {
                    listValue.add(new ValueTextItem(selectedRow.getPrimaryKeyValue().toString(), selectedRow.getName()));
                }
                fs.addItems(listValue);
            }
        });
        billList.addListRowSelectAllListeners(event -> {
            ArrayList<ValueTextItem> listValue = new ArrayList<ValueTextItem>();
            for (ListSelectedRow selectedRow : billList.getSelectedRows()) {
                listValue.add(new ValueTextItem(selectedRow.getPrimaryKeyValue().toString(), selectedRow.getName()));
            }
            fs.addItems(listValue);
        });
        billList.addClearSelectionListener(event -> {
            ArrayList listValue = new ArrayList();
            fs.addItems(listValue);
            this.getPageCache().remove(INITSELECTEDROWS);
        });
    }

    private ListSelectedRowCollection getAndCacheListSelectedRows(ListRowClickEvent evt) {
        ListSelectedRowCollection ls = this.getPageCache().get(INITSELECTEDROWS) != null ? (ListSelectedRowCollection)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(INITSELECTEDROWS)) : new ListSelectedRowCollection();
        HashSet<Object> selectedF7Ids = new HashSet<Object>(16);
        for (ListSelectedRow l2 : ls) {
            selectedF7Ids.add(l2.getPrimaryKeyValue());
        }
        for (ListSelectedRow selectedRow : evt.getListSelectedRowCollection()) {
            if (selectedF7Ids.contains(selectedRow.getPrimaryKeyValue())) continue;
            ls.add((Object)selectedRow);
        }
        HashSet<Object> selectedListIds = new HashSet<Object>(16);
        for (ListSelectedRow l3 : evt.getListSelectedRowCollection()) {
            selectedListIds.add(l3.getPrimaryKeyValue());
        }
        ls.removeIf(l -> !selectedListIds.contains(l.getPrimaryKeyValue()));
        this.getPageCache().put(INITSELECTEDROWS, SerializationUtils.serializeToBase64((Object)ls));
        return ls;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String selectnodeId = this.getPageCache().get(selectnode);
        TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache());
        List treeNodes = treeModel.seekAllChildrenIf(selectnodeId, t -> t.isIstemplate() && t.isIsvalid());
        List ids = treeNodes.stream().map(m -> Long.valueOf(m.getId())).collect(Collectors.toList());
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and(this.isFromWorkPaper() ? new QFilter("templatetype", "=", (Object)(TemplateTypeEnum.MSN.getType() + "")) : new QFilter("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType()));
        filter.and(new QFilter("status", "=", (Object)"1"));
        filter.and(new QFilter("id", "in", ids));
        e.getQFilters().add(filter);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.getPageCache().put(selectnode, (String)evt.getNodeId());
        BillList billList = (BillList)this.getView().getControl(billlistap);
        billList.refresh();
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        if ("btnok".equals(((Button)evt.getSource()).getKey())) {
            BillList billList = (BillList)this.getView().getControl(billlistap);
            if (this.getPageCache().get(INITSELECTEDROWS) != null && !billList.getSelectedRows().isEmpty()) {
                ListSelectedRowCollection ls = (ListSelectedRowCollection)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(INITSELECTEDROWS));
                this.getView().returnDataToParent((Object)ls);
            } else {
                this.getView().returnDataToParent((Object)billList.getSelectedRows());
            }
            this.getView().close();
        }
    }

    private TreeModel<AbstractTreeNode<Object>> initLeftTree() {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("model", "=", (Object)this.getModelId()));
        qfBuilder.add(this.isFromWorkPaper() ? new QFilter("templatetype", "=", (Object)(TemplateTypeEnum.MSN.getType() + "")) : new QFilter("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType()));
        qfBuilder.add(new QFilter("status", "=", (Object)"1"));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])qfBuilder.toArray());
        long scenceId = this.getScenceId();
        ArrayList<Long> filterIDs = new ArrayList<Long>(16);
        for (DynamicObject tempDy : doc) {
            TemplateModel tempModel = ModelDataProvider.getTemplateModel(tempDy.getLong("id"));
            boolean isInner = TemplateRangeService.isInnerRange((String)"bcm_scenemembertree", (TemplateModel)tempModel, (Object)scenceId);
            if (!isInner) continue;
            filterIDs.add(tempDy.getLong("id"));
        }
        QFilter filter = new QFilter("id", "in", filterIDs);
        TemplateTreeNode root = ChkTreeBuilder.getTempTree(this.getModelId(), "1", filter, true);
        TreeBuilder.checkInvalidNode((TemplateTreeNode)root);
        root = TreeBuilder.invalidTempTreeNode((TemplateTreeNode)root);
        TreeModel treemodel = new TreeModel((ITreeNode)root);
        treemodel.cache2page(this.getPageCache());
        List lists = treemodel.seekAllChildrenIf(root.getId(), t -> !t.getChildren().isEmpty() && !((TemplateTreeNode)t).isIstemplate());
        List catalogIds = lists.stream().map(l -> Long.valueOf(l.getId())).collect(Collectors.toList());
        TreeView tree = (TreeView)this.getControl(TREEVIEW);
        TreeNode templatecatalog = new TreeNode();
        TemplatePermCrossUtil.buildTemplateTree((IPageCache)this.getPageCache(), (long)this.getModelId(), (TreeNode)templatecatalog, catalogIds);
        templatecatalog.setText(this.getRootName());
        if (StringUtils.isEmpty((String)templatecatalog.getId())) {
            return null;
        }
        tree.addNode(templatecatalog);
        tree.focusNode(templatecatalog);
        this.getPageCache().put(selectnode, templatecatalog.getId());
        return treemodel;
    }

    protected String getRootName() {
        return ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b", (String)"AbstractTemplateTreePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public long getScenceId() {
        Object scence = this.getView().getParentView().getModel().getValue("scenario");
        if (scence != null) {
            return ((DynamicObject)scence).getLong("id");
        }
        return 0L;
    }

    public boolean isFromWorkPaper() {
        return this.getView().getParentView().getFormShowParameter().getCustomParam("isFromWorkPaper") != null && "1".equals(this.getView().getParentView().getFormShowParameter().getCustomParam("isFromWorkPaper"));
    }
}

