/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template;

import java.util.EventObject;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.fi.bcm.common.enums.WeaveInfoEnum;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.spread.domain.Cell;

public class TemplateWeaveInfoPlugin
extends AbstractTemplateBasePlugin {
    private static final String WEAVE_TEXT = "weavetext";
    private static final String WEAVE_FIELD = "weavefield";
    private static final String BAR_ITEM_CLEAR = "baritemclear";
    private static final String BAR_ITEM_SAVE = "baritemsave";
    private static final String BAR_ITEM_CLOSE = "baritemclose";

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners("toolbarap");
        this.addClickListeners(BAR_ITEM_CLEAR, BAR_ITEM_SAVE, BAR_ITEM_CLOSE);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Cell cell = this.getEffectiveSheet().getCell(((Integer)this.getFormCustomParam("selectrow")).intValue(), ((Integer)this.getFormCustomParam("selectcol")).intValue());
        String formula = cell.getFormula();
        if (formula != null) {
            if (formula.startsWith(WeaveInfoEnum.UNIT.getFormlua())) {
                String ss = formula.substring(5, formula.length() - 1);
                this.getModel().setValue(WEAVE_TEXT, (Object)ss.trim());
                this.getModel().setValue(WEAVE_FIELD, (Object)WeaveInfoEnum.UNIT.getWeavefiled());
            } else if (formula.startsWith(WeaveInfoEnum.DATE.getFormlua())) {
                String ss = formula.substring(5, formula.length() - 1);
                this.getModel().setValue(WEAVE_TEXT, (Object)ss.trim());
                this.getModel().setValue(WEAVE_FIELD, (Object)WeaveInfoEnum.DATE.getWeavefiled());
            } else if (formula.startsWith(WeaveInfoEnum.CURRENCY.getFormlua())) {
                String ss = formula.substring(9, formula.length() - 1);
                this.getModel().setValue(WEAVE_TEXT, (Object)ss.trim());
                this.getModel().setValue(WEAVE_FIELD, (Object)WeaveInfoEnum.CURRENCY.getWeavefiled());
            }
        } else {
            this.getModel().setValue(WEAVE_TEXT, null);
            this.getModel().setValue(WEAVE_FIELD, (Object)"1");
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "baritemsave": {
                String weavefiled;
                Object weavetext = this.getModel().getValue(WEAVE_TEXT);
                String weaveinfo = null;
                StringBuilder sb = new StringBuilder();
                switch (weavefiled = (String)this.getModel().getValue(WEAVE_FIELD)) {
                    case "1": {
                        weaveinfo = WeaveInfoEnum.UNIT.getFormlua();
                        break;
                    }
                    case "2": {
                        weaveinfo = WeaveInfoEnum.DATE.getFormlua();
                        break;
                    }
                    case "3": {
                        weaveinfo = WeaveInfoEnum.CURRENCY.getFormlua();
                    }
                }
                sb.append(weaveinfo).append(weavetext).append(')');
                this.setFmlua(new String[]{sb.toString(), weavetext.toString()});
                break;
            }
            case "baritemclear": {
                this.setFmlua(new String[]{null, null});
                break;
            }
            case "baritemclose": {
                this.getView().close();
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "baritemsave": {
                String weavefiled;
                Object weavetext = this.getModel().getValue(WEAVE_TEXT);
                String weaveinfo = null;
                StringBuilder sb = new StringBuilder();
                switch (weavefiled = (String)this.getModel().getValue(WEAVE_FIELD)) {
                    case "1": {
                        weaveinfo = WeaveInfoEnum.UNIT.getFormlua();
                        break;
                    }
                    case "2": {
                        weaveinfo = WeaveInfoEnum.DATE.getFormlua();
                        break;
                    }
                    case "3": {
                        weaveinfo = WeaveInfoEnum.CURRENCY.getFormlua();
                    }
                }
                sb.append(weaveinfo).append(weavetext).append(')');
                this.setFmlua(new String[]{sb.toString(), weavetext.toString()});
                break;
            }
            case "baritemclear": {
                this.setFmlua(new String[]{null, null});
                break;
            }
            case "baritemclose": {
                this.getView().close();
            }
        }
    }

    private void setFmlua(String[] strings) {
        this.getView().returnDataToParent((Object)strings);
        this.getView().close();
    }
}

