/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.extdatamodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.extdata.model.DimFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtFieldEntry;
import kd.fi.bcm.business.formula.model.VFormula;
import kd.fi.bcm.business.model.formula.Formula;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.ButtonElement;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.template.model.DynaEntityObject;
import kd.fi.bcm.business.util.ResourcesLoaderUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.intergration.formula.validate.FTicket;
import kd.fi.bcm.formplugin.intergration.formula.validate.FormulaTicketer;
import kd.fi.bcm.formplugin.intergration.formula.validate.IValidate;
import kd.fi.bcm.formplugin.intergration.formula.validate.NotNullValidate;
import kd.fi.bcm.formplugin.intergration.util.ShowFormulaUtil;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.formplugin.template.util.TemplateExtendModelRefUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.datacollect.EDFormulaUtil;
import kd.fi.bcm.spread.datacollect.FormulaCheckModel;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.Expression;

public class ExtendCalLogicSettingPlugin
extends AbstractTemplateBasePlugin
implements DynamicPage {
    private static final String CODEMAPPINGMEMBER = "codemappingmember";
    private static final String CODEMAPPINGCONTROL = "codemappingcontrol";
    private static final String OPTIONALCOLSPANEL = "optionalcolspanel";
    private static final String OPENVFORMULA = "V";
    private static final String OPENEXCRATEFORMULA = "EXCRATE";
    private static final String EXTFOUMULAEDITTEXT = "extfoumulaedittext";
    private static final Map<String, String> operationCharacter = new HashMap<String, String>();

    private Map<String, DynaEntityObject> getNumberMap() {
        if (this.getPageCache().get(CODEMAPPINGMEMBER) != null) {
            return (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(CODEMAPPINGMEMBER));
        }
        return new LinkedHashMap<String, DynaEntityObject>(16);
    }

    private Map<String, String> getControlSignMap() {
        if (this.getPageCache().get(CODEMAPPINGCONTROL) != null) {
            return (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(CODEMAPPINGCONTROL));
        }
        return new HashMap<String, String>(16);
    }

    private void updateNumberCache(String type, Object obj) {
        this.getPageCache().put(type, ObjectSerialUtil.toByteSerialized((Object)obj));
    }

    @Override
    public void initialize() {
        super.initialize();
        operationCharacter.put("btn_lastyearendof", "lastYearEndOf()");
        operationCharacter.put("btn_lastyearof", "lastYearOf()");
        operationCharacter.put("btn_lastperiodof", "lastPeriodOf()");
        operationCharacter.put("btn_curryear", "currYear()");
        operationCharacter.put("btn_currperiod", "currPeriod()");
        operationCharacter.put("btn_if", "if(,,)");
        operationCharacter.put("btn_abs", "abs()");
        operationCharacter.put("btn_round", "round(,)");
        operationCharacter.put("btn_and", "and(,)");
        operationCharacter.put("btn_or", "or(,)");
        operationCharacter.put("btn_add", "+");
        operationCharacter.put("btn_subtract", "-");
        operationCharacter.put("btn_multiply", "*");
        operationCharacter.put("btn_divide", "/");
        operationCharacter.put("btn_)", ")");
        operationCharacter.put("btn_(", "(");
        operationCharacter.put("btn_gq", ">=");
        operationCharacter.put("btn_lq", "<=");
        operationCharacter.put("btn_greaterthan", ">");
        operationCharacter.put("btn_lessthan", "<");
        operationCharacter.put("btn_notequal", "<>");
        operationCharacter.put("btn_equal", "=");
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_confirm", "btn_add", "btn_subtract", "btn_multiply", "btn_divide", "btn_notequal", "btn_if", "btn_abs", "btn_round", "btn_and", "btn_or", "btn_equal", "btn_notequal", "btn_lq", "btn_gq", "btn_lessthan", "btn_greaterthan", "btn_)", "btn_(", "btn_lastyearendof", "btm_lastyearof", "btn_lastperiodof", "btn_curryear", "btn_currperiod", "btn_v", "btn_excrate");
        this.addDyClickListeners();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initExtMap();
        this.loadData();
    }

    @Override
    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_confirm": {
                this.checkFormula();
                this.getView().returnDataToParent(this.getModel().getValue(EXTFOUMULAEDITTEXT));
                this.getView().close();
                break;
            }
            case "btn_v": 
            case "btn_excrate": {
                this.openFormulaEdit(key);
                break;
            }
            default: {
                String character;
                if (((BeforeClickEvent)evt).isCancel()) {
                    return;
                }
                Map<String, String> controlSignMap = this.getControlSignMap();
                if (controlSignMap.containsKey(key)) {
                    character = controlSignMap.get(key);
                    character = EDFormulaUtil.EDC + "(\"" + character + "\")";
                } else {
                    character = operationCharacter.get(key);
                }
                FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)key, (String)EXTFOUMULAEDITTEXT, (String)character);
                ((BeforeClickEvent)evt).setCancel(true);
            }
        }
    }

    private void checkFormula() {
        String formula = (String)this.getModel().getValue(EXTFOUMULAEDITTEXT);
        if (StringUtil.isEmptyString((String)formula)) {
            return;
        }
        String message = "";
        try {
            Expression parse = ExcelFormulaPaserHelper.parse((String)formula);
            if (ExcelFormulaPaserHelper.isHavSpecialExpr((Expression)parse)) {
                message = ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u533a\u57df\u4e2d\u516c\u5f0f\u8bbe\u7f6e\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u5f15\u7528\u5355\u5143\u683c\u3002", (String)"ExtendCalLogicSettingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
        }
        catch (Exception e2) {
            throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u9519\u8bef\u3002", (String)"MultiViewTemplateProcess_41", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        List noDataCols = new FormulaCheckModel().getNoDataCols(formula, this.getCols());
        if (!noDataCols.isEmpty()) {
            Map<String, DynaEntityObject> numberMap = this.getNumberMap();
            HashMap<String, String> map = new HashMap<String, String>(noDataCols.size());
            numberMap.forEach((e, v) -> {
                if (noDataCols.contains(e)) {
                    String name = "";
                    if (v instanceof ExtFieldEntry) {
                        name = ((ExtFieldEntry)v).getExtField().getName();
                        map.put((String)e, name);
                    }
                }
            });
            message = String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u4e2d\u5b58\u5728\u65e0\u6548\u7684\u62d3\u5c55\u5b57\u6bb5\u201c%s\u201d\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4fdd\u5b58\u3002", (String)"ExtendCalLogicSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), TemplateExtendModelRefUtil.showNumberAndNameFromMap(map, noDataCols));
        }
        if (StringUtils.isNotEmpty((String)message)) {
            throw new KDBizException(message);
        }
    }

    private void addDyClickListeners() {
        Map<String, String> controlSignMap = this.getControlSignMap();
        if (controlSignMap.isEmpty()) {
            return;
        }
        controlSignMap.entrySet().forEach(entry -> this.addClickListeners(((String)entry.getKey()).toLowerCase()));
    }

    private void openFormulaEdit(String key) {
        FormShowParameter para = new FormShowParameter();
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCustomParam("KEY_MODEL_ID", this.getFormCustomParam("KEY_MODEL_ID"));
        this.getPageCache().put("KEY_MODEL_ID", this.getFormCustomParam("KEY_MODEL_ID").toString());
        String actionId = "";
        if ("btn_v".equals(key)) {
            actionId = OPENVFORMULA;
            para.setFormId("bcm_vformula");
            List list = (List)this.getFormCustomParam("mustinput");
            FormulaTicketer ticketer = this.buildTicketer(list);
            para.setCustomParam("FormulaTicketer", (Object)this.toByteSerialized(ticketer));
            para.setCustomParam("formulanumber", (Object)VFormula.getVName().toLowerCase(Locale.ENGLISH));
            para.setCustomParam("displayProp", (Object)"name");
        }
        if ("btn_excrate".equals(key)) {
            actionId = OPENEXCRATEFORMULA;
            Formula formula = ResourcesLoaderUtil.getFormulaByNumber((String)"excrate");
            ShowFormulaUtil.selectGuidePage(formula, para, (Long)this.getFormCustomParam("KEY_MODEL_ID"));
        }
        int cursorIndex = FormulaEditHelper.getCursorIndex((IFormView)this.getView(), (String)key, (String)EXTFOUMULAEDITTEXT);
        this.getPageCache().put("selectindex", Integer.toString(cursorIndex));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    private FormulaTicketer buildTicketer(List<String> list) {
        FormulaTicketer ticketer = new FormulaTicketer();
        IValidate notnull = (IValidate)IValidate.build(NotNullValidate.class);
        DynamicObjectCollection alldims = QueryDimensionServiceHelper.getDimensionBaseInfos((Object)this.getModelId());
        for (DynamicObject obj : alldims) {
            String sign;
            String entity = obj.getString("membermodel");
            String number = obj.getString("number");
            String name = obj.getString("name");
            if (list.contains(number)) {
                sign = entity;
                if ("bcm_userdefinedmembertree".equals(entity)) {
                    sign = this.sugarF7Key(entity, number);
                }
                ticketer.addTicket(sign, new FTicket(entity, name, notnull, true, true, true, false));
                continue;
            }
            if ("bcm_userdefinedmembertree".equals(entity)) {
                sign = this.sugarF7Key(entity, number);
                ticketer.addTicket(sign, new FTicket(entity, name, null, true, true, false, false));
                continue;
            }
            ticketer.addTicket(entity, new FTicket(entity, name, null, true, true, false, false));
        }
        return ticketer;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ((OPENVFORMULA.equals(actionId) || OPENEXCRATEFORMULA.equals(actionId)) && evt.getReturnData() != null) {
            if (this.getPageCache().get("selectindex") != null) {
                int cursorIndex = Integer.parseInt(this.getPageCache().get("selectindex"));
                this.getModel().setValue(EXTFOUMULAEDITTEXT, (Object)FormulaEditHelper.insertCharacter((String)((String)this.getModel().getValue(EXTFOUMULAEDITTEXT)), (String)evt.getReturnData().toString(), (int)cursorIndex));
                this.getPageCache().remove("selectindex");
            } else {
                FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)actionId, (String)EXTFOUMULAEDITTEXT, (String)evt.getReturnData().toString());
            }
        }
    }

    private void loadData() {
        Page page = this.getPage(this.getView());
        page = page == null ? new Page() : page;
        Area optionalcolsArea = new Area(OPTIONALCOLSPANEL);
        Map<String, String> controlSignMap = this.getControlSignMap();
        List<String> cols = this.getCols();
        if (cols != null && !cols.isEmpty()) {
            cols.forEach(colNumber -> {
                String s = colNumber.toLowerCase();
                optionalcolsArea.addElement((Element)this.fillValueElememt((String)colNumber, s));
                if (!controlSignMap.containsKey(s)) {
                    controlSignMap.put(s, (String)colNumber);
                }
            });
            if (!controlSignMap.isEmpty()) {
                this.updateNumberCache(CODEMAPPINGCONTROL, controlSignMap);
            }
        }
        page.addArea(optionalcolsArea);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        optionalcolsArea.getElementListList().forEach(element -> this.getModel().setValue(element.getSign(), (Object)element.getName()));
        if (this.getFormCustomParam("formula") != null) {
            this.getModel().setValue(EXTFOUMULAEDITTEXT, this.getFormCustomParam("formula"));
        }
    }

    private ButtonElement fillValueElememt(String number, String sign) {
        Map<String, DynaEntityObject> map = this.getNumberMap();
        DynaEntityObject value = map.get(number);
        String name = "";
        if (value instanceof DimFieldEntry) {
            name = ((DimFieldEntry)value).getDimension().getName();
        } else if (value instanceof ExtFieldEntry) {
            name = ((ExtFieldEntry)value).getExtField().getName();
        }
        ButtonElement element = new ButtonElement(sign, name);
        element.setShowLabel(false);
        element.setTextAlign("center");
        element.setFieldTextAlign("center");
        return element;
    }

    private List<String> getCols() {
        if (this.getFormCustomParam("cols") == null) {
            return new ArrayList<String>(16);
        }
        return (List)SerializationUtils.deSerializeFromBase64((String)((String)this.getFormCustomParam("cols")));
    }

    private void initExtMap() {
        if (this.getFormCustomParam("extfieldmap") == null) {
            return;
        }
        this.updateNumberCache(CODEMAPPINGMEMBER, SerializationUtils.deSerializeFromBase64((String)((String)this.getFormCustomParam("extfieldmap"))));
    }
}

