/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.extdatamodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.bcm.business.extdata.model.ExtField;
import kd.fi.bcm.business.extdata.model.ExtFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.template.model.DynaEntityObject;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.CalculateInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.ExtendInfo;

public class ExtendDataAreaCalSettingPlugin
extends AbstractTemplateBasePlugin {
    private static final String NUMBER = "number";
    private static final String DATACOL = "datacol";
    private static final String CALLOGICSETTING = "callogicsetting";
    private static final String ENTRYENTITY = "entryentity";
    private static final String OPTIONALCOLS = "optionalcols";
    private static final String ALLCOLS = "allcols";
    private static final String CODEMAPPINGMEMBER = "codemappingmember";

    private Map<String, DynaEntityObject> getNumberMap() {
        if (this.getPageCache().get(CODEMAPPINGMEMBER) != null) {
            return (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(CODEMAPPINGMEMBER));
        }
        return new LinkedHashMap<String, DynaEntityObject>(16);
    }

    private void updateNumberCache(String type, Object obj) {
        this.getPageCache().put(type, ObjectSerialUtil.toByteSerialized((Object)obj));
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn-confirm", CALLOGICSETTING);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getPositionInfo() == null || this.getExtendsModel() == null) {
            return;
        }
        this.loadData();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object newValue = this.getModel().getValue(key);
        if (CALLOGICSETTING.equals(key) && (newValue == null || newValue.equals(""))) {
            EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, eg.getSelectRows()[0]);
            this.getPageCache().remove(entryRowEntity.getString(NUMBER));
            return;
        }
    }

    private void loadData() {
        ExtendInfo extendInfo;
        PositionInfo positionInfo = this.getPositionInfo();
        if (positionInfo != null && (extendInfo = positionInfo.getExtendInfo()) != null) {
            List<String> cols = extendInfo.getCols(false);
            if (cols.isEmpty()) {
                return;
            }
            cols = this.getFilterCol(cols);
            List calculateInfos = extendInfo.getCalculateInfos();
            HashMap formulaMap = new HashMap(16);
            if (calculateInfos != null && !calculateInfos.isEmpty()) {
                calculateInfos.forEach(calculateInfo -> formulaMap.put(calculateInfo.getCalcol(), calculateInfo.getFormula()));
            }
            this.getView().getModel().batchCreateNewEntryRow(ENTRYENTITY, cols.size());
            Map<String, DynaEntityObject> map = this.getNumberMap();
            for (int i = 0; i < cols.size(); ++i) {
                String number = cols.get(i);
                DynaEntityObject dynaEntityObject = map.get(number);
                if (!(dynaEntityObject instanceof ExtFieldEntry)) continue;
                ExtField extField = ((ExtFieldEntry)dynaEntityObject).getExtField();
                String name = extField.getName();
                this.getModel().setValue(NUMBER, (Object)number, i);
                this.getModel().setValue(DATACOL, (Object)name, i);
                String formula = "";
                if (!formulaMap.isEmpty() && formulaMap.containsKey(number)) {
                    formula = (String)formulaMap.get(number);
                    this.getPageCache().put(number, formula);
                }
                this.getModel().setValue(CALLOGICSETTING, (Object)formula, i);
            }
            this.getView().updateView(ENTRYENTITY);
        }
    }

    private List<String> getFilterCol(List<String> cols) {
        if (cols == null && this.getPageCache().get(ALLCOLS) != null) {
            return (List)SerializationUtils.fromJsonString((String)Optional.ofNullable(this.getPageCache().get(ALLCOLS)).orElse("[]"), List.class);
        }
        if (this.getPageCache().get(OPTIONALCOLS) != null) {
            return (List)SerializationUtils.fromJsonString((String)Optional.ofNullable(this.getPageCache().get(OPTIONALCOLS)).orElse("[]"), List.class);
        }
        if (cols == null) {
            return new ArrayList<String>(16);
        }
        ArrayList<String> showCol = new ArrayList<String>(cols.size());
        ArrayList allCols = new ArrayList(cols.size());
        Map<String, DynaEntityObject> map = this.getNumberMap();
        if (cols != null && !cols.isEmpty()) {
            cols.forEach(number -> {
                ExtField extField;
                DynaEntityObject dynaEntityObject = (DynaEntityObject)map.get(number);
                if (dynaEntityObject instanceof ExtFieldEntry && (extField = ((ExtFieldEntry)dynaEntityObject).getExtField()).getMapped().contains("numext")) {
                    allCols.add(number);
                    if (!extField.getDataType().equals(DataTypeEnum.ENUMTP.index)) {
                        showCol.add((String)number);
                    }
                }
            });
            this.getPageCache().put(OPTIONALCOLS, SerializationUtils.toJsonString(showCol));
            this.getPageCache().put(ALLCOLS, SerializationUtils.toJsonString(allCols));
        }
        return showCol;
    }

    private PositionInfo getPositionInfo() {
        if (this.getFormCustomParam("ps") == null) {
            return null;
        }
        PositionInfo positionInfo = (PositionInfo)this.deSerializedBytes((String)this.getFormCustomParam("ps"));
        return positionInfo;
    }

    private ExtendsModel getExtendsModel() {
        if (this.getFormCustomParam("extenddatamodel") == null) {
            return null;
        }
        Long extId = (Long)this.getFormCustomParam("extenddatamodel");
        ExtendsModel extendsModel = new ExtendsModel().getExtendsModel(extId);
        List dimFieldEntryList = extendsModel.getDimFieldEntry();
        Map<String, DynaEntityObject> map = this.getNumberMap();
        dimFieldEntryList.forEach(dimFieldEntry -> {
            String number = dimFieldEntry.getDimension().getNumber();
            if (!map.containsKey(number)) {
                map.put(number, (DynaEntityObject)dimFieldEntry);
            }
        });
        List extFieldEntrys = extendsModel.getExtFieldEntry();
        extFieldEntrys.forEach(extFieldEntry -> {
            String number = extFieldEntry.getExtField().getNumber();
            if (!map.containsKey(number)) {
                map.put(number, (DynaEntityObject)extFieldEntry);
            }
        });
        if (!map.isEmpty()) {
            this.updateNumberCache(CODEMAPPINGMEMBER, map);
        }
        return extendsModel;
    }

    @Override
    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "callogicsetting": {
                this.openForm();
                break;
            }
            case "btn-confirm": {
                this.saveData();
                break;
            }
        }
    }

    private void saveData() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (entryEntity.isEmpty()) {
            return;
        }
        ArrayList calculateInfos = new ArrayList(entryEntity.size());
        entryEntity.forEach(dyo -> {
            if (dyo.getString(CALLOGICSETTING) != "") {
                calculateInfos.add(new CalculateInfo(dyo.getString(NUMBER), dyo.getString(CALLOGICSETTING)));
            }
        });
        PositionInfo positionInfo = this.getPositionInfo();
        if (positionInfo != null && positionInfo.getExtendInfo() != null) {
            positionInfo.getExtendInfo().setCalculateInfos(calculateInfos);
            this.getView().returnDataToParent((Object)positionInfo);
        }
        this.getView().close();
    }

    private void openForm() {
        EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, eg.getSelectRows()[0]);
        FormShowParameter para = new FormShowParameter();
        para.setFormId("bcm_extarea_caldetails");
        para.getOpenStyle().setShowType(ShowType.Modal);
        this.getPageCache().put("KEY_MODEL_ID", this.getFormCustomParam("KEY_MODEL_ID").toString());
        List<String> filterCol = this.getFilterCol(null);
        if (filterCol != null) {
            filterCol.remove(entryRowEntity.getString(NUMBER));
            para.setCustomParam("cols", (Object)SerializationUtils.serializeToBase64(filterCol));
        }
        para.setCustomParam("extfieldmap", (Object)SerializationUtils.serializeToBase64(this.getNumberMap()));
        para.setCustomParam("formula", (Object)entryRowEntity.getString(CALLOGICSETTING));
        para.setCustomParam("mustinput", this.getFormCustomParam("mustinput"));
        para.setCustomParam("KEY_MODEL_ID", this.getFormCustomParam("KEY_MODEL_ID"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLOGICSETTING);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (CALLOGICSETTING.equals(actionId) && (returnData = evt.getReturnData()) != null) {
            EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, eg.getSelectRows()[0]);
            this.getModel().setValue(CALLOGICSETTING, (Object)returnData.toString(), eg.getSelectRows()[0]);
            this.getPageCache().put(entryRowEntity.getString(NUMBER), returnData.toString());
        }
    }
}

