/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.extdatamodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;

public class ExtendDataAreaOtherShowSettingPlugin
extends AbstractTemplateBasePlugin {
    private static final String TEXTFIELD = "textfield";
    private static final String CUSTOMNAME = "customname";
    private static final String NUMBER = "number";
    private static final String BTN_CONFIRM = "btn-confirm";
    private static final String ENTRYENTITY = "entryentity";

    private List<String> getFormParamList(String key) {
        if (this.getFormCustomParam(key) == null) {
            return new ArrayList<String>(16);
        }
        return (List)ObjectSerialUtil.deSerializedBytes((String)((String)this.getFormCustomParam(key)));
    }

    private Map<String, String> getFormParamMap(String key) {
        if (this.getFormCustomParam(key) != null) {
            return (Map)ObjectSerialUtil.deSerializedBytes((String)((String)this.getFormCustomParam(key)));
        }
        return new HashMap<String, String>();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_CONFIRM);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
    }

    private void initData() {
        List<String> cols = this.getFormParamList("cols");
        Map<String, String> map = this.getFormParamMap("colnumbertoname");
        Map<String, String> cusMap = this.getFormParamMap("customcolname");
        if (!cols.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, cols.size());
            for (int i = 0; i < cols.size(); ++i) {
                String colNumber = cols.get(i);
                this.getModel().setValue(NUMBER, (Object)colNumber, i);
                this.getModel().setValue(TEXTFIELD, (Object)map.get(colNumber), i);
                String name = cusMap.get(colNumber);
                if (name == null) continue;
                this.getModel().setValue(CUSTOMNAME, (Object)name, i);
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_CONFIRM.equals(key)) {
            this.saveData();
        }
    }

    private void saveData() {
        LinkedHashMap map = new LinkedHashMap(16);
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
        if (!dynamicObjects.isEmpty() && dynamicObjects.stream().anyMatch(dyo -> dyo.get(CUSTOMNAME) != null && StringUtils.isNotEmpty((String)dyo.get(CUSTOMNAME).toString()))) {
            List<String> formParamList = this.getFormParamList("mustinputfields");
            dynamicObjects.forEach(dyo -> {
                if (dyo.get(CUSTOMNAME) != null && StringUtils.isNotEmpty((String)dyo.get(CUSTOMNAME).toString())) {
                    map.put(dyo.getString(NUMBER), dyo.get(CUSTOMNAME).toString());
                } else if (formParamList.contains(dyo.getString(NUMBER))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5fc5\u5f55\u5b57\u6bb5\u6216\u552f\u4e00\u6027\u6821\u9a8c\u5b57\u6bb5\u201c%s\u201d\u5fc5\u9700\u8bbe\u7f6e\u663e\u793a\u503c\u3002", (String)"ExtendDataAreaOtherShowSettingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dyo.getString(NUMBER)));
                }
            });
        }
        this.getView().returnDataToParent(map);
        this.getView().close();
    }
}

