/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.extdatamodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.extdata.model.DimFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtField;
import kd.fi.bcm.business.extdata.model.ExtFieldEntry;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.business.template.model.DynaEntityObject;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.formplugin.template.util.TemplateExtendModelRefUtil;
import kd.fi.bcm.formplugin.util.FormShowParameterUtil;

public class ExtendDataAreaTopSettingPlugin
extends AbstractTemplateBasePlugin {
    private static final String TOPFIELDS = "topfields";
    private static final String OTHERSETTING = "othersetting";
    private static final String TOPCOUNT = "topcount";
    private static final String BTN_CONFIRM = "btn-confirm";

    private Map<String, DynaEntityObject> getNumberMap() {
        if (this.getFormCustomParam("extfieldmap") != null) {
            return (Map)ObjectSerialUtil.deSerializedBytes((String)((String)this.getFormCustomParam("extfieldmap")));
        }
        return new LinkedHashMap<String, DynaEntityObject>(16);
    }

    private List<String> getCols() {
        if (this.getFormCustomParam("cols") == null) {
            return new ArrayList<String>(16);
        }
        return (List)ObjectSerialUtil.deSerializedBytes((String)((String)this.getFormCustomParam("cols")));
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_CONFIRM, OTHERSETTING);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(TOPFIELDS);
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        Long modelId = (Long)this.getFormCustomParam("modelid");
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("enable", "=", (Object)TemplateModel.TplStatus.ENABLE.getStatuValue());
        qFilter.and("number", "in", TemplateExtendModelRefUtil.getCurDataCols(this.getNumberMap(), this.getCols(), true));
        qFilter.and("parent.number", "=", (Object)this.getFormCustomParam("ExtendsGroupNumber", ""));
        beforeF7SelectEvent.getCustomQFilters().add(qFilter);
    }

    private Map<String, String> getColNumberToName() {
        HashMap<String, String> numberToNameMap = new HashMap<String, String>();
        Map<String, DynaEntityObject> map = this.getNumberMap();
        map.forEach((k, v) -> {
            if (v instanceof ExtFieldEntry) {
                ExtField extField = ((ExtFieldEntry)v).getExtField();
                numberToNameMap.put(extField.getNumber(), extField.getName());
            } else if (v instanceof DimFieldEntry) {
                Dimension dimension = ((DimFieldEntry)v).getDimension();
                numberToNameMap.put(dimension.getNumber(), dimension.getName());
            }
        });
        return numberToNameMap;
    }

    private List<String> getMustInputField() {
        ArrayList<String> mustInputFields = new ArrayList<String>(16);
        this.getNumberMap().forEach((k, v) -> {
            ExtFieldEntry extFieldEntry;
            if (v instanceof DimFieldEntry) {
                DimFieldEntry dimFieldEntry = (DimFieldEntry)v;
                if (dimFieldEntry.getIsNecessary() || dimFieldEntry.getUniqueCheck()) {
                    mustInputFields.add(dimFieldEntry.getDimension().getNumber());
                }
            } else if (v instanceof ExtFieldEntry && ((extFieldEntry = (ExtFieldEntry)v).getIsNecessary() || extFieldEntry.getUniqueCheck())) {
                mustInputFields.add(extFieldEntry.getExtField().getNumber());
            }
        });
        return mustInputFields;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{OTHERSETTING});
    }

    private void initData() {
        if (this.getFormCustomParam("exttopsetting") != null) {
            Tuple topSetting = (Tuple)ObjectSerialUtil.deSerializedBytes((String)((String)this.getFormCustomParam("exttopsetting")));
            String topNum = (String)topSetting.p1;
            DynaEntityObject dynaEntityObject = this.getNumberMap().get(topNum);
            if (dynaEntityObject instanceof ExtFieldEntry) {
                this.getModel().setValue(TOPFIELDS, (Object)((ExtFieldEntry)dynaEntityObject).getExtField().getId());
            }
            this.getModel().setValue(TOPCOUNT, topSetting.p2);
            this.dealOtherTotalSetting((Map)topSetting.p3);
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "othersetting": {
                this.openOtherTotalSetting();
                break;
            }
            case "btn-confirm": {
                this.saveData();
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (OTHERSETTING.equals(key) && (e.getChangeSet()[0].getNewValue() == null || e.getChangeSet()[0].getNewValue().equals(""))) {
            this.getPageCache().remove("customcolname");
        }
    }

    private void openOtherTotalSetting() {
        if (this.getModel().getValue(TOPFIELDS) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6eTop\u5b57\u6bb5\u540e\u518d\u64cd\u4f5c\u3002", (String)"ExtendDataAreaTopSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List<String> noDataCols = TemplateExtendModelRefUtil.getCurDataCols(this.getNumberMap(), this.getCols(), false);
        if (noDataCols.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u975e\u6570\u636e\u7c7b\u5b57\u6bb5\uff0c\u4e0d\u9700\u8981\u8bbe\u7f6e\u3002", (String)"ExtendDataAreaTopSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("cols", ObjectSerialUtil.toByteSerialized(noDataCols));
        map.put("colnumbertoname", ObjectSerialUtil.toByteSerialized(this.getColNumberToName()));
        map.put("mustinputfields", ObjectSerialUtil.toByteSerialized(this.getMustInputField()));
        map.put("customcolname", this.getPageCache().get("customcolname"));
        this.getView().showForm(FormShowParameterUtil.getFormShowParameter("bcm_extarea_othertotal", ShowType.Modal, "", new CloseCallBack((IFormPlugin)this, OTHERSETTING), "", map));
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (OTHERSETTING.equals(actionId) && (returnData = evt.getReturnData()) != null) {
            this.dealOtherTotalSetting((Map)returnData);
        }
    }

    private void dealOtherTotalSetting(Map<String, String> map) {
        if (map.isEmpty()) {
            this.getModel().setValue(OTHERSETTING, null);
            this.getPageCache().remove("customcolname");
            return;
        }
        this.getModel().setValue(OTHERSETTING, (Object)map.toString());
        this.getPageCache().put("customcolname", ObjectSerialUtil.toByteSerialized(map));
    }

    private void saveData() {
        DynamicObject dyo = (DynamicObject)this.getModel().getValue(TOPFIELDS);
        if (dyo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"top\u8bbe\u7f6e\u4e2dtop\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExtendDataAreaTopSettingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, String> cusMap = new HashMap<String, String>(16);
        if (this.getPageCache().get("customcolname") != null) {
            cusMap = (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("customcolname"));
        }
        TemplateExtendModelRefUtil.checkOtherShowSetting(this.getNumberMap(), this.getCols(), cusMap);
        this.getView().returnDataToParent((Object)Tuple.create((Object)dyo.getString("number"), (Object)Integer.parseInt(this.getModel().getValue(TOPCOUNT).toString()), cusMap));
        this.getView().close();
    }
}

