/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.extdatamodel;

import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.enums.ExtendDimGroupType;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.formplugin.template.ICommunicateBtwForm;
import kd.fi.bcm.formplugin.template.util.TemplateExtendModelRefUtil;
import org.apache.commons.collections.CollectionUtils;

public class ExtendDataModelSelectionPlugin
extends AbstractTemplateBasePlugin {
    private static final String EXTDATAMODEL = "extdatamodel";
    private static final String KEY_INVFA_CONSOL = "INTR_CONSOL";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn-confirm");
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(EXTDATAMODEL);
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        Long modelId = (Long)this.getFormCustomParam("KEY_MODEL_ID");
        String number = (String)this.getFormCustomParam("templatenumber");
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("enable", "=", (Object)TemplateModel.TplStatus.ENABLE.getStatuValue());
        qFilter.and("number", "!=", (Object)KEY_INVFA_CONSOL);
        qFilter.and("extendsgroup.grouptype", "in", (Object)Lists.newArrayList((Object[])new String[]{ExtendDimGroupType.UNKNOWN.getIndex(), ExtendDimGroupType.COMMON.getIndex(), ExtendDimGroupType.TRANSACTION.getIndex()}));
        if (this.getFormCustomParam("isweavetemplate") != null && ((Boolean)this.getFormCustomParam("isweavetemplate")).booleanValue()) {
            HashSet<Long> usedExtDataModelIdSet = new HashSet<Long>(16);
            usedExtDataModelIdSet.addAll(TemplateExtendModelRefUtil.getIntrExtDataModelRef(modelId).values());
            usedExtDataModelIdSet.addAll(TemplateExtendModelRefUtil.getExtModelRef(modelId, number).values());
            if (CollectionUtils.isNotEmpty(usedExtDataModelIdSet)) {
                qFilter.and("id", "not in", usedExtDataModelIdSet);
            }
        }
        beforeF7SelectEvent.getCustomQFilters().add(qFilter);
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btn-confirm".equals(key)) {
            if (this.getModel().getValue(EXTDATAMODEL) != null) {
                this.sendMsg2Parent();
                IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
                String success = pageCache.get("areasetting");
                if (success != null && "true".equals(success)) {
                    this.getView().close();
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u62d3\u5c55\u6570\u636e\u6a21\u578b\u201d\u3002", (String)"ExtendDataModelSelectionPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getFormCustomParam(EXTDATAMODEL) != null) {
            this.getModel().setValue(EXTDATAMODEL, this.getFormCustomParam(EXTDATAMODEL));
        }
    }

    private void sendMsg2Parent() {
        IFormView pv = this.getView().getParentView();
        if (this.getModel().getValue(EXTDATAMODEL) != null) {
            DynamicObject dyo = (DynamicObject)this.getModel().getValue(EXTDATAMODEL);
            pv.getFormShowParameter().setCustomParam("extenddatamodel", (Object)dyo.getLong("id"));
            pv.getFormShowParameter().setCustomParam("area", this.getFormCustomParam("area"));
            FormViewPluginProxy proxy = (FormViewPluginProxy)pv.getService(FormViewPluginProxy.class);
            proxy.getPlugIns().forEach(e -> {
                if (ICommunicateBtwForm.class.isAssignableFrom(e.getClass())) {
                    ((ICommunicateBtwForm)ICommunicateBtwForm.class.cast(e)).communicateMsg();
                }
            });
            this.getView().sendFormAction(pv);
        }
    }
}

