/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.model;

import com.google.common.collect.Sets;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;

public interface IPageCacheProxy {
    public IPageCache getPageCache();

    public static class PageCacheMonitor {
        private Map<String, Integer> monitor = new HashMap<String, Integer>();

        protected void addMonitor(String cachKey, String cacheVal, String methodName) {
            this.monitor.compute(String.format("[%s]-%s", methodName, cachKey), (k, oldVal) -> oldVal == null ? 1 : oldVal + 1);
        }
    }

    public static class PageCacheProxy
    implements InvocationHandler {
        private final IPageCache pageCache;
        private PageCacheMonitor monitor;
        private Map<String, String> bigDataCache;
        private Map<String, String> smallDataCache;
        private boolean isModified4SmallDataCache = false;
        private Set<String> bigDataCacheKeys;
        private static final String BCM_BIGDATA_KEY = "bcm_bigData_Key_";
        private static final String BCM_SMALLDATA_KEY = "bcm_smallData_Key_";
        private static final int threshold = 10000;
        private static Set<String> bosKey = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"ConfirmCallBackListener.", "_Tab_Selected_"}));

        public PageCacheProxy(IPageCache pageCache) {
            this.pageCache = pageCache;
            this.monitor = new PageCacheMonitor();
            this.bigDataCache = new HashMap<String, String>();
            String dataKeys = this.pageCache.get(BCM_BIGDATA_KEY);
            this.bigDataCacheKeys = StringUtils.isEmpty((String)dataKeys) ? new HashSet() : (Set)ObjectSerialUtil.parseObject((String)dataKeys, Set.class);
            String smallDataKeys = this.pageCache.get(BCM_SMALLDATA_KEY);
            this.smallDataCache = StringUtils.isEmpty((String)smallDataKeys) ? new HashMap() : (Map)ObjectSerialUtil.parseObject((String)smallDataKeys, Map.class);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (args == null || args.length == 1 && !(args[0] instanceof String)) {
                return method.invoke((Object)this.pageCache, args);
            }
            Object result = null;
            String val = null;
            String key = (String)args[0];
            if ("put".equals(method.getName())) {
                if (FormShowParameter.class.getSimpleName().equals(key) && args[1] instanceof String) {
                    this.pageCache.put(key, (String)args[1]);
                }
                if (args[1] instanceof String) {
                    val = (String)args[1];
                    if (val.length() >= 10000) {
                        this.bigDataCache.put(key, val);
                        this.bigDataCacheKeys.add(key);
                        if (this.smallDataCache.containsKey(key)) {
                            this.smallDataCache.remove(key);
                            this.isModified4SmallDataCache = true;
                        }
                    } else if (bosKey.stream().anyMatch(key::startsWith) || !this.smallDataCache.containsKey(key) && this.pageCache.get(key) != null) {
                        this.pageCache.put(key, val);
                        this.monitor(args, method.getName());
                    } else {
                        this.smallDataCache.put(key, val);
                        this.isModified4SmallDataCache = true;
                        if (this.bigDataCacheKeys.remove(key)) {
                            this.bigDataCache.remove(key);
                        }
                    }
                } else if (args[1] == null && this.smallDataCache.containsKey(key)) {
                    this.smallDataCache.put(key, null);
                    this.isModified4SmallDataCache = true;
                } else {
                    this.pageCache.put(key, val);
                }
            } else if ("get".equals(method.getName())) {
                String tempValue;
                String value = this.bigDataCache.get(key);
                result = value != null ? value : (this.bigDataCacheKeys.contains(key) ? this.pageCache.getBigObject((String)args[0]) : ((tempValue = this.smallDataCache.get(key)) != null ? tempValue : this.pageCache.get(key)));
            } else if ("remove".equals(method.getName())) {
                if (this.bigDataCache.remove(key) != null || this.bigDataCacheKeys.remove(key)) {
                    this.pageCache.removeBigObject((String)args[0]);
                } else if (!this.smallDataCache.containsKey(key)) {
                    this.pageCache.remove(key);
                    this.monitor(args, method.getName());
                } else {
                    this.smallDataCache.put(key, null);
                    this.isModified4SmallDataCache = true;
                }
            } else {
                result = method.invoke((Object)this.pageCache, args);
            }
            return result;
        }

        private void monitor(Object[] args, String method) {
            this.monitor.addMonitor((String)args[0], args.length > 1 ? (String)args[1] : "", method);
        }

        public void pushCache() {
            this.bigDataCache.entrySet().forEach(e -> {
                this.pageCache.putBigObject((String)e.getKey(), (String)e.getValue());
                this.monitor(new Object[]{e.getKey()}, "putBigObject");
            });
            this.bigDataCache.clear();
            this.pageCache.put(BCM_BIGDATA_KEY, ObjectSerialUtil.toJson(this.bigDataCacheKeys));
            if (this.isModified4SmallDataCache) {
                this.pageCache.put(BCM_SMALLDATA_KEY, ObjectSerialUtil.toJson(this.smallDataCache));
                this.monitor(new Object[]{BCM_SMALLDATA_KEY}, "put");
            }
            this.isModified4SmallDataCache = false;
            this.invokeSaveChanges(this.pageCache, "saveChanges");
        }

        private void invokeSaveChanges(Object obj, String methodName) {
            try {
                Class<?> clazz = obj.getClass();
                for (Method m : clazz.getMethods()) {
                    if (!m.getName().equals(methodName)) continue;
                    m.invoke(obj, new Object[0]);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public IPageCache getProxy() {
            return (IPageCache)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), this.pageCache.getClass().getInterfaces(), (InvocationHandler)this);
        }

        public IPageCache getOriginalPageCache() {
            return this.pageCache;
        }

        public String toJsonMonitor() {
            int invCount = 0;
            Iterator iterator = this.monitor.monitor.values().iterator();
            while (iterator.hasNext()) {
                int c = (Integer)iterator.next();
                invCount += c;
            }
            this.monitor.monitor.put(String.format("[%s]", "count"), invCount);
            return ObjectSerialUtil.toJson((Object)this.monitor.monitor);
        }
    }
}

