/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.multiview;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integration.util.IntergrationUtil;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.EffectCombChecker;
import kd.fi.bcm.common.FormulaMessage;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.enums.invest.InvFormulaLogTypeEnum;
import kd.fi.bcm.common.json.JSONObjectUtil;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.util.TemplateFloatUtil;
import kd.fi.bcm.spread.datacollect.FormulaCheckModel;
import kd.fi.bcm.spread.datacollect.SpecialCalLogic;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.AreaExpr;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.ReferenceExpr;
import kd.fi.bcm.spread.util.DataAndJsonTranslator;
import kd.fi.bcm.spread.util.GZIPUtils;
import org.apache.commons.collections.CollectionUtils;

public class TempFormulaUtil {
    private static JSONObject getDataTable(JSONObject object, String sheetname) {
        return DataAndJsonTranslator.getDataTable((JSONObject)object, (String)sheetname);
    }

    public static String removeFormula(SpreadManager sm, JSONObject object) {
        ArrayList cells = new ArrayList(10);
        sm.getBook().getSheet(0).iteratorCells(cell -> {
            if (cell.hasFormula() && !TempFormulaUtil.checkIsOnlyExcel(cell.getFormula())) {
                cell.setValue(null);
                cells.add(cell);
                cell.setChangeVal(false);
            }
        });
        if (cells.size() > 0) {
            String sheetname = sm.getBook().getSheet(0).getSheetName();
            Object sheetsObj = object.get((Object)"sheets");
            if (sheetsObj == null) {
                return object.toJSONString();
            }
            JSONObject sheets = (JSONObject)sheetsObj;
            Object sheetObj = sheets.get((Object)sheetname);
            if (sheetObj == null) {
                Map.Entry entry;
                Iterator iterator = sheets.entrySet().iterator();
                while (iterator.hasNext() && (sheetObj = (entry = (Map.Entry)iterator.next()).getValue()) == null) {
                }
            }
            Object dataObj = null;
            if (sheetObj != null) {
                JSONObject sheet = (JSONObject)sheetObj;
                dataObj = sheet.get((Object)"data");
            }
            if (dataObj == null) {
                return object.toJSONString();
            }
            JSONObject data = (JSONObject)dataObj;
            Object dataTableObj = data.get((Object)"dataTable");
            if (dataTableObj == null) {
                return object.toJSONString();
            }
            JSONObject dataTable = (JSONObject)dataTableObj;
            for (Cell c : cells) {
                JSONObject cell2;
                Object row = dataTable.get((Object)(c.getRow() + ""));
                if (row == null || (cell2 = (JSONObject)((JSONObject)row).get((Object)(c.getCol() + ""))) == null) continue;
                cell2.remove((Object)"value");
                cell2.remove((Object)"formula");
            }
            return object.toJSONString();
        }
        return object.toJSONString();
    }

    public static String removeAccFormula(SpreadManager sm, String spreadJson) {
        if (spreadJson == null) {
            return null;
        }
        spreadJson = TempFormulaUtil.dealBase64Str(spreadJson);
        String ssjson = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(spreadJson)));
        JSONObject object = JSONObjectUtil.parseObjectOrder((String)ssjson);
        String sb = TempFormulaUtil.removeFormula(sm, object);
        byte[] bb = Base64.getEncoder().encode(GZIPUtils.compress((String)sb));
        String bbs = new String(bb);
        return "base64" + bbs;
    }

    public static String dealSpreadJson(SpreadManager sm, String spreadJson) {
        if (spreadJson == null) {
            return null;
        }
        spreadJson = TempFormulaUtil.dealBase64Str(spreadJson);
        String ssjson = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(spreadJson)));
        JSONObject object = JSONObjectUtil.parseObjectOrder((String)ssjson);
        ArrayList cells = new ArrayList();
        sm.getBook().getSheet(0).iteratorCells(cell -> {
            if (cell.hasFormula() && !TempFormulaUtil.checkIsOnlyExcel(cell.getFormula())) {
                cells.add(cell);
            }
        });
        if (cells.size() > 0) {
            JSONObject sheet;
            Object dataObj;
            String sheetname = sm.getBook().getSheet(0).getSheetName();
            Object sheetsObj = object.get((Object)"sheets");
            if (sheetsObj == null) {
                return object.toJSONString();
            }
            JSONObject sheets = (JSONObject)sheetsObj;
            Object sheetObj = sheets.get((Object)sheetname);
            if (sheetObj == null) {
                Map.Entry entry;
                Iterator iterator = sheets.entrySet().iterator();
                while (iterator.hasNext() && (sheetObj = (entry = (Map.Entry)iterator.next()).getValue()) == null) {
                }
            }
            Object object2 = dataObj = (sheet = (JSONObject)sheetObj) == null ? null : sheet.get((Object)"data");
            if (dataObj == null) {
                return object.toJSONString();
            }
            JSONObject data = (JSONObject)dataObj;
            Object dataTableObj = data.get((Object)"dataTable");
            if (dataTableObj == null) {
                return object.toJSONString();
            }
            JSONObject dataTable = (JSONObject)dataTableObj;
            for (Cell c : cells) {
                JSONObject cell2;
                Object row = dataTable.get((Object)(c.getRow() + ""));
                if (row == null || (cell2 = (JSONObject)((JSONObject)row).get((Object)(c.getCol() + ""))) == null) continue;
                cell2.remove((Object)"formula");
            }
        }
        byte[] bb = Base64.getEncoder().encode(GZIPUtils.compress((String)object.toJSONString()));
        String bbs = new String(bb);
        return "base64" + bbs;
    }

    public static String dealBase64Str(String spreadJson) {
        return DataAndJsonTranslator.dealBase64Str((String)spreadJson);
    }

    public static Map<String, String> dealSpreadManagerAndSpreadJson(Table table, SpreadManager sm, String json) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        ArrayList<Cell> cells = new ArrayList<Cell>(table.size());
        Map resultRowMap = table.rowMap();
        for (Map.Entry resultRow : resultRowMap.entrySet()) {
            Map resultCVs = (Map)resultRowMap.get(resultRow.getKey());
            for (Map.Entry entry : resultCVs.entrySet()) {
                Cell cell = sm.getBook().getSheet(0).getCell(((Integer)resultRow.getKey()).intValue(), ((Integer)entry.getKey()).intValue());
                boolean isExcel = false;
                if (cell.hasFormula() && TempFormulaUtil.checkIsOnlyExcel(cell.getFormula()) || TempFormulaUtil.checkIsOnlyExcel(entry.getValue().toString())) {
                    isExcel = true;
                }
                cell.setFormula(entry.getValue().toString().equals("") ? null : entry.getValue().toString());
                if (!isExcel) continue;
                cells.add(cell);
            }
        }
        json = TempFormulaUtil.dealBase64Str(json);
        String ssjson = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(json)));
        JSONObject obj = JSONObjectUtil.parseObjectOrder((String)ssjson);
        String sheetname = sm.getBook().getSheet(0).getSheetName();
        JSONObject dataTable = TempFormulaUtil.getDataTable(obj, sheetname);
        for (Cell c : cells) {
            JSONObject cell = (JSONObject)((JSONObject)dataTable.get((Object)(c.getRow() + ""))).get((Object)(c.getCol() + ""));
            if (cell == null) {
                JSONObject rowObject = (JSONObject)dataTable.get((Object)(c.getRow() + ""));
                if (rowObject == null) {
                    rowObject = new JSONObject();
                    dataTable.put(c.getRow() + "", (Object)rowObject);
                }
                if ((cell = (JSONObject)rowObject.get((Object)(c.getCol() + ""))) == null) {
                    cell = new JSONObject();
                    rowObject.put(c.getCol() + "", (Object)cell);
                }
            }
            cell.put("formula", ((Map)resultRowMap.get(c.getRow())).get(c.getCol()));
            if (((Map)resultRowMap.get(c.getRow())).get(c.getCol()).equals("")) {
                cell.remove((Object)"formula");
            }
            cell.put("value", null);
        }
        String string = TempFormulaUtil.removeAccFormula(sm, obj);
        map.put("spreadjson", string);
        map.put("data", JsonSerializerUtil.toJson((SpreadManager)sm));
        return map;
    }

    public static String dealSpreadJson(List<Cell> cells, String sheetname, String json) {
        return SpecialCalLogic.dealSpreadJson(cells, (String)sheetname, (String)json);
    }

    public static Table collectFormulas(TemplateModel templateModel, SpreadManager spm, long orgId) {
        Map formulas = IntergrationUtil.getAcctByOrg((long)templateModel.getId(), (long)templateModel.getModelId(), (long)orgId);
        if (formulas.size() == 0) {
            return null;
        }
        HashBasedTable resultCells = HashBasedTable.create();
        StringBuilder dimKey = new StringBuilder();
        StringBuilder membKey = new StringBuilder();
        spm.getBook().getSheet(0).iteratorCells(arg_0 -> TempFormulaUtil.lambda$collectFormulas$3(dimKey, membKey, formulas, spm, (Table)resultCells, arg_0));
        return resultCells;
    }

    public static String removeAccFormula(SpreadManager sm, JSONObject object) {
        if (object == null) {
            return null;
        }
        String sb = TempFormulaUtil.removeFormula(sm, object);
        byte[] bb = Base64.getEncoder().encode(GZIPUtils.compress((String)sb));
        String bbs = new String(bb);
        return "base64" + bbs;
    }

    @Deprecated
    public static boolean checkFormulaExits(String formula) {
        return new FormulaCheckModel().isPass(formula);
    }

    @Deprecated
    public static boolean checkIsOnlyExcel(String formula) {
        return new FormulaCheckModel().isOnlyExcel(formula);
    }

    public static boolean isCycleRefrenceCal(String formula, String str) throws Exception {
        AtomicBoolean flag = new AtomicBoolean(false);
        Point point = ExcelUtils.pos2Point((String)str);
        Expression parse = ExcelFormulaPaserHelper.parse((String)formula);
        ExcelFormulaPaserHelper.walk((Expression)parse, expr -> {
            ReferenceExpr referenceExpr;
            if (expr instanceof AreaExpr) {
                AreaExpr areaExpr = (AreaExpr)expr;
                if (new RangeModel(str).checkIsInArea(new RangeModel(areaExpr.getStart_col(), areaExpr.getEnd_col(), areaExpr.getStart_row(), areaExpr.getEnd_row()))) {
                    flag.set(true);
                    return false;
                }
            } else if (expr instanceof ReferenceExpr && point.y == (referenceExpr = (ReferenceExpr)expr).getRow() && point.x == referenceExpr.getCol()) {
                flag.set(true);
                return false;
            }
            return true;
        });
        return flag.get();
    }

    public static void markColor(long modelId, SpreadManager spreadModel, IClientViewProxy clientViewProxy, String spreadKey, long templateId, String orgNumber) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("template", "=", (Object)templateId);
        if (" ".equals(orgNumber)) {
            qFilter.and("orgnumber", "!=", (Object)orgNumber);
        } else {
            qFilter.and("orgnumber", "=", (Object)orgNumber);
        }
        DynamicObjectCollection cellformulas = QueryServiceHelper.query((String)"bcm_cellformula", (String)"cell", (QFilter[])qFilter.toArray());
        HashSet<Integer> cellIds = new HashSet<Integer>(16);
        for (DynamicObject cell2 : cellformulas) {
            cellIds.add(cell2.getInt("cell"));
        }
        SpreadEasyInvoker.setCellStyleMethod(spreadModel, clientViewProxy, spreadKey, MapInitHelper.ofMap((Object)SpreadProperties.SetCellStyleMethod.BACKCOLOR.k(), (Object)"#FFA500"), false, cell -> cellIds.contains(cell.getCellId()));
    }

    public static void setStyle(SpreadManager spreadModel, IClientViewProxy clientViewProxy, String spreadKey) {
        SpreadEasyInvoker.setCellStyleMethod(spreadModel, clientViewProxy, spreadKey, MapInitHelper.ofMap((Object)SpreadProperties.SetCellStyleMethod.HORIZONTALALIGN.k(), (Object)0), false, cell -> cell.hasFormula());
    }

    public static void markErrorColor(long modelId, SpreadManager spreadModel, IClientViewProxy clientViewProxy, String spreadKey, long templateId, long orgId, long peroidId, long yearId, long scenarioId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("template", "=", (Object)templateId);
        qFilter.and("org", "=", (Object)orgId);
        qFilter.and("period", "=", (Object)peroidId);
        qFilter.and("fy", "=", (Object)yearId);
        qFilter.and("scenario", "=", (Object)scenarioId);
        Boolean isExist = QueryServiceHelper.exists((String)"bcm_datacollect", (QFilter[])qFilter.toArray());
        if (isExist.booleanValue()) {
            qFilter.and("logtype", "=", (Object)InvFormulaLogTypeEnum.ReoprtFormulaLog.getLogType());
            DynamicObjectCollection cellformulas = QueryServiceHelper.query((String)"bcm_datacollectlog", (String)"datafrom,cellid", (QFilter[])qFilter.toArray());
            HashSet<Integer> cellIds = new HashSet<Integer>(16);
            for (DynamicObject dataformula : cellformulas) {
                int cellId = dataformula.getInt("cellid");
                if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dataformula.getString("datafrom"))) continue;
                cellIds.add(cellId);
            }
            Predicate<Cell> predicate = null;
            if (!cellIds.isEmpty()) {
                predicate = cell -> cell.hasFormula() && cellIds.contains(cell.getCellId());
            } else {
                QFilter qf = new QFilter("model", "=", (Object)modelId);
                qf.and("org", "=", (Object)orgId);
                qf.and(new QFilter("template", "=", (Object)0).or("template", "=", (Object)templateId));
                qf.and("datafrom", "=", (Object)" ");
                qf.and("logtype", "=", (Object)"0");
                DynamicObjectCollection cellErrors = QueryServiceHelper.query((String)"bcm_datacollectlog", (String)"error", (QFilter[])qf.toArray());
                if (CollectionUtils.isNotEmpty((Collection)cellErrors)) {
                    predicate = cell -> cell.hasFormula();
                }
            }
            if (predicate != null) {
                SpreadEasyInvoker.setCellStyleMethod(spreadModel, clientViewProxy, spreadKey, MapInitHelper.ofMap((Object)SpreadProperties.SetCellStyleMethod.HORIZONTALALIGN.k(), (Object)0, (Object)SpreadProperties.SetCellStyleMethod.BACKCOLOR.k(), (Object)"#FFD700"), false, predicate);
            }
        } else {
            TempFormulaUtil.setStyle(spreadModel, clientViewProxy, spreadKey);
        }
    }

    public static String checkDimCombinationForFormula(String dimNumber, String number, long modelId) {
        String key = "checkDimCombinationForFormula_" + dimNumber + '#' + number + '#' + modelId;
        if (ThreadCache.exists((Object)key)) {
            return "fi-bcm-formplugin".equals(ThreadCache.get((Object)key)) ? null : ThreadCache.get((Object)key).toString();
        }
        String tips = TempFormulaUtil.checkDimCombination(dimNumber, number, modelId);
        ThreadCache.put((Object)key, (Object)tips);
        return "fi-bcm-formplugin".equals(tips) ? null : tips;
    }

    private static String checkDimCombination(String dimNumber, String number, long modelId) {
        if (Arrays.asList(SystemVarsEnum.values()).stream().anyMatch(e -> e.getNumber().equals(number))) {
            return "fi-bcm-formplugin";
        }
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        EffectCombChecker effectCombChecker = new EffectCombChecker(modelId);
        List<String> bpInputNums = Arrays.asList("CSTE", "IRpt", "EIRpt");
        Set atInputNums = new HashSet(16);
        String entityname = DimEntityNumEnum.getEntieyNumByNumber((String)dimNumber);
        if ("bcm_audittrialmembertree".equals(entityname)) {
            atInputNums = effectCombChecker.getAtInputNums();
        }
        if ("bcm_processmembertree".equals(entityname) && !bpInputNums.contains(number)) {
            return FormulaMessage.getProcessMseeage();
        }
        if ("bcm_audittrialmembertree".equals(entityname) && !atInputNums.contains(number)) {
            return FormulaMessage.getAuditTrailMseeage();
        }
        IDNumberTreeNode node = BcmThreadCache.findMemberByNum((String)modelNumber, (String)dimNumber, (String)number);
        if (node != IDNumberTreeNode.NotFoundTreeNode) {
            if (ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM043") && node.getStorageType() == StorageTypeEnum.DYNAMIC) {
                return "fi-bcm-formplugin";
            }
            if (node.getStorageType() == StorageTypeEnum.LABEL || node.getStorageType() == StorageTypeEnum.DYNAMIC) {
                return FormulaMessage.getDetailMseeage();
            }
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u3010%1s\u3011\u4e2d\u7684\u7ef4\u5ea6\u6210\u5458\u3010\u7f16\u7801\u4e3a: %2s\u3011\u4e0d\u5b58\u5728\u3002", (String)"TempFormulaUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimNumber, number));
        }
        return "fi-bcm-formplugin";
    }

    private static /* synthetic */ void lambda$collectFormulas$3(StringBuilder dimKey, StringBuilder membKey, Map formulas, SpreadManager spm, Table resultCells, Cell cell) {
        if (cell.getMemberFromUserObject() != null) {
            dimKey.setLength(0);
            membKey.setLength(0);
            cell.getMemberFromUserObject().forEach(m -> {
                membKey.append(m.getNumber()).append("|");
                dimKey.append(m.getDimension().getNumber()).append("|");
            });
            String key = dimKey + "&" + membKey;
            String str = (String)formulas.get(key);
            if (str == null) {
                String floatFKey = TemplateFloatUtil.setSpreadCellFormuala(cell, spm);
                str = (String)formulas.get(floatFKey);
            }
            int row = cell.getRow();
            int col = cell.getCol();
            Cell cel = spm.getBook().getSheet(0).getCell(row, col);
            if (str != null) {
                String formula = StringUtils.isEmpty((String)str) ? str : str.substring(1);
                cel.setFormula(formula);
                resultCells.put((Object)row, (Object)col, (Object)formula);
            }
        } else {
            String floatFKey = TemplateFloatUtil.setSpreadCellFormuala(cell, spm);
            String str = (String)formulas.get(floatFKey);
            if (str != null) {
                String formula = StringUtils.isEmpty((String)str) ? str : str.substring(1);
                int row = cell.getRow();
                int col = cell.getCol();
                Cell cel = spm.getBook().getSheet(0).getCell(row, col);
                cel.setFormula(formula);
                resultCells.put((Object)row, (Object)col, (Object)formula);
            }
        }
    }
}

