/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.template.multiview;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IPageCache;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.convert.query.BaseConvertFormula;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.formplugin.template.model.ISpreadModelSupplier;
import kd.fi.bcm.formplugin.util.CvtFormulaUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.util.DynamicUtils;

public class TemplateCvtFormulaViewPlugin
extends AbstractTemplateBasePlugin
implements ISpreadModelSupplier {
    private String convert2scenarioid = null;
    private String convert2scenarionumber = null;

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.convert2scenarioid = (String)this.getFormCustomParam("convert2scenarioid");
        this.convert2scenarionumber = (String)this.getFormCustomParam("convert2scenarionumber");
        this.display();
    }

    private void display() {
        SpreadManager spreadModel = this.getSpreadModel();
        String json = (String)this.getView().getFormShowParameter().getCustomParam("json");
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), "template_spread", json);
        SpreadClientInvoker.invokeLockOrUnlockWholeToolbar(this.getClientViewProxy(), "template_spread", true);
        SpreadClientInvoker.invokeCloseToolBar(this.getClientViewProxy(), "template_spread");
        boolean isDynaTemplate = DynamicUtils.isDynamicReport((SpreadManager)spreadModel);
        Sheet sheet = this.getEffectiveSheet();
        int maxRow = isDynaTemplate ? Math.min(100, sheet.getMaxRowCount()) : sheet.getMaxRowCount();
        ArrayList cells = new ArrayList();
        HashMap<String, Integer> cell = new HashMap<String, Integer>();
        cell.put(SpreadProperties.LockCellMethod.R.k(), 0);
        cell.put(SpreadProperties.LockCellMethod.C.k(), 0);
        cell.put(SpreadProperties.LockCellMethod.RC.k(), maxRow);
        cell.put(SpreadProperties.LockCellMethod.CC.k(), sheet.getMaxColumnCount());
        cells.add(cell);
        SpreadClientInvoker.invokeLockCellMethod(this.getClientViewProxy(), "template_spread", cells);
        boolean canDisplay = this.checkCanDisplay();
        if (canDisplay) {
            this.drawEditFormulaColor();
            this.displayFormulaInfo();
        }
    }

    private boolean checkCanDisplay() {
        if (this.convert2scenarioid == null) {
            return false;
        }
        TemplateModel template = this.getTemplateModel();
        for (PageDimensionEntry dim : template.getPageDimensionEntries()) {
            if (!dim.getDimension().getNumber().equals("Account") && !dim.getDimension().getNumber().equals("ChangeType")) continue;
            if (dim.getMembers().size() > 1) {
                return false;
            }
            if (((Member)dim.getMembers().get(0)).getScope() == RangeEnum.VALUE_10.getValue()) continue;
            return false;
        }
        return true;
    }

    private void drawEditFormulaColor() {
        String suffix = this.convert2scenarionumber + "_";
        SpreadManager sm = this.getSpreadModel();
        Sheet sheet = sm.getBook().getSheet(0);
        ArrayList rangeList = new ArrayList();
        sm.getAreaManager().forEach(area -> {
            String[] areaRange = ((PositionInfo)area.getKey()).getAreaRange().split(":");
            int[] startXY = ExcelUtils.pos2XY((String)areaRange[0]);
            int[] endXY = ExcelUtils.pos2XY((String)areaRange[1]);
            sheet.iteratorRangeCells(startXY[1], endXY[1], startXY[0], endXY[0], cell -> {
                if (((Boolean)cell.getUserObject(suffix + "defined_formula", (Object)false)).booleanValue()) {
                    int[] xy = new int[]{cell.getCol(), cell.getRow()};
                    rangeList.add(this.constructRangeFeature(xy, xy, true));
                    rangeList.add(this.constructRangeFeature(xy, xy, false));
                }
            });
        });
        if (!rangeList.isEmpty()) {
            HashMap<String, Cloneable> features = new HashMap<String, Cloneable>();
            HashMap<String, String> styleMap = new HashMap<String, String>();
            styleMap.put(SpreadProperties.SetCellStyleMethod.BACKCOLOR.k(), "#AAD4FF");
            features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
            features.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), styleMap);
            SpreadClientInvoker.invokeSetCellStyleMethod(this.getClientViewProxy(), "template_spread", Lists.newArrayList((Object[])new Map[]{features}));
        }
    }

    private Map<String, Object> constructRangeFeature(int[] startXY, int[] endXY, boolean isDrawRow) {
        HashMap<String, Object> rangeMap = new HashMap<String, Object>();
        rangeMap.put(SpreadProperties.SetCellStyleMethod.R.k(), startXY[1]);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.C.k(), startXY[0]);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.RC.k(), isDrawRow ? 1 : endXY[1] - startXY[1] + 1);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.CC.k(), isDrawRow ? endXY[0] - startXY[0] + 1 : 1);
        return rangeMap;
    }

    private void displayFormulaInfo() {
        String suffix = this.convert2scenarionumber + "_";
        TemplateModel template = this.getTemplateModel();
        IPageCache pageCache = this.getPageCache();
        pageCache.put("convert2scenarioid", this.convert2scenarioid);
        Map<String, Map<String, Map<String, Object>>> dimInfo = CvtFormulaUtil.getDimInfo(template, pageCache);
        Pair<String, String> dimValue = CvtFormulaUtil.getAccountAndCTNumber(template);
        BaseConvertFormula baseFormula = CvtFormulaUtil.getBaseCvtFormula(template, pageCache);
        SpreadManager sm = this.getSpreadModel();
        Sheet sheet = sm.getBook().getSheet(0);
        ArrayList cellValues = new ArrayList();
        ArrayList formulas = new ArrayList();
        Recorder hasFormula = new Recorder((Object)false);
        sm.getAreaManager().forEach(area -> {
            String[] areaRange = ((PositionInfo)area.getKey()).getAreaRange().split(":");
            int[] startXY = ExcelUtils.pos2XY((String)areaRange[0]);
            int[] endXY = ExcelUtils.pos2XY((String)areaRange[1]);
            sheet.iteratorRangeCells(startXY[1], endXY[1], startXY[0], endXY[0], cell -> {
                Object formula;
                if (cell.isMdDataDomain()) {
                    if (!((Boolean)cell.getUserObject(suffix + "no_formula", (Object)false)).booleanValue()) {
                        if (((Boolean)cell.getUserObject(suffix + "defined_formula", (Object)false)).booleanValue()) {
                            cellValues.add(this.packedUpdateCellMap(cell.getRow(), cell.getCol(), cell.getUserObject(suffix + "formula_name", (Object)ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6298\u7b97\u516c\u5f0f\u3002", (String)"TemplateCvtFormulaViewPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]))));
                            cell.setUserObject(suffix + "no_formula", (Object)false);
                        } else {
                            formula = CvtFormulaUtil.displayFormula(cell, dimInfo, dimValue, baseFormula, template);
                            if (formula != null) {
                                cellValues.add(this.packedUpdateCellMap(cell.getRow(), cell.getCol(), formula));
                                cell.setUserObject(suffix + "no_formula", (Object)false);
                            } else {
                                cell.getUserObject().remove((Object)(suffix + "no_formula"));
                            }
                        }
                    } else {
                        this.clearCellValue((Cell)cell, cellValues);
                    }
                } else if (!((Boolean)cell.getUserObject(suffix + "no_formula", (Object)false)).booleanValue()) {
                    if (((Boolean)cell.getUserObject(suffix + "defined_formula", (Object)false)).booleanValue()) {
                        cellValues.add(this.packedUpdateCellMap(cell.getRow(), cell.getCol(), cell.getUserObject(suffix + "formula_name", (Object)ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6298\u7b97\u516c\u5f0f\u3002", (String)"TemplateCvtFormulaViewPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]))));
                        cell.setUserObject(suffix + "no_formula", (Object)false);
                    } else if (this.checkCellAtCanDisplayFloatArea((Cell)cell, (PositionInfo)area.getKey(), dimInfo)) {
                        formula = CvtFormulaUtil.displayFormula4Float(cell, dimInfo, dimValue, baseFormula, (PositionInfo)area.getKey(), template, this.getEffectiveSheet());
                        if (formula != null) {
                            cellValues.add(this.packedUpdateCellMap(cell.getRow(), cell.getCol(), formula));
                            cell.setUserObject(suffix + "no_formula", (Object)false);
                        } else {
                            cell.getUserObject().remove((Object)(suffix + "no_formula"));
                        }
                    } else {
                        this.clearCellValue((Cell)cell, cellValues);
                    }
                } else {
                    this.clearCellValue((Cell)cell, cellValues);
                }
                if (StringUtils.isNotEmpty((String)cell.getFormula())) {
                    formula = new HashMap<String, Integer>(3);
                    formula.put(SpreadProperties.SetFormulaMethod.R.k(), cell.getRow());
                    formula.put(SpreadProperties.SetFormulaMethod.C.k(), cell.getCol());
                    formula.put(SpreadProperties.SetFormulaMethod.F.k(), null);
                    formulas.add(formula);
                    hasFormula.setRecord((Object)true);
                }
            });
        });
        if (!formulas.isEmpty()) {
            SpreadClientInvoker.invokeSetFormulaMethod(this.getClientViewProxy(), "template_spread", formulas);
        }
        if (!cellValues.isEmpty()) {
            SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), "template_spread", cellValues);
        }
        if (((Boolean)hasFormula.getRecord()).booleanValue()) {
            this.cacheSpreadModel();
        }
    }

    private void clearCellValue(Cell cell, List<Map<String, Object>> cellValues) {
        if (cell.getVariant() != null && !cell.getVariant().isEmpty()) {
            cellValues.add(this.packedUpdateCellMap(cell.getRow(), cell.getCol(), null));
        }
    }

    private boolean checkCellAtCanDisplayFloatArea(Cell cell, PositionInfo psInfo, Map<String, Map<String, Map<String, Object>>> dimInfo) {
        String start = psInfo.getAreaRange().split(":")[0];
        int[] startXY = ExcelUtils.pos2XY((String)start);
        for (BasePointInfo bp : psInfo.getBasePoints()) {
            String[] dynaRange = bp.getDynaRange().split(":");
            int[] fromXY = ExcelUtils.pos2XY((String)dynaRange[0]);
            boolean isFirst = false;
            if (bp.isDirectHoriz()) {
                if (cell.getCol() == fromXY[0]) {
                    isFirst = true;
                }
            } else if (cell.getRow() == fromXY[1]) {
                isFirst = true;
            }
            if (!isFirst) continue;
            List lines = bp.getBasePointInnerLineInfo();
            for (BasePointInnerLineInfo info : lines) {
                String dimNum;
                IDimMember member;
                if (!(!info.isFloated() ? !CvtFormulaUtil.checkIsLeaf(member = ((DynaMembScopeInfo)info.getDynaMembScopes().get(0)).getMember(), dimInfo) : (dimNum = info.getDimension().getNumber()).equals(DimTypesEnum.ACCOUNT.getNumber()) || dimNum.equals(DimTypesEnum.CHANGETYPE.getNumber()))) continue;
                return false;
            }
            List members = bp.isDirectHoriz() ? this.getEffectiveSheet().getCell(cell.getRow(), startXY[0]).getMemberFromUserObject() : this.getEffectiveSheet().getCell(startXY[1], cell.getCol()).getMemberFromUserObject();
            if (members == null || members.isEmpty()) {
                return false;
            }
            if (!CvtFormulaUtil.checkAllIsLeaf(members, dimInfo)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void showFormulaPanel(int row, int col) {
    }

    @Override
    public void spreadF7Click(int r, int c) {
    }

    @Override
    public void spreadF7LookUpData(LookUpDataArgs args) {
    }
}

